#include <Python.h>
#include <numpy/ndarrayobject.h>

void
smoothness009 (const double *restrict f, int n, int fsi, double *restrict sigma, int ssi, int ssr)
{
  int i;
  double sigma0, sigma1, sigma2, sigma3, sigma4, sigma5, sigma6, sigma7, sigma8;
  for (i = 9; i < n - 9; i++)
    {
      sigma0 =
	+669.714981108808 * f[(i + 0) * fsi] * f[(i + 0) * fsi] -
	8893.78045641284 * f[(i + 0) * fsi] * f[(i + 1) * fsi] +
	26542.9748247279 * f[(i + 0) * fsi] * f[(i + 2) * fsi] -
	46202.7564018809 * f[(i + 0) * fsi] * f[(i + 3) * fsi] +
	51067.48172473 * f[(i + 0) * fsi] * f[(i + 4) * fsi] -
	36585.0576509742 * f[(i + 0) * fsi] * f[(i + 5) * fsi] +
	16552.0014823105 * f[(i + 0) * fsi] * f[(i + 6) * fsi] -
	4316.36463814691 * f[(i + 0) * fsi] * f[(i + 7) * fsi] +
	496.071153428775 * f[(i + 0) * fsi] * f[(i + 8) * fsi] +
	29991.6199268498 * f[(i + 1) * fsi] * f[(i + 1) * fsi] -
	180813.861301392 * f[(i + 1) * fsi] * f[(i + 2) * fsi] +
	316864.946394454 * f[(i + 1) * fsi] * f[(i + 3) * fsi] -
	351925.412140196 * f[(i + 1) * fsi] * f[(i + 4) * fsi] +
	253037.274363286 * f[(i + 1) * fsi] * f[(i + 5) * fsi] -
	114802.39231254 * f[(i + 1) * fsi] * f[(i + 6) * fsi] +
	30004.6106074921 * f[(i + 1) * fsi] * f[(i + 7) * fsi] -
	3454.6250083913 * f[(i + 1) * fsi] * f[(i + 8) * fsi] +
	274437.463974042 * f[(i + 2) * fsi] * f[(i + 2) * fsi] -
	966727.207640071 * f[(i + 2) * fsi] * f[(i + 3) * fsi] +
	1077735.75959481 * f[(i + 2) * fsi] * f[(i + 4) * fsi] -
	777141.668605927 * f[(i + 2) * fsi] * f[(i + 5) * fsi] +
	353390.255601705 * f[(i + 2) * fsi] * f[(i + 6) * fsi] -
	92530.8427411113 * f[(i + 2) * fsi] * f[(i + 7) * fsi] +
	10669.6623191712 * f[(i + 2) * fsi] * f[(i + 8) * fsi] +
	854591.512480352 * f[(i + 3) * fsi] * f[(i + 3) * fsi] -
	1911046.21916467 * f[(i + 3) * fsi] * f[(i + 4) * fsi] +
	1381212.31577771 * f[(i + 3) * fsi] * f[(i + 5) * fsi] -
	629240.182223211 * f[(i + 3) * fsi] * f[(i + 6) * fsi] +
	165006.507929424 * f[(i + 3) * fsi] * f[(i + 7) * fsi] -
	19050.4296324557 * f[(i + 3) * fsi] * f[(i + 8) * fsi] +
	1070854.47449811 * f[(i + 4) * fsi] * f[(i + 4) * fsi] -
	1550800.19015232 * f[(i + 4) * fsi] * f[(i + 5) * fsi] +
	707565.248792344 * f[(i + 4) * fsi] * f[(i + 6) * fsi] -
	185776.153674587 * f[(i + 4) * fsi] * f[(i + 7) * fsi] +
	21470.5360236718 * f[(i + 4) * fsi] * f[(i + 8) * fsi] +
	562311.328233438 * f[(i + 5) * fsi] * f[(i + 5) * fsi] -
	513755.446640071 * f[(i + 5) * fsi] * f[(i + 6) * fsi] +
	135029.257900627 * f[(i + 5) * fsi] * f[(i + 7) * fsi] -
	15619.1414592001 * f[(i + 5) * fsi] * f[(i + 8) * fsi] +
	117469.122961696 * f[(i + 6) * fsi] * f[(i + 6) * fsi] -
	61801.7019274941 * f[(i + 6) * fsi] * f[(i + 7) * fsi] +
	7153.9713035639 * f[(i + 6) * fsi] * f[(i + 8) * fsi] +
	8134.55939472587 * f[(i + 7) * fsi] * f[(i + 7) * fsi] -
	1884.43224565446 * f[(i + 7) * fsi] * f[(i + 8) * fsi] +
	109.193772932945 * f[(i + 8) * fsi] * f[(i + 8) * fsi];
      sigma1 =
	+109.193772932945 * f[(i - 1) * fsi] * f[(i - 1) * fsi] -
	1469.41675936423 * f[(i - 1) * fsi] * f[(i + 0) * fsi] +
	4407.32664278072 * f[(i - 1) * fsi] * f[(i + 1) * fsi] -
	7674.89153356352 * f[(i - 1) * fsi] * f[(i + 2) * fsi] +
	8466.40114664635 * f[(i - 1) * fsi] * f[(i + 3) * fsi] -
	6046.29475543025 * f[(i - 1) * fsi] * f[(i + 4) * fsi] +
	2725.41239353462 * f[(i - 1) * fsi] * f[(i + 5) * fsi] -
	707.980347608125 * f[(i - 1) * fsi] * f[(i + 6) * fsi] +
	81.0556671385418 * f[(i - 1) * fsi] * f[(i + 7) * fsi] +
	5049.77020781835 * f[(i + 0) * fsi] * f[(i + 0) * fsi] -
	30701.1587180034 * f[(i + 0) * fsi] * f[(i + 1) * fsi] +
	53947.0217387824 * f[(i + 0) * fsi] * f[(i + 2) * fsi] -
	59895.4013896723 * f[(i + 0) * fsi] * f[(i + 3) * fsi] +
	42979.1691915766 * f[(i + 0) * fsi] * f[(i + 4) * fsi] -
	19443.7923047687 * f[(i + 0) * fsi] * f[(i + 5) * fsi] +
	5065.26308734773 * f[(i + 0) * fsi] * f[(i + 6) * fsi] -
	581.225261534807 * f[(i + 0) * fsi] * f[(i + 7) * fsi] +
	47140.2493458593 * f[(i + 1) * fsi] * f[(i + 1) * fsi] -
	166921.455804809 * f[(i + 1) * fsi] * f[(i + 2) * fsi] +
	186372.636616418 * f[(i + 1) * fsi] * f[(i + 3) * fsi] -
	134309.272278381 * f[(i + 1) * fsi] * f[(i + 4) * fsi] +
	60963.6198256632 * f[(i + 1) * fsi] * f[(i + 5) * fsi] -
	15923.1845243454 * f[(i + 1) * fsi] * f[(i + 6) * fsi] +
	1830.9895489579 * f[(i + 1) * fsi] * f[(i + 7) * fsi] +
	148657.090978519 * f[(i + 2) * fsi] * f[(i + 2) * fsi] -
	333527.451742794 * f[(i + 2) * fsi] * f[(i + 3) * fsi] +
	241247.066835384 * f[(i + 2) * fsi] * f[(i + 4) * fsi] -
	109824.674852455 * f[(i + 2) * fsi] * f[(i + 5) * fsi] +
	28752.7613106242 * f[(i + 2) * fsi] * f[(i + 6) * fsi] -
	3312.55790820803 * f[(i + 2) * fsi] * f[(i + 7) * fsi] +
	187797.717874362 * f[(i + 3) * fsi] * f[(i + 3) * fsi] -
	272525.224659461 * f[(i + 3) * fsi] * f[(i + 4) * fsi] +
	124378.188236788 * f[(i + 3) * fsi] * f[(i + 5) * fsi] -
	32630.2392534289 * f[(i + 3) * fsi] * f[(i + 6) * fsi] +
	3765.65529677863 * f[(i + 3) * fsi] * f[(i + 7) * fsi] +
	99127.2745988898 * f[(i + 4) * fsi] * f[(i + 4) * fsi] -
	90677.1257492533 * f[(i + 4) * fsi] * f[(i + 5) * fsi] +
	23831.4757387824 * f[(i + 4) * fsi] * f[(i + 6) * fsi] -
	2754.34352099738 * f[(i + 4) * fsi] * f[(i + 7) * fsi] +
	20774.7074754889 * f[(i + 5) * fsi] * f[(i + 5) * fsi] -
	10936.7033079505 * f[(i + 5) * fsi] * f[(i + 6) * fsi] +
	1265.66080746326 * f[(i + 5) * fsi] * f[(i + 7) * fsi] +
	1441.28575449258 * f[(i + 6) * fsi] * f[(i + 6) * fsi] -
	333.964212406558 * f[(i + 6) * fsi] * f[(i + 7) * fsi] +
	19.3647914042221 * f[(i + 7) * fsi] * f[(i + 7) * fsi];
      sigma2 =
	+19.3647914042221 * f[(i - 2) * fsi] * f[(i - 2) * fsi] -
	267.510578137456 * f[(i - 2) * fsi] * f[(i - 1) * fsi] +
	813.039719569186 * f[(i - 2) * fsi] * f[(i + 0) * fsi] -
	1422.29540695141 * f[(i - 2) * fsi] * f[(i + 1) * fsi] +
	1567.36952565594 * f[(i - 2) * fsi] * f[(i + 2) * fsi] -
	1114.27213708535 * f[(i - 2) * fsi] * f[(i + 3) * fsi] +
	498.941434911939 * f[(i - 2) * fsi] * f[(i + 4) * fsi] -
	128.604173640737 * f[(i - 2) * fsi] * f[(i + 5) * fsi] +
	14.6020328694406 * f[(i - 2) * fsi] * f[(i + 6) * fsi] +
	948.240872428061 * f[(i - 1) * fsi] * f[(i - 1) * fsi] -
	5868.7702184994 * f[(i - 1) * fsi] * f[(i + 0) * fsi] +
	10399.3092657059 * f[(i - 1) * fsi] * f[(i + 1) * fsi] -
	11568.2032050107 * f[(i - 1) * fsi] * f[(i + 2) * fsi] +
	8281.83632095821 * f[(i - 1) * fsi] * f[(i + 3) * fsi] -
	3728.0916300002 * f[(i - 1) * fsi] * f[(i + 4) * fsi] +
	964.845939313753 * f[(i - 1) * fsi] * f[(i + 5) * fsi] -
	109.897639186214 * f[(i - 1) * fsi] * f[(i + 6) * fsi] +
	9222.43045243719 * f[(i + 0) * fsi] * f[(i + 0) * fsi] -
	33080.8713993305 * f[(i + 0) * fsi] * f[(i + 1) * fsi] +
	37137.9417090107 * f[(i + 0) * fsi] * f[(i + 2) * fsi] -
	26774.8153713592 * f[(i + 0) * fsi] * f[(i + 3) * fsi] +
	12118.1388794826 * f[(i + 0) * fsi] * f[(i + 4) * fsi] -
	3149.43314058221 * f[(i + 0) * fsi] * f[(i + 5) * fsi] +
	359.908916834338 * f[(i + 0) * fsi] * f[(i + 6) * fsi] +
	29975.0953815866 * f[(i + 1) * fsi] * f[(i + 1) * fsi] -
	67875.8127912121 * f[(i + 1) * fsi] * f[(i + 2) * fsi] +
	49266.8129628913 * f[(i + 1) * fsi] * f[(i + 3) * fsi] -
	22417.2306985197 * f[(i + 1) * fsi] * f[(i + 4) * fsi] +
	5850.74664900054 * f[(i + 1) * fsi] * f[(i + 5) * fsi] -
	670.849344757305 * f[(i + 1) * fsi] * f[(i + 6) * fsi] +
	38710.2228777378 * f[(i + 2) * fsi] * f[(i + 2) * fsi] -
	56543.4445813355 * f[(i + 2) * fsi] * f[(i + 3) * fsi] +
	25858.8233448132 * f[(i + 2) * fsi] * f[(i + 4) * fsi] -
	6776.71603569857 * f[(i + 2) * fsi] * f[(i + 5) * fsi] +
	779.596278301446 * f[(i + 2) * fsi] * f[(i + 6) * fsi] +
	20760.5788136853 * f[(i + 3) * fsi] * f[(i + 3) * fsi] -
	19076.8005289601 * f[(i + 3) * fsi] * f[(i + 4) * fsi] +
	5018.72343149075 * f[(i + 3) * fsi] * f[(i + 5) * fsi] -
	579.197723970813 * f[(i + 3) * fsi] * f[(i + 6) * fsi] +
	4400.38698330138 * f[(i + 4) * fsi] * f[(i + 4) * fsi] -
	2323.5095791696 * f[(i + 4) * fsi] * f[(i + 5) * fsi] +
	268.954810839028 * f[(i + 4) * fsi] * f[(i + 6) * fsi] +
	307.688066683541 * f[(i + 5) * fsi] * f[(i + 5) * fsi] -
	71.4292240810191 * f[(i + 5) * fsi] * f[(i + 6) * fsi] +
	4.15594657554992 * f[(i + 6) * fsi] * f[(i + 6) * fsi];
      sigma3 =
	+4.15594657554992 * f[(i - 3) * fsi] * f[(i - 3) * fsi] -
	60.2050054904579 * f[(i - 3) * fsi] * f[(i - 2) * fsi] +
	189.330514253379 * f[(i - 3) * fsi] * f[(i - 1) * fsi] -
	338.290107858048 * f[(i - 3) * fsi] * f[(i + 0) * fsi] +
	376.449192281274 * f[(i - 3) * fsi] * f[(i + 1) * fsi] -
	267.702258737133 * f[(i - 3) * fsi] * f[(i + 2) * fsi] +
	119.001300721573 * f[(i - 3) * fsi] * f[(i + 3) * fsi] -
	30.2733426005663 * f[(i - 3) * fsi] * f[(i + 4) * fsi] +
	3.3778142788794 * f[(i - 3) * fsi] * f[(i + 5) * fsi] +
	224.5781681988 * f[(i - 2) * fsi] * f[(i - 2) * fsi] -
	1445.81202311801 * f[(i - 2) * fsi] * f[(i - 1) * fsi] +
	2631.07992925861 * f[(i - 2) * fsi] * f[(i + 0) * fsi] -
	2970.48199593336 * f[(i - 2) * fsi] * f[(i + 1) * fsi] +
	2136.83371274062 * f[(i - 2) * fsi] * f[(i + 2) * fsi] -
	958.713082546492 * f[(i - 2) * fsi] * f[(i + 3) * fsi] +
	245.728335017173 * f[(i - 2) * fsi] * f[(i + 4) * fsi] -
	27.586206325686 * f[(i - 2) * fsi] * f[(i + 5) * fsi] +
	2378.03262363703 * f[(i - 1) * fsi] * f[(i - 1) * fsi] -
	8815.81240974712 * f[(i - 1) * fsi] * f[(i + 0) * fsi] +
	10104.3776503687 * f[(i - 1) * fsi] * f[(i + 1) * fsi] -
	7358.38198208451 * f[(i - 1) * fsi] * f[(i + 2) * fsi] +
	3334.48145529283 * f[(i - 1) * fsi] * f[(i + 3) * fsi] -
	861.616952916863 * f[(i - 1) * fsi] * f[(i + 4) * fsi] +
	97.3685006774814 * f[(i - 1) * fsi] * f[(i + 5) * fsi] +
	8314.44047543303 * f[(i + 0) * fsi] * f[(i + 0) * fsi] -
	19354.0800298309 * f[(i + 0) * fsi] * f[(i + 1) * fsi] +
	14276.4079218034 * f[(i + 0) * fsi] * f[(i + 2) * fsi] -
	6538.57561788698 * f[(i + 0) * fsi] * f[(i + 3) * fsi] +
	1704.37865189406 * f[(i + 0) * fsi] * f[(i + 4) * fsi] -
	193.989288499038 * f[(i + 0) * fsi] * f[(i + 5) * fsi] +
	11427.8857755966 * f[(i + 1) * fsi] * f[(i + 1) * fsi] -
	17079.2799526704 * f[(i + 1) * fsi] * f[(i + 2) * fsi] +
	7909.63189419591 * f[(i + 1) * fsi] * f[(i + 3) * fsi] -
	2081.09545492807 * f[(i + 1) * fsi] * f[(i + 4) * fsi] +
	238.707145323602 * f[(i + 1) * fsi] * f[(i + 5) * fsi] +
	6460.89964518612 * f[(i + 2) * fsi] * f[(i + 2) * fsi] -
	6051.52109493231 * f[(i + 2) * fsi] * f[(i + 3) * fsi] +
	1607.7984936325 * f[(i + 2) * fsi] * f[(i + 4) * fsi] -
	185.954130124362 * f[(i + 2) * fsi] * f[(i + 5) * fsi] +
	1432.32903721728 * f[(i + 3) * fsi] * f[(i + 3) * fsi] -
	768.643244458397 * f[(i + 3) * fsi] * f[(i + 4) * fsi] +
	89.6803151793054 * f[(i + 3) * fsi] * f[(i + 5) * fsi] +
	104.120555009079 * f[(i + 4) * fsi] * f[(i + 4) * fsi] -
	24.5175956580063 * f[(i + 4) * fsi] * f[(i + 5) * fsi] +
	1.45672257391222 * f[(i + 5) * fsi] * f[(i + 5) * fsi];
      sigma4 =
	+1.45672257391222 * f[(i - 4) * fsi] * f[(i - 4) * fsi] -
	22.8431920515406 * f[(i - 4) * fsi] * f[(i - 3) * fsi] +
	77.2978189959941 * f[(i - 4) * fsi] * f[(i - 2) * fsi] -
	147.360891739772 * f[(i - 4) * fsi] * f[(i - 1) * fsi] +
	173.104800126842 * f[(i - 4) * fsi] * f[(i + 0) * fsi] -
	128.386943302279 * f[(i - 4) * fsi] * f[(i + 1) * fsi] +
	58.7752622928914 * f[(i - 4) * fsi] * f[(i + 2) * fsi] -
	15.2037101423747 * f[(i - 4) * fsi] * f[(i + 3) * fsi] +
	1.70341067241367 * f[(i - 4) * fsi] * f[(i + 4) * fsi] +
	91.7501465525254 * f[(i - 3) * fsi] * f[(i - 3) * fsi] -
	634.284062414746 * f[(i - 3) * fsi] * f[(i - 2) * fsi] +
	1231.84214048546 * f[(i - 3) * fsi] * f[(i - 1) * fsi] -
	1470.62870986083 * f[(i - 3) * fsi] * f[(i + 0) * fsi] +
	1106.32708286298 * f[(i - 3) * fsi] * f[(i + 1) * fsi] -
	512.943219947286 * f[(i - 3) * fsi] * f[(i + 2) * fsi] +
	134.233377963287 * f[(i - 3) * fsi] * f[(i + 3) * fsi] -
	15.2037101423747 * f[(i - 3) * fsi] * f[(i + 4) * fsi] +
	1119.38719626435 * f[(i - 2) * fsi] * f[(i - 2) * fsi] -
	4433.56279439219 * f[(i - 2) * fsi] * f[(i - 1) * fsi] +
	5386.9907367885 * f[(i - 2) * fsi] * f[(i + 0) * fsi] -
	4116.54995777895 * f[(i - 2) * fsi] * f[(i + 1) * fsi] +
	1935.50182392709 * f[(i - 2) * fsi] * f[(i + 2) * fsi] -
	512.943219947286 * f[(i - 2) * fsi] * f[(i + 3) * fsi] +
	58.7752622928914 * f[(i - 2) * fsi] * f[(i + 4) * fsi] +
	4477.71304825325 * f[(i - 1) * fsi] * f[(i - 1) * fsi] -
	11088.1845350392 * f[(i - 1) * fsi] * f[(i + 0) * fsi] +
	8620.4498023975 * f[(i - 1) * fsi] * f[(i + 1) * fsi] -
	4116.54995777895 * f[(i - 1) * fsi] * f[(i + 2) * fsi] +
	1106.32708286298 * f[(i - 1) * fsi] * f[(i + 3) * fsi] -
	128.386943302279 * f[(i - 1) * fsi] * f[(i + 4) * fsi] +
	6998.71770798472 * f[(i + 0) * fsi] * f[(i + 0) * fsi] -
	11088.1845350392 * f[(i + 0) * fsi] * f[(i + 1) * fsi] +
	5386.9907367885 * f[(i + 0) * fsi] * f[(i + 2) * fsi] -
	1470.62870986083 * f[(i + 0) * fsi] * f[(i + 3) * fsi] +
	173.104800126842 * f[(i + 0) * fsi] * f[(i + 4) * fsi] +
	4477.71304825325 * f[(i + 1) * fsi] * f[(i + 1) * fsi] -
	4433.56279439219 * f[(i + 1) * fsi] * f[(i + 2) * fsi] +
	1231.84214048546 * f[(i + 1) * fsi] * f[(i + 3) * fsi] -
	147.360891739772 * f[(i + 1) * fsi] * f[(i + 4) * fsi] +
	1119.38719626435 * f[(i + 2) * fsi] * f[(i + 2) * fsi] -
	634.284062414746 * f[(i + 2) * fsi] * f[(i + 3) * fsi] +
	77.2978189959941 * f[(i + 2) * fsi] * f[(i + 4) * fsi] +
	91.7501465525254 * f[(i + 3) * fsi] * f[(i + 3) * fsi] -
	22.8431920515406 * f[(i + 3) * fsi] * f[(i + 4) * fsi] +
	1.45672257391222 * f[(i + 4) * fsi] * f[(i + 4) * fsi];
      sigma5 =
	+1.45672257391222 * f[(i - 5) * fsi] * f[(i - 5) * fsi] -
	24.5175956580063 * f[(i - 5) * fsi] * f[(i - 4) * fsi] +
	89.6803151793054 * f[(i - 5) * fsi] * f[(i - 3) * fsi] -
	185.954130124362 * f[(i - 5) * fsi] * f[(i - 2) * fsi] +
	238.707145323602 * f[(i - 5) * fsi] * f[(i - 1) * fsi] -
	193.989288499038 * f[(i - 5) * fsi] * f[(i + 0) * fsi] +
	97.3685006774814 * f[(i - 5) * fsi] * f[(i + 1) * fsi] -
	27.586206325686 * f[(i - 5) * fsi] * f[(i + 2) * fsi] +
	3.3778142788794 * f[(i - 5) * fsi] * f[(i + 3) * fsi] +
	104.120555009079 * f[(i - 4) * fsi] * f[(i - 4) * fsi] -
	768.643244458397 * f[(i - 4) * fsi] * f[(i - 3) * fsi] +
	1607.7984936325 * f[(i - 4) * fsi] * f[(i - 2) * fsi] -
	2081.09545492807 * f[(i - 4) * fsi] * f[(i - 1) * fsi] +
	1704.37865189406 * f[(i - 4) * fsi] * f[(i + 0) * fsi] -
	861.616952916863 * f[(i - 4) * fsi] * f[(i + 1) * fsi] +
	245.728335017173 * f[(i - 4) * fsi] * f[(i + 2) * fsi] -
	30.2733426005663 * f[(i - 4) * fsi] * f[(i + 3) * fsi] +
	1432.32903721728 * f[(i - 3) * fsi] * f[(i - 3) * fsi] -
	6051.52109493231 * f[(i - 3) * fsi] * f[(i - 2) * fsi] +
	7909.63189419591 * f[(i - 3) * fsi] * f[(i - 1) * fsi] -
	6538.57561788698 * f[(i - 3) * fsi] * f[(i + 0) * fsi] +
	3334.48145529283 * f[(i - 3) * fsi] * f[(i + 1) * fsi] -
	958.713082546492 * f[(i - 3) * fsi] * f[(i + 2) * fsi] +
	119.001300721573 * f[(i - 3) * fsi] * f[(i + 3) * fsi] +
	6460.89964518612 * f[(i - 2) * fsi] * f[(i - 2) * fsi] -
	17079.2799526704 * f[(i - 2) * fsi] * f[(i - 1) * fsi] +
	14276.4079218034 * f[(i - 2) * fsi] * f[(i + 0) * fsi] -
	7358.38198208451 * f[(i - 2) * fsi] * f[(i + 1) * fsi] +
	2136.83371274062 * f[(i - 2) * fsi] * f[(i + 2) * fsi] -
	267.702258737133 * f[(i - 2) * fsi] * f[(i + 3) * fsi] +
	11427.8857755966 * f[(i - 1) * fsi] * f[(i - 1) * fsi] -
	19354.0800298309 * f[(i - 1) * fsi] * f[(i + 0) * fsi] +
	10104.3776503687 * f[(i - 1) * fsi] * f[(i + 1) * fsi] -
	2970.48199593336 * f[(i - 1) * fsi] * f[(i + 2) * fsi] +
	376.449192281274 * f[(i - 1) * fsi] * f[(i + 3) * fsi] +
	8314.44047543303 * f[(i + 0) * fsi] * f[(i + 0) * fsi] -
	8815.81240974712 * f[(i + 0) * fsi] * f[(i + 1) * fsi] +
	2631.07992925861 * f[(i + 0) * fsi] * f[(i + 2) * fsi] -
	338.290107858048 * f[(i + 0) * fsi] * f[(i + 3) * fsi] +
	2378.03262363703 * f[(i + 1) * fsi] * f[(i + 1) * fsi] -
	1445.81202311801 * f[(i + 1) * fsi] * f[(i + 2) * fsi] +
	189.330514253379 * f[(i + 1) * fsi] * f[(i + 3) * fsi] +
	224.5781681988 * f[(i + 2) * fsi] * f[(i + 2) * fsi] -
	60.2050054904579 * f[(i + 2) * fsi] * f[(i + 3) * fsi] +
	4.15594657554992 * f[(i + 3) * fsi] * f[(i + 3) * fsi];
      sigma6 =
	+4.15594657554992 * f[(i - 6) * fsi] * f[(i - 6) * fsi] -
	71.4292240810191 * f[(i - 6) * fsi] * f[(i - 5) * fsi] +
	268.954810839028 * f[(i - 6) * fsi] * f[(i - 4) * fsi] -
	579.197723970813 * f[(i - 6) * fsi] * f[(i - 3) * fsi] +
	779.596278301446 * f[(i - 6) * fsi] * f[(i - 2) * fsi] -
	670.849344757305 * f[(i - 6) * fsi] * f[(i - 1) * fsi] +
	359.908916834338 * f[(i - 6) * fsi] * f[(i + 0) * fsi] -
	109.897639186214 * f[(i - 6) * fsi] * f[(i + 1) * fsi] +
	14.6020328694406 * f[(i - 6) * fsi] * f[(i + 2) * fsi] +
	307.688066683541 * f[(i - 5) * fsi] * f[(i - 5) * fsi] -
	2323.5095791696 * f[(i - 5) * fsi] * f[(i - 4) * fsi] +
	5018.72343149075 * f[(i - 5) * fsi] * f[(i - 3) * fsi] -
	6776.71603569857 * f[(i - 5) * fsi] * f[(i - 2) * fsi] +
	5850.74664900054 * f[(i - 5) * fsi] * f[(i - 1) * fsi] -
	3149.43314058221 * f[(i - 5) * fsi] * f[(i + 0) * fsi] +
	964.845939313753 * f[(i - 5) * fsi] * f[(i + 1) * fsi] -
	128.604173640737 * f[(i - 5) * fsi] * f[(i + 2) * fsi] +
	4400.38698330138 * f[(i - 4) * fsi] * f[(i - 4) * fsi] -
	19076.8005289601 * f[(i - 4) * fsi] * f[(i - 3) * fsi] +
	25858.8233448132 * f[(i - 4) * fsi] * f[(i - 2) * fsi] -
	22417.2306985197 * f[(i - 4) * fsi] * f[(i - 1) * fsi] +
	12118.1388794826 * f[(i - 4) * fsi] * f[(i + 0) * fsi] -
	3728.0916300002 * f[(i - 4) * fsi] * f[(i + 1) * fsi] +
	498.941434911939 * f[(i - 4) * fsi] * f[(i + 2) * fsi] +
	20760.5788136853 * f[(i - 3) * fsi] * f[(i - 3) * fsi] -
	56543.4445813355 * f[(i - 3) * fsi] * f[(i - 2) * fsi] +
	49266.8129628913 * f[(i - 3) * fsi] * f[(i - 1) * fsi] -
	26774.8153713592 * f[(i - 3) * fsi] * f[(i + 0) * fsi] +
	8281.83632095821 * f[(i - 3) * fsi] * f[(i + 1) * fsi] -
	1114.27213708535 * f[(i - 3) * fsi] * f[(i + 2) * fsi] +
	38710.2228777378 * f[(i - 2) * fsi] * f[(i - 2) * fsi] -
	67875.8127912121 * f[(i - 2) * fsi] * f[(i - 1) * fsi] +
	37137.9417090107 * f[(i - 2) * fsi] * f[(i + 0) * fsi] -
	11568.2032050107 * f[(i - 2) * fsi] * f[(i + 1) * fsi] +
	1567.36952565594 * f[(i - 2) * fsi] * f[(i + 2) * fsi] +
	29975.0953815866 * f[(i - 1) * fsi] * f[(i - 1) * fsi] -
	33080.8713993305 * f[(i - 1) * fsi] * f[(i + 0) * fsi] +
	10399.3092657059 * f[(i - 1) * fsi] * f[(i + 1) * fsi] -
	1422.29540695141 * f[(i - 1) * fsi] * f[(i + 2) * fsi] +
	9222.43045243719 * f[(i + 0) * fsi] * f[(i + 0) * fsi] -
	5868.7702184994 * f[(i + 0) * fsi] * f[(i + 1) * fsi] +
	813.039719569186 * f[(i + 0) * fsi] * f[(i + 2) * fsi] +
	948.240872428061 * f[(i + 1) * fsi] * f[(i + 1) * fsi] -
	267.510578137456 * f[(i + 1) * fsi] * f[(i + 2) * fsi] +
	19.3647914042221 * f[(i + 2) * fsi] * f[(i + 2) * fsi];
      sigma7 =
	+19.3647914042221 * f[(i - 7) * fsi] * f[(i - 7) * fsi] -
	333.964212406558 * f[(i - 7) * fsi] * f[(i - 6) * fsi] +
	1265.66080746326 * f[(i - 7) * fsi] * f[(i - 5) * fsi] -
	2754.34352099738 * f[(i - 7) * fsi] * f[(i - 4) * fsi] +
	3765.65529677863 * f[(i - 7) * fsi] * f[(i - 3) * fsi] -
	3312.55790820803 * f[(i - 7) * fsi] * f[(i - 2) * fsi] +
	1830.9895489579 * f[(i - 7) * fsi] * f[(i - 1) * fsi] -
	581.225261534807 * f[(i - 7) * fsi] * f[(i + 0) * fsi] +
	81.0556671385418 * f[(i - 7) * fsi] * f[(i + 1) * fsi] +
	1441.28575449258 * f[(i - 6) * fsi] * f[(i - 6) * fsi] -
	10936.7033079505 * f[(i - 6) * fsi] * f[(i - 5) * fsi] +
	23831.4757387824 * f[(i - 6) * fsi] * f[(i - 4) * fsi] -
	32630.2392534289 * f[(i - 6) * fsi] * f[(i - 3) * fsi] +
	28752.7613106242 * f[(i - 6) * fsi] * f[(i - 2) * fsi] -
	15923.1845243454 * f[(i - 6) * fsi] * f[(i - 1) * fsi] +
	5065.26308734773 * f[(i - 6) * fsi] * f[(i + 0) * fsi] -
	707.980347608125 * f[(i - 6) * fsi] * f[(i + 1) * fsi] +
	20774.7074754889 * f[(i - 5) * fsi] * f[(i - 5) * fsi] -
	90677.1257492533 * f[(i - 5) * fsi] * f[(i - 4) * fsi] +
	124378.188236788 * f[(i - 5) * fsi] * f[(i - 3) * fsi] -
	109824.674852455 * f[(i - 5) * fsi] * f[(i - 2) * fsi] +
	60963.6198256632 * f[(i - 5) * fsi] * f[(i - 1) * fsi] -
	19443.7923047687 * f[(i - 5) * fsi] * f[(i + 0) * fsi] +
	2725.41239353462 * f[(i - 5) * fsi] * f[(i + 1) * fsi] +
	99127.2745988898 * f[(i - 4) * fsi] * f[(i - 4) * fsi] -
	272525.224659461 * f[(i - 4) * fsi] * f[(i - 3) * fsi] +
	241247.066835384 * f[(i - 4) * fsi] * f[(i - 2) * fsi] -
	134309.272278381 * f[(i - 4) * fsi] * f[(i - 1) * fsi] +
	42979.1691915766 * f[(i - 4) * fsi] * f[(i + 0) * fsi] -
	6046.29475543025 * f[(i - 4) * fsi] * f[(i + 1) * fsi] +
	187797.717874362 * f[(i - 3) * fsi] * f[(i - 3) * fsi] -
	333527.451742794 * f[(i - 3) * fsi] * f[(i - 2) * fsi] +
	186372.636616418 * f[(i - 3) * fsi] * f[(i - 1) * fsi] -
	59895.4013896723 * f[(i - 3) * fsi] * f[(i + 0) * fsi] +
	8466.40114664635 * f[(i - 3) * fsi] * f[(i + 1) * fsi] +
	148657.090978519 * f[(i - 2) * fsi] * f[(i - 2) * fsi] -
	166921.455804809 * f[(i - 2) * fsi] * f[(i - 1) * fsi] +
	53947.0217387824 * f[(i - 2) * fsi] * f[(i + 0) * fsi] -
	7674.89153356352 * f[(i - 2) * fsi] * f[(i + 1) * fsi] +
	47140.2493458593 * f[(i - 1) * fsi] * f[(i - 1) * fsi] -
	30701.1587180034 * f[(i - 1) * fsi] * f[(i + 0) * fsi] +
	4407.32664278072 * f[(i - 1) * fsi] * f[(i + 1) * fsi] +
	5049.77020781835 * f[(i + 0) * fsi] * f[(i + 0) * fsi] -
	1469.41675936423 * f[(i + 0) * fsi] * f[(i + 1) * fsi] +
	109.193772932945 * f[(i + 1) * fsi] * f[(i + 1) * fsi];
      sigma8 =
	+109.193772932945 * f[(i - 8) * fsi] * f[(i - 8) * fsi] -
	1884.43224565446 * f[(i - 8) * fsi] * f[(i - 7) * fsi] +
	7153.9713035639 * f[(i - 8) * fsi] * f[(i - 6) * fsi] -
	15619.1414592001 * f[(i - 8) * fsi] * f[(i - 5) * fsi] +
	21470.5360236718 * f[(i - 8) * fsi] * f[(i - 4) * fsi] -
	19050.4296324557 * f[(i - 8) * fsi] * f[(i - 3) * fsi] +
	10669.6623191712 * f[(i - 8) * fsi] * f[(i - 2) * fsi] -
	3454.6250083913 * f[(i - 8) * fsi] * f[(i - 1) * fsi] +
	496.071153428775 * f[(i - 8) * fsi] * f[(i + 0) * fsi] +
	8134.55939472587 * f[(i - 7) * fsi] * f[(i - 7) * fsi] -
	61801.7019274941 * f[(i - 7) * fsi] * f[(i - 6) * fsi] +
	135029.257900627 * f[(i - 7) * fsi] * f[(i - 5) * fsi] -
	185776.153674587 * f[(i - 7) * fsi] * f[(i - 4) * fsi] +
	165006.507929424 * f[(i - 7) * fsi] * f[(i - 3) * fsi] -
	92530.8427411113 * f[(i - 7) * fsi] * f[(i - 2) * fsi] +
	30004.6106074921 * f[(i - 7) * fsi] * f[(i - 1) * fsi] -
	4316.36463814691 * f[(i - 7) * fsi] * f[(i + 0) * fsi] +
	117469.122961696 * f[(i - 6) * fsi] * f[(i - 6) * fsi] -
	513755.446640071 * f[(i - 6) * fsi] * f[(i - 5) * fsi] +
	707565.248792344 * f[(i - 6) * fsi] * f[(i - 4) * fsi] -
	629240.182223211 * f[(i - 6) * fsi] * f[(i - 3) * fsi] +
	353390.255601705 * f[(i - 6) * fsi] * f[(i - 2) * fsi] -
	114802.39231254 * f[(i - 6) * fsi] * f[(i - 1) * fsi] +
	16552.0014823105 * f[(i - 6) * fsi] * f[(i + 0) * fsi] +
	562311.328233438 * f[(i - 5) * fsi] * f[(i - 5) * fsi] -
	1550800.19015232 * f[(i - 5) * fsi] * f[(i - 4) * fsi] +
	1381212.31577771 * f[(i - 5) * fsi] * f[(i - 3) * fsi] -
	777141.668605927 * f[(i - 5) * fsi] * f[(i - 2) * fsi] +
	253037.274363286 * f[(i - 5) * fsi] * f[(i - 1) * fsi] -
	36585.0576509742 * f[(i - 5) * fsi] * f[(i + 0) * fsi] +
	1070854.47449811 * f[(i - 4) * fsi] * f[(i - 4) * fsi] -
	1911046.21916467 * f[(i - 4) * fsi] * f[(i - 3) * fsi] +
	1077735.75959481 * f[(i - 4) * fsi] * f[(i - 2) * fsi] -
	351925.412140196 * f[(i - 4) * fsi] * f[(i - 1) * fsi] +
	51067.48172473 * f[(i - 4) * fsi] * f[(i + 0) * fsi] +
	854591.512480352 * f[(i - 3) * fsi] * f[(i - 3) * fsi] -
	966727.207640071 * f[(i - 3) * fsi] * f[(i - 2) * fsi] +
	316864.946394454 * f[(i - 3) * fsi] * f[(i - 1) * fsi] -
	46202.7564018809 * f[(i - 3) * fsi] * f[(i + 0) * fsi] +
	274437.463974042 * f[(i - 2) * fsi] * f[(i - 2) * fsi] -
	180813.861301392 * f[(i - 2) * fsi] * f[(i - 1) * fsi] +
	26542.9748247279 * f[(i - 2) * fsi] * f[(i + 0) * fsi] +
	29991.6199268498 * f[(i - 1) * fsi] * f[(i - 1) * fsi] -
	8893.78045641284 * f[(i - 1) * fsi] * f[(i + 0) * fsi] +
	669.714981108808 * f[(i + 0) * fsi] * f[(i + 0) * fsi];
      sigma[i * ssi + 0 * ssr] = sigma0;
      sigma[i * ssi + 1 * ssr] = sigma1;
      sigma[i * ssi + 2 * ssr] = sigma2;
      sigma[i * ssi + 3 * ssr] = sigma3;
      sigma[i * ssi + 4 * ssr] = sigma4;
      sigma[i * ssi + 5 * ssr] = sigma5;
      sigma[i * ssi + 6 * ssr] = sigma6;
      sigma[i * ssi + 7 * ssr] = sigma7;
      sigma[i * ssi + 8 * ssr] = sigma8;
    }
}

PyObject *
py_smoothness009 (PyObject * self, PyObject * args)
{
  double *sigma, *f;
  PyArrayObject *f_py, *sigma_py;

  long int n;
  int ssi, ssr, fsi;

  /* parse options */

  if (!PyArg_ParseTuple (args, "OO", &f_py, &sigma_py))
    return NULL;

  if (sigma_py->nd != 2 || sigma_py->descr->type_num != PyArray_DOUBLE)
    {
      PyErr_SetString (PyExc_ValueError, "sigma must be two-dimensional and of type float");
      return NULL;
    }

  if (f_py->nd != 1 || f_py->descr->type_num != PyArray_DOUBLE)
    {
      PyErr_SetString (PyExc_ValueError, "f must be one-dimensional and of type float");
      return NULL;
    }

  /* get data, n, strides */
  sigma = (double *) PyArray_DATA (sigma_py);
  f = (double *) PyArray_DATA (f_py);

  n = PyArray_DIM (f_py, 0);

  ssi = sigma_py->strides[0] / sizeof (double);
  ssr = sigma_py->strides[1] / sizeof (double);

  fsi = f_py->strides[0] / sizeof (double);

  smoothness009 (f, n, fsi, sigma, ssi, ssr);

  Py_INCREF (Py_None);
  return Py_None;
}
