#include <Python.h>
#include <numpy/ndarrayobject.h>

void
smoothness007 (const double *restrict f, int n, int fsi, double *restrict sigma, int ssi, int ssr)
{
  int i;
  double sigma0, sigma1, sigma2, sigma3, sigma4, sigma5, sigma6;
  for (i = 7; i < n - 7; i++)
    {
      sigma0 =
	+119.876965822244 * f[(i + 0) * fsi] * f[(i + 0) * fsi] -
	1140.52691383077 * f[(i + 0) * fsi] * f[(i + 1) * fsi] +
	2345.30742098565 * f[(i + 0) * fsi] * f[(i + 2) * fsi] -
	2648.53826913313 * f[(i + 0) * fsi] * f[(i + 3) * fsi] +
	1719.4383816338 * f[(i + 0) * fsi] * f[(i + 4) * fsi] -
	605.48066052389 * f[(i + 0) * fsi] * f[(i + 5) * fsi] +
	90.0461092238523 * f[(i + 0) * fsi] * f[(i + 6) * fsi] +
	2787.97471636003 * f[(i + 1) * fsi] * f[(i + 1) * fsi] -
	11665.8977583874 * f[(i + 1) * fsi] * f[(i + 2) * fsi] +
	13315.7065438111 * f[(i + 1) * fsi] * f[(i + 3) * fsi] -
	8706.93798656205 * f[(i + 1) * fsi] * f[(i + 4) * fsi] +
	3081.76169462482 * f[(i + 1) * fsi] * f[(i + 5) * fsi] -
	460.055012375742 * f[(i + 1) * fsi] * f[(i + 6) * fsi] +
	12350.3314303752 * f[(i + 2) * fsi] * f[(i + 2) * fsi] -
	28424.0145572791 * f[(i + 2) * fsi] * f[(i + 3) * fsi] +
	18693.1184907107 * f[(i + 2) * fsi] * f[(i + 4) * fsi] -
	6644.20048656205 * f[(i + 2) * fsi] * f[(i + 5) * fsi] +
	995.024029781946 * f[(i + 2) * fsi] * f[(i + 6) * fsi] +
	16453.1759122308 * f[(i + 3) * fsi] * f[(i + 3) * fsi] -
	21738.2182609828 * f[(i + 3) * fsi] * f[(i + 4) * fsi] +
	7752.80284010742 * f[(i + 3) * fsi] * f[(i + 5) * fsi] -
	1164.09012098498 * f[(i + 3) * fsi] * f[(i + 6) * fsi] +
	7205.30018037518 * f[(i + 4) * fsi] * f[(i + 4) * fsi] -
	5153.46025838745 * f[(i + 4) * fsi] * f[(i + 5) * fsi] +
	775.459272837502 * f[(i + 4) * fsi] * f[(i + 6) * fsi] +
	923.494716360029 * f[(i + 5) * fsi] * f[(i + 5) * fsi] -
	278.412561978916 * f[(i + 5) * fsi] * f[(i + 6) * fsi] +
	21.0141417481695 * f[(i + 6) * fsi] * f[(i + 6) * fsi];
      sigma1 =
	+21.0141417481695 * f[(i - 1) * fsi] * f[(i - 1) * fsi] -
	204.151875250521 * f[(i - 1) * fsi] * f[(i + 0) * fsi] +
	422.538941047379 * f[(i - 1) * fsi] * f[(i + 1) * fsi] -
	475.96589258992 * f[(i - 1) * fsi] * f[(i + 2) * fsi] +
	306.899801386885 * f[(i - 1) * fsi] * f[(i + 3) * fsi] -
	107.134680585618 * f[(i - 1) * fsi] * f[(i + 4) * fsi] +
	15.7854224954572 * f[(i - 1) * fsi] * f[(i + 5) * fsi] +
	519.247146915584 * f[(i + 0) * fsi] * f[(i + 0) * fsi] -
	2207.33120746152 * f[(i + 0) * fsi] * f[(i + 1) * fsi] +
	2525.45484628026 * f[(i + 0) * fsi] * f[(i + 2) * fsi] -
	1645.22305600649 * f[(i + 0) * fsi] * f[(i + 3) * fsi] +
	578.412852032227 * f[(i + 0) * fsi] * f[(i + 4) * fsi] -
	85.6558534251243 * f[(i + 0) * fsi] * f[(i + 5) * fsi] +
	2394.05596741222 * f[(i + 1) * fsi] * f[(i + 1) * fsi] -
	5559.25606962482 * f[(i + 1) * fsi] * f[(i + 2) * fsi] +
	3658.67693978475 * f[(i + 1) * fsi] * f[(i + 3) * fsi] -
	1295.61101896946 * f[(i + 1) * fsi] * f[(i + 4) * fsi] +
	192.87048039923 * f[(i + 1) * fsi] * f[(i + 5) * fsi] +
	3266.81402951472 * f[(i + 2) * fsi] * f[(i + 2) * fsi] -
	4339.66656345198 * f[(i + 2) * fsi] * f[(i + 3) * fsi] +
	1547.32768578644 * f[(i + 2) * fsi] * f[(i + 4) * fsi] -
	231.522065429427 * f[(i + 2) * fsi] * f[(i + 5) * fsi] +
	1452.34531926407 * f[(i + 3) * fsi] * f[(i + 3) * fsi] -
	1042.03954079485 * f[(i + 3) * fsi] * f[(i + 4) * fsi] +
	156.661780553551 * f[(i + 3) * fsi] * f[(i + 5) * fsi] +
	187.891961730399 * f[(i + 4) * fsi] * f[(i + 4) * fsi] -
	56.7392209295334 * f[(i + 4) * fsi] * f[(i + 5) * fsi] +
	4.29972816792261 * f[(i + 5) * fsi] * f[(i + 5) * fsi];
      sigma2 =
	+4.29972816792261 * f[(i - 2) * fsi] * f[(i - 2) * fsi] -
	44.4107718554594 * f[(i - 2) * fsi] * f[(i - 1) * fsi] +
	94.9327296276255 * f[(i - 2) * fsi] * f[(i + 0) * fsi] -
	108.110491355352 * f[(i - 2) * fsi] * f[(i + 1) * fsi] +
	69.4589063251563 * f[(i - 2) * fsi] * f[(i + 2) * fsi] -
	23.9268024991983 * f[(i - 2) * fsi] * f[(i + 3) * fsi] +
	3.45697342138314 * f[(i - 2) * fsi] * f[(i + 4) * fsi] +
	121.202864508177 * f[(i - 1) * fsi] * f[(i - 1) * fsi] -
	537.187110239298 * f[(i - 1) * fsi] * f[(i + 0) * fsi] +
	626.822593193843 * f[(i - 1) * fsi] * f[(i + 1) * fsi] -
	409.688449525012 * f[(i - 1) * fsi] * f[(i + 2) * fsi] +
	142.893546476671 * f[(i - 1) * fsi] * f[(i + 3) * fsi] -
	20.8355370670996 * f[(i - 1) * fsi] * f[(i + 4) * fsi] +
	616.654347041847 * f[(i + 0) * fsi] * f[(i + 0) * fsi] -
	1479.69665604457 * f[(i + 0) * fsi] * f[(i + 1) * fsi] +
	986.137009229197 * f[(i + 0) * fsi] * f[(i + 2) * fsi] -
	348.912986562049 * f[(i + 0) * fsi] * f[(i + 3) * fsi] +
	51.4183199054032 * f[(i + 0) * fsi] * f[(i + 4) * fsi] +
	910.756159144354 * f[(i + 1) * fsi] * f[(i + 1) * fsi] -
	1239.85097703223 * f[(i + 1) * fsi] * f[(i + 2) * fsi] +
	445.834938872856 * f[(i + 1) * fsi] * f[(i + 3) * fsi] -
	66.5117259232537 * f[(i + 1) * fsi] * f[(i + 4) * fsi] +
	430.708745189995 * f[(i + 2) * fsi] * f[(i + 2) * fsi] -
	315.141276905964 * f[(i + 2) * fsi] * f[(i + 3) * fsi] +
	47.66729752886 * f[(i + 2) * fsi] * f[(i + 4) * fsi] +
	58.6280496933622 * f[(i + 3) * fsi] * f[(i + 3) * fsi] -
	18.0035187690396 * f[(i + 3) * fsi] * f[(i + 4) * fsi] +
	1.40409545187323 * f[(i + 4) * fsi] * f[(i + 4) * fsi];
      sigma3 =
	+1.40409545187323 * f[(i - 3) * fsi] * f[(i - 3) * fsi] -
	16.2003629048421 * f[(i - 3) * fsi] * f[(i - 2) * fsi] +
	38.1364719115761 * f[(i - 3) * fsi] * f[(i - 1) * fsi] -
	46.8683617257228 * f[(i - 3) * fsi] * f[(i + 0) * fsi] +
	31.7749557078724 * f[(i - 3) * fsi] * f[(i + 1) * fsi] -
	11.3047114498156 * f[(i - 3) * fsi] * f[(i + 2) * fsi] +
	1.65381755718561 * f[(i - 3) * fsi] * f[(i + 3) * fsi] +
	48.9015913600289 * f[(i - 2) * fsi] * f[(i - 2) * fsi] -
	238.769633387446 * f[(i - 2) * fsi] * f[(i - 1) * fsi] +
	302.017191959275 * f[(i - 2) * fsi] * f[(i + 0) * fsi] -
	209.541111562049 * f[(i - 2) * fsi] * f[(i + 1) * fsi] +
	75.9954446248196 * f[(i - 2) * fsi] * f[(i + 2) * fsi] -
	11.3047114498156 * f[(i - 2) * fsi] * f[(i + 3) * fsi] +
	302.86268037518 * f[(i - 1) * fsi] * f[(i - 1) * fsi] -
	792.178909130992 * f[(i - 1) * fsi] * f[(i + 0) * fsi] +
	564.852865710678 * f[(i - 1) * fsi] * f[(i + 1) * fsi] -
	209.541111562049 * f[(i - 1) * fsi] * f[(i + 2) * fsi] +
	31.7749557078724 * f[(i - 1) * fsi] * f[(i + 3) * fsi] +
	537.03007889744 * f[(i + 0) * fsi] * f[(i + 0) * fsi] -
	792.178909130992 * f[(i + 0) * fsi] * f[(i + 1) * fsi] +
	302.017191959275 * f[(i + 0) * fsi] * f[(i + 2) * fsi] -
	46.8683617257228 * f[(i + 0) * fsi] * f[(i + 3) * fsi] +
	302.86268037518 * f[(i + 1) * fsi] * f[(i + 1) * fsi] -
	238.769633387446 * f[(i + 1) * fsi] * f[(i + 2) * fsi] +
	38.1364719115761 * f[(i + 1) * fsi] * f[(i + 3) * fsi] +
	48.9015913600289 * f[(i + 2) * fsi] * f[(i + 2) * fsi] -
	16.2003629048421 * f[(i + 2) * fsi] * f[(i + 3) * fsi] +
	1.40409545187323 * f[(i + 3) * fsi] * f[(i + 3) * fsi];
      sigma4 =
	+1.40409545187323 * f[(i - 4) * fsi] * f[(i - 4) * fsi] -
	18.0035187690396 * f[(i - 4) * fsi] * f[(i - 3) * fsi] +
	47.66729752886 * f[(i - 4) * fsi] * f[(i - 2) * fsi] -
	66.5117259232537 * f[(i - 4) * fsi] * f[(i - 1) * fsi] +
	51.4183199054032 * f[(i - 4) * fsi] * f[(i + 0) * fsi] -
	20.8355370670996 * f[(i - 4) * fsi] * f[(i + 1) * fsi] +
	3.45697342138314 * f[(i - 4) * fsi] * f[(i + 2) * fsi] +
	58.6280496933622 * f[(i - 3) * fsi] * f[(i - 3) * fsi] -
	315.141276905964 * f[(i - 3) * fsi] * f[(i - 2) * fsi] +
	445.834938872856 * f[(i - 3) * fsi] * f[(i - 1) * fsi] -
	348.912986562049 * f[(i - 3) * fsi] * f[(i + 0) * fsi] +
	142.893546476671 * f[(i - 3) * fsi] * f[(i + 1) * fsi] -
	23.9268024991983 * f[(i - 3) * fsi] * f[(i + 2) * fsi] +
	430.708745189995 * f[(i - 2) * fsi] * f[(i - 2) * fsi] -
	1239.85097703223 * f[(i - 2) * fsi] * f[(i - 1) * fsi] +
	986.137009229197 * f[(i - 2) * fsi] * f[(i + 0) * fsi] -
	409.688449525012 * f[(i - 2) * fsi] * f[(i + 1) * fsi] +
	69.4589063251563 * f[(i - 2) * fsi] * f[(i + 2) * fsi] +
	910.756159144354 * f[(i - 1) * fsi] * f[(i - 1) * fsi] -
	1479.69665604457 * f[(i - 1) * fsi] * f[(i + 0) * fsi] +
	626.822593193843 * f[(i - 1) * fsi] * f[(i + 1) * fsi] -
	108.110491355352 * f[(i - 1) * fsi] * f[(i + 2) * fsi] +
	616.654347041847 * f[(i + 0) * fsi] * f[(i + 0) * fsi] -
	537.187110239298 * f[(i + 0) * fsi] * f[(i + 1) * fsi] +
	94.9327296276255 * f[(i + 0) * fsi] * f[(i + 2) * fsi] +
	121.202864508177 * f[(i + 1) * fsi] * f[(i + 1) * fsi] -
	44.4107718554594 * f[(i + 1) * fsi] * f[(i + 2) * fsi] +
	4.29972816792261 * f[(i + 2) * fsi] * f[(i + 2) * fsi];
      sigma5 =
	+4.29972816792261 * f[(i - 5) * fsi] * f[(i - 5) * fsi] -
	56.7392209295334 * f[(i - 5) * fsi] * f[(i - 4) * fsi] +
	156.661780553551 * f[(i - 5) * fsi] * f[(i - 3) * fsi] -
	231.522065429427 * f[(i - 5) * fsi] * f[(i - 2) * fsi] +
	192.87048039923 * f[(i - 5) * fsi] * f[(i - 1) * fsi] -
	85.6558534251243 * f[(i - 5) * fsi] * f[(i + 0) * fsi] +
	15.7854224954572 * f[(i - 5) * fsi] * f[(i + 1) * fsi] +
	187.891961730399 * f[(i - 4) * fsi] * f[(i - 4) * fsi] -
	1042.03954079485 * f[(i - 4) * fsi] * f[(i - 3) * fsi] +
	1547.32768578644 * f[(i - 4) * fsi] * f[(i - 2) * fsi] -
	1295.61101896946 * f[(i - 4) * fsi] * f[(i - 1) * fsi] +
	578.412852032227 * f[(i - 4) * fsi] * f[(i + 0) * fsi] -
	107.134680585618 * f[(i - 4) * fsi] * f[(i + 1) * fsi] +
	1452.34531926407 * f[(i - 3) * fsi] * f[(i - 3) * fsi] -
	4339.66656345198 * f[(i - 3) * fsi] * f[(i - 2) * fsi] +
	3658.67693978475 * f[(i - 3) * fsi] * f[(i - 1) * fsi] -
	1645.22305600649 * f[(i - 3) * fsi] * f[(i + 0) * fsi] +
	306.899801386885 * f[(i - 3) * fsi] * f[(i + 1) * fsi] +
	3266.81402951472 * f[(i - 2) * fsi] * f[(i - 2) * fsi] -
	5559.25606962482 * f[(i - 2) * fsi] * f[(i - 1) * fsi] +
	2525.45484628026 * f[(i - 2) * fsi] * f[(i + 0) * fsi] -
	475.96589258992 * f[(i - 2) * fsi] * f[(i + 1) * fsi] +
	2394.05596741222 * f[(i - 1) * fsi] * f[(i - 1) * fsi] -
	2207.33120746152 * f[(i - 1) * fsi] * f[(i + 0) * fsi] +
	422.538941047379 * f[(i - 1) * fsi] * f[(i + 1) * fsi] +
	519.247146915584 * f[(i + 0) * fsi] * f[(i + 0) * fsi] -
	204.151875250521 * f[(i + 0) * fsi] * f[(i + 1) * fsi] +
	21.0141417481695 * f[(i + 1) * fsi] * f[(i + 1) * fsi];
      sigma6 =
	+21.0141417481695 * f[(i - 6) * fsi] * f[(i - 6) * fsi] -
	278.412561978916 * f[(i - 6) * fsi] * f[(i - 5) * fsi] +
	775.459272837502 * f[(i - 6) * fsi] * f[(i - 4) * fsi] -
	1164.09012098498 * f[(i - 6) * fsi] * f[(i - 3) * fsi] +
	995.024029781946 * f[(i - 6) * fsi] * f[(i - 2) * fsi] -
	460.055012375742 * f[(i - 6) * fsi] * f[(i - 1) * fsi] +
	90.0461092238523 * f[(i - 6) * fsi] * f[(i + 0) * fsi] +
	923.494716360029 * f[(i - 5) * fsi] * f[(i - 5) * fsi] -
	5153.46025838745 * f[(i - 5) * fsi] * f[(i - 4) * fsi] +
	7752.80284010742 * f[(i - 5) * fsi] * f[(i - 3) * fsi] -
	6644.20048656205 * f[(i - 5) * fsi] * f[(i - 2) * fsi] +
	3081.76169462482 * f[(i - 5) * fsi] * f[(i - 1) * fsi] -
	605.48066052389 * f[(i - 5) * fsi] * f[(i + 0) * fsi] +
	7205.30018037518 * f[(i - 4) * fsi] * f[(i - 4) * fsi] -
	21738.2182609828 * f[(i - 4) * fsi] * f[(i - 3) * fsi] +
	18693.1184907107 * f[(i - 4) * fsi] * f[(i - 2) * fsi] -
	8706.93798656205 * f[(i - 4) * fsi] * f[(i - 1) * fsi] +
	1719.4383816338 * f[(i - 4) * fsi] * f[(i + 0) * fsi] +
	16453.1759122308 * f[(i - 3) * fsi] * f[(i - 3) * fsi] -
	28424.0145572791 * f[(i - 3) * fsi] * f[(i - 2) * fsi] +
	13315.7065438111 * f[(i - 3) * fsi] * f[(i - 1) * fsi] -
	2648.53826913313 * f[(i - 3) * fsi] * f[(i + 0) * fsi] +
	12350.3314303752 * f[(i - 2) * fsi] * f[(i - 2) * fsi] -
	11665.8977583874 * f[(i - 2) * fsi] * f[(i - 1) * fsi] +
	2345.30742098565 * f[(i - 2) * fsi] * f[(i + 0) * fsi] +
	2787.97471636003 * f[(i - 1) * fsi] * f[(i - 1) * fsi] -
	1140.52691383077 * f[(i - 1) * fsi] * f[(i + 0) * fsi] +
	119.876965822244 * f[(i + 0) * fsi] * f[(i + 0) * fsi];
      sigma[i * ssi + 0 * ssr] = sigma0;
      sigma[i * ssi + 1 * ssr] = sigma1;
      sigma[i * ssi + 2 * ssr] = sigma2;
      sigma[i * ssi + 3 * ssr] = sigma3;
      sigma[i * ssi + 4 * ssr] = sigma4;
      sigma[i * ssi + 5 * ssr] = sigma5;
      sigma[i * ssi + 6 * ssr] = sigma6;
    }
}

PyObject *
py_smoothness007 (PyObject * self, PyObject * args)
{
  double *sigma, *f;
  PyArrayObject *f_py, *sigma_py;

  long int n;
  int ssi, ssr, fsi;

  /* parse options */

  if (!PyArg_ParseTuple (args, "OO", &f_py, &sigma_py))
    return NULL;

  if (sigma_py->nd != 2 || sigma_py->descr->type_num != PyArray_DOUBLE)
    {
      PyErr_SetString (PyExc_ValueError, "sigma must be two-dimensional and of type float");
      return NULL;
    }

  if (f_py->nd != 1 || f_py->descr->type_num != PyArray_DOUBLE)
    {
      PyErr_SetString (PyExc_ValueError, "f must be one-dimensional and of type float");
      return NULL;
    }

  /* get data, n, strides */
  sigma = (double *) PyArray_DATA (sigma_py);
  f = (double *) PyArray_DATA (f_py);

  n = PyArray_DIM (f_py, 0);

  ssi = sigma_py->strides[0] / sizeof (double);
  ssr = sigma_py->strides[1] / sizeof (double);

  fsi = f_py->strides[0] / sizeof (double);

  smoothness007 (f, n, fsi, sigma, ssi, ssr);

  Py_INCREF (Py_None);
  return Py_None;
}
