#include <Python.h>
#include <numpy/ndarrayobject.h>

void
smoothness008 (const double *restrict f, int n, int fsi, double *restrict sigma, int ssi, int ssr)
{
  int i;
  double sigma0, sigma1, sigma2, sigma3, sigma4, sigma5, sigma6, sigma7;
  for (i = 8; i < n - 8; i++)
    {
      sigma0 =
	+282.837600612977 * f[(i + 0) * fsi] * f[(i + 0) * fsi] -
	3217.68658751845 * f[(i + 0) * fsi] * f[(i + 1) * fsi] +
	8098.17149379591 * f[(i + 0) * fsi] * f[(i + 2) * fsi] -
	11602.0447459035 * f[(i + 0) * fsi] * f[(i + 3) * fsi] +
	10159.0931716562 * f[(i + 0) * fsi] * f[(i + 4) * fsi] -
	5415.63416825253 * f[(i + 0) * fsi] * f[(i + 5) * fsi] +
	1622.88916698582 * f[(i + 0) * fsi] * f[(i + 6) * fsi] -
	210.463531989358 * f[(i + 0) * fsi] * f[(i + 7) * fsi] +
	9343.02132742786 * f[(i + 1) * fsi] * f[(i + 1) * fsi] -
	47645.872787025 * f[(i + 1) * fsi] * f[(i + 2) * fsi] +
	68840.1294128134 * f[(i + 1) * fsi] * f[(i + 3) * fsi] -
	60634.3990483282 * f[(i + 1) * fsi] * f[(i + 4) * fsi] +
	32462.762767691 * f[(i + 1) * fsi] * f[(i + 5) * fsi] -
	9759.93192303144 * f[(i + 1) * fsi] * f[(i + 6) * fsi] +
	1268.95551054292 * f[(i + 1) * fsi] * f[(i + 7) * fsi] +
	61294.8370166772 * f[(i + 2) * fsi] * f[(i + 2) * fsi] -
	178245.759975439 * f[(i + 2) * fsi] * f[(i + 3) * fsi] +
	157723.978487162 * f[(i + 2) * fsi] * f[(i + 4) * fsi] -
	84736.2897924522 * f[(i + 2) * fsi] * f[(i + 5) * fsi] +
	25544.3501239796 * f[(i + 2) * fsi] * f[(i + 6) * fsi] -
	3328.25158337599 * f[(i + 2) * fsi] * f[(i + 7) * fsi] +
	130199.124980546 * f[(i + 3) * fsi] * f[(i + 3) * fsi] -
	231245.307361434 * f[(i + 3) * fsi] * f[(i + 4) * fsi] +
	124579.67848041 * f[(i + 3) * fsi] * f[(i + 5) * fsi] -
	37637.4314325875 * f[(i + 3) * fsi] * f[(i + 6) * fsi] +
	4912.48566104661 * f[(i + 3) * fsi] * f[(i + 7) * fsi] +
	102966.44021251 * f[(i + 4) * fsi] * f[(i + 4) * fsi] -
	111189.450476982 * f[(i + 4) * fsi] * f[(i + 5) * fsi] +
	33651.8387772039 * f[(i + 4) * fsi] * f[(i + 6) * fsi] -
	4398.63397429859 * f[(i + 4) * fsi] * f[(i + 7) * fsi] +
	30071.0784359481 * f[(i + 5) * fsi] * f[(i + 5) * fsi] -
	18228.7647006052 * f[(i + 5) * fsi] * f[(i + 6) * fsi] +
	2385.54101829437 * f[(i + 5) * fsi] * f[(i + 7) * fsi] +
	2765.84444133604 * f[(i + 6) * fsi] * f[(i + 6) * fsi] -
	724.638894617214 * f[(i + 6) * fsi] * f[(i + 7) * fsi] +
	47.5028971986251 * f[(i + 7) * fsi] * f[(i + 7) * fsi];
      sigma1 =
	+47.5028971986251 * f[(i - 1) * fsi] * f[(i - 1) * fsi] -
	549.582823188643 * f[(i - 1) * fsi] * f[(i + 0) * fsi] +
	1391.20673258008 * f[(i - 1) * fsi] * f[(i + 1) * fsi] -
	1992.07290287002 * f[(i - 1) * fsi] * f[(i + 2) * fsi] +
	1737.9199467609 * f[(i - 1) * fsi] * f[(i + 3) * fsi] -
	921.690511947415 * f[(i - 1) * fsi] * f[(i + 4) * fsi] +
	274.621224828637 * f[(i - 1) * fsi] * f[(i + 5) * fsi] -
	35.407460560787 * f[(i - 1) * fsi] * f[(i + 6) * fsi] +
	1639.31476541011 * f[(i + 0) * fsi] * f[(i + 0) * fsi] -
	8454.36155245706 * f[(i + 0) * fsi] * f[(i + 1) * fsi] +
	12248.796925352 * f[(i + 0) * fsi] * f[(i + 2) * fsi] -
	10772.9570807356 * f[(i + 0) * fsi] * f[(i + 3) * fsi] +
	5746.65947583143 * f[(i + 0) * fsi] * f[(i + 4) * fsi] -
	1719.62507117959 * f[(i + 0) * fsi] * f[(i + 5) * fsi] +
	222.440595557253 * f[(i + 0) * fsi] * f[(i + 6) * fsi] +
	11054.5384359481 * f[(i + 1) * fsi] * f[(i + 1) * fsi] -
	32362.4054769819 * f[(i + 1) * fsi] * f[(i + 2) * fsi] +
	28675.0021841139 * f[(i + 1) * fsi] * f[(i + 3) * fsi] -
	15380.2247924521 * f[(i + 1) * fsi] * f[(i + 4) * fsi] +
	4621.402767691 * f[(i + 1) * fsi] * f[(i + 5) * fsi] -
	599.696734390095 * f[(i + 1) * fsi] * f[(i + 6) * fsi] +
	23881.8339625102 * f[(i + 2) * fsi] * f[(i + 2) * fsi] -
	42591.6661577299 * f[(i + 2) * fsi] * f[(i + 3) * fsi] +
	22956.5584871618 * f[(i + 2) * fsi] * f[(i + 4) * fsi] -
	6924.03404832822 * f[(i + 2) * fsi] * f[(i + 5) * fsi] +
	901.155248375756 * f[(i + 2) * fsi] * f[(i + 6) * fsi] +
	19089.3249805465 * f[(i + 3) * fsi] * f[(i + 3) * fsi] -
	20664.4461791424 * f[(i + 3) * fsi] * f[(i + 4) * fsi] +
	6253.56570910972 * f[(i + 3) * fsi] * f[(i + 5) * fsi] -
	816.068383469668 * f[(i + 3) * fsi] * f[(i + 6) * fsi] +
	5612.02326667724 * f[(i + 4) * fsi] * f[(i + 4) * fsi] -
	3406.48778702496 * f[(i + 4) * fsi] * f[(i + 5) * fsi] +
	445.58477421919 * f[(i + 4) * fsi] * f[(i + 6) * fsi] +
	518.201327427861 * f[(i + 5) * fsi] * f[(i + 5) * fsi] -
	135.845449952311 * f[(i + 5) * fsi] * f[(i + 6) * fsi] +
	8.91870511033141 * f[(i + 6) * fsi] * f[(i + 6) * fsi];
      sigma2 =
	+8.91870511033141 * f[(i - 2) * fsi] * f[(i - 2) * fsi] -
	107.291821204516 * f[(i - 2) * fsi] * f[(i - 1) * fsi] +
	277.006890621306 * f[(i - 2) * fsi] * f[(i + 0) * fsi] -
	399.198237967023 * f[(i - 2) * fsi] * f[(i + 1) * fsi] +
	347.463467070642 * f[(i - 2) * fsi] * f[(i + 2) * fsi] -
	182.82658888745 * f[(i - 2) * fsi] * f[(i + 3) * fsi] +
	53.8627119593691 * f[(i - 2) * fsi] * f[(i + 4) * fsi] -
	6.85383181299153 * f[(i - 2) * fsi] * f[(i + 5) * fsi] +
	335.04033977354 * f[(i - 1) * fsi] * f[(i - 1) * fsi] -
	1774.22905245706 * f[(i - 1) * fsi] * f[(i + 0) * fsi] +
	2601.97484491219 * f[(i - 1) * fsi] * f[(i + 1) * fsi] -
	2293.25840018007 * f[(i - 1) * fsi] * f[(i + 2) * fsi] +
	1217.71486645643 * f[(i - 1) * fsi] * f[(i + 3) * fsi] -
	361.183311920333 * f[(i - 1) * fsi] * f[(i + 4) * fsi] +
	46.1921948462738 * f[(i - 1) * fsi] * f[(i + 5) * fsi] +
	2403.24289630687 * f[(i + 0) * fsi] * f[(i + 0) * fsi] -
	7175.23886432754 * f[(i + 0) * fsi] * f[(i + 1) * fsi] +
	6406.93231432228 * f[(i + 0) * fsi] * f[(i + 2) * fsi] -
	3435.42821837807 * f[(i + 0) * fsi] * f[(i + 3) * fsi] +
	1026.47873509069 * f[(i + 0) * fsi] * f[(i + 4) * fsi] -
	132.007597485334 * f[(i + 0) * fsi] * f[(i + 5) * fsi] +
	5440.58053610203 * f[(i + 1) * fsi] * f[(i + 1) * fsi] -
	9841.58822563111 * f[(i + 1) * fsi] * f[(i + 2) * fsi] +
	5330.2740359658 * f[(i + 1) * fsi] * f[(i + 3) * fsi] -
	1605.02809925414 * f[(i + 1) * fsi] * f[(i + 4) * fsi] +
	207.643474097758 * f[(i + 1) * fsi] * f[(i + 5) * fsi] +
	4502.6216168312 * f[(i + 2) * fsi] * f[(i + 2) * fsi] -
	4924.83347080903 * f[(i + 2) * fsi] * f[(i + 3) * fsi] +
	1494.60136979645 * f[(i + 2) * fsi] * f[(i + 4) * fsi] -
	194.560288231573 * f[(i + 2) * fsi] * f[(i + 5) * fsi] +
	1358.55473224437 * f[(i + 3) * fsi] * f[(i + 3) * fsi] -
	830.843311716319 * f[(i + 3) * fsi] * f[(i + 4) * fsi] +
	108.833222879904 * f[(i + 3) * fsi] * f[(i + 5) * fsi] +
	127.914395039744 * f[(i + 4) * fsi] * f[(i + 4) * fsi] -
	33.7168840352035 * f[(i + 4) * fsi] * f[(i + 5) * fsi] +
	2.23485487058274 * f[(i + 5) * fsi] * f[(i + 5) * fsi];
      sigma3 =
	+2.23485487058274 * f[(i - 3) * fsi] * f[(i - 3) * fsi] -
	28.9038461163322 * f[(i - 3) * fsi] * f[(i - 2) * fsi] +
	78.9596779063593 * f[(i - 3) * fsi] * f[(i - 1) * fsi] -
	118.296148019933 * f[(i - 3) * fsi] * f[(i + 0) * fsi] +
	105.236207783825 * f[(i - 3) * fsi] * f[(i + 1) * fsi] -
	55.7434572736934 * f[(i - 3) * fsi] * f[(i + 2) * fsi] +
	16.3186498727289 * f[(i - 3) * fsi] * f[(i + 3) * fsi] -
	2.04079389412028 * f[(i - 3) * fsi] * f[(i + 4) * fsi] +
	97.1187623236942 * f[(i - 2) * fsi] * f[(i - 2) * fsi] -
	547.061953691627 * f[(i - 2) * fsi] * f[(i - 1) * fsi] +
	839.561493253242 * f[(i - 2) * fsi] * f[(i + 0) * fsi] -
	761.319673328215 * f[(i - 2) * fsi] * f[(i + 1) * fsi] +
	409.596543732663 * f[(i - 2) * fsi] * f[(i + 2) * fsi] -
	121.468497105518 * f[(i - 2) * fsi] * f[(i + 3) * fsi] +
	15.3584086083991 * f[(i - 2) * fsi] * f[(i + 4) * fsi] +
	793.785102614737 * f[(i - 1) * fsi] * f[(i - 1) * fsi] -
	2499.75828562384 * f[(i - 1) * fsi] * f[(i + 0) * fsi] +
	2315.13502362012 * f[(i - 1) * fsi] * f[(i + 1) * fsi] -
	1267.31229245215 * f[(i - 1) * fsi] * f[(i + 2) * fsi] +
	381.255607197169 * f[(i - 1) * fsi] * f[(i + 3) * fsi] -
	48.78798218551 * f[(i - 1) * fsi] * f[(i + 4) * fsi] +
	2019.32231127564 * f[(i + 0) * fsi] * f[(i + 0) * fsi] -
	3827.93467624839 * f[(i + 0) * fsi] * f[(i + 1) * fsi] +
	2136.14046247043 * f[(i + 0) * fsi] * f[(i + 2) * fsi] -
	653.059881661548 * f[(i + 0) * fsi] * f[(i + 3) * fsi] +
	84.7024132787544 * f[(i + 0) * fsi] * f[(i + 4) * fsi] +
	1856.32621511438 * f[(i + 1) * fsi] * f[(i + 1) * fsi] -
	2115.5956853152 * f[(i + 1) * fsi] * f[(i + 2) * fsi] +
	658.5622523196 * f[(i + 1) * fsi] * f[(i + 3) * fsi] -
	86.7358790604971 * f[(i + 1) * fsi] * f[(i + 4) * fsi] +
	615.75035001057 * f[(i + 2) * fsi] * f[(i + 2) * fsi] -
	390.9897931978 * f[(i + 2) * fsi] * f[(i + 3) * fsi] +
	52.4035220146045 * f[(i + 2) * fsi] * f[(i + 4) * fsi] +
	63.3507101439102 * f[(i + 3) * fsi] * f[(i + 3) * fsi] -
	17.3197577124522 * f[(i + 3) * fsi] * f[(i + 4) * fsi] +
	1.21003447541078 * f[(i + 4) * fsi] * f[(i + 4) * fsi];
      sigma4 =
	+1.21003447541078 * f[(i - 4) * fsi] * f[(i - 4) * fsi] -
	17.3197577124522 * f[(i - 4) * fsi] * f[(i - 3) * fsi] +
	52.4035220146045 * f[(i - 4) * fsi] * f[(i - 2) * fsi] -
	86.7358790604971 * f[(i - 4) * fsi] * f[(i - 1) * fsi] +
	84.7024132787544 * f[(i - 4) * fsi] * f[(i + 0) * fsi] -
	48.78798218551 * f[(i - 4) * fsi] * f[(i + 1) * fsi] +
	15.3584086083991 * f[(i - 4) * fsi] * f[(i + 2) * fsi] -
	2.04079389412028 * f[(i - 4) * fsi] * f[(i + 3) * fsi] +
	63.3507101439102 * f[(i - 3) * fsi] * f[(i - 3) * fsi] -
	390.9897931978 * f[(i - 3) * fsi] * f[(i - 2) * fsi] +
	658.5622523196 * f[(i - 3) * fsi] * f[(i - 1) * fsi] -
	653.059881661548 * f[(i - 3) * fsi] * f[(i + 0) * fsi] +
	381.255607197169 * f[(i - 3) * fsi] * f[(i + 1) * fsi] -
	121.468497105518 * f[(i - 3) * fsi] * f[(i + 2) * fsi] +
	16.3186498727289 * f[(i - 3) * fsi] * f[(i + 3) * fsi] +
	615.75035001057 * f[(i - 2) * fsi] * f[(i - 2) * fsi] -
	2115.5956853152 * f[(i - 2) * fsi] * f[(i - 1) * fsi] +
	2136.14046247043 * f[(i - 2) * fsi] * f[(i + 0) * fsi] -
	1267.31229245215 * f[(i - 2) * fsi] * f[(i + 1) * fsi] +
	409.596543732663 * f[(i - 2) * fsi] * f[(i + 2) * fsi] -
	55.7434572736934 * f[(i - 2) * fsi] * f[(i + 3) * fsi] +
	1856.32621511438 * f[(i - 1) * fsi] * f[(i - 1) * fsi] -
	3827.93467624839 * f[(i - 1) * fsi] * f[(i + 0) * fsi] +
	2315.13502362012 * f[(i - 1) * fsi] * f[(i + 1) * fsi] -
	761.319673328215 * f[(i - 1) * fsi] * f[(i + 2) * fsi] +
	105.236207783825 * f[(i - 1) * fsi] * f[(i + 3) * fsi] +
	2019.32231127564 * f[(i + 0) * fsi] * f[(i + 0) * fsi] -
	2499.75828562384 * f[(i + 0) * fsi] * f[(i + 1) * fsi] +
	839.561493253242 * f[(i + 0) * fsi] * f[(i + 2) * fsi] -
	118.296148019933 * f[(i + 0) * fsi] * f[(i + 3) * fsi] +
	793.785102614737 * f[(i + 1) * fsi] * f[(i + 1) * fsi] -
	547.061953691627 * f[(i + 1) * fsi] * f[(i + 2) * fsi] +
	78.9596779063593 * f[(i + 1) * fsi] * f[(i + 3) * fsi] +
	97.1187623236942 * f[(i + 2) * fsi] * f[(i + 2) * fsi] -
	28.9038461163322 * f[(i + 2) * fsi] * f[(i + 3) * fsi] +
	2.23485487058274 * f[(i + 3) * fsi] * f[(i + 3) * fsi];
      sigma5 =
	+2.23485487058274 * f[(i - 5) * fsi] * f[(i - 5) * fsi] -
	33.7168840352035 * f[(i - 5) * fsi] * f[(i - 4) * fsi] +
	108.833222879904 * f[(i - 5) * fsi] * f[(i - 3) * fsi] -
	194.560288231573 * f[(i - 5) * fsi] * f[(i - 2) * fsi] +
	207.643474097758 * f[(i - 5) * fsi] * f[(i - 1) * fsi] -
	132.007597485334 * f[(i - 5) * fsi] * f[(i + 0) * fsi] +
	46.1921948462738 * f[(i - 5) * fsi] * f[(i + 1) * fsi] -
	6.85383181299153 * f[(i - 5) * fsi] * f[(i + 2) * fsi] +
	127.914395039744 * f[(i - 4) * fsi] * f[(i - 4) * fsi] -
	830.843311716319 * f[(i - 4) * fsi] * f[(i - 3) * fsi] +
	1494.60136979645 * f[(i - 4) * fsi] * f[(i - 2) * fsi] -
	1605.02809925414 * f[(i - 4) * fsi] * f[(i - 1) * fsi] +
	1026.47873509069 * f[(i - 4) * fsi] * f[(i + 0) * fsi] -
	361.183311920333 * f[(i - 4) * fsi] * f[(i + 1) * fsi] +
	53.8627119593691 * f[(i - 4) * fsi] * f[(i + 2) * fsi] +
	1358.55473224437 * f[(i - 3) * fsi] * f[(i - 3) * fsi] -
	4924.83347080903 * f[(i - 3) * fsi] * f[(i - 2) * fsi] +
	5330.2740359658 * f[(i - 3) * fsi] * f[(i - 1) * fsi] -
	3435.42821837807 * f[(i - 3) * fsi] * f[(i + 0) * fsi] +
	1217.71486645643 * f[(i - 3) * fsi] * f[(i + 1) * fsi] -
	182.82658888745 * f[(i - 3) * fsi] * f[(i + 2) * fsi] +
	4502.6216168312 * f[(i - 2) * fsi] * f[(i - 2) * fsi] -
	9841.58822563111 * f[(i - 2) * fsi] * f[(i - 1) * fsi] +
	6406.93231432228 * f[(i - 2) * fsi] * f[(i + 0) * fsi] -
	2293.25840018007 * f[(i - 2) * fsi] * f[(i + 1) * fsi] +
	347.463467070642 * f[(i - 2) * fsi] * f[(i + 2) * fsi] +
	5440.58053610203 * f[(i - 1) * fsi] * f[(i - 1) * fsi] -
	7175.23886432754 * f[(i - 1) * fsi] * f[(i + 0) * fsi] +
	2601.97484491219 * f[(i - 1) * fsi] * f[(i + 1) * fsi] -
	399.198237967023 * f[(i - 1) * fsi] * f[(i + 2) * fsi] +
	2403.24289630687 * f[(i + 0) * fsi] * f[(i + 0) * fsi] -
	1774.22905245706 * f[(i + 0) * fsi] * f[(i + 1) * fsi] +
	277.006890621306 * f[(i + 0) * fsi] * f[(i + 2) * fsi] +
	335.04033977354 * f[(i + 1) * fsi] * f[(i + 1) * fsi] -
	107.291821204516 * f[(i + 1) * fsi] * f[(i + 2) * fsi] +
	8.91870511033141 * f[(i + 2) * fsi] * f[(i + 2) * fsi];
      sigma6 =
	+8.91870511033141 * f[(i - 6) * fsi] * f[(i - 6) * fsi] -
	135.845449952311 * f[(i - 6) * fsi] * f[(i - 5) * fsi] +
	445.58477421919 * f[(i - 6) * fsi] * f[(i - 4) * fsi] -
	816.068383469668 * f[(i - 6) * fsi] * f[(i - 3) * fsi] +
	901.155248375756 * f[(i - 6) * fsi] * f[(i - 2) * fsi] -
	599.696734390095 * f[(i - 6) * fsi] * f[(i - 1) * fsi] +
	222.440595557253 * f[(i - 6) * fsi] * f[(i + 0) * fsi] -
	35.407460560787 * f[(i - 6) * fsi] * f[(i + 1) * fsi] +
	518.201327427861 * f[(i - 5) * fsi] * f[(i - 5) * fsi] -
	3406.48778702496 * f[(i - 5) * fsi] * f[(i - 4) * fsi] +
	6253.56570910972 * f[(i - 5) * fsi] * f[(i - 3) * fsi] -
	6924.03404832822 * f[(i - 5) * fsi] * f[(i - 2) * fsi] +
	4621.402767691 * f[(i - 5) * fsi] * f[(i - 1) * fsi] -
	1719.62507117959 * f[(i - 5) * fsi] * f[(i + 0) * fsi] +
	274.621224828637 * f[(i - 5) * fsi] * f[(i + 1) * fsi] +
	5612.02326667724 * f[(i - 4) * fsi] * f[(i - 4) * fsi] -
	20664.4461791424 * f[(i - 4) * fsi] * f[(i - 3) * fsi] +
	22956.5584871618 * f[(i - 4) * fsi] * f[(i - 2) * fsi] -
	15380.2247924521 * f[(i - 4) * fsi] * f[(i - 1) * fsi] +
	5746.65947583143 * f[(i - 4) * fsi] * f[(i + 0) * fsi] -
	921.690511947415 * f[(i - 4) * fsi] * f[(i + 1) * fsi] +
	19089.3249805465 * f[(i - 3) * fsi] * f[(i - 3) * fsi] -
	42591.6661577299 * f[(i - 3) * fsi] * f[(i - 2) * fsi] +
	28675.0021841139 * f[(i - 3) * fsi] * f[(i - 1) * fsi] -
	10772.9570807356 * f[(i - 3) * fsi] * f[(i + 0) * fsi] +
	1737.9199467609 * f[(i - 3) * fsi] * f[(i + 1) * fsi] +
	23881.8339625102 * f[(i - 2) * fsi] * f[(i - 2) * fsi] -
	32362.4054769819 * f[(i - 2) * fsi] * f[(i - 1) * fsi] +
	12248.796925352 * f[(i - 2) * fsi] * f[(i + 0) * fsi] -
	1992.07290287002 * f[(i - 2) * fsi] * f[(i + 1) * fsi] +
	11054.5384359481 * f[(i - 1) * fsi] * f[(i - 1) * fsi] -
	8454.36155245706 * f[(i - 1) * fsi] * f[(i + 0) * fsi] +
	1391.20673258008 * f[(i - 1) * fsi] * f[(i + 1) * fsi] +
	1639.31476541011 * f[(i + 0) * fsi] * f[(i + 0) * fsi] -
	549.582823188643 * f[(i + 0) * fsi] * f[(i + 1) * fsi] +
	47.5028971986251 * f[(i + 1) * fsi] * f[(i + 1) * fsi];
      sigma7 =
	+47.5028971986251 * f[(i - 7) * fsi] * f[(i - 7) * fsi] -
	724.638894617214 * f[(i - 7) * fsi] * f[(i - 6) * fsi] +
	2385.54101829437 * f[(i - 7) * fsi] * f[(i - 5) * fsi] -
	4398.63397429859 * f[(i - 7) * fsi] * f[(i - 4) * fsi] +
	4912.48566104661 * f[(i - 7) * fsi] * f[(i - 3) * fsi] -
	3328.25158337599 * f[(i - 7) * fsi] * f[(i - 2) * fsi] +
	1268.95551054292 * f[(i - 7) * fsi] * f[(i - 1) * fsi] -
	210.463531989358 * f[(i - 7) * fsi] * f[(i + 0) * fsi] +
	2765.84444133604 * f[(i - 6) * fsi] * f[(i - 6) * fsi] -
	18228.7647006052 * f[(i - 6) * fsi] * f[(i - 5) * fsi] +
	33651.8387772039 * f[(i - 6) * fsi] * f[(i - 4) * fsi] -
	37637.4314325875 * f[(i - 6) * fsi] * f[(i - 3) * fsi] +
	25544.3501239796 * f[(i - 6) * fsi] * f[(i - 2) * fsi] -
	9759.93192303144 * f[(i - 6) * fsi] * f[(i - 1) * fsi] +
	1622.88916698582 * f[(i - 6) * fsi] * f[(i + 0) * fsi] +
	30071.0784359481 * f[(i - 5) * fsi] * f[(i - 5) * fsi] -
	111189.450476982 * f[(i - 5) * fsi] * f[(i - 4) * fsi] +
	124579.67848041 * f[(i - 5) * fsi] * f[(i - 3) * fsi] -
	84736.2897924522 * f[(i - 5) * fsi] * f[(i - 2) * fsi] +
	32462.762767691 * f[(i - 5) * fsi] * f[(i - 1) * fsi] -
	5415.63416825253 * f[(i - 5) * fsi] * f[(i + 0) * fsi] +
	102966.44021251 * f[(i - 4) * fsi] * f[(i - 4) * fsi] -
	231245.307361434 * f[(i - 4) * fsi] * f[(i - 3) * fsi] +
	157723.978487162 * f[(i - 4) * fsi] * f[(i - 2) * fsi] -
	60634.3990483282 * f[(i - 4) * fsi] * f[(i - 1) * fsi] +
	10159.0931716562 * f[(i - 4) * fsi] * f[(i + 0) * fsi] +
	130199.124980546 * f[(i - 3) * fsi] * f[(i - 3) * fsi] -
	178245.759975439 * f[(i - 3) * fsi] * f[(i - 2) * fsi] +
	68840.1294128134 * f[(i - 3) * fsi] * f[(i - 1) * fsi] -
	11602.0447459035 * f[(i - 3) * fsi] * f[(i + 0) * fsi] +
	61294.8370166772 * f[(i - 2) * fsi] * f[(i - 2) * fsi] -
	47645.872787025 * f[(i - 2) * fsi] * f[(i - 1) * fsi] +
	8098.17149379591 * f[(i - 2) * fsi] * f[(i + 0) * fsi] +
	9343.02132742786 * f[(i - 1) * fsi] * f[(i - 1) * fsi] -
	3217.68658751845 * f[(i - 1) * fsi] * f[(i + 0) * fsi] +
	282.837600612977 * f[(i + 0) * fsi] * f[(i + 0) * fsi];
      sigma[i * ssi + 0 * ssr] = sigma0;
      sigma[i * ssi + 1 * ssr] = sigma1;
      sigma[i * ssi + 2 * ssr] = sigma2;
      sigma[i * ssi + 3 * ssr] = sigma3;
      sigma[i * ssi + 4 * ssr] = sigma4;
      sigma[i * ssi + 5 * ssr] = sigma5;
      sigma[i * ssi + 6 * ssr] = sigma6;
      sigma[i * ssi + 7 * ssr] = sigma7;
    }
}

PyObject *
py_smoothness008 (PyObject * self, PyObject * args)
{
  double *sigma, *f;
  PyArrayObject *f_py, *sigma_py;

  long int n;
  int ssi, ssr, fsi;

  /* parse options */

  if (!PyArg_ParseTuple (args, "OO", &f_py, &sigma_py))
    return NULL;

  if (sigma_py->nd != 2 || sigma_py->descr->type_num != PyArray_DOUBLE)
    {
      PyErr_SetString (PyExc_ValueError, "sigma must be two-dimensional and of type float");
      return NULL;
    }

  if (f_py->nd != 1 || f_py->descr->type_num != PyArray_DOUBLE)
    {
      PyErr_SetString (PyExc_ValueError, "f must be one-dimensional and of type float");
      return NULL;
    }

  /* get data, n, strides */
  sigma = (double *) PyArray_DATA (sigma_py);
  f = (double *) PyArray_DATA (f_py);

  n = PyArray_DIM (f_py, 0);

  ssi = sigma_py->strides[0] / sizeof (double);
  ssr = sigma_py->strides[1] / sizeof (double);

  fsi = f_py->strides[0] / sizeof (double);

  smoothness008 (f, n, fsi, sigma, ssi, ssr);

  Py_INCREF (Py_None);
  return Py_None;
}
