#include <Python.h>
#include <numpy/ndarrayobject.h>

void
smoothness006 (const double *restrict f, int n, int fsi, double *restrict sigma, int ssi, int ssr)
{
  int i;
  double sigma0, sigma1, sigma2, sigma3, sigma4, sigma5;
  for (i = 6; i < n - 6; i++)
    {
      sigma0 =
	((+50.8449983465608) * (f[(i + 0) * fsi])) * (f[(i + 0) * fsi]) +
	((-392.364947089947) * (f[(i + 0) * fsi])) * (f[(i + 1) * fsi]) +
	((+630.016005291005) * (f[(i + 0) * fsi])) * (f[(i + 2) * fsi]) +
	((-524.091633597884) * (f[(i + 0) * fsi])) * (f[(i + 3) * fsi]) +
	((+223.711722883598) * (f[(i + 0) * fsi])) * (f[(i + 4) * fsi]) +
	((-38.9611441798942) * (f[(i + 0) * fsi])) * (f[(i + 5) * fsi]) +
	((+784.153745039683) * (f[(i + 1) * fsi])) * (f[(i + 1) * fsi]) +
	((-2577.47390873016) * (f[(i + 1) * fsi])) * (f[(i + 2) * fsi]) +
	((+2173.45958994709) * (f[(i + 1) * fsi])) * (f[(i + 3) * fsi]) +
	((-935.902678571429) * (f[(i + 1) * fsi])) * (f[(i + 4) * fsi]) +
	((+163.974454365079) * (f[(i + 1) * fsi])) * (f[(i + 5) * fsi]) +
	((+2153.15287698413) * (f[(i + 2) * fsi])) * (f[(i + 2) * fsi]) +
	((-3670.6671957672) * (f[(i + 2) * fsi])) * (f[(i + 3) * fsi]) +
	((+1592.23273809524) * (f[(i + 2) * fsi])) * (f[(i + 4) * fsi]) +
	((-280.413392857143) * (f[(i + 2) * fsi])) * (f[(i + 5) * fsi]) +
	((+1577.03019179894) * (f[(i + 3) * fsi])) * (f[(i + 3) * fsi]) +
	((-1376.16603835979) * (f[(i + 3) * fsi])) * (f[(i + 4) * fsi]) +
	((+243.404894179894) * (f[(i + 3) * fsi])) * (f[(i + 5) * fsi]) +
	((+301.592981150794) * (f[(i + 4) * fsi])) * (f[(i + 4) * fsi]) +
	((-107.061706349206) * (f[(i + 4) * fsi])) * (f[(i + 5) * fsi]) +
	((+9.52844742063492) * (f[(i + 5) * fsi])) * (f[(i + 5) * fsi]);
      sigma1 =
	((+9.52844742063492) * (f[(i - 1) * fsi])) * (f[(i - 1) * fsi]) +
	((-75.3802248677249) * (f[(i - 1) * fsi])) * (f[(i + 0) * fsi]) +
	((+121.878968253968) * (f[(i - 1) * fsi])) * (f[(i + 1) * fsi]) +
	((-100.724503968254) * (f[(i - 1) * fsi])) * (f[(i + 2) * fsi]) +
	((+42.4485284391534) * (f[(i - 1) * fsi])) * (f[(i + 3) * fsi]) +
	((-7.2796626984127) * (f[(i - 1) * fsi])) * (f[(i + 4) * fsi]) +
	((+160.102240410053) * (f[(i + 0) * fsi])) * (f[(i + 0) * fsi]) +
	((-539.221593915344) * (f[(i + 0) * fsi])) * (f[(i + 1) * fsi]) +
	((+455.140145502646) * (f[(i + 0) * fsi])) * (f[(i + 2) * fsi]) +
	((-194.365641534392) * (f[(i + 0) * fsi])) * (f[(i + 3) * fsi]) +
	((+33.622833994709) * (f[(i + 0) * fsi])) * (f[(i + 4) * fsi]) +
	((+468.437599206349) * (f[(i + 1) * fsi])) * (f[(i + 1) * fsi]) +
	((-808.852380952381) * (f[(i + 1) * fsi])) * (f[(i + 2) * fsi]) +
	((+350.570701058201) * (f[(i + 1) * fsi])) * (f[(i + 3) * fsi]) +
	((-61.2508928571429) * (f[(i + 1) * fsi])) * (f[(i + 4) * fsi]) +
	((+356.263988095238) * (f[(i + 2) * fsi])) * (f[(i + 2) * fsi]) +
	((-313.436871693122) * (f[(i + 2) * fsi])) * (f[(i + 3) * fsi]) +
	((+55.3456349206349) * (f[(i + 2) * fsi])) * (f[(i + 4) * fsi]) +
	((+69.8574487433862) * (f[(i + 3) * fsi])) * (f[(i + 3) * fsi]) +
	((-24.9316137566138) * (f[(i + 3) * fsi])) * (f[(i + 4) * fsi]) +
	((+2.2468501984127) * (f[(i + 4) * fsi])) * (f[(i + 4) * fsi]);
      sigma2 =
	((+2.2468501984127) * (f[(i - 2) * fsi])) * (f[(i - 2) * fsi]) +
	((-19.6825396825397) * (f[(i - 2) * fsi])) * (f[(i - 1) * fsi]) +
	((+33.782671957672) * (f[(i - 2) * fsi])) * (f[(i + 0) * fsi]) +
	((-28.6231150793651) * (f[(i - 2) * fsi])) * (f[(i + 1) * fsi]) +
	((+12.059871031746) * (f[(i - 2) * fsi])) * (f[(i + 2) * fsi]) +
	((-2.03058862433862) * (f[(i - 2) * fsi])) * (f[(i + 3) * fsi]) +
	((+46.7370783730159) * (f[(i - 1) * fsi])) * (f[(i - 1) * fsi]) +
	((-168.881316137566) * (f[(i - 1) * fsi])) * (f[(i + 0) * fsi]) +
	((+148.024404761905) * (f[(i - 1) * fsi])) * (f[(i + 1) * fsi]) +
	((-63.8887896825397) * (f[(i - 1) * fsi])) * (f[(i + 2) * fsi]) +
	((+10.954083994709) * (f[(i - 1) * fsi])) * (f[(i + 3) * fsi]) +
	((+161.301025132275) * (f[(i + 0) * fsi])) * (f[(i + 0) * fsi]) +
	((-296.11164021164) * (f[(i + 0) * fsi])) * (f[(i + 1) * fsi]) +
	((+131.695701058201) * (f[(i + 0) * fsi])) * (f[(i + 2) * fsi]) +
	((-23.0874669312169) * (f[(i + 0) * fsi])) * (f[(i + 3) * fsi]) +
	((+142.159821428571) * (f[(i + 1) * fsi])) * (f[(i + 1) * fsi]) +
	((-131.286408730159) * (f[(i + 1) * fsi])) * (f[(i + 2) * fsi]) +
	((+23.6771164021164) * (f[(i + 1) * fsi])) * (f[(i + 3) * fsi]) +
	((+31.6207589285714) * (f[(i + 2) * fsi])) * (f[(i + 2) * fsi]) +
	((-11.8218915343915) * (f[(i + 2) * fsi])) * (f[(i + 3) * fsi]) +
	((+1.15437334656085) * (f[(i + 3) * fsi])) * (f[(i + 3) * fsi]);
      sigma3 =
	((+1.15437334656085) * (f[(i - 3) * fsi])) * (f[(i - 3) * fsi]) +
	((-11.8218915343915) * (f[(i - 3) * fsi])) * (f[(i - 2) * fsi]) +
	((+23.6771164021164) * (f[(i - 3) * fsi])) * (f[(i - 1) * fsi]) +
	((-23.0874669312169) * (f[(i - 3) * fsi])) * (f[(i + 0) * fsi]) +
	((+10.954083994709) * (f[(i - 3) * fsi])) * (f[(i + 1) * fsi]) +
	((-2.03058862433862) * (f[(i - 3) * fsi])) * (f[(i + 2) * fsi]) +
	((+31.6207589285714) * (f[(i - 2) * fsi])) * (f[(i - 2) * fsi]) +
	((-131.286408730159) * (f[(i - 2) * fsi])) * (f[(i - 1) * fsi]) +
	((+131.695701058201) * (f[(i - 2) * fsi])) * (f[(i + 0) * fsi]) +
	((-63.8887896825397) * (f[(i - 2) * fsi])) * (f[(i + 1) * fsi]) +
	((+12.059871031746) * (f[(i - 2) * fsi])) * (f[(i + 2) * fsi]) +
	((+142.159821428571) * (f[(i - 1) * fsi])) * (f[(i - 1) * fsi]) +
	((-296.11164021164) * (f[(i - 1) * fsi])) * (f[(i + 0) * fsi]) +
	((+148.024404761905) * (f[(i - 1) * fsi])) * (f[(i + 1) * fsi]) +
	((-28.6231150793651) * (f[(i - 1) * fsi])) * (f[(i + 2) * fsi]) +
	((+161.301025132275) * (f[(i + 0) * fsi])) * (f[(i + 0) * fsi]) +
	((-168.881316137566) * (f[(i + 0) * fsi])) * (f[(i + 1) * fsi]) +
	((+33.782671957672) * (f[(i + 0) * fsi])) * (f[(i + 2) * fsi]) +
	((+46.7370783730159) * (f[(i + 1) * fsi])) * (f[(i + 1) * fsi]) +
	((-19.6825396825397) * (f[(i + 1) * fsi])) * (f[(i + 2) * fsi]) +
	((+2.2468501984127) * (f[(i + 2) * fsi])) * (f[(i + 2) * fsi]);
      sigma4 =
	((+2.2468501984127) * (f[(i - 4) * fsi])) * (f[(i - 4) * fsi]) +
	((-24.9316137566138) * (f[(i - 4) * fsi])) * (f[(i - 3) * fsi]) +
	((+55.3456349206349) * (f[(i - 4) * fsi])) * (f[(i - 2) * fsi]) +
	((-61.2508928571429) * (f[(i - 4) * fsi])) * (f[(i - 1) * fsi]) +
	((+33.622833994709) * (f[(i - 4) * fsi])) * (f[(i + 0) * fsi]) +
	((-7.2796626984127) * (f[(i - 4) * fsi])) * (f[(i + 1) * fsi]) +
	((+69.8574487433862) * (f[(i - 3) * fsi])) * (f[(i - 3) * fsi]) +
	((-313.436871693122) * (f[(i - 3) * fsi])) * (f[(i - 2) * fsi]) +
	((+350.570701058201) * (f[(i - 3) * fsi])) * (f[(i - 1) * fsi]) +
	((-194.365641534392) * (f[(i - 3) * fsi])) * (f[(i + 0) * fsi]) +
	((+42.4485284391534) * (f[(i - 3) * fsi])) * (f[(i + 1) * fsi]) +
	((+356.263988095238) * (f[(i - 2) * fsi])) * (f[(i - 2) * fsi]) +
	((-808.852380952381) * (f[(i - 2) * fsi])) * (f[(i - 1) * fsi]) +
	((+455.140145502646) * (f[(i - 2) * fsi])) * (f[(i + 0) * fsi]) +
	((-100.724503968254) * (f[(i - 2) * fsi])) * (f[(i + 1) * fsi]) +
	((+468.437599206349) * (f[(i - 1) * fsi])) * (f[(i - 1) * fsi]) +
	((-539.221593915344) * (f[(i - 1) * fsi])) * (f[(i + 0) * fsi]) +
	((+121.878968253968) * (f[(i - 1) * fsi])) * (f[(i + 1) * fsi]) +
	((+160.102240410053) * (f[(i + 0) * fsi])) * (f[(i + 0) * fsi]) +
	((-75.3802248677249) * (f[(i + 0) * fsi])) * (f[(i + 1) * fsi]) +
	((+9.52844742063492) * (f[(i + 1) * fsi])) * (f[(i + 1) * fsi]);
      sigma5 =
	((+9.52844742063492) * (f[(i - 5) * fsi])) * (f[(i - 5) * fsi]) +
	((-107.061706349206) * (f[(i - 5) * fsi])) * (f[(i - 4) * fsi]) +
	((+243.404894179894) * (f[(i - 5) * fsi])) * (f[(i - 3) * fsi]) +
	((-280.413392857143) * (f[(i - 5) * fsi])) * (f[(i - 2) * fsi]) +
	((+163.974454365079) * (f[(i - 5) * fsi])) * (f[(i - 1) * fsi]) +
	((-38.9611441798942) * (f[(i - 5) * fsi])) * (f[(i + 0) * fsi]) +
	((+301.592981150794) * (f[(i - 4) * fsi])) * (f[(i - 4) * fsi]) +
	((-1376.16603835979) * (f[(i - 4) * fsi])) * (f[(i - 3) * fsi]) +
	((+1592.23273809524) * (f[(i - 4) * fsi])) * (f[(i - 2) * fsi]) +
	((-935.902678571429) * (f[(i - 4) * fsi])) * (f[(i - 1) * fsi]) +
	((+223.711722883598) * (f[(i - 4) * fsi])) * (f[(i + 0) * fsi]) +
	((+1577.03019179894) * (f[(i - 3) * fsi])) * (f[(i - 3) * fsi]) +
	((-3670.6671957672) * (f[(i - 3) * fsi])) * (f[(i - 2) * fsi]) +
	((+2173.45958994709) * (f[(i - 3) * fsi])) * (f[(i - 1) * fsi]) +
	((-524.091633597884) * (f[(i - 3) * fsi])) * (f[(i + 0) * fsi]) +
	((+2153.15287698413) * (f[(i - 2) * fsi])) * (f[(i - 2) * fsi]) +
	((-2577.47390873016) * (f[(i - 2) * fsi])) * (f[(i - 1) * fsi]) +
	((+630.016005291005) * (f[(i - 2) * fsi])) * (f[(i + 0) * fsi]) +
	((+784.153745039683) * (f[(i - 1) * fsi])) * (f[(i - 1) * fsi]) +
	((-392.364947089947) * (f[(i - 1) * fsi])) * (f[(i + 0) * fsi]) +
	((+50.8449983465608) * (f[(i + 0) * fsi])) * (f[(i + 0) * fsi]);
      sigma[i * ssi + 0 * ssr] = sigma0;
      sigma[i * ssi + 1 * ssr] = sigma1;
      sigma[i * ssi + 2 * ssr] = sigma2;
      sigma[i * ssi + 3 * ssr] = sigma3;
      sigma[i * ssi + 4 * ssr] = sigma4;
      sigma[i * ssi + 5 * ssr] = sigma5;
    }
}

PyObject *
py_smoothness006 (PyObject * self, PyObject * args)
{
  double *sigma, *f;
  PyArrayObject *f_py, *sigma_py;

  long int n;
  int ssi, ssr, fsi;

  /* parse options */

  if (!PyArg_ParseTuple (args, "OO", &f_py, &sigma_py))
    return NULL;

  if (sigma_py->nd != 2 || sigma_py->descr->type_num != PyArray_DOUBLE)
    {
      PyErr_SetString (PyExc_ValueError, "sigma must be two-dimensional and of type float");
      return NULL;
    }

  if (f_py->nd != 1 || f_py->descr->type_num != PyArray_DOUBLE)
    {
      PyErr_SetString (PyExc_ValueError, "f must be one-dimensional and of type float");
      return NULL;
    }

  /* get data, n, strides */
  sigma = (double *) PyArray_DATA (sigma_py);
  f = (double *) PyArray_DATA (f_py);

  n = PyArray_DIM (f_py, 0);

  ssi = sigma_py->strides[0] / sizeof (double);
  ssr = sigma_py->strides[1] / sizeof (double);

  fsi = f_py->strides[0] / sizeof (double);

  smoothness006 (f, n, fsi, sigma, ssi, ssr);

  Py_INCREF (Py_None);
  return Py_None;
}
