# Unicode property and category maps.

from unicode import CodePointSet

# Unicode code blocks: 96 blocks
BlockMap = {
  'AlphabeticPresentationForms' : CodePointSet(
     (0x00fb00, 0x00fb4f),
  ),
  'Arabic' : CodePointSet(
     (0x000600, 0x0006ff),
  ),
  'ArabicPresentationForms-A' : CodePointSet(
     (0x00fb50, 0x00fdff),
  ),
  'ArabicPresentationForms-B' : CodePointSet(
     (0x00fe70, 0x00fefe),
  ),
  'Armenian' : CodePointSet(
     (0x000530, 0x00058f),
  ),
  'Arrows' : CodePointSet(
     (0x002190, 0x0021ff),
  ),
  'BasicLatin' : CodePointSet(
     (0x000000, 0x00007f),
  ),
  'Bengali' : CodePointSet(
     (0x000980, 0x0009ff),
  ),
  'BlockElements' : CodePointSet(
     (0x002580, 0x00259f),
  ),
  'Bopomofo' : CodePointSet(
     (0x003100, 0x00312f),
  ),
  'BopomofoExtended' : CodePointSet(
     (0x0031a0, 0x0031bf),
  ),
  'BoxDrawing' : CodePointSet(
     (0x002500, 0x00257f),
  ),
  'BraillePatterns' : CodePointSet(
     (0x002800, 0x0028ff),
  ),
  'ByzantineMusicalSymbols' : CodePointSet(
     (0x01d000, 0x01d0ff),
  ),
  'CJKCompatibility' : CodePointSet(
     (0x003300, 0x0033ff),
  ),
  'CJKCompatibilityForms' : CodePointSet(
     (0x00fe30, 0x00fe4f),
  ),
  'CJKCompatibilityIdeographs' : CodePointSet(
     (0x00f900, 0x00faff),
  ),
  'CJKCompatibilityIdeographsSupplement' : CodePointSet(
     (0x02f800, 0x02fa1f),
  ),
  'CJKRadicalsSupplement' : CodePointSet(
     (0x002e80, 0x002eff),
  ),
  'CJKSymbolsandPunctuation' : CodePointSet(
     (0x003000, 0x00303f),
  ),
  'CJKUnifiedIdeographs' : CodePointSet(
     (0x004e00, 0x009fff),
  ),
  'CJKUnifiedIdeographsExtensionA' : CodePointSet(
     (0x003400, 0x004db5),
  ),
  'CJKUnifiedIdeographsExtensionB' : CodePointSet(
     (0x020000, 0x02a6d6),
  ),
  'Cherokee' : CodePointSet(
     (0x0013a0, 0x0013ff),
  ),
  'CombiningDiacriticalMarks' : CodePointSet(
     (0x000300, 0x00036f),
  ),
  'CombiningHalfMarks' : CodePointSet(
     (0x00fe20, 0x00fe2f),
  ),
  'CombiningMarksforSymbols' : CodePointSet(
     (0x0020d0, 0x0020ff),
  ),
  'ControlPictures' : CodePointSet(
     (0x002400, 0x00243f),
  ),
  'CurrencySymbols' : CodePointSet(
     (0x0020a0, 0x0020cf),
  ),
  'Cyrillic' : CodePointSet(
     (0x000400, 0x0004ff),
  ),
  'Deseret' : CodePointSet(
     (0x010400, 0x01044f),
  ),
  'Devanagari' : CodePointSet(
     (0x000900, 0x00097f),
  ),
  'Dingbats' : CodePointSet(
     (0x002700, 0x0027bf),
  ),
  'EnclosedAlphanumerics' : CodePointSet(
     (0x002460, 0x0024ff),
  ),
  'EnclosedCJKLettersandMonths' : CodePointSet(
     (0x003200, 0x0032ff),
  ),
  'Ethiopic' : CodePointSet(
     (0x001200, 0x00137f),
  ),
  'GeneralPunctuation' : CodePointSet(
     (0x002000, 0x00206f),
  ),
  'GeometricShapes' : CodePointSet(
     (0x0025a0, 0x0025ff),
  ),
  'Georgian' : CodePointSet(
     (0x0010a0, 0x0010ff),
  ),
  'Gothic' : CodePointSet(
     (0x010330, 0x01034f),
  ),
  'Greek' : CodePointSet(
     (0x000370, 0x0003ff),
  ),
  'GreekExtended' : CodePointSet(
     (0x001f00, 0x001fff),
  ),
  'Gujarati' : CodePointSet(
     (0x000a80, 0x000aff),
  ),
  'Gurmukhi' : CodePointSet(
     (0x000a00, 0x000a7f),
  ),
  'HalfwidthandFullwidthForms' : CodePointSet(
     (0x00ff00, 0x00ffef),
  ),
  'HangulCompatibilityJamo' : CodePointSet(
     (0x003130, 0x00318f),
  ),
  'HangulJamo' : CodePointSet(
     (0x001100, 0x0011ff),
  ),
  'HangulSyllables' : CodePointSet(
     (0x00ac00, 0x00d7a3),
  ),
  'Hebrew' : CodePointSet(
     (0x000590, 0x0005ff),
  ),
  'HighPrivateUseSurrogates' : CodePointSet(
     (0x00db80, 0x00dbff),
  ),
  'HighSurrogates' : CodePointSet(
     (0x00d800, 0x00db7f),
  ),
  'Hiragana' : CodePointSet(
     (0x003040, 0x00309f),
  ),
  'IPAExtensions' : CodePointSet(
     (0x000250, 0x0002af),
  ),
  'IdeographicDescriptionCharacters' : CodePointSet(
     (0x002ff0, 0x002fff),
  ),
  'Kanbun' : CodePointSet(
     (0x003190, 0x00319f),
  ),
  'KangxiRadicals' : CodePointSet(
     (0x002f00, 0x002fdf),
  ),
  'Kannada' : CodePointSet(
     (0x000c80, 0x000cff),
  ),
  'Katakana' : CodePointSet(
     (0x0030a0, 0x0030ff),
  ),
  'Khmer' : CodePointSet(
     (0x001780, 0x0017ff),
  ),
  'Lao' : CodePointSet(
     (0x000e80, 0x000eff),
  ),
  'Latin-1Supplement' : CodePointSet(
     (0x000080, 0x0000ff),
  ),
  'LatinExtended-A' : CodePointSet(
     (0x000100, 0x00017f),
  ),
  'LatinExtended-B' : CodePointSet(
     (0x000180, 0x00024f),
  ),
  'LatinExtendedAdditional' : CodePointSet(
     (0x001e00, 0x001eff),
  ),
  'LetterlikeSymbols' : CodePointSet(
     (0x002100, 0x00214f),
  ),
  'LowSurrogates' : CodePointSet(
     (0x00dc00, 0x00dfff),
  ),
  'Malayalam' : CodePointSet(
     (0x000d00, 0x000d7f),
  ),
  'MathematicalAlphanumericSymbols' : CodePointSet(
     (0x01d400, 0x01d7ff),
  ),
  'MathematicalOperators' : CodePointSet(
     (0x002200, 0x0022ff),
  ),
  'MiscellaneousSymbols' : CodePointSet(
     (0x002600, 0x0026ff),
  ),
  'MiscellaneousTechnical' : CodePointSet(
     (0x002300, 0x0023ff),
  ),
  'Mongolian' : CodePointSet(
     (0x001800, 0x0018af),
  ),
  'MusicalSymbols' : CodePointSet(
     (0x01d100, 0x01d1ff),
  ),
  'Myanmar' : CodePointSet(
     (0x001000, 0x00109f),
  ),
  'NumberForms' : CodePointSet(
     (0x002150, 0x00218f),
  ),
  'Ogham' : CodePointSet(
     (0x001680, 0x00169f),
  ),
  'OldItalic' : CodePointSet(
     (0x010300, 0x01032f),
  ),
  'OpticalCharacterRecognition' : CodePointSet(
     (0x002440, 0x00245f),
  ),
  'Oriya' : CodePointSet(
     (0x000b00, 0x000b7f),
  ),
  'PrivateUse' : CodePointSet(
     (0x00e000, 0x00f8ff), (0x0f0000, 0x0ffffd), (0x100000, 0x10fffd),
  ),
  'Runic' : CodePointSet(
     (0x0016a0, 0x0016ff),
  ),
  'Sinhala' : CodePointSet(
     (0x000d80, 0x000dff),
  ),
  'SmallFormVariants' : CodePointSet(
     (0x00fe50, 0x00fe6f),
  ),
  'SpacingModifierLetters' : CodePointSet(
     (0x0002b0, 0x0002ff),
  ),
  'Specials' : CodePointSet(
     (0x00feff, 0x00feff), (0x00fff0, 0x00fffd),
  ),
  'SuperscriptsandSubscripts' : CodePointSet(
     (0x002070, 0x00209f),
  ),
  'Syriac' : CodePointSet(
     (0x000700, 0x00074f),
  ),
  'Tags' : CodePointSet(
     (0x0e0000, 0x0e007f),
  ),
  'Tamil' : CodePointSet(
     (0x000b80, 0x000bff),
  ),
  'Telugu' : CodePointSet(
     (0x000c00, 0x000c7f),
  ),
  'Thaana' : CodePointSet(
     (0x000780, 0x0007bf),
  ),
  'Thai' : CodePointSet(
     (0x000e00, 0x000e7f),
  ),
  'Tibetan' : CodePointSet(
     (0x000f00, 0x000fff),
  ),
  'UnifiedCanadianAboriginalSyllabics' : CodePointSet(
     (0x001400, 0x00167f),
  ),
  'YiRadicals' : CodePointSet(
     (0x00a490, 0x00a4cf),
  ),
  'YiSyllables' : CodePointSet(
     (0x00a000, 0x00a48f),
  ),
  }
# Unicode general category properties: 36 properties
PropertyMap = {
  # C: 200 codepoint markers (*not* codepoints)
  'C'  : CodePointSet([
           (0x000000, 0x00001f), (0x00007f, 0x00009f), (0x00070f, 0x00070f),
           (0x00180b, 0x00180e), (0x00200c, 0x00200f), (0x00202a, 0x00202e),
           (0x00206a, 0x00206f), (0x00d800, 0x00db7f), (0x00db80, 0x00dbff),
           (0x00dc00, 0x00dfff), (0x00e000, 0x00f8ff), (0x00feff, 0x00feff),
           (0x00fff9, 0x00fffb), (0x01d173, 0x01d17a), (0x0e0001, 0x0e0001),
           (0x0e0020, 0x0e007f), (0x0f0000, 0x0ffffd), (0x100000, 0x10fffd),
         ]),
  # Cc: 65 codepoint markers (*not* codepoints)
  'Cc' : CodePointSet([
           (0x000000, 0x00001f), (0x00007f, 0x00009f),
         ]),
  # Cf: 129 codepoint markers (*not* codepoints)
  'Cf' : CodePointSet([
           (0x00070f, 0x00070f), (0x00180b, 0x00180e), (0x00200c, 0x00200f),
           (0x00202a, 0x00202e), (0x00206a, 0x00206f), (0x00feff, 0x00feff),
           (0x00fff9, 0x00fffb), (0x01d173, 0x01d17a), (0x0e0001, 0x0e0001),
           (0x0e0020, 0x0e007f),
         ]),
  # Co: 3 codepoint markers (*not* codepoints)
  'Co' : CodePointSet([
           (0x00e000, 0x00f8ff), (0x0f0000, 0x0ffffd), (0x100000, 0x10fffd),
         ]),
  # Cs: 3 codepoint markers (*not* codepoints)
  'Cs' : CodePointSet([
           (0x00d800, 0x00db7f), (0x00db80, 0x00dbff), (0x00dc00, 0x00dfff),
         ]),
  # L: 8399 codepoint markers (*not* codepoints)
  'L'  : CodePointSet([
           (0x000041, 0x00005a), (0x000061, 0x00007a), (0x0000aa, 0x0000aa),
           (0x0000b5, 0x0000b5), (0x0000ba, 0x0000ba), (0x0000c0, 0x0000d6),
           (0x0000d8, 0x0000f6), (0x0000f8, 0x00021f), (0x000222, 0x000233),
           (0x000250, 0x0002ad), (0x0002b0, 0x0002b8), (0x0002bb, 0x0002c1),
           (0x0002d0, 0x0002d1), (0x0002e0, 0x0002e4), (0x0002ee, 0x0002ee),
           (0x00037a, 0x00037a), (0x000386, 0x000386), (0x000388, 0x00038a),
           (0x00038c, 0x00038c), (0x00038e, 0x0003a1), (0x0003a3, 0x0003ce),
           (0x0003d0, 0x0003d7), (0x0003da, 0x0003f5), (0x000400, 0x000481),
           (0x00048c, 0x0004c4), (0x0004c7, 0x0004c8), (0x0004cb, 0x0004cc),
           (0x0004d0, 0x0004f5), (0x0004f8, 0x0004f9), (0x000531, 0x000556),
           (0x000559, 0x000559), (0x000561, 0x000587), (0x0005d0, 0x0005ea),
           (0x0005f0, 0x0005f2), (0x000621, 0x00063a), (0x000640, 0x00064a),
           (0x000671, 0x0006d3), (0x0006d5, 0x0006d5), (0x0006e5, 0x0006e6),
           (0x0006fa, 0x0006fc), (0x000710, 0x000710), (0x000712, 0x00072c),
           (0x000780, 0x0007a5), (0x000905, 0x000939), (0x00093d, 0x00093d),
           (0x000950, 0x000950), (0x000958, 0x000961), (0x000985, 0x00098c),
           (0x00098f, 0x000990), (0x000993, 0x0009a8), (0x0009aa, 0x0009b0),
           (0x0009b2, 0x0009b2), (0x0009b6, 0x0009b9), (0x0009dc, 0x0009dd),
           (0x0009df, 0x0009e1), (0x0009f0, 0x0009f1), (0x000a05, 0x000a0a),
           (0x000a0f, 0x000a10), (0x000a13, 0x000a28), (0x000a2a, 0x000a30),
           (0x000a32, 0x000a33), (0x000a35, 0x000a36), (0x000a38, 0x000a39),
           (0x000a59, 0x000a5c), (0x000a5e, 0x000a5e), (0x000a72, 0x000a74),
           (0x000a85, 0x000a8b), (0x000a8d, 0x000a8d), (0x000a8f, 0x000a91),
           (0x000a93, 0x000aa8), (0x000aaa, 0x000ab0), (0x000ab2, 0x000ab3),
           (0x000ab5, 0x000ab9), (0x000abd, 0x000abd), (0x000ad0, 0x000ad0),
           (0x000ae0, 0x000ae0), (0x000b05, 0x000b0c), (0x000b0f, 0x000b10),
           (0x000b13, 0x000b28), (0x000b2a, 0x000b30), (0x000b32, 0x000b33),
           (0x000b36, 0x000b39), (0x000b3d, 0x000b3d), (0x000b5c, 0x000b5d),
           (0x000b5f, 0x000b61), (0x000b85, 0x000b8a), (0x000b8e, 0x000b90),
           (0x000b92, 0x000b95), (0x000b99, 0x000b9a), (0x000b9c, 0x000b9c),
           (0x000b9e, 0x000b9f), (0x000ba3, 0x000ba4), (0x000ba8, 0x000baa),
           (0x000bae, 0x000bb5), (0x000bb7, 0x000bb9), (0x000c05, 0x000c0c),
           (0x000c0e, 0x000c10), (0x000c12, 0x000c28), (0x000c2a, 0x000c33),
           (0x000c35, 0x000c39), (0x000c60, 0x000c61), (0x000c85, 0x000c8c),
           (0x000c8e, 0x000c90), (0x000c92, 0x000ca8), (0x000caa, 0x000cb3),
           (0x000cb5, 0x000cb9), (0x000cde, 0x000cde), (0x000ce0, 0x000ce1),
           (0x000d05, 0x000d0c), (0x000d0e, 0x000d10), (0x000d12, 0x000d28),
           (0x000d2a, 0x000d39), (0x000d60, 0x000d61), (0x000d85, 0x000d96),
           (0x000d9a, 0x000db1), (0x000db3, 0x000dbb), (0x000dbd, 0x000dbd),
           (0x000dc0, 0x000dc6), (0x000e01, 0x000e30), (0x000e32, 0x000e33),
           (0x000e40, 0x000e46), (0x000e81, 0x000e82), (0x000e84, 0x000e84),
           (0x000e87, 0x000e88), (0x000e8a, 0x000e8a), (0x000e8d, 0x000e8d),
           (0x000e94, 0x000e97), (0x000e99, 0x000e9f), (0x000ea1, 0x000ea3),
           (0x000ea5, 0x000ea5), (0x000ea7, 0x000ea7), (0x000eaa, 0x000eab),
           (0x000ead, 0x000eb0), (0x000eb2, 0x000eb3), (0x000ebd, 0x000ebd),
           (0x000ec0, 0x000ec4), (0x000ec6, 0x000ec6), (0x000edc, 0x000edd),
           (0x000f00, 0x000f00), (0x000f40, 0x000f47), (0x000f49, 0x000f6a),
           (0x000f88, 0x000f8b), (0x001000, 0x001021), (0x001023, 0x001027),
           (0x001029, 0x00102a), (0x001050, 0x001055), (0x0010a0, 0x0010c5),
           (0x0010d0, 0x0010f6), (0x001100, 0x001159), (0x00115f, 0x0011a2),
           (0x0011a8, 0x0011f9), (0x001200, 0x001206), (0x001208, 0x001246),
           (0x001248, 0x001248), (0x00124a, 0x00124d), (0x001250, 0x001256),
           (0x001258, 0x001258), (0x00125a, 0x00125d), (0x001260, 0x001286),
           (0x001288, 0x001288), (0x00128a, 0x00128d), (0x001290, 0x0012ae),
           (0x0012b0, 0x0012b0), (0x0012b2, 0x0012b5), (0x0012b8, 0x0012be),
           (0x0012c0, 0x0012c0), (0x0012c2, 0x0012c5), (0x0012c8, 0x0012ce),
           (0x0012d0, 0x0012d6), (0x0012d8, 0x0012ee), (0x0012f0, 0x00130e),
           (0x001310, 0x001310), (0x001312, 0x001315), (0x001318, 0x00131e),
           (0x001320, 0x001346), (0x001348, 0x00135a), (0x0013a0, 0x0013f4),
           (0x001401, 0x00166c), (0x00166f, 0x001676), (0x001681, 0x00169a),
           (0x0016a0, 0x0016ea), (0x001780, 0x0017b3), (0x001820, 0x001877),
           (0x001880, 0x0018a8), (0x001e00, 0x001e9b), (0x001ea0, 0x001ef9),
           (0x001f00, 0x001f15), (0x001f18, 0x001f1d), (0x001f20, 0x001f45),
           (0x001f48, 0x001f4d), (0x001f50, 0x001f57), (0x001f59, 0x001f59),
           (0x001f5b, 0x001f5b), (0x001f5d, 0x001f5d), (0x001f5f, 0x001f7d),
           (0x001f80, 0x001fb4), (0x001fb6, 0x001fbc), (0x001fbe, 0x001fbe),
           (0x001fc2, 0x001fc4), (0x001fc6, 0x001fcc), (0x001fd0, 0x001fd3),
           (0x001fd6, 0x001fdb), (0x001fe0, 0x001fec), (0x001ff2, 0x001ff4),
           (0x001ff6, 0x001ffc), (0x00207f, 0x00207f), (0x002102, 0x002102),
           (0x002107, 0x002107), (0x00210a, 0x002113), (0x002115, 0x002115),
           (0x002119, 0x00211d), (0x002124, 0x002124), (0x002126, 0x002126),
           (0x002128, 0x002128), (0x00212a, 0x00212d), (0x00212f, 0x002131),
           (0x002133, 0x002139), (0x003005, 0x003006), (0x003031, 0x003035),
           (0x003041, 0x003094), (0x00309d, 0x00309e), (0x0030a1, 0x0030fa),
           (0x0030fc, 0x0030fe), (0x003105, 0x00312c), (0x003131, 0x00318e),
           (0x0031a0, 0x0031b7), (0x003400, 0x004db5), (0x004e00, 0x009fa5),
           (0x00a000, 0x00a48c), (0x00ac00, 0x00d7a3), (0x00f900, 0x00fa2d),
           (0x00fb00, 0x00fb06), (0x00fb13, 0x00fb17), (0x00fb1d, 0x00fb1d),
           (0x00fb1f, 0x00fb28), (0x00fb2a, 0x00fb36), (0x00fb38, 0x00fb3c),
           (0x00fb3e, 0x00fb3e), (0x00fb40, 0x00fb41), (0x00fb43, 0x00fb44),
           (0x00fb46, 0x00fbb1), (0x00fbd3, 0x00fd3d), (0x00fd50, 0x00fd8f),
           (0x00fd92, 0x00fdc7), (0x00fdf0, 0x00fdfb), (0x00fe70, 0x00fe72),
           (0x00fe74, 0x00fe74), (0x00fe76, 0x00fefc), (0x00ff21, 0x00ff3a),
           (0x00ff41, 0x00ff5a), (0x00ff66, 0x00ffbe), (0x00ffc2, 0x00ffc7),
           (0x00ffca, 0x00ffcf), (0x00ffd2, 0x00ffd7), (0x00ffda, 0x00ffdc),
           (0x010300, 0x01031e), (0x010330, 0x010349), (0x010400, 0x010425),
           (0x010428, 0x01044d), (0x01d400, 0x01d454), (0x01d456, 0x01d49c),
           (0x01d49e, 0x01d49f), (0x01d4a2, 0x01d4a2), (0x01d4a5, 0x01d4a6),
           (0x01d4a9, 0x01d4ac), (0x01d4ae, 0x01d4b9), (0x01d4bb, 0x01d4bb),
           (0x01d4bd, 0x01d4c0), (0x01d4c2, 0x01d4c3), (0x01d4c5, 0x01d505),
           (0x01d507, 0x01d50a), (0x01d50d, 0x01d514), (0x01d516, 0x01d51c),
           (0x01d51e, 0x01d539), (0x01d53b, 0x01d53e), (0x01d540, 0x01d544),
           (0x01d546, 0x01d546), (0x01d54a, 0x01d550), (0x01d552, 0x01d6a3),
           (0x01d6a8, 0x01d6c0), (0x01d6c2, 0x01d6da), (0x01d6dc, 0x01d6fa),
           (0x01d6fc, 0x01d714), (0x01d716, 0x01d734), (0x01d736, 0x01d74e),
           (0x01d750, 0x01d76e), (0x01d770, 0x01d788), (0x01d78a, 0x01d7a8),
           (0x01d7aa, 0x01d7c2), (0x01d7c4, 0x01d7c9), (0x020000, 0x02a6d6),
           (0x02f800, 0x02fa1d),
         ]),
  # Ll: 1331 codepoint markers (*not* codepoints)
  'Ll' : CodePointSet([
           (0x000061, 0x00007a), (0x0000aa, 0x0000aa), (0x0000b5, 0x0000b5),
           (0x0000ba, 0x0000ba), (0x0000df, 0x0000f6), (0x0000f8, 0x0000ff),
           (0x000101, 0x000101), (0x000103, 0x000103), (0x000105, 0x000105),
           (0x000107, 0x000107), (0x000109, 0x000109), (0x00010b, 0x00010b),
           (0x00010d, 0x00010d), (0x00010f, 0x00010f), (0x000111, 0x000111),
           (0x000113, 0x000113), (0x000115, 0x000115), (0x000117, 0x000117),
           (0x000119, 0x000119), (0x00011b, 0x00011b), (0x00011d, 0x00011d),
           (0x00011f, 0x00011f), (0x000121, 0x000121), (0x000123, 0x000123),
           (0x000125, 0x000125), (0x000127, 0x000127), (0x000129, 0x000129),
           (0x00012b, 0x00012b), (0x00012d, 0x00012d), (0x00012f, 0x00012f),
           (0x000131, 0x000131), (0x000133, 0x000133), (0x000135, 0x000135),
           (0x000137, 0x000138), (0x00013a, 0x00013a), (0x00013c, 0x00013c),
           (0x00013e, 0x00013e), (0x000140, 0x000140), (0x000142, 0x000142),
           (0x000144, 0x000144), (0x000146, 0x000146), (0x000148, 0x000149),
           (0x00014b, 0x00014b), (0x00014d, 0x00014d), (0x00014f, 0x00014f),
           (0x000151, 0x000151), (0x000153, 0x000153), (0x000155, 0x000155),
           (0x000157, 0x000157), (0x000159, 0x000159), (0x00015b, 0x00015b),
           (0x00015d, 0x00015d), (0x00015f, 0x00015f), (0x000161, 0x000161),
           (0x000163, 0x000163), (0x000165, 0x000165), (0x000167, 0x000167),
           (0x000169, 0x000169), (0x00016b, 0x00016b), (0x00016d, 0x00016d),
           (0x00016f, 0x00016f), (0x000171, 0x000171), (0x000173, 0x000173),
           (0x000175, 0x000175), (0x000177, 0x000177), (0x00017a, 0x00017a),
           (0x00017c, 0x00017c), (0x00017e, 0x000180), (0x000183, 0x000183),
           (0x000185, 0x000185), (0x000188, 0x000188), (0x00018c, 0x00018d),
           (0x000192, 0x000192), (0x000195, 0x000195), (0x000199, 0x00019b),
           (0x00019e, 0x00019e), (0x0001a1, 0x0001a1), (0x0001a3, 0x0001a3),
           (0x0001a5, 0x0001a5), (0x0001a8, 0x0001a8), (0x0001aa, 0x0001ab),
           (0x0001ad, 0x0001ad), (0x0001b0, 0x0001b0), (0x0001b4, 0x0001b4),
           (0x0001b6, 0x0001b6), (0x0001b9, 0x0001ba), (0x0001bd, 0x0001bf),
           (0x0001c6, 0x0001c6), (0x0001c9, 0x0001c9), (0x0001cc, 0x0001cc),
           (0x0001ce, 0x0001ce), (0x0001d0, 0x0001d0), (0x0001d2, 0x0001d2),
           (0x0001d4, 0x0001d4), (0x0001d6, 0x0001d6), (0x0001d8, 0x0001d8),
           (0x0001da, 0x0001da), (0x0001dc, 0x0001dd), (0x0001df, 0x0001df),
           (0x0001e1, 0x0001e1), (0x0001e3, 0x0001e3), (0x0001e5, 0x0001e5),
           (0x0001e7, 0x0001e7), (0x0001e9, 0x0001e9), (0x0001eb, 0x0001eb),
           (0x0001ed, 0x0001ed), (0x0001ef, 0x0001f0), (0x0001f3, 0x0001f3),
           (0x0001f5, 0x0001f5), (0x0001f9, 0x0001f9), (0x0001fb, 0x0001fb),
           (0x0001fd, 0x0001fd), (0x0001ff, 0x0001ff), (0x000201, 0x000201),
           (0x000203, 0x000203), (0x000205, 0x000205), (0x000207, 0x000207),
           (0x000209, 0x000209), (0x00020b, 0x00020b), (0x00020d, 0x00020d),
           (0x00020f, 0x00020f), (0x000211, 0x000211), (0x000213, 0x000213),
           (0x000215, 0x000215), (0x000217, 0x000217), (0x000219, 0x000219),
           (0x00021b, 0x00021b), (0x00021d, 0x00021d), (0x00021f, 0x00021f),
           (0x000223, 0x000223), (0x000225, 0x000225), (0x000227, 0x000227),
           (0x000229, 0x000229), (0x00022b, 0x00022b), (0x00022d, 0x00022d),
           (0x00022f, 0x00022f), (0x000231, 0x000231), (0x000233, 0x000233),
           (0x000250, 0x0002ad), (0x000390, 0x000390), (0x0003ac, 0x0003ce),
           (0x0003d0, 0x0003d1), (0x0003d5, 0x0003d7), (0x0003db, 0x0003db),
           (0x0003dd, 0x0003dd), (0x0003df, 0x0003df), (0x0003e1, 0x0003e1),
           (0x0003e3, 0x0003e3), (0x0003e5, 0x0003e5), (0x0003e7, 0x0003e7),
           (0x0003e9, 0x0003e9), (0x0003eb, 0x0003eb), (0x0003ed, 0x0003ed),
           (0x0003ef, 0x0003f3), (0x0003f5, 0x0003f5), (0x000430, 0x00045f),
           (0x000461, 0x000461), (0x000463, 0x000463), (0x000465, 0x000465),
           (0x000467, 0x000467), (0x000469, 0x000469), (0x00046b, 0x00046b),
           (0x00046d, 0x00046d), (0x00046f, 0x00046f), (0x000471, 0x000471),
           (0x000473, 0x000473), (0x000475, 0x000475), (0x000477, 0x000477),
           (0x000479, 0x000479), (0x00047b, 0x00047b), (0x00047d, 0x00047d),
           (0x00047f, 0x00047f), (0x000481, 0x000481), (0x00048d, 0x00048d),
           (0x00048f, 0x00048f), (0x000491, 0x000491), (0x000493, 0x000493),
           (0x000495, 0x000495), (0x000497, 0x000497), (0x000499, 0x000499),
           (0x00049b, 0x00049b), (0x00049d, 0x00049d), (0x00049f, 0x00049f),
           (0x0004a1, 0x0004a1), (0x0004a3, 0x0004a3), (0x0004a5, 0x0004a5),
           (0x0004a7, 0x0004a7), (0x0004a9, 0x0004a9), (0x0004ab, 0x0004ab),
           (0x0004ad, 0x0004ad), (0x0004af, 0x0004af), (0x0004b1, 0x0004b1),
           (0x0004b3, 0x0004b3), (0x0004b5, 0x0004b5), (0x0004b7, 0x0004b7),
           (0x0004b9, 0x0004b9), (0x0004bb, 0x0004bb), (0x0004bd, 0x0004bd),
           (0x0004bf, 0x0004bf), (0x0004c2, 0x0004c2), (0x0004c4, 0x0004c4),
           (0x0004c8, 0x0004c8), (0x0004cc, 0x0004cc), (0x0004d1, 0x0004d1),
           (0x0004d3, 0x0004d3), (0x0004d5, 0x0004d5), (0x0004d7, 0x0004d7),
           (0x0004d9, 0x0004d9), (0x0004db, 0x0004db), (0x0004dd, 0x0004dd),
           (0x0004df, 0x0004df), (0x0004e1, 0x0004e1), (0x0004e3, 0x0004e3),
           (0x0004e5, 0x0004e5), (0x0004e7, 0x0004e7), (0x0004e9, 0x0004e9),
           (0x0004eb, 0x0004eb), (0x0004ed, 0x0004ed), (0x0004ef, 0x0004ef),
           (0x0004f1, 0x0004f1), (0x0004f3, 0x0004f3), (0x0004f5, 0x0004f5),
           (0x0004f9, 0x0004f9), (0x000561, 0x000587), (0x001e01, 0x001e01),
           (0x001e03, 0x001e03), (0x001e05, 0x001e05), (0x001e07, 0x001e07),
           (0x001e09, 0x001e09), (0x001e0b, 0x001e0b), (0x001e0d, 0x001e0d),
           (0x001e0f, 0x001e0f), (0x001e11, 0x001e11), (0x001e13, 0x001e13),
           (0x001e15, 0x001e15), (0x001e17, 0x001e17), (0x001e19, 0x001e19),
           (0x001e1b, 0x001e1b), (0x001e1d, 0x001e1d), (0x001e1f, 0x001e1f),
           (0x001e21, 0x001e21), (0x001e23, 0x001e23), (0x001e25, 0x001e25),
           (0x001e27, 0x001e27), (0x001e29, 0x001e29), (0x001e2b, 0x001e2b),
           (0x001e2d, 0x001e2d), (0x001e2f, 0x001e2f), (0x001e31, 0x001e31),
           (0x001e33, 0x001e33), (0x001e35, 0x001e35), (0x001e37, 0x001e37),
           (0x001e39, 0x001e39), (0x001e3b, 0x001e3b), (0x001e3d, 0x001e3d),
           (0x001e3f, 0x001e3f), (0x001e41, 0x001e41), (0x001e43, 0x001e43),
           (0x001e45, 0x001e45), (0x001e47, 0x001e47), (0x001e49, 0x001e49),
           (0x001e4b, 0x001e4b), (0x001e4d, 0x001e4d), (0x001e4f, 0x001e4f),
           (0x001e51, 0x001e51), (0x001e53, 0x001e53), (0x001e55, 0x001e55),
           (0x001e57, 0x001e57), (0x001e59, 0x001e59), (0x001e5b, 0x001e5b),
           (0x001e5d, 0x001e5d), (0x001e5f, 0x001e5f), (0x001e61, 0x001e61),
           (0x001e63, 0x001e63), (0x001e65, 0x001e65), (0x001e67, 0x001e67),
           (0x001e69, 0x001e69), (0x001e6b, 0x001e6b), (0x001e6d, 0x001e6d),
           (0x001e6f, 0x001e6f), (0x001e71, 0x001e71), (0x001e73, 0x001e73),
           (0x001e75, 0x001e75), (0x001e77, 0x001e77), (0x001e79, 0x001e79),
           (0x001e7b, 0x001e7b), (0x001e7d, 0x001e7d), (0x001e7f, 0x001e7f),
           (0x001e81, 0x001e81), (0x001e83, 0x001e83), (0x001e85, 0x001e85),
           (0x001e87, 0x001e87), (0x001e89, 0x001e89), (0x001e8b, 0x001e8b),
           (0x001e8d, 0x001e8d), (0x001e8f, 0x001e8f), (0x001e91, 0x001e91),
           (0x001e93, 0x001e93), (0x001e95, 0x001e9b), (0x001ea1, 0x001ea1),
           (0x001ea3, 0x001ea3), (0x001ea5, 0x001ea5), (0x001ea7, 0x001ea7),
           (0x001ea9, 0x001ea9), (0x001eab, 0x001eab), (0x001ead, 0x001ead),
           (0x001eaf, 0x001eaf), (0x001eb1, 0x001eb1), (0x001eb3, 0x001eb3),
           (0x001eb5, 0x001eb5), (0x001eb7, 0x001eb7), (0x001eb9, 0x001eb9),
           (0x001ebb, 0x001ebb), (0x001ebd, 0x001ebd), (0x001ebf, 0x001ebf),
           (0x001ec1, 0x001ec1), (0x001ec3, 0x001ec3), (0x001ec5, 0x001ec5),
           (0x001ec7, 0x001ec7), (0x001ec9, 0x001ec9), (0x001ecb, 0x001ecb),
           (0x001ecd, 0x001ecd), (0x001ecf, 0x001ecf), (0x001ed1, 0x001ed1),
           (0x001ed3, 0x001ed3), (0x001ed5, 0x001ed5), (0x001ed7, 0x001ed7),
           (0x001ed9, 0x001ed9), (0x001edb, 0x001edb), (0x001edd, 0x001edd),
           (0x001edf, 0x001edf), (0x001ee1, 0x001ee1), (0x001ee3, 0x001ee3),
           (0x001ee5, 0x001ee5), (0x001ee7, 0x001ee7), (0x001ee9, 0x001ee9),
           (0x001eeb, 0x001eeb), (0x001eed, 0x001eed), (0x001eef, 0x001eef),
           (0x001ef1, 0x001ef1), (0x001ef3, 0x001ef3), (0x001ef5, 0x001ef5),
           (0x001ef7, 0x001ef7), (0x001ef9, 0x001ef9), (0x001f00, 0x001f07),
           (0x001f10, 0x001f15), (0x001f20, 0x001f27), (0x001f30, 0x001f37),
           (0x001f40, 0x001f45), (0x001f50, 0x001f57), (0x001f60, 0x001f67),
           (0x001f70, 0x001f7d), (0x001f80, 0x001f87), (0x001f90, 0x001f97),
           (0x001fa0, 0x001fa7), (0x001fb0, 0x001fb4), (0x001fb6, 0x001fb7),
           (0x001fbe, 0x001fbe), (0x001fc2, 0x001fc4), (0x001fc6, 0x001fc7),
           (0x001fd0, 0x001fd3), (0x001fd6, 0x001fd7), (0x001fe0, 0x001fe7),
           (0x001ff2, 0x001ff4), (0x001ff6, 0x001ff7), (0x00207f, 0x00207f),
           (0x00210a, 0x00210a), (0x00210e, 0x00210f), (0x002113, 0x002113),
           (0x00212f, 0x00212f), (0x002134, 0x002134), (0x002139, 0x002139),
           (0x00fb00, 0x00fb06), (0x00fb13, 0x00fb17), (0x00ff41, 0x00ff5a),
           (0x010428, 0x01044d), (0x01d41a, 0x01d433), (0x01d44e, 0x01d454),
           (0x01d456, 0x01d467), (0x01d482, 0x01d49b), (0x01d4b6, 0x01d4b9),
           (0x01d4bb, 0x01d4bb), (0x01d4bd, 0x01d4c0), (0x01d4c2, 0x01d4c3),
           (0x01d4c5, 0x01d4cf), (0x01d4ea, 0x01d503), (0x01d51e, 0x01d537),
           (0x01d552, 0x01d56b), (0x01d586, 0x01d59f), (0x01d5ba, 0x01d5d3),
           (0x01d5ee, 0x01d607), (0x01d622, 0x01d63b), (0x01d656, 0x01d66f),
           (0x01d68a, 0x01d6a3), (0x01d6c2, 0x01d6da), (0x01d6dc, 0x01d6e1),
           (0x01d6fc, 0x01d714), (0x01d716, 0x01d71b), (0x01d736, 0x01d74e),
           (0x01d750, 0x01d755), (0x01d770, 0x01d788), (0x01d78a, 0x01d78f),
           (0x01d7aa, 0x01d7c2), (0x01d7c4, 0x01d7c9),
         ]),
  # Lm: 46 codepoint markers (*not* codepoints)
  'Lm' : CodePointSet([
           (0x0002b0, 0x0002b8), (0x0002bb, 0x0002c1), (0x0002d0, 0x0002d1),
           (0x0002e0, 0x0002e4), (0x0002ee, 0x0002ee), (0x00037a, 0x00037a),
           (0x000559, 0x000559), (0x000640, 0x000640), (0x0006e5, 0x0006e6),
           (0x000e46, 0x000e46), (0x000ec6, 0x000ec6), (0x001843, 0x001843),
           (0x003005, 0x003005), (0x003031, 0x003035), (0x00309d, 0x00309e),
           (0x0030fc, 0x0030fe), (0x00ff70, 0x00ff70), (0x00ff9e, 0x00ff9f),
         ]),
  # Lo: 5823 codepoint markers (*not* codepoints)
  'Lo' : CodePointSet([
           (0x0001bb, 0x0001bb), (0x0001c0, 0x0001c3), (0x0005d0, 0x0005ea),
           (0x0005f0, 0x0005f2), (0x000621, 0x00063a), (0x000641, 0x00064a),
           (0x000671, 0x0006d3), (0x0006d5, 0x0006d5), (0x0006fa, 0x0006fc),
           (0x000710, 0x000710), (0x000712, 0x00072c), (0x000780, 0x0007a5),
           (0x000905, 0x000939), (0x00093d, 0x00093d), (0x000950, 0x000950),
           (0x000958, 0x000961), (0x000985, 0x00098c), (0x00098f, 0x000990),
           (0x000993, 0x0009a8), (0x0009aa, 0x0009b0), (0x0009b2, 0x0009b2),
           (0x0009b6, 0x0009b9), (0x0009dc, 0x0009dd), (0x0009df, 0x0009e1),
           (0x0009f0, 0x0009f1), (0x000a05, 0x000a0a), (0x000a0f, 0x000a10),
           (0x000a13, 0x000a28), (0x000a2a, 0x000a30), (0x000a32, 0x000a33),
           (0x000a35, 0x000a36), (0x000a38, 0x000a39), (0x000a59, 0x000a5c),
           (0x000a5e, 0x000a5e), (0x000a72, 0x000a74), (0x000a85, 0x000a8b),
           (0x000a8d, 0x000a8d), (0x000a8f, 0x000a91), (0x000a93, 0x000aa8),
           (0x000aaa, 0x000ab0), (0x000ab2, 0x000ab3), (0x000ab5, 0x000ab9),
           (0x000abd, 0x000abd), (0x000ad0, 0x000ad0), (0x000ae0, 0x000ae0),
           (0x000b05, 0x000b0c), (0x000b0f, 0x000b10), (0x000b13, 0x000b28),
           (0x000b2a, 0x000b30), (0x000b32, 0x000b33), (0x000b36, 0x000b39),
           (0x000b3d, 0x000b3d), (0x000b5c, 0x000b5d), (0x000b5f, 0x000b61),
           (0x000b85, 0x000b8a), (0x000b8e, 0x000b90), (0x000b92, 0x000b95),
           (0x000b99, 0x000b9a), (0x000b9c, 0x000b9c), (0x000b9e, 0x000b9f),
           (0x000ba3, 0x000ba4), (0x000ba8, 0x000baa), (0x000bae, 0x000bb5),
           (0x000bb7, 0x000bb9), (0x000c05, 0x000c0c), (0x000c0e, 0x000c10),
           (0x000c12, 0x000c28), (0x000c2a, 0x000c33), (0x000c35, 0x000c39),
           (0x000c60, 0x000c61), (0x000c85, 0x000c8c), (0x000c8e, 0x000c90),
           (0x000c92, 0x000ca8), (0x000caa, 0x000cb3), (0x000cb5, 0x000cb9),
           (0x000cde, 0x000cde), (0x000ce0, 0x000ce1), (0x000d05, 0x000d0c),
           (0x000d0e, 0x000d10), (0x000d12, 0x000d28), (0x000d2a, 0x000d39),
           (0x000d60, 0x000d61), (0x000d85, 0x000d96), (0x000d9a, 0x000db1),
           (0x000db3, 0x000dbb), (0x000dbd, 0x000dbd), (0x000dc0, 0x000dc6),
           (0x000e01, 0x000e30), (0x000e32, 0x000e33), (0x000e40, 0x000e45),
           (0x000e81, 0x000e82), (0x000e84, 0x000e84), (0x000e87, 0x000e88),
           (0x000e8a, 0x000e8a), (0x000e8d, 0x000e8d), (0x000e94, 0x000e97),
           (0x000e99, 0x000e9f), (0x000ea1, 0x000ea3), (0x000ea5, 0x000ea5),
           (0x000ea7, 0x000ea7), (0x000eaa, 0x000eab), (0x000ead, 0x000eb0),
           (0x000eb2, 0x000eb3), (0x000ebd, 0x000ebd), (0x000ec0, 0x000ec4),
           (0x000edc, 0x000edd), (0x000f00, 0x000f00), (0x000f40, 0x000f47),
           (0x000f49, 0x000f6a), (0x000f88, 0x000f8b), (0x001000, 0x001021),
           (0x001023, 0x001027), (0x001029, 0x00102a), (0x001050, 0x001055),
           (0x0010d0, 0x0010f6), (0x001100, 0x001159), (0x00115f, 0x0011a2),
           (0x0011a8, 0x0011f9), (0x001200, 0x001206), (0x001208, 0x001246),
           (0x001248, 0x001248), (0x00124a, 0x00124d), (0x001250, 0x001256),
           (0x001258, 0x001258), (0x00125a, 0x00125d), (0x001260, 0x001286),
           (0x001288, 0x001288), (0x00128a, 0x00128d), (0x001290, 0x0012ae),
           (0x0012b0, 0x0012b0), (0x0012b2, 0x0012b5), (0x0012b8, 0x0012be),
           (0x0012c0, 0x0012c0), (0x0012c2, 0x0012c5), (0x0012c8, 0x0012ce),
           (0x0012d0, 0x0012d6), (0x0012d8, 0x0012ee), (0x0012f0, 0x00130e),
           (0x001310, 0x001310), (0x001312, 0x001315), (0x001318, 0x00131e),
           (0x001320, 0x001346), (0x001348, 0x00135a), (0x0013a0, 0x0013f4),
           (0x001401, 0x00166c), (0x00166f, 0x001676), (0x001681, 0x00169a),
           (0x0016a0, 0x0016ea), (0x001780, 0x0017b3), (0x001820, 0x001842),
           (0x001844, 0x001877), (0x001880, 0x0018a8), (0x002135, 0x002138),
           (0x003006, 0x003006), (0x003041, 0x003094), (0x0030a1, 0x0030fa),
           (0x003105, 0x00312c), (0x003131, 0x00318e), (0x0031a0, 0x0031b7),
           (0x003400, 0x004db5), (0x004e00, 0x009fa5), (0x00a000, 0x00a48c),
           (0x00ac00, 0x00d7a3), (0x00f900, 0x00fa2d), (0x00fb1d, 0x00fb1d),
           (0x00fb1f, 0x00fb28), (0x00fb2a, 0x00fb36), (0x00fb38, 0x00fb3c),
           (0x00fb3e, 0x00fb3e), (0x00fb40, 0x00fb41), (0x00fb43, 0x00fb44),
           (0x00fb46, 0x00fbb1), (0x00fbd3, 0x00fd3d), (0x00fd50, 0x00fd8f),
           (0x00fd92, 0x00fdc7), (0x00fdf0, 0x00fdfb), (0x00fe70, 0x00fe72),
           (0x00fe74, 0x00fe74), (0x00fe76, 0x00fefc), (0x00ff66, 0x00ff6f),
           (0x00ff71, 0x00ff9d), (0x00ffa0, 0x00ffbe), (0x00ffc2, 0x00ffc7),
           (0x00ffca, 0x00ffcf), (0x00ffd2, 0x00ffd7), (0x00ffda, 0x00ffdc),
           (0x010300, 0x01031e), (0x010330, 0x010349), (0x020000, 0x02a6d6),
           (0x02f800, 0x02fa1d),
         ]),
  # Lt: 31 codepoint markers (*not* codepoints)
  'Lt' : CodePointSet([
           (0x0001c5, 0x0001c5), (0x0001c8, 0x0001c8), (0x0001cb, 0x0001cb),
           (0x0001f2, 0x0001f2), (0x001f88, 0x001f8f), (0x001f98, 0x001f9f),
           (0x001fa8, 0x001faf), (0x001fbc, 0x001fbc), (0x001fcc, 0x001fcc),
           (0x001ffc, 0x001ffc),
         ]),
  # Lu: 1168 codepoint markers (*not* codepoints)
  'Lu' : CodePointSet([
           (0x000041, 0x00005a), (0x0000c0, 0x0000d6), (0x0000d8, 0x0000de),
           (0x000100, 0x000100), (0x000102, 0x000102), (0x000104, 0x000104),
           (0x000106, 0x000106), (0x000108, 0x000108), (0x00010a, 0x00010a),
           (0x00010c, 0x00010c), (0x00010e, 0x00010e), (0x000110, 0x000110),
           (0x000112, 0x000112), (0x000114, 0x000114), (0x000116, 0x000116),
           (0x000118, 0x000118), (0x00011a, 0x00011a), (0x00011c, 0x00011c),
           (0x00011e, 0x00011e), (0x000120, 0x000120), (0x000122, 0x000122),
           (0x000124, 0x000124), (0x000126, 0x000126), (0x000128, 0x000128),
           (0x00012a, 0x00012a), (0x00012c, 0x00012c), (0x00012e, 0x00012e),
           (0x000130, 0x000130), (0x000132, 0x000132), (0x000134, 0x000134),
           (0x000136, 0x000136), (0x000139, 0x000139), (0x00013b, 0x00013b),
           (0x00013d, 0x00013d), (0x00013f, 0x00013f), (0x000141, 0x000141),
           (0x000143, 0x000143), (0x000145, 0x000145), (0x000147, 0x000147),
           (0x00014a, 0x00014a), (0x00014c, 0x00014c), (0x00014e, 0x00014e),
           (0x000150, 0x000150), (0x000152, 0x000152), (0x000154, 0x000154),
           (0x000156, 0x000156), (0x000158, 0x000158), (0x00015a, 0x00015a),
           (0x00015c, 0x00015c), (0x00015e, 0x00015e), (0x000160, 0x000160),
           (0x000162, 0x000162), (0x000164, 0x000164), (0x000166, 0x000166),
           (0x000168, 0x000168), (0x00016a, 0x00016a), (0x00016c, 0x00016c),
           (0x00016e, 0x00016e), (0x000170, 0x000170), (0x000172, 0x000172),
           (0x000174, 0x000174), (0x000176, 0x000176), (0x000178, 0x000179),
           (0x00017b, 0x00017b), (0x00017d, 0x00017d), (0x000181, 0x000182),
           (0x000184, 0x000184), (0x000186, 0x000187), (0x000189, 0x00018b),
           (0x00018e, 0x000191), (0x000193, 0x000194), (0x000196, 0x000198),
           (0x00019c, 0x00019d), (0x00019f, 0x0001a0), (0x0001a2, 0x0001a2),
           (0x0001a4, 0x0001a4), (0x0001a6, 0x0001a7), (0x0001a9, 0x0001a9),
           (0x0001ac, 0x0001ac), (0x0001ae, 0x0001af), (0x0001b1, 0x0001b3),
           (0x0001b5, 0x0001b5), (0x0001b7, 0x0001b8), (0x0001bc, 0x0001bc),
           (0x0001c4, 0x0001c4), (0x0001c7, 0x0001c7), (0x0001ca, 0x0001ca),
           (0x0001cd, 0x0001cd), (0x0001cf, 0x0001cf), (0x0001d1, 0x0001d1),
           (0x0001d3, 0x0001d3), (0x0001d5, 0x0001d5), (0x0001d7, 0x0001d7),
           (0x0001d9, 0x0001d9), (0x0001db, 0x0001db), (0x0001de, 0x0001de),
           (0x0001e0, 0x0001e0), (0x0001e2, 0x0001e2), (0x0001e4, 0x0001e4),
           (0x0001e6, 0x0001e6), (0x0001e8, 0x0001e8), (0x0001ea, 0x0001ea),
           (0x0001ec, 0x0001ec), (0x0001ee, 0x0001ee), (0x0001f1, 0x0001f1),
           (0x0001f4, 0x0001f4), (0x0001f6, 0x0001f8), (0x0001fa, 0x0001fa),
           (0x0001fc, 0x0001fc), (0x0001fe, 0x0001fe), (0x000200, 0x000200),
           (0x000202, 0x000202), (0x000204, 0x000204), (0x000206, 0x000206),
           (0x000208, 0x000208), (0x00020a, 0x00020a), (0x00020c, 0x00020c),
           (0x00020e, 0x00020e), (0x000210, 0x000210), (0x000212, 0x000212),
           (0x000214, 0x000214), (0x000216, 0x000216), (0x000218, 0x000218),
           (0x00021a, 0x00021a), (0x00021c, 0x00021c), (0x00021e, 0x00021e),
           (0x000222, 0x000222), (0x000224, 0x000224), (0x000226, 0x000226),
           (0x000228, 0x000228), (0x00022a, 0x00022a), (0x00022c, 0x00022c),
           (0x00022e, 0x00022e), (0x000230, 0x000230), (0x000232, 0x000232),
           (0x000386, 0x000386), (0x000388, 0x00038a), (0x00038c, 0x00038c),
           (0x00038e, 0x00038f), (0x000391, 0x0003a1), (0x0003a3, 0x0003ab),
           (0x0003d2, 0x0003d4), (0x0003da, 0x0003da), (0x0003dc, 0x0003dc),
           (0x0003de, 0x0003de), (0x0003e0, 0x0003e0), (0x0003e2, 0x0003e2),
           (0x0003e4, 0x0003e4), (0x0003e6, 0x0003e6), (0x0003e8, 0x0003e8),
           (0x0003ea, 0x0003ea), (0x0003ec, 0x0003ec), (0x0003ee, 0x0003ee),
           (0x0003f4, 0x0003f4), (0x000400, 0x00042f), (0x000460, 0x000460),
           (0x000462, 0x000462), (0x000464, 0x000464), (0x000466, 0x000466),
           (0x000468, 0x000468), (0x00046a, 0x00046a), (0x00046c, 0x00046c),
           (0x00046e, 0x00046e), (0x000470, 0x000470), (0x000472, 0x000472),
           (0x000474, 0x000474), (0x000476, 0x000476), (0x000478, 0x000478),
           (0x00047a, 0x00047a), (0x00047c, 0x00047c), (0x00047e, 0x00047e),
           (0x000480, 0x000480), (0x00048c, 0x00048c), (0x00048e, 0x00048e),
           (0x000490, 0x000490), (0x000492, 0x000492), (0x000494, 0x000494),
           (0x000496, 0x000496), (0x000498, 0x000498), (0x00049a, 0x00049a),
           (0x00049c, 0x00049c), (0x00049e, 0x00049e), (0x0004a0, 0x0004a0),
           (0x0004a2, 0x0004a2), (0x0004a4, 0x0004a4), (0x0004a6, 0x0004a6),
           (0x0004a8, 0x0004a8), (0x0004aa, 0x0004aa), (0x0004ac, 0x0004ac),
           (0x0004ae, 0x0004ae), (0x0004b0, 0x0004b0), (0x0004b2, 0x0004b2),
           (0x0004b4, 0x0004b4), (0x0004b6, 0x0004b6), (0x0004b8, 0x0004b8),
           (0x0004ba, 0x0004ba), (0x0004bc, 0x0004bc), (0x0004be, 0x0004be),
           (0x0004c0, 0x0004c1), (0x0004c3, 0x0004c3), (0x0004c7, 0x0004c7),
           (0x0004cb, 0x0004cb), (0x0004d0, 0x0004d0), (0x0004d2, 0x0004d2),
           (0x0004d4, 0x0004d4), (0x0004d6, 0x0004d6), (0x0004d8, 0x0004d8),
           (0x0004da, 0x0004da), (0x0004dc, 0x0004dc), (0x0004de, 0x0004de),
           (0x0004e0, 0x0004e0), (0x0004e2, 0x0004e2), (0x0004e4, 0x0004e4),
           (0x0004e6, 0x0004e6), (0x0004e8, 0x0004e8), (0x0004ea, 0x0004ea),
           (0x0004ec, 0x0004ec), (0x0004ee, 0x0004ee), (0x0004f0, 0x0004f0),
           (0x0004f2, 0x0004f2), (0x0004f4, 0x0004f4), (0x0004f8, 0x0004f8),
           (0x000531, 0x000556), (0x0010a0, 0x0010c5), (0x001e00, 0x001e00),
           (0x001e02, 0x001e02), (0x001e04, 0x001e04), (0x001e06, 0x001e06),
           (0x001e08, 0x001e08), (0x001e0a, 0x001e0a), (0x001e0c, 0x001e0c),
           (0x001e0e, 0x001e0e), (0x001e10, 0x001e10), (0x001e12, 0x001e12),
           (0x001e14, 0x001e14), (0x001e16, 0x001e16), (0x001e18, 0x001e18),
           (0x001e1a, 0x001e1a), (0x001e1c, 0x001e1c), (0x001e1e, 0x001e1e),
           (0x001e20, 0x001e20), (0x001e22, 0x001e22), (0x001e24, 0x001e24),
           (0x001e26, 0x001e26), (0x001e28, 0x001e28), (0x001e2a, 0x001e2a),
           (0x001e2c, 0x001e2c), (0x001e2e, 0x001e2e), (0x001e30, 0x001e30),
           (0x001e32, 0x001e32), (0x001e34, 0x001e34), (0x001e36, 0x001e36),
           (0x001e38, 0x001e38), (0x001e3a, 0x001e3a), (0x001e3c, 0x001e3c),
           (0x001e3e, 0x001e3e), (0x001e40, 0x001e40), (0x001e42, 0x001e42),
           (0x001e44, 0x001e44), (0x001e46, 0x001e46), (0x001e48, 0x001e48),
           (0x001e4a, 0x001e4a), (0x001e4c, 0x001e4c), (0x001e4e, 0x001e4e),
           (0x001e50, 0x001e50), (0x001e52, 0x001e52), (0x001e54, 0x001e54),
           (0x001e56, 0x001e56), (0x001e58, 0x001e58), (0x001e5a, 0x001e5a),
           (0x001e5c, 0x001e5c), (0x001e5e, 0x001e5e), (0x001e60, 0x001e60),
           (0x001e62, 0x001e62), (0x001e64, 0x001e64), (0x001e66, 0x001e66),
           (0x001e68, 0x001e68), (0x001e6a, 0x001e6a), (0x001e6c, 0x001e6c),
           (0x001e6e, 0x001e6e), (0x001e70, 0x001e70), (0x001e72, 0x001e72),
           (0x001e74, 0x001e74), (0x001e76, 0x001e76), (0x001e78, 0x001e78),
           (0x001e7a, 0x001e7a), (0x001e7c, 0x001e7c), (0x001e7e, 0x001e7e),
           (0x001e80, 0x001e80), (0x001e82, 0x001e82), (0x001e84, 0x001e84),
           (0x001e86, 0x001e86), (0x001e88, 0x001e88), (0x001e8a, 0x001e8a),
           (0x001e8c, 0x001e8c), (0x001e8e, 0x001e8e), (0x001e90, 0x001e90),
           (0x001e92, 0x001e92), (0x001e94, 0x001e94), (0x001ea0, 0x001ea0),
           (0x001ea2, 0x001ea2), (0x001ea4, 0x001ea4), (0x001ea6, 0x001ea6),
           (0x001ea8, 0x001ea8), (0x001eaa, 0x001eaa), (0x001eac, 0x001eac),
           (0x001eae, 0x001eae), (0x001eb0, 0x001eb0), (0x001eb2, 0x001eb2),
           (0x001eb4, 0x001eb4), (0x001eb6, 0x001eb6), (0x001eb8, 0x001eb8),
           (0x001eba, 0x001eba), (0x001ebc, 0x001ebc), (0x001ebe, 0x001ebe),
           (0x001ec0, 0x001ec0), (0x001ec2, 0x001ec2), (0x001ec4, 0x001ec4),
           (0x001ec6, 0x001ec6), (0x001ec8, 0x001ec8), (0x001eca, 0x001eca),
           (0x001ecc, 0x001ecc), (0x001ece, 0x001ece), (0x001ed0, 0x001ed0),
           (0x001ed2, 0x001ed2), (0x001ed4, 0x001ed4), (0x001ed6, 0x001ed6),
           (0x001ed8, 0x001ed8), (0x001eda, 0x001eda), (0x001edc, 0x001edc),
           (0x001ede, 0x001ede), (0x001ee0, 0x001ee0), (0x001ee2, 0x001ee2),
           (0x001ee4, 0x001ee4), (0x001ee6, 0x001ee6), (0x001ee8, 0x001ee8),
           (0x001eea, 0x001eea), (0x001eec, 0x001eec), (0x001eee, 0x001eee),
           (0x001ef0, 0x001ef0), (0x001ef2, 0x001ef2), (0x001ef4, 0x001ef4),
           (0x001ef6, 0x001ef6), (0x001ef8, 0x001ef8), (0x001f08, 0x001f0f),
           (0x001f18, 0x001f1d), (0x001f28, 0x001f2f), (0x001f38, 0x001f3f),
           (0x001f48, 0x001f4d), (0x001f59, 0x001f59), (0x001f5b, 0x001f5b),
           (0x001f5d, 0x001f5d), (0x001f5f, 0x001f5f), (0x001f68, 0x001f6f),
           (0x001fb8, 0x001fbb), (0x001fc8, 0x001fcb), (0x001fd8, 0x001fdb),
           (0x001fe8, 0x001fec), (0x001ff8, 0x001ffb), (0x002102, 0x002102),
           (0x002107, 0x002107), (0x00210b, 0x00210d), (0x002110, 0x002112),
           (0x002115, 0x002115), (0x002119, 0x00211d), (0x002124, 0x002124),
           (0x002126, 0x002126), (0x002128, 0x002128), (0x00212a, 0x00212d),
           (0x002130, 0x002131), (0x002133, 0x002133), (0x00ff21, 0x00ff3a),
           (0x010400, 0x010425), (0x01d400, 0x01d419), (0x01d434, 0x01d44d),
           (0x01d468, 0x01d481), (0x01d49c, 0x01d49c), (0x01d49e, 0x01d49f),
           (0x01d4a2, 0x01d4a2), (0x01d4a5, 0x01d4a6), (0x01d4a9, 0x01d4ac),
           (0x01d4ae, 0x01d4b5), (0x01d4d0, 0x01d4e9), (0x01d504, 0x01d505),
           (0x01d507, 0x01d50a), (0x01d50d, 0x01d514), (0x01d516, 0x01d51c),
           (0x01d538, 0x01d539), (0x01d53b, 0x01d53e), (0x01d540, 0x01d544),
           (0x01d546, 0x01d546), (0x01d54a, 0x01d550), (0x01d56c, 0x01d585),
           (0x01d5a0, 0x01d5b9), (0x01d5d4, 0x01d5ed), (0x01d608, 0x01d621),
           (0x01d63c, 0x01d655), (0x01d670, 0x01d689), (0x01d6a8, 0x01d6c0),
           (0x01d6e2, 0x01d6fa), (0x01d71c, 0x01d734), (0x01d756, 0x01d76e),
           (0x01d790, 0x01d7a8),
         ]),
  # M: 605 codepoint markers (*not* codepoints)
  'M'  : CodePointSet([
           (0x000300, 0x00034e), (0x000360, 0x000362), (0x000483, 0x000486),
           (0x000488, 0x000489), (0x000591, 0x0005a1), (0x0005a3, 0x0005b9),
           (0x0005bb, 0x0005bd), (0x0005bf, 0x0005bf), (0x0005c1, 0x0005c2),
           (0x0005c4, 0x0005c4), (0x00064b, 0x000655), (0x000670, 0x000670),
           (0x0006d6, 0x0006e4), (0x0006e7, 0x0006e8), (0x0006ea, 0x0006ed),
           (0x000711, 0x000711), (0x000730, 0x00074a), (0x0007a6, 0x0007b0),
           (0x000901, 0x000903), (0x00093c, 0x00093c), (0x00093e, 0x00094d),
           (0x000951, 0x000954), (0x000962, 0x000963), (0x000981, 0x000983),
           (0x0009bc, 0x0009bc), (0x0009be, 0x0009c4), (0x0009c7, 0x0009c8),
           (0x0009cb, 0x0009cd), (0x0009d7, 0x0009d7), (0x0009e2, 0x0009e3),
           (0x000a02, 0x000a02), (0x000a3c, 0x000a3c), (0x000a3e, 0x000a42),
           (0x000a47, 0x000a48), (0x000a4b, 0x000a4d), (0x000a70, 0x000a71),
           (0x000a81, 0x000a83), (0x000abc, 0x000abc), (0x000abe, 0x000ac5),
           (0x000ac7, 0x000ac9), (0x000acb, 0x000acd), (0x000b01, 0x000b03),
           (0x000b3c, 0x000b3c), (0x000b3e, 0x000b43), (0x000b47, 0x000b48),
           (0x000b4b, 0x000b4d), (0x000b56, 0x000b57), (0x000b82, 0x000b83),
           (0x000bbe, 0x000bc2), (0x000bc6, 0x000bc8), (0x000bca, 0x000bcd),
           (0x000bd7, 0x000bd7), (0x000c01, 0x000c03), (0x000c3e, 0x000c44),
           (0x000c46, 0x000c48), (0x000c4a, 0x000c4d), (0x000c55, 0x000c56),
           (0x000c82, 0x000c83), (0x000cbe, 0x000cc4), (0x000cc6, 0x000cc8),
           (0x000cca, 0x000ccd), (0x000cd5, 0x000cd6), (0x000d02, 0x000d03),
           (0x000d3e, 0x000d43), (0x000d46, 0x000d48), (0x000d4a, 0x000d4d),
           (0x000d57, 0x000d57), (0x000d82, 0x000d83), (0x000dca, 0x000dca),
           (0x000dcf, 0x000dd4), (0x000dd6, 0x000dd6), (0x000dd8, 0x000ddf),
           (0x000df2, 0x000df3), (0x000e31, 0x000e31), (0x000e34, 0x000e3a),
           (0x000e47, 0x000e4e), (0x000eb1, 0x000eb1), (0x000eb4, 0x000eb9),
           (0x000ebb, 0x000ebc), (0x000ec8, 0x000ecd), (0x000f18, 0x000f19),
           (0x000f35, 0x000f35), (0x000f37, 0x000f37), (0x000f39, 0x000f39),
           (0x000f3e, 0x000f3f), (0x000f71, 0x000f84), (0x000f86, 0x000f87),
           (0x000f90, 0x000f97), (0x000f99, 0x000fbc), (0x000fc6, 0x000fc6),
           (0x00102c, 0x001032), (0x001036, 0x001039), (0x001056, 0x001059),
           (0x0017b4, 0x0017d3), (0x0018a9, 0x0018a9), (0x0020d0, 0x0020e3),
           (0x00302a, 0x00302f), (0x003099, 0x00309a), (0x00fb1e, 0x00fb1e),
           (0x00fe20, 0x00fe23), (0x01d165, 0x01d169), (0x01d16d, 0x01d172),
           (0x01d17b, 0x01d182), (0x01d185, 0x01d18b), (0x01d1aa, 0x01d1ad),
         ]),
  # Mc: 126 codepoint markers (*not* codepoints)
  'Mc' : CodePointSet([
           (0x000903, 0x000903), (0x00093e, 0x000940), (0x000949, 0x00094c),
           (0x000982, 0x000983), (0x0009be, 0x0009c0), (0x0009c7, 0x0009c8),
           (0x0009cb, 0x0009cc), (0x0009d7, 0x0009d7), (0x000a3e, 0x000a40),
           (0x000a83, 0x000a83), (0x000abe, 0x000ac0), (0x000ac9, 0x000ac9),
           (0x000acb, 0x000acc), (0x000b02, 0x000b03), (0x000b3e, 0x000b3e),
           (0x000b40, 0x000b40), (0x000b47, 0x000b48), (0x000b4b, 0x000b4c),
           (0x000b57, 0x000b57), (0x000b83, 0x000b83), (0x000bbe, 0x000bbf),
           (0x000bc1, 0x000bc2), (0x000bc6, 0x000bc8), (0x000bca, 0x000bcc),
           (0x000bd7, 0x000bd7), (0x000c01, 0x000c03), (0x000c41, 0x000c44),
           (0x000c82, 0x000c83), (0x000cbe, 0x000cbe), (0x000cc0, 0x000cc4),
           (0x000cc7, 0x000cc8), (0x000cca, 0x000ccb), (0x000cd5, 0x000cd6),
           (0x000d02, 0x000d03), (0x000d3e, 0x000d40), (0x000d46, 0x000d48),
           (0x000d4a, 0x000d4c), (0x000d57, 0x000d57), (0x000d82, 0x000d83),
           (0x000dcf, 0x000dd1), (0x000dd8, 0x000ddf), (0x000df2, 0x000df3),
           (0x000f3e, 0x000f3f), (0x000f7f, 0x000f7f), (0x00102c, 0x00102c),
           (0x001031, 0x001031), (0x001038, 0x001038), (0x001056, 0x001057),
           (0x0017b4, 0x0017b6), (0x0017be, 0x0017c5), (0x0017c7, 0x0017c8),
           (0x01d165, 0x01d166), (0x01d16d, 0x01d172),
         ]),
  # Me: 10 codepoint markers (*not* codepoints)
  'Me' : CodePointSet([
           (0x000488, 0x000489), (0x0006dd, 0x0006de), (0x0020dd, 0x0020e0),
           (0x0020e2, 0x0020e3),
         ]),
  # Mn: 469 codepoint markers (*not* codepoints)
  'Mn' : CodePointSet([
           (0x000300, 0x00034e), (0x000360, 0x000362), (0x000483, 0x000486),
           (0x000591, 0x0005a1), (0x0005a3, 0x0005b9), (0x0005bb, 0x0005bd),
           (0x0005bf, 0x0005bf), (0x0005c1, 0x0005c2), (0x0005c4, 0x0005c4),
           (0x00064b, 0x000655), (0x000670, 0x000670), (0x0006d6, 0x0006dc),
           (0x0006df, 0x0006e4), (0x0006e7, 0x0006e8), (0x0006ea, 0x0006ed),
           (0x000711, 0x000711), (0x000730, 0x00074a), (0x0007a6, 0x0007b0),
           (0x000901, 0x000902), (0x00093c, 0x00093c), (0x000941, 0x000948),
           (0x00094d, 0x00094d), (0x000951, 0x000954), (0x000962, 0x000963),
           (0x000981, 0x000981), (0x0009bc, 0x0009bc), (0x0009c1, 0x0009c4),
           (0x0009cd, 0x0009cd), (0x0009e2, 0x0009e3), (0x000a02, 0x000a02),
           (0x000a3c, 0x000a3c), (0x000a41, 0x000a42), (0x000a47, 0x000a48),
           (0x000a4b, 0x000a4d), (0x000a70, 0x000a71), (0x000a81, 0x000a82),
           (0x000abc, 0x000abc), (0x000ac1, 0x000ac5), (0x000ac7, 0x000ac8),
           (0x000acd, 0x000acd), (0x000b01, 0x000b01), (0x000b3c, 0x000b3c),
           (0x000b3f, 0x000b3f), (0x000b41, 0x000b43), (0x000b4d, 0x000b4d),
           (0x000b56, 0x000b56), (0x000b82, 0x000b82), (0x000bc0, 0x000bc0),
           (0x000bcd, 0x000bcd), (0x000c3e, 0x000c40), (0x000c46, 0x000c48),
           (0x000c4a, 0x000c4d), (0x000c55, 0x000c56), (0x000cbf, 0x000cbf),
           (0x000cc6, 0x000cc6), (0x000ccc, 0x000ccd), (0x000d41, 0x000d43),
           (0x000d4d, 0x000d4d), (0x000dca, 0x000dca), (0x000dd2, 0x000dd4),
           (0x000dd6, 0x000dd6), (0x000e31, 0x000e31), (0x000e34, 0x000e3a),
           (0x000e47, 0x000e4e), (0x000eb1, 0x000eb1), (0x000eb4, 0x000eb9),
           (0x000ebb, 0x000ebc), (0x000ec8, 0x000ecd), (0x000f18, 0x000f19),
           (0x000f35, 0x000f35), (0x000f37, 0x000f37), (0x000f39, 0x000f39),
           (0x000f71, 0x000f7e), (0x000f80, 0x000f84), (0x000f86, 0x000f87),
           (0x000f90, 0x000f97), (0x000f99, 0x000fbc), (0x000fc6, 0x000fc6),
           (0x00102d, 0x001030), (0x001032, 0x001032), (0x001036, 0x001037),
           (0x001039, 0x001039), (0x001058, 0x001059), (0x0017b7, 0x0017bd),
           (0x0017c6, 0x0017c6), (0x0017c9, 0x0017d3), (0x0018a9, 0x0018a9),
           (0x0020d0, 0x0020dc), (0x0020e1, 0x0020e1), (0x00302a, 0x00302f),
           (0x003099, 0x00309a), (0x00fb1e, 0x00fb1e), (0x00fe20, 0x00fe23),
           (0x01d167, 0x01d169), (0x01d17b, 0x01d182), (0x01d185, 0x01d18b),
           (0x01d1aa, 0x01d1ad),
         ]),
  # N: 486 codepoint markers (*not* codepoints)
  'N'  : CodePointSet([
           (0x000030, 0x000039), (0x0000b2, 0x0000b3), (0x0000b9, 0x0000b9),
           (0x0000bc, 0x0000be), (0x000660, 0x000669), (0x0006f0, 0x0006f9),
           (0x000966, 0x00096f), (0x0009e6, 0x0009ef), (0x0009f4, 0x0009f9),
           (0x000a66, 0x000a6f), (0x000ae6, 0x000aef), (0x000b66, 0x000b6f),
           (0x000be7, 0x000bf2), (0x000c66, 0x000c6f), (0x000ce6, 0x000cef),
           (0x000d66, 0x000d6f), (0x000e50, 0x000e59), (0x000ed0, 0x000ed9),
           (0x000f20, 0x000f33), (0x001040, 0x001049), (0x001369, 0x00137c),
           (0x0016ee, 0x0016f0), (0x0017e0, 0x0017e9), (0x001810, 0x001819),
           (0x002070, 0x002070), (0x002074, 0x002079), (0x002080, 0x002089),
           (0x002153, 0x002183), (0x002460, 0x00249b), (0x0024ea, 0x0024ea),
           (0x002776, 0x002793), (0x003007, 0x003007), (0x003021, 0x003029),
           (0x003038, 0x00303a), (0x003192, 0x003195), (0x003220, 0x003229),
           (0x003280, 0x003289), (0x00ff10, 0x00ff19), (0x010320, 0x010323),
           (0x01034a, 0x01034a), (0x01d7ce, 0x01d7ff),
         ]),
  # Nd: 248 codepoint markers (*not* codepoints)
  'Nd' : CodePointSet([
           (0x000030, 0x000039), (0x000660, 0x000669), (0x0006f0, 0x0006f9),
           (0x000966, 0x00096f), (0x0009e6, 0x0009ef), (0x000a66, 0x000a6f),
           (0x000ae6, 0x000aef), (0x000b66, 0x000b6f), (0x000be7, 0x000bef),
           (0x000c66, 0x000c6f), (0x000ce6, 0x000cef), (0x000d66, 0x000d6f),
           (0x000e50, 0x000e59), (0x000ed0, 0x000ed9), (0x000f20, 0x000f29),
           (0x001040, 0x001049), (0x001369, 0x001371), (0x0017e0, 0x0017e9),
           (0x001810, 0x001819), (0x00ff10, 0x00ff19), (0x01d7ce, 0x01d7ff),
         ]),
  # Nl: 53 codepoint markers (*not* codepoints)
  'Nl' : CodePointSet([
           (0x0016ee, 0x0016f0), (0x002160, 0x002183), (0x003007, 0x003007),
           (0x003021, 0x003029), (0x003038, 0x00303a), (0x01034a, 0x01034a),
         ]),
  # No: 185 codepoint markers (*not* codepoints)
  'No' : CodePointSet([
           (0x0000b2, 0x0000b3), (0x0000b9, 0x0000b9), (0x0000bc, 0x0000be),
           (0x0009f4, 0x0009f9), (0x000bf0, 0x000bf2), (0x000f2a, 0x000f33),
           (0x001372, 0x00137c), (0x002070, 0x002070), (0x002074, 0x002079),
           (0x002080, 0x002089), (0x002153, 0x00215f), (0x002460, 0x00249b),
           (0x0024ea, 0x0024ea), (0x002776, 0x002793), (0x003192, 0x003195),
           (0x003220, 0x003229), (0x003280, 0x003289), (0x010320, 0x010323),
         ]),
  # P: 298 codepoint markers (*not* codepoints)
  'P'  : CodePointSet([
           (0x000021, 0x000023), (0x000025, 0x00002a), (0x00002c, 0x00002f),
           (0x00003a, 0x00003b), (0x00003f, 0x000040), (0x00005b, 0x00005d),
           (0x00005f, 0x00005f), (0x00007b, 0x00007b), (0x00007d, 0x00007d),
           (0x0000a1, 0x0000a1), (0x0000ab, 0x0000ab), (0x0000ad, 0x0000ad),
           (0x0000b7, 0x0000b7), (0x0000bb, 0x0000bb), (0x0000bf, 0x0000bf),
           (0x00037e, 0x00037e), (0x000387, 0x000387), (0x00055a, 0x00055f),
           (0x000589, 0x00058a), (0x0005be, 0x0005be), (0x0005c0, 0x0005c0),
           (0x0005c3, 0x0005c3), (0x0005f3, 0x0005f4), (0x00060c, 0x00060c),
           (0x00061b, 0x00061b), (0x00061f, 0x00061f), (0x00066a, 0x00066d),
           (0x0006d4, 0x0006d4), (0x000700, 0x00070d), (0x000964, 0x000965),
           (0x000970, 0x000970), (0x000df4, 0x000df4), (0x000e4f, 0x000e4f),
           (0x000e5a, 0x000e5b), (0x000f04, 0x000f12), (0x000f3a, 0x000f3d),
           (0x000f85, 0x000f85), (0x00104a, 0x00104f), (0x0010fb, 0x0010fb),
           (0x001361, 0x001368), (0x00166d, 0x00166e), (0x00169b, 0x00169c),
           (0x0016eb, 0x0016ed), (0x0017d4, 0x0017da), (0x0017dc, 0x0017dc),
           (0x001800, 0x00180a), (0x002010, 0x002027), (0x002030, 0x002043),
           (0x002045, 0x002046), (0x002048, 0x00204d), (0x00207d, 0x00207e),
           (0x00208d, 0x00208e), (0x002329, 0x00232a), (0x003001, 0x003003),
           (0x003008, 0x003011), (0x003014, 0x00301f), (0x003030, 0x003030),
           (0x0030fb, 0x0030fb), (0x00fd3e, 0x00fd3f), (0x00fe30, 0x00fe44),
           (0x00fe49, 0x00fe52), (0x00fe54, 0x00fe61), (0x00fe63, 0x00fe63),
           (0x00fe68, 0x00fe68), (0x00fe6a, 0x00fe6b), (0x00ff01, 0x00ff03),
           (0x00ff05, 0x00ff0a), (0x00ff0c, 0x00ff0f), (0x00ff1a, 0x00ff1b),
           (0x00ff1f, 0x00ff20), (0x00ff3b, 0x00ff3d), (0x00ff3f, 0x00ff3f),
           (0x00ff5b, 0x00ff5b), (0x00ff5d, 0x00ff5d), (0x00ff61, 0x00ff65),
         ]),
  # Pc: 11 codepoint markers (*not* codepoints)
  'Pc' : CodePointSet([
           (0x00005f, 0x00005f), (0x00203f, 0x002040), (0x0030fb, 0x0030fb),
           (0x00fe33, 0x00fe34), (0x00fe4d, 0x00fe4f), (0x00ff3f, 0x00ff3f),
           (0x00ff65, 0x00ff65),
         ]),
  # Pd: 17 codepoint markers (*not* codepoints)
  'Pd' : CodePointSet([
           (0x00002d, 0x00002d), (0x0000ad, 0x0000ad), (0x00058a, 0x00058a),
           (0x001806, 0x001806), (0x002010, 0x002015), (0x00301c, 0x00301c),
           (0x003030, 0x003030), (0x00fe31, 0x00fe32), (0x00fe58, 0x00fe58),
           (0x00fe63, 0x00fe63), (0x00ff0d, 0x00ff0d),
         ]),
  # Pe: 37 codepoint markers (*not* codepoints)
  'Pe' : CodePointSet([
           (0x000029, 0x000029), (0x00005d, 0x00005d), (0x00007d, 0x00007d),
           (0x000f3b, 0x000f3b), (0x000f3d, 0x000f3d), (0x00169c, 0x00169c),
           (0x002046, 0x002046), (0x00207e, 0x00207e), (0x00208e, 0x00208e),
           (0x00232a, 0x00232a), (0x003009, 0x003009), (0x00300b, 0x00300b),
           (0x00300d, 0x00300d), (0x00300f, 0x00300f), (0x003011, 0x003011),
           (0x003015, 0x003015), (0x003017, 0x003017), (0x003019, 0x003019),
           (0x00301b, 0x00301b), (0x00301e, 0x00301f), (0x00fd3f, 0x00fd3f),
           (0x00fe36, 0x00fe36), (0x00fe38, 0x00fe38), (0x00fe3a, 0x00fe3a),
           (0x00fe3c, 0x00fe3c), (0x00fe3e, 0x00fe3e), (0x00fe40, 0x00fe40),
           (0x00fe42, 0x00fe42), (0x00fe44, 0x00fe44), (0x00fe5a, 0x00fe5a),
           (0x00fe5c, 0x00fe5c), (0x00fe5e, 0x00fe5e), (0x00ff09, 0x00ff09),
           (0x00ff3d, 0x00ff3d), (0x00ff5d, 0x00ff5d), (0x00ff63, 0x00ff63),
         ]),
  # Pf: 4 codepoint markers (*not* codepoints)
  'Pf' : CodePointSet([
           (0x0000bb, 0x0000bb), (0x002019, 0x002019), (0x00201d, 0x00201d),
           (0x00203a, 0x00203a),
         ]),
  # Pi: 6 codepoint markers (*not* codepoints)
  'Pi' : CodePointSet([
           (0x0000ab, 0x0000ab), (0x002018, 0x002018), (0x00201b, 0x00201c),
           (0x00201f, 0x00201f), (0x002039, 0x002039),
         ]),
  # Po: 185 codepoint markers (*not* codepoints)
  'Po' : CodePointSet([
           (0x000021, 0x000023), (0x000025, 0x000027), (0x00002a, 0x00002a),
           (0x00002c, 0x00002c), (0x00002e, 0x00002f), (0x00003a, 0x00003b),
           (0x00003f, 0x000040), (0x00005c, 0x00005c), (0x0000a1, 0x0000a1),
           (0x0000b7, 0x0000b7), (0x0000bf, 0x0000bf), (0x00037e, 0x00037e),
           (0x000387, 0x000387), (0x00055a, 0x00055f), (0x000589, 0x000589),
           (0x0005be, 0x0005be), (0x0005c0, 0x0005c0), (0x0005c3, 0x0005c3),
           (0x0005f3, 0x0005f4), (0x00060c, 0x00060c), (0x00061b, 0x00061b),
           (0x00061f, 0x00061f), (0x00066a, 0x00066d), (0x0006d4, 0x0006d4),
           (0x000700, 0x00070d), (0x000964, 0x000965), (0x000970, 0x000970),
           (0x000df4, 0x000df4), (0x000e4f, 0x000e4f), (0x000e5a, 0x000e5b),
           (0x000f04, 0x000f12), (0x000f85, 0x000f85), (0x00104a, 0x00104f),
           (0x0010fb, 0x0010fb), (0x001361, 0x001368), (0x00166d, 0x00166e),
           (0x0016eb, 0x0016ed), (0x0017d4, 0x0017da), (0x0017dc, 0x0017dc),
           (0x001800, 0x001805), (0x001807, 0x00180a), (0x002016, 0x002017),
           (0x002020, 0x002027), (0x002030, 0x002038), (0x00203b, 0x00203e),
           (0x002041, 0x002043), (0x002048, 0x00204d), (0x003001, 0x003003),
           (0x00fe30, 0x00fe30), (0x00fe49, 0x00fe4c), (0x00fe50, 0x00fe52),
           (0x00fe54, 0x00fe57), (0x00fe5f, 0x00fe61), (0x00fe68, 0x00fe68),
           (0x00fe6a, 0x00fe6b), (0x00ff01, 0x00ff03), (0x00ff05, 0x00ff07),
           (0x00ff0a, 0x00ff0a), (0x00ff0c, 0x00ff0c), (0x00ff0e, 0x00ff0f),
           (0x00ff1a, 0x00ff1b), (0x00ff1f, 0x00ff20), (0x00ff3c, 0x00ff3c),
           (0x00ff61, 0x00ff61), (0x00ff64, 0x00ff64),
         ]),
  # Ps: 38 codepoint markers (*not* codepoints)
  'Ps' : CodePointSet([
           (0x000028, 0x000028), (0x00005b, 0x00005b), (0x00007b, 0x00007b),
           (0x000f3a, 0x000f3a), (0x000f3c, 0x000f3c), (0x00169b, 0x00169b),
           (0x00201a, 0x00201a), (0x00201e, 0x00201e), (0x002045, 0x002045),
           (0x00207d, 0x00207d), (0x00208d, 0x00208d), (0x002329, 0x002329),
           (0x003008, 0x003008), (0x00300a, 0x00300a), (0x00300c, 0x00300c),
           (0x00300e, 0x00300e), (0x003010, 0x003010), (0x003014, 0x003014),
           (0x003016, 0x003016), (0x003018, 0x003018), (0x00301a, 0x00301a),
           (0x00301d, 0x00301d), (0x00fd3e, 0x00fd3e), (0x00fe35, 0x00fe35),
           (0x00fe37, 0x00fe37), (0x00fe39, 0x00fe39), (0x00fe3b, 0x00fe3b),
           (0x00fe3d, 0x00fe3d), (0x00fe3f, 0x00fe3f), (0x00fe41, 0x00fe41),
           (0x00fe43, 0x00fe43), (0x00fe59, 0x00fe59), (0x00fe5b, 0x00fe5b),
           (0x00fe5d, 0x00fe5d), (0x00ff08, 0x00ff08), (0x00ff3b, 0x00ff3b),
           (0x00ff5b, 0x00ff5b), (0x00ff62, 0x00ff62),
         ]),
  # S: 2841 codepoint markers (*not* codepoints)
  'S'  : CodePointSet([
           (0x000024, 0x000024), (0x00002b, 0x00002b), (0x00003c, 0x00003e),
           (0x00005e, 0x00005e), (0x000060, 0x000060), (0x00007c, 0x00007c),
           (0x00007e, 0x00007e), (0x0000a2, 0x0000a9), (0x0000ac, 0x0000ac),
           (0x0000ae, 0x0000b1), (0x0000b4, 0x0000b4), (0x0000b6, 0x0000b6),
           (0x0000b8, 0x0000b8), (0x0000d7, 0x0000d7), (0x0000f7, 0x0000f7),
           (0x0002b9, 0x0002ba), (0x0002c2, 0x0002cf), (0x0002d2, 0x0002df),
           (0x0002e5, 0x0002ed), (0x000374, 0x000375), (0x000384, 0x000385),
           (0x000482, 0x000482), (0x0006e9, 0x0006e9), (0x0006fd, 0x0006fe),
           (0x0009f2, 0x0009f3), (0x0009fa, 0x0009fa), (0x000b70, 0x000b70),
           (0x000e3f, 0x000e3f), (0x000f01, 0x000f03), (0x000f13, 0x000f17),
           (0x000f1a, 0x000f1f), (0x000f34, 0x000f34), (0x000f36, 0x000f36),
           (0x000f38, 0x000f38), (0x000fbe, 0x000fc5), (0x000fc7, 0x000fcc),
           (0x000fcf, 0x000fcf), (0x0017db, 0x0017db), (0x001fbd, 0x001fbd),
           (0x001fbf, 0x001fc1), (0x001fcd, 0x001fcf), (0x001fdd, 0x001fdf),
           (0x001fed, 0x001fef), (0x001ffd, 0x001ffe), (0x002044, 0x002044),
           (0x00207a, 0x00207c), (0x00208a, 0x00208c), (0x0020a0, 0x0020af),
           (0x002100, 0x002101), (0x002103, 0x002106), (0x002108, 0x002109),
           (0x002114, 0x002114), (0x002116, 0x002118), (0x00211e, 0x002123),
           (0x002125, 0x002125), (0x002127, 0x002127), (0x002129, 0x002129),
           (0x00212e, 0x00212e), (0x002132, 0x002132), (0x00213a, 0x00213a),
           (0x002190, 0x0021f3), (0x002200, 0x0022f1), (0x002300, 0x002328),
           (0x00232b, 0x00237b), (0x00237d, 0x00239a), (0x002400, 0x002426),
           (0x002440, 0x00244a), (0x00249c, 0x0024e9), (0x002500, 0x002595),
           (0x0025a0, 0x0025f7), (0x002600, 0x002613), (0x002619, 0x002671),
           (0x002701, 0x002704), (0x002706, 0x002709), (0x00270c, 0x002727),
           (0x002729, 0x00274b), (0x00274d, 0x00274d), (0x00274f, 0x002752),
           (0x002756, 0x002756), (0x002758, 0x00275e), (0x002761, 0x002767),
           (0x002794, 0x002794), (0x002798, 0x0027af), (0x0027b1, 0x0027be),
           (0x002800, 0x0028ff), (0x002e80, 0x002e99), (0x002e9b, 0x002ef3),
           (0x002f00, 0x002fd5), (0x002ff0, 0x002ffb), (0x003004, 0x003004),
           (0x003012, 0x003013), (0x003020, 0x003020), (0x003036, 0x003037),
           (0x00303e, 0x00303f), (0x00309b, 0x00309c), (0x003190, 0x003191),
           (0x003196, 0x00319f), (0x003200, 0x00321c), (0x00322a, 0x003243),
           (0x003260, 0x00327b), (0x00327f, 0x00327f), (0x00328a, 0x0032b0),
           (0x0032c0, 0x0032cb), (0x0032d0, 0x0032fe), (0x003300, 0x003376),
           (0x00337b, 0x0033dd), (0x0033e0, 0x0033fe), (0x00a490, 0x00a4a1),
           (0x00a4a4, 0x00a4b3), (0x00a4b5, 0x00a4c0), (0x00a4c2, 0x00a4c4),
           (0x00a4c6, 0x00a4c6), (0x00fb29, 0x00fb29), (0x00fe62, 0x00fe62),
           (0x00fe64, 0x00fe66), (0x00fe69, 0x00fe69), (0x00ff04, 0x00ff04),
           (0x00ff0b, 0x00ff0b), (0x00ff1c, 0x00ff1e), (0x00ff3e, 0x00ff3e),
           (0x00ff40, 0x00ff40), (0x00ff5c, 0x00ff5c), (0x00ff5e, 0x00ff5e),
           (0x00ffe0, 0x00ffe6), (0x00ffe8, 0x00ffee), (0x00fffc, 0x00fffd),
           (0x01d000, 0x01d0f5), (0x01d100, 0x01d126), (0x01d12a, 0x01d164),
           (0x01d16a, 0x01d16c), (0x01d183, 0x01d184), (0x01d18c, 0x01d1a9),
           (0x01d1ae, 0x01d1dd), (0x01d6c1, 0x01d6c1), (0x01d6db, 0x01d6db),
           (0x01d6fb, 0x01d6fb), (0x01d715, 0x01d715), (0x01d735, 0x01d735),
           (0x01d74f, 0x01d74f), (0x01d76f, 0x01d76f), (0x01d789, 0x01d789),
           (0x01d7a9, 0x01d7a9), (0x01d7c3, 0x01d7c3),
         ]),
  # Sc: 31 codepoint markers (*not* codepoints)
  'Sc' : CodePointSet([
           (0x000024, 0x000024), (0x0000a2, 0x0000a5), (0x0009f2, 0x0009f3),
           (0x000e3f, 0x000e3f), (0x0017db, 0x0017db), (0x0020a0, 0x0020af),
           (0x00fe69, 0x00fe69), (0x00ff04, 0x00ff04), (0x00ffe0, 0x00ffe1),
           (0x00ffe5, 0x00ffe6),
         ]),
  # Sk: 69 codepoint markers (*not* codepoints)
  'Sk' : CodePointSet([
           (0x00005e, 0x00005e), (0x000060, 0x000060), (0x0000a8, 0x0000a8),
           (0x0000af, 0x0000af), (0x0000b4, 0x0000b4), (0x0000b8, 0x0000b8),
           (0x0002b9, 0x0002ba), (0x0002c2, 0x0002cf), (0x0002d2, 0x0002df),
           (0x0002e5, 0x0002ed), (0x000374, 0x000375), (0x000384, 0x000385),
           (0x001fbd, 0x001fbd), (0x001fbf, 0x001fc1), (0x001fcd, 0x001fcf),
           (0x001fdd, 0x001fdf), (0x001fed, 0x001fef), (0x001ffd, 0x001ffe),
           (0x00309b, 0x00309c), (0x00ff3e, 0x00ff3e), (0x00ff40, 0x00ff40),
           (0x00ffe3, 0x00ffe3),
         ]),
  # Sm: 309 codepoint markers (*not* codepoints)
  'Sm' : CodePointSet([
           (0x00002b, 0x00002b), (0x00003c, 0x00003e), (0x00007c, 0x00007c),
           (0x00007e, 0x00007e), (0x0000ac, 0x0000ac), (0x0000b1, 0x0000b1),
           (0x0000d7, 0x0000d7), (0x0000f7, 0x0000f7), (0x002044, 0x002044),
           (0x00207a, 0x00207c), (0x00208a, 0x00208c), (0x002190, 0x002194),
           (0x00219a, 0x00219b), (0x0021a0, 0x0021a0), (0x0021a3, 0x0021a3),
           (0x0021a6, 0x0021a6), (0x0021ae, 0x0021ae), (0x0021ce, 0x0021cf),
           (0x0021d2, 0x0021d2), (0x0021d4, 0x0021d4), (0x002200, 0x0022f1),
           (0x002308, 0x00230b), (0x002320, 0x002321), (0x0025b7, 0x0025b7),
           (0x0025c1, 0x0025c1), (0x00266f, 0x00266f), (0x00fb29, 0x00fb29),
           (0x00fe62, 0x00fe62), (0x00fe64, 0x00fe66), (0x00ff0b, 0x00ff0b),
           (0x00ff1c, 0x00ff1e), (0x00ff5c, 0x00ff5c), (0x00ff5e, 0x00ff5e),
           (0x00ffe2, 0x00ffe2), (0x00ffe9, 0x00ffec), (0x01d6c1, 0x01d6c1),
           (0x01d6db, 0x01d6db), (0x01d6fb, 0x01d6fb), (0x01d715, 0x01d715),
           (0x01d735, 0x01d735), (0x01d74f, 0x01d74f), (0x01d76f, 0x01d76f),
           (0x01d789, 0x01d789), (0x01d7a9, 0x01d7a9), (0x01d7c3, 0x01d7c3),
         ]),
  # So: 2432 codepoint markers (*not* codepoints)
  'So' : CodePointSet([
           (0x0000a6, 0x0000a7), (0x0000a9, 0x0000a9), (0x0000ae, 0x0000ae),
           (0x0000b0, 0x0000b0), (0x0000b6, 0x0000b6), (0x000482, 0x000482),
           (0x0006e9, 0x0006e9), (0x0006fd, 0x0006fe), (0x0009fa, 0x0009fa),
           (0x000b70, 0x000b70), (0x000f01, 0x000f03), (0x000f13, 0x000f17),
           (0x000f1a, 0x000f1f), (0x000f34, 0x000f34), (0x000f36, 0x000f36),
           (0x000f38, 0x000f38), (0x000fbe, 0x000fc5), (0x000fc7, 0x000fcc),
           (0x000fcf, 0x000fcf), (0x002100, 0x002101), (0x002103, 0x002106),
           (0x002108, 0x002109), (0x002114, 0x002114), (0x002116, 0x002118),
           (0x00211e, 0x002123), (0x002125, 0x002125), (0x002127, 0x002127),
           (0x002129, 0x002129), (0x00212e, 0x00212e), (0x002132, 0x002132),
           (0x00213a, 0x00213a), (0x002195, 0x002199), (0x00219c, 0x00219f),
           (0x0021a1, 0x0021a2), (0x0021a4, 0x0021a5), (0x0021a7, 0x0021ad),
           (0x0021af, 0x0021cd), (0x0021d0, 0x0021d1), (0x0021d3, 0x0021d3),
           (0x0021d5, 0x0021f3), (0x002300, 0x002307), (0x00230c, 0x00231f),
           (0x002322, 0x002328), (0x00232b, 0x00237b), (0x00237d, 0x00239a),
           (0x002400, 0x002426), (0x002440, 0x00244a), (0x00249c, 0x0024e9),
           (0x002500, 0x002595), (0x0025a0, 0x0025b6), (0x0025b8, 0x0025c0),
           (0x0025c2, 0x0025f7), (0x002600, 0x002613), (0x002619, 0x00266e),
           (0x002670, 0x002671), (0x002701, 0x002704), (0x002706, 0x002709),
           (0x00270c, 0x002727), (0x002729, 0x00274b), (0x00274d, 0x00274d),
           (0x00274f, 0x002752), (0x002756, 0x002756), (0x002758, 0x00275e),
           (0x002761, 0x002767), (0x002794, 0x002794), (0x002798, 0x0027af),
           (0x0027b1, 0x0027be), (0x002800, 0x0028ff), (0x002e80, 0x002e99),
           (0x002e9b, 0x002ef3), (0x002f00, 0x002fd5), (0x002ff0, 0x002ffb),
           (0x003004, 0x003004), (0x003012, 0x003013), (0x003020, 0x003020),
           (0x003036, 0x003037), (0x00303e, 0x00303f), (0x003190, 0x003191),
           (0x003196, 0x00319f), (0x003200, 0x00321c), (0x00322a, 0x003243),
           (0x003260, 0x00327b), (0x00327f, 0x00327f), (0x00328a, 0x0032b0),
           (0x0032c0, 0x0032cb), (0x0032d0, 0x0032fe), (0x003300, 0x003376),
           (0x00337b, 0x0033dd), (0x0033e0, 0x0033fe), (0x00a490, 0x00a4a1),
           (0x00a4a4, 0x00a4b3), (0x00a4b5, 0x00a4c0), (0x00a4c2, 0x00a4c4),
           (0x00a4c6, 0x00a4c6), (0x00ffe4, 0x00ffe4), (0x00ffe8, 0x00ffe8),
           (0x00ffed, 0x00ffee), (0x00fffc, 0x00fffd), (0x01d000, 0x01d0f5),
           (0x01d100, 0x01d126), (0x01d12a, 0x01d164), (0x01d16a, 0x01d16c),
           (0x01d183, 0x01d184), (0x01d18c, 0x01d1a9), (0x01d1ae, 0x01d1dd),
         ]),
  # Z: 19 codepoint markers (*not* codepoints)
  'Z'  : CodePointSet([
           (0x000020, 0x000020), (0x0000a0, 0x0000a0), (0x001680, 0x001680),
           (0x002000, 0x00200b), (0x002028, 0x002029), (0x00202f, 0x00202f),
           (0x003000, 0x003000),
         ]),
  # Zl: 1 codepoint markers (*not* codepoints)
  'Zl' : CodePointSet([
           (0x002028, 0x002028),
         ]),
  # Zp: 1 codepoint markers (*not* codepoints)
  'Zp' : CodePointSet([
           (0x002029, 0x002029),
         ]),
  # Zs: 17 codepoint markers (*not* codepoints)
  'Zs' : CodePointSet([
           (0x000020, 0x000020), (0x0000a0, 0x0000a0), (0x001680, 0x001680),
           (0x002000, 0x00200b), (0x00202f, 0x00202f), (0x003000, 0x003000),
         ]),
  }
