# ./pyxb/bundles/opengis/raw/_nsgroup.py
# PyXB bindings for NamespaceGroupModule
# NGM:31dc9d33ae09dae9cd9938ac948b7eee03f73812
# Incorporated namespaces:
#  http://www.isotc211.org/2005/gts gts
#  http://www.isotc211.org/2005/gsr gsr
#  http://www.isotc211.org/2005/gco gco
#  http://www.opengis.net/gml/3.2 gml
#  http://www.isotc211.org/2005/gss gss
#  http://www.isotc211.org/2005/gmd gmd

import pyxb
import pyxb.binding
import pyxb.utils.utility

# Unique identifier for bindings created at the same time
_GenerationUID = pyxb.utils.utility.UniqueIdentifier('urn:uuid:bad804a6-de0d-11de-a8dc-001cc05930fc')

# Import bindings for schemas in group
import pyxb.binding.datatypes
import pyxb.bundles.opengis.misc.xlinks

_Namespace_gco = pyxb.namespace.NamespaceForURI(u'http://www.isotc211.org/2005/gco', create_if_missing=True)
_Namespace_gco.configureCategories(['typeBinding', 'elementBinding'])
_Namespace_gmd = pyxb.namespace.NamespaceForURI(u'http://www.isotc211.org/2005/gmd', create_if_missing=True)
_Namespace_gmd.configureCategories(['typeBinding', 'elementBinding'])
_Namespace_gml = pyxb.namespace.NamespaceForURI(u'http://www.opengis.net/gml/3.2', create_if_missing=True)
_Namespace_gml.configureCategories(['typeBinding', 'elementBinding'])
_Namespace_xlink = pyxb.namespace.NamespaceForURI(u'http://www.w3.org/1999/xlink', create_if_missing=True)
_Namespace_xlink.configureCategories(['typeBinding', 'elementBinding'])
_Namespace_gts = pyxb.namespace.NamespaceForURI(u'http://www.isotc211.org/2005/gts', create_if_missing=True)
_Namespace_gts.configureCategories(['typeBinding', 'elementBinding'])
_Namespace_gss = pyxb.namespace.NamespaceForURI(u'http://www.isotc211.org/2005/gss', create_if_missing=True)
_Namespace_gss.configureCategories(['typeBinding', 'elementBinding'])
_Namespace_gsr = pyxb.namespace.NamespaceForURI(u'http://www.isotc211.org/2005/gsr', create_if_missing=True)
_Namespace_gsr.configureCategories(['typeBinding', 'elementBinding'])

# Atomic SimpleTypeDefinition
class STD_ANON_1 (pyxb.binding.datatypes.string, pyxb.binding.basis.enumeration_mixin):

    """An atomic simple type."""

    _ExpandedName = None
    _Documentation = None
STD_ANON_1._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=STD_ANON_1, enum_prefix=None)
STD_ANON_1.inapplicable = STD_ANON_1._CF_enumeration.addEnumeration(unicode_value=u'inapplicable')
STD_ANON_1.missing = STD_ANON_1._CF_enumeration.addEnumeration(unicode_value=u'missing')
STD_ANON_1.template = STD_ANON_1._CF_enumeration.addEnumeration(unicode_value=u'template')
STD_ANON_1.unknown = STD_ANON_1._CF_enumeration.addEnumeration(unicode_value=u'unknown')
STD_ANON_1.withheld = STD_ANON_1._CF_enumeration.addEnumeration(unicode_value=u'withheld')
STD_ANON_1._InitializeFacetMap(STD_ANON_1._CF_enumeration)

# Atomic SimpleTypeDefinition
class STD_ANON_2 (pyxb.binding.datatypes.string):

    """An atomic simple type."""

    _ExpandedName = None
    _Documentation = None
STD_ANON_2._CF_pattern = pyxb.binding.facets.CF_pattern()
STD_ANON_2._CF_pattern.addPattern(pattern=u'other:\\w{2,}')
STD_ANON_2._InitializeFacetMap(STD_ANON_2._CF_pattern)

# Union SimpleTypeDefinition
# superclasses pyxb.binding.datatypes.anySimpleType
class NilReasonType (pyxb.binding.basis.STD_union):

    """gml:NilReasonType defines a content model that allows recording of an explanation for a void value or other exception.
gml:NilReasonType is a union of the following enumerated values:
-	inapplicable there is no value
-	missing the correct value is not readily available to the sender of this data. Furthermore, a correct value may not exist
-	template the value will be available later
-	unknown the correct value is not known to, and not computable by, the sender of this data. However, a correct value probably exists
-	withheld the value is not divulged
-	other:text other brief explanation, where text is a string of two or more characters with no included spaces
and
-	anyURI which should refer to a resource which describes the reason for the exception
A particular community may choose to assign more detailed semantics to the standard values provided. Alternatively, the URI method enables a specific or more complete explanation for the absence of a value to be provided elsewhere and indicated by-reference in an instance document.
gml:NilReasonType is used as a member of a union in a number of simple content types where it is necessary to permit a value from the NilReasonType union as an alternative to the primary type."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'NilReasonType')
    _Documentation = u'gml:NilReasonType defines a content model that allows recording of an explanation for a void value or other exception.\ngml:NilReasonType is a union of the following enumerated values:\n-\tinapplicable there is no value\n-\tmissing the correct value is not readily available to the sender of this data. Furthermore, a correct value may not exist\n-\ttemplate the value will be available later\n-\tunknown the correct value is not known to, and not computable by, the sender of this data. However, a correct value probably exists\n-\twithheld the value is not divulged\n-\tother:text other brief explanation, where text is a string of two or more characters with no included spaces\nand\n-\tanyURI which should refer to a resource which describes the reason for the exception\nA particular community may choose to assign more detailed semantics to the standard values provided. Alternatively, the URI method enables a specific or more complete explanation for the absence of a value to be provided elsewhere and indicated by-reference in an instance document.\ngml:NilReasonType is used as a member of a union in a number of simple content types where it is necessary to permit a value from the NilReasonType union as an alternative to the primary type.'

    _MemberTypes = ( STD_ANON_1, STD_ANON_2, pyxb.binding.datatypes.anyURI, )
NilReasonType._CF_pattern = pyxb.binding.facets.CF_pattern()
NilReasonType._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=NilReasonType)
NilReasonType.inapplicable = u'inapplicable'      # originally STD_ANON_1.inapplicable
NilReasonType.missing = u'missing'                # originally STD_ANON_1.missing
NilReasonType.template = u'template'              # originally STD_ANON_1.template
NilReasonType.unknown = u'unknown'                # originally STD_ANON_1.unknown
NilReasonType.withheld = u'withheld'              # originally STD_ANON_1.withheld
NilReasonType._InitializeFacetMap(NilReasonType._CF_pattern,
   NilReasonType._CF_enumeration)
_Namespace_gml.addCategoryObject('typeBinding', u'NilReasonType', NilReasonType)

# Atomic SimpleTypeDefinition
class SurfaceInterpolationType (pyxb.binding.datatypes.string, pyxb.binding.basis.enumeration_mixin):

    """gml:SurfaceInterpolationType is a list of codes that may be used to identify the interpolation mechanisms specified by an application schema."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'SurfaceInterpolationType')
    _Documentation = u'gml:SurfaceInterpolationType is a list of codes that may be used to identify the interpolation mechanisms specified by an application schema.'
SurfaceInterpolationType._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=SurfaceInterpolationType, enum_prefix=None)
SurfaceInterpolationType.none = SurfaceInterpolationType._CF_enumeration.addEnumeration(unicode_value=u'none')
SurfaceInterpolationType.planar = SurfaceInterpolationType._CF_enumeration.addEnumeration(unicode_value=u'planar')
SurfaceInterpolationType.spherical = SurfaceInterpolationType._CF_enumeration.addEnumeration(unicode_value=u'spherical')
SurfaceInterpolationType.elliptical = SurfaceInterpolationType._CF_enumeration.addEnumeration(unicode_value=u'elliptical')
SurfaceInterpolationType.conic = SurfaceInterpolationType._CF_enumeration.addEnumeration(unicode_value=u'conic')
SurfaceInterpolationType.tin = SurfaceInterpolationType._CF_enumeration.addEnumeration(unicode_value=u'tin')
SurfaceInterpolationType.parametricCurve = SurfaceInterpolationType._CF_enumeration.addEnumeration(unicode_value=u'parametricCurve')
SurfaceInterpolationType.polynomialSpline = SurfaceInterpolationType._CF_enumeration.addEnumeration(unicode_value=u'polynomialSpline')
SurfaceInterpolationType.rationalSpline = SurfaceInterpolationType._CF_enumeration.addEnumeration(unicode_value=u'rationalSpline')
SurfaceInterpolationType.triangulatedSpline = SurfaceInterpolationType._CF_enumeration.addEnumeration(unicode_value=u'triangulatedSpline')
SurfaceInterpolationType._InitializeFacetMap(SurfaceInterpolationType._CF_enumeration)
_Namespace_gml.addCategoryObject('typeBinding', u'SurfaceInterpolationType', SurfaceInterpolationType)

# Atomic SimpleTypeDefinition
class DegreeValueType (pyxb.binding.datatypes.nonNegativeInteger):

    """An atomic simple type."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'DegreeValueType')
    _Documentation = ''
DegreeValueType._CF_maxInclusive = pyxb.binding.facets.CF_maxInclusive(value_datatype=DegreeValueType, value=pyxb.binding.datatypes.nonNegativeInteger(359L))
DegreeValueType._InitializeFacetMap(DegreeValueType._CF_maxInclusive)
_Namespace_gml.addCategoryObject('typeBinding', u'DegreeValueType', DegreeValueType)

# Atomic SimpleTypeDefinition
class STD_ANON_3 (pyxb.binding.datatypes.string, pyxb.binding.basis.enumeration_mixin):

    """An atomic simple type."""

    _ExpandedName = None
    _Documentation = None
STD_ANON_3._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=STD_ANON_3, enum_prefix=None)
STD_ANON_3.N = STD_ANON_3._CF_enumeration.addEnumeration(unicode_value=u'N')
STD_ANON_3.E = STD_ANON_3._CF_enumeration.addEnumeration(unicode_value=u'E')
STD_ANON_3.S = STD_ANON_3._CF_enumeration.addEnumeration(unicode_value=u'S')
STD_ANON_3.W = STD_ANON_3._CF_enumeration.addEnumeration(unicode_value=u'W')
STD_ANON_3.emptyString = STD_ANON_3._CF_enumeration.addEnumeration(unicode_value=u'+')
STD_ANON_3.emptyString_ = STD_ANON_3._CF_enumeration.addEnumeration(unicode_value=u'-')
STD_ANON_3._InitializeFacetMap(STD_ANON_3._CF_enumeration)

# Atomic SimpleTypeDefinition
class SignType (pyxb.binding.datatypes.string, pyxb.binding.basis.enumeration_mixin):

    """gml:SignType is a convenience type with values "+" (plus) and "-" (minus)."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'SignType')
    _Documentation = u'gml:SignType is a convenience type with values "+" (plus) and "-" (minus).'
SignType._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=SignType, enum_prefix=None)
SignType.emptyString = SignType._CF_enumeration.addEnumeration(unicode_value=u'-')
SignType.emptyString_ = SignType._CF_enumeration.addEnumeration(unicode_value=u'+')
SignType._InitializeFacetMap(SignType._CF_enumeration)
_Namespace_gml.addCategoryObject('typeBinding', u'SignType', SignType)

# Atomic SimpleTypeDefinition
class AggregationType (pyxb.binding.datatypes.string, pyxb.binding.basis.enumeration_mixin):

    """An atomic simple type."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AggregationType')
    _Documentation = None
AggregationType._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=AggregationType, enum_prefix=None)
AggregationType.set = AggregationType._CF_enumeration.addEnumeration(unicode_value=u'set')
AggregationType.bag = AggregationType._CF_enumeration.addEnumeration(unicode_value=u'bag')
AggregationType.sequence = AggregationType._CF_enumeration.addEnumeration(unicode_value=u'sequence')
AggregationType.array = AggregationType._CF_enumeration.addEnumeration(unicode_value=u'array')
AggregationType.record = AggregationType._CF_enumeration.addEnumeration(unicode_value=u'record')
AggregationType.table = AggregationType._CF_enumeration.addEnumeration(unicode_value=u'table')
AggregationType._InitializeFacetMap(AggregationType._CF_enumeration)
_Namespace_gml.addCategoryObject('typeBinding', u'AggregationType', AggregationType)

# Union SimpleTypeDefinition
# superclasses pyxb.binding.datatypes.anySimpleType
class doubleOrNilReason (pyxb.binding.basis.STD_union):

    """Extension to the respective XML Schema built-in simple type to allow a choice of either a value of the built-in simple type or a reason for a nil value."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'doubleOrNilReason')
    _Documentation = u'Extension to the respective XML Schema built-in simple type to allow a choice of either a value of the built-in simple type or a reason for a nil value.'

    _MemberTypes = ( STD_ANON_1, STD_ANON_2, pyxb.binding.datatypes.double, pyxb.binding.datatypes.anyURI, )
doubleOrNilReason._CF_pattern = pyxb.binding.facets.CF_pattern()
doubleOrNilReason._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=doubleOrNilReason)
doubleOrNilReason.inapplicable = u'inapplicable'  # originally STD_ANON_1.inapplicable
doubleOrNilReason.missing = u'missing'            # originally STD_ANON_1.missing
doubleOrNilReason.template = u'template'          # originally STD_ANON_1.template
doubleOrNilReason.unknown = u'unknown'            # originally STD_ANON_1.unknown
doubleOrNilReason.withheld = u'withheld'          # originally STD_ANON_1.withheld
doubleOrNilReason._InitializeFacetMap(doubleOrNilReason._CF_pattern,
   doubleOrNilReason._CF_enumeration)
_Namespace_gml.addCategoryObject('typeBinding', u'doubleOrNilReason', doubleOrNilReason)

# List SimpleTypeDefinition
# superclasses pyxb.binding.datatypes.anySimpleType
class doubleOrNilReasonList (pyxb.binding.basis.STD_list):

    """A type for a list of values of the respective simple type."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'doubleOrNilReasonList')
    _Documentation = u'A type for a list of values of the respective simple type.'

    _ItemType = doubleOrNilReason
doubleOrNilReasonList._InitializeFacetMap()
_Namespace_gml.addCategoryObject('typeBinding', u'doubleOrNilReasonList', doubleOrNilReasonList)

# List SimpleTypeDefinition
# superclasses doubleOrNilReasonList
class STD_ANON_4 (pyxb.binding.basis.STD_list):

    """Simple type that is a list of doubleOrNilReason."""

    _ExpandedName = None
    _Documentation = None

    _ItemType = doubleOrNilReason
STD_ANON_4._CF_length = pyxb.binding.facets.CF_length(value=pyxb.binding.datatypes.nonNegativeInteger(2L))
STD_ANON_4._InitializeFacetMap(STD_ANON_4._CF_length)

# List SimpleTypeDefinition
# superclasses pyxb.binding.datatypes.anySimpleType
class doubleList (pyxb.binding.basis.STD_list):

    """A type for a list of values of the respective simple type."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'doubleList')
    _Documentation = u'A type for a list of values of the respective simple type.'

    _ItemType = pyxb.binding.datatypes.double
doubleList._InitializeFacetMap()
_Namespace_gml.addCategoryObject('typeBinding', u'doubleList', doubleList)

# List SimpleTypeDefinition
# superclasses pyxb.binding.datatypes.anySimpleType
class NCNameList (pyxb.binding.basis.STD_list):

    """A type for a list of values of the respective simple type."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'NCNameList')
    _Documentation = u'A type for a list of values of the respective simple type.'

    _ItemType = pyxb.binding.datatypes.NCName
NCNameList._InitializeFacetMap()
_Namespace_gml.addCategoryObject('typeBinding', u'NCNameList', NCNameList)

# Union SimpleTypeDefinition
# superclasses pyxb.binding.datatypes.anySimpleType
class NameOrNilReason (pyxb.binding.basis.STD_union):

    """Extension to the respective XML Schema built-in simple type to allow a choice of either a value of the built-in simple type or a reason for a nil value."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'NameOrNilReason')
    _Documentation = u'Extension to the respective XML Schema built-in simple type to allow a choice of either a value of the built-in simple type or a reason for a nil value.'

    _MemberTypes = ( STD_ANON_1, STD_ANON_2, pyxb.binding.datatypes.Name, pyxb.binding.datatypes.anyURI, )
NameOrNilReason._CF_pattern = pyxb.binding.facets.CF_pattern()
NameOrNilReason._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=NameOrNilReason)
NameOrNilReason.inapplicable = u'inapplicable'    # originally STD_ANON_1.inapplicable
NameOrNilReason.missing = u'missing'              # originally STD_ANON_1.missing
NameOrNilReason.template = u'template'            # originally STD_ANON_1.template
NameOrNilReason.unknown = u'unknown'              # originally STD_ANON_1.unknown
NameOrNilReason.withheld = u'withheld'            # originally STD_ANON_1.withheld
NameOrNilReason._InitializeFacetMap(NameOrNilReason._CF_pattern,
   NameOrNilReason._CF_enumeration)
_Namespace_gml.addCategoryObject('typeBinding', u'NameOrNilReason', NameOrNilReason)

# List SimpleTypeDefinition
# superclasses pyxb.binding.datatypes.anySimpleType
class NameOrNilReasonList (pyxb.binding.basis.STD_list):

    """A type for a list of values of the respective simple type."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'NameOrNilReasonList')
    _Documentation = u'A type for a list of values of the respective simple type.'

    _ItemType = NameOrNilReason
NameOrNilReasonList._InitializeFacetMap()
_Namespace_gml.addCategoryObject('typeBinding', u'NameOrNilReasonList', NameOrNilReasonList)

# Atomic SimpleTypeDefinition
class UomSymbol (pyxb.binding.datatypes.string):

    """This type specifies a character string of length at least one, and restricted such that it must not contain any of the following characters: ":" (colon), " " (space), (newline), (carriage return), (tab). This allows values corresponding to familiar abbreviations, such as "kg", "m/s", etc. 
It is recommended that the symbol be an identifier for a unit of measure as specified in the "Unified Code of Units of Measure" (UCUM) (http://aurora.regenstrief.org/UCUM). This provides a set of symbols and a grammar for constructing identifiers for units of measure that are unique, and may be easily entered with a keyboard supporting the limited character set known as 7-bit ASCII. ISO 2955 formerly provided a specification with this scope, but was withdrawn in 2001. UCUM largely follows ISO 2955 with modifications to remove ambiguities and other problems."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'UomSymbol')
    _Documentation = u'This type specifies a character string of length at least one, and restricted such that it must not contain any of the following characters: ":" (colon), " " (space), (newline), (carriage return), (tab). This allows values corresponding to familiar abbreviations, such as "kg", "m/s", etc. \nIt is recommended that the symbol be an identifier for a unit of measure as specified in the "Unified Code of Units of Measure" (UCUM) (http://aurora.regenstrief.org/UCUM). This provides a set of symbols and a grammar for constructing identifiers for units of measure that are unique, and may be easily entered with a keyboard supporting the limited character set known as 7-bit ASCII. ISO 2955 formerly provided a specification with this scope, but was withdrawn in 2001. UCUM largely follows ISO 2955 with modifications to remove ambiguities and other problems.'
UomSymbol._CF_pattern = pyxb.binding.facets.CF_pattern()
UomSymbol._CF_pattern.addPattern(pattern=u'[^: \\n\\r\\t]+')
UomSymbol._InitializeFacetMap(UomSymbol._CF_pattern)
_Namespace_gml.addCategoryObject('typeBinding', u'UomSymbol', UomSymbol)

# Atomic SimpleTypeDefinition
class UomURI (pyxb.binding.datatypes.anyURI):

    """This type specifies a URI, restricted such that it must start with one of the following sequences: "#", "./", "../", or a string of characters followed by a ":". These patterns ensure that the most common URI forms are supported, including absolute and relative URIs and URIs that are simple fragment identifiers, but prohibits certain forms of relative URI that could be mistaken for unit of measure symbol . 
NOTE	It is possible to re-write such a relative URI to conform to the restriction (e.g. "./m/s").
In an instance document, on elements of type gml:MeasureType the mandatory uom attribute shall carry a value corresponding to either 
-	a conventional unit of measure symbol,
-	a link to a definition of a unit of measure that does not have a conventional symbol, or when it is desired to indicate a precise or variant definition."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'UomURI')
    _Documentation = u'This type specifies a URI, restricted such that it must start with one of the following sequences: "#", "./", "../", or a string of characters followed by a ":". These patterns ensure that the most common URI forms are supported, including absolute and relative URIs and URIs that are simple fragment identifiers, but prohibits certain forms of relative URI that could be mistaken for unit of measure symbol . \nNOTE\tIt is possible to re-write such a relative URI to conform to the restriction (e.g. "./m/s").\nIn an instance document, on elements of type gml:MeasureType the mandatory uom attribute shall carry a value corresponding to either \n-\ta conventional unit of measure symbol,\n-\ta link to a definition of a unit of measure that does not have a conventional symbol, or when it is desired to indicate a precise or variant definition.'
UomURI._CF_pattern = pyxb.binding.facets.CF_pattern()
UomURI._CF_pattern.addPattern(pattern=u'([a-zA-Z][a-zA-Z0-9\\-\\+\\.]*:|\\.\\./|\\./|#).*')
UomURI._InitializeFacetMap(UomURI._CF_pattern)
_Namespace_gml.addCategoryObject('typeBinding', u'UomURI', UomURI)

# Union SimpleTypeDefinition
# superclasses pyxb.binding.datatypes.anySimpleType
class UomIdentifier (pyxb.binding.basis.STD_union):

    """The simple type gml:UomIdentifer defines the syntax and value space of the unit of measure identifier."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'UomIdentifier')
    _Documentation = u'The simple type gml:UomIdentifer defines the syntax and value space of the unit of measure identifier.'

    _MemberTypes = ( UomSymbol, UomURI, )
UomIdentifier._CF_pattern = pyxb.binding.facets.CF_pattern()
UomIdentifier._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=UomIdentifier)
UomIdentifier._InitializeFacetMap(UomIdentifier._CF_pattern,
   UomIdentifier._CF_enumeration)
_Namespace_gml.addCategoryObject('typeBinding', u'UomIdentifier', UomIdentifier)

# Atomic SimpleTypeDefinition
class ArcMinutesType (pyxb.binding.datatypes.nonNegativeInteger):

    """An atomic simple type."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'ArcMinutesType')
    _Documentation = ''
ArcMinutesType._CF_maxInclusive = pyxb.binding.facets.CF_maxInclusive(value_datatype=ArcMinutesType, value=pyxb.binding.datatypes.nonNegativeInteger(59L))
ArcMinutesType._InitializeFacetMap(ArcMinutesType._CF_maxInclusive)
_Namespace_gml.addCategoryObject('typeBinding', u'ArcMinutesType', ArcMinutesType)

# Atomic SimpleTypeDefinition
class DecimalMinutesType (pyxb.binding.datatypes.decimal):

    """An atomic simple type."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'DecimalMinutesType')
    _Documentation = ''
DecimalMinutesType._CF_minInclusive = pyxb.binding.facets.CF_minInclusive(value_datatype=DecimalMinutesType, value=pyxb.binding.datatypes.decimal(0.0))
DecimalMinutesType._CF_maxExclusive = pyxb.binding.facets.CF_maxExclusive(value_datatype=pyxb.binding.datatypes.decimal, value=pyxb.binding.datatypes.anySimpleType(u'60.00'))
DecimalMinutesType._InitializeFacetMap(DecimalMinutesType._CF_minInclusive,
   DecimalMinutesType._CF_maxExclusive)
_Namespace_gml.addCategoryObject('typeBinding', u'DecimalMinutesType', DecimalMinutesType)

# List SimpleTypeDefinition
# superclasses pyxb.binding.datatypes.anySimpleType
class booleanList (pyxb.binding.basis.STD_list):

    """A type for a list of values of the respective simple type."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'booleanList')
    _Documentation = u'A type for a list of values of the respective simple type.'

    _ItemType = pyxb.binding.datatypes.boolean
booleanList._InitializeFacetMap()
_Namespace_gml.addCategoryObject('typeBinding', u'booleanList', booleanList)

# List SimpleTypeDefinition
# superclasses pyxb.binding.datatypes.anySimpleType
class NameList (pyxb.binding.basis.STD_list):

    """A type for a list of values of the respective simple type."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'NameList')
    _Documentation = u'A type for a list of values of the respective simple type.'

    _ItemType = pyxb.binding.datatypes.Name
NameList._InitializeFacetMap()
_Namespace_gml.addCategoryObject('typeBinding', u'NameList', NameList)

# Atomic SimpleTypeDefinition
class MD_PixelOrientationCode_Type (pyxb.binding.datatypes.string, pyxb.binding.basis.enumeration_mixin):

    """An atomic simple type."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_PixelOrientationCode_Type')
    _Documentation = None
MD_PixelOrientationCode_Type._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=MD_PixelOrientationCode_Type, enum_prefix=None)
MD_PixelOrientationCode_Type.center = MD_PixelOrientationCode_Type._CF_enumeration.addEnumeration(unicode_value=u'center')
MD_PixelOrientationCode_Type.lowerLeft = MD_PixelOrientationCode_Type._CF_enumeration.addEnumeration(unicode_value=u'lowerLeft')
MD_PixelOrientationCode_Type.lowerRight = MD_PixelOrientationCode_Type._CF_enumeration.addEnumeration(unicode_value=u'lowerRight')
MD_PixelOrientationCode_Type.upperRight = MD_PixelOrientationCode_Type._CF_enumeration.addEnumeration(unicode_value=u'upperRight')
MD_PixelOrientationCode_Type.upperLeft = MD_PixelOrientationCode_Type._CF_enumeration.addEnumeration(unicode_value=u'upperLeft')
MD_PixelOrientationCode_Type._InitializeFacetMap(MD_PixelOrientationCode_Type._CF_enumeration)
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_PixelOrientationCode_Type', MD_PixelOrientationCode_Type)

# Atomic SimpleTypeDefinition
class CurveInterpolationType (pyxb.binding.datatypes.string, pyxb.binding.basis.enumeration_mixin):

    """gml:CurveInterpolationType is a list of codes that may be used to identify the interpolation mechanisms specified by an application schema."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'CurveInterpolationType')
    _Documentation = u'gml:CurveInterpolationType is a list of codes that may be used to identify the interpolation mechanisms specified by an application schema.'
CurveInterpolationType._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=CurveInterpolationType, enum_prefix=None)
CurveInterpolationType.linear = CurveInterpolationType._CF_enumeration.addEnumeration(unicode_value=u'linear')
CurveInterpolationType.geodesic = CurveInterpolationType._CF_enumeration.addEnumeration(unicode_value=u'geodesic')
CurveInterpolationType.circularArc3Points = CurveInterpolationType._CF_enumeration.addEnumeration(unicode_value=u'circularArc3Points')
CurveInterpolationType.circularArc2PointWithBulge = CurveInterpolationType._CF_enumeration.addEnumeration(unicode_value=u'circularArc2PointWithBulge')
CurveInterpolationType.circularArcCenterPointWithRadius = CurveInterpolationType._CF_enumeration.addEnumeration(unicode_value=u'circularArcCenterPointWithRadius')
CurveInterpolationType.elliptical = CurveInterpolationType._CF_enumeration.addEnumeration(unicode_value=u'elliptical')
CurveInterpolationType.clothoid = CurveInterpolationType._CF_enumeration.addEnumeration(unicode_value=u'clothoid')
CurveInterpolationType.conic = CurveInterpolationType._CF_enumeration.addEnumeration(unicode_value=u'conic')
CurveInterpolationType.polynomialSpline = CurveInterpolationType._CF_enumeration.addEnumeration(unicode_value=u'polynomialSpline')
CurveInterpolationType.cubicSpline = CurveInterpolationType._CF_enumeration.addEnumeration(unicode_value=u'cubicSpline')
CurveInterpolationType.rationalSpline = CurveInterpolationType._CF_enumeration.addEnumeration(unicode_value=u'rationalSpline')
CurveInterpolationType._InitializeFacetMap(CurveInterpolationType._CF_enumeration)
_Namespace_gml.addCategoryObject('typeBinding', u'CurveInterpolationType', CurveInterpolationType)

# Union SimpleTypeDefinition
# superclasses pyxb.binding.datatypes.anySimpleType
class NilReasonEnumeration (pyxb.binding.basis.STD_union):

    """Simple type that is a union of STD_ANON_1, STD_ANON_2."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'NilReasonEnumeration')
    _Documentation = None

    _MemberTypes = ( STD_ANON_1, STD_ANON_2, )
NilReasonEnumeration._CF_pattern = pyxb.binding.facets.CF_pattern()
NilReasonEnumeration._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=NilReasonEnumeration)
NilReasonEnumeration.inapplicable = u'inapplicable'# originally STD_ANON_1.inapplicable
NilReasonEnumeration.missing = u'missing'         # originally STD_ANON_1.missing
NilReasonEnumeration.template = u'template'       # originally STD_ANON_1.template
NilReasonEnumeration.unknown = u'unknown'         # originally STD_ANON_1.unknown
NilReasonEnumeration.withheld = u'withheld'       # originally STD_ANON_1.withheld
NilReasonEnumeration._InitializeFacetMap(NilReasonEnumeration._CF_pattern,
   NilReasonEnumeration._CF_enumeration)
_Namespace_gml.addCategoryObject('typeBinding', u'NilReasonEnumeration', NilReasonEnumeration)

# Union SimpleTypeDefinition
# superclasses pyxb.binding.datatypes.anySimpleType
class integerOrNilReason (pyxb.binding.basis.STD_union):

    """Extension to the respective XML Schema built-in simple type to allow a choice of either a value of the built-in simple type or a reason for a nil value."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'integerOrNilReason')
    _Documentation = u'Extension to the respective XML Schema built-in simple type to allow a choice of either a value of the built-in simple type or a reason for a nil value.'

    _MemberTypes = ( STD_ANON_1, STD_ANON_2, pyxb.binding.datatypes.integer, pyxb.binding.datatypes.anyURI, )
integerOrNilReason._CF_pattern = pyxb.binding.facets.CF_pattern()
integerOrNilReason._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=integerOrNilReason)
integerOrNilReason.inapplicable = u'inapplicable' # originally STD_ANON_1.inapplicable
integerOrNilReason.missing = u'missing'           # originally STD_ANON_1.missing
integerOrNilReason.template = u'template'         # originally STD_ANON_1.template
integerOrNilReason.unknown = u'unknown'           # originally STD_ANON_1.unknown
integerOrNilReason.withheld = u'withheld'         # originally STD_ANON_1.withheld
integerOrNilReason._InitializeFacetMap(integerOrNilReason._CF_pattern,
   integerOrNilReason._CF_enumeration)
_Namespace_gml.addCategoryObject('typeBinding', u'integerOrNilReason', integerOrNilReason)

# List SimpleTypeDefinition
# superclasses pyxb.binding.datatypes.anySimpleType
class integerOrNilReasonList (pyxb.binding.basis.STD_list):

    """A type for a list of values of the respective simple type."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'integerOrNilReasonList')
    _Documentation = u'A type for a list of values of the respective simple type.'

    _ItemType = integerOrNilReason
integerOrNilReasonList._InitializeFacetMap()
_Namespace_gml.addCategoryObject('typeBinding', u'integerOrNilReasonList', integerOrNilReasonList)

# List SimpleTypeDefinition
# superclasses pyxb.binding.datatypes.anySimpleType
class integerList (pyxb.binding.basis.STD_list):

    """A type for a list of values of the respective simple type."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'integerList')
    _Documentation = u'A type for a list of values of the respective simple type.'

    _ItemType = pyxb.binding.datatypes.integer
integerList._InitializeFacetMap()
_Namespace_gml.addCategoryObject('typeBinding', u'integerList', integerList)

# List SimpleTypeDefinition
# superclasses doubleList
class STD_ANON_5 (pyxb.binding.basis.STD_list):

    """Simple type that is a list of pyxb.binding.datatypes.double."""

    _ExpandedName = None
    _Documentation = None

    _ItemType = pyxb.binding.datatypes.double
STD_ANON_5._InitializeFacetMap()

# Atomic SimpleTypeDefinition
class SuccessionType (pyxb.binding.datatypes.string, pyxb.binding.basis.enumeration_mixin):

    """An atomic simple type."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'SuccessionType')
    _Documentation = ''
SuccessionType._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=SuccessionType, enum_prefix=None)
SuccessionType.substitution = SuccessionType._CF_enumeration.addEnumeration(unicode_value=u'substitution')
SuccessionType.division = SuccessionType._CF_enumeration.addEnumeration(unicode_value=u'division')
SuccessionType.fusion = SuccessionType._CF_enumeration.addEnumeration(unicode_value=u'fusion')
SuccessionType.initiation = SuccessionType._CF_enumeration.addEnumeration(unicode_value=u'initiation')
SuccessionType._InitializeFacetMap(SuccessionType._CF_enumeration)
_Namespace_gml.addCategoryObject('typeBinding', u'SuccessionType', SuccessionType)

# Atomic SimpleTypeDefinition
class SequenceRuleEnumeration (pyxb.binding.datatypes.string, pyxb.binding.basis.enumeration_mixin):

    """An atomic simple type."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'SequenceRuleEnumeration')
    _Documentation = None
SequenceRuleEnumeration._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=SequenceRuleEnumeration, enum_prefix=None)
SequenceRuleEnumeration.Linear = SequenceRuleEnumeration._CF_enumeration.addEnumeration(unicode_value=u'Linear')
SequenceRuleEnumeration.Boustrophedonic = SequenceRuleEnumeration._CF_enumeration.addEnumeration(unicode_value=u'Boustrophedonic')
SequenceRuleEnumeration.Cantor_diagonal = SequenceRuleEnumeration._CF_enumeration.addEnumeration(unicode_value=u'Cantor-diagonal')
SequenceRuleEnumeration.Spiral = SequenceRuleEnumeration._CF_enumeration.addEnumeration(unicode_value=u'Spiral')
SequenceRuleEnumeration.Morton = SequenceRuleEnumeration._CF_enumeration.addEnumeration(unicode_value=u'Morton')
SequenceRuleEnumeration.Hilbert = SequenceRuleEnumeration._CF_enumeration.addEnumeration(unicode_value=u'Hilbert')
SequenceRuleEnumeration._InitializeFacetMap(SequenceRuleEnumeration._CF_enumeration)
_Namespace_gml.addCategoryObject('typeBinding', u'SequenceRuleEnumeration', SequenceRuleEnumeration)

# Atomic SimpleTypeDefinition
class AxisDirection (pyxb.binding.datatypes.string):

    """The value of a gml:AxisDirection indicates the incrementation order to be used on an axis of the grid."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AxisDirection')
    _Documentation = u'The value of a gml:AxisDirection indicates the incrementation order to be used on an axis of the grid.'
AxisDirection._CF_pattern = pyxb.binding.facets.CF_pattern()
AxisDirection._CF_pattern.addPattern(pattern=u'[\\+\\-][1-9][0-9]*')
AxisDirection._InitializeFacetMap(AxisDirection._CF_pattern)
_Namespace_gml.addCategoryObject('typeBinding', u'AxisDirection', AxisDirection)

# List SimpleTypeDefinition
# superclasses pyxb.binding.datatypes.anySimpleType
class AxisDirectionList (pyxb.binding.basis.STD_list):

    """The different values in a gml:AxisDirectionList indicate the incrementation order to be used on all axes of the grid. Each axis shall be mentioned once and only once."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AxisDirectionList')
    _Documentation = u'The different values in a gml:AxisDirectionList indicate the incrementation order to be used on all axes of the grid. Each axis shall be mentioned once and only once.'

    _ItemType = AxisDirection
AxisDirectionList._InitializeFacetMap()
_Namespace_gml.addCategoryObject('typeBinding', u'AxisDirectionList', AxisDirectionList)

# Atomic SimpleTypeDefinition
class IncrementOrder (pyxb.binding.datatypes.string, pyxb.binding.basis.enumeration_mixin):

    """An atomic simple type."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'IncrementOrder')
    _Documentation = ''
IncrementOrder._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=IncrementOrder, enum_prefix=None)
IncrementOrder.xy = IncrementOrder._CF_enumeration.addEnumeration(unicode_value=u'+x+y')
IncrementOrder.yx = IncrementOrder._CF_enumeration.addEnumeration(unicode_value=u'+y+x')
IncrementOrder.x_y = IncrementOrder._CF_enumeration.addEnumeration(unicode_value=u'+x-y')
IncrementOrder.x_y_ = IncrementOrder._CF_enumeration.addEnumeration(unicode_value=u'-x-y')
IncrementOrder._InitializeFacetMap(IncrementOrder._CF_enumeration)
_Namespace_gml.addCategoryObject('typeBinding', u'IncrementOrder', IncrementOrder)

# Atomic SimpleTypeDefinition
class MD_TopicCategoryCode_Type (pyxb.binding.datatypes.string, pyxb.binding.basis.enumeration_mixin):

    """High-level geospatial data thematic classification to assist in the grouping and search of available geospatial datasets"""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_TopicCategoryCode_Type')
    _Documentation = u'High-level geospatial data thematic classification to assist in the grouping and search of available geospatial datasets'
MD_TopicCategoryCode_Type._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=MD_TopicCategoryCode_Type, enum_prefix=None)
MD_TopicCategoryCode_Type.farming = MD_TopicCategoryCode_Type._CF_enumeration.addEnumeration(unicode_value=u'farming')
MD_TopicCategoryCode_Type.biota = MD_TopicCategoryCode_Type._CF_enumeration.addEnumeration(unicode_value=u'biota')
MD_TopicCategoryCode_Type.boundaries = MD_TopicCategoryCode_Type._CF_enumeration.addEnumeration(unicode_value=u'boundaries')
MD_TopicCategoryCode_Type.climatologyMeteorologyAtmosphere = MD_TopicCategoryCode_Type._CF_enumeration.addEnumeration(unicode_value=u'climatologyMeteorologyAtmosphere')
MD_TopicCategoryCode_Type.economy = MD_TopicCategoryCode_Type._CF_enumeration.addEnumeration(unicode_value=u'economy')
MD_TopicCategoryCode_Type.elevation = MD_TopicCategoryCode_Type._CF_enumeration.addEnumeration(unicode_value=u'elevation')
MD_TopicCategoryCode_Type.environment = MD_TopicCategoryCode_Type._CF_enumeration.addEnumeration(unicode_value=u'environment')
MD_TopicCategoryCode_Type.geoscientificInformation = MD_TopicCategoryCode_Type._CF_enumeration.addEnumeration(unicode_value=u'geoscientificInformation')
MD_TopicCategoryCode_Type.health = MD_TopicCategoryCode_Type._CF_enumeration.addEnumeration(unicode_value=u'health')
MD_TopicCategoryCode_Type.imageryBaseMapsEarthCover = MD_TopicCategoryCode_Type._CF_enumeration.addEnumeration(unicode_value=u'imageryBaseMapsEarthCover')
MD_TopicCategoryCode_Type.intelligenceMilitary = MD_TopicCategoryCode_Type._CF_enumeration.addEnumeration(unicode_value=u'intelligenceMilitary')
MD_TopicCategoryCode_Type.inlandWaters = MD_TopicCategoryCode_Type._CF_enumeration.addEnumeration(unicode_value=u'inlandWaters')
MD_TopicCategoryCode_Type.location = MD_TopicCategoryCode_Type._CF_enumeration.addEnumeration(unicode_value=u'location')
MD_TopicCategoryCode_Type.oceans = MD_TopicCategoryCode_Type._CF_enumeration.addEnumeration(unicode_value=u'oceans')
MD_TopicCategoryCode_Type.planningCadastre = MD_TopicCategoryCode_Type._CF_enumeration.addEnumeration(unicode_value=u'planningCadastre')
MD_TopicCategoryCode_Type.society = MD_TopicCategoryCode_Type._CF_enumeration.addEnumeration(unicode_value=u'society')
MD_TopicCategoryCode_Type.structure = MD_TopicCategoryCode_Type._CF_enumeration.addEnumeration(unicode_value=u'structure')
MD_TopicCategoryCode_Type.transportation = MD_TopicCategoryCode_Type._CF_enumeration.addEnumeration(unicode_value=u'transportation')
MD_TopicCategoryCode_Type.utilitiesCommunication = MD_TopicCategoryCode_Type._CF_enumeration.addEnumeration(unicode_value=u'utilitiesCommunication')
MD_TopicCategoryCode_Type._InitializeFacetMap(MD_TopicCategoryCode_Type._CF_enumeration)
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_TopicCategoryCode_Type', MD_TopicCategoryCode_Type)

# Atomic SimpleTypeDefinition
class ArcSecondsType (pyxb.binding.datatypes.decimal):

    """An atomic simple type."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'ArcSecondsType')
    _Documentation = ''
ArcSecondsType._CF_minInclusive = pyxb.binding.facets.CF_minInclusive(value_datatype=ArcSecondsType, value=pyxb.binding.datatypes.decimal(0.0))
ArcSecondsType._CF_maxExclusive = pyxb.binding.facets.CF_maxExclusive(value_datatype=pyxb.binding.datatypes.decimal, value=pyxb.binding.datatypes.anySimpleType(u'60.00'))
ArcSecondsType._InitializeFacetMap(ArcSecondsType._CF_minInclusive,
   ArcSecondsType._CF_maxExclusive)
_Namespace_gml.addCategoryObject('typeBinding', u'ArcSecondsType', ArcSecondsType)

# Atomic SimpleTypeDefinition
class MD_ObligationCode_Type (pyxb.binding.datatypes.string, pyxb.binding.basis.enumeration_mixin):

    """An atomic simple type."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_ObligationCode_Type')
    _Documentation = None
MD_ObligationCode_Type._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=MD_ObligationCode_Type, enum_prefix=None)
MD_ObligationCode_Type.mandatory = MD_ObligationCode_Type._CF_enumeration.addEnumeration(unicode_value=u'mandatory')
MD_ObligationCode_Type.optional = MD_ObligationCode_Type._CF_enumeration.addEnumeration(unicode_value=u'optional')
MD_ObligationCode_Type.conditional = MD_ObligationCode_Type._CF_enumeration.addEnumeration(unicode_value=u'conditional')
MD_ObligationCode_Type._InitializeFacetMap(MD_ObligationCode_Type._CF_enumeration)
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_ObligationCode_Type', MD_ObligationCode_Type)

# List SimpleTypeDefinition
# superclasses NameOrNilReasonList
class STD_ANON_6 (pyxb.binding.basis.STD_list):

    """Simple type that is a list of NameOrNilReason."""

    _ExpandedName = None
    _Documentation = None

    _ItemType = NameOrNilReason
STD_ANON_6._CF_length = pyxb.binding.facets.CF_length(value=pyxb.binding.datatypes.nonNegativeInteger(2L))
STD_ANON_6._InitializeFacetMap(STD_ANON_6._CF_length)

# Union SimpleTypeDefinition
# superclasses pyxb.binding.datatypes.anySimpleType
class stringOrNilReason (pyxb.binding.basis.STD_union):

    """Extension to the respective XML Schema built-in simple type to allow a choice of either a value of the built-in simple type or a reason for a nil value."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'stringOrNilReason')
    _Documentation = u'Extension to the respective XML Schema built-in simple type to allow a choice of either a value of the built-in simple type or a reason for a nil value.'

    _MemberTypes = ( STD_ANON_1, STD_ANON_2, pyxb.binding.datatypes.string, pyxb.binding.datatypes.anyURI, )
stringOrNilReason._CF_pattern = pyxb.binding.facets.CF_pattern()
stringOrNilReason._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=stringOrNilReason)
stringOrNilReason.inapplicable = u'inapplicable'  # originally STD_ANON_1.inapplicable
stringOrNilReason.missing = u'missing'            # originally STD_ANON_1.missing
stringOrNilReason.template = u'template'          # originally STD_ANON_1.template
stringOrNilReason.unknown = u'unknown'            # originally STD_ANON_1.unknown
stringOrNilReason.withheld = u'withheld'          # originally STD_ANON_1.withheld
stringOrNilReason._InitializeFacetMap(stringOrNilReason._CF_pattern,
   stringOrNilReason._CF_enumeration)
_Namespace_gml.addCategoryObject('typeBinding', u'stringOrNilReason', stringOrNilReason)

# Atomic SimpleTypeDefinition
class KnotTypesType (pyxb.binding.datatypes.string, pyxb.binding.basis.enumeration_mixin):

    """This enumeration type specifies values for the knots' type (see ISO 19107:2003, 6.4.25)."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'KnotTypesType')
    _Documentation = u"This enumeration type specifies values for the knots' type (see ISO 19107:2003, 6.4.25)."
KnotTypesType._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=KnotTypesType, enum_prefix=None)
KnotTypesType.uniform = KnotTypesType._CF_enumeration.addEnumeration(unicode_value=u'uniform')
KnotTypesType.quasiUniform = KnotTypesType._CF_enumeration.addEnumeration(unicode_value=u'quasiUniform')
KnotTypesType.piecewiseBezier = KnotTypesType._CF_enumeration.addEnumeration(unicode_value=u'piecewiseBezier')
KnotTypesType._InitializeFacetMap(KnotTypesType._CF_enumeration)
_Namespace_gml.addCategoryObject('typeBinding', u'KnotTypesType', KnotTypesType)

# Atomic SimpleTypeDefinition
class STD_ANON_7 (pyxb.binding.datatypes.string, pyxb.binding.basis.enumeration_mixin):

    """An atomic simple type."""

    _ExpandedName = None
    _Documentation = None
STD_ANON_7._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=STD_ANON_7, enum_prefix=None)
STD_ANON_7.Before = STD_ANON_7._CF_enumeration.addEnumeration(unicode_value=u'Before')
STD_ANON_7.After = STD_ANON_7._CF_enumeration.addEnumeration(unicode_value=u'After')
STD_ANON_7.Begins = STD_ANON_7._CF_enumeration.addEnumeration(unicode_value=u'Begins')
STD_ANON_7.Ends = STD_ANON_7._CF_enumeration.addEnumeration(unicode_value=u'Ends')
STD_ANON_7.During = STD_ANON_7._CF_enumeration.addEnumeration(unicode_value=u'During')
STD_ANON_7.Equals = STD_ANON_7._CF_enumeration.addEnumeration(unicode_value=u'Equals')
STD_ANON_7.Contains = STD_ANON_7._CF_enumeration.addEnumeration(unicode_value=u'Contains')
STD_ANON_7.Overlaps = STD_ANON_7._CF_enumeration.addEnumeration(unicode_value=u'Overlaps')
STD_ANON_7.Meets = STD_ANON_7._CF_enumeration.addEnumeration(unicode_value=u'Meets')
STD_ANON_7.OverlappedBy = STD_ANON_7._CF_enumeration.addEnumeration(unicode_value=u'OverlappedBy')
STD_ANON_7.MetBy = STD_ANON_7._CF_enumeration.addEnumeration(unicode_value=u'MetBy')
STD_ANON_7.BegunBy = STD_ANON_7._CF_enumeration.addEnumeration(unicode_value=u'BegunBy')
STD_ANON_7.EndedBy = STD_ANON_7._CF_enumeration.addEnumeration(unicode_value=u'EndedBy')
STD_ANON_7._InitializeFacetMap(STD_ANON_7._CF_enumeration)

# List SimpleTypeDefinition
# superclasses integerOrNilReasonList
class CountExtentType (pyxb.binding.basis.STD_list):

    """Simple type that is a list of integerOrNilReason."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'CountExtentType')
    _Documentation = None

    _ItemType = integerOrNilReason
CountExtentType._CF_length = pyxb.binding.facets.CF_length(value=pyxb.binding.datatypes.nonNegativeInteger(2L))
CountExtentType._InitializeFacetMap(CountExtentType._CF_length)
_Namespace_gml.addCategoryObject('typeBinding', u'CountExtentType', CountExtentType)

# Union SimpleTypeDefinition
# superclasses pyxb.binding.datatypes.anySimpleType
class TimePositionUnion (pyxb.binding.basis.STD_union):

    """The simple type gml:TimePositionUnion is a union of XML Schema simple types which instantiate the subtypes for temporal position described in ISO 19108.
 An ordinal era may be referenced via URI.  A decimal value may be used to indicate the distance from the scale origin .  time is used for a position that recurs daily (see ISO 19108:2002 5.4.4.2).
 Finally, calendar and clock forms that support the representation of time in systems based on years, months, days, hours, minutes and seconds, in a notation following ISO 8601, are assembled by gml:CalDate"""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'TimePositionUnion')
    _Documentation = u'The simple type gml:TimePositionUnion is a union of XML Schema simple types which instantiate the subtypes for temporal position described in ISO 19108.\n An ordinal era may be referenced via URI.  A decimal value may be used to indicate the distance from the scale origin .  time is used for a position that recurs daily (see ISO 19108:2002 5.4.4.2).\n Finally, calendar and clock forms that support the representation of time in systems based on years, months, days, hours, minutes and seconds, in a notation following ISO 8601, are assembled by gml:CalDate'

    _MemberTypes = ( pyxb.binding.datatypes.date, pyxb.binding.datatypes.gYearMonth, pyxb.binding.datatypes.gYear, pyxb.binding.datatypes.time, pyxb.binding.datatypes.dateTime, pyxb.binding.datatypes.anyURI, pyxb.binding.datatypes.decimal, )
TimePositionUnion._CF_pattern = pyxb.binding.facets.CF_pattern()
TimePositionUnion._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=TimePositionUnion)
TimePositionUnion._InitializeFacetMap(TimePositionUnion._CF_pattern,
   TimePositionUnion._CF_enumeration)
_Namespace_gml.addCategoryObject('typeBinding', u'TimePositionUnion', TimePositionUnion)

# Atomic SimpleTypeDefinition
class TimeIndeterminateValueType (pyxb.binding.datatypes.string, pyxb.binding.basis.enumeration_mixin):

    """These values are interpreted as follows: 
-	"unknown" indicates that no specific value for temporal position is provided.
-	"now" indicates that the specified value shall be replaced with the current temporal position whenever the value is accessed.
-	"before" indicates that the actual temporal position is unknown, but it is known to be before the specified value.
-	"after" indicates that the actual temporal position is unknown, but it is known to be after the specified value.
A value for indeterminatePosition may 
-	be used either alone, or 
-	qualify a specific value for temporal position."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'TimeIndeterminateValueType')
    _Documentation = u'These values are interpreted as follows: \n-\t"unknown" indicates that no specific value for temporal position is provided.\n-\t"now" indicates that the specified value shall be replaced with the current temporal position whenever the value is accessed.\n-\t"before" indicates that the actual temporal position is unknown, but it is known to be before the specified value.\n-\t"after" indicates that the actual temporal position is unknown, but it is known to be after the specified value.\nA value for indeterminatePosition may \n-\tbe used either alone, or \n-\tqualify a specific value for temporal position.'
TimeIndeterminateValueType._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=TimeIndeterminateValueType, enum_prefix=None)
TimeIndeterminateValueType.after = TimeIndeterminateValueType._CF_enumeration.addEnumeration(unicode_value=u'after')
TimeIndeterminateValueType.before = TimeIndeterminateValueType._CF_enumeration.addEnumeration(unicode_value=u'before')
TimeIndeterminateValueType.now = TimeIndeterminateValueType._CF_enumeration.addEnumeration(unicode_value=u'now')
TimeIndeterminateValueType.unknown = TimeIndeterminateValueType._CF_enumeration.addEnumeration(unicode_value=u'unknown')
TimeIndeterminateValueType._InitializeFacetMap(TimeIndeterminateValueType._CF_enumeration)
_Namespace_gml.addCategoryObject('typeBinding', u'TimeIndeterminateValueType', TimeIndeterminateValueType)

# Union SimpleTypeDefinition
# superclasses pyxb.binding.datatypes.anySimpleType
class CalDate (pyxb.binding.basis.STD_union):

    """Simple type that is a union of pyxb.binding.datatypes.date, pyxb.binding.datatypes.gYearMonth, pyxb.binding.datatypes.gYear."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'CalDate')
    _Documentation = None

    _MemberTypes = ( pyxb.binding.datatypes.date, pyxb.binding.datatypes.gYearMonth, pyxb.binding.datatypes.gYear, )
CalDate._CF_pattern = pyxb.binding.facets.CF_pattern()
CalDate._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=CalDate)
CalDate._InitializeFacetMap(CalDate._CF_pattern,
   CalDate._CF_enumeration)
_Namespace_gml.addCategoryObject('typeBinding', u'CalDate', CalDate)

# Atomic SimpleTypeDefinition
class STD_ANON_8 (pyxb.binding.datatypes.string):

    """An atomic simple type."""

    _ExpandedName = None
    _Documentation = None
STD_ANON_8._InitializeFacetMap()

# Union SimpleTypeDefinition
# superclasses pyxb.binding.datatypes.anySimpleType
class Date_Type (pyxb.binding.basis.STD_union):

    """Simple type that is a union of pyxb.binding.datatypes.date, pyxb.binding.datatypes.gYearMonth, pyxb.binding.datatypes.gYear."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gco, u'Date_Type')
    _Documentation = None

    _MemberTypes = ( pyxb.binding.datatypes.date, pyxb.binding.datatypes.gYearMonth, pyxb.binding.datatypes.gYear, )
Date_Type._CF_pattern = pyxb.binding.facets.CF_pattern()
Date_Type._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=Date_Type)
Date_Type._InitializeFacetMap(Date_Type._CF_pattern,
   Date_Type._CF_enumeration)
_Namespace_gco.addCategoryObject('typeBinding', u'Date_Type', Date_Type)

# Atomic SimpleTypeDefinition
class CompassPointEnumeration (pyxb.binding.datatypes.string, pyxb.binding.basis.enumeration_mixin):

    """These directions are necessarily approximate, giving direction with a precision of 22.5&#176;. It is thus generally unnecessary to specify the reference frame, though this may be detailed in the definition of a GML application language."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'CompassPointEnumeration')
    _Documentation = u'These directions are necessarily approximate, giving direction with a precision of 22.5\xb0. It is thus generally unnecessary to specify the reference frame, though this may be detailed in the definition of a GML application language.'
CompassPointEnumeration._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=CompassPointEnumeration, enum_prefix=None)
CompassPointEnumeration.N = CompassPointEnumeration._CF_enumeration.addEnumeration(unicode_value=u'N')
CompassPointEnumeration.NNE = CompassPointEnumeration._CF_enumeration.addEnumeration(unicode_value=u'NNE')
CompassPointEnumeration.NE = CompassPointEnumeration._CF_enumeration.addEnumeration(unicode_value=u'NE')
CompassPointEnumeration.ENE = CompassPointEnumeration._CF_enumeration.addEnumeration(unicode_value=u'ENE')
CompassPointEnumeration.E = CompassPointEnumeration._CF_enumeration.addEnumeration(unicode_value=u'E')
CompassPointEnumeration.ESE = CompassPointEnumeration._CF_enumeration.addEnumeration(unicode_value=u'ESE')
CompassPointEnumeration.SE = CompassPointEnumeration._CF_enumeration.addEnumeration(unicode_value=u'SE')
CompassPointEnumeration.SSE = CompassPointEnumeration._CF_enumeration.addEnumeration(unicode_value=u'SSE')
CompassPointEnumeration.S = CompassPointEnumeration._CF_enumeration.addEnumeration(unicode_value=u'S')
CompassPointEnumeration.SSW = CompassPointEnumeration._CF_enumeration.addEnumeration(unicode_value=u'SSW')
CompassPointEnumeration.SW = CompassPointEnumeration._CF_enumeration.addEnumeration(unicode_value=u'SW')
CompassPointEnumeration.WSW = CompassPointEnumeration._CF_enumeration.addEnumeration(unicode_value=u'WSW')
CompassPointEnumeration.W = CompassPointEnumeration._CF_enumeration.addEnumeration(unicode_value=u'W')
CompassPointEnumeration.WNW = CompassPointEnumeration._CF_enumeration.addEnumeration(unicode_value=u'WNW')
CompassPointEnumeration.NW = CompassPointEnumeration._CF_enumeration.addEnumeration(unicode_value=u'NW')
CompassPointEnumeration.NNW = CompassPointEnumeration._CF_enumeration.addEnumeration(unicode_value=u'NNW')
CompassPointEnumeration._InitializeFacetMap(CompassPointEnumeration._CF_enumeration)
_Namespace_gml.addCategoryObject('typeBinding', u'CompassPointEnumeration', CompassPointEnumeration)

# Atomic SimpleTypeDefinition
class STD_ANON_9 (pyxb.binding.datatypes.string, pyxb.binding.basis.enumeration_mixin):

    """An atomic simple type."""

    _ExpandedName = None
    _Documentation = None
STD_ANON_9._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=STD_ANON_9, enum_prefix=None)
STD_ANON_9.year = STD_ANON_9._CF_enumeration.addEnumeration(unicode_value=u'year')
STD_ANON_9.month = STD_ANON_9._CF_enumeration.addEnumeration(unicode_value=u'month')
STD_ANON_9.day = STD_ANON_9._CF_enumeration.addEnumeration(unicode_value=u'day')
STD_ANON_9.hour = STD_ANON_9._CF_enumeration.addEnumeration(unicode_value=u'hour')
STD_ANON_9.minute = STD_ANON_9._CF_enumeration.addEnumeration(unicode_value=u'minute')
STD_ANON_9.second = STD_ANON_9._CF_enumeration.addEnumeration(unicode_value=u'second')
STD_ANON_9._InitializeFacetMap(STD_ANON_9._CF_enumeration)

# Atomic SimpleTypeDefinition
class STD_ANON_10 (pyxb.binding.datatypes.string):

    """An atomic simple type."""

    _ExpandedName = None
    _Documentation = None
STD_ANON_10._CF_pattern = pyxb.binding.facets.CF_pattern()
STD_ANON_10._CF_pattern.addPattern(pattern=u'other:\\w{2,}')
STD_ANON_10._InitializeFacetMap(STD_ANON_10._CF_pattern)

# Union SimpleTypeDefinition
# superclasses pyxb.binding.datatypes.anySimpleType
class TimeUnitType (pyxb.binding.basis.STD_union):

    """Simple type that is a union of STD_ANON_9, STD_ANON_10."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'TimeUnitType')
    _Documentation = None

    _MemberTypes = ( STD_ANON_9, STD_ANON_10, )
TimeUnitType._CF_pattern = pyxb.binding.facets.CF_pattern()
TimeUnitType._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=TimeUnitType)
TimeUnitType.year = u'year'                       # originally STD_ANON_9.year
TimeUnitType.month = u'month'                     # originally STD_ANON_9.month
TimeUnitType.day = u'day'                         # originally STD_ANON_9.day
TimeUnitType.hour = u'hour'                       # originally STD_ANON_9.hour
TimeUnitType.minute = u'minute'                   # originally STD_ANON_9.minute
TimeUnitType.second = u'second'                   # originally STD_ANON_9.second
TimeUnitType._InitializeFacetMap(TimeUnitType._CF_pattern,
   TimeUnitType._CF_enumeration)
_Namespace_gml.addCategoryObject('typeBinding', u'TimeUnitType', TimeUnitType)

# Union SimpleTypeDefinition
# superclasses pyxb.binding.datatypes.anySimpleType
class booleanOrNilReason (pyxb.binding.basis.STD_union):

    """Extension to the respective XML Schema built-in simple type to allow a choice of either a value of the built-in simple type or a reason for a nil value."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'booleanOrNilReason')
    _Documentation = u'Extension to the respective XML Schema built-in simple type to allow a choice of either a value of the built-in simple type or a reason for a nil value.'

    _MemberTypes = ( STD_ANON_1, STD_ANON_2, pyxb.binding.datatypes.boolean, pyxb.binding.datatypes.anyURI, )
booleanOrNilReason._CF_pattern = pyxb.binding.facets.CF_pattern()
booleanOrNilReason._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=booleanOrNilReason)
booleanOrNilReason.inapplicable = u'inapplicable' # originally STD_ANON_1.inapplicable
booleanOrNilReason.missing = u'missing'           # originally STD_ANON_1.missing
booleanOrNilReason.template = u'template'         # originally STD_ANON_1.template
booleanOrNilReason.unknown = u'unknown'           # originally STD_ANON_1.unknown
booleanOrNilReason.withheld = u'withheld'         # originally STD_ANON_1.withheld
booleanOrNilReason._InitializeFacetMap(booleanOrNilReason._CF_pattern,
   booleanOrNilReason._CF_enumeration)
_Namespace_gml.addCategoryObject('typeBinding', u'booleanOrNilReason', booleanOrNilReason)

# List SimpleTypeDefinition
# superclasses pyxb.binding.datatypes.anySimpleType
class booleanOrNilReasonList (pyxb.binding.basis.STD_list):

    """A type for a list of values of the respective simple type."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'booleanOrNilReasonList')
    _Documentation = u'A type for a list of values of the respective simple type.'

    _ItemType = booleanOrNilReason
booleanOrNilReasonList._InitializeFacetMap()
_Namespace_gml.addCategoryObject('typeBinding', u'booleanOrNilReasonList', booleanOrNilReasonList)

# List SimpleTypeDefinition
# superclasses pyxb.binding.datatypes.anySimpleType
class QNameList (pyxb.binding.basis.STD_list):

    """A type for a list of values of the respective simple type."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'QNameList')
    _Documentation = u'A type for a list of values of the respective simple type.'

    _ItemType = pyxb.binding.datatypes.QName
QNameList._InitializeFacetMap()
_Namespace_gml.addCategoryObject('typeBinding', u'QNameList', QNameList)

# Complex type CharacterString_PropertyType with content type ELEMENT_ONLY
class CharacterString_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gco, u'CharacterString_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gco}CharacterString uses Python identifier CharacterString
    __CharacterString = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'CharacterString'), 'CharacterString', '__httpwww_isotc211_org2005gco_CharacterString_PropertyType_httpwww_isotc211_org2005gcoCharacterString', False)

    
    CharacterString = property(__CharacterString.value, __CharacterString.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gco_CharacterString_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        __CharacterString.name() : __CharacterString
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason
    }
_Namespace_gco.addCategoryObject('typeBinding', u'CharacterString_PropertyType', CharacterString_PropertyType)


# Complex type Real_PropertyType with content type ELEMENT_ONLY
class Real_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gco, u'Real_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gco}Real uses Python identifier Real
    __Real = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'Real'), 'Real', '__httpwww_isotc211_org2005gco_Real_PropertyType_httpwww_isotc211_org2005gcoReal', False)

    
    Real = property(__Real.value, __Real.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gco_Real_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        __Real.name() : __Real
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason
    }
_Namespace_gco.addCategoryObject('typeBinding', u'Real_PropertyType', Real_PropertyType)


# Complex type AbstractObject_Type with content type EMPTY
class AbstractObject_Type (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_EMPTY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gco, u'AbstractObject_Type')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Attribute id uses Python identifier id
    __id = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'id'), 'id', '__httpwww_isotc211_org2005gco_AbstractObject_Type_id', pyxb.binding.datatypes.ID)
    
    id = property(__id.value, __id.set, None, None)

    
    # Attribute uuid uses Python identifier uuid
    __uuid = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuid'), 'uuid', '__httpwww_isotc211_org2005gco_AbstractObject_Type_uuid', pyxb.binding.datatypes.string)
    
    uuid = property(__uuid.value, __uuid.set, None, None)


    _ElementMap = {
        
    }
    _AttributeMap = {
        __id.name() : __id,
        __uuid.name() : __uuid
    }
_Namespace_gco.addCategoryObject('typeBinding', u'AbstractObject_Type', AbstractObject_Type)


# Complex type AbstractMD_Identification_Type with content type ELEMENT_ONLY
class AbstractMD_Identification_Type (AbstractObject_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'AbstractMD_Identification_Type')
    # Base type is AbstractObject_Type
    
    # Element {http://www.isotc211.org/2005/gmd}resourceMaintenance uses Python identifier resourceMaintenance
    __resourceMaintenance = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'resourceMaintenance'), 'resourceMaintenance', '__httpwww_isotc211_org2005gmd_AbstractMD_Identification_Type_httpwww_isotc211_org2005gmdresourceMaintenance', True)

    
    resourceMaintenance = property(__resourceMaintenance.value, __resourceMaintenance.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}pointOfContact uses Python identifier pointOfContact
    __pointOfContact = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'pointOfContact'), 'pointOfContact', '__httpwww_isotc211_org2005gmd_AbstractMD_Identification_Type_httpwww_isotc211_org2005gmdpointOfContact', True)

    
    pointOfContact = property(__pointOfContact.value, __pointOfContact.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}purpose uses Python identifier purpose
    __purpose = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'purpose'), 'purpose', '__httpwww_isotc211_org2005gmd_AbstractMD_Identification_Type_httpwww_isotc211_org2005gmdpurpose', False)

    
    purpose = property(__purpose.value, __purpose.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}resourceFormat uses Python identifier resourceFormat
    __resourceFormat = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'resourceFormat'), 'resourceFormat', '__httpwww_isotc211_org2005gmd_AbstractMD_Identification_Type_httpwww_isotc211_org2005gmdresourceFormat', True)

    
    resourceFormat = property(__resourceFormat.value, __resourceFormat.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}graphicOverview uses Python identifier graphicOverview
    __graphicOverview = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'graphicOverview'), 'graphicOverview', '__httpwww_isotc211_org2005gmd_AbstractMD_Identification_Type_httpwww_isotc211_org2005gmdgraphicOverview', True)

    
    graphicOverview = property(__graphicOverview.value, __graphicOverview.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}citation uses Python identifier citation
    __citation = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'citation'), 'citation', '__httpwww_isotc211_org2005gmd_AbstractMD_Identification_Type_httpwww_isotc211_org2005gmdcitation', False)

    
    citation = property(__citation.value, __citation.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}resourceConstraints uses Python identifier resourceConstraints
    __resourceConstraints = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'resourceConstraints'), 'resourceConstraints', '__httpwww_isotc211_org2005gmd_AbstractMD_Identification_Type_httpwww_isotc211_org2005gmdresourceConstraints', True)

    
    resourceConstraints = property(__resourceConstraints.value, __resourceConstraints.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}abstract uses Python identifier abstract
    __abstract = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'abstract'), 'abstract', '__httpwww_isotc211_org2005gmd_AbstractMD_Identification_Type_httpwww_isotc211_org2005gmdabstract', False)

    
    abstract = property(__abstract.value, __abstract.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}resourceSpecificUsage uses Python identifier resourceSpecificUsage
    __resourceSpecificUsage = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'resourceSpecificUsage'), 'resourceSpecificUsage', '__httpwww_isotc211_org2005gmd_AbstractMD_Identification_Type_httpwww_isotc211_org2005gmdresourceSpecificUsage', True)

    
    resourceSpecificUsage = property(__resourceSpecificUsage.value, __resourceSpecificUsage.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}aggregationInfo uses Python identifier aggregationInfo
    __aggregationInfo = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'aggregationInfo'), 'aggregationInfo', '__httpwww_isotc211_org2005gmd_AbstractMD_Identification_Type_httpwww_isotc211_org2005gmdaggregationInfo', True)

    
    aggregationInfo = property(__aggregationInfo.value, __aggregationInfo.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}credit uses Python identifier credit
    __credit = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'credit'), 'credit', '__httpwww_isotc211_org2005gmd_AbstractMD_Identification_Type_httpwww_isotc211_org2005gmdcredit', True)

    
    credit = property(__credit.value, __credit.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}descriptiveKeywords uses Python identifier descriptiveKeywords
    __descriptiveKeywords = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'descriptiveKeywords'), 'descriptiveKeywords', '__httpwww_isotc211_org2005gmd_AbstractMD_Identification_Type_httpwww_isotc211_org2005gmddescriptiveKeywords', True)

    
    descriptiveKeywords = property(__descriptiveKeywords.value, __descriptiveKeywords.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}status uses Python identifier status
    __status = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'status'), 'status', '__httpwww_isotc211_org2005gmd_AbstractMD_Identification_Type_httpwww_isotc211_org2005gmdstatus', True)

    
    status = property(__status.value, __status.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractObject_Type._ElementMap.copy()
    _ElementMap.update({
        __resourceMaintenance.name() : __resourceMaintenance,
        __pointOfContact.name() : __pointOfContact,
        __purpose.name() : __purpose,
        __resourceFormat.name() : __resourceFormat,
        __graphicOverview.name() : __graphicOverview,
        __citation.name() : __citation,
        __resourceConstraints.name() : __resourceConstraints,
        __abstract.name() : __abstract,
        __resourceSpecificUsage.name() : __resourceSpecificUsage,
        __aggregationInfo.name() : __aggregationInfo,
        __credit.name() : __credit,
        __descriptiveKeywords.name() : __descriptiveKeywords,
        __status.name() : __status
    })
    _AttributeMap = AbstractObject_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'AbstractMD_Identification_Type', AbstractMD_Identification_Type)


# Complex type MD_DataIdentification_Type with content type ELEMENT_ONLY
class MD_DataIdentification_Type (AbstractMD_Identification_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_DataIdentification_Type')
    # Base type is AbstractMD_Identification_Type
    
    # Element pointOfContact ({http://www.isotc211.org/2005/gmd}pointOfContact) inherited from {http://www.isotc211.org/2005/gmd}AbstractMD_Identification_Type
    
    # Element purpose ({http://www.isotc211.org/2005/gmd}purpose) inherited from {http://www.isotc211.org/2005/gmd}AbstractMD_Identification_Type
    
    # Element {http://www.isotc211.org/2005/gmd}characterSet uses Python identifier characterSet
    __characterSet = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'characterSet'), 'characterSet', '__httpwww_isotc211_org2005gmd_MD_DataIdentification_Type_httpwww_isotc211_org2005gmdcharacterSet', True)

    
    characterSet = property(__characterSet.value, __characterSet.set, None, None)

    
    # Element resourceMaintenance ({http://www.isotc211.org/2005/gmd}resourceMaintenance) inherited from {http://www.isotc211.org/2005/gmd}AbstractMD_Identification_Type
    
    # Element {http://www.isotc211.org/2005/gmd}topicCategory uses Python identifier topicCategory
    __topicCategory = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'topicCategory'), 'topicCategory', '__httpwww_isotc211_org2005gmd_MD_DataIdentification_Type_httpwww_isotc211_org2005gmdtopicCategory', True)

    
    topicCategory = property(__topicCategory.value, __topicCategory.set, None, None)

    
    # Element credit ({http://www.isotc211.org/2005/gmd}credit) inherited from {http://www.isotc211.org/2005/gmd}AbstractMD_Identification_Type
    
    # Element {http://www.isotc211.org/2005/gmd}extent uses Python identifier extent
    __extent = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'extent'), 'extent', '__httpwww_isotc211_org2005gmd_MD_DataIdentification_Type_httpwww_isotc211_org2005gmdextent', True)

    
    extent = property(__extent.value, __extent.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}environmentDescription uses Python identifier environmentDescription
    __environmentDescription = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'environmentDescription'), 'environmentDescription', '__httpwww_isotc211_org2005gmd_MD_DataIdentification_Type_httpwww_isotc211_org2005gmdenvironmentDescription', False)

    
    environmentDescription = property(__environmentDescription.value, __environmentDescription.set, None, None)

    
    # Element abstract ({http://www.isotc211.org/2005/gmd}abstract) inherited from {http://www.isotc211.org/2005/gmd}AbstractMD_Identification_Type
    
    # Element resourceFormat ({http://www.isotc211.org/2005/gmd}resourceFormat) inherited from {http://www.isotc211.org/2005/gmd}AbstractMD_Identification_Type
    
    # Element {http://www.isotc211.org/2005/gmd}language uses Python identifier language
    __language = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'language'), 'language', '__httpwww_isotc211_org2005gmd_MD_DataIdentification_Type_httpwww_isotc211_org2005gmdlanguage', True)

    
    language = property(__language.value, __language.set, None, None)

    
    # Element descriptiveKeywords ({http://www.isotc211.org/2005/gmd}descriptiveKeywords) inherited from {http://www.isotc211.org/2005/gmd}AbstractMD_Identification_Type
    
    # Element {http://www.isotc211.org/2005/gmd}supplementalInformation uses Python identifier supplementalInformation
    __supplementalInformation = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'supplementalInformation'), 'supplementalInformation', '__httpwww_isotc211_org2005gmd_MD_DataIdentification_Type_httpwww_isotc211_org2005gmdsupplementalInformation', False)

    
    supplementalInformation = property(__supplementalInformation.value, __supplementalInformation.set, None, None)

    
    # Element graphicOverview ({http://www.isotc211.org/2005/gmd}graphicOverview) inherited from {http://www.isotc211.org/2005/gmd}AbstractMD_Identification_Type
    
    # Element resourceSpecificUsage ({http://www.isotc211.org/2005/gmd}resourceSpecificUsage) inherited from {http://www.isotc211.org/2005/gmd}AbstractMD_Identification_Type
    
    # Element {http://www.isotc211.org/2005/gmd}spatialRepresentationType uses Python identifier spatialRepresentationType
    __spatialRepresentationType = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'spatialRepresentationType'), 'spatialRepresentationType', '__httpwww_isotc211_org2005gmd_MD_DataIdentification_Type_httpwww_isotc211_org2005gmdspatialRepresentationType', True)

    
    spatialRepresentationType = property(__spatialRepresentationType.value, __spatialRepresentationType.set, None, None)

    
    # Element aggregationInfo ({http://www.isotc211.org/2005/gmd}aggregationInfo) inherited from {http://www.isotc211.org/2005/gmd}AbstractMD_Identification_Type
    
    # Element resourceConstraints ({http://www.isotc211.org/2005/gmd}resourceConstraints) inherited from {http://www.isotc211.org/2005/gmd}AbstractMD_Identification_Type
    
    # Element {http://www.isotc211.org/2005/gmd}spatialResolution uses Python identifier spatialResolution
    __spatialResolution = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'spatialResolution'), 'spatialResolution', '__httpwww_isotc211_org2005gmd_MD_DataIdentification_Type_httpwww_isotc211_org2005gmdspatialResolution', True)

    
    spatialResolution = property(__spatialResolution.value, __spatialResolution.set, None, None)

    
    # Element citation ({http://www.isotc211.org/2005/gmd}citation) inherited from {http://www.isotc211.org/2005/gmd}AbstractMD_Identification_Type
    
    # Element status ({http://www.isotc211.org/2005/gmd}status) inherited from {http://www.isotc211.org/2005/gmd}AbstractMD_Identification_Type
    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractMD_Identification_Type._ElementMap.copy()
    _ElementMap.update({
        __characterSet.name() : __characterSet,
        __topicCategory.name() : __topicCategory,
        __extent.name() : __extent,
        __environmentDescription.name() : __environmentDescription,
        __language.name() : __language,
        __supplementalInformation.name() : __supplementalInformation,
        __spatialRepresentationType.name() : __spatialRepresentationType,
        __spatialResolution.name() : __spatialResolution
    })
    _AttributeMap = AbstractMD_Identification_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_DataIdentification_Type', MD_DataIdentification_Type)


# Complex type CI_Contact_Type with content type ELEMENT_ONLY
class CI_Contact_Type (AbstractObject_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'CI_Contact_Type')
    # Base type is AbstractObject_Type
    
    # Element {http://www.isotc211.org/2005/gmd}contactInstructions uses Python identifier contactInstructions
    __contactInstructions = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'contactInstructions'), 'contactInstructions', '__httpwww_isotc211_org2005gmd_CI_Contact_Type_httpwww_isotc211_org2005gmdcontactInstructions', False)

    
    contactInstructions = property(__contactInstructions.value, __contactInstructions.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}phone uses Python identifier phone
    __phone = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'phone'), 'phone', '__httpwww_isotc211_org2005gmd_CI_Contact_Type_httpwww_isotc211_org2005gmdphone', False)

    
    phone = property(__phone.value, __phone.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}onlineResource uses Python identifier onlineResource
    __onlineResource = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'onlineResource'), 'onlineResource', '__httpwww_isotc211_org2005gmd_CI_Contact_Type_httpwww_isotc211_org2005gmdonlineResource', False)

    
    onlineResource = property(__onlineResource.value, __onlineResource.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}hoursOfService uses Python identifier hoursOfService
    __hoursOfService = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'hoursOfService'), 'hoursOfService', '__httpwww_isotc211_org2005gmd_CI_Contact_Type_httpwww_isotc211_org2005gmdhoursOfService', False)

    
    hoursOfService = property(__hoursOfService.value, __hoursOfService.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}address uses Python identifier address
    __address = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'address'), 'address', '__httpwww_isotc211_org2005gmd_CI_Contact_Type_httpwww_isotc211_org2005gmdaddress', False)

    
    address = property(__address.value, __address.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractObject_Type._ElementMap.copy()
    _ElementMap.update({
        __contactInstructions.name() : __contactInstructions,
        __phone.name() : __phone,
        __onlineResource.name() : __onlineResource,
        __hoursOfService.name() : __hoursOfService,
        __address.name() : __address
    })
    _AttributeMap = AbstractObject_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'CI_Contact_Type', CI_Contact_Type)


# Complex type AbstractSurfacePatchType with content type EMPTY
class AbstractSurfacePatchType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_EMPTY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractSurfacePatchType')
    # Base type is pyxb.binding.datatypes.anyType

    _ElementMap = {
        
    }
    _AttributeMap = {
        
    }
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractSurfacePatchType', AbstractSurfacePatchType)


# Complex type TriangleType with content type ELEMENT_ONLY
class TriangleType (AbstractSurfacePatchType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'TriangleType')
    # Base type is AbstractSurfacePatchType
    
    # Element {http://www.opengis.net/gml/3.2}exterior uses Python identifier exterior
    __exterior = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'exterior'), 'exterior', '__httpwww_opengis_netgml3_2_TriangleType_httpwww_opengis_netgml3_2exterior', False)

    
    exterior = property(__exterior.value, __exterior.set, None, u'A boundary of a surface consists of a number of rings. In the normal 2D case, one of these rings is distinguished as being the exterior boundary. In a general manifold this is not always possible, in which case all boundaries shall be listed as interior boundaries, and the exterior will be empty.')

    
    # Attribute interpolation uses Python identifier interpolation
    __interpolation = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'interpolation'), 'interpolation', '__httpwww_opengis_netgml3_2_TriangleType_interpolation', SurfaceInterpolationType, fixed=True, unicode_default=u'planar')
    
    interpolation = property(__interpolation.value, __interpolation.set, None, None)


    _ElementMap = AbstractSurfacePatchType._ElementMap.copy()
    _ElementMap.update({
        __exterior.name() : __exterior
    })
    _AttributeMap = AbstractSurfacePatchType._AttributeMap.copy()
    _AttributeMap.update({
        __interpolation.name() : __interpolation
    })
_Namespace_gml.addCategoryObject('typeBinding', u'TriangleType', TriangleType)


# Complex type DirectionPropertyType with content type ELEMENT_ONLY
class DirectionPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'DirectionPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}DirectionVector uses Python identifier DirectionVector
    __DirectionVector = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'DirectionVector'), 'DirectionVector', '__httpwww_opengis_netgml3_2_DirectionPropertyType_httpwww_opengis_netgml3_2DirectionVector', False)

    
    DirectionVector = property(__DirectionVector.value, __DirectionVector.set, None, None)

    
    # Element {http://www.opengis.net/gml/3.2}DirectionDescription uses Python identifier DirectionDescription
    __DirectionDescription = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'DirectionDescription'), 'DirectionDescription', '__httpwww_opengis_netgml3_2_DirectionPropertyType_httpwww_opengis_netgml3_2DirectionDescription', False)

    
    DirectionDescription = property(__DirectionDescription.value, __DirectionDescription.set, None, None)

    
    # Element {http://www.opengis.net/gml/3.2}CompassPoint uses Python identifier CompassPoint
    __CompassPoint = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'CompassPoint'), 'CompassPoint', '__httpwww_opengis_netgml3_2_DirectionPropertyType_httpwww_opengis_netgml3_2CompassPoint', False)

    
    CompassPoint = property(__CompassPoint.value, __CompassPoint.set, None, None)

    
    # Element {http://www.opengis.net/gml/3.2}DirectionKeyword uses Python identifier DirectionKeyword
    __DirectionKeyword = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'DirectionKeyword'), 'DirectionKeyword', '__httpwww_opengis_netgml3_2_DirectionPropertyType_httpwww_opengis_netgml3_2DirectionKeyword', False)

    
    DirectionKeyword = property(__DirectionKeyword.value, __DirectionKeyword.set, None, None)

    
    # Element {http://www.opengis.net/gml/3.2}DirectionString uses Python identifier DirectionString
    __DirectionString = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'DirectionString'), 'DirectionString', '__httpwww_opengis_netgml3_2_DirectionPropertyType_httpwww_opengis_netgml3_2DirectionString', False)

    
    DirectionString = property(__DirectionString.value, __DirectionString.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_DirectionPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_DirectionPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_DirectionPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_DirectionPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_DirectionPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_DirectionPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_DirectionPropertyType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_DirectionPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_DirectionPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_DirectionPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')


    _ElementMap = {
        __DirectionVector.name() : __DirectionVector,
        __DirectionDescription.name() : __DirectionDescription,
        __CompassPoint.name() : __CompassPoint,
        __DirectionKeyword.name() : __DirectionKeyword,
        __DirectionString.name() : __DirectionString
    }
    _AttributeMap = {
        __role.name() : __role,
        __type.name() : __type,
        __arcrole.name() : __arcrole,
        __title.name() : __title,
        __nilReason.name() : __nilReason,
        __show.name() : __show,
        __owns.name() : __owns,
        __actuate.name() : __actuate,
        __href.name() : __href,
        __remoteSchema.name() : __remoteSchema
    }
_Namespace_gml.addCategoryObject('typeBinding', u'DirectionPropertyType', DirectionPropertyType)


# Complex type DegreesType with content type SIMPLE
class DegreesType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = DegreeValueType
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_SIMPLE
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'DegreesType')
    # Base type is DegreeValueType
    
    # Attribute direction uses Python identifier direction
    __direction = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'direction'), 'direction', '__httpwww_opengis_netgml3_2_DegreesType_direction', STD_ANON_3)
    
    direction = property(__direction.value, __direction.set, None, None)


    _ElementMap = {
        
    }
    _AttributeMap = {
        __direction.name() : __direction
    }
_Namespace_gml.addCategoryObject('typeBinding', u'DegreesType', DegreesType)


# Complex type ReferenceType with content type EMPTY
class ReferenceType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_EMPTY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'ReferenceType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_ReferenceType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_ReferenceType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_ReferenceType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_ReferenceType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_ReferenceType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_ReferenceType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_ReferenceType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_ReferenceType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_ReferenceType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_ReferenceType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)


    _ElementMap = {
        
    }
    _AttributeMap = {
        __remoteSchema.name() : __remoteSchema,
        __role.name() : __role,
        __show.name() : __show,
        __owns.name() : __owns,
        __arcrole.name() : __arcrole,
        __actuate.name() : __actuate,
        __nilReason.name() : __nilReason,
        __href.name() : __href,
        __type.name() : __type,
        __title.name() : __title
    }
_Namespace_gml.addCategoryObject('typeBinding', u'ReferenceType', ReferenceType)


# Complex type SolidArrayPropertyType with content type ELEMENT_ONLY
class SolidArrayPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'SolidArrayPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}AbstractSolid uses Python identifier AbstractSolid
    __AbstractSolid = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractSolid'), 'AbstractSolid', '__httpwww_opengis_netgml3_2_SolidArrayPropertyType_httpwww_opengis_netgml3_2AbstractSolid', True)

    
    AbstractSolid = property(__AbstractSolid.value, __AbstractSolid.set, None, u'The AbstractSolid element is the abstract head of the substituition group for all (continuous) solid elements.')

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_SolidArrayPropertyType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)


    _ElementMap = {
        __AbstractSolid.name() : __AbstractSolid
    }
    _AttributeMap = {
        __owns.name() : __owns
    }
_Namespace_gml.addCategoryObject('typeBinding', u'SolidArrayPropertyType', SolidArrayPropertyType)


# Complex type GeneralTransformationPropertyType with content type ELEMENT_ONLY
class GeneralTransformationPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'GeneralTransformationPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}AbstractGeneralTransformation uses Python identifier AbstractGeneralTransformation
    __AbstractGeneralTransformation = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractGeneralTransformation'), 'AbstractGeneralTransformation', '__httpwww_opengis_netgml3_2_GeneralTransformationPropertyType_httpwww_opengis_netgml3_2AbstractGeneralTransformation', False)

    
    AbstractGeneralTransformation = property(__AbstractGeneralTransformation.value, __AbstractGeneralTransformation.set, None, u'gml:AbstractGeneralTransformation is an abstract operation on coordinates that usually includes a change of Datum. The parameters of a coordinate transformation are empirically derived from data containing the coordinates of a series of points in both coordinate reference systems. This computational process is usually "over-determined", allowing derivation of error (or accuracy) estimates for the transformation. Also, the stochastic nature of the parameters may result in multiple (different) versions of the same coordinate transformation. The operationVersion, sourceCRS, and targetCRS proeprty elements are mandatory in a coordinate transformation.\nThis abstract complex type is expected to be extended for well-known operation methods with many Transformation instances, in Application Schemas that define operation-method-specialized value element names and contents. This transformation uses an operation method with associated parameter values. However, operation methods and parameter values are directly associated with concrete subtypes, not with this abstract type. All concrete types derived from this type shall extend this type to include a "usesMethod" element that references one "OperationMethod" element. Similarly, all concrete types derived from this type shall extend this type to include one or more elements each named "uses...Value" that each use the type of an element substitutable for the "AbstractGeneralParameterValue" element.')

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_GeneralTransformationPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_GeneralTransformationPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_GeneralTransformationPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_GeneralTransformationPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_GeneralTransformationPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_GeneralTransformationPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_GeneralTransformationPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_GeneralTransformationPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_GeneralTransformationPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")


    _ElementMap = {
        __AbstractGeneralTransformation.name() : __AbstractGeneralTransformation
    }
    _AttributeMap = {
        __remoteSchema.name() : __remoteSchema,
        __href.name() : __href,
        __arcrole.name() : __arcrole,
        __type.name() : __type,
        __title.name() : __title,
        __nilReason.name() : __nilReason,
        __role.name() : __role,
        __show.name() : __show,
        __actuate.name() : __actuate
    }
_Namespace_gml.addCategoryObject('typeBinding', u'GeneralTransformationPropertyType', GeneralTransformationPropertyType)


# Complex type DirectedNodePropertyType with content type ELEMENT_ONLY
class DirectedNodePropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'DirectedNodePropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}Node uses Python identifier Node
    __Node = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'Node'), 'Node', '__httpwww_opengis_netgml3_2_DirectedNodePropertyType_httpwww_opengis_netgml3_2Node', False)

    
    Node = property(__Node.value, __Node.set, None, u'gml:Node represents the 0-dimensional primitive.\nThe optional coboundary of a node (gml:directedEdge) is a sequence of directed edges which are incident on this node. Edges emanating from this node appear in the node coboundary with a negative orientation. \nIf provided, the aggregationType attribute shall have the value "sequence".\nA node may optionally be realised by a 0-dimensional geometric primitive (gml:pointProperty).')

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_DirectedNodePropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute orientation uses Python identifier orientation
    __orientation = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'orientation'), 'orientation', '__httpwww_opengis_netgml3_2_DirectedNodePropertyType_orientation', SignType, unicode_default=u'+')
    
    orientation = property(__orientation.value, __orientation.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_DirectedNodePropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_DirectedNodePropertyType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_DirectedNodePropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_DirectedNodePropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_DirectedNodePropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_DirectedNodePropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_DirectedNodePropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_DirectedNodePropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_DirectedNodePropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)


    _ElementMap = {
        __Node.name() : __Node
    }
    _AttributeMap = {
        __type.name() : __type,
        __orientation.name() : __orientation,
        __actuate.name() : __actuate,
        __owns.name() : __owns,
        __href.name() : __href,
        __nilReason.name() : __nilReason,
        __remoteSchema.name() : __remoteSchema,
        __title.name() : __title,
        __arcrole.name() : __arcrole,
        __show.name() : __show,
        __role.name() : __role
    }
_Namespace_gml.addCategoryObject('typeBinding', u'DirectedNodePropertyType', DirectedNodePropertyType)


# Complex type AbstractGMLType with content type ELEMENT_ONLY
class AbstractGMLType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractGMLType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}name uses Python identifier name
    __name = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'name'), 'name', '__httpwww_opengis_netgml3_2_AbstractGMLType_httpwww_opengis_netgml3_2name', True)

    
    name = property(__name.value, __name.set, None, u'The gml:name property provides a label or identifier for the object, commonly a descriptive name. An object may have several names, typically assigned by different authorities. gml:name uses the gml:CodeType content model.  The authority for a name is indicated by the value of its (optional) codeSpace attribute.  The name may or may not be unique, as determined by the rules of the organization responsible for the codeSpace.  In common usage there will be one name per authority, so a processing application may select the name from its preferred codeSpace.')

    
    # Element {http://www.opengis.net/gml/3.2}metaDataProperty uses Python identifier metaDataProperty
    __metaDataProperty = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'metaDataProperty'), 'metaDataProperty', '__httpwww_opengis_netgml3_2_AbstractGMLType_httpwww_opengis_netgml3_2metaDataProperty', True)

    
    metaDataProperty = property(__metaDataProperty.value, __metaDataProperty.set, None, u'')

    
    # Element {http://www.opengis.net/gml/3.2}descriptionReference uses Python identifier descriptionReference
    __descriptionReference = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'descriptionReference'), 'descriptionReference', '__httpwww_opengis_netgml3_2_AbstractGMLType_httpwww_opengis_netgml3_2descriptionReference', False)

    
    descriptionReference = property(__descriptionReference.value, __descriptionReference.set, None, u'The value of this property is a remote text description of the object. The xlink:href attribute of the gml:descriptionReference property references the external description.')

    
    # Element {http://www.opengis.net/gml/3.2}description uses Python identifier description
    __description = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'description'), 'description', '__httpwww_opengis_netgml3_2_AbstractGMLType_httpwww_opengis_netgml3_2description', False)

    
    description = property(__description.value, __description.set, None, u'The value of this property is a text description of the object. gml:description uses gml:StringOrRefType as its content model, so it may contain a simple text string content, or carry a reference to an external description. The use of gml:description to reference an external description has been deprecated and replaced by the gml:descriptionReference property.')

    
    # Element {http://www.opengis.net/gml/3.2}identifier uses Python identifier identifier
    __identifier = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'identifier'), 'identifier', '__httpwww_opengis_netgml3_2_AbstractGMLType_httpwww_opengis_netgml3_2identifier', False)

    
    identifier = property(__identifier.value, __identifier.set, None, u'Often, a special identifier is assigned to an object by the maintaining authority with the intention that it is used in references to the object For such cases, the codeSpace shall be provided. That identifier is usually unique either globally or within an application domain. gml:identifier is a pre-defined property for such identifiers.')

    
    # Attribute {http://www.opengis.net/gml/3.2}id uses Python identifier id
    __id = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'id'), 'id', '__httpwww_opengis_netgml3_2_AbstractGMLType_httpwww_opengis_netgml3_2id', pyxb.binding.datatypes.ID, required=True)
    
    id = property(__id.value, __id.set, None, u'The attribute gml:id supports provision of a handle for the XML element representing a GML Object. Its use is mandatory for all GML objects. It is of XML type ID, so is constrained to be unique in the XML document within which it occurs.')


    _ElementMap = {
        __name.name() : __name,
        __metaDataProperty.name() : __metaDataProperty,
        __descriptionReference.name() : __descriptionReference,
        __description.name() : __description,
        __identifier.name() : __identifier
    }
    _AttributeMap = {
        __id.name() : __id
    }
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractGMLType', AbstractGMLType)


# Complex type DefinitionBaseType with content type ELEMENT_ONLY
class DefinitionBaseType (AbstractGMLType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'DefinitionBaseType')
    # Base type is AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute id is restricted from parent
    
    # Attribute {http://www.opengis.net/gml/3.2}id uses Python identifier id
    __id = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'id'), 'id', '__httpwww_opengis_netgml3_2_AbstractGMLType_httpwww_opengis_netgml3_2id', pyxb.binding.datatypes.ID, required=True)
    
    id = property(__id.value, __id.set, None, u'The attribute gml:id supports provision of a handle for the XML element representing a GML Object. Its use is mandatory for all GML objects. It is of XML type ID, so is constrained to be unique in the XML document within which it occurs.')


    _ElementMap = AbstractGMLType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractGMLType._AttributeMap.copy()
    _AttributeMap.update({
        __id.name() : __id
    })
_Namespace_gml.addCategoryObject('typeBinding', u'DefinitionBaseType', DefinitionBaseType)


# Complex type DefinitionType with content type ELEMENT_ONLY
class DefinitionType (DefinitionBaseType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'DefinitionType')
    # Base type is DefinitionBaseType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}remarks uses Python identifier remarks
    __remarks = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remarks'), 'remarks', '__httpwww_opengis_netgml3_2_DefinitionType_httpwww_opengis_netgml3_2remarks', False)

    
    remarks = property(__remarks.value, __remarks.set, None, None)

    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType

    _ElementMap = DefinitionBaseType._ElementMap.copy()
    _ElementMap.update({
        __remarks.name() : __remarks
    })
    _AttributeMap = DefinitionBaseType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'DefinitionType', DefinitionType)


# Complex type IdentifiedObjectType with content type ELEMENT_ONLY
class IdentifiedObjectType (DefinitionType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'IdentifiedObjectType')
    # Base type is DefinitionType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType

    _ElementMap = DefinitionType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = DefinitionType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'IdentifiedObjectType', IdentifiedObjectType)


# Complex type AbstractCRSType with content type ELEMENT_ONLY
class AbstractCRSType (IdentifiedObjectType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractCRSType')
    # Base type is IdentifiedObjectType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}domainOfValidity uses Python identifier domainOfValidity
    __domainOfValidity = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'domainOfValidity'), 'domainOfValidity', '__httpwww_opengis_netgml3_2_AbstractCRSType_httpwww_opengis_netgml3_2domainOfValidity', True)

    
    domainOfValidity = property(__domainOfValidity.value, __domainOfValidity.set, None, u'The gml:domainOfValidity property implements an association role to an EX_Extent object as encoded in ISO/TS 19139, either referencing or containing the definition of that extent.')

    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}scope uses Python identifier scope
    __scope = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'scope'), 'scope', '__httpwww_opengis_netgml3_2_AbstractCRSType_httpwww_opengis_netgml3_2scope', True)

    
    scope = property(__scope.value, __scope.set, None, u'The gml:scope property provides a description of the usage, or limitations of usage, for which this CRS-related object is valid. If unknown, enter "not known".')

    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType

    _ElementMap = IdentifiedObjectType._ElementMap.copy()
    _ElementMap.update({
        __domainOfValidity.name() : __domainOfValidity,
        __scope.name() : __scope
    })
    _AttributeMap = IdentifiedObjectType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractCRSType', AbstractCRSType)


# Complex type AbstractGeneralDerivedCRSType with content type ELEMENT_ONLY
class AbstractGeneralDerivedCRSType (AbstractCRSType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractGeneralDerivedCRSType')
    # Base type is AbstractCRSType
    
    # Element {http://www.opengis.net/gml/3.2}conversion uses Python identifier conversion
    __conversion = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'conversion'), 'conversion', '__httpwww_opengis_netgml3_2_AbstractGeneralDerivedCRSType_httpwww_opengis_netgml3_2conversion', False)

    
    conversion = property(__conversion.value, __conversion.set, None, u'gml:conversion is an association role to the coordinate conversion used to define the derived CRS.')

    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element domainOfValidity ({http://www.opengis.net/gml/3.2}domainOfValidity) inherited from {http://www.opengis.net/gml/3.2}AbstractCRSType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element scope ({http://www.opengis.net/gml/3.2}scope) inherited from {http://www.opengis.net/gml/3.2}AbstractCRSType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType

    _ElementMap = AbstractCRSType._ElementMap.copy()
    _ElementMap.update({
        __conversion.name() : __conversion
    })
    _AttributeMap = AbstractCRSType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractGeneralDerivedCRSType', AbstractGeneralDerivedCRSType)


# Complex type ProjectedCRSType with content type ELEMENT_ONLY
class ProjectedCRSType (AbstractGeneralDerivedCRSType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'ProjectedCRSType')
    # Base type is AbstractGeneralDerivedCRSType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element conversion ({http://www.opengis.net/gml/3.2}conversion) inherited from {http://www.opengis.net/gml/3.2}AbstractGeneralDerivedCRSType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element domainOfValidity ({http://www.opengis.net/gml/3.2}domainOfValidity) inherited from {http://www.opengis.net/gml/3.2}AbstractCRSType
    
    # Element {http://www.opengis.net/gml/3.2}baseGeodeticCRS uses Python identifier baseGeodeticCRS
    __baseGeodeticCRS = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'baseGeodeticCRS'), 'baseGeodeticCRS', '__httpwww_opengis_netgml3_2_ProjectedCRSType_httpwww_opengis_netgml3_2baseGeodeticCRS', False)

    
    baseGeodeticCRS = property(__baseGeodeticCRS.value, __baseGeodeticCRS.set, None, u'gml:baseGeodeticCRS is an association role to the geodetic coordinate reference system used by this projected CRS.')

    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element scope ({http://www.opengis.net/gml/3.2}scope) inherited from {http://www.opengis.net/gml/3.2}AbstractCRSType
    
    # Element {http://www.opengis.net/gml/3.2}baseGeographicCRS uses Python identifier baseGeographicCRS
    __baseGeographicCRS = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'baseGeographicCRS'), 'baseGeographicCRS', '__httpwww_opengis_netgml3_2_ProjectedCRSType_httpwww_opengis_netgml3_2baseGeographicCRS', False)

    
    baseGeographicCRS = property(__baseGeographicCRS.value, __baseGeographicCRS.set, None, u'')

    
    # Element {http://www.opengis.net/gml/3.2}cartesianCS uses Python identifier cartesianCS
    __cartesianCS = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'cartesianCS'), 'cartesianCS', '__httpwww_opengis_netgml3_2_ProjectedCRSType_httpwww_opengis_netgml3_2cartesianCS', False)

    
    cartesianCS = property(__cartesianCS.value, __cartesianCS.set, None, u'gml:cartesianCS is an association role to the Cartesian coordinate system used by this CRS.')

    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType

    _ElementMap = AbstractGeneralDerivedCRSType._ElementMap.copy()
    _ElementMap.update({
        __baseGeodeticCRS.name() : __baseGeodeticCRS,
        __baseGeographicCRS.name() : __baseGeographicCRS,
        __cartesianCS.name() : __cartesianCS
    })
    _AttributeMap = AbstractGeneralDerivedCRSType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'ProjectedCRSType', ProjectedCRSType)


# Complex type SurfaceArrayPropertyType with content type ELEMENT_ONLY
class SurfaceArrayPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'SurfaceArrayPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}AbstractSurface uses Python identifier AbstractSurface
    __AbstractSurface = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractSurface'), 'AbstractSurface', '__httpwww_opengis_netgml3_2_SurfaceArrayPropertyType_httpwww_opengis_netgml3_2AbstractSurface', True)

    
    AbstractSurface = property(__AbstractSurface.value, __AbstractSurface.set, None, u'The AbstractSurface element is the abstract head of the substitution group for all (continuous) surface elements.')

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_SurfaceArrayPropertyType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)


    _ElementMap = {
        __AbstractSurface.name() : __AbstractSurface
    }
    _AttributeMap = {
        __owns.name() : __owns
    }
_Namespace_gml.addCategoryObject('typeBinding', u'SurfaceArrayPropertyType', SurfaceArrayPropertyType)


# Complex type PointPropertyType with content type ELEMENT_ONLY
class PointPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'PointPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}Point uses Python identifier Point
    __Point = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'Point'), 'Point', '__httpwww_opengis_netgml3_2_PointPropertyType_httpwww_opengis_netgml3_2Point', False)

    
    Point = property(__Point.value, __Point.set, None, u'A Point is defined by a single coordinate tuple. The direct position of a point is specified by the pos element which is of type DirectPositionType.')

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_PointPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_PointPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_PointPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_PointPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_PointPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_PointPropertyType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_PointPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_PointPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_PointPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_PointPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)


    _ElementMap = {
        __Point.name() : __Point
    }
    _AttributeMap = {
        __role.name() : __role,
        __arcrole.name() : __arcrole,
        __show.name() : __show,
        __nilReason.name() : __nilReason,
        __actuate.name() : __actuate,
        __owns.name() : __owns,
        __remoteSchema.name() : __remoteSchema,
        __title.name() : __title,
        __href.name() : __href,
        __type.name() : __type
    }
_Namespace_gml.addCategoryObject('typeBinding', u'PointPropertyType', PointPropertyType)


# Complex type CI_ResponsibleParty_Type with content type ELEMENT_ONLY
class CI_ResponsibleParty_Type (AbstractObject_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'CI_ResponsibleParty_Type')
    # Base type is AbstractObject_Type
    
    # Element {http://www.isotc211.org/2005/gmd}role uses Python identifier role
    __role = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'role'), 'role', '__httpwww_isotc211_org2005gmd_CI_ResponsibleParty_Type_httpwww_isotc211_org2005gmdrole', False)

    
    role = property(__role.value, __role.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}individualName uses Python identifier individualName
    __individualName = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'individualName'), 'individualName', '__httpwww_isotc211_org2005gmd_CI_ResponsibleParty_Type_httpwww_isotc211_org2005gmdindividualName', False)

    
    individualName = property(__individualName.value, __individualName.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}organisationName uses Python identifier organisationName
    __organisationName = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'organisationName'), 'organisationName', '__httpwww_isotc211_org2005gmd_CI_ResponsibleParty_Type_httpwww_isotc211_org2005gmdorganisationName', False)

    
    organisationName = property(__organisationName.value, __organisationName.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}contactInfo uses Python identifier contactInfo
    __contactInfo = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'contactInfo'), 'contactInfo', '__httpwww_isotc211_org2005gmd_CI_ResponsibleParty_Type_httpwww_isotc211_org2005gmdcontactInfo', False)

    
    contactInfo = property(__contactInfo.value, __contactInfo.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}positionName uses Python identifier positionName
    __positionName = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'positionName'), 'positionName', '__httpwww_isotc211_org2005gmd_CI_ResponsibleParty_Type_httpwww_isotc211_org2005gmdpositionName', False)

    
    positionName = property(__positionName.value, __positionName.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractObject_Type._ElementMap.copy()
    _ElementMap.update({
        __role.name() : __role,
        __individualName.name() : __individualName,
        __organisationName.name() : __organisationName,
        __contactInfo.name() : __contactInfo,
        __positionName.name() : __positionName
    })
    _AttributeMap = AbstractObject_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'CI_ResponsibleParty_Type', CI_ResponsibleParty_Type)


# Complex type MD_ReferenceSystem_PropertyType with content type ELEMENT_ONLY
class MD_ReferenceSystem_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_ReferenceSystem_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}MD_ReferenceSystem uses Python identifier MD_ReferenceSystem
    __MD_ReferenceSystem = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_ReferenceSystem'), 'MD_ReferenceSystem', '__httpwww_isotc211_org2005gmd_MD_ReferenceSystem_PropertyType_httpwww_isotc211_org2005gmdMD_ReferenceSystem', False)

    
    MD_ReferenceSystem = property(__MD_ReferenceSystem.value, __MD_ReferenceSystem.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_MD_ReferenceSystem_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_MD_ReferenceSystem_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_MD_ReferenceSystem_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_MD_ReferenceSystem_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_MD_ReferenceSystem_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_MD_ReferenceSystem_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_MD_ReferenceSystem_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_MD_ReferenceSystem_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_MD_ReferenceSystem_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")


    _ElementMap = {
        __MD_ReferenceSystem.name() : __MD_ReferenceSystem
    }
    _AttributeMap = {
        __type.name() : __type,
        __role.name() : __role,
        __arcrole.name() : __arcrole,
        __nilReason.name() : __nilReason,
        __title.name() : __title,
        __uuidref.name() : __uuidref,
        __show.name() : __show,
        __href.name() : __href,
        __actuate.name() : __actuate
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_ReferenceSystem_PropertyType', MD_ReferenceSystem_PropertyType)


# Complex type AbstractTopologyType with content type ELEMENT_ONLY
class AbstractTopologyType (AbstractGMLType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractTopologyType')
    # Base type is AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType

    _ElementMap = AbstractGMLType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractGMLType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractTopologyType', AbstractTopologyType)


# Complex type AbstractTopoPrimitiveType with content type ELEMENT_ONLY
class AbstractTopoPrimitiveType (AbstractTopologyType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractTopoPrimitiveType')
    # Base type is AbstractTopologyType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType

    _ElementMap = AbstractTopologyType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractTopologyType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractTopoPrimitiveType', AbstractTopoPrimitiveType)


# Complex type FaceType with content type ELEMENT_ONLY
class FaceType (AbstractTopoPrimitiveType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'FaceType')
    # Base type is AbstractTopoPrimitiveType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}directedEdge uses Python identifier directedEdge
    __directedEdge = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'directedEdge'), 'directedEdge', '__httpwww_opengis_netgml3_2_FaceType_httpwww_opengis_netgml3_2directedEdge', True)

    
    directedEdge = property(__directedEdge.value, __directedEdge.set, None, u'A gml:directedEdge property element describes the boundary of topology faces, the coBoundary of topology nodes and is used in the support of topological line features via the gml:TopoCurve expression, see below. The orientation attribute of type gml:SignType expresses the sense in which the included edge is used, i.e. forward or reverse.')

    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}directedTopoSolid uses Python identifier directedTopoSolid
    __directedTopoSolid = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'directedTopoSolid'), 'directedTopoSolid', '__httpwww_opengis_netgml3_2_FaceType_httpwww_opengis_netgml3_2directedTopoSolid', True)

    
    directedTopoSolid = property(__directedTopoSolid.value, __directedTopoSolid.set, None, u'The gml:directedSolid property element describes the coBoundary of topology faces and is used in the support of volume features via the gml:TopoVolume expression, see below. The orientation attribute of type gml:SignType expresses the sense in which the included solid appears in the face coboundary. In the context of a gml:TopoVolume the orientation attribute has no meaning.')

    
    # Element {http://www.opengis.net/gml/3.2}surfaceProperty uses Python identifier surfaceProperty
    __surfaceProperty = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'surfaceProperty'), 'surfaceProperty', '__httpwww_opengis_netgml3_2_FaceType_httpwww_opengis_netgml3_2surfaceProperty', False)

    
    surfaceProperty = property(__surfaceProperty.value, __surfaceProperty.set, None, u'This property element either references a surface via the XLink-attributes or contains the surface element. surfaceProperty is the predefined property which may be used by GML Application Schemas whenever a GML feature has a property with a value that is substitutable for AbstractSurface.')

    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}isolated uses Python identifier isolated
    __isolated = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'isolated'), 'isolated', '__httpwww_opengis_netgml3_2_FaceType_httpwww_opengis_netgml3_2isolated', True)

    
    isolated = property(__isolated.value, __isolated.set, None, None)

    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute aggregationType uses Python identifier aggregationType
    __aggregationType = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'aggregationType'), 'aggregationType', '__httpwww_opengis_netgml3_2_FaceType_aggregationType', AggregationType)
    
    aggregationType = property(__aggregationType.value, __aggregationType.set, None, None)

    
    # Attribute universal uses Python identifier universal
    __universal = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'universal'), 'universal', '__httpwww_opengis_netgml3_2_FaceType_universal', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    universal = property(__universal.value, __universal.set, None, u'If the topological representation exists an unbounded manifold (e.g. Euclidean plane), a gml:Face must indicate whether it is a universal face or not, to ensure a lossless topology representation as defined by Kuijpers, et. al. (see OGC 05-102 Topology IPR). The optional universal attribute of type boolean is used to indicate this. NOTE The universal face is normally not part of any feature, and is used to represent the unbounded portion of the data set. Its interior boundary (it has no exterior boundary) would normally be considered the exterior boundary of the map represented by the data set. ')

    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType

    _ElementMap = AbstractTopoPrimitiveType._ElementMap.copy()
    _ElementMap.update({
        __directedEdge.name() : __directedEdge,
        __directedTopoSolid.name() : __directedTopoSolid,
        __surfaceProperty.name() : __surfaceProperty,
        __isolated.name() : __isolated
    })
    _AttributeMap = AbstractTopoPrimitiveType._AttributeMap.copy()
    _AttributeMap.update({
        __aggregationType.name() : __aggregationType,
        __universal.name() : __universal
    })
_Namespace_gml.addCategoryObject('typeBinding', u'FaceType', FaceType)


# Complex type DQ_ConceptualConsistency_PropertyType with content type ELEMENT_ONLY
class DQ_ConceptualConsistency_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'DQ_ConceptualConsistency_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}DQ_ConceptualConsistency uses Python identifier DQ_ConceptualConsistency
    __DQ_ConceptualConsistency = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'DQ_ConceptualConsistency'), 'DQ_ConceptualConsistency', '__httpwww_isotc211_org2005gmd_DQ_ConceptualConsistency_PropertyType_httpwww_isotc211_org2005gmdDQ_ConceptualConsistency', False)

    
    DQ_ConceptualConsistency = property(__DQ_ConceptualConsistency.value, __DQ_ConceptualConsistency.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_DQ_ConceptualConsistency_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_DQ_ConceptualConsistency_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_DQ_ConceptualConsistency_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_DQ_ConceptualConsistency_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_DQ_ConceptualConsistency_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_DQ_ConceptualConsistency_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_DQ_ConceptualConsistency_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_DQ_ConceptualConsistency_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_DQ_ConceptualConsistency_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)


    _ElementMap = {
        __DQ_ConceptualConsistency.name() : __DQ_ConceptualConsistency
    }
    _AttributeMap = {
        __arcrole.name() : __arcrole,
        __role.name() : __role,
        __nilReason.name() : __nilReason,
        __title.name() : __title,
        __show.name() : __show,
        __uuidref.name() : __uuidref,
        __href.name() : __href,
        __actuate.name() : __actuate,
        __type.name() : __type
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'DQ_ConceptualConsistency_PropertyType', DQ_ConceptualConsistency_PropertyType)


# Complex type MD_ServiceIdentification_PropertyType with content type ELEMENT_ONLY
class MD_ServiceIdentification_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_ServiceIdentification_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}MD_ServiceIdentification uses Python identifier MD_ServiceIdentification
    __MD_ServiceIdentification = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_ServiceIdentification'), 'MD_ServiceIdentification', '__httpwww_isotc211_org2005gmd_MD_ServiceIdentification_PropertyType_httpwww_isotc211_org2005gmdMD_ServiceIdentification', False)

    
    MD_ServiceIdentification = property(__MD_ServiceIdentification.value, __MD_ServiceIdentification.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_MD_ServiceIdentification_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_MD_ServiceIdentification_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_MD_ServiceIdentification_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_MD_ServiceIdentification_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_MD_ServiceIdentification_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_MD_ServiceIdentification_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_MD_ServiceIdentification_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_MD_ServiceIdentification_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_MD_ServiceIdentification_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")


    _ElementMap = {
        __MD_ServiceIdentification.name() : __MD_ServiceIdentification
    }
    _AttributeMap = {
        __arcrole.name() : __arcrole,
        __role.name() : __role,
        __title.name() : __title,
        __show.name() : __show,
        __uuidref.name() : __uuidref,
        __nilReason.name() : __nilReason,
        __href.name() : __href,
        __type.name() : __type,
        __actuate.name() : __actuate
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_ServiceIdentification_PropertyType', MD_ServiceIdentification_PropertyType)


# Complex type CoordinateSystemAxisPropertyType with content type ELEMENT_ONLY
class CoordinateSystemAxisPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'CoordinateSystemAxisPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}CoordinateSystemAxis uses Python identifier CoordinateSystemAxis
    __CoordinateSystemAxis = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'CoordinateSystemAxis'), 'CoordinateSystemAxis', '__httpwww_opengis_netgml3_2_CoordinateSystemAxisPropertyType_httpwww_opengis_netgml3_2CoordinateSystemAxis', False)

    
    CoordinateSystemAxis = property(__CoordinateSystemAxis.value, __CoordinateSystemAxis.set, None, u'gml:CoordinateSystemAxis is a definition of a coordinate system axis.')

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_CoordinateSystemAxisPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_CoordinateSystemAxisPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_CoordinateSystemAxisPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_CoordinateSystemAxisPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_CoordinateSystemAxisPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_CoordinateSystemAxisPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_CoordinateSystemAxisPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_CoordinateSystemAxisPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_CoordinateSystemAxisPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")


    _ElementMap = {
        __CoordinateSystemAxis.name() : __CoordinateSystemAxis
    }
    _AttributeMap = {
        __remoteSchema.name() : __remoteSchema,
        __href.name() : __href,
        __title.name() : __title,
        __type.name() : __type,
        __nilReason.name() : __nilReason,
        __role.name() : __role,
        __show.name() : __show,
        __arcrole.name() : __arcrole,
        __actuate.name() : __actuate
    }
_Namespace_gml.addCategoryObject('typeBinding', u'CoordinateSystemAxisPropertyType', CoordinateSystemAxisPropertyType)


# Complex type Binary_PropertyType with content type ELEMENT_ONLY
class Binary_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gco, u'Binary_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gco}Binary uses Python identifier Binary
    __Binary = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'Binary'), 'Binary', '__httpwww_isotc211_org2005gco_Binary_PropertyType_httpwww_isotc211_org2005gcoBinary', False)

    
    Binary = property(__Binary.value, __Binary.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gco_Binary_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        __Binary.name() : __Binary
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason
    }
_Namespace_gco.addCategoryObject('typeBinding', u'Binary_PropertyType', Binary_PropertyType)


# Complex type MD_Georeferenceable_PropertyType with content type ELEMENT_ONLY
class MD_Georeferenceable_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_Georeferenceable_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}MD_Georeferenceable uses Python identifier MD_Georeferenceable
    __MD_Georeferenceable = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_Georeferenceable'), 'MD_Georeferenceable', '__httpwww_isotc211_org2005gmd_MD_Georeferenceable_PropertyType_httpwww_isotc211_org2005gmdMD_Georeferenceable', False)

    
    MD_Georeferenceable = property(__MD_Georeferenceable.value, __MD_Georeferenceable.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_MD_Georeferenceable_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_MD_Georeferenceable_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_MD_Georeferenceable_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_MD_Georeferenceable_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_MD_Georeferenceable_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_MD_Georeferenceable_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_MD_Georeferenceable_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_MD_Georeferenceable_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_MD_Georeferenceable_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)


    _ElementMap = {
        __MD_Georeferenceable.name() : __MD_Georeferenceable
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason,
        __type.name() : __type,
        __title.name() : __title,
        __show.name() : __show,
        __href.name() : __href,
        __actuate.name() : __actuate,
        __uuidref.name() : __uuidref,
        __role.name() : __role,
        __arcrole.name() : __arcrole
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_Georeferenceable_PropertyType', MD_Georeferenceable_PropertyType)


# Complex type SphericalCSPropertyType with content type ELEMENT_ONLY
class SphericalCSPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'SphericalCSPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}SphericalCS uses Python identifier SphericalCS
    __SphericalCS = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'SphericalCS'), 'SphericalCS', '__httpwww_opengis_netgml3_2_SphericalCSPropertyType_httpwww_opengis_netgml3_2SphericalCS', False)

    
    SphericalCS = property(__SphericalCS.value, __SphericalCS.set, None, u'gml:SphericalCS is a three-dimensional coordinate system with one distance measured from the origin and two angular coordinates. A SphericalCS shall have three gml:axis property elements.')

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_SphericalCSPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_SphericalCSPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_SphericalCSPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_SphericalCSPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_SphericalCSPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_SphericalCSPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_SphericalCSPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_SphericalCSPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_SphericalCSPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)


    _ElementMap = {
        __SphericalCS.name() : __SphericalCS
    }
    _AttributeMap = {
        __remoteSchema.name() : __remoteSchema,
        __type.name() : __type,
        __title.name() : __title,
        __arcrole.name() : __arcrole,
        __role.name() : __role,
        __nilReason.name() : __nilReason,
        __actuate.name() : __actuate,
        __show.name() : __show,
        __href.name() : __href
    }
_Namespace_gml.addCategoryObject('typeBinding', u'SphericalCSPropertyType', SphericalCSPropertyType)


# Complex type EdgeType with content type ELEMENT_ONLY
class EdgeType (AbstractTopoPrimitiveType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'EdgeType')
    # Base type is AbstractTopoPrimitiveType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}curveProperty uses Python identifier curveProperty
    __curveProperty = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'curveProperty'), 'curveProperty', '__httpwww_opengis_netgml3_2_EdgeType_httpwww_opengis_netgml3_2curveProperty', False)

    
    curveProperty = property(__curveProperty.value, __curveProperty.set, None, u'This property element either references a curve via the XLink-attributes or contains the curve element. curveProperty is the predefined property which may be used by GML Application Schemas whenever a GML feature has a property with a value that is substitutable for AbstractCurve.')

    
    # Element {http://www.opengis.net/gml/3.2}container uses Python identifier container
    __container = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'container'), 'container', '__httpwww_opengis_netgml3_2_EdgeType_httpwww_opengis_netgml3_2container', False)

    
    container = property(__container.value, __container.set, None, None)

    
    # Element {http://www.opengis.net/gml/3.2}directedFace uses Python identifier directedFace
    __directedFace = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'directedFace'), 'directedFace', '__httpwww_opengis_netgml3_2_EdgeType_httpwww_opengis_netgml3_2directedFace', True)

    
    directedFace = property(__directedFace.value, __directedFace.set, None, u'The gml:directedFace property element describes the boundary of topology solids, in the coBoundary of topology edges and is used in the support of surface features via the gml:TopoSurface expression, see below. The orientation attribute of type gml:SignType expresses the sense in which the included face is used i.e. inward or outward with respect to the surface normal in any geometric realisation.')

    
    # Element {http://www.opengis.net/gml/3.2}directedNode uses Python identifier directedNode
    __directedNode = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'directedNode'), 'directedNode', '__httpwww_opengis_netgml3_2_EdgeType_httpwww_opengis_netgml3_2directedNode', True)

    
    directedNode = property(__directedNode.value, __directedNode.set, None, u'A gml:directedNode property element describes the boundary of topology edges and is used in the support of topological point features via the gml:TopoPoint expression, see below. The orientation attribute of type gml:SignType expresses the sense in which the included node is used: start ("-") or end ("+") node.')

    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute aggregationType uses Python identifier aggregationType
    __aggregationType = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'aggregationType'), 'aggregationType', '__httpwww_opengis_netgml3_2_EdgeType_aggregationType', AggregationType)
    
    aggregationType = property(__aggregationType.value, __aggregationType.set, None, None)

    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType

    _ElementMap = AbstractTopoPrimitiveType._ElementMap.copy()
    _ElementMap.update({
        __curveProperty.name() : __curveProperty,
        __container.name() : __container,
        __directedFace.name() : __directedFace,
        __directedNode.name() : __directedNode
    })
    _AttributeMap = AbstractTopoPrimitiveType._AttributeMap.copy()
    _AttributeMap.update({
        __aggregationType.name() : __aggregationType
    })
_Namespace_gml.addCategoryObject('typeBinding', u'EdgeType', EdgeType)


# Complex type AbstractDQ_Result_Type with content type EMPTY
class AbstractDQ_Result_Type (AbstractObject_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_EMPTY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'AbstractDQ_Result_Type')
    # Base type is AbstractObject_Type
    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractObject_Type._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractObject_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'AbstractDQ_Result_Type', AbstractDQ_Result_Type)


# Complex type DQ_ConformanceResult_Type with content type ELEMENT_ONLY
class DQ_ConformanceResult_Type (AbstractDQ_Result_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'DQ_ConformanceResult_Type')
    # Base type is AbstractDQ_Result_Type
    
    # Element {http://www.isotc211.org/2005/gmd}pass uses Python identifier pass_
    __pass = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'pass'), 'pass_', '__httpwww_isotc211_org2005gmd_DQ_ConformanceResult_Type_httpwww_isotc211_org2005gmdpass', False)

    
    pass_ = property(__pass.value, __pass.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}specification uses Python identifier specification
    __specification = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'specification'), 'specification', '__httpwww_isotc211_org2005gmd_DQ_ConformanceResult_Type_httpwww_isotc211_org2005gmdspecification', False)

    
    specification = property(__specification.value, __specification.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}explanation uses Python identifier explanation
    __explanation = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'explanation'), 'explanation', '__httpwww_isotc211_org2005gmd_DQ_ConformanceResult_Type_httpwww_isotc211_org2005gmdexplanation', False)

    
    explanation = property(__explanation.value, __explanation.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractDQ_Result_Type._ElementMap.copy()
    _ElementMap.update({
        __pass.name() : __pass,
        __specification.name() : __specification,
        __explanation.name() : __explanation
    })
    _AttributeMap = AbstractDQ_Result_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'DQ_ConformanceResult_Type', DQ_ConformanceResult_Type)


# Complex type RangeSetType with content type ELEMENT_ONLY
class RangeSetType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'RangeSetType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}ValueArray uses Python identifier ValueArray
    __ValueArray = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'ValueArray'), 'ValueArray', '__httpwww_opengis_netgml3_2_RangeSetType_httpwww_opengis_netgml3_2ValueArray', True)

    
    ValueArray = property(__ValueArray.value, __ValueArray.set, None, u'A Value Array is used for homogeneous arrays of primitive and aggregate values.  \nThe member values may be scalars, composites, arrays or lists.\nValueArray has the same content model as CompositeValue, but the member values shall be homogeneous.  The element declaration contains a Schematron constraint which expresses this restriction precisely.  Since the members are homogeneous, the gml:referenceSystem (uom, codeSpace) may be specified on the gml:ValueArray itself and inherited by all the members if desired.')

    
    # Element {http://www.opengis.net/gml/3.2}AbstractScalarValueList uses Python identifier AbstractScalarValueList
    __AbstractScalarValueList = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractScalarValueList'), 'AbstractScalarValueList', '__httpwww_opengis_netgml3_2_RangeSetType_httpwww_opengis_netgml3_2AbstractScalarValueList', True)

    
    AbstractScalarValueList = property(__AbstractScalarValueList.value, __AbstractScalarValueList.set, None, u'gml:AbstractScalarValueList is an abstract element which acts as the head of a substitution group which contains gml:BooleanList, gml:CategoryList, gml:CountList and gml:QuantityList, and (transitively) the elements in their substitution groups.')

    
    # Element {http://www.opengis.net/gml/3.2}DataBlock uses Python identifier DataBlock
    __DataBlock = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'DataBlock'), 'DataBlock', '__httpwww_opengis_netgml3_2_RangeSetType_httpwww_opengis_netgml3_2DataBlock', False)

    
    DataBlock = property(__DataBlock.value, __DataBlock.set, None, u'gml:DataBlock describes the Range as a block of text encoded values similar to a Common Separated Value (CSV) representation.\nThe range set parameterization is described by the property gml:rangeParameters.')

    
    # Element {http://www.opengis.net/gml/3.2}File uses Python identifier File
    __File = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'File'), 'File', '__httpwww_opengis_netgml3_2_RangeSetType_httpwww_opengis_netgml3_2File', False)

    
    File = property(__File.value, __File.set, None, u'for efficiency reasons, GML also provides a means of encoding the range set in an arbitrary external encoding, such as a binary file.  This encoding may be "well-known" but this is not required. This mode uses the gml:File element.\nThe values of the coverage (attribute values in the range set) are transmitted in a external file that is referenced from the XML structure described by gml:FileType.  The external file is referenced by the gml:fileReference property that is an anyURI (the gml:fileName property has been deprecated).  This means that the external file may be located remotely from the referencing GML instance. \nThe gml:compression property points to a definition of a compression algorithm through an anyURI.  This may be a retrievable, computable definition or simply a reference to an unambiguous name for the compression method.\nThe gml:mimeType property points to a definition of the file mime type.\nThe gml:fileStructure property is defined by a codelist. Note further that all values shall be enclosed in a single file. Multi-file structures for values are not supported in GML.\nThe semantics of the range set is described as above using the gml:rangeParameters property.\nNote that if any compression algorithm is applied, the structure above applies only to the pre-compression or post-decompression structure of the file.\nNote that the fields within a record match the gml:valueComponents of the gml:CompositeValue in document order.')


    _ElementMap = {
        __ValueArray.name() : __ValueArray,
        __AbstractScalarValueList.name() : __AbstractScalarValueList,
        __DataBlock.name() : __DataBlock,
        __File.name() : __File
    }
    _AttributeMap = {
        
    }
_Namespace_gml.addCategoryObject('typeBinding', u'RangeSetType', RangeSetType)


# Complex type Binary_Type with content type SIMPLE
class Binary_Type (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = pyxb.binding.datatypes.string
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_SIMPLE
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gco, u'Binary_Type')
    # Base type is pyxb.binding.datatypes.string
    
    # Attribute src uses Python identifier src
    __src = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'src'), 'src', '__httpwww_isotc211_org2005gco_Binary_Type_src', pyxb.binding.datatypes.anyURI)
    
    src = property(__src.value, __src.set, None, None)


    _ElementMap = {
        
    }
    _AttributeMap = {
        __src.name() : __src
    }
_Namespace_gco.addCategoryObject('typeBinding', u'Binary_Type', Binary_Type)


# Complex type CompoundCRSType with content type ELEMENT_ONLY
class CompoundCRSType (AbstractCRSType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'CompoundCRSType')
    # Base type is AbstractCRSType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}componentReferenceSystem uses Python identifier componentReferenceSystem
    __componentReferenceSystem = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'componentReferenceSystem'), 'componentReferenceSystem', '__httpwww_opengis_netgml3_2_CompoundCRSType_httpwww_opengis_netgml3_2componentReferenceSystem', True)

    
    componentReferenceSystem = property(__componentReferenceSystem.value, __componentReferenceSystem.set, None, u'The gml:componentReferenceSystem elements are an ordered sequence of associations to all the component coordinate reference systems included in this compound coordinate reference system. The gml:AggregationAttributeGroup should be used to specify that the gml:componentReferenceSystem properties are ordered.')

    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element domainOfValidity ({http://www.opengis.net/gml/3.2}domainOfValidity) inherited from {http://www.opengis.net/gml/3.2}AbstractCRSType
    
    # Element scope ({http://www.opengis.net/gml/3.2}scope) inherited from {http://www.opengis.net/gml/3.2}AbstractCRSType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Attribute aggregationType uses Python identifier aggregationType
    __aggregationType = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'aggregationType'), 'aggregationType', '__httpwww_opengis_netgml3_2_CompoundCRSType_aggregationType', AggregationType)
    
    aggregationType = property(__aggregationType.value, __aggregationType.set, None, None)

    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType

    _ElementMap = AbstractCRSType._ElementMap.copy()
    _ElementMap.update({
        __componentReferenceSystem.name() : __componentReferenceSystem
    })
    _AttributeMap = AbstractCRSType._AttributeMap.copy()
    _AttributeMap.update({
        __aggregationType.name() : __aggregationType
    })
_Namespace_gml.addCategoryObject('typeBinding', u'CompoundCRSType', CompoundCRSType)


# Complex type AbstractDatumType with content type ELEMENT_ONLY
class AbstractDatumType (IdentifiedObjectType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractDatumType')
    # Base type is IdentifiedObjectType
    
    # Element {http://www.opengis.net/gml/3.2}scope uses Python identifier scope
    __scope = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'scope'), 'scope', '__httpwww_opengis_netgml3_2_AbstractDatumType_httpwww_opengis_netgml3_2scope', True)

    
    scope = property(__scope.value, __scope.set, None, u'The gml:scope property provides a description of the usage, or limitations of usage, for which this CRS-related object is valid. If unknown, enter "not known".')

    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}anchorDefinition uses Python identifier anchorDefinition
    __anchorDefinition = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'anchorDefinition'), 'anchorDefinition', '__httpwww_opengis_netgml3_2_AbstractDatumType_httpwww_opengis_netgml3_2anchorDefinition', False)

    
    anchorDefinition = property(__anchorDefinition.value, __anchorDefinition.set, None, u'gml:anchorDefinition is a description, possibly including coordinates, of the definition used to anchor the datum to the Earth. Also known as the "origin", especially for engineering and image datums. The codeSpace attribute may be used to reference a source of more detailed on this point or surface, or on a set of such descriptions.\n-\tFor a geodetic datum, this point is also known as the fundamental point, which is traditionally the point where the relationship between geoid and ellipsoid is defined. In some cases, the "fundamental point" may consist of a number of points. In those cases, the parameters defining the geoid/ellipsoid relationship have been averaged for these points, and the averages adopted as the datum definition.\n-\tFor an engineering datum, the anchor definition may be a physical point, or it may be a point with defined coordinates in another CRS.may\n-\tFor an image datum, the anchor definition is usually either the centre of the image or the corner of the image.\n-\tFor a temporal datum, this attribute is not defined. Instead of the anchor definition, a temporal datum carries a separate time origin of type DateTime.')

    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}realizationEpoch uses Python identifier realizationEpoch
    __realizationEpoch = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'realizationEpoch'), 'realizationEpoch', '__httpwww_opengis_netgml3_2_AbstractDatumType_httpwww_opengis_netgml3_2realizationEpoch', False)

    
    realizationEpoch = property(__realizationEpoch.value, __realizationEpoch.set, None, u'gml:realizationEpoch is the time after which this datum definition is valid. See ISO 19111 Table 32 for details.')

    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}domainOfValidity uses Python identifier domainOfValidity
    __domainOfValidity = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'domainOfValidity'), 'domainOfValidity', '__httpwww_opengis_netgml3_2_AbstractDatumType_httpwww_opengis_netgml3_2domainOfValidity', False)

    
    domainOfValidity = property(__domainOfValidity.value, __domainOfValidity.set, None, u'The gml:domainOfValidity property implements an association role to an EX_Extent object as encoded in ISO/TS 19139, either referencing or containing the definition of that extent.')

    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType

    _ElementMap = IdentifiedObjectType._ElementMap.copy()
    _ElementMap.update({
        __scope.name() : __scope,
        __anchorDefinition.name() : __anchorDefinition,
        __realizationEpoch.name() : __realizationEpoch,
        __domainOfValidity.name() : __domainOfValidity
    })
    _AttributeMap = IdentifiedObjectType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractDatumType', AbstractDatumType)


# Complex type VerticalDatumType with content type ELEMENT_ONLY
class VerticalDatumType (AbstractDatumType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'VerticalDatumType')
    # Base type is AbstractDatumType
    
    # Element scope ({http://www.opengis.net/gml/3.2}scope) inherited from {http://www.opengis.net/gml/3.2}AbstractDatumType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element anchorDefinition ({http://www.opengis.net/gml/3.2}anchorDefinition) inherited from {http://www.opengis.net/gml/3.2}AbstractDatumType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element realizationEpoch ({http://www.opengis.net/gml/3.2}realizationEpoch) inherited from {http://www.opengis.net/gml/3.2}AbstractDatumType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element domainOfValidity ({http://www.opengis.net/gml/3.2}domainOfValidity) inherited from {http://www.opengis.net/gml/3.2}AbstractDatumType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType

    _ElementMap = AbstractDatumType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractDatumType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'VerticalDatumType', VerticalDatumType)


# Complex type TemporalDatumBaseType with content type ELEMENT_ONLY
class TemporalDatumBaseType (AbstractDatumType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'TemporalDatumBaseType')
    # Base type is AbstractDatumType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element scope ({http://www.opengis.net/gml/3.2}scope) inherited from {http://www.opengis.net/gml/3.2}AbstractDatumType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element domainOfValidity ({http://www.opengis.net/gml/3.2}domainOfValidity) inherited from {http://www.opengis.net/gml/3.2}AbstractDatumType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Attribute id_ is restricted from parent
    
    # Attribute {http://www.opengis.net/gml/3.2}id uses Python identifier id_
    __id_ = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'id'), 'id_', '__httpwww_opengis_netgml3_2_DefinitionBaseType_httpwww_opengis_netgml3_2id', pyxb.binding.datatypes.ID, required=True)
    
    id_ = property(__id_.value, __id_.set, None, u'The attribute gml:id supports provision of a handle for the XML element representing a GML Object. Its use is mandatory for all GML objects. It is of XML type ID, so is constrained to be unique in the XML document within which it occurs.')


    _ElementMap = AbstractDatumType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractDatumType._AttributeMap.copy()
    _AttributeMap.update({
        __id_.name() : __id_
    })
_Namespace_gml.addCategoryObject('typeBinding', u'TemporalDatumBaseType', TemporalDatumBaseType)


# Complex type TemporalDatumType with content type ELEMENT_ONLY
class TemporalDatumType (TemporalDatumBaseType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'TemporalDatumType')
    # Base type is TemporalDatumBaseType
    
    # Element scope ({http://www.opengis.net/gml/3.2}scope) inherited from {http://www.opengis.net/gml/3.2}AbstractDatumType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}origin uses Python identifier origin
    __origin = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'origin'), 'origin', '__httpwww_opengis_netgml3_2_TemporalDatumType_httpwww_opengis_netgml3_2origin', False)

    
    origin = property(__origin.value, __origin.set, None, u'gml:origin is the date and time origin of this temporal datum.')

    
    # Element domainOfValidity ({http://www.opengis.net/gml/3.2}domainOfValidity) inherited from {http://www.opengis.net/gml/3.2}AbstractDatumType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Attribute id_2 inherited from {http://www.opengis.net/gml/3.2}TemporalDatumBaseType

    _ElementMap = TemporalDatumBaseType._ElementMap.copy()
    _ElementMap.update({
        __origin.name() : __origin
    })
    _AttributeMap = TemporalDatumBaseType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'TemporalDatumType', TemporalDatumType)


# Complex type CI_OnLineFunctionCode_PropertyType with content type ELEMENT_ONLY
class CI_OnLineFunctionCode_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'CI_OnLineFunctionCode_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}CI_OnLineFunctionCode uses Python identifier CI_OnLineFunctionCode
    __CI_OnLineFunctionCode = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'CI_OnLineFunctionCode'), 'CI_OnLineFunctionCode', '__httpwww_isotc211_org2005gmd_CI_OnLineFunctionCode_PropertyType_httpwww_isotc211_org2005gmdCI_OnLineFunctionCode', False)

    
    CI_OnLineFunctionCode = property(__CI_OnLineFunctionCode.value, __CI_OnLineFunctionCode.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_CI_OnLineFunctionCode_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        __CI_OnLineFunctionCode.name() : __CI_OnLineFunctionCode
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'CI_OnLineFunctionCode_PropertyType', CI_OnLineFunctionCode_PropertyType)


# Complex type ImageCRSType with content type ELEMENT_ONLY
class ImageCRSType (AbstractCRSType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'ImageCRSType')
    # Base type is AbstractCRSType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}affineCS uses Python identifier affineCS
    __affineCS = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'affineCS'), 'affineCS', '__httpwww_opengis_netgml3_2_ImageCRSType_httpwww_opengis_netgml3_2affineCS', False)

    
    affineCS = property(__affineCS.value, __affineCS.set, None, u'gml:affineCS is an association role to the affine coordinate system used by this CRS.')

    
    # Element {http://www.opengis.net/gml/3.2}usesObliqueCartesianCS uses Python identifier usesObliqueCartesianCS
    __usesObliqueCartesianCS = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'usesObliqueCartesianCS'), 'usesObliqueCartesianCS', '__httpwww_opengis_netgml3_2_ImageCRSType_httpwww_opengis_netgml3_2usesObliqueCartesianCS', False)

    
    usesObliqueCartesianCS = property(__usesObliqueCartesianCS.value, __usesObliqueCartesianCS.set, None, u'')

    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element domainOfValidity ({http://www.opengis.net/gml/3.2}domainOfValidity) inherited from {http://www.opengis.net/gml/3.2}AbstractCRSType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element scope ({http://www.opengis.net/gml/3.2}scope) inherited from {http://www.opengis.net/gml/3.2}AbstractCRSType
    
    # Element {http://www.opengis.net/gml/3.2}cartesianCS uses Python identifier cartesianCS
    __cartesianCS = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'cartesianCS'), 'cartesianCS', '__httpwww_opengis_netgml3_2_ImageCRSType_httpwww_opengis_netgml3_2cartesianCS', False)

    
    cartesianCS = property(__cartesianCS.value, __cartesianCS.set, None, u'gml:cartesianCS is an association role to the Cartesian coordinate system used by this CRS.')

    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Element {http://www.opengis.net/gml/3.2}imageDatum uses Python identifier imageDatum
    __imageDatum = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'imageDatum'), 'imageDatum', '__httpwww_opengis_netgml3_2_ImageCRSType_httpwww_opengis_netgml3_2imageDatum', False)

    
    imageDatum = property(__imageDatum.value, __imageDatum.set, None, u'gml:imageDatum is an association role to the image datum used by this CRS.')

    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType

    _ElementMap = AbstractCRSType._ElementMap.copy()
    _ElementMap.update({
        __affineCS.name() : __affineCS,
        __usesObliqueCartesianCS.name() : __usesObliqueCartesianCS,
        __cartesianCS.name() : __cartesianCS,
        __imageDatum.name() : __imageDatum
    })
    _AttributeMap = AbstractCRSType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'ImageCRSType', ImageCRSType)


# Complex type CoordinatesType with content type SIMPLE
class CoordinatesType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = pyxb.binding.datatypes.string
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_SIMPLE
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'CoordinatesType')
    # Base type is pyxb.binding.datatypes.string
    
    # Attribute cs uses Python identifier cs
    __cs = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'cs'), 'cs', '__httpwww_opengis_netgml3_2_CoordinatesType_cs', pyxb.binding.datatypes.string, unicode_default=u',')
    
    cs = property(__cs.value, __cs.set, None, None)

    
    # Attribute decimal uses Python identifier decimal
    __decimal = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'decimal'), 'decimal', '__httpwww_opengis_netgml3_2_CoordinatesType_decimal', pyxb.binding.datatypes.string, unicode_default=u'.')
    
    decimal = property(__decimal.value, __decimal.set, None, None)

    
    # Attribute ts uses Python identifier ts
    __ts = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'ts'), 'ts', '__httpwww_opengis_netgml3_2_CoordinatesType_ts', pyxb.binding.datatypes.string, unicode_default=u' ')
    
    ts = property(__ts.value, __ts.set, None, None)


    _ElementMap = {
        
    }
    _AttributeMap = {
        __cs.name() : __cs,
        __decimal.name() : __decimal,
        __ts.name() : __ts
    }
_Namespace_gml.addCategoryObject('typeBinding', u'CoordinatesType', CoordinatesType)


# Complex type DirectPositionType with content type SIMPLE
class DirectPositionType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = doubleList
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_SIMPLE
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'DirectPositionType')
    # Base type is doubleList
    
    # Attribute srsName uses Python identifier srsName
    __srsName = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'srsName'), 'srsName', '__httpwww_opengis_netgml3_2_DirectPositionType_srsName', pyxb.binding.datatypes.anyURI)
    
    srsName = property(__srsName.value, __srsName.set, None, None)

    
    # Attribute axisLabels uses Python identifier axisLabels
    __axisLabels = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'axisLabels'), 'axisLabels', '__httpwww_opengis_netgml3_2_DirectPositionType_axisLabels', NCNameList)
    
    axisLabels = property(__axisLabels.value, __axisLabels.set, None, None)

    
    # Attribute uomLabels uses Python identifier uomLabels
    __uomLabels = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uomLabels'), 'uomLabels', '__httpwww_opengis_netgml3_2_DirectPositionType_uomLabels', NCNameList)
    
    uomLabels = property(__uomLabels.value, __uomLabels.set, None, None)

    
    # Attribute srsDimension uses Python identifier srsDimension
    __srsDimension = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'srsDimension'), 'srsDimension', '__httpwww_opengis_netgml3_2_DirectPositionType_srsDimension', pyxb.binding.datatypes.positiveInteger)
    
    srsDimension = property(__srsDimension.value, __srsDimension.set, None, None)


    _ElementMap = {
        
    }
    _AttributeMap = {
        __srsName.name() : __srsName,
        __axisLabels.name() : __axisLabels,
        __uomLabels.name() : __uomLabels,
        __srsDimension.name() : __srsDimension
    }
_Namespace_gml.addCategoryObject('typeBinding', u'DirectPositionType', DirectPositionType)


# Complex type CI_OnlineResource_PropertyType with content type ELEMENT_ONLY
class CI_OnlineResource_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'CI_OnlineResource_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}CI_OnlineResource uses Python identifier CI_OnlineResource
    __CI_OnlineResource = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'CI_OnlineResource'), 'CI_OnlineResource', '__httpwww_isotc211_org2005gmd_CI_OnlineResource_PropertyType_httpwww_isotc211_org2005gmdCI_OnlineResource', False)

    
    CI_OnlineResource = property(__CI_OnlineResource.value, __CI_OnlineResource.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_CI_OnlineResource_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_CI_OnlineResource_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_CI_OnlineResource_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_CI_OnlineResource_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_CI_OnlineResource_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_CI_OnlineResource_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_CI_OnlineResource_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_CI_OnlineResource_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_CI_OnlineResource_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)


    _ElementMap = {
        __CI_OnlineResource.name() : __CI_OnlineResource
    }
    _AttributeMap = {
        __type.name() : __type,
        __show.name() : __show,
        __href.name() : __href,
        __actuate.name() : __actuate,
        __uuidref.name() : __uuidref,
        __arcrole.name() : __arcrole,
        __role.name() : __role,
        __nilReason.name() : __nilReason,
        __title.name() : __title
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'CI_OnlineResource_PropertyType', CI_OnlineResource_PropertyType)


# Complex type DS_Platform_PropertyType with content type ELEMENT_ONLY
class DS_Platform_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'DS_Platform_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}DS_Platform uses Python identifier DS_Platform
    __DS_Platform = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'DS_Platform'), 'DS_Platform', '__httpwww_isotc211_org2005gmd_DS_Platform_PropertyType_httpwww_isotc211_org2005gmdDS_Platform', False)

    
    DS_Platform = property(__DS_Platform.value, __DS_Platform.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_DS_Platform_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_DS_Platform_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_DS_Platform_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_DS_Platform_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_DS_Platform_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_DS_Platform_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_DS_Platform_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_DS_Platform_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_DS_Platform_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)


    _ElementMap = {
        __DS_Platform.name() : __DS_Platform
    }
    _AttributeMap = {
        __type.name() : __type,
        __show.name() : __show,
        __href.name() : __href,
        __actuate.name() : __actuate,
        __uuidref.name() : __uuidref,
        __arcrole.name() : __arcrole,
        __role.name() : __role,
        __nilReason.name() : __nilReason,
        __title.name() : __title
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'DS_Platform_PropertyType', DS_Platform_PropertyType)


# Complex type MD_Constraints_PropertyType with content type ELEMENT_ONLY
class MD_Constraints_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_Constraints_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}MD_Constraints uses Python identifier MD_Constraints
    __MD_Constraints = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_Constraints'), 'MD_Constraints', '__httpwww_isotc211_org2005gmd_MD_Constraints_PropertyType_httpwww_isotc211_org2005gmdMD_Constraints', False)

    
    MD_Constraints = property(__MD_Constraints.value, __MD_Constraints.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_MD_Constraints_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_MD_Constraints_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_MD_Constraints_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_MD_Constraints_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_MD_Constraints_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_MD_Constraints_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_MD_Constraints_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_MD_Constraints_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_MD_Constraints_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)


    _ElementMap = {
        __MD_Constraints.name() : __MD_Constraints
    }
    _AttributeMap = {
        __type.name() : __type,
        __show.name() : __show,
        __href.name() : __href,
        __actuate.name() : __actuate,
        __uuidref.name() : __uuidref,
        __arcrole.name() : __arcrole,
        __role.name() : __role,
        __nilReason.name() : __nilReason,
        __title.name() : __title
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_Constraints_PropertyType', MD_Constraints_PropertyType)


# Complex type AbstractFeatureType with content type ELEMENT_ONLY
class AbstractFeatureType (AbstractGMLType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractFeatureType')
    # Base type is AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}boundedBy uses Python identifier boundedBy
    __boundedBy = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'boundedBy'), 'boundedBy', '__httpwww_opengis_netgml3_2_AbstractFeatureType_httpwww_opengis_netgml3_2boundedBy', False)

    
    boundedBy = property(__boundedBy.value, __boundedBy.set, None, u'This property describes the minimum bounding box or rectangle that encloses the entire feature.')

    
    # Element {http://www.opengis.net/gml/3.2}location uses Python identifier location
    __location = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'location'), 'location', '__httpwww_opengis_netgml3_2_AbstractFeatureType_httpwww_opengis_netgml3_2location', False)

    
    location = property(__location.value, __location.set, None, u'')

    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType

    _ElementMap = AbstractGMLType._ElementMap.copy()
    _ElementMap.update({
        __boundedBy.name() : __boundedBy,
        __location.name() : __location
    })
    _AttributeMap = AbstractGMLType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractFeatureType', AbstractFeatureType)


# Complex type BoundedFeatureType with content type ELEMENT_ONLY
class BoundedFeatureType (AbstractFeatureType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'BoundedFeatureType')
    # Base type is AbstractFeatureType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element location ({http://www.opengis.net/gml/3.2}location) inherited from {http://www.opengis.net/gml/3.2}AbstractFeatureType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element boundedBy ({http://www.opengis.net/gml/3.2}boundedBy) inherited from {http://www.opengis.net/gml/3.2}AbstractFeatureType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType

    _ElementMap = AbstractFeatureType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractFeatureType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'BoundedFeatureType', BoundedFeatureType)


# Complex type MD_DistributionUnits_PropertyType with content type ELEMENT_ONLY
class MD_DistributionUnits_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_DistributionUnits_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}MD_DistributionUnits uses Python identifier MD_DistributionUnits
    __MD_DistributionUnits = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_DistributionUnits'), 'MD_DistributionUnits', '__httpwww_isotc211_org2005gmd_MD_DistributionUnits_PropertyType_httpwww_isotc211_org2005gmdMD_DistributionUnits', False)

    
    MD_DistributionUnits = property(__MD_DistributionUnits.value, __MD_DistributionUnits.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_MD_DistributionUnits_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        __MD_DistributionUnits.name() : __MD_DistributionUnits
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_DistributionUnits_PropertyType', MD_DistributionUnits_PropertyType)


# Complex type ConversionPropertyType with content type ELEMENT_ONLY
class ConversionPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'ConversionPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}Conversion uses Python identifier Conversion
    __Conversion = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'Conversion'), 'Conversion', '__httpwww_opengis_netgml3_2_ConversionPropertyType_httpwww_opengis_netgml3_2Conversion', False)

    
    Conversion = property(__Conversion.value, __Conversion.set, None, u'gml:Conversion is a concrete operation on coordinates that does not include any change of Datum. The best-known example of a coordinate conversion is a map projection. The parameters describing coordinate conversions are defined rather than empirically derived. Note that some conversions have no parameters.\nThis concrete complex type can be used without using a GML Application Schema that defines operation-method-specialized element names and contents, especially for methods with only one Conversion instance.\nThe usesValue property elements are an unordered list of composition associations to the set of parameter values used by this conversion operation.')

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_ConversionPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_ConversionPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_ConversionPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_ConversionPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_ConversionPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_ConversionPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_ConversionPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_ConversionPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_ConversionPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)


    _ElementMap = {
        __Conversion.name() : __Conversion
    }
    _AttributeMap = {
        __remoteSchema.name() : __remoteSchema,
        __type.name() : __type,
        __show.name() : __show,
        __title.name() : __title,
        __arcrole.name() : __arcrole,
        __role.name() : __role,
        __nilReason.name() : __nilReason,
        __actuate.name() : __actuate,
        __href.name() : __href
    }
_Namespace_gml.addCategoryObject('typeBinding', u'ConversionPropertyType', ConversionPropertyType)


# Complex type TimeCSPropertyType with content type ELEMENT_ONLY
class TimeCSPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'TimeCSPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}TimeCS uses Python identifier TimeCS
    __TimeCS = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'TimeCS'), 'TimeCS', '__httpwww_opengis_netgml3_2_TimeCSPropertyType_httpwww_opengis_netgml3_2TimeCS', False)

    
    TimeCS = property(__TimeCS.value, __TimeCS.set, None, u'gml:TimeCS is a one-dimensional coordinate system containing a time axis, used to describe the temporal position of a point in the specified time units from a specified time origin. A TimeCS shall have one gml:axis property element.')

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_TimeCSPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_TimeCSPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_TimeCSPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_TimeCSPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_TimeCSPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_TimeCSPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_TimeCSPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_TimeCSPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_TimeCSPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)


    _ElementMap = {
        __TimeCS.name() : __TimeCS
    }
    _AttributeMap = {
        __arcrole.name() : __arcrole,
        __remoteSchema.name() : __remoteSchema,
        __role.name() : __role,
        __show.name() : __show,
        __actuate.name() : __actuate,
        __nilReason.name() : __nilReason,
        __href.name() : __href,
        __type.name() : __type,
        __title.name() : __title
    }
_Namespace_gml.addCategoryObject('typeBinding', u'TimeCSPropertyType', TimeCSPropertyType)


# Complex type AbstractTimeSliceType with content type ELEMENT_ONLY
class AbstractTimeSliceType (AbstractGMLType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractTimeSliceType')
    # Base type is AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}validTime uses Python identifier validTime
    __validTime = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'validTime'), 'validTime', '__httpwww_opengis_netgml3_2_AbstractTimeSliceType_httpwww_opengis_netgml3_2validTime', False)

    
    validTime = property(__validTime.value, __validTime.set, None, u'gml:validTime is a convenience property element.')

    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}dataSource uses Python identifier dataSource
    __dataSource = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'dataSource'), 'dataSource', '__httpwww_opengis_netgml3_2_AbstractTimeSliceType_httpwww_opengis_netgml3_2dataSource', False)

    
    dataSource = property(__dataSource.value, __dataSource.set, None, u'Evidence is represented by a simple gml:dataSource or gml:dataSourceReference property that indicates the source of the temporal data. The remote link attributes of the gml:dataSource element have been deprecated along with its current type.')

    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType

    _ElementMap = AbstractGMLType._ElementMap.copy()
    _ElementMap.update({
        __validTime.name() : __validTime,
        __dataSource.name() : __dataSource
    })
    _AttributeMap = AbstractGMLType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractTimeSliceType', AbstractTimeSliceType)


# Complex type AbstractTimeObjectType with content type ELEMENT_ONLY
class AbstractTimeObjectType (AbstractGMLType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractTimeObjectType')
    # Base type is AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType

    _ElementMap = AbstractGMLType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractGMLType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractTimeObjectType', AbstractTimeObjectType)


# Complex type AbstractTimePrimitiveType with content type ELEMENT_ONLY
class AbstractTimePrimitiveType (AbstractTimeObjectType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractTimePrimitiveType')
    # Base type is AbstractTimeObjectType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}relatedTime uses Python identifier relatedTime
    __relatedTime = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'relatedTime'), 'relatedTime', '__httpwww_opengis_netgml3_2_AbstractTimePrimitiveType_httpwww_opengis_netgml3_2relatedTime', True)

    
    relatedTime = property(__relatedTime.value, __relatedTime.set, None, None)

    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType

    _ElementMap = AbstractTimeObjectType._ElementMap.copy()
    _ElementMap.update({
        __relatedTime.name() : __relatedTime
    })
    _AttributeMap = AbstractTimeObjectType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractTimePrimitiveType', AbstractTimePrimitiveType)


# Complex type AbstractTimeGeometricPrimitiveType with content type ELEMENT_ONLY
class AbstractTimeGeometricPrimitiveType (AbstractTimePrimitiveType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractTimeGeometricPrimitiveType')
    # Base type is AbstractTimePrimitiveType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element relatedTime ({http://www.opengis.net/gml/3.2}relatedTime) inherited from {http://www.opengis.net/gml/3.2}AbstractTimePrimitiveType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute frame uses Python identifier frame
    __frame = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'frame'), 'frame', '__httpwww_opengis_netgml3_2_AbstractTimeGeometricPrimitiveType_frame', pyxb.binding.datatypes.anyURI, unicode_default=u'#ISO-8601')
    
    frame = property(__frame.value, __frame.set, None, None)

    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType

    _ElementMap = AbstractTimePrimitiveType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractTimePrimitiveType._AttributeMap.copy()
    _AttributeMap.update({
        __frame.name() : __frame
    })
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractTimeGeometricPrimitiveType', AbstractTimeGeometricPrimitiveType)


# Complex type TimeInstantType with content type ELEMENT_ONLY
class TimeInstantType (AbstractTimeGeometricPrimitiveType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'TimeInstantType')
    # Base type is AbstractTimeGeometricPrimitiveType
    
    # Element {http://www.opengis.net/gml/3.2}timePosition uses Python identifier timePosition
    __timePosition = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'timePosition'), 'timePosition', '__httpwww_opengis_netgml3_2_TimeInstantType_httpwww_opengis_netgml3_2timePosition', False)

    
    timePosition = property(__timePosition.value, __timePosition.set, None, u'This element is used directly as a property of gml:TimeInstant (see 15.2.2.3), and may also be used in application schemas.')

    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element relatedTime ({http://www.opengis.net/gml/3.2}relatedTime) inherited from {http://www.opengis.net/gml/3.2}AbstractTimePrimitiveType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute frame inherited from {http://www.opengis.net/gml/3.2}AbstractTimeGeometricPrimitiveType
    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType

    _ElementMap = AbstractTimeGeometricPrimitiveType._ElementMap.copy()
    _ElementMap.update({
        __timePosition.name() : __timePosition
    })
    _AttributeMap = AbstractTimeGeometricPrimitiveType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'TimeInstantType', TimeInstantType)


# Complex type CodeType with content type SIMPLE
class CodeType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = pyxb.binding.datatypes.string
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_SIMPLE
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'CodeType')
    # Base type is pyxb.binding.datatypes.string
    
    # Attribute codeSpace uses Python identifier codeSpace
    __codeSpace = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'codeSpace'), 'codeSpace', '__httpwww_opengis_netgml3_2_CodeType_codeSpace', pyxb.binding.datatypes.anyURI)
    
    codeSpace = property(__codeSpace.value, __codeSpace.set, None, None)


    _ElementMap = {
        
    }
    _AttributeMap = {
        __codeSpace.name() : __codeSpace
    }
_Namespace_gml.addCategoryObject('typeBinding', u'CodeType', CodeType)


# Complex type CodeWithAuthorityType with content type SIMPLE
class CodeWithAuthorityType (CodeType):
    _TypeDefinition = STD_ANON_8
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_SIMPLE
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'CodeWithAuthorityType')
    # Base type is CodeType
    
    # Attribute codeSpace is restricted from parent
    
    # Attribute codeSpace uses Python identifier codeSpace
    __codeSpace = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'codeSpace'), 'codeSpace', '__httpwww_opengis_netgml3_2_CodeType_codeSpace', pyxb.binding.datatypes.anyURI, required=True)
    
    codeSpace = property(__codeSpace.value, __codeSpace.set, None, None)


    _ElementMap = CodeType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = CodeType._AttributeMap.copy()
    _AttributeMap.update({
        __codeSpace.name() : __codeSpace
    })
_Namespace_gml.addCategoryObject('typeBinding', u'CodeWithAuthorityType', CodeWithAuthorityType)


# Complex type CI_RoleCode_PropertyType with content type ELEMENT_ONLY
class CI_RoleCode_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'CI_RoleCode_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}CI_RoleCode uses Python identifier CI_RoleCode
    __CI_RoleCode = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'CI_RoleCode'), 'CI_RoleCode', '__httpwww_isotc211_org2005gmd_CI_RoleCode_PropertyType_httpwww_isotc211_org2005gmdCI_RoleCode', False)

    
    CI_RoleCode = property(__CI_RoleCode.value, __CI_RoleCode.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_CI_RoleCode_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        __CI_RoleCode.name() : __CI_RoleCode
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'CI_RoleCode_PropertyType', CI_RoleCode_PropertyType)


# Complex type AbstractGeneralParameterValuePropertyType with content type ELEMENT_ONLY
class AbstractGeneralParameterValuePropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractGeneralParameterValuePropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}AbstractGeneralParameterValue uses Python identifier AbstractGeneralParameterValue
    __AbstractGeneralParameterValue = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractGeneralParameterValue'), 'AbstractGeneralParameterValue', '__httpwww_opengis_netgml3_2_AbstractGeneralParameterValuePropertyType_httpwww_opengis_netgml3_2AbstractGeneralParameterValue', False)

    
    AbstractGeneralParameterValue = property(__AbstractGeneralParameterValue.value, __AbstractGeneralParameterValue.set, None, u'gml:AbstractGeneralParameterValue is an abstract parameter value or group of parameter values.\nThis abstract complexType is expected to be extended and restricted for well-known operation methods with many instances, in Application Schemas that define operation-method-specialized element names and contents. Specific parameter value elements are directly contained in concrete subtypes, not in this abstract type. All concrete types derived from this type shall extend this type to include one "...Value" element with an appropriate type, which should be one of the element types allowed in the ParameterValueType. In addition, all derived concrete types shall extend this type to include a "operationParameter" property element that references one element substitutable for the "OperationParameter" object element.')


    _ElementMap = {
        __AbstractGeneralParameterValue.name() : __AbstractGeneralParameterValue
    }
    _AttributeMap = {
        
    }
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractGeneralParameterValuePropertyType', AbstractGeneralParameterValuePropertyType)


# Complex type CoverageFunctionType with content type ELEMENT_ONLY
class CoverageFunctionType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'CoverageFunctionType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}MappingRule uses Python identifier MappingRule
    __MappingRule = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'MappingRule'), 'MappingRule', '__httpwww_opengis_netgml3_2_CoverageFunctionType_httpwww_opengis_netgml3_2MappingRule', False)

    
    MappingRule = property(__MappingRule.value, __MappingRule.set, None, u'')

    
    # Element {http://www.opengis.net/gml/3.2}CoverageMappingRule uses Python identifier CoverageMappingRule
    __CoverageMappingRule = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'CoverageMappingRule'), 'CoverageMappingRule', '__httpwww_opengis_netgml3_2_CoverageFunctionType_httpwww_opengis_netgml3_2CoverageMappingRule', False)

    
    CoverageMappingRule = property(__CoverageMappingRule.value, __CoverageMappingRule.set, None, u"gml:CoverageMappingRule provides a formal or informal description of the coverage function.\nThe mapping rule may be defined as an in-line string (gml:ruleDefinition) or via a remote reference through xlink:href (gml:ruleReference).  \nIf no rule name is specified, the default is 'Linear' with respect to members of the domain in document order.")

    
    # Element {http://www.opengis.net/gml/3.2}GridFunction uses Python identifier GridFunction
    __GridFunction = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'GridFunction'), 'GridFunction', '__httpwww_opengis_netgml3_2_CoverageFunctionType_httpwww_opengis_netgml3_2GridFunction', False)

    
    GridFunction = property(__GridFunction.value, __GridFunction.set, None, u'gml:GridFunction provides an explicit mapping rule for grid geometries, i.e. the domain shall be a geometry of type grid.  It describes the mapping of grid posts (discrete point grid coverage) or grid cells (discrete surface coverage) to the values in the range set.\nThe gml:startPoint is the index position of a point in the grid that is mapped to the first point in the range set (this is also the index position of the first grid post).  If the gml:startPoint property is omitted the gml:startPoint is assumed to be equal to the value of gml:low in the gml:Grid geometry. Subsequent points in the mapping are determined by the value of the gml:sequenceRule.')


    _ElementMap = {
        __MappingRule.name() : __MappingRule,
        __CoverageMappingRule.name() : __CoverageMappingRule,
        __GridFunction.name() : __GridFunction
    }
    _AttributeMap = {
        
    }
_Namespace_gml.addCategoryObject('typeBinding', u'CoverageFunctionType', CoverageFunctionType)


# Complex type CodeOrNilReasonListType with content type SIMPLE
class CodeOrNilReasonListType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = NameOrNilReasonList
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_SIMPLE
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'CodeOrNilReasonListType')
    # Base type is NameOrNilReasonList
    
    # Attribute codeSpace uses Python identifier codeSpace
    __codeSpace = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'codeSpace'), 'codeSpace', '__httpwww_opengis_netgml3_2_CodeOrNilReasonListType_codeSpace', pyxb.binding.datatypes.anyURI)
    
    codeSpace = property(__codeSpace.value, __codeSpace.set, None, None)


    _ElementMap = {
        
    }
    _AttributeMap = {
        __codeSpace.name() : __codeSpace
    }
_Namespace_gml.addCategoryObject('typeBinding', u'CodeOrNilReasonListType', CodeOrNilReasonListType)


# Complex type AbstractCoordinateSystemType with content type ELEMENT_ONLY
class AbstractCoordinateSystemType (IdentifiedObjectType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractCoordinateSystemType')
    # Base type is IdentifiedObjectType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}axis uses Python identifier axis
    __axis = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'axis'), 'axis', '__httpwww_opengis_netgml3_2_AbstractCoordinateSystemType_httpwww_opengis_netgml3_2axis', True)

    
    axis = property(__axis.value, __axis.set, None, u'The gml:axis property is an association role (ordered sequence) to the coordinate system axes included in this coordinate system. The coordinate values in a coordinate tuple shall be recorded in the order in which the coordinate system axes associations are recorded, whenever those coordinates use a coordinate reference system that uses this coordinate system. The gml:AggregationAttributeGroup should be used to specify that the axis objects are ordered.')

    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Attribute aggregationType uses Python identifier aggregationType
    __aggregationType = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'aggregationType'), 'aggregationType', '__httpwww_opengis_netgml3_2_AbstractCoordinateSystemType_aggregationType', AggregationType)
    
    aggregationType = property(__aggregationType.value, __aggregationType.set, None, None)

    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType

    _ElementMap = IdentifiedObjectType._ElementMap.copy()
    _ElementMap.update({
        __axis.name() : __axis
    })
    _AttributeMap = IdentifiedObjectType._AttributeMap.copy()
    _AttributeMap.update({
        __aggregationType.name() : __aggregationType
    })
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractCoordinateSystemType', AbstractCoordinateSystemType)


# Complex type AffineCSType with content type ELEMENT_ONLY
class AffineCSType (AbstractCoordinateSystemType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AffineCSType')
    # Base type is AbstractCoordinateSystemType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element axis ({http://www.opengis.net/gml/3.2}axis) inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateSystemType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Attribute aggregationType inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateSystemType
    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType

    _ElementMap = AbstractCoordinateSystemType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractCoordinateSystemType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'AffineCSType', AffineCSType)


# Complex type PolarCSType with content type ELEMENT_ONLY
class PolarCSType (AbstractCoordinateSystemType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'PolarCSType')
    # Base type is AbstractCoordinateSystemType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element axis ({http://www.opengis.net/gml/3.2}axis) inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateSystemType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Attribute aggregationType inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateSystemType
    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType

    _ElementMap = AbstractCoordinateSystemType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractCoordinateSystemType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'PolarCSType', PolarCSType)


# Complex type TemporalCRSType with content type ELEMENT_ONLY
class TemporalCRSType (AbstractCRSType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'TemporalCRSType')
    # Base type is AbstractCRSType
    
    # Element {http://www.opengis.net/gml/3.2}temporalDatum uses Python identifier temporalDatum
    __temporalDatum = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'temporalDatum'), 'temporalDatum', '__httpwww_opengis_netgml3_2_TemporalCRSType_httpwww_opengis_netgml3_2temporalDatum', False)

    
    temporalDatum = property(__temporalDatum.value, __temporalDatum.set, None, u'gml:temporalDatum is an association role to the temporal datum used by this CRS.')

    
    # Element {http://www.opengis.net/gml/3.2}usesTemporalCS uses Python identifier usesTemporalCS
    __usesTemporalCS = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'usesTemporalCS'), 'usesTemporalCS', '__httpwww_opengis_netgml3_2_TemporalCRSType_httpwww_opengis_netgml3_2usesTemporalCS', False)

    
    usesTemporalCS = property(__usesTemporalCS.value, __usesTemporalCS.set, None, u'')

    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element domainOfValidity ({http://www.opengis.net/gml/3.2}domainOfValidity) inherited from {http://www.opengis.net/gml/3.2}AbstractCRSType
    
    # Element scope ({http://www.opengis.net/gml/3.2}scope) inherited from {http://www.opengis.net/gml/3.2}AbstractCRSType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}timeCS uses Python identifier timeCS
    __timeCS = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'timeCS'), 'timeCS', '__httpwww_opengis_netgml3_2_TemporalCRSType_httpwww_opengis_netgml3_2timeCS', False)

    
    timeCS = property(__timeCS.value, __timeCS.set, None, u'gml:timeCS is an association role to the time coordinate system used by this CRS.')

    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType

    _ElementMap = AbstractCRSType._ElementMap.copy()
    _ElementMap.update({
        __temporalDatum.name() : __temporalDatum,
        __usesTemporalCS.name() : __usesTemporalCS,
        __timeCS.name() : __timeCS
    })
    _AttributeMap = AbstractCRSType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'TemporalCRSType', TemporalCRSType)


# Complex type Country_PropertyType with content type ELEMENT_ONLY
class Country_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'Country_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}Country uses Python identifier Country
    __Country = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'Country'), 'Country', '__httpwww_isotc211_org2005gmd_Country_PropertyType_httpwww_isotc211_org2005gmdCountry', False)

    
    Country = property(__Country.value, __Country.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_Country_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        __Country.name() : __Country
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'Country_PropertyType', Country_PropertyType)


# Complex type MeasureType with content type SIMPLE
class MeasureType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = pyxb.binding.datatypes.double
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_SIMPLE
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'MeasureType')
    # Base type is pyxb.binding.datatypes.double
    
    # Attribute uom uses Python identifier uom
    __uom = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uom'), 'uom', '__httpwww_opengis_netgml3_2_MeasureType_uom', UomIdentifier, required=True)
    
    uom = property(__uom.value, __uom.set, None, None)


    _ElementMap = {
        
    }
    _AttributeMap = {
        __uom.name() : __uom
    }
_Namespace_gml.addCategoryObject('typeBinding', u'MeasureType', MeasureType)


# Complex type LocationPropertyType with content type ELEMENT_ONLY
class LocationPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'LocationPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}AbstractGeometry uses Python identifier AbstractGeometry
    __AbstractGeometry = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractGeometry'), 'AbstractGeometry', '__httpwww_opengis_netgml3_2_LocationPropertyType_httpwww_opengis_netgml3_2AbstractGeometry', False)

    
    AbstractGeometry = property(__AbstractGeometry.value, __AbstractGeometry.set, None, u'The AbstractGeometry element is the abstract head of the substitution group for all geometry elements of GML. This includes pre-defined and user-defined geometry elements. Any geometry element shall be a direct or indirect extension/restriction of AbstractGeometryType and shall be directly or indirectly in the substitution group of AbstractGeometry.')

    
    # Element {http://www.opengis.net/gml/3.2}LocationKeyWord uses Python identifier LocationKeyWord
    __LocationKeyWord = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'LocationKeyWord'), 'LocationKeyWord', '__httpwww_opengis_netgml3_2_LocationPropertyType_httpwww_opengis_netgml3_2LocationKeyWord', False)

    
    LocationKeyWord = property(__LocationKeyWord.value, __LocationKeyWord.set, None, u'')

    
    # Element {http://www.opengis.net/gml/3.2}Null uses Python identifier Null
    __Null = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'Null'), 'Null', '__httpwww_opengis_netgml3_2_LocationPropertyType_httpwww_opengis_netgml3_2Null', False)

    
    Null = property(__Null.value, __Null.set, None, u'')

    
    # Element {http://www.opengis.net/gml/3.2}LocationString uses Python identifier LocationString
    __LocationString = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'LocationString'), 'LocationString', '__httpwww_opengis_netgml3_2_LocationPropertyType_httpwww_opengis_netgml3_2LocationString', False)

    
    LocationString = property(__LocationString.value, __LocationString.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_LocationPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_LocationPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_LocationPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_LocationPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_LocationPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_LocationPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_LocationPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_LocationPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_LocationPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")


    _ElementMap = {
        __AbstractGeometry.name() : __AbstractGeometry,
        __LocationKeyWord.name() : __LocationKeyWord,
        __Null.name() : __Null,
        __LocationString.name() : __LocationString
    }
    _AttributeMap = {
        __actuate.name() : __actuate,
        __remoteSchema.name() : __remoteSchema,
        __href.name() : __href,
        __type.name() : __type,
        __title.name() : __title,
        __nilReason.name() : __nilReason,
        __arcrole.name() : __arcrole,
        __role.name() : __role,
        __show.name() : __show
    }
_Namespace_gml.addCategoryObject('typeBinding', u'LocationPropertyType', LocationPropertyType)


# Complex type PriorityLocationPropertyType with content type ELEMENT_ONLY
class PriorityLocationPropertyType (LocationPropertyType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'PriorityLocationPropertyType')
    # Base type is LocationPropertyType
    
    # Element AbstractGeometry ({http://www.opengis.net/gml/3.2}AbstractGeometry) inherited from {http://www.opengis.net/gml/3.2}LocationPropertyType
    
    # Element LocationKeyWord ({http://www.opengis.net/gml/3.2}LocationKeyWord) inherited from {http://www.opengis.net/gml/3.2}LocationPropertyType
    
    # Element Null ({http://www.opengis.net/gml/3.2}Null) inherited from {http://www.opengis.net/gml/3.2}LocationPropertyType
    
    # Element LocationString ({http://www.opengis.net/gml/3.2}LocationString) inherited from {http://www.opengis.net/gml/3.2}LocationPropertyType
    
    # Attribute actuate inherited from {http://www.opengis.net/gml/3.2}LocationPropertyType
    
    # Attribute remoteSchema inherited from {http://www.opengis.net/gml/3.2}LocationPropertyType
    
    # Attribute priority uses Python identifier priority
    __priority = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'priority'), 'priority', '__httpwww_opengis_netgml3_2_PriorityLocationPropertyType_priority', pyxb.binding.datatypes.string)
    
    priority = property(__priority.value, __priority.set, None, None)

    
    # Attribute href inherited from {http://www.opengis.net/gml/3.2}LocationPropertyType
    
    # Attribute type inherited from {http://www.opengis.net/gml/3.2}LocationPropertyType
    
    # Attribute title inherited from {http://www.opengis.net/gml/3.2}LocationPropertyType
    
    # Attribute nilReason inherited from {http://www.opengis.net/gml/3.2}LocationPropertyType
    
    # Attribute arcrole inherited from {http://www.opengis.net/gml/3.2}LocationPropertyType
    
    # Attribute role inherited from {http://www.opengis.net/gml/3.2}LocationPropertyType
    
    # Attribute show inherited from {http://www.opengis.net/gml/3.2}LocationPropertyType

    _ElementMap = LocationPropertyType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = LocationPropertyType._AttributeMap.copy()
    _AttributeMap.update({
        __priority.name() : __priority
    })
_Namespace_gml.addCategoryObject('typeBinding', u'PriorityLocationPropertyType', PriorityLocationPropertyType)


# Complex type BoundingShapeType with content type ELEMENT_ONLY
class BoundingShapeType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'BoundingShapeType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}Envelope uses Python identifier Envelope
    __Envelope = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'Envelope'), 'Envelope', '__httpwww_opengis_netgml3_2_BoundingShapeType_httpwww_opengis_netgml3_2Envelope', False)

    
    Envelope = property(__Envelope.value, __Envelope.set, None, u'Envelope defines an extent using a pair of positions defining opposite corners in arbitrary dimensions. The first direct position is the "lower corner" (a coordinate position consisting of all the minimal ordinates for each dimension for all points within the envelope), the second one the "upper corner" (a coordinate position consisting of all the maximal ordinates for each dimension for all points within the envelope).\nThe use of the properties "coordinates" and "pos" has been deprecated. The explicitly named properties "lowerCorner" and "upperCorner" shall be used instead.')

    
    # Element {http://www.opengis.net/gml/3.2}Null uses Python identifier Null
    __Null = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'Null'), 'Null', '__httpwww_opengis_netgml3_2_BoundingShapeType_httpwww_opengis_netgml3_2Null', False)

    
    Null = property(__Null.value, __Null.set, None, u'')

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_BoundingShapeType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        __Envelope.name() : __Envelope,
        __Null.name() : __Null
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason
    }
_Namespace_gml.addCategoryObject('typeBinding', u'BoundingShapeType', BoundingShapeType)


# Complex type AbstractRingPropertyType with content type ELEMENT_ONLY
class AbstractRingPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractRingPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}AbstractRing uses Python identifier AbstractRing
    __AbstractRing = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractRing'), 'AbstractRing', '__httpwww_opengis_netgml3_2_AbstractRingPropertyType_httpwww_opengis_netgml3_2AbstractRing', False)

    
    AbstractRing = property(__AbstractRing.value, __AbstractRing.set, None, u'An abstraction of a ring to support surface boundaries of different complexity.\nThe AbstractRing element is the abstract head of the substituition group for all closed boundaries of a surface patch.')


    _ElementMap = {
        __AbstractRing.name() : __AbstractRing
    }
    _AttributeMap = {
        
    }
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractRingPropertyType', AbstractRingPropertyType)


# Complex type DS_InitiativeTypeCode_PropertyType with content type ELEMENT_ONLY
class DS_InitiativeTypeCode_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'DS_InitiativeTypeCode_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}DS_InitiativeTypeCode uses Python identifier DS_InitiativeTypeCode
    __DS_InitiativeTypeCode = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'DS_InitiativeTypeCode'), 'DS_InitiativeTypeCode', '__httpwww_isotc211_org2005gmd_DS_InitiativeTypeCode_PropertyType_httpwww_isotc211_org2005gmdDS_InitiativeTypeCode', False)

    
    DS_InitiativeTypeCode = property(__DS_InitiativeTypeCode.value, __DS_InitiativeTypeCode.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_DS_InitiativeTypeCode_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        __DS_InitiativeTypeCode.name() : __DS_InitiativeTypeCode
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'DS_InitiativeTypeCode_PropertyType', DS_InitiativeTypeCode_PropertyType)


# Complex type MultiSurfacePropertyType with content type ELEMENT_ONLY
class MultiSurfacePropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'MultiSurfacePropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}MultiSurface uses Python identifier MultiSurface
    __MultiSurface = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'MultiSurface'), 'MultiSurface', '__httpwww_opengis_netgml3_2_MultiSurfacePropertyType_httpwww_opengis_netgml3_2MultiSurface', False)

    
    MultiSurface = property(__MultiSurface.value, __MultiSurface.set, None, u'A gml:MultiSurface is defined by one or more gml:AbstractSurfaces.\nThe members of the geometric aggregate may be specified either using the "standard" property (gml:surfaceMember) or the array property (gml:surfaceMembers). It is also valid to use both the "standard" and the array properties in the same collection.')

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_MultiSurfacePropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_MultiSurfacePropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_MultiSurfacePropertyType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_MultiSurfacePropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_MultiSurfacePropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_MultiSurfacePropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_MultiSurfacePropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_MultiSurfacePropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_MultiSurfacePropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_MultiSurfacePropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')


    _ElementMap = {
        __MultiSurface.name() : __MultiSurface
    }
    _AttributeMap = {
        __role.name() : __role,
        __show.name() : __show,
        __owns.name() : __owns,
        __actuate.name() : __actuate,
        __nilReason.name() : __nilReason,
        __arcrole.name() : __arcrole,
        __type.name() : __type,
        __href.name() : __href,
        __title.name() : __title,
        __remoteSchema.name() : __remoteSchema
    }
_Namespace_gml.addCategoryObject('typeBinding', u'MultiSurfacePropertyType', MultiSurfacePropertyType)


# Complex type CI_Citation_Type with content type ELEMENT_ONLY
class CI_Citation_Type (AbstractObject_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'CI_Citation_Type')
    # Base type is AbstractObject_Type
    
    # Element {http://www.isotc211.org/2005/gmd}series uses Python identifier series
    __series = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'series'), 'series', '__httpwww_isotc211_org2005gmd_CI_Citation_Type_httpwww_isotc211_org2005gmdseries', False)

    
    series = property(__series.value, __series.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}date uses Python identifier date
    __date = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'date'), 'date', '__httpwww_isotc211_org2005gmd_CI_Citation_Type_httpwww_isotc211_org2005gmddate', True)

    
    date = property(__date.value, __date.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}alternateTitle uses Python identifier alternateTitle
    __alternateTitle = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'alternateTitle'), 'alternateTitle', '__httpwww_isotc211_org2005gmd_CI_Citation_Type_httpwww_isotc211_org2005gmdalternateTitle', True)

    
    alternateTitle = property(__alternateTitle.value, __alternateTitle.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}collectiveTitle uses Python identifier collectiveTitle
    __collectiveTitle = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'collectiveTitle'), 'collectiveTitle', '__httpwww_isotc211_org2005gmd_CI_Citation_Type_httpwww_isotc211_org2005gmdcollectiveTitle', False)

    
    collectiveTitle = property(__collectiveTitle.value, __collectiveTitle.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}edition uses Python identifier edition
    __edition = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'edition'), 'edition', '__httpwww_isotc211_org2005gmd_CI_Citation_Type_httpwww_isotc211_org2005gmdedition', False)

    
    edition = property(__edition.value, __edition.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}title uses Python identifier title
    __title = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'title'), 'title', '__httpwww_isotc211_org2005gmd_CI_Citation_Type_httpwww_isotc211_org2005gmdtitle', False)

    
    title = property(__title.value, __title.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}editionDate uses Python identifier editionDate
    __editionDate = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'editionDate'), 'editionDate', '__httpwww_isotc211_org2005gmd_CI_Citation_Type_httpwww_isotc211_org2005gmdeditionDate', False)

    
    editionDate = property(__editionDate.value, __editionDate.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}ISSN uses Python identifier ISSN
    __ISSN = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'ISSN'), 'ISSN', '__httpwww_isotc211_org2005gmd_CI_Citation_Type_httpwww_isotc211_org2005gmdISSN', False)

    
    ISSN = property(__ISSN.value, __ISSN.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}identifier uses Python identifier identifier
    __identifier = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'identifier'), 'identifier', '__httpwww_isotc211_org2005gmd_CI_Citation_Type_httpwww_isotc211_org2005gmdidentifier', True)

    
    identifier = property(__identifier.value, __identifier.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}otherCitationDetails uses Python identifier otherCitationDetails
    __otherCitationDetails = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'otherCitationDetails'), 'otherCitationDetails', '__httpwww_isotc211_org2005gmd_CI_Citation_Type_httpwww_isotc211_org2005gmdotherCitationDetails', False)

    
    otherCitationDetails = property(__otherCitationDetails.value, __otherCitationDetails.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}citedResponsibleParty uses Python identifier citedResponsibleParty
    __citedResponsibleParty = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'citedResponsibleParty'), 'citedResponsibleParty', '__httpwww_isotc211_org2005gmd_CI_Citation_Type_httpwww_isotc211_org2005gmdcitedResponsibleParty', True)

    
    citedResponsibleParty = property(__citedResponsibleParty.value, __citedResponsibleParty.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}presentationForm uses Python identifier presentationForm
    __presentationForm = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'presentationForm'), 'presentationForm', '__httpwww_isotc211_org2005gmd_CI_Citation_Type_httpwww_isotc211_org2005gmdpresentationForm', True)

    
    presentationForm = property(__presentationForm.value, __presentationForm.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}ISBN uses Python identifier ISBN
    __ISBN = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'ISBN'), 'ISBN', '__httpwww_isotc211_org2005gmd_CI_Citation_Type_httpwww_isotc211_org2005gmdISBN', False)

    
    ISBN = property(__ISBN.value, __ISBN.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractObject_Type._ElementMap.copy()
    _ElementMap.update({
        __series.name() : __series,
        __date.name() : __date,
        __alternateTitle.name() : __alternateTitle,
        __collectiveTitle.name() : __collectiveTitle,
        __edition.name() : __edition,
        __title.name() : __title,
        __editionDate.name() : __editionDate,
        __ISSN.name() : __ISSN,
        __identifier.name() : __identifier,
        __otherCitationDetails.name() : __otherCitationDetails,
        __citedResponsibleParty.name() : __citedResponsibleParty,
        __presentationForm.name() : __presentationForm,
        __ISBN.name() : __ISBN
    })
    _AttributeMap = AbstractObject_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'CI_Citation_Type', CI_Citation_Type)


# Complex type CTD_ANON_1 with content type ELEMENT_ONLY
class CTD_ANON_1 (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = None
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}EX_Extent uses Python identifier EX_Extent
    __EX_Extent = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'EX_Extent'), 'EX_Extent', '__httpwww_opengis_netgml3_2_CTD_ANON_1_httpwww_isotc211_org2005gmdEX_Extent', False)

    
    EX_Extent = property(__EX_Extent.value, __EX_Extent.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_CTD_ANON_1_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_CTD_ANON_1_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_CTD_ANON_1_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_CTD_ANON_1_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_CTD_ANON_1_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_CTD_ANON_1_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_CTD_ANON_1_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_CTD_ANON_1_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_CTD_ANON_1_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)


    _ElementMap = {
        __EX_Extent.name() : __EX_Extent
    }
    _AttributeMap = {
        __title.name() : __title,
        __role.name() : __role,
        __arcrole.name() : __arcrole,
        __remoteSchema.name() : __remoteSchema,
        __show.name() : __show,
        __nilReason.name() : __nilReason,
        __actuate.name() : __actuate,
        __href.name() : __href,
        __type.name() : __type
    }



# Complex type ScopedName_PropertyType with content type ELEMENT_ONLY
class ScopedName_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gco, u'ScopedName_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gco}ScopedName uses Python identifier ScopedName
    __ScopedName = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'ScopedName'), 'ScopedName', '__httpwww_isotc211_org2005gco_ScopedName_PropertyType_httpwww_isotc211_org2005gcoScopedName', False)

    
    ScopedName = property(__ScopedName.value, __ScopedName.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gco_ScopedName_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        __ScopedName.name() : __ScopedName
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason
    }
_Namespace_gco.addCategoryObject('typeBinding', u'ScopedName_PropertyType', ScopedName_PropertyType)


# Complex type MD_ScopeCode_PropertyType with content type ELEMENT_ONLY
class MD_ScopeCode_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_ScopeCode_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}MD_ScopeCode uses Python identifier MD_ScopeCode
    __MD_ScopeCode = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_ScopeCode'), 'MD_ScopeCode', '__httpwww_isotc211_org2005gmd_MD_ScopeCode_PropertyType_httpwww_isotc211_org2005gmdMD_ScopeCode', False)

    
    MD_ScopeCode = property(__MD_ScopeCode.value, __MD_ScopeCode.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_MD_ScopeCode_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        __MD_ScopeCode.name() : __MD_ScopeCode
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_ScopeCode_PropertyType', MD_ScopeCode_PropertyType)


# Complex type NodeType with content type ELEMENT_ONLY
class NodeType (AbstractTopoPrimitiveType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'NodeType')
    # Base type is AbstractTopoPrimitiveType
    
    # Element {http://www.opengis.net/gml/3.2}pointProperty uses Python identifier pointProperty
    __pointProperty = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'pointProperty'), 'pointProperty', '__httpwww_opengis_netgml3_2_NodeType_httpwww_opengis_netgml3_2pointProperty', False)

    
    pointProperty = property(__pointProperty.value, __pointProperty.set, None, u'This property element either references a point via the XLink-attributes or contains the point element. pointProperty is the predefined property which may be used by GML Application Schemas whenever a GML feature has a property with a value that is substitutable for Point.')

    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}container uses Python identifier container
    __container = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'container'), 'container', '__httpwww_opengis_netgml3_2_NodeType_httpwww_opengis_netgml3_2container', False)

    
    container = property(__container.value, __container.set, None, None)

    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}directedEdge uses Python identifier directedEdge
    __directedEdge = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'directedEdge'), 'directedEdge', '__httpwww_opengis_netgml3_2_NodeType_httpwww_opengis_netgml3_2directedEdge', True)

    
    directedEdge = property(__directedEdge.value, __directedEdge.set, None, u'A gml:directedEdge property element describes the boundary of topology faces, the coBoundary of topology nodes and is used in the support of topological line features via the gml:TopoCurve expression, see below. The orientation attribute of type gml:SignType expresses the sense in which the included edge is used, i.e. forward or reverse.')

    
    # Attribute aggregationType uses Python identifier aggregationType
    __aggregationType = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'aggregationType'), 'aggregationType', '__httpwww_opengis_netgml3_2_NodeType_aggregationType', AggregationType)
    
    aggregationType = property(__aggregationType.value, __aggregationType.set, None, None)

    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType

    _ElementMap = AbstractTopoPrimitiveType._ElementMap.copy()
    _ElementMap.update({
        __pointProperty.name() : __pointProperty,
        __container.name() : __container,
        __directedEdge.name() : __directedEdge
    })
    _AttributeMap = AbstractTopoPrimitiveType._AttributeMap.copy()
    _AttributeMap.update({
        __aggregationType.name() : __aggregationType
    })
_Namespace_gml.addCategoryObject('typeBinding', u'NodeType', NodeType)


# Complex type CodeListValue_Type with content type SIMPLE
class CodeListValue_Type (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = pyxb.binding.datatypes.string
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_SIMPLE
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gco, u'CodeListValue_Type')
    # Base type is pyxb.binding.datatypes.string
    
    # Attribute codeList uses Python identifier codeList
    __codeList = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'codeList'), 'codeList', '__httpwww_isotc211_org2005gco_CodeListValue_Type_codeList', pyxb.binding.datatypes.anyURI, required=True)
    
    codeList = property(__codeList.value, __codeList.set, None, None)

    
    # Attribute codeSpace uses Python identifier codeSpace
    __codeSpace = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'codeSpace'), 'codeSpace', '__httpwww_isotc211_org2005gco_CodeListValue_Type_codeSpace', pyxb.binding.datatypes.anyURI)
    
    codeSpace = property(__codeSpace.value, __codeSpace.set, None, None)

    
    # Attribute codeListValue uses Python identifier codeListValue
    __codeListValue = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'codeListValue'), 'codeListValue', '__httpwww_isotc211_org2005gco_CodeListValue_Type_codeListValue', pyxb.binding.datatypes.anyURI, required=True)
    
    codeListValue = property(__codeListValue.value, __codeListValue.set, None, None)


    _ElementMap = {
        
    }
    _AttributeMap = {
        __codeList.name() : __codeList,
        __codeSpace.name() : __codeSpace,
        __codeListValue.name() : __codeListValue
    }
_Namespace_gco.addCategoryObject('typeBinding', u'CodeListValue_Type', CodeListValue_Type)


# Complex type CI_DateTypeCode_PropertyType with content type ELEMENT_ONLY
class CI_DateTypeCode_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'CI_DateTypeCode_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}CI_DateTypeCode uses Python identifier CI_DateTypeCode
    __CI_DateTypeCode = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'CI_DateTypeCode'), 'CI_DateTypeCode', '__httpwww_isotc211_org2005gmd_CI_DateTypeCode_PropertyType_httpwww_isotc211_org2005gmdCI_DateTypeCode', False)

    
    CI_DateTypeCode = property(__CI_DateTypeCode.value, __CI_DateTypeCode.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_CI_DateTypeCode_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        __CI_DateTypeCode.name() : __CI_DateTypeCode
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'CI_DateTypeCode_PropertyType', CI_DateTypeCode_PropertyType)


# Complex type AbstractCurveSegmentType with content type EMPTY
class AbstractCurveSegmentType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_EMPTY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractCurveSegmentType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Attribute numDerivativesAtEnd uses Python identifier numDerivativesAtEnd
    __numDerivativesAtEnd = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'numDerivativesAtEnd'), 'numDerivativesAtEnd', '__httpwww_opengis_netgml3_2_AbstractCurveSegmentType_numDerivativesAtEnd', pyxb.binding.datatypes.integer, unicode_default=u'0')
    
    numDerivativesAtEnd = property(__numDerivativesAtEnd.value, __numDerivativesAtEnd.set, None, None)

    
    # Attribute numDerivativeInterior uses Python identifier numDerivativeInterior
    __numDerivativeInterior = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'numDerivativeInterior'), 'numDerivativeInterior', '__httpwww_opengis_netgml3_2_AbstractCurveSegmentType_numDerivativeInterior', pyxb.binding.datatypes.integer, unicode_default=u'0')
    
    numDerivativeInterior = property(__numDerivativeInterior.value, __numDerivativeInterior.set, None, None)

    
    # Attribute numDerivativesAtStart uses Python identifier numDerivativesAtStart
    __numDerivativesAtStart = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'numDerivativesAtStart'), 'numDerivativesAtStart', '__httpwww_opengis_netgml3_2_AbstractCurveSegmentType_numDerivativesAtStart', pyxb.binding.datatypes.integer, unicode_default=u'0')
    
    numDerivativesAtStart = property(__numDerivativesAtStart.value, __numDerivativesAtStart.set, None, None)


    _ElementMap = {
        
    }
    _AttributeMap = {
        __numDerivativesAtEnd.name() : __numDerivativesAtEnd,
        __numDerivativeInterior.name() : __numDerivativeInterior,
        __numDerivativesAtStart.name() : __numDerivativesAtStart
    }
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractCurveSegmentType', AbstractCurveSegmentType)


# Complex type OffsetCurveType with content type ELEMENT_ONLY
class OffsetCurveType (AbstractCurveSegmentType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'OffsetCurveType')
    # Base type is AbstractCurveSegmentType
    
    # Element {http://www.opengis.net/gml/3.2}refDirection uses Python identifier refDirection
    __refDirection = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'refDirection'), 'refDirection', '__httpwww_opengis_netgml3_2_OffsetCurveType_httpwww_opengis_netgml3_2refDirection', False)

    
    refDirection = property(__refDirection.value, __refDirection.set, None, None)

    
    # Element {http://www.opengis.net/gml/3.2}offsetBase uses Python identifier offsetBase
    __offsetBase = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'offsetBase'), 'offsetBase', '__httpwww_opengis_netgml3_2_OffsetCurveType_httpwww_opengis_netgml3_2offsetBase', False)

    
    offsetBase = property(__offsetBase.value, __offsetBase.set, None, None)

    
    # Element {http://www.opengis.net/gml/3.2}distance uses Python identifier distance
    __distance = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'distance'), 'distance', '__httpwww_opengis_netgml3_2_OffsetCurveType_httpwww_opengis_netgml3_2distance', False)

    
    distance = property(__distance.value, __distance.set, None, None)

    
    # Attribute numDerivativesAtEnd inherited from {http://www.opengis.net/gml/3.2}AbstractCurveSegmentType
    
    # Attribute numDerivativesAtStart inherited from {http://www.opengis.net/gml/3.2}AbstractCurveSegmentType
    
    # Attribute numDerivativeInterior inherited from {http://www.opengis.net/gml/3.2}AbstractCurveSegmentType

    _ElementMap = AbstractCurveSegmentType._ElementMap.copy()
    _ElementMap.update({
        __refDirection.name() : __refDirection,
        __offsetBase.name() : __offsetBase,
        __distance.name() : __distance
    })
    _AttributeMap = AbstractCurveSegmentType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'OffsetCurveType', OffsetCurveType)


# Complex type AbstractCoverageType with content type ELEMENT_ONLY
class AbstractCoverageType (AbstractFeatureType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractCoverageType')
    # Base type is AbstractFeatureType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element boundedBy ({http://www.opengis.net/gml/3.2}boundedBy) inherited from {http://www.opengis.net/gml/3.2}AbstractFeatureType
    
    # Element location ({http://www.opengis.net/gml/3.2}location) inherited from {http://www.opengis.net/gml/3.2}AbstractFeatureType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}domainSet uses Python identifier domainSet
    __domainSet = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'domainSet'), 'domainSet', '__httpwww_opengis_netgml3_2_AbstractCoverageType_httpwww_opengis_netgml3_2domainSet', False)

    
    domainSet = property(__domainSet.value, __domainSet.set, None, u'The gml:domainSet property element describes the spatio-temporal region of interest, within which the coverage is defined. Its content model is given by gml:DomainSetType.\nThe value of the domain is thus a choice between a gml:AbstractGeometry and a gml:AbstractTimeObject.  In the instance these abstract elements will normally be substituted by a geometry complex or temporal complex, to represent spatial coverages and time-series, respectively.  \nThe presence of the gml:AssociationAttributeGroup means that domainSet follows the usual GML property model and may use the xlink:href attribute to point to the domain, as an alternative to describing the domain inline. Ownership semantics may be provided using the gml:OwnershipAttributeGroup.\n')

    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}rangeSet uses Python identifier rangeSet
    __rangeSet = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'rangeSet'), 'rangeSet', '__httpwww_opengis_netgml3_2_AbstractCoverageType_httpwww_opengis_netgml3_2rangeSet', False)

    
    rangeSet = property(__rangeSet.value, __rangeSet.set, None, u'The gml:rangeSet property element contains the values of the coverage (sometimes called the attribute values).  Its content model is given by gml:RangeSetType.\nThis content model supports a structural description of the range.  The semantic information describing the range set is embedded using a uniform method, as part of the explicit values, or as a template value accompanying the representation using gml:DataBlock and gml:File.\nThe values from each component (or "band") in the range may be encoded within a gml:ValueArray element or a concrete member of the gml:AbstractScalarValueList substitution group . Use of these elements satisfies the value-type homogeneity requirement.')

    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType

    _ElementMap = AbstractFeatureType._ElementMap.copy()
    _ElementMap.update({
        __domainSet.name() : __domainSet,
        __rangeSet.name() : __rangeSet
    })
    _AttributeMap = AbstractFeatureType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractCoverageType', AbstractCoverageType)


# Complex type AbstractContinuousCoverageType with content type ELEMENT_ONLY
class AbstractContinuousCoverageType (AbstractCoverageType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractContinuousCoverageType')
    # Base type is AbstractCoverageType
    
    # Element rangeSet ({http://www.opengis.net/gml/3.2}rangeSet) inherited from {http://www.opengis.net/gml/3.2}AbstractCoverageType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element boundedBy ({http://www.opengis.net/gml/3.2}boundedBy) inherited from {http://www.opengis.net/gml/3.2}AbstractFeatureType
    
    # Element location ({http://www.opengis.net/gml/3.2}location) inherited from {http://www.opengis.net/gml/3.2}AbstractFeatureType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element domainSet ({http://www.opengis.net/gml/3.2}domainSet) inherited from {http://www.opengis.net/gml/3.2}AbstractCoverageType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}coverageFunction uses Python identifier coverageFunction
    __coverageFunction = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'coverageFunction'), 'coverageFunction', '__httpwww_opengis_netgml3_2_AbstractContinuousCoverageType_httpwww_opengis_netgml3_2coverageFunction', False)

    
    coverageFunction = property(__coverageFunction.value, __coverageFunction.set, None, u'The gml:coverageFunction property describes the mapping function from the domain to the range of the coverage.\nThe value of the CoverageFunction is one of gml:CoverageMappingRule and gml:GridFunction.\nIf the gml:coverageFunction property is omitted for a gridded coverage (including rectified gridded coverages) the gml:startPoint is assumed to be the value of the gml:low property in the gml:Grid geometry, and the gml:sequenceRule is assumed to be linear and the gml:axisOrder property is assumed to be "+1 +2".')

    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType

    _ElementMap = AbstractCoverageType._ElementMap.copy()
    _ElementMap.update({
        __coverageFunction.name() : __coverageFunction
    })
    _AttributeMap = AbstractCoverageType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractContinuousCoverageType', AbstractContinuousCoverageType)


# Complex type AbstractDQ_Element_Type with content type ELEMENT_ONLY
class AbstractDQ_Element_Type (AbstractObject_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'AbstractDQ_Element_Type')
    # Base type is AbstractObject_Type
    
    # Element {http://www.isotc211.org/2005/gmd}evaluationMethodDescription uses Python identifier evaluationMethodDescription
    __evaluationMethodDescription = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'evaluationMethodDescription'), 'evaluationMethodDescription', '__httpwww_isotc211_org2005gmd_AbstractDQ_Element_Type_httpwww_isotc211_org2005gmdevaluationMethodDescription', False)

    
    evaluationMethodDescription = property(__evaluationMethodDescription.value, __evaluationMethodDescription.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}measureDescription uses Python identifier measureDescription
    __measureDescription = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'measureDescription'), 'measureDescription', '__httpwww_isotc211_org2005gmd_AbstractDQ_Element_Type_httpwww_isotc211_org2005gmdmeasureDescription', False)

    
    measureDescription = property(__measureDescription.value, __measureDescription.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}evaluationProcedure uses Python identifier evaluationProcedure
    __evaluationProcedure = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'evaluationProcedure'), 'evaluationProcedure', '__httpwww_isotc211_org2005gmd_AbstractDQ_Element_Type_httpwww_isotc211_org2005gmdevaluationProcedure', False)

    
    evaluationProcedure = property(__evaluationProcedure.value, __evaluationProcedure.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}evaluationMethodType uses Python identifier evaluationMethodType
    __evaluationMethodType = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'evaluationMethodType'), 'evaluationMethodType', '__httpwww_isotc211_org2005gmd_AbstractDQ_Element_Type_httpwww_isotc211_org2005gmdevaluationMethodType', False)

    
    evaluationMethodType = property(__evaluationMethodType.value, __evaluationMethodType.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}dateTime uses Python identifier dateTime
    __dateTime = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'dateTime'), 'dateTime', '__httpwww_isotc211_org2005gmd_AbstractDQ_Element_Type_httpwww_isotc211_org2005gmddateTime', True)

    
    dateTime = property(__dateTime.value, __dateTime.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}result uses Python identifier result
    __result = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'result'), 'result', '__httpwww_isotc211_org2005gmd_AbstractDQ_Element_Type_httpwww_isotc211_org2005gmdresult', True)

    
    result = property(__result.value, __result.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}nameOfMeasure uses Python identifier nameOfMeasure
    __nameOfMeasure = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'nameOfMeasure'), 'nameOfMeasure', '__httpwww_isotc211_org2005gmd_AbstractDQ_Element_Type_httpwww_isotc211_org2005gmdnameOfMeasure', True)

    
    nameOfMeasure = property(__nameOfMeasure.value, __nameOfMeasure.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}measureIdentification uses Python identifier measureIdentification
    __measureIdentification = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'measureIdentification'), 'measureIdentification', '__httpwww_isotc211_org2005gmd_AbstractDQ_Element_Type_httpwww_isotc211_org2005gmdmeasureIdentification', False)

    
    measureIdentification = property(__measureIdentification.value, __measureIdentification.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractObject_Type._ElementMap.copy()
    _ElementMap.update({
        __evaluationMethodDescription.name() : __evaluationMethodDescription,
        __measureDescription.name() : __measureDescription,
        __evaluationProcedure.name() : __evaluationProcedure,
        __evaluationMethodType.name() : __evaluationMethodType,
        __dateTime.name() : __dateTime,
        __result.name() : __result,
        __nameOfMeasure.name() : __nameOfMeasure,
        __measureIdentification.name() : __measureIdentification
    })
    _AttributeMap = AbstractObject_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'AbstractDQ_Element_Type', AbstractDQ_Element_Type)


# Complex type AbstractDQ_TemporalAccuracy_Type with content type ELEMENT_ONLY
class AbstractDQ_TemporalAccuracy_Type (AbstractDQ_Element_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'AbstractDQ_TemporalAccuracy_Type')
    # Base type is AbstractDQ_Element_Type
    
    # Element evaluationMethodDescription ({http://www.isotc211.org/2005/gmd}evaluationMethodDescription) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element measureDescription ({http://www.isotc211.org/2005/gmd}measureDescription) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element evaluationProcedure ({http://www.isotc211.org/2005/gmd}evaluationProcedure) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element evaluationMethodType ({http://www.isotc211.org/2005/gmd}evaluationMethodType) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element dateTime ({http://www.isotc211.org/2005/gmd}dateTime) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element result ({http://www.isotc211.org/2005/gmd}result) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element nameOfMeasure ({http://www.isotc211.org/2005/gmd}nameOfMeasure) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element measureIdentification ({http://www.isotc211.org/2005/gmd}measureIdentification) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractDQ_Element_Type._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractDQ_Element_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'AbstractDQ_TemporalAccuracy_Type', AbstractDQ_TemporalAccuracy_Type)


# Complex type DQ_TemporalConsistency_Type with content type ELEMENT_ONLY
class DQ_TemporalConsistency_Type (AbstractDQ_TemporalAccuracy_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'DQ_TemporalConsistency_Type')
    # Base type is AbstractDQ_TemporalAccuracy_Type
    
    # Element evaluationMethodDescription ({http://www.isotc211.org/2005/gmd}evaluationMethodDescription) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element measureDescription ({http://www.isotc211.org/2005/gmd}measureDescription) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element evaluationProcedure ({http://www.isotc211.org/2005/gmd}evaluationProcedure) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element evaluationMethodType ({http://www.isotc211.org/2005/gmd}evaluationMethodType) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element dateTime ({http://www.isotc211.org/2005/gmd}dateTime) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element result ({http://www.isotc211.org/2005/gmd}result) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element nameOfMeasure ({http://www.isotc211.org/2005/gmd}nameOfMeasure) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element measureIdentification ({http://www.isotc211.org/2005/gmd}measureIdentification) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractDQ_TemporalAccuracy_Type._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractDQ_TemporalAccuracy_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'DQ_TemporalConsistency_Type', DQ_TemporalConsistency_Type)


# Complex type AbstractMD_SpatialRepresentation_Type with content type EMPTY
class AbstractMD_SpatialRepresentation_Type (AbstractObject_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_EMPTY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'AbstractMD_SpatialRepresentation_Type')
    # Base type is AbstractObject_Type
    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractObject_Type._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractObject_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'AbstractMD_SpatialRepresentation_Type', AbstractMD_SpatialRepresentation_Type)


# Complex type MD_GridSpatialRepresentation_Type with content type ELEMENT_ONLY
class MD_GridSpatialRepresentation_Type (AbstractMD_SpatialRepresentation_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_GridSpatialRepresentation_Type')
    # Base type is AbstractMD_SpatialRepresentation_Type
    
    # Element {http://www.isotc211.org/2005/gmd}transformationParameterAvailability uses Python identifier transformationParameterAvailability
    __transformationParameterAvailability = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'transformationParameterAvailability'), 'transformationParameterAvailability', '__httpwww_isotc211_org2005gmd_MD_GridSpatialRepresentation_Type_httpwww_isotc211_org2005gmdtransformationParameterAvailability', False)

    
    transformationParameterAvailability = property(__transformationParameterAvailability.value, __transformationParameterAvailability.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}numberOfDimensions uses Python identifier numberOfDimensions
    __numberOfDimensions = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'numberOfDimensions'), 'numberOfDimensions', '__httpwww_isotc211_org2005gmd_MD_GridSpatialRepresentation_Type_httpwww_isotc211_org2005gmdnumberOfDimensions', False)

    
    numberOfDimensions = property(__numberOfDimensions.value, __numberOfDimensions.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}cellGeometry uses Python identifier cellGeometry
    __cellGeometry = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'cellGeometry'), 'cellGeometry', '__httpwww_isotc211_org2005gmd_MD_GridSpatialRepresentation_Type_httpwww_isotc211_org2005gmdcellGeometry', False)

    
    cellGeometry = property(__cellGeometry.value, __cellGeometry.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}axisDimensionProperties uses Python identifier axisDimensionProperties
    __axisDimensionProperties = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'axisDimensionProperties'), 'axisDimensionProperties', '__httpwww_isotc211_org2005gmd_MD_GridSpatialRepresentation_Type_httpwww_isotc211_org2005gmdaxisDimensionProperties', True)

    
    axisDimensionProperties = property(__axisDimensionProperties.value, __axisDimensionProperties.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractMD_SpatialRepresentation_Type._ElementMap.copy()
    _ElementMap.update({
        __transformationParameterAvailability.name() : __transformationParameterAvailability,
        __numberOfDimensions.name() : __numberOfDimensions,
        __cellGeometry.name() : __cellGeometry,
        __axisDimensionProperties.name() : __axisDimensionProperties
    })
    _AttributeMap = AbstractMD_SpatialRepresentation_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_GridSpatialRepresentation_Type', MD_GridSpatialRepresentation_Type)


# Complex type MD_Georeferenceable_Type with content type ELEMENT_ONLY
class MD_Georeferenceable_Type (MD_GridSpatialRepresentation_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_Georeferenceable_Type')
    # Base type is MD_GridSpatialRepresentation_Type
    
    # Element transformationParameterAvailability ({http://www.isotc211.org/2005/gmd}transformationParameterAvailability) inherited from {http://www.isotc211.org/2005/gmd}MD_GridSpatialRepresentation_Type
    
    # Element {http://www.isotc211.org/2005/gmd}controlPointAvailability uses Python identifier controlPointAvailability
    __controlPointAvailability = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'controlPointAvailability'), 'controlPointAvailability', '__httpwww_isotc211_org2005gmd_MD_Georeferenceable_Type_httpwww_isotc211_org2005gmdcontrolPointAvailability', False)

    
    controlPointAvailability = property(__controlPointAvailability.value, __controlPointAvailability.set, None, None)

    
    # Element cellGeometry ({http://www.isotc211.org/2005/gmd}cellGeometry) inherited from {http://www.isotc211.org/2005/gmd}MD_GridSpatialRepresentation_Type
    
    # Element {http://www.isotc211.org/2005/gmd}orientationParameterDescription uses Python identifier orientationParameterDescription
    __orientationParameterDescription = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'orientationParameterDescription'), 'orientationParameterDescription', '__httpwww_isotc211_org2005gmd_MD_Georeferenceable_Type_httpwww_isotc211_org2005gmdorientationParameterDescription', False)

    
    orientationParameterDescription = property(__orientationParameterDescription.value, __orientationParameterDescription.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}georeferencedParameters uses Python identifier georeferencedParameters
    __georeferencedParameters = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'georeferencedParameters'), 'georeferencedParameters', '__httpwww_isotc211_org2005gmd_MD_Georeferenceable_Type_httpwww_isotc211_org2005gmdgeoreferencedParameters', False)

    
    georeferencedParameters = property(__georeferencedParameters.value, __georeferencedParameters.set, None, None)

    
    # Element numberOfDimensions ({http://www.isotc211.org/2005/gmd}numberOfDimensions) inherited from {http://www.isotc211.org/2005/gmd}MD_GridSpatialRepresentation_Type
    
    # Element {http://www.isotc211.org/2005/gmd}orientationParameterAvailability uses Python identifier orientationParameterAvailability
    __orientationParameterAvailability = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'orientationParameterAvailability'), 'orientationParameterAvailability', '__httpwww_isotc211_org2005gmd_MD_Georeferenceable_Type_httpwww_isotc211_org2005gmdorientationParameterAvailability', False)

    
    orientationParameterAvailability = property(__orientationParameterAvailability.value, __orientationParameterAvailability.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}parameterCitation uses Python identifier parameterCitation
    __parameterCitation = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'parameterCitation'), 'parameterCitation', '__httpwww_isotc211_org2005gmd_MD_Georeferenceable_Type_httpwww_isotc211_org2005gmdparameterCitation', True)

    
    parameterCitation = property(__parameterCitation.value, __parameterCitation.set, None, None)

    
    # Element axisDimensionProperties ({http://www.isotc211.org/2005/gmd}axisDimensionProperties) inherited from {http://www.isotc211.org/2005/gmd}MD_GridSpatialRepresentation_Type
    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = MD_GridSpatialRepresentation_Type._ElementMap.copy()
    _ElementMap.update({
        __controlPointAvailability.name() : __controlPointAvailability,
        __orientationParameterDescription.name() : __orientationParameterDescription,
        __georeferencedParameters.name() : __georeferencedParameters,
        __orientationParameterAvailability.name() : __orientationParameterAvailability,
        __parameterCitation.name() : __parameterCitation
    })
    _AttributeMap = MD_GridSpatialRepresentation_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_Georeferenceable_Type', MD_Georeferenceable_Type)


# Complex type DQ_AccuracyOfATimeMeasurement_Type with content type ELEMENT_ONLY
class DQ_AccuracyOfATimeMeasurement_Type (AbstractDQ_TemporalAccuracy_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'DQ_AccuracyOfATimeMeasurement_Type')
    # Base type is AbstractDQ_TemporalAccuracy_Type
    
    # Element evaluationMethodDescription ({http://www.isotc211.org/2005/gmd}evaluationMethodDescription) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element measureDescription ({http://www.isotc211.org/2005/gmd}measureDescription) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element evaluationProcedure ({http://www.isotc211.org/2005/gmd}evaluationProcedure) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element evaluationMethodType ({http://www.isotc211.org/2005/gmd}evaluationMethodType) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element dateTime ({http://www.isotc211.org/2005/gmd}dateTime) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element result ({http://www.isotc211.org/2005/gmd}result) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element nameOfMeasure ({http://www.isotc211.org/2005/gmd}nameOfMeasure) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element measureIdentification ({http://www.isotc211.org/2005/gmd}measureIdentification) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractDQ_TemporalAccuracy_Type._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractDQ_TemporalAccuracy_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'DQ_AccuracyOfATimeMeasurement_Type', DQ_AccuracyOfATimeMeasurement_Type)


# Complex type EllipsoidalCSPropertyType with content type ELEMENT_ONLY
class EllipsoidalCSPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'EllipsoidalCSPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}EllipsoidalCS uses Python identifier EllipsoidalCS
    __EllipsoidalCS = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'EllipsoidalCS'), 'EllipsoidalCS', '__httpwww_opengis_netgml3_2_EllipsoidalCSPropertyType_httpwww_opengis_netgml3_2EllipsoidalCS', False)

    
    EllipsoidalCS = property(__EllipsoidalCS.value, __EllipsoidalCS.set, None, u'gml:EllipsoidalCS is a two- or three-dimensional coordinate system in which position is specified by geodetic latitude, geodetic longitude, and (in the three-dimensional case) ellipsoidal height. An EllipsoidalCS shall have two or three gml:axis property elements; the number of associations shall equal the dimension of the CS.')

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_EllipsoidalCSPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_EllipsoidalCSPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_EllipsoidalCSPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_EllipsoidalCSPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_EllipsoidalCSPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_EllipsoidalCSPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_EllipsoidalCSPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_EllipsoidalCSPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_EllipsoidalCSPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")


    _ElementMap = {
        __EllipsoidalCS.name() : __EllipsoidalCS
    }
    _AttributeMap = {
        __remoteSchema.name() : __remoteSchema,
        __actuate.name() : __actuate,
        __href.name() : __href,
        __type.name() : __type,
        __nilReason.name() : __nilReason,
        __title.name() : __title,
        __arcrole.name() : __arcrole,
        __role.name() : __role,
        __show.name() : __show
    }
_Namespace_gml.addCategoryObject('typeBinding', u'EllipsoidalCSPropertyType', EllipsoidalCSPropertyType)


# Complex type MD_GeometricObjects_Type with content type ELEMENT_ONLY
class MD_GeometricObjects_Type (AbstractObject_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_GeometricObjects_Type')
    # Base type is AbstractObject_Type
    
    # Element {http://www.isotc211.org/2005/gmd}geometricObjectCount uses Python identifier geometricObjectCount
    __geometricObjectCount = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'geometricObjectCount'), 'geometricObjectCount', '__httpwww_isotc211_org2005gmd_MD_GeometricObjects_Type_httpwww_isotc211_org2005gmdgeometricObjectCount', False)

    
    geometricObjectCount = property(__geometricObjectCount.value, __geometricObjectCount.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}geometricObjectType uses Python identifier geometricObjectType
    __geometricObjectType = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'geometricObjectType'), 'geometricObjectType', '__httpwww_isotc211_org2005gmd_MD_GeometricObjects_Type_httpwww_isotc211_org2005gmdgeometricObjectType', False)

    
    geometricObjectType = property(__geometricObjectType.value, __geometricObjectType.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractObject_Type._ElementMap.copy()
    _ElementMap.update({
        __geometricObjectCount.name() : __geometricObjectCount,
        __geometricObjectType.name() : __geometricObjectType
    })
    _AttributeMap = AbstractObject_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_GeometricObjects_Type', MD_GeometricObjects_Type)


# Complex type ObservationType with content type ELEMENT_ONLY
class ObservationType (AbstractFeatureType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'ObservationType')
    # Base type is AbstractFeatureType
    
    # Element {http://www.opengis.net/gml/3.2}using uses Python identifier using
    __using = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'using'), 'using', '__httpwww_opengis_netgml3_2_ObservationType_httpwww_opengis_netgml3_2using', False)

    
    using = property(__using.value, __using.set, None, None)

    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}target uses Python identifier target
    __target = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'target'), 'target', '__httpwww_opengis_netgml3_2_ObservationType_httpwww_opengis_netgml3_2target', False)

    
    target = property(__target.value, __target.set, None, None)

    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}resultOf uses Python identifier resultOf
    __resultOf = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'resultOf'), 'resultOf', '__httpwww_opengis_netgml3_2_ObservationType_httpwww_opengis_netgml3_2resultOf', False)

    
    resultOf = property(__resultOf.value, __resultOf.set, None, None)

    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element location ({http://www.opengis.net/gml/3.2}location) inherited from {http://www.opengis.net/gml/3.2}AbstractFeatureType
    
    # Element boundedBy ({http://www.opengis.net/gml/3.2}boundedBy) inherited from {http://www.opengis.net/gml/3.2}AbstractFeatureType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}validTime uses Python identifier validTime
    __validTime = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'validTime'), 'validTime', '__httpwww_opengis_netgml3_2_ObservationType_httpwww_opengis_netgml3_2validTime', False)

    
    validTime = property(__validTime.value, __validTime.set, None, u'gml:validTime is a convenience property element.')

    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType

    _ElementMap = AbstractFeatureType._ElementMap.copy()
    _ElementMap.update({
        __using.name() : __using,
        __target.name() : __target,
        __resultOf.name() : __resultOf,
        __validTime.name() : __validTime
    })
    _AttributeMap = AbstractFeatureType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'ObservationType', ObservationType)


# Complex type DirectedObservationType with content type ELEMENT_ONLY
class DirectedObservationType (ObservationType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'DirectedObservationType')
    # Base type is ObservationType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element boundedBy ({http://www.opengis.net/gml/3.2}boundedBy) inherited from {http://www.opengis.net/gml/3.2}AbstractFeatureType
    
    # Element target ({http://www.opengis.net/gml/3.2}target) inherited from {http://www.opengis.net/gml/3.2}ObservationType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element using ({http://www.opengis.net/gml/3.2}using) inherited from {http://www.opengis.net/gml/3.2}ObservationType
    
    # Element {http://www.opengis.net/gml/3.2}direction uses Python identifier direction
    __direction = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'direction'), 'direction', '__httpwww_opengis_netgml3_2_DirectedObservationType_httpwww_opengis_netgml3_2direction', False)

    
    direction = property(__direction.value, __direction.set, None, u'The property gml:direction is intended as a pre-defined property expressing a direction to be assigned to features defined in a GML application schema.')

    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element location ({http://www.opengis.net/gml/3.2}location) inherited from {http://www.opengis.net/gml/3.2}AbstractFeatureType
    
    # Element resultOf ({http://www.opengis.net/gml/3.2}resultOf) inherited from {http://www.opengis.net/gml/3.2}ObservationType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element validTime ({http://www.opengis.net/gml/3.2}validTime) inherited from {http://www.opengis.net/gml/3.2}ObservationType
    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType

    _ElementMap = ObservationType._ElementMap.copy()
    _ElementMap.update({
        __direction.name() : __direction
    })
    _AttributeMap = ObservationType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'DirectedObservationType', DirectedObservationType)


# Complex type DirectedObservationAtDistanceType with content type ELEMENT_ONLY
class DirectedObservationAtDistanceType (DirectedObservationType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'DirectedObservationAtDistanceType')
    # Base type is DirectedObservationType
    
    # Element {http://www.opengis.net/gml/3.2}distance uses Python identifier distance
    __distance = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'distance'), 'distance', '__httpwww_opengis_netgml3_2_DirectedObservationAtDistanceType_httpwww_opengis_netgml3_2distance', False)

    
    distance = property(__distance.value, __distance.set, None, None)

    
    # Element using ({http://www.opengis.net/gml/3.2}using) inherited from {http://www.opengis.net/gml/3.2}ObservationType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element target ({http://www.opengis.net/gml/3.2}target) inherited from {http://www.opengis.net/gml/3.2}ObservationType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element direction ({http://www.opengis.net/gml/3.2}direction) inherited from {http://www.opengis.net/gml/3.2}DirectedObservationType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element location ({http://www.opengis.net/gml/3.2}location) inherited from {http://www.opengis.net/gml/3.2}AbstractFeatureType
    
    # Element boundedBy ({http://www.opengis.net/gml/3.2}boundedBy) inherited from {http://www.opengis.net/gml/3.2}AbstractFeatureType
    
    # Element resultOf ({http://www.opengis.net/gml/3.2}resultOf) inherited from {http://www.opengis.net/gml/3.2}ObservationType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element validTime ({http://www.opengis.net/gml/3.2}validTime) inherited from {http://www.opengis.net/gml/3.2}ObservationType
    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType

    _ElementMap = DirectedObservationType._ElementMap.copy()
    _ElementMap.update({
        __distance.name() : __distance
    })
    _AttributeMap = DirectedObservationType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'DirectedObservationAtDistanceType', DirectedObservationAtDistanceType)


# Complex type AbstractTimeComplexType with content type ELEMENT_ONLY
class AbstractTimeComplexType (AbstractTimeObjectType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractTimeComplexType')
    # Base type is AbstractTimeObjectType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType

    _ElementMap = AbstractTimeObjectType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractTimeObjectType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractTimeComplexType', AbstractTimeComplexType)


# Complex type TimeTopologyComplexType with content type ELEMENT_ONLY
class TimeTopologyComplexType (AbstractTimeComplexType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'TimeTopologyComplexType')
    # Base type is AbstractTimeComplexType
    
    # Element {http://www.opengis.net/gml/3.2}primitive uses Python identifier primitive
    __primitive = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'primitive'), 'primitive', '__httpwww_opengis_netgml3_2_TimeTopologyComplexType_httpwww_opengis_netgml3_2primitive', True)

    
    primitive = property(__primitive.value, __primitive.set, None, None)

    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType

    _ElementMap = AbstractTimeComplexType._ElementMap.copy()
    _ElementMap.update({
        __primitive.name() : __primitive
    })
    _AttributeMap = AbstractTimeComplexType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'TimeTopologyComplexType', TimeTopologyComplexType)


# Complex type AbstractDQ_Completeness_Type with content type ELEMENT_ONLY
class AbstractDQ_Completeness_Type (AbstractDQ_Element_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'AbstractDQ_Completeness_Type')
    # Base type is AbstractDQ_Element_Type
    
    # Element evaluationMethodDescription ({http://www.isotc211.org/2005/gmd}evaluationMethodDescription) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element measureDescription ({http://www.isotc211.org/2005/gmd}measureDescription) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element evaluationProcedure ({http://www.isotc211.org/2005/gmd}evaluationProcedure) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element evaluationMethodType ({http://www.isotc211.org/2005/gmd}evaluationMethodType) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element dateTime ({http://www.isotc211.org/2005/gmd}dateTime) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element result ({http://www.isotc211.org/2005/gmd}result) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element nameOfMeasure ({http://www.isotc211.org/2005/gmd}nameOfMeasure) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element measureIdentification ({http://www.isotc211.org/2005/gmd}measureIdentification) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractDQ_Element_Type._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractDQ_Element_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'AbstractDQ_Completeness_Type', AbstractDQ_Completeness_Type)


# Complex type DQ_CompletenessCommission_Type with content type ELEMENT_ONLY
class DQ_CompletenessCommission_Type (AbstractDQ_Completeness_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'DQ_CompletenessCommission_Type')
    # Base type is AbstractDQ_Completeness_Type
    
    # Element evaluationMethodDescription ({http://www.isotc211.org/2005/gmd}evaluationMethodDescription) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element measureDescription ({http://www.isotc211.org/2005/gmd}measureDescription) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element evaluationProcedure ({http://www.isotc211.org/2005/gmd}evaluationProcedure) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element evaluationMethodType ({http://www.isotc211.org/2005/gmd}evaluationMethodType) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element dateTime ({http://www.isotc211.org/2005/gmd}dateTime) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element result ({http://www.isotc211.org/2005/gmd}result) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element nameOfMeasure ({http://www.isotc211.org/2005/gmd}nameOfMeasure) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element measureIdentification ({http://www.isotc211.org/2005/gmd}measureIdentification) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractDQ_Completeness_Type._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractDQ_Completeness_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'DQ_CompletenessCommission_Type', DQ_CompletenessCommission_Type)


# Complex type TimePeriodPropertyType with content type ELEMENT_ONLY
class TimePeriodPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'TimePeriodPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}TimePeriod uses Python identifier TimePeriod
    __TimePeriod = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'TimePeriod'), 'TimePeriod', '__httpwww_opengis_netgml3_2_TimePeriodPropertyType_httpwww_opengis_netgml3_2TimePeriod', False)

    
    TimePeriod = property(__TimePeriod.value, __TimePeriod.set, None, u'gml:TimePeriod acts as a one-dimensional geometric primitive that represents an identifiable extent in time.\nThe location in of a gml:TimePeriod is described by the temporal positions of the instants at which it begins and ends. The length of the period is equal to the temporal distance between the two bounding temporal positions. \nBoth beginning and end may be described in terms of their direct position using gml:TimePositionType which is an XML Schema simple content type, or by reference to an indentifiable time instant using gml:TimeInstantPropertyType.\nAlternatively a limit of a gml:TimePeriod may use the conventional GML property model to make a reference to a time instant described elsewhere, or a limit may be indicated as a direct position.')

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_TimePeriodPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_TimePeriodPropertyType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_TimePeriodPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_TimePeriodPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_TimePeriodPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_TimePeriodPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_TimePeriodPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_TimePeriodPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_TimePeriodPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_TimePeriodPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")


    _ElementMap = {
        __TimePeriod.name() : __TimePeriod
    }
    _AttributeMap = {
        __title.name() : __title,
        __owns.name() : __owns,
        __href.name() : __href,
        __type.name() : __type,
        __nilReason.name() : __nilReason,
        __remoteSchema.name() : __remoteSchema,
        __arcrole.name() : __arcrole,
        __role.name() : __role,
        __show.name() : __show,
        __actuate.name() : __actuate
    }
_Namespace_gml.addCategoryObject('typeBinding', u'TimePeriodPropertyType', TimePeriodPropertyType)


# Complex type DS_DataSet_Type with content type ELEMENT_ONLY
class DS_DataSet_Type (AbstractObject_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'DS_DataSet_Type')
    # Base type is AbstractObject_Type
    
    # Element {http://www.isotc211.org/2005/gmd}partOf uses Python identifier partOf
    __partOf = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'partOf'), 'partOf', '__httpwww_isotc211_org2005gmd_DS_DataSet_Type_httpwww_isotc211_org2005gmdpartOf', True)

    
    partOf = property(__partOf.value, __partOf.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}has uses Python identifier has
    __has = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'has'), 'has', '__httpwww_isotc211_org2005gmd_DS_DataSet_Type_httpwww_isotc211_org2005gmdhas', True)

    
    has = property(__has.value, __has.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractObject_Type._ElementMap.copy()
    _ElementMap.update({
        __partOf.name() : __partOf,
        __has.name() : __has
    })
    _AttributeMap = AbstractObject_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'DS_DataSet_Type', DS_DataSet_Type)


# Complex type OperationPropertyType with content type ELEMENT_ONLY
class OperationPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'OperationPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}AbstractOperation uses Python identifier AbstractOperation
    __AbstractOperation = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractOperation'), 'AbstractOperation', '__httpwww_opengis_netgml3_2_OperationPropertyType_httpwww_opengis_netgml3_2AbstractOperation', False)

    
    AbstractOperation = property(__AbstractOperation.value, __AbstractOperation.set, None, u'')

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_OperationPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_OperationPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_OperationPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_OperationPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_OperationPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_OperationPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_OperationPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_OperationPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_OperationPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")


    _ElementMap = {
        __AbstractOperation.name() : __AbstractOperation
    }
    _AttributeMap = {
        __remoteSchema.name() : __remoteSchema,
        __actuate.name() : __actuate,
        __href.name() : __href,
        __type.name() : __type,
        __nilReason.name() : __nilReason,
        __title.name() : __title,
        __arcrole.name() : __arcrole,
        __role.name() : __role,
        __show.name() : __show
    }
_Namespace_gml.addCategoryObject('typeBinding', u'OperationPropertyType', OperationPropertyType)


# Complex type AreaType with content type SIMPLE
class AreaType (MeasureType):
    _TypeDefinition = pyxb.binding.datatypes.double
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_SIMPLE
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AreaType')
    # Base type is MeasureType
    
    # Attribute uom inherited from {http://www.opengis.net/gml/3.2}MeasureType

    _ElementMap = MeasureType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = MeasureType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'AreaType', AreaType)


# Complex type Measure_PropertyType with content type ELEMENT_ONLY
class Measure_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gco, u'Measure_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gco}Measure uses Python identifier Measure
    __Measure = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'Measure'), 'Measure', '__httpwww_isotc211_org2005gco_Measure_PropertyType_httpwww_isotc211_org2005gcoMeasure', False)

    
    Measure = property(__Measure.value, __Measure.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gco_Measure_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        __Measure.name() : __Measure
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason
    }
_Namespace_gco.addCategoryObject('typeBinding', u'Measure_PropertyType', Measure_PropertyType)


# Complex type EngineeringDatumPropertyType with content type ELEMENT_ONLY
class EngineeringDatumPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'EngineeringDatumPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}EngineeringDatum uses Python identifier EngineeringDatum
    __EngineeringDatum = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'EngineeringDatum'), 'EngineeringDatum', '__httpwww_opengis_netgml3_2_EngineeringDatumPropertyType_httpwww_opengis_netgml3_2EngineeringDatum', False)

    
    EngineeringDatum = property(__EngineeringDatum.value, __EngineeringDatum.set, None, u'gml:EngineeringDatum defines the origin of an engineering coordinate reference system, and is used in a region around that origin. This origin may be fixed with respect to the earth (such as a defined point at a construction site), or be a defined point on a moving vehicle (such as on a ship or satellite).')

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_EngineeringDatumPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_EngineeringDatumPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_EngineeringDatumPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_EngineeringDatumPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_EngineeringDatumPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_EngineeringDatumPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_EngineeringDatumPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_EngineeringDatumPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_EngineeringDatumPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")


    _ElementMap = {
        __EngineeringDatum.name() : __EngineeringDatum
    }
    _AttributeMap = {
        __actuate.name() : __actuate,
        __remoteSchema.name() : __remoteSchema,
        __href.name() : __href,
        __type.name() : __type,
        __title.name() : __title,
        __nilReason.name() : __nilReason,
        __arcrole.name() : __arcrole,
        __role.name() : __role,
        __show.name() : __show
    }
_Namespace_gml.addCategoryObject('typeBinding', u'EngineeringDatumPropertyType', EngineeringDatumPropertyType)


# Complex type TimeNodePropertyType with content type ELEMENT_ONLY
class TimeNodePropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'TimeNodePropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}TimeNode uses Python identifier TimeNode
    __TimeNode = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'TimeNode'), 'TimeNode', '__httpwww_opengis_netgml3_2_TimeNodePropertyType_httpwww_opengis_netgml3_2TimeNode', False)

    
    TimeNode = property(__TimeNode.value, __TimeNode.set, None, u'A time node is a zero-dimensional topological primitive that represents an identifiable node in time (it is equivalent to a point in space). A node may act as the termination or initiation of any number of time edges. A time node may be realised as a geometry, its position, whose value is a time instant.')

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_TimeNodePropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_TimeNodePropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_TimeNodePropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_TimeNodePropertyType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_TimeNodePropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_TimeNodePropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_TimeNodePropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_TimeNodePropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_TimeNodePropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_TimeNodePropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')


    _ElementMap = {
        __TimeNode.name() : __TimeNode
    }
    _AttributeMap = {
        __show.name() : __show,
        __role.name() : __role,
        __title.name() : __title,
        __owns.name() : __owns,
        __actuate.name() : __actuate,
        __arcrole.name() : __arcrole,
        __href.name() : __href,
        __nilReason.name() : __nilReason,
        __type.name() : __type,
        __remoteSchema.name() : __remoteSchema
    }
_Namespace_gml.addCategoryObject('typeBinding', u'TimeNodePropertyType', TimeNodePropertyType)


# Complex type GeodeticDatumPropertyType with content type ELEMENT_ONLY
class GeodeticDatumPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'GeodeticDatumPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}GeodeticDatum uses Python identifier GeodeticDatum
    __GeodeticDatum = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'GeodeticDatum'), 'GeodeticDatum', '__httpwww_opengis_netgml3_2_GeodeticDatumPropertyType_httpwww_opengis_netgml3_2GeodeticDatum', False)

    
    GeodeticDatum = property(__GeodeticDatum.value, __GeodeticDatum.set, None, u'gml:GeodeticDatum is a geodetic datum defines the precise location and orientation in 3-dimensional space of a defined ellipsoid (or sphere), or of a Cartesian coordinate system centered in this ellipsoid (or sphere).')

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_GeodeticDatumPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_GeodeticDatumPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_GeodeticDatumPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_GeodeticDatumPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_GeodeticDatumPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_GeodeticDatumPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_GeodeticDatumPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_GeodeticDatumPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_GeodeticDatumPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)


    _ElementMap = {
        __GeodeticDatum.name() : __GeodeticDatum
    }
    _AttributeMap = {
        __role.name() : __role,
        __type.name() : __type,
        __title.name() : __title,
        __arcrole.name() : __arcrole,
        __remoteSchema.name() : __remoteSchema,
        __nilReason.name() : __nilReason,
        __show.name() : __show,
        __actuate.name() : __actuate,
        __href.name() : __href
    }
_Namespace_gml.addCategoryObject('typeBinding', u'GeodeticDatumPropertyType', GeodeticDatumPropertyType)


# Complex type MovingObjectStatusType with content type ELEMENT_ONLY
class MovingObjectStatusType (AbstractTimeSliceType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'MovingObjectStatusType')
    # Base type is AbstractTimeSliceType
    
    # Element {http://www.opengis.net/gml/3.2}location uses Python identifier location
    __location = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'location'), 'location', '__httpwww_opengis_netgml3_2_MovingObjectStatusType_httpwww_opengis_netgml3_2location', False)

    
    location = property(__location.value, __location.set, None, u'')

    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}locationName uses Python identifier locationName
    __locationName = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'locationName'), 'locationName', '__httpwww_opengis_netgml3_2_MovingObjectStatusType_httpwww_opengis_netgml3_2locationName', False)

    
    locationName = property(__locationName.value, __locationName.set, None, u'The gml:locationName property element is a convenience property where the text value describes the location of the feature. If the location names are selected from a controlled list, then the list shall be identified in the codeSpace attribute.')

    
    # Element {http://www.opengis.net/gml/3.2}pos uses Python identifier pos
    __pos = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'pos'), 'pos', '__httpwww_opengis_netgml3_2_MovingObjectStatusType_httpwww_opengis_netgml3_2pos', False)

    
    pos = property(__pos.value, __pos.set, None, None)

    
    # Element {http://www.opengis.net/gml/3.2}locationReference uses Python identifier locationReference
    __locationReference = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'locationReference'), 'locationReference', '__httpwww_opengis_netgml3_2_MovingObjectStatusType_httpwww_opengis_netgml3_2locationReference', False)

    
    locationReference = property(__locationReference.value, __locationReference.set, None, u'The gml:locationReference property element is a convenience property where the text value referenced by the xlink:href attribute describes the location of the feature.')

    
    # Element {http://www.opengis.net/gml/3.2}bearing uses Python identifier bearing
    __bearing = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'bearing'), 'bearing', '__httpwww_opengis_netgml3_2_MovingObjectStatusType_httpwww_opengis_netgml3_2bearing', False)

    
    bearing = property(__bearing.value, __bearing.set, None, None)

    
    # Element {http://www.opengis.net/gml/3.2}speed uses Python identifier speed
    __speed = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'speed'), 'speed', '__httpwww_opengis_netgml3_2_MovingObjectStatusType_httpwww_opengis_netgml3_2speed', False)

    
    speed = property(__speed.value, __speed.set, None, None)

    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}position uses Python identifier position
    __position = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'position'), 'position', '__httpwww_opengis_netgml3_2_MovingObjectStatusType_httpwww_opengis_netgml3_2position', False)

    
    position = property(__position.value, __position.set, None, None)

    
    # Element dataSource ({http://www.opengis.net/gml/3.2}dataSource) inherited from {http://www.opengis.net/gml/3.2}AbstractTimeSliceType
    
    # Element {http://www.opengis.net/gml/3.2}status uses Python identifier status
    __status = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'status'), 'status', '__httpwww_opengis_netgml3_2_MovingObjectStatusType_httpwww_opengis_netgml3_2status', False)

    
    status = property(__status.value, __status.set, None, u'')

    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}elevation uses Python identifier elevation
    __elevation = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'elevation'), 'elevation', '__httpwww_opengis_netgml3_2_MovingObjectStatusType_httpwww_opengis_netgml3_2elevation', False)

    
    elevation = property(__elevation.value, __elevation.set, None, None)

    
    # Element {http://www.opengis.net/gml/3.2}statusReference uses Python identifier statusReference
    __statusReference = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'statusReference'), 'statusReference', '__httpwww_opengis_netgml3_2_MovingObjectStatusType_httpwww_opengis_netgml3_2statusReference', False)

    
    statusReference = property(__statusReference.value, __statusReference.set, None, u'')

    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element validTime ({http://www.opengis.net/gml/3.2}validTime) inherited from {http://www.opengis.net/gml/3.2}AbstractTimeSliceType
    
    # Element {http://www.opengis.net/gml/3.2}acceleration uses Python identifier acceleration
    __acceleration = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'acceleration'), 'acceleration', '__httpwww_opengis_netgml3_2_MovingObjectStatusType_httpwww_opengis_netgml3_2acceleration', False)

    
    acceleration = property(__acceleration.value, __acceleration.set, None, None)

    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType

    _ElementMap = AbstractTimeSliceType._ElementMap.copy()
    _ElementMap.update({
        __location.name() : __location,
        __locationName.name() : __locationName,
        __pos.name() : __pos,
        __locationReference.name() : __locationReference,
        __bearing.name() : __bearing,
        __speed.name() : __speed,
        __position.name() : __position,
        __status.name() : __status,
        __elevation.name() : __elevation,
        __statusReference.name() : __statusReference,
        __acceleration.name() : __acceleration
    })
    _AttributeMap = AbstractTimeSliceType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'MovingObjectStatusType', MovingObjectStatusType)


# Complex type MD_MetadataExtensionInformation_PropertyType with content type ELEMENT_ONLY
class MD_MetadataExtensionInformation_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_MetadataExtensionInformation_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}MD_MetadataExtensionInformation uses Python identifier MD_MetadataExtensionInformation
    __MD_MetadataExtensionInformation = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_MetadataExtensionInformation'), 'MD_MetadataExtensionInformation', '__httpwww_isotc211_org2005gmd_MD_MetadataExtensionInformation_PropertyType_httpwww_isotc211_org2005gmdMD_MetadataExtensionInformation', False)

    
    MD_MetadataExtensionInformation = property(__MD_MetadataExtensionInformation.value, __MD_MetadataExtensionInformation.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_MD_MetadataExtensionInformation_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_MD_MetadataExtensionInformation_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_MD_MetadataExtensionInformation_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_MD_MetadataExtensionInformation_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_MD_MetadataExtensionInformation_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_MD_MetadataExtensionInformation_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_MD_MetadataExtensionInformation_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_MD_MetadataExtensionInformation_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_MD_MetadataExtensionInformation_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")


    _ElementMap = {
        __MD_MetadataExtensionInformation.name() : __MD_MetadataExtensionInformation
    }
    _AttributeMap = {
        __type.name() : __type,
        __title.name() : __title,
        __arcrole.name() : __arcrole,
        __role.name() : __role,
        __nilReason.name() : __nilReason,
        __uuidref.name() : __uuidref,
        __show.name() : __show,
        __href.name() : __href,
        __actuate.name() : __actuate
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_MetadataExtensionInformation_PropertyType', MD_MetadataExtensionInformation_PropertyType)


# Complex type MD_Constraints_Type with content type ELEMENT_ONLY
class MD_Constraints_Type (AbstractObject_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_Constraints_Type')
    # Base type is AbstractObject_Type
    
    # Element {http://www.isotc211.org/2005/gmd}useLimitation uses Python identifier useLimitation
    __useLimitation = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'useLimitation'), 'useLimitation', '__httpwww_isotc211_org2005gmd_MD_Constraints_Type_httpwww_isotc211_org2005gmduseLimitation', True)

    
    useLimitation = property(__useLimitation.value, __useLimitation.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractObject_Type._ElementMap.copy()
    _ElementMap.update({
        __useLimitation.name() : __useLimitation
    })
    _AttributeMap = AbstractObject_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_Constraints_Type', MD_Constraints_Type)


# Complex type ImageDatumPropertyType with content type ELEMENT_ONLY
class ImageDatumPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'ImageDatumPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}ImageDatum uses Python identifier ImageDatum
    __ImageDatum = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'ImageDatum'), 'ImageDatum', '__httpwww_opengis_netgml3_2_ImageDatumPropertyType_httpwww_opengis_netgml3_2ImageDatum', False)

    
    ImageDatum = property(__ImageDatum.value, __ImageDatum.set, None, u'gml:ImageDatum defines the origin of an image coordinate reference system, and is used in a local context only. For an image datum, the anchor definition is usually either the centre of the image or the corner of the image. For more information, see ISO 19111 B.3.5.')

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_ImageDatumPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_ImageDatumPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_ImageDatumPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_ImageDatumPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_ImageDatumPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_ImageDatumPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_ImageDatumPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_ImageDatumPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_ImageDatumPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)


    _ElementMap = {
        __ImageDatum.name() : __ImageDatum
    }
    _AttributeMap = {
        __remoteSchema.name() : __remoteSchema,
        __role.name() : __role,
        __show.name() : __show,
        __actuate.name() : __actuate,
        __nilReason.name() : __nilReason,
        __href.name() : __href,
        __type.name() : __type,
        __title.name() : __title,
        __arcrole.name() : __arcrole
    }
_Namespace_gml.addCategoryObject('typeBinding', u'ImageDatumPropertyType', ImageDatumPropertyType)


# Complex type CurveArrayPropertyType with content type ELEMENT_ONLY
class CurveArrayPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'CurveArrayPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}AbstractCurve uses Python identifier AbstractCurve
    __AbstractCurve = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractCurve'), 'AbstractCurve', '__httpwww_opengis_netgml3_2_CurveArrayPropertyType_httpwww_opengis_netgml3_2AbstractCurve', True)

    
    AbstractCurve = property(__AbstractCurve.value, __AbstractCurve.set, None, u'The AbstractCurve element is the abstract head of the substitution group for all (continuous) curve elements.')

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_CurveArrayPropertyType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)


    _ElementMap = {
        __AbstractCurve.name() : __AbstractCurve
    }
    _AttributeMap = {
        __owns.name() : __owns
    }
_Namespace_gml.addCategoryObject('typeBinding', u'CurveArrayPropertyType', CurveArrayPropertyType)


# Complex type CTD_ANON_2 with content type ELEMENT_ONLY
class CTD_ANON_2 (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = None
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}AbstractDQ_PositionalAccuracy uses Python identifier AbstractDQ_PositionalAccuracy
    __AbstractDQ_PositionalAccuracy = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'AbstractDQ_PositionalAccuracy'), 'AbstractDQ_PositionalAccuracy', '__httpwww_opengis_netgml3_2_CTD_ANON_2_httpwww_isotc211_org2005gmdAbstractDQ_PositionalAccuracy', False)

    
    AbstractDQ_PositionalAccuracy = property(__AbstractDQ_PositionalAccuracy.value, __AbstractDQ_PositionalAccuracy.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_CTD_ANON_2_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_CTD_ANON_2_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_CTD_ANON_2_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_CTD_ANON_2_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_CTD_ANON_2_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_CTD_ANON_2_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_CTD_ANON_2_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_CTD_ANON_2_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_CTD_ANON_2_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")


    _ElementMap = {
        __AbstractDQ_PositionalAccuracy.name() : __AbstractDQ_PositionalAccuracy
    }
    _AttributeMap = {
        __actuate.name() : __actuate,
        __remoteSchema.name() : __remoteSchema,
        __href.name() : __href,
        __type.name() : __type,
        __title.name() : __title,
        __nilReason.name() : __nilReason,
        __arcrole.name() : __arcrole,
        __role.name() : __role,
        __show.name() : __show
    }



# Complex type Date_PropertyType with content type ELEMENT_ONLY
class Date_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gco, u'Date_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gco}Date uses Python identifier Date
    __Date = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'Date'), 'Date', '__httpwww_isotc211_org2005gco_Date_PropertyType_httpwww_isotc211_org2005gcoDate', False)

    
    Date = property(__Date.value, __Date.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gco}DateTime uses Python identifier DateTime
    __DateTime = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'DateTime'), 'DateTime', '__httpwww_isotc211_org2005gco_Date_PropertyType_httpwww_isotc211_org2005gcoDateTime', False)

    
    DateTime = property(__DateTime.value, __DateTime.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gco_Date_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        __Date.name() : __Date,
        __DateTime.name() : __DateTime
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason
    }
_Namespace_gco.addCategoryObject('typeBinding', u'Date_PropertyType', Date_PropertyType)


# Complex type NodePropertyType with content type ELEMENT_ONLY
class NodePropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'NodePropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}Node uses Python identifier Node
    __Node = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'Node'), 'Node', '__httpwww_opengis_netgml3_2_NodePropertyType_httpwww_opengis_netgml3_2Node', False)

    
    Node = property(__Node.value, __Node.set, None, u'gml:Node represents the 0-dimensional primitive.\nThe optional coboundary of a node (gml:directedEdge) is a sequence of directed edges which are incident on this node. Edges emanating from this node appear in the node coboundary with a negative orientation. \nIf provided, the aggregationType attribute shall have the value "sequence".\nA node may optionally be realised by a 0-dimensional geometric primitive (gml:pointProperty).')

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_NodePropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_NodePropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_NodePropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_NodePropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_NodePropertyType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_NodePropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_NodePropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_NodePropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_NodePropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_NodePropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')


    _ElementMap = {
        __Node.name() : __Node
    }
    _AttributeMap = {
        __arcrole.name() : __arcrole,
        __role.name() : __role,
        __show.name() : __show,
        __type.name() : __type,
        __owns.name() : __owns,
        __actuate.name() : __actuate,
        __nilReason.name() : __nilReason,
        __href.name() : __href,
        __title.name() : __title,
        __remoteSchema.name() : __remoteSchema
    }
_Namespace_gml.addCategoryObject('typeBinding', u'NodePropertyType', NodePropertyType)


# Complex type AbstractCoordinateOperationType with content type ELEMENT_ONLY
class AbstractCoordinateOperationType (IdentifiedObjectType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractCoordinateOperationType')
    # Base type is IdentifiedObjectType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}targetCRS uses Python identifier targetCRS
    __targetCRS = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'targetCRS'), 'targetCRS', '__httpwww_opengis_netgml3_2_AbstractCoordinateOperationType_httpwww_opengis_netgml3_2targetCRS', False)

    
    targetCRS = property(__targetCRS.value, __targetCRS.set, None, u'gml:targetCRS is an association role to the target CRS (coordinate reference system) of this coordinate operation.')

    
    # Element {http://www.opengis.net/gml/3.2}domainOfValidity uses Python identifier domainOfValidity
    __domainOfValidity = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'domainOfValidity'), 'domainOfValidity', '__httpwww_opengis_netgml3_2_AbstractCoordinateOperationType_httpwww_opengis_netgml3_2domainOfValidity', False)

    
    domainOfValidity = property(__domainOfValidity.value, __domainOfValidity.set, None, u'The gml:domainOfValidity property implements an association role to an EX_Extent object as encoded in ISO/TS 19139, either referencing or containing the definition of that extent.')

    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}sourceCRS uses Python identifier sourceCRS
    __sourceCRS = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'sourceCRS'), 'sourceCRS', '__httpwww_opengis_netgml3_2_AbstractCoordinateOperationType_httpwww_opengis_netgml3_2sourceCRS', False)

    
    sourceCRS = property(__sourceCRS.value, __sourceCRS.set, None, u'gml:sourceCRS is an association role to the source CRS (coordinate reference system) of this coordinate operation.')

    
    # Element {http://www.opengis.net/gml/3.2}operationVersion uses Python identifier operationVersion
    __operationVersion = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'operationVersion'), 'operationVersion', '__httpwww_opengis_netgml3_2_AbstractCoordinateOperationType_httpwww_opengis_netgml3_2operationVersion', False)

    
    operationVersion = property(__operationVersion.value, __operationVersion.set, None, u'gml:operationVersion is the version of the coordinate transformation (i.e., instantiation due to the stochastic nature of the parameters). Mandatory when describing a transformation, and should not be supplied for a conversion.')

    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}scope uses Python identifier scope
    __scope = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'scope'), 'scope', '__httpwww_opengis_netgml3_2_AbstractCoordinateOperationType_httpwww_opengis_netgml3_2scope', True)

    
    scope = property(__scope.value, __scope.set, None, u'The gml:scope property provides a description of the usage, or limitations of usage, for which this CRS-related object is valid. If unknown, enter "not known".')

    
    # Element {http://www.opengis.net/gml/3.2}coordinateOperationAccuracy uses Python identifier coordinateOperationAccuracy
    __coordinateOperationAccuracy = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'coordinateOperationAccuracy'), 'coordinateOperationAccuracy', '__httpwww_opengis_netgml3_2_AbstractCoordinateOperationType_httpwww_opengis_netgml3_2coordinateOperationAccuracy', True)

    
    coordinateOperationAccuracy = property(__coordinateOperationAccuracy.value, __coordinateOperationAccuracy.set, None, u'gml:coordinateOperationAccuracy is an association role to a DQ_PositionalAccuracy object as encoded in ISO/TS 19139, either referencing or containing the definition of that positional accuracy. That object contains an estimate of the impact of this coordinate operation on point accuracy. That is, it gives position error estimates for the target coordinates of this coordinate operation, assuming no errors in the source coordinates.')

    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType

    _ElementMap = IdentifiedObjectType._ElementMap.copy()
    _ElementMap.update({
        __targetCRS.name() : __targetCRS,
        __domainOfValidity.name() : __domainOfValidity,
        __sourceCRS.name() : __sourceCRS,
        __operationVersion.name() : __operationVersion,
        __scope.name() : __scope,
        __coordinateOperationAccuracy.name() : __coordinateOperationAccuracy
    })
    _AttributeMap = IdentifiedObjectType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractCoordinateOperationType', AbstractCoordinateOperationType)


# Complex type MD_ScopeDescription_PropertyType with content type ELEMENT_ONLY
class MD_ScopeDescription_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_ScopeDescription_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}MD_ScopeDescription uses Python identifier MD_ScopeDescription
    __MD_ScopeDescription = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_ScopeDescription'), 'MD_ScopeDescription', '__httpwww_isotc211_org2005gmd_MD_ScopeDescription_PropertyType_httpwww_isotc211_org2005gmdMD_ScopeDescription', False)

    
    MD_ScopeDescription = property(__MD_ScopeDescription.value, __MD_ScopeDescription.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_MD_ScopeDescription_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        __MD_ScopeDescription.name() : __MD_ScopeDescription
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_ScopeDescription_PropertyType', MD_ScopeDescription_PropertyType)


# Complex type Record_PropertyType with content type ELEMENT_ONLY
class Record_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gco, u'Record_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gco}Record uses Python identifier Record
    __Record = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'Record'), 'Record', '__httpwww_isotc211_org2005gco_Record_PropertyType_httpwww_isotc211_org2005gcoRecord', False)

    
    Record = property(__Record.value, __Record.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gco_Record_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gco_Record_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gco_Record_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gco_Record_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gco_Record_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gco_Record_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gco_Record_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gco_Record_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gco_Record_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")


    _ElementMap = {
        __Record.name() : __Record
    }
    _AttributeMap = {
        __type.name() : __type,
        __arcrole.name() : __arcrole,
        __role.name() : __role,
        __nilReason.name() : __nilReason,
        __uuidref.name() : __uuidref,
        __show.name() : __show,
        __title.name() : __title,
        __href.name() : __href,
        __actuate.name() : __actuate
    }
_Namespace_gco.addCategoryObject('typeBinding', u'Record_PropertyType', Record_PropertyType)


# Complex type AbstractFeatureCollectionType with content type ELEMENT_ONLY
class AbstractFeatureCollectionType (AbstractFeatureType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractFeatureCollectionType')
    # Base type is AbstractFeatureType
    
    # Element {http://www.opengis.net/gml/3.2}featureMember uses Python identifier featureMember
    __featureMember = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'featureMember'), 'featureMember', '__httpwww_opengis_netgml3_2_AbstractFeatureCollectionType_httpwww_opengis_netgml3_2featureMember', True)

    
    featureMember = property(__featureMember.value, __featureMember.set, None, u'')

    
    # Element {http://www.opengis.net/gml/3.2}featureMembers uses Python identifier featureMembers
    __featureMembers = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'featureMembers'), 'featureMembers', '__httpwww_opengis_netgml3_2_AbstractFeatureCollectionType_httpwww_opengis_netgml3_2featureMembers', False)

    
    featureMembers = property(__featureMembers.value, __featureMembers.set, None, u'')

    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element location ({http://www.opengis.net/gml/3.2}location) inherited from {http://www.opengis.net/gml/3.2}AbstractFeatureType
    
    # Element boundedBy ({http://www.opengis.net/gml/3.2}boundedBy) inherited from {http://www.opengis.net/gml/3.2}AbstractFeatureType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType

    _ElementMap = AbstractFeatureType._ElementMap.copy()
    _ElementMap.update({
        __featureMember.name() : __featureMember,
        __featureMembers.name() : __featureMembers
    })
    _AttributeMap = AbstractFeatureType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractFeatureCollectionType', AbstractFeatureCollectionType)


# Complex type AbstractFeatureMemberType with content type EMPTY
class AbstractFeatureMemberType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_EMPTY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractFeatureMemberType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_AbstractFeatureMemberType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)


    _ElementMap = {
        
    }
    _AttributeMap = {
        __owns.name() : __owns
    }
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractFeatureMemberType', AbstractFeatureMemberType)


# Complex type DynamicFeatureMemberType with content type ELEMENT_ONLY
class DynamicFeatureMemberType (AbstractFeatureMemberType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'DynamicFeatureMemberType')
    # Base type is AbstractFeatureMemberType
    
    # Element {http://www.opengis.net/gml/3.2}DynamicFeature uses Python identifier DynamicFeature
    __DynamicFeature = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'DynamicFeature'), 'DynamicFeature', '__httpwww_opengis_netgml3_2_DynamicFeatureMemberType_httpwww_opengis_netgml3_2DynamicFeature', True)

    
    DynamicFeature = property(__DynamicFeature.value, __DynamicFeature.set, None, u"States are captured by time-stamped instances of a feature. The content model extends the standard gml:AbstractFeatureType with the gml:dynamicProperties model group.\nEach time-stamped instance represents a 'snapshot' of a feature. The dynamic feature classes will normally be extended to suit particular applications.  A dynamic feature bears either a time stamp or a history.")

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_DynamicFeatureMemberType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_DynamicFeatureMemberType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_DynamicFeatureMemberType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_DynamicFeatureMemberType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_DynamicFeatureMemberType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_DynamicFeatureMemberType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute owns inherited from {http://www.opengis.net/gml/3.2}AbstractFeatureMemberType
    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_DynamicFeatureMemberType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_DynamicFeatureMemberType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_DynamicFeatureMemberType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")


    _ElementMap = AbstractFeatureMemberType._ElementMap.copy()
    _ElementMap.update({
        __DynamicFeature.name() : __DynamicFeature
    })
    _AttributeMap = AbstractFeatureMemberType._AttributeMap.copy()
    _AttributeMap.update({
        __role.name() : __role,
        __type.name() : __type,
        __actuate.name() : __actuate,
        __href.name() : __href,
        __nilReason.name() : __nilReason,
        __title.name() : __title,
        __arcrole.name() : __arcrole,
        __remoteSchema.name() : __remoteSchema,
        __show.name() : __show
    })
_Namespace_gml.addCategoryObject('typeBinding', u'DynamicFeatureMemberType', DynamicFeatureMemberType)


# Complex type AbstractDS_Aggregate_Type with content type ELEMENT_ONLY
class AbstractDS_Aggregate_Type (AbstractObject_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'AbstractDS_Aggregate_Type')
    # Base type is AbstractObject_Type
    
    # Element {http://www.isotc211.org/2005/gmd}superset uses Python identifier superset
    __superset = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'superset'), 'superset', '__httpwww_isotc211_org2005gmd_AbstractDS_Aggregate_Type_httpwww_isotc211_org2005gmdsuperset', True)

    
    superset = property(__superset.value, __superset.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}composedOf uses Python identifier composedOf
    __composedOf = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'composedOf'), 'composedOf', '__httpwww_isotc211_org2005gmd_AbstractDS_Aggregate_Type_httpwww_isotc211_org2005gmdcomposedOf', True)

    
    composedOf = property(__composedOf.value, __composedOf.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}seriesMetadata uses Python identifier seriesMetadata
    __seriesMetadata = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'seriesMetadata'), 'seriesMetadata', '__httpwww_isotc211_org2005gmd_AbstractDS_Aggregate_Type_httpwww_isotc211_org2005gmdseriesMetadata', True)

    
    seriesMetadata = property(__seriesMetadata.value, __seriesMetadata.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}subset uses Python identifier subset
    __subset = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'subset'), 'subset', '__httpwww_isotc211_org2005gmd_AbstractDS_Aggregate_Type_httpwww_isotc211_org2005gmdsubset', True)

    
    subset = property(__subset.value, __subset.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractObject_Type._ElementMap.copy()
    _ElementMap.update({
        __superset.name() : __superset,
        __composedOf.name() : __composedOf,
        __seriesMetadata.name() : __seriesMetadata,
        __subset.name() : __subset
    })
    _AttributeMap = AbstractObject_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'AbstractDS_Aggregate_Type', AbstractDS_Aggregate_Type)


# Complex type DS_Series_Type with content type ELEMENT_ONLY
class DS_Series_Type (AbstractDS_Aggregate_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'DS_Series_Type')
    # Base type is AbstractDS_Aggregate_Type
    
    # Element superset ({http://www.isotc211.org/2005/gmd}superset) inherited from {http://www.isotc211.org/2005/gmd}AbstractDS_Aggregate_Type
    
    # Element composedOf ({http://www.isotc211.org/2005/gmd}composedOf) inherited from {http://www.isotc211.org/2005/gmd}AbstractDS_Aggregate_Type
    
    # Element seriesMetadata ({http://www.isotc211.org/2005/gmd}seriesMetadata) inherited from {http://www.isotc211.org/2005/gmd}AbstractDS_Aggregate_Type
    
    # Element subset ({http://www.isotc211.org/2005/gmd}subset) inherited from {http://www.isotc211.org/2005/gmd}AbstractDS_Aggregate_Type
    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractDS_Aggregate_Type._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractDS_Aggregate_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'DS_Series_Type', DS_Series_Type)


# Complex type DS_Platform_Type with content type ELEMENT_ONLY
class DS_Platform_Type (DS_Series_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'DS_Platform_Type')
    # Base type is DS_Series_Type
    
    # Element superset ({http://www.isotc211.org/2005/gmd}superset) inherited from {http://www.isotc211.org/2005/gmd}AbstractDS_Aggregate_Type
    
    # Element composedOf ({http://www.isotc211.org/2005/gmd}composedOf) inherited from {http://www.isotc211.org/2005/gmd}AbstractDS_Aggregate_Type
    
    # Element seriesMetadata ({http://www.isotc211.org/2005/gmd}seriesMetadata) inherited from {http://www.isotc211.org/2005/gmd}AbstractDS_Aggregate_Type
    
    # Element subset ({http://www.isotc211.org/2005/gmd}subset) inherited from {http://www.isotc211.org/2005/gmd}AbstractDS_Aggregate_Type
    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = DS_Series_Type._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = DS_Series_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'DS_Platform_Type', DS_Platform_Type)


# Complex type UnitDefinitionType with content type ELEMENT_ONLY
class UnitDefinitionType (DefinitionType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'UnitDefinitionType')
    # Base type is DefinitionType
    
    # Element {http://www.opengis.net/gml/3.2}catalogSymbol uses Python identifier catalogSymbol
    __catalogSymbol = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'catalogSymbol'), 'catalogSymbol', '__httpwww_opengis_netgml3_2_UnitDefinitionType_httpwww_opengis_netgml3_2catalogSymbol', False)

    
    catalogSymbol = property(__catalogSymbol.value, __catalogSymbol.set, None, u'The catalogSymbol is the preferred lexical symbol used for this unit of measure.\nThe codeSpace attribute in gml:CodeType identifies a namespace for the catalog symbol value, and might reference the external catalog. The string value in gml:CodeType contains the value of a symbol that should be unique within this catalog namespace. This symbol often appears explicitly in the catalog, but it could be a combination of symbols using a specified algebra of units.')

    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}quantityType uses Python identifier quantityType
    __quantityType = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'quantityType'), 'quantityType', '__httpwww_opengis_netgml3_2_UnitDefinitionType_httpwww_opengis_netgml3_2quantityType', False)

    
    quantityType = property(__quantityType.value, __quantityType.set, None, u'The gml:quantityType property indicates the phenomenon to which the units apply. This element contains an informal description of the phenomenon or type of physical quantity that is measured or observed. When the physical quantity is the result of an observation or measurement, this term is known as observable type or measurand.\nThe use of gml:quantityType for references to remote values is deprecated.')

    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}quantityTypeReference uses Python identifier quantityTypeReference
    __quantityTypeReference = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'quantityTypeReference'), 'quantityTypeReference', '__httpwww_opengis_netgml3_2_UnitDefinitionType_httpwww_opengis_netgml3_2quantityTypeReference', False)

    
    quantityTypeReference = property(__quantityTypeReference.value, __quantityTypeReference.set, None, u'The gml:quantityTypeReference property indicates the phenomenon to which the units apply. The content is a reference to a remote value.')

    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType

    _ElementMap = DefinitionType._ElementMap.copy()
    _ElementMap.update({
        __catalogSymbol.name() : __catalogSymbol,
        __quantityType.name() : __quantityType,
        __quantityTypeReference.name() : __quantityTypeReference
    })
    _AttributeMap = DefinitionType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'UnitDefinitionType', UnitDefinitionType)


# Complex type DQ_TopologicalConsistency_PropertyType with content type ELEMENT_ONLY
class DQ_TopologicalConsistency_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'DQ_TopologicalConsistency_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}DQ_TopologicalConsistency uses Python identifier DQ_TopologicalConsistency
    __DQ_TopologicalConsistency = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'DQ_TopologicalConsistency'), 'DQ_TopologicalConsistency', '__httpwww_isotc211_org2005gmd_DQ_TopologicalConsistency_PropertyType_httpwww_isotc211_org2005gmdDQ_TopologicalConsistency', False)

    
    DQ_TopologicalConsistency = property(__DQ_TopologicalConsistency.value, __DQ_TopologicalConsistency.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_DQ_TopologicalConsistency_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_DQ_TopologicalConsistency_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_DQ_TopologicalConsistency_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_DQ_TopologicalConsistency_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_DQ_TopologicalConsistency_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_DQ_TopologicalConsistency_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_DQ_TopologicalConsistency_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_DQ_TopologicalConsistency_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_DQ_TopologicalConsistency_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)


    _ElementMap = {
        __DQ_TopologicalConsistency.name() : __DQ_TopologicalConsistency
    }
    _AttributeMap = {
        __type.name() : __type,
        __arcrole.name() : __arcrole,
        __role.name() : __role,
        __nilReason.name() : __nilReason,
        __uuidref.name() : __uuidref,
        __show.name() : __show,
        __href.name() : __href,
        __actuate.name() : __actuate,
        __title.name() : __title
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'DQ_TopologicalConsistency_PropertyType', DQ_TopologicalConsistency_PropertyType)


# Complex type DiscreteCoverageType with content type ELEMENT_ONLY
class DiscreteCoverageType (AbstractCoverageType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'DiscreteCoverageType')
    # Base type is AbstractCoverageType
    
    # Element boundedBy ({http://www.opengis.net/gml/3.2}boundedBy) inherited from {http://www.opengis.net/gml/3.2}AbstractFeatureType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element rangeSet ({http://www.opengis.net/gml/3.2}rangeSet) inherited from {http://www.opengis.net/gml/3.2}AbstractCoverageType
    
    # Element {http://www.opengis.net/gml/3.2}coverageFunction uses Python identifier coverageFunction
    __coverageFunction = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'coverageFunction'), 'coverageFunction', '__httpwww_opengis_netgml3_2_DiscreteCoverageType_httpwww_opengis_netgml3_2coverageFunction', False)

    
    coverageFunction = property(__coverageFunction.value, __coverageFunction.set, None, u'The gml:coverageFunction property describes the mapping function from the domain to the range of the coverage.\nThe value of the CoverageFunction is one of gml:CoverageMappingRule and gml:GridFunction.\nIf the gml:coverageFunction property is omitted for a gridded coverage (including rectified gridded coverages) the gml:startPoint is assumed to be the value of the gml:low property in the gml:Grid geometry, and the gml:sequenceRule is assumed to be linear and the gml:axisOrder property is assumed to be "+1 +2".')

    
    # Element location ({http://www.opengis.net/gml/3.2}location) inherited from {http://www.opengis.net/gml/3.2}AbstractFeatureType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element domainSet ({http://www.opengis.net/gml/3.2}domainSet) inherited from {http://www.opengis.net/gml/3.2}AbstractCoverageType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType

    _ElementMap = AbstractCoverageType._ElementMap.copy()
    _ElementMap.update({
        __coverageFunction.name() : __coverageFunction
    })
    _AttributeMap = AbstractCoverageType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'DiscreteCoverageType', DiscreteCoverageType)


# Complex type AbstractEX_GeographicExtent_Type with content type ELEMENT_ONLY
class AbstractEX_GeographicExtent_Type (AbstractObject_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'AbstractEX_GeographicExtent_Type')
    # Base type is AbstractObject_Type
    
    # Element {http://www.isotc211.org/2005/gmd}extentTypeCode uses Python identifier extentTypeCode
    __extentTypeCode = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'extentTypeCode'), 'extentTypeCode', '__httpwww_isotc211_org2005gmd_AbstractEX_GeographicExtent_Type_httpwww_isotc211_org2005gmdextentTypeCode', False)

    
    extentTypeCode = property(__extentTypeCode.value, __extentTypeCode.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractObject_Type._ElementMap.copy()
    _ElementMap.update({
        __extentTypeCode.name() : __extentTypeCode
    })
    _AttributeMap = AbstractObject_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'AbstractEX_GeographicExtent_Type', AbstractEX_GeographicExtent_Type)


# Complex type AngleChoiceType with content type ELEMENT_ONLY
class AngleChoiceType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AngleChoiceType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}angle uses Python identifier angle
    __angle = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'angle'), 'angle', '__httpwww_opengis_netgml3_2_AngleChoiceType_httpwww_opengis_netgml3_2angle', False)

    
    angle = property(__angle.value, __angle.set, None, u'The gml:angle property element is used to record the value of an angle quantity as a single number, with its units.')

    
    # Element {http://www.opengis.net/gml/3.2}dmsAngle uses Python identifier dmsAngle
    __dmsAngle = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'dmsAngle'), 'dmsAngle', '__httpwww_opengis_netgml3_2_AngleChoiceType_httpwww_opengis_netgml3_2dmsAngle', False)

    
    dmsAngle = property(__dmsAngle.value, __dmsAngle.set, None, u'')


    _ElementMap = {
        __angle.name() : __angle,
        __dmsAngle.name() : __dmsAngle
    }
    _AttributeMap = {
        
    }
_Namespace_gml.addCategoryObject('typeBinding', u'AngleChoiceType', AngleChoiceType)


# Complex type Integer_PropertyType with content type ELEMENT_ONLY
class Integer_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gco, u'Integer_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gco}Integer uses Python identifier Integer
    __Integer = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'Integer'), 'Integer', '__httpwww_isotc211_org2005gco_Integer_PropertyType_httpwww_isotc211_org2005gcoInteger', False)

    
    Integer = property(__Integer.value, __Integer.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gco_Integer_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        __Integer.name() : __Integer
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason
    }
_Namespace_gco.addCategoryObject('typeBinding', u'Integer_PropertyType', Integer_PropertyType)


# Complex type MD_Keywords_PropertyType with content type ELEMENT_ONLY
class MD_Keywords_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_Keywords_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}MD_Keywords uses Python identifier MD_Keywords
    __MD_Keywords = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_Keywords'), 'MD_Keywords', '__httpwww_isotc211_org2005gmd_MD_Keywords_PropertyType_httpwww_isotc211_org2005gmdMD_Keywords', False)

    
    MD_Keywords = property(__MD_Keywords.value, __MD_Keywords.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_MD_Keywords_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_MD_Keywords_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_MD_Keywords_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_MD_Keywords_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_MD_Keywords_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_MD_Keywords_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_MD_Keywords_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_MD_Keywords_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_MD_Keywords_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")


    _ElementMap = {
        __MD_Keywords.name() : __MD_Keywords
    }
    _AttributeMap = {
        __type.name() : __type,
        __arcrole.name() : __arcrole,
        __role.name() : __role,
        __nilReason.name() : __nilReason,
        __title.name() : __title,
        __uuidref.name() : __uuidref,
        __show.name() : __show,
        __href.name() : __href,
        __actuate.name() : __actuate
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_Keywords_PropertyType', MD_Keywords_PropertyType)


# Complex type AssociationRoleType with content type ELEMENT_ONLY
class AssociationRoleType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AssociationRoleType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_AssociationRoleType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_AssociationRoleType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_AssociationRoleType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_AssociationRoleType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_AssociationRoleType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_AssociationRoleType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_AssociationRoleType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_AssociationRoleType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_AssociationRoleType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_AssociationRoleType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    _HasWildcardElement = True

    _ElementMap = {
        
    }
    _AttributeMap = {
        __role.name() : __role,
        __arcrole.name() : __arcrole,
        __title.name() : __title,
        __show.name() : __show,
        __owns.name() : __owns,
        __nilReason.name() : __nilReason,
        __href.name() : __href,
        __remoteSchema.name() : __remoteSchema,
        __actuate.name() : __actuate,
        __type.name() : __type
    }
_Namespace_gml.addCategoryObject('typeBinding', u'AssociationRoleType', AssociationRoleType)


# Complex type AbstractDQ_PositionalAccuracy_Type with content type ELEMENT_ONLY
class AbstractDQ_PositionalAccuracy_Type (AbstractDQ_Element_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'AbstractDQ_PositionalAccuracy_Type')
    # Base type is AbstractDQ_Element_Type
    
    # Element evaluationMethodDescription ({http://www.isotc211.org/2005/gmd}evaluationMethodDescription) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element measureDescription ({http://www.isotc211.org/2005/gmd}measureDescription) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element evaluationProcedure ({http://www.isotc211.org/2005/gmd}evaluationProcedure) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element evaluationMethodType ({http://www.isotc211.org/2005/gmd}evaluationMethodType) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element dateTime ({http://www.isotc211.org/2005/gmd}dateTime) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element result ({http://www.isotc211.org/2005/gmd}result) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element nameOfMeasure ({http://www.isotc211.org/2005/gmd}nameOfMeasure) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element measureIdentification ({http://www.isotc211.org/2005/gmd}measureIdentification) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractDQ_Element_Type._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractDQ_Element_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'AbstractDQ_PositionalAccuracy_Type', AbstractDQ_PositionalAccuracy_Type)


# Complex type DQ_GriddedDataPositionalAccuracy_Type with content type ELEMENT_ONLY
class DQ_GriddedDataPositionalAccuracy_Type (AbstractDQ_PositionalAccuracy_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'DQ_GriddedDataPositionalAccuracy_Type')
    # Base type is AbstractDQ_PositionalAccuracy_Type
    
    # Element evaluationMethodDescription ({http://www.isotc211.org/2005/gmd}evaluationMethodDescription) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element measureDescription ({http://www.isotc211.org/2005/gmd}measureDescription) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element evaluationProcedure ({http://www.isotc211.org/2005/gmd}evaluationProcedure) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element evaluationMethodType ({http://www.isotc211.org/2005/gmd}evaluationMethodType) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element dateTime ({http://www.isotc211.org/2005/gmd}dateTime) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element result ({http://www.isotc211.org/2005/gmd}result) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element nameOfMeasure ({http://www.isotc211.org/2005/gmd}nameOfMeasure) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element measureIdentification ({http://www.isotc211.org/2005/gmd}measureIdentification) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractDQ_PositionalAccuracy_Type._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractDQ_PositionalAccuracy_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'DQ_GriddedDataPositionalAccuracy_Type', DQ_GriddedDataPositionalAccuracy_Type)


# Complex type SphericalCSType with content type ELEMENT_ONLY
class SphericalCSType (AbstractCoordinateSystemType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'SphericalCSType')
    # Base type is AbstractCoordinateSystemType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element axis ({http://www.opengis.net/gml/3.2}axis) inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateSystemType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Attribute aggregationType inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateSystemType
    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType

    _ElementMap = AbstractCoordinateSystemType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractCoordinateSystemType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'SphericalCSType', SphericalCSType)


# Complex type MD_TopologyLevelCode_PropertyType with content type ELEMENT_ONLY
class MD_TopologyLevelCode_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_TopologyLevelCode_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}MD_TopologyLevelCode uses Python identifier MD_TopologyLevelCode
    __MD_TopologyLevelCode = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_TopologyLevelCode'), 'MD_TopologyLevelCode', '__httpwww_isotc211_org2005gmd_MD_TopologyLevelCode_PropertyType_httpwww_isotc211_org2005gmdMD_TopologyLevelCode', False)

    
    MD_TopologyLevelCode = property(__MD_TopologyLevelCode.value, __MD_TopologyLevelCode.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_MD_TopologyLevelCode_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        __MD_TopologyLevelCode.name() : __MD_TopologyLevelCode
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_TopologyLevelCode_PropertyType', MD_TopologyLevelCode_PropertyType)


# Complex type ObliqueCartesianCSPropertyType with content type ELEMENT_ONLY
class ObliqueCartesianCSPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'ObliqueCartesianCSPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}ObliqueCartesianCS uses Python identifier ObliqueCartesianCS
    __ObliqueCartesianCS = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'ObliqueCartesianCS'), 'ObliqueCartesianCS', '__httpwww_opengis_netgml3_2_ObliqueCartesianCSPropertyType_httpwww_opengis_netgml3_2ObliqueCartesianCS', False)

    
    ObliqueCartesianCS = property(__ObliqueCartesianCS.value, __ObliqueCartesianCS.set, None, u'')

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_ObliqueCartesianCSPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_ObliqueCartesianCSPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_ObliqueCartesianCSPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_ObliqueCartesianCSPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_ObliqueCartesianCSPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_ObliqueCartesianCSPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_ObliqueCartesianCSPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_ObliqueCartesianCSPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_ObliqueCartesianCSPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")


    _ElementMap = {
        __ObliqueCartesianCS.name() : __ObliqueCartesianCS
    }
    _AttributeMap = {
        __remoteSchema.name() : __remoteSchema,
        __href.name() : __href,
        __type.name() : __type,
        __title.name() : __title,
        __nilReason.name() : __nilReason,
        __arcrole.name() : __arcrole,
        __role.name() : __role,
        __show.name() : __show,
        __actuate.name() : __actuate
    }
_Namespace_gml.addCategoryObject('typeBinding', u'ObliqueCartesianCSPropertyType', ObliqueCartesianCSPropertyType)


# Complex type EnvelopeType with content type ELEMENT_ONLY
class EnvelopeType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'EnvelopeType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}upperCorner uses Python identifier upperCorner
    __upperCorner = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'upperCorner'), 'upperCorner', '__httpwww_opengis_netgml3_2_EnvelopeType_httpwww_opengis_netgml3_2upperCorner', False)

    
    upperCorner = property(__upperCorner.value, __upperCorner.set, None, None)

    
    # Element {http://www.opengis.net/gml/3.2}lowerCorner uses Python identifier lowerCorner
    __lowerCorner = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'lowerCorner'), 'lowerCorner', '__httpwww_opengis_netgml3_2_EnvelopeType_httpwww_opengis_netgml3_2lowerCorner', False)

    
    lowerCorner = property(__lowerCorner.value, __lowerCorner.set, None, None)

    
    # Element {http://www.opengis.net/gml/3.2}coordinates uses Python identifier coordinates
    __coordinates = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'coordinates'), 'coordinates', '__httpwww_opengis_netgml3_2_EnvelopeType_httpwww_opengis_netgml3_2coordinates', False)

    
    coordinates = property(__coordinates.value, __coordinates.set, None, u'')

    
    # Element {http://www.opengis.net/gml/3.2}pos uses Python identifier pos
    __pos = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'pos'), 'pos', '__httpwww_opengis_netgml3_2_EnvelopeType_httpwww_opengis_netgml3_2pos', True)

    
    pos = property(__pos.value, __pos.set, None, None)

    
    # Attribute srsName uses Python identifier srsName
    __srsName = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'srsName'), 'srsName', '__httpwww_opengis_netgml3_2_EnvelopeType_srsName', pyxb.binding.datatypes.anyURI)
    
    srsName = property(__srsName.value, __srsName.set, None, None)

    
    # Attribute axisLabels uses Python identifier axisLabels
    __axisLabels = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'axisLabels'), 'axisLabels', '__httpwww_opengis_netgml3_2_EnvelopeType_axisLabels', NCNameList)
    
    axisLabels = property(__axisLabels.value, __axisLabels.set, None, None)

    
    # Attribute uomLabels uses Python identifier uomLabels
    __uomLabels = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uomLabels'), 'uomLabels', '__httpwww_opengis_netgml3_2_EnvelopeType_uomLabels', NCNameList)
    
    uomLabels = property(__uomLabels.value, __uomLabels.set, None, None)

    
    # Attribute srsDimension uses Python identifier srsDimension
    __srsDimension = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'srsDimension'), 'srsDimension', '__httpwww_opengis_netgml3_2_EnvelopeType_srsDimension', pyxb.binding.datatypes.positiveInteger)
    
    srsDimension = property(__srsDimension.value, __srsDimension.set, None, None)


    _ElementMap = {
        __upperCorner.name() : __upperCorner,
        __lowerCorner.name() : __lowerCorner,
        __coordinates.name() : __coordinates,
        __pos.name() : __pos
    }
    _AttributeMap = {
        __srsName.name() : __srsName,
        __axisLabels.name() : __axisLabels,
        __uomLabels.name() : __uomLabels,
        __srsDimension.name() : __srsDimension
    }
_Namespace_gml.addCategoryObject('typeBinding', u'EnvelopeType', EnvelopeType)


# Complex type EnvelopeWithTimePeriodType with content type ELEMENT_ONLY
class EnvelopeWithTimePeriodType (EnvelopeType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'EnvelopeWithTimePeriodType')
    # Base type is EnvelopeType
    
    # Element {http://www.opengis.net/gml/3.2}beginPosition uses Python identifier beginPosition
    __beginPosition = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'beginPosition'), 'beginPosition', '__httpwww_opengis_netgml3_2_EnvelopeWithTimePeriodType_httpwww_opengis_netgml3_2beginPosition', False)

    
    beginPosition = property(__beginPosition.value, __beginPosition.set, None, None)

    
    # Element coordinates ({http://www.opengis.net/gml/3.2}coordinates) inherited from {http://www.opengis.net/gml/3.2}EnvelopeType
    
    # Element pos ({http://www.opengis.net/gml/3.2}pos) inherited from {http://www.opengis.net/gml/3.2}EnvelopeType
    
    # Element lowerCorner ({http://www.opengis.net/gml/3.2}lowerCorner) inherited from {http://www.opengis.net/gml/3.2}EnvelopeType
    
    # Element {http://www.opengis.net/gml/3.2}endPosition uses Python identifier endPosition
    __endPosition = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'endPosition'), 'endPosition', '__httpwww_opengis_netgml3_2_EnvelopeWithTimePeriodType_httpwww_opengis_netgml3_2endPosition', False)

    
    endPosition = property(__endPosition.value, __endPosition.set, None, None)

    
    # Element upperCorner ({http://www.opengis.net/gml/3.2}upperCorner) inherited from {http://www.opengis.net/gml/3.2}EnvelopeType
    
    # Attribute srsName inherited from {http://www.opengis.net/gml/3.2}EnvelopeType
    
    # Attribute axisLabels inherited from {http://www.opengis.net/gml/3.2}EnvelopeType
    
    # Attribute uomLabels inherited from {http://www.opengis.net/gml/3.2}EnvelopeType
    
    # Attribute srsDimension inherited from {http://www.opengis.net/gml/3.2}EnvelopeType
    
    # Attribute frame uses Python identifier frame
    __frame = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'frame'), 'frame', '__httpwww_opengis_netgml3_2_EnvelopeWithTimePeriodType_frame', pyxb.binding.datatypes.anyURI, unicode_default=u'#ISO-8601')
    
    frame = property(__frame.value, __frame.set, None, None)


    _ElementMap = EnvelopeType._ElementMap.copy()
    _ElementMap.update({
        __beginPosition.name() : __beginPosition,
        __endPosition.name() : __endPosition
    })
    _AttributeMap = EnvelopeType._AttributeMap.copy()
    _AttributeMap.update({
        __frame.name() : __frame
    })
_Namespace_gml.addCategoryObject('typeBinding', u'EnvelopeWithTimePeriodType', EnvelopeWithTimePeriodType)


# Complex type SurfacePropertyType with content type ELEMENT_ONLY
class SurfacePropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'SurfacePropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}AbstractSurface uses Python identifier AbstractSurface
    __AbstractSurface = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractSurface'), 'AbstractSurface', '__httpwww_opengis_netgml3_2_SurfacePropertyType_httpwww_opengis_netgml3_2AbstractSurface', False)

    
    AbstractSurface = property(__AbstractSurface.value, __AbstractSurface.set, None, u'The AbstractSurface element is the abstract head of the substitution group for all (continuous) surface elements.')

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_SurfacePropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_SurfacePropertyType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_SurfacePropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_SurfacePropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_SurfacePropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_SurfacePropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_SurfacePropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_SurfacePropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_SurfacePropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_SurfacePropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")


    _ElementMap = {
        __AbstractSurface.name() : __AbstractSurface
    }
    _AttributeMap = {
        __actuate.name() : __actuate,
        __owns.name() : __owns,
        __arcrole.name() : __arcrole,
        __href.name() : __href,
        __type.name() : __type,
        __nilReason.name() : __nilReason,
        __title.name() : __title,
        __remoteSchema.name() : __remoteSchema,
        __role.name() : __role,
        __show.name() : __show
    }
_Namespace_gml.addCategoryObject('typeBinding', u'SurfacePropertyType', SurfacePropertyType)


# Complex type AbstractGeneralTransformationType with content type ELEMENT_ONLY
class AbstractGeneralTransformationType (AbstractCoordinateOperationType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractGeneralTransformationType')
    # Base type is AbstractCoordinateOperationType
    
    # Element sourceCRS ({http://www.opengis.net/gml/3.2}sourceCRS) inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateOperationType
    
    # Element targetCRS ({http://www.opengis.net/gml/3.2}targetCRS) inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateOperationType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element operationVersion ({http://www.opengis.net/gml/3.2}operationVersion) inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateOperationType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element scope ({http://www.opengis.net/gml/3.2}scope) inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateOperationType
    
    # Element domainOfValidity ({http://www.opengis.net/gml/3.2}domainOfValidity) inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateOperationType
    
    # Element coordinateOperationAccuracy ({http://www.opengis.net/gml/3.2}coordinateOperationAccuracy) inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateOperationType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Attribute id_ is restricted from parent
    
    # Attribute {http://www.opengis.net/gml/3.2}id uses Python identifier id_
    __id_ = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'id'), 'id_', '__httpwww_opengis_netgml3_2_DefinitionBaseType_httpwww_opengis_netgml3_2id', pyxb.binding.datatypes.ID, required=True)
    
    id_ = property(__id_.value, __id_.set, None, u'The attribute gml:id supports provision of a handle for the XML element representing a GML Object. Its use is mandatory for all GML objects. It is of XML type ID, so is constrained to be unique in the XML document within which it occurs.')


    _ElementMap = AbstractCoordinateOperationType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractCoordinateOperationType._AttributeMap.copy()
    _AttributeMap.update({
        __id_.name() : __id_
    })
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractGeneralTransformationType', AbstractGeneralTransformationType)


# Complex type TransformationType with content type ELEMENT_ONLY
class TransformationType (AbstractGeneralTransformationType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'TransformationType')
    # Base type is AbstractGeneralTransformationType
    
    # Element sourceCRS ({http://www.opengis.net/gml/3.2}sourceCRS) inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateOperationType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}parameterValue uses Python identifier parameterValue
    __parameterValue = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'parameterValue'), 'parameterValue', '__httpwww_opengis_netgml3_2_TransformationType_httpwww_opengis_netgml3_2parameterValue', True)

    
    parameterValue = property(__parameterValue.value, __parameterValue.set, None, u'gml:parameterValue is a composition association to a parameter value or group of parameter values used by a coordinate operation.')

    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}method uses Python identifier method
    __method = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'method'), 'method', '__httpwww_opengis_netgml3_2_TransformationType_httpwww_opengis_netgml3_2method', False)

    
    method = property(__method.value, __method.set, None, u'gml:method is an association role to the operation method used by a coordinate operation.')

    
    # Element operationVersion ({http://www.opengis.net/gml/3.2}operationVersion) inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateOperationType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element scope ({http://www.opengis.net/gml/3.2}scope) inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateOperationType
    
    # Element domainOfValidity ({http://www.opengis.net/gml/3.2}domainOfValidity) inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateOperationType
    
    # Element coordinateOperationAccuracy ({http://www.opengis.net/gml/3.2}coordinateOperationAccuracy) inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateOperationType
    
    # Element targetCRS ({http://www.opengis.net/gml/3.2}targetCRS) inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateOperationType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Attribute id_2 inherited from {http://www.opengis.net/gml/3.2}AbstractGeneralTransformationType

    _ElementMap = AbstractGeneralTransformationType._ElementMap.copy()
    _ElementMap.update({
        __parameterValue.name() : __parameterValue,
        __method.name() : __method
    })
    _AttributeMap = AbstractGeneralTransformationType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'TransformationType', TransformationType)


# Complex type UnlimitedInteger_Type with content type SIMPLE
class UnlimitedInteger_Type (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = pyxb.binding.datatypes.nonNegativeInteger
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_SIMPLE
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gco, u'UnlimitedInteger_Type')
    # Base type is pyxb.binding.datatypes.nonNegativeInteger
    
    # Attribute isInfinite uses Python identifier isInfinite
    __isInfinite = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'isInfinite'), 'isInfinite', '__httpwww_isotc211_org2005gco_UnlimitedInteger_Type_isInfinite', pyxb.binding.datatypes.boolean)
    
    isInfinite = property(__isInfinite.value, __isInfinite.set, None, None)


    _ElementMap = {
        
    }
    _AttributeMap = {
        __isInfinite.name() : __isInfinite
    }
_Namespace_gco.addCategoryObject('typeBinding', u'UnlimitedInteger_Type', UnlimitedInteger_Type)


# Complex type CI_Telephone_PropertyType with content type ELEMENT_ONLY
class CI_Telephone_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'CI_Telephone_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}CI_Telephone uses Python identifier CI_Telephone
    __CI_Telephone = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'CI_Telephone'), 'CI_Telephone', '__httpwww_isotc211_org2005gmd_CI_Telephone_PropertyType_httpwww_isotc211_org2005gmdCI_Telephone', False)

    
    CI_Telephone = property(__CI_Telephone.value, __CI_Telephone.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_CI_Telephone_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_CI_Telephone_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_CI_Telephone_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_CI_Telephone_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_CI_Telephone_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_CI_Telephone_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_CI_Telephone_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_CI_Telephone_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_CI_Telephone_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)


    _ElementMap = {
        __CI_Telephone.name() : __CI_Telephone
    }
    _AttributeMap = {
        __show.name() : __show,
        __role.name() : __role,
        __href.name() : __href,
        __actuate.name() : __actuate,
        __type.name() : __type,
        __uuidref.name() : __uuidref,
        __arcrole.name() : __arcrole,
        __nilReason.name() : __nilReason,
        __title.name() : __title
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'CI_Telephone_PropertyType', CI_Telephone_PropertyType)


# Complex type DS_OtherAggregate_PropertyType with content type ELEMENT_ONLY
class DS_OtherAggregate_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'DS_OtherAggregate_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}DS_OtherAggregate uses Python identifier DS_OtherAggregate
    __DS_OtherAggregate = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'DS_OtherAggregate'), 'DS_OtherAggregate', '__httpwww_isotc211_org2005gmd_DS_OtherAggregate_PropertyType_httpwww_isotc211_org2005gmdDS_OtherAggregate', False)

    
    DS_OtherAggregate = property(__DS_OtherAggregate.value, __DS_OtherAggregate.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_DS_OtherAggregate_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_DS_OtherAggregate_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_DS_OtherAggregate_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_DS_OtherAggregate_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_DS_OtherAggregate_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_DS_OtherAggregate_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_DS_OtherAggregate_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_DS_OtherAggregate_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_DS_OtherAggregate_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)


    _ElementMap = {
        __DS_OtherAggregate.name() : __DS_OtherAggregate
    }
    _AttributeMap = {
        __arcrole.name() : __arcrole,
        __role.name() : __role,
        __nilReason.name() : __nilReason,
        __title.name() : __title,
        __show.name() : __show,
        __uuidref.name() : __uuidref,
        __href.name() : __href,
        __actuate.name() : __actuate,
        __type.name() : __type
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'DS_OtherAggregate_PropertyType', DS_OtherAggregate_PropertyType)


# Complex type AngleType with content type SIMPLE
class AngleType (MeasureType):
    _TypeDefinition = pyxb.binding.datatypes.double
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_SIMPLE
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AngleType')
    # Base type is MeasureType
    
    # Attribute uom inherited from {http://www.opengis.net/gml/3.2}MeasureType

    _ElementMap = MeasureType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = MeasureType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'AngleType', AngleType)


# Complex type MD_PixelOrientationCode_PropertyType with content type ELEMENT_ONLY
class MD_PixelOrientationCode_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_PixelOrientationCode_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}MD_PixelOrientationCode uses Python identifier MD_PixelOrientationCode
    __MD_PixelOrientationCode = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_PixelOrientationCode'), 'MD_PixelOrientationCode', '__httpwww_isotc211_org2005gmd_MD_PixelOrientationCode_PropertyType_httpwww_isotc211_org2005gmdMD_PixelOrientationCode', False)

    
    MD_PixelOrientationCode = property(__MD_PixelOrientationCode.value, __MD_PixelOrientationCode.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_MD_PixelOrientationCode_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        __MD_PixelOrientationCode.name() : __MD_PixelOrientationCode
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_PixelOrientationCode_PropertyType', MD_PixelOrientationCode_PropertyType)


# Complex type StringOrRefType with content type SIMPLE
class StringOrRefType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = pyxb.binding.datatypes.string
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_SIMPLE
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'StringOrRefType')
    # Base type is pyxb.binding.datatypes.string
    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_StringOrRefType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_StringOrRefType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_StringOrRefType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_StringOrRefType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_StringOrRefType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_StringOrRefType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_StringOrRefType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_StringOrRefType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_StringOrRefType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)


    _ElementMap = {
        
    }
    _AttributeMap = {
        __role.name() : __role,
        __remoteSchema.name() : __remoteSchema,
        __show.name() : __show,
        __actuate.name() : __actuate,
        __href.name() : __href,
        __nilReason.name() : __nilReason,
        __type.name() : __type,
        __title.name() : __title,
        __arcrole.name() : __arcrole
    }
_Namespace_gml.addCategoryObject('typeBinding', u'StringOrRefType', StringOrRefType)


# Complex type AffinePlacementType with content type ELEMENT_ONLY
class AffinePlacementType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AffinePlacementType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}outDimension uses Python identifier outDimension
    __outDimension = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'outDimension'), 'outDimension', '__httpwww_opengis_netgml3_2_AffinePlacementType_httpwww_opengis_netgml3_2outDimension', False)

    
    outDimension = property(__outDimension.value, __outDimension.set, None, None)

    
    # Element {http://www.opengis.net/gml/3.2}location uses Python identifier location
    __location = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'location'), 'location', '__httpwww_opengis_netgml3_2_AffinePlacementType_httpwww_opengis_netgml3_2location', False)

    
    location = property(__location.value, __location.set, None, None)

    
    # Element {http://www.opengis.net/gml/3.2}refDirection uses Python identifier refDirection
    __refDirection = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'refDirection'), 'refDirection', '__httpwww_opengis_netgml3_2_AffinePlacementType_httpwww_opengis_netgml3_2refDirection', True)

    
    refDirection = property(__refDirection.value, __refDirection.set, None, None)

    
    # Element {http://www.opengis.net/gml/3.2}inDimension uses Python identifier inDimension
    __inDimension = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'inDimension'), 'inDimension', '__httpwww_opengis_netgml3_2_AffinePlacementType_httpwww_opengis_netgml3_2inDimension', False)

    
    inDimension = property(__inDimension.value, __inDimension.set, None, None)


    _ElementMap = {
        __outDimension.name() : __outDimension,
        __location.name() : __location,
        __refDirection.name() : __refDirection,
        __inDimension.name() : __inDimension
    }
    _AttributeMap = {
        
    }
_Namespace_gml.addCategoryObject('typeBinding', u'AffinePlacementType', AffinePlacementType)


# Complex type AbstractMetadataPropertyType with content type EMPTY
class AbstractMetadataPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_EMPTY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractMetadataPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_AbstractMetadataPropertyType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)


    _ElementMap = {
        
    }
    _AttributeMap = {
        __owns.name() : __owns
    }
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractMetadataPropertyType', AbstractMetadataPropertyType)


# Complex type EllipsoidPropertyType with content type ELEMENT_ONLY
class EllipsoidPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'EllipsoidPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}Ellipsoid uses Python identifier Ellipsoid
    __Ellipsoid = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'Ellipsoid'), 'Ellipsoid', '__httpwww_opengis_netgml3_2_EllipsoidPropertyType_httpwww_opengis_netgml3_2Ellipsoid', False)

    
    Ellipsoid = property(__Ellipsoid.value, __Ellipsoid.set, None, u'A gml:Ellipsoid is a geometric figure that may be used to describe the approximate shape of the earth. In mathematical terms, it is a surface formed by the rotation of an ellipse about its minor axis.')

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_EllipsoidPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_EllipsoidPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_EllipsoidPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_EllipsoidPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_EllipsoidPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_EllipsoidPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_EllipsoidPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_EllipsoidPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_EllipsoidPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)


    _ElementMap = {
        __Ellipsoid.name() : __Ellipsoid
    }
    _AttributeMap = {
        __title.name() : __title,
        __role.name() : __role,
        __arcrole.name() : __arcrole,
        __remoteSchema.name() : __remoteSchema,
        __show.name() : __show,
        __nilReason.name() : __nilReason,
        __actuate.name() : __actuate,
        __href.name() : __href,
        __type.name() : __type
    }
_Namespace_gml.addCategoryObject('typeBinding', u'EllipsoidPropertyType', EllipsoidPropertyType)


# Complex type TimeReferenceSystemType with content type ELEMENT_ONLY
class TimeReferenceSystemType (DefinitionType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'TimeReferenceSystemType')
    # Base type is DefinitionType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}domainOfValidity uses Python identifier domainOfValidity
    __domainOfValidity = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'domainOfValidity'), 'domainOfValidity', '__httpwww_opengis_netgml3_2_TimeReferenceSystemType_httpwww_opengis_netgml3_2domainOfValidity', False)

    
    domainOfValidity = property(__domainOfValidity.value, __domainOfValidity.set, None, None)

    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType

    _ElementMap = DefinitionType._ElementMap.copy()
    _ElementMap.update({
        __domainOfValidity.name() : __domainOfValidity
    })
    _AttributeMap = DefinitionType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'TimeReferenceSystemType', TimeReferenceSystemType)


# Complex type TimeCoordinateSystemType with content type ELEMENT_ONLY
class TimeCoordinateSystemType (TimeReferenceSystemType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'TimeCoordinateSystemType')
    # Base type is TimeReferenceSystemType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element domainOfValidity ({http://www.opengis.net/gml/3.2}domainOfValidity) inherited from {http://www.opengis.net/gml/3.2}TimeReferenceSystemType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}originPosition uses Python identifier originPosition
    __originPosition = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'originPosition'), 'originPosition', '__httpwww_opengis_netgml3_2_TimeCoordinateSystemType_httpwww_opengis_netgml3_2originPosition', False)

    
    originPosition = property(__originPosition.value, __originPosition.set, None, None)

    
    # Element {http://www.opengis.net/gml/3.2}origin uses Python identifier origin
    __origin = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'origin'), 'origin', '__httpwww_opengis_netgml3_2_TimeCoordinateSystemType_httpwww_opengis_netgml3_2origin', False)

    
    origin = property(__origin.value, __origin.set, None, None)

    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}interval uses Python identifier interval
    __interval = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'interval'), 'interval', '__httpwww_opengis_netgml3_2_TimeCoordinateSystemType_httpwww_opengis_netgml3_2interval', False)

    
    interval = property(__interval.value, __interval.set, None, None)

    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType

    _ElementMap = TimeReferenceSystemType._ElementMap.copy()
    _ElementMap.update({
        __originPosition.name() : __originPosition,
        __origin.name() : __origin,
        __interval.name() : __interval
    })
    _AttributeMap = TimeReferenceSystemType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'TimeCoordinateSystemType', TimeCoordinateSystemType)


# Complex type MD_Identifier_PropertyType with content type ELEMENT_ONLY
class MD_Identifier_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_Identifier_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}MD_Identifier uses Python identifier MD_Identifier
    __MD_Identifier = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_Identifier'), 'MD_Identifier', '__httpwww_isotc211_org2005gmd_MD_Identifier_PropertyType_httpwww_isotc211_org2005gmdMD_Identifier', False)

    
    MD_Identifier = property(__MD_Identifier.value, __MD_Identifier.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_MD_Identifier_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_MD_Identifier_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_MD_Identifier_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_MD_Identifier_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_MD_Identifier_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_MD_Identifier_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_MD_Identifier_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_MD_Identifier_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_MD_Identifier_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)


    _ElementMap = {
        __MD_Identifier.name() : __MD_Identifier
    }
    _AttributeMap = {
        __actuate.name() : __actuate,
        __type.name() : __type,
        __arcrole.name() : __arcrole,
        __role.name() : __role,
        __uuidref.name() : __uuidref,
        __nilReason.name() : __nilReason,
        __title.name() : __title,
        __show.name() : __show,
        __href.name() : __href
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_Identifier_PropertyType', MD_Identifier_PropertyType)


# Complex type MultiPointPropertyType with content type ELEMENT_ONLY
class MultiPointPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'MultiPointPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}MultiPoint uses Python identifier MultiPoint
    __MultiPoint = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'MultiPoint'), 'MultiPoint', '__httpwww_opengis_netgml3_2_MultiPointPropertyType_httpwww_opengis_netgml3_2MultiPoint', False)

    
    MultiPoint = property(__MultiPoint.value, __MultiPoint.set, None, u'A gml:MultiPoint consists of one or more gml:Points.\nThe members of the geometric aggregate may be specified either using the "standard" property (gml:pointMember) or the array property (gml:pointMembers). It is also valid to use both the "standard" and the array properties in the same collection.')

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_MultiPointPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_MultiPointPropertyType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_MultiPointPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_MultiPointPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_MultiPointPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_MultiPointPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_MultiPointPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_MultiPointPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_MultiPointPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_MultiPointPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")


    _ElementMap = {
        __MultiPoint.name() : __MultiPoint
    }
    _AttributeMap = {
        __href.name() : __href,
        __owns.name() : __owns,
        __type.name() : __type,
        __title.name() : __title,
        __arcrole.name() : __arcrole,
        __remoteSchema.name() : __remoteSchema,
        __nilReason.name() : __nilReason,
        __role.name() : __role,
        __show.name() : __show,
        __actuate.name() : __actuate
    }
_Namespace_gml.addCategoryObject('typeBinding', u'MultiPointPropertyType', MultiPointPropertyType)


# Complex type MultiCurvePropertyType with content type ELEMENT_ONLY
class MultiCurvePropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'MultiCurvePropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}MultiCurve uses Python identifier MultiCurve
    __MultiCurve = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'MultiCurve'), 'MultiCurve', '__httpwww_opengis_netgml3_2_MultiCurvePropertyType_httpwww_opengis_netgml3_2MultiCurve', False)

    
    MultiCurve = property(__MultiCurve.value, __MultiCurve.set, None, u'A gml:MultiCurve is defined by one or more gml:AbstractCurves.\nThe members of the geometric aggregate may be specified either using the "standard" property (gml:curveMember) or the array property (gml:curveMembers). It is also valid to use both the "standard" and the array properties in the same collection.')

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_MultiCurvePropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_MultiCurvePropertyType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_MultiCurvePropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_MultiCurvePropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_MultiCurvePropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_MultiCurvePropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_MultiCurvePropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_MultiCurvePropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_MultiCurvePropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_MultiCurvePropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)


    _ElementMap = {
        __MultiCurve.name() : __MultiCurve
    }
    _AttributeMap = {
        __title.name() : __title,
        __owns.name() : __owns,
        __arcrole.name() : __arcrole,
        __remoteSchema.name() : __remoteSchema,
        __role.name() : __role,
        __show.name() : __show,
        __nilReason.name() : __nilReason,
        __actuate.name() : __actuate,
        __href.name() : __href,
        __type.name() : __type
    }
_Namespace_gml.addCategoryObject('typeBinding', u'MultiCurvePropertyType', MultiCurvePropertyType)


# Complex type MD_Resolution_Type with content type ELEMENT_ONLY
class MD_Resolution_Type (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_Resolution_Type')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}equivalentScale uses Python identifier equivalentScale
    __equivalentScale = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'equivalentScale'), 'equivalentScale', '__httpwww_isotc211_org2005gmd_MD_Resolution_Type_httpwww_isotc211_org2005gmdequivalentScale', False)

    
    equivalentScale = property(__equivalentScale.value, __equivalentScale.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}distance uses Python identifier distance
    __distance = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'distance'), 'distance', '__httpwww_isotc211_org2005gmd_MD_Resolution_Type_httpwww_isotc211_org2005gmddistance', False)

    
    distance = property(__distance.value, __distance.set, None, None)


    _ElementMap = {
        __equivalentScale.name() : __equivalentScale,
        __distance.name() : __distance
    }
    _AttributeMap = {
        
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_Resolution_Type', MD_Resolution_Type)


# Complex type MD_DigitalTransferOptions_Type with content type ELEMENT_ONLY
class MD_DigitalTransferOptions_Type (AbstractObject_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_DigitalTransferOptions_Type')
    # Base type is AbstractObject_Type
    
    # Element {http://www.isotc211.org/2005/gmd}offLine uses Python identifier offLine
    __offLine = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'offLine'), 'offLine', '__httpwww_isotc211_org2005gmd_MD_DigitalTransferOptions_Type_httpwww_isotc211_org2005gmdoffLine', False)

    
    offLine = property(__offLine.value, __offLine.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}unitsOfDistribution uses Python identifier unitsOfDistribution
    __unitsOfDistribution = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'unitsOfDistribution'), 'unitsOfDistribution', '__httpwww_isotc211_org2005gmd_MD_DigitalTransferOptions_Type_httpwww_isotc211_org2005gmdunitsOfDistribution', False)

    
    unitsOfDistribution = property(__unitsOfDistribution.value, __unitsOfDistribution.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}transferSize uses Python identifier transferSize
    __transferSize = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'transferSize'), 'transferSize', '__httpwww_isotc211_org2005gmd_MD_DigitalTransferOptions_Type_httpwww_isotc211_org2005gmdtransferSize', False)

    
    transferSize = property(__transferSize.value, __transferSize.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}onLine uses Python identifier onLine
    __onLine = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'onLine'), 'onLine', '__httpwww_isotc211_org2005gmd_MD_DigitalTransferOptions_Type_httpwww_isotc211_org2005gmdonLine', True)

    
    onLine = property(__onLine.value, __onLine.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractObject_Type._ElementMap.copy()
    _ElementMap.update({
        __offLine.name() : __offLine,
        __unitsOfDistribution.name() : __unitsOfDistribution,
        __transferSize.name() : __transferSize,
        __onLine.name() : __onLine
    })
    _AttributeMap = AbstractObject_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_DigitalTransferOptions_Type', MD_DigitalTransferOptions_Type)


# Complex type AbstractGeometryType with content type ELEMENT_ONLY
class AbstractGeometryType (AbstractGMLType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractGeometryType')
    # Base type is AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute srsName uses Python identifier srsName
    __srsName = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'srsName'), 'srsName', '__httpwww_opengis_netgml3_2_AbstractGeometryType_srsName', pyxb.binding.datatypes.anyURI)
    
    srsName = property(__srsName.value, __srsName.set, None, None)

    
    # Attribute axisLabels uses Python identifier axisLabels
    __axisLabels = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'axisLabels'), 'axisLabels', '__httpwww_opengis_netgml3_2_AbstractGeometryType_axisLabels', NCNameList)
    
    axisLabels = property(__axisLabels.value, __axisLabels.set, None, None)

    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute uomLabels uses Python identifier uomLabels
    __uomLabels = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uomLabels'), 'uomLabels', '__httpwww_opengis_netgml3_2_AbstractGeometryType_uomLabels', NCNameList)
    
    uomLabels = property(__uomLabels.value, __uomLabels.set, None, None)

    
    # Attribute srsDimension uses Python identifier srsDimension
    __srsDimension = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'srsDimension'), 'srsDimension', '__httpwww_opengis_netgml3_2_AbstractGeometryType_srsDimension', pyxb.binding.datatypes.positiveInteger)
    
    srsDimension = property(__srsDimension.value, __srsDimension.set, None, None)


    _ElementMap = AbstractGMLType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractGMLType._AttributeMap.copy()
    _AttributeMap.update({
        __srsName.name() : __srsName,
        __axisLabels.name() : __axisLabels,
        __uomLabels.name() : __uomLabels,
        __srsDimension.name() : __srsDimension
    })
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractGeometryType', AbstractGeometryType)


# Complex type OperationMethodPropertyType with content type ELEMENT_ONLY
class OperationMethodPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'OperationMethodPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}OperationMethod uses Python identifier OperationMethod
    __OperationMethod = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'OperationMethod'), 'OperationMethod', '__httpwww_opengis_netgml3_2_OperationMethodPropertyType_httpwww_opengis_netgml3_2OperationMethod', False)

    
    OperationMethod = property(__OperationMethod.value, __OperationMethod.set, None, u'gml:OperationMethod is a method (algorithm or procedure) used to perform a coordinate operation. Most operation methods use a number of operation parameters, although some coordinate conversions use none. Each coordinate operation using the method assigns values to these parameters.\nThe parameter elements are an unordered list of associations to the set of operation parameters and parameter groups used by this operation method.')

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_OperationMethodPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_OperationMethodPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_OperationMethodPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_OperationMethodPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_OperationMethodPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_OperationMethodPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_OperationMethodPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_OperationMethodPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_OperationMethodPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)


    _ElementMap = {
        __OperationMethod.name() : __OperationMethod
    }
    _AttributeMap = {
        __remoteSchema.name() : __remoteSchema,
        __href.name() : __href,
        __show.name() : __show,
        __title.name() : __title,
        __type.name() : __type,
        __nilReason.name() : __nilReason,
        __role.name() : __role,
        __actuate.name() : __actuate,
        __arcrole.name() : __arcrole
    }
_Namespace_gml.addCategoryObject('typeBinding', u'OperationMethodPropertyType', OperationMethodPropertyType)


# Complex type PT_FreeText_PropertyType with content type ELEMENT_ONLY
class PT_FreeText_PropertyType (CharacterString_PropertyType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'PT_FreeText_PropertyType')
    # Base type is CharacterString_PropertyType
    
    # Element {http://www.isotc211.org/2005/gmd}PT_FreeText uses Python identifier PT_FreeText
    __PT_FreeText = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'PT_FreeText'), 'PT_FreeText', '__httpwww_isotc211_org2005gmd_PT_FreeText_PropertyType_httpwww_isotc211_org2005gmdPT_FreeText', False)

    
    PT_FreeText = property(__PT_FreeText.value, __PT_FreeText.set, None, None)

    
    # Element CharacterString ({http://www.isotc211.org/2005/gco}CharacterString) inherited from {http://www.isotc211.org/2005/gco}CharacterString_PropertyType
    
    # Attribute nilReason inherited from {http://www.isotc211.org/2005/gco}CharacterString_PropertyType

    _ElementMap = CharacterString_PropertyType._ElementMap.copy()
    _ElementMap.update({
        __PT_FreeText.name() : __PT_FreeText
    })
    _AttributeMap = CharacterString_PropertyType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'PT_FreeText_PropertyType', PT_FreeText_PropertyType)


# Complex type BaseUnitType with content type ELEMENT_ONLY
class BaseUnitType (UnitDefinitionType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'BaseUnitType')
    # Base type is UnitDefinitionType
    
    # Element {http://www.opengis.net/gml/3.2}unitsSystem uses Python identifier unitsSystem
    __unitsSystem = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'unitsSystem'), 'unitsSystem', '__httpwww_opengis_netgml3_2_BaseUnitType_httpwww_opengis_netgml3_2unitsSystem', False)

    
    unitsSystem = property(__unitsSystem.value, __unitsSystem.set, None, None)

    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element catalogSymbol ({http://www.opengis.net/gml/3.2}catalogSymbol) inherited from {http://www.opengis.net/gml/3.2}UnitDefinitionType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element quantityType ({http://www.opengis.net/gml/3.2}quantityType) inherited from {http://www.opengis.net/gml/3.2}UnitDefinitionType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element quantityTypeReference ({http://www.opengis.net/gml/3.2}quantityTypeReference) inherited from {http://www.opengis.net/gml/3.2}UnitDefinitionType
    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType

    _ElementMap = UnitDefinitionType._ElementMap.copy()
    _ElementMap.update({
        __unitsSystem.name() : __unitsSystem
    })
    _AttributeMap = UnitDefinitionType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'BaseUnitType', BaseUnitType)


# Complex type MD_CharacterSetCode_PropertyType with content type ELEMENT_ONLY
class MD_CharacterSetCode_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_CharacterSetCode_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}MD_CharacterSetCode uses Python identifier MD_CharacterSetCode
    __MD_CharacterSetCode = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_CharacterSetCode'), 'MD_CharacterSetCode', '__httpwww_isotc211_org2005gmd_MD_CharacterSetCode_PropertyType_httpwww_isotc211_org2005gmdMD_CharacterSetCode', False)

    
    MD_CharacterSetCode = property(__MD_CharacterSetCode.value, __MD_CharacterSetCode.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_MD_CharacterSetCode_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        __MD_CharacterSetCode.name() : __MD_CharacterSetCode
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_CharacterSetCode_PropertyType', MD_CharacterSetCode_PropertyType)


# Complex type CI_ResponsibleParty_PropertyType with content type ELEMENT_ONLY
class CI_ResponsibleParty_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'CI_ResponsibleParty_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}CI_ResponsibleParty uses Python identifier CI_ResponsibleParty
    __CI_ResponsibleParty = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'CI_ResponsibleParty'), 'CI_ResponsibleParty', '__httpwww_isotc211_org2005gmd_CI_ResponsibleParty_PropertyType_httpwww_isotc211_org2005gmdCI_ResponsibleParty', False)

    
    CI_ResponsibleParty = property(__CI_ResponsibleParty.value, __CI_ResponsibleParty.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_CI_ResponsibleParty_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_CI_ResponsibleParty_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_CI_ResponsibleParty_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_CI_ResponsibleParty_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_CI_ResponsibleParty_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_CI_ResponsibleParty_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_CI_ResponsibleParty_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_CI_ResponsibleParty_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_CI_ResponsibleParty_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)


    _ElementMap = {
        __CI_ResponsibleParty.name() : __CI_ResponsibleParty
    }
    _AttributeMap = {
        __type.name() : __type,
        __arcrole.name() : __arcrole,
        __role.name() : __role,
        __title.name() : __title,
        __uuidref.name() : __uuidref,
        __nilReason.name() : __nilReason,
        __show.name() : __show,
        __actuate.name() : __actuate,
        __href.name() : __href
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'CI_ResponsibleParty_PropertyType', CI_ResponsibleParty_PropertyType)


# Complex type CI_Address_Type with content type ELEMENT_ONLY
class CI_Address_Type (AbstractObject_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'CI_Address_Type')
    # Base type is AbstractObject_Type
    
    # Element {http://www.isotc211.org/2005/gmd}city uses Python identifier city
    __city = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'city'), 'city', '__httpwww_isotc211_org2005gmd_CI_Address_Type_httpwww_isotc211_org2005gmdcity', False)

    
    city = property(__city.value, __city.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}deliveryPoint uses Python identifier deliveryPoint
    __deliveryPoint = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'deliveryPoint'), 'deliveryPoint', '__httpwww_isotc211_org2005gmd_CI_Address_Type_httpwww_isotc211_org2005gmddeliveryPoint', True)

    
    deliveryPoint = property(__deliveryPoint.value, __deliveryPoint.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}postalCode uses Python identifier postalCode
    __postalCode = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'postalCode'), 'postalCode', '__httpwww_isotc211_org2005gmd_CI_Address_Type_httpwww_isotc211_org2005gmdpostalCode', False)

    
    postalCode = property(__postalCode.value, __postalCode.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}administrativeArea uses Python identifier administrativeArea
    __administrativeArea = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'administrativeArea'), 'administrativeArea', '__httpwww_isotc211_org2005gmd_CI_Address_Type_httpwww_isotc211_org2005gmdadministrativeArea', False)

    
    administrativeArea = property(__administrativeArea.value, __administrativeArea.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}country uses Python identifier country
    __country = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'country'), 'country', '__httpwww_isotc211_org2005gmd_CI_Address_Type_httpwww_isotc211_org2005gmdcountry', False)

    
    country = property(__country.value, __country.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}electronicMailAddress uses Python identifier electronicMailAddress
    __electronicMailAddress = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'electronicMailAddress'), 'electronicMailAddress', '__httpwww_isotc211_org2005gmd_CI_Address_Type_httpwww_isotc211_org2005gmdelectronicMailAddress', True)

    
    electronicMailAddress = property(__electronicMailAddress.value, __electronicMailAddress.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractObject_Type._ElementMap.copy()
    _ElementMap.update({
        __city.name() : __city,
        __deliveryPoint.name() : __deliveryPoint,
        __postalCode.name() : __postalCode,
        __administrativeArea.name() : __administrativeArea,
        __country.name() : __country,
        __electronicMailAddress.name() : __electronicMailAddress
    })
    _AttributeMap = AbstractObject_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'CI_Address_Type', CI_Address_Type)


# Complex type EX_Extent_PropertyType with content type ELEMENT_ONLY
class EX_Extent_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'EX_Extent_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}EX_Extent uses Python identifier EX_Extent
    __EX_Extent = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'EX_Extent'), 'EX_Extent', '__httpwww_isotc211_org2005gmd_EX_Extent_PropertyType_httpwww_isotc211_org2005gmdEX_Extent', False)

    
    EX_Extent = property(__EX_Extent.value, __EX_Extent.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_EX_Extent_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_EX_Extent_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_EX_Extent_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_EX_Extent_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_EX_Extent_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_EX_Extent_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_EX_Extent_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_EX_Extent_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_EX_Extent_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")


    _ElementMap = {
        __EX_Extent.name() : __EX_Extent
    }
    _AttributeMap = {
        __type.name() : __type,
        __href.name() : __href,
        __actuate.name() : __actuate,
        __arcrole.name() : __arcrole,
        __uuidref.name() : __uuidref,
        __role.name() : __role,
        __nilReason.name() : __nilReason,
        __title.name() : __title,
        __show.name() : __show
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'EX_Extent_PropertyType', EX_Extent_PropertyType)


# Complex type FeaturePropertyType with content type ELEMENT_ONLY
class FeaturePropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'FeaturePropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}AbstractFeature uses Python identifier AbstractFeature
    __AbstractFeature = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractFeature'), 'AbstractFeature', '__httpwww_opengis_netgml3_2_FeaturePropertyType_httpwww_opengis_netgml3_2AbstractFeature', False)

    
    AbstractFeature = property(__AbstractFeature.value, __AbstractFeature.set, None, u'This abstract element serves as the head of a substitution group which may contain any elements whose content model is derived from gml:AbstractFeatureType.  This may be used as a variable in the construction of content models.  \ngml:AbstractFeature may be thought of as "anything that is a GML feature" and may be used to define variables or templates in which the value of a GML property is "any feature". This occurs in particular in a GML feature collection where the feature member properties contain one or multiple copies of gml:AbstractFeature respectively.')

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_FeaturePropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_FeaturePropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_FeaturePropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_FeaturePropertyType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_FeaturePropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_FeaturePropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_FeaturePropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_FeaturePropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_FeaturePropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_FeaturePropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)


    _ElementMap = {
        __AbstractFeature.name() : __AbstractFeature
    }
    _AttributeMap = {
        __remoteSchema.name() : __remoteSchema,
        __role.name() : __role,
        __show.name() : __show,
        __owns.name() : __owns,
        __actuate.name() : __actuate,
        __href.name() : __href,
        __nilReason.name() : __nilReason,
        __type.name() : __type,
        __arcrole.name() : __arcrole,
        __title.name() : __title
    }
_Namespace_gml.addCategoryObject('typeBinding', u'FeaturePropertyType', FeaturePropertyType)


# Complex type AbstractDQ_LogicalConsistency_Type with content type ELEMENT_ONLY
class AbstractDQ_LogicalConsistency_Type (AbstractDQ_Element_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'AbstractDQ_LogicalConsistency_Type')
    # Base type is AbstractDQ_Element_Type
    
    # Element evaluationMethodDescription ({http://www.isotc211.org/2005/gmd}evaluationMethodDescription) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element measureDescription ({http://www.isotc211.org/2005/gmd}measureDescription) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element evaluationProcedure ({http://www.isotc211.org/2005/gmd}evaluationProcedure) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element evaluationMethodType ({http://www.isotc211.org/2005/gmd}evaluationMethodType) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element dateTime ({http://www.isotc211.org/2005/gmd}dateTime) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element result ({http://www.isotc211.org/2005/gmd}result) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element nameOfMeasure ({http://www.isotc211.org/2005/gmd}nameOfMeasure) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element measureIdentification ({http://www.isotc211.org/2005/gmd}measureIdentification) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractDQ_Element_Type._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractDQ_Element_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'AbstractDQ_LogicalConsistency_Type', AbstractDQ_LogicalConsistency_Type)


# Complex type CoordinateSystemAxisType with content type ELEMENT_ONLY
class CoordinateSystemAxisType (IdentifiedObjectType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'CoordinateSystemAxisType')
    # Base type is IdentifiedObjectType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}axisDirection uses Python identifier axisDirection
    __axisDirection = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'axisDirection'), 'axisDirection', '__httpwww_opengis_netgml3_2_CoordinateSystemAxisType_httpwww_opengis_netgml3_2axisDirection', False)

    
    axisDirection = property(__axisDirection.value, __axisDirection.set, None, u'gml:axisDirection is the direction of this coordinate system axis (or in the case of Cartesian projected coordinates, the direction of this coordinate system axis at the origin).\nWithin any set of coordinate system axes, only one of each pair of terms may be used. For earth-fixed CRSs, this direction is often approximate and intended to provide a human interpretable meaning to the axis. When a geodetic datum is used, the precise directions of the axes may therefore vary slightly from this approximate direction.\nThe codeSpace attribute shall reference a source of information specifying the values and meanings of all the allowed string values for this property.')

    
    # Element {http://www.opengis.net/gml/3.2}rangeMeaning uses Python identifier rangeMeaning
    __rangeMeaning = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'rangeMeaning'), 'rangeMeaning', '__httpwww_opengis_netgml3_2_CoordinateSystemAxisType_httpwww_opengis_netgml3_2rangeMeaning', False)

    
    rangeMeaning = property(__rangeMeaning.value, __rangeMeaning.set, None, u'gml:rangeMeaning describes the meaning of axis value range specified by gml:minimumValue and gml:maximumValue. This element shall be omitted when both gml:minimumValue and gml:maximumValue are omitted. This element should be included when gml:minimumValue and/or gml:maximumValue are included. If this element is omitted when the gml:minimumValue and/or gml:maximumValue are included, the meaning is unspecified. The codeSpace attribute shall reference a source of information specifying the values and meanings of all the allowed string values for this property.')

    
    # Element {http://www.opengis.net/gml/3.2}minimumValue uses Python identifier minimumValue
    __minimumValue = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'minimumValue'), 'minimumValue', '__httpwww_opengis_netgml3_2_CoordinateSystemAxisType_httpwww_opengis_netgml3_2minimumValue', False)

    
    minimumValue = property(__minimumValue.value, __minimumValue.set, None, u'The gml:minimumValue and gml:maximumValue properties allow the specification of minimum and maximum value normally allowed for this axis, in the unit of measure for the axis. For a continuous angular axis such as longitude, the values wrap-around at this value. Also, values beyond this minimum/maximum can be used for specified purposes, such as in a bounding box. A value of minus infinity shall be allowed for the gml:minimumValue element, a value of plus infiniy for the gml:maximumValue element. If these elements are omitted, the value is unspecified.')

    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}maximumValue uses Python identifier maximumValue
    __maximumValue = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'maximumValue'), 'maximumValue', '__httpwww_opengis_netgml3_2_CoordinateSystemAxisType_httpwww_opengis_netgml3_2maximumValue', False)

    
    maximumValue = property(__maximumValue.value, __maximumValue.set, None, u'The gml:minimumValue and gml:maximumValue properties allow the specification of minimum and maximum value normally allowed for this axis, in the unit of measure for the axis. For a continuous angular axis such as longitude, the values wrap-around at this value. Also, values beyond this minimum/maximum can be used for specified purposes, such as in a bounding box. A value of minus infinity shall be allowed for the gml:minimumValue element, a value of plus infiniy for the gml:maximumValue element. If these elements are omitted, the value is unspecified.')

    
    # Element {http://www.opengis.net/gml/3.2}axisAbbrev uses Python identifier axisAbbrev
    __axisAbbrev = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'axisAbbrev'), 'axisAbbrev', '__httpwww_opengis_netgml3_2_CoordinateSystemAxisType_httpwww_opengis_netgml3_2axisAbbrev', False)

    
    axisAbbrev = property(__axisAbbrev.value, __axisAbbrev.set, None, u'gml:axisAbbrev is the abbreviation used for this coordinate system axis; this abbreviation is also used to identify the coordinates in the coordinate tuple. The codeSpace attribute may reference a source of more information on a set of standardized abbreviations, or on this abbreviation.')

    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType
    
    # Attribute uom uses Python identifier uom
    __uom = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uom'), 'uom', '__httpwww_opengis_netgml3_2_CoordinateSystemAxisType_uom', UomIdentifier, required=True)
    
    uom = property(__uom.value, __uom.set, None, u'The uom attribute provides an identifier of the unit of measure used for this coordinate system axis. The value of this coordinate in a coordinate tuple shall be recorded using this unit of measure, whenever those coordinates use a coordinate reference system that uses a coordinate system that uses this axis.')


    _ElementMap = IdentifiedObjectType._ElementMap.copy()
    _ElementMap.update({
        __axisDirection.name() : __axisDirection,
        __rangeMeaning.name() : __rangeMeaning,
        __minimumValue.name() : __minimumValue,
        __maximumValue.name() : __maximumValue,
        __axisAbbrev.name() : __axisAbbrev
    })
    _AttributeMap = IdentifiedObjectType._AttributeMap.copy()
    _AttributeMap.update({
        __uom.name() : __uom
    })
_Namespace_gml.addCategoryObject('typeBinding', u'CoordinateSystemAxisType', CoordinateSystemAxisType)


# Complex type TopoCurveType with content type ELEMENT_ONLY
class TopoCurveType (AbstractTopologyType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'TopoCurveType')
    # Base type is AbstractTopologyType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}directedEdge uses Python identifier directedEdge
    __directedEdge = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'directedEdge'), 'directedEdge', '__httpwww_opengis_netgml3_2_TopoCurveType_httpwww_opengis_netgml3_2directedEdge', True)

    
    directedEdge = property(__directedEdge.value, __directedEdge.set, None, u'A gml:directedEdge property element describes the boundary of topology faces, the coBoundary of topology nodes and is used in the support of topological line features via the gml:TopoCurve expression, see below. The orientation attribute of type gml:SignType expresses the sense in which the included edge is used, i.e. forward or reverse.')

    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute aggregationType uses Python identifier aggregationType
    __aggregationType = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'aggregationType'), 'aggregationType', '__httpwww_opengis_netgml3_2_TopoCurveType_aggregationType', AggregationType)
    
    aggregationType = property(__aggregationType.value, __aggregationType.set, None, None)

    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType

    _ElementMap = AbstractTopologyType._ElementMap.copy()
    _ElementMap.update({
        __directedEdge.name() : __directedEdge
    })
    _AttributeMap = AbstractTopologyType._AttributeMap.copy()
    _AttributeMap.update({
        __aggregationType.name() : __aggregationType
    })
_Namespace_gml.addCategoryObject('typeBinding', u'TopoCurveType', TopoCurveType)


# Complex type CRSPropertyType with content type ELEMENT_ONLY
class CRSPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'CRSPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}AbstractCRS uses Python identifier AbstractCRS
    __AbstractCRS = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractCRS'), 'AbstractCRS', '__httpwww_opengis_netgml3_2_CRSPropertyType_httpwww_opengis_netgml3_2AbstractCRS', False)

    
    AbstractCRS = property(__AbstractCRS.value, __AbstractCRS.set, None, u'gml:AbstractCRS specifies a coordinate reference system which is usually single but may be compound. This abstract complex type shall not be used, extended, or restricted, in a GML Application Schema, to define a concrete subtype with a meaning equivalent to a concrete subtype specified in this document.')

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_CRSPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_CRSPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_CRSPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_CRSPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_CRSPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_CRSPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_CRSPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_CRSPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_CRSPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')


    _ElementMap = {
        __AbstractCRS.name() : __AbstractCRS
    }
    _AttributeMap = {
        __arcrole.name() : __arcrole,
        __role.name() : __role,
        __title.name() : __title,
        __show.name() : __show,
        __actuate.name() : __actuate,
        __nilReason.name() : __nilReason,
        __href.name() : __href,
        __type.name() : __type,
        __remoteSchema.name() : __remoteSchema
    }
_Namespace_gml.addCategoryObject('typeBinding', u'CRSPropertyType', CRSPropertyType)


# Complex type DirectPositionListType with content type SIMPLE
class DirectPositionListType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = doubleList
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_SIMPLE
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'DirectPositionListType')
    # Base type is doubleList
    
    # Attribute count uses Python identifier count
    __count = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'count'), 'count', '__httpwww_opengis_netgml3_2_DirectPositionListType_count', pyxb.binding.datatypes.positiveInteger)
    
    count = property(__count.value, __count.set, None, None)

    
    # Attribute srsName uses Python identifier srsName
    __srsName = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'srsName'), 'srsName', '__httpwww_opengis_netgml3_2_DirectPositionListType_srsName', pyxb.binding.datatypes.anyURI)
    
    srsName = property(__srsName.value, __srsName.set, None, None)

    
    # Attribute srsDimension uses Python identifier srsDimension
    __srsDimension = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'srsDimension'), 'srsDimension', '__httpwww_opengis_netgml3_2_DirectPositionListType_srsDimension', pyxb.binding.datatypes.positiveInteger)
    
    srsDimension = property(__srsDimension.value, __srsDimension.set, None, None)

    
    # Attribute axisLabels uses Python identifier axisLabels
    __axisLabels = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'axisLabels'), 'axisLabels', '__httpwww_opengis_netgml3_2_DirectPositionListType_axisLabels', NCNameList)
    
    axisLabels = property(__axisLabels.value, __axisLabels.set, None, None)

    
    # Attribute uomLabels uses Python identifier uomLabels
    __uomLabels = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uomLabels'), 'uomLabels', '__httpwww_opengis_netgml3_2_DirectPositionListType_uomLabels', NCNameList)
    
    uomLabels = property(__uomLabels.value, __uomLabels.set, None, None)


    _ElementMap = {
        
    }
    _AttributeMap = {
        __count.name() : __count,
        __srsName.name() : __srsName,
        __srsDimension.name() : __srsDimension,
        __axisLabels.name() : __axisLabels,
        __uomLabels.name() : __uomLabels
    }
_Namespace_gml.addCategoryObject('typeBinding', u'DirectPositionListType', DirectPositionListType)


# Complex type SingleCRSPropertyType with content type ELEMENT_ONLY
class SingleCRSPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'SingleCRSPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}AbstractSingleCRS uses Python identifier AbstractSingleCRS
    __AbstractSingleCRS = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractSingleCRS'), 'AbstractSingleCRS', '__httpwww_opengis_netgml3_2_SingleCRSPropertyType_httpwww_opengis_netgml3_2AbstractSingleCRS', False)

    
    AbstractSingleCRS = property(__AbstractSingleCRS.value, __AbstractSingleCRS.set, None, u'gml:AbstractSingleCRS implements a coordinate reference system consisting of one coordinate system and one datum (as opposed to a Compound CRS).')

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_SingleCRSPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_SingleCRSPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_SingleCRSPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_SingleCRSPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_SingleCRSPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_SingleCRSPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_SingleCRSPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_SingleCRSPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_SingleCRSPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")


    _ElementMap = {
        __AbstractSingleCRS.name() : __AbstractSingleCRS
    }
    _AttributeMap = {
        __remoteSchema.name() : __remoteSchema,
        __actuate.name() : __actuate,
        __title.name() : __title,
        __href.name() : __href,
        __type.name() : __type,
        __nilReason.name() : __nilReason,
        __arcrole.name() : __arcrole,
        __role.name() : __role,
        __show.name() : __show
    }
_Namespace_gml.addCategoryObject('typeBinding', u'SingleCRSPropertyType', SingleCRSPropertyType)


# Complex type DQ_FormatConsistency_Type with content type ELEMENT_ONLY
class DQ_FormatConsistency_Type (AbstractDQ_LogicalConsistency_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'DQ_FormatConsistency_Type')
    # Base type is AbstractDQ_LogicalConsistency_Type
    
    # Element evaluationMethodDescription ({http://www.isotc211.org/2005/gmd}evaluationMethodDescription) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element measureDescription ({http://www.isotc211.org/2005/gmd}measureDescription) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element evaluationProcedure ({http://www.isotc211.org/2005/gmd}evaluationProcedure) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element evaluationMethodType ({http://www.isotc211.org/2005/gmd}evaluationMethodType) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element dateTime ({http://www.isotc211.org/2005/gmd}dateTime) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element result ({http://www.isotc211.org/2005/gmd}result) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element nameOfMeasure ({http://www.isotc211.org/2005/gmd}nameOfMeasure) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element measureIdentification ({http://www.isotc211.org/2005/gmd}measureIdentification) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractDQ_LogicalConsistency_Type._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractDQ_LogicalConsistency_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'DQ_FormatConsistency_Type', DQ_FormatConsistency_Type)


# Complex type PolygonPatchType with content type ELEMENT_ONLY
class PolygonPatchType (AbstractSurfacePatchType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'PolygonPatchType')
    # Base type is AbstractSurfacePatchType
    
    # Element {http://www.opengis.net/gml/3.2}interior uses Python identifier interior
    __interior = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'interior'), 'interior', '__httpwww_opengis_netgml3_2_PolygonPatchType_httpwww_opengis_netgml3_2interior', True)

    
    interior = property(__interior.value, __interior.set, None, u'A boundary of a surface consists of a number of rings. The "interior" rings separate the surface / surface patch from the area enclosed by the rings.')

    
    # Element {http://www.opengis.net/gml/3.2}exterior uses Python identifier exterior
    __exterior = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'exterior'), 'exterior', '__httpwww_opengis_netgml3_2_PolygonPatchType_httpwww_opengis_netgml3_2exterior', False)

    
    exterior = property(__exterior.value, __exterior.set, None, u'A boundary of a surface consists of a number of rings. In the normal 2D case, one of these rings is distinguished as being the exterior boundary. In a general manifold this is not always possible, in which case all boundaries shall be listed as interior boundaries, and the exterior will be empty.')

    
    # Attribute interpolation uses Python identifier interpolation
    __interpolation = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'interpolation'), 'interpolation', '__httpwww_opengis_netgml3_2_PolygonPatchType_interpolation', SurfaceInterpolationType, fixed=True, unicode_default=u'planar')
    
    interpolation = property(__interpolation.value, __interpolation.set, None, None)


    _ElementMap = AbstractSurfacePatchType._ElementMap.copy()
    _ElementMap.update({
        __interior.name() : __interior,
        __exterior.name() : __exterior
    })
    _AttributeMap = AbstractSurfacePatchType._AttributeMap.copy()
    _AttributeMap.update({
        __interpolation.name() : __interpolation
    })
_Namespace_gml.addCategoryObject('typeBinding', u'PolygonPatchType', PolygonPatchType)


# Complex type AbstractGeometricAggregateType with content type ELEMENT_ONLY
class AbstractGeometricAggregateType (AbstractGeometryType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractGeometricAggregateType')
    # Base type is AbstractGeometryType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute uomLabels inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute aggregationType uses Python identifier aggregationType
    __aggregationType = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'aggregationType'), 'aggregationType', '__httpwww_opengis_netgml3_2_AbstractGeometricAggregateType_aggregationType', AggregationType)
    
    aggregationType = property(__aggregationType.value, __aggregationType.set, None, None)

    
    # Attribute srsName inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute srsDimension inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute axisLabels inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType

    _ElementMap = AbstractGeometryType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractGeometryType._AttributeMap.copy()
    _AttributeMap.update({
        __aggregationType.name() : __aggregationType
    })
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractGeometricAggregateType', AbstractGeometricAggregateType)


# Complex type Boolean_PropertyType with content type ELEMENT_ONLY
class Boolean_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gco, u'Boolean_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gco}Boolean uses Python identifier Boolean
    __Boolean = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'Boolean'), 'Boolean', '__httpwww_isotc211_org2005gco_Boolean_PropertyType_httpwww_isotc211_org2005gcoBoolean', False)

    
    Boolean = property(__Boolean.value, __Boolean.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gco_Boolean_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        __Boolean.name() : __Boolean
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason
    }
_Namespace_gco.addCategoryObject('typeBinding', u'Boolean_PropertyType', Boolean_PropertyType)


# Complex type EX_TemporalExtent_Type with content type ELEMENT_ONLY
class EX_TemporalExtent_Type (AbstractObject_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'EX_TemporalExtent_Type')
    # Base type is AbstractObject_Type
    
    # Element {http://www.isotc211.org/2005/gmd}extent uses Python identifier extent
    __extent = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'extent'), 'extent', '__httpwww_isotc211_org2005gmd_EX_TemporalExtent_Type_httpwww_isotc211_org2005gmdextent', False)

    
    extent = property(__extent.value, __extent.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractObject_Type._ElementMap.copy()
    _ElementMap.update({
        __extent.name() : __extent
    })
    _AttributeMap = AbstractObject_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'EX_TemporalExtent_Type', EX_TemporalExtent_Type)


# Complex type EX_SpatialTemporalExtent_Type with content type ELEMENT_ONLY
class EX_SpatialTemporalExtent_Type (EX_TemporalExtent_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'EX_SpatialTemporalExtent_Type')
    # Base type is EX_TemporalExtent_Type
    
    # Element {http://www.isotc211.org/2005/gmd}spatialExtent uses Python identifier spatialExtent
    __spatialExtent = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'spatialExtent'), 'spatialExtent', '__httpwww_isotc211_org2005gmd_EX_SpatialTemporalExtent_Type_httpwww_isotc211_org2005gmdspatialExtent', True)

    
    spatialExtent = property(__spatialExtent.value, __spatialExtent.set, None, None)

    
    # Element extent ({http://www.isotc211.org/2005/gmd}extent) inherited from {http://www.isotc211.org/2005/gmd}EX_TemporalExtent_Type
    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = EX_TemporalExtent_Type._ElementMap.copy()
    _ElementMap.update({
        __spatialExtent.name() : __spatialExtent
    })
    _AttributeMap = EX_TemporalExtent_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'EX_SpatialTemporalExtent_Type', EX_SpatialTemporalExtent_Type)


# Complex type MD_DimensionNameTypeCode_PropertyType with content type ELEMENT_ONLY
class MD_DimensionNameTypeCode_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_DimensionNameTypeCode_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}MD_DimensionNameTypeCode uses Python identifier MD_DimensionNameTypeCode
    __MD_DimensionNameTypeCode = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_DimensionNameTypeCode'), 'MD_DimensionNameTypeCode', '__httpwww_isotc211_org2005gmd_MD_DimensionNameTypeCode_PropertyType_httpwww_isotc211_org2005gmdMD_DimensionNameTypeCode', False)

    
    MD_DimensionNameTypeCode = property(__MD_DimensionNameTypeCode.value, __MD_DimensionNameTypeCode.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_MD_DimensionNameTypeCode_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        __MD_DimensionNameTypeCode.name() : __MD_DimensionNameTypeCode
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_DimensionNameTypeCode_PropertyType', MD_DimensionNameTypeCode_PropertyType)


# Complex type CI_Citation_PropertyType with content type ELEMENT_ONLY
class CI_Citation_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'CI_Citation_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}CI_Citation uses Python identifier CI_Citation
    __CI_Citation = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'CI_Citation'), 'CI_Citation', '__httpwww_isotc211_org2005gmd_CI_Citation_PropertyType_httpwww_isotc211_org2005gmdCI_Citation', False)

    
    CI_Citation = property(__CI_Citation.value, __CI_Citation.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_CI_Citation_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_CI_Citation_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_CI_Citation_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_CI_Citation_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_CI_Citation_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_CI_Citation_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_CI_Citation_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_CI_Citation_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_CI_Citation_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")


    _ElementMap = {
        __CI_Citation.name() : __CI_Citation
    }
    _AttributeMap = {
        __arcrole.name() : __arcrole,
        __type.name() : __type,
        __role.name() : __role,
        __href.name() : __href,
        __nilReason.name() : __nilReason,
        __show.name() : __show,
        __uuidref.name() : __uuidref,
        __title.name() : __title,
        __actuate.name() : __actuate
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'CI_Citation_PropertyType', CI_Citation_PropertyType)


# Complex type PolarCSPropertyType with content type ELEMENT_ONLY
class PolarCSPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'PolarCSPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}PolarCS uses Python identifier PolarCS
    __PolarCS = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'PolarCS'), 'PolarCS', '__httpwww_opengis_netgml3_2_PolarCSPropertyType_httpwww_opengis_netgml3_2PolarCS', False)

    
    PolarCS = property(__PolarCS.value, __PolarCS.set, None, u'gml:PolarCS ia s two-dimensional coordinate system in which position is specified by the distance from the origin and the angle between the line from the origin to a point and a reference direction. A PolarCS shall have two gml:axis property elements.')

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_PolarCSPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_PolarCSPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_PolarCSPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_PolarCSPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_PolarCSPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_PolarCSPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_PolarCSPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_PolarCSPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_PolarCSPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")


    _ElementMap = {
        __PolarCS.name() : __PolarCS
    }
    _AttributeMap = {
        __remoteSchema.name() : __remoteSchema,
        __type.name() : __type,
        __actuate.name() : __actuate,
        __href.name() : __href,
        __nilReason.name() : __nilReason,
        __title.name() : __title,
        __arcrole.name() : __arcrole,
        __role.name() : __role,
        __show.name() : __show
    }
_Namespace_gml.addCategoryObject('typeBinding', u'PolarCSPropertyType', PolarCSPropertyType)


# Complex type VectorType with content type SIMPLE
class VectorType (DirectPositionType):
    _TypeDefinition = STD_ANON_5
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_SIMPLE
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'VectorType')
    # Base type is DirectPositionType
    
    # Attribute srsName inherited from {http://www.opengis.net/gml/3.2}DirectPositionType
    
    # Attribute axisLabels inherited from {http://www.opengis.net/gml/3.2}DirectPositionType
    
    # Attribute uomLabels inherited from {http://www.opengis.net/gml/3.2}DirectPositionType
    
    # Attribute srsDimension inherited from {http://www.opengis.net/gml/3.2}DirectPositionType

    _ElementMap = DirectPositionType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = DirectPositionType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'VectorType', VectorType)


# Complex type CI_Date_PropertyType with content type ELEMENT_ONLY
class CI_Date_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'CI_Date_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}CI_Date uses Python identifier CI_Date
    __CI_Date = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'CI_Date'), 'CI_Date', '__httpwww_isotc211_org2005gmd_CI_Date_PropertyType_httpwww_isotc211_org2005gmdCI_Date', False)

    
    CI_Date = property(__CI_Date.value, __CI_Date.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_CI_Date_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_CI_Date_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_CI_Date_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_CI_Date_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_CI_Date_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_CI_Date_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_CI_Date_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_CI_Date_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_CI_Date_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)


    _ElementMap = {
        __CI_Date.name() : __CI_Date
    }
    _AttributeMap = {
        __type.name() : __type,
        __nilReason.name() : __nilReason,
        __actuate.name() : __actuate,
        __show.name() : __show,
        __href.name() : __href,
        __uuidref.name() : __uuidref,
        __role.name() : __role,
        __title.name() : __title,
        __arcrole.name() : __arcrole
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'CI_Date_PropertyType', CI_Date_PropertyType)


# Complex type DQ_DomainConsistency_Type with content type ELEMENT_ONLY
class DQ_DomainConsistency_Type (AbstractDQ_LogicalConsistency_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'DQ_DomainConsistency_Type')
    # Base type is AbstractDQ_LogicalConsistency_Type
    
    # Element evaluationMethodDescription ({http://www.isotc211.org/2005/gmd}evaluationMethodDescription) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element measureDescription ({http://www.isotc211.org/2005/gmd}measureDescription) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element evaluationProcedure ({http://www.isotc211.org/2005/gmd}evaluationProcedure) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element evaluationMethodType ({http://www.isotc211.org/2005/gmd}evaluationMethodType) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element dateTime ({http://www.isotc211.org/2005/gmd}dateTime) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element result ({http://www.isotc211.org/2005/gmd}result) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element nameOfMeasure ({http://www.isotc211.org/2005/gmd}nameOfMeasure) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element measureIdentification ({http://www.isotc211.org/2005/gmd}measureIdentification) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractDQ_LogicalConsistency_Type._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractDQ_LogicalConsistency_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'DQ_DomainConsistency_Type', DQ_DomainConsistency_Type)


# Complex type CylindricalCSPropertyType with content type ELEMENT_ONLY
class CylindricalCSPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'CylindricalCSPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}CylindricalCS uses Python identifier CylindricalCS
    __CylindricalCS = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'CylindricalCS'), 'CylindricalCS', '__httpwww_opengis_netgml3_2_CylindricalCSPropertyType_httpwww_opengis_netgml3_2CylindricalCS', False)

    
    CylindricalCS = property(__CylindricalCS.value, __CylindricalCS.set, None, u'gml:CylindricalCS is a three-dimensional coordinate system consisting of a polar coordinate system extended by a straight coordinate axis perpendicular to the plane spanned by the polar coordinate system. A CylindricalCS shall have three gml:axis property elements.')

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_CylindricalCSPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_CylindricalCSPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_CylindricalCSPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_CylindricalCSPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_CylindricalCSPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_CylindricalCSPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_CylindricalCSPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_CylindricalCSPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_CylindricalCSPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)


    _ElementMap = {
        __CylindricalCS.name() : __CylindricalCS
    }
    _AttributeMap = {
        __title.name() : __title,
        __role.name() : __role,
        __arcrole.name() : __arcrole,
        __remoteSchema.name() : __remoteSchema,
        __show.name() : __show,
        __nilReason.name() : __nilReason,
        __actuate.name() : __actuate,
        __href.name() : __href,
        __type.name() : __type
    }
_Namespace_gml.addCategoryObject('typeBinding', u'CylindricalCSPropertyType', CylindricalCSPropertyType)


# Complex type MD_SpatialRepresentation_PropertyType with content type ELEMENT_ONLY
class MD_SpatialRepresentation_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_SpatialRepresentation_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}AbstractMD_SpatialRepresentation uses Python identifier AbstractMD_SpatialRepresentation
    __AbstractMD_SpatialRepresentation = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'AbstractMD_SpatialRepresentation'), 'AbstractMD_SpatialRepresentation', '__httpwww_isotc211_org2005gmd_MD_SpatialRepresentation_PropertyType_httpwww_isotc211_org2005gmdAbstractMD_SpatialRepresentation', False)

    
    AbstractMD_SpatialRepresentation = property(__AbstractMD_SpatialRepresentation.value, __AbstractMD_SpatialRepresentation.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_MD_SpatialRepresentation_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_MD_SpatialRepresentation_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_MD_SpatialRepresentation_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_MD_SpatialRepresentation_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_MD_SpatialRepresentation_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_MD_SpatialRepresentation_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_MD_SpatialRepresentation_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_MD_SpatialRepresentation_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_MD_SpatialRepresentation_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)


    _ElementMap = {
        __AbstractMD_SpatialRepresentation.name() : __AbstractMD_SpatialRepresentation
    }
    _AttributeMap = {
        __type.name() : __type,
        __nilReason.name() : __nilReason,
        __title.name() : __title,
        __show.name() : __show,
        __href.name() : __href,
        __uuidref.name() : __uuidref,
        __actuate.name() : __actuate,
        __role.name() : __role,
        __arcrole.name() : __arcrole
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_SpatialRepresentation_PropertyType', MD_SpatialRepresentation_PropertyType)


# Complex type ConcatenatedOperationType with content type ELEMENT_ONLY
class ConcatenatedOperationType (AbstractCoordinateOperationType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'ConcatenatedOperationType')
    # Base type is AbstractCoordinateOperationType
    
    # Element sourceCRS ({http://www.opengis.net/gml/3.2}sourceCRS) inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateOperationType
    
    # Element targetCRS ({http://www.opengis.net/gml/3.2}targetCRS) inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateOperationType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element operationVersion ({http://www.opengis.net/gml/3.2}operationVersion) inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateOperationType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element scope ({http://www.opengis.net/gml/3.2}scope) inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateOperationType
    
    # Element {http://www.opengis.net/gml/3.2}coordOperation uses Python identifier coordOperation
    __coordOperation = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'coordOperation'), 'coordOperation', '__httpwww_opengis_netgml3_2_ConcatenatedOperationType_httpwww_opengis_netgml3_2coordOperation', True)

    
    coordOperation = property(__coordOperation.value, __coordOperation.set, None, u'gml:coordOperation is an association role to a coordinate operation.')

    
    # Element domainOfValidity ({http://www.opengis.net/gml/3.2}domainOfValidity) inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateOperationType
    
    # Element coordinateOperationAccuracy ({http://www.opengis.net/gml/3.2}coordinateOperationAccuracy) inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateOperationType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Attribute aggregationType uses Python identifier aggregationType
    __aggregationType = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'aggregationType'), 'aggregationType', '__httpwww_opengis_netgml3_2_ConcatenatedOperationType_aggregationType', AggregationType)
    
    aggregationType = property(__aggregationType.value, __aggregationType.set, None, None)

    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType

    _ElementMap = AbstractCoordinateOperationType._ElementMap.copy()
    _ElementMap.update({
        __coordOperation.name() : __coordOperation
    })
    _AttributeMap = AbstractCoordinateOperationType._AttributeMap.copy()
    _AttributeMap.update({
        __aggregationType.name() : __aggregationType
    })
_Namespace_gml.addCategoryObject('typeBinding', u'ConcatenatedOperationType', ConcatenatedOperationType)


# Complex type GridFunctionType with content type ELEMENT_ONLY
class GridFunctionType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'GridFunctionType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}startPoint uses Python identifier startPoint
    __startPoint = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'startPoint'), 'startPoint', '__httpwww_opengis_netgml3_2_GridFunctionType_httpwww_opengis_netgml3_2startPoint', False)

    
    startPoint = property(__startPoint.value, __startPoint.set, None, None)

    
    # Element {http://www.opengis.net/gml/3.2}sequenceRule uses Python identifier sequenceRule
    __sequenceRule = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'sequenceRule'), 'sequenceRule', '__httpwww_opengis_netgml3_2_GridFunctionType_httpwww_opengis_netgml3_2sequenceRule', False)

    
    sequenceRule = property(__sequenceRule.value, __sequenceRule.set, None, None)


    _ElementMap = {
        __startPoint.name() : __startPoint,
        __sequenceRule.name() : __sequenceRule
    }
    _AttributeMap = {
        
    }
_Namespace_gml.addCategoryObject('typeBinding', u'GridFunctionType', GridFunctionType)


# Complex type CI_Telephone_Type with content type ELEMENT_ONLY
class CI_Telephone_Type (AbstractObject_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'CI_Telephone_Type')
    # Base type is AbstractObject_Type
    
    # Element {http://www.isotc211.org/2005/gmd}facsimile uses Python identifier facsimile
    __facsimile = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'facsimile'), 'facsimile', '__httpwww_isotc211_org2005gmd_CI_Telephone_Type_httpwww_isotc211_org2005gmdfacsimile', True)

    
    facsimile = property(__facsimile.value, __facsimile.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}voice uses Python identifier voice
    __voice = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'voice'), 'voice', '__httpwww_isotc211_org2005gmd_CI_Telephone_Type_httpwww_isotc211_org2005gmdvoice', True)

    
    voice = property(__voice.value, __voice.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractObject_Type._ElementMap.copy()
    _ElementMap.update({
        __facsimile.name() : __facsimile,
        __voice.name() : __voice
    })
    _AttributeMap = AbstractObject_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'CI_Telephone_Type', CI_Telephone_Type)


# Complex type MD_DataIdentification_PropertyType with content type ELEMENT_ONLY
class MD_DataIdentification_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_DataIdentification_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}MD_DataIdentification uses Python identifier MD_DataIdentification
    __MD_DataIdentification = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_DataIdentification'), 'MD_DataIdentification', '__httpwww_isotc211_org2005gmd_MD_DataIdentification_PropertyType_httpwww_isotc211_org2005gmdMD_DataIdentification', False)

    
    MD_DataIdentification = property(__MD_DataIdentification.value, __MD_DataIdentification.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_MD_DataIdentification_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_MD_DataIdentification_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_MD_DataIdentification_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_MD_DataIdentification_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_MD_DataIdentification_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_MD_DataIdentification_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_MD_DataIdentification_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_MD_DataIdentification_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_MD_DataIdentification_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)


    _ElementMap = {
        __MD_DataIdentification.name() : __MD_DataIdentification
    }
    _AttributeMap = {
        __role.name() : __role,
        __type.name() : __type,
        __arcrole.name() : __arcrole,
        __title.name() : __title,
        __uuidref.name() : __uuidref,
        __nilReason.name() : __nilReason,
        __show.name() : __show,
        __actuate.name() : __actuate,
        __href.name() : __href
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_DataIdentification_PropertyType', MD_DataIdentification_PropertyType)


# Complex type CI_PresentationFormCode_PropertyType with content type ELEMENT_ONLY
class CI_PresentationFormCode_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'CI_PresentationFormCode_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}CI_PresentationFormCode uses Python identifier CI_PresentationFormCode
    __CI_PresentationFormCode = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'CI_PresentationFormCode'), 'CI_PresentationFormCode', '__httpwww_isotc211_org2005gmd_CI_PresentationFormCode_PropertyType_httpwww_isotc211_org2005gmdCI_PresentationFormCode', False)

    
    CI_PresentationFormCode = property(__CI_PresentationFormCode.value, __CI_PresentationFormCode.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_CI_PresentationFormCode_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        __CI_PresentationFormCode.name() : __CI_PresentationFormCode
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'CI_PresentationFormCode_PropertyType', CI_PresentationFormCode_PropertyType)


# Complex type OperationParameterPropertyType with content type ELEMENT_ONLY
class OperationParameterPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'OperationParameterPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}OperationParameter uses Python identifier OperationParameter
    __OperationParameter = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'OperationParameter'), 'OperationParameter', '__httpwww_opengis_netgml3_2_OperationParameterPropertyType_httpwww_opengis_netgml3_2OperationParameter', False)

    
    OperationParameter = property(__OperationParameter.value, __OperationParameter.set, None, u'gml:OperationParameter is the definition of a parameter used by an operation method. Most parameter values are numeric, but other types of parameter values are possible. This complex type is expected to be used or extended for all operation methods, without defining operation-method-specialized element names.')

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_OperationParameterPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_OperationParameterPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_OperationParameterPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_OperationParameterPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_OperationParameterPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_OperationParameterPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_OperationParameterPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_OperationParameterPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_OperationParameterPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")


    _ElementMap = {
        __OperationParameter.name() : __OperationParameter
    }
    _AttributeMap = {
        __arcrole.name() : __arcrole,
        __remoteSchema.name() : __remoteSchema,
        __href.name() : __href,
        __type.name() : __type,
        __title.name() : __title,
        __nilReason.name() : __nilReason,
        __role.name() : __role,
        __show.name() : __show,
        __actuate.name() : __actuate
    }
_Namespace_gml.addCategoryObject('typeBinding', u'OperationParameterPropertyType', OperationParameterPropertyType)


# Complex type TM_PeriodDuration_PropertyType with content type ELEMENT_ONLY
class TM_PeriodDuration_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gts, u'TM_PeriodDuration_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gts}TM_PeriodDuration uses Python identifier TM_PeriodDuration
    __TM_PeriodDuration = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gts, u'TM_PeriodDuration'), 'TM_PeriodDuration', '__httpwww_isotc211_org2005gts_TM_PeriodDuration_PropertyType_httpwww_isotc211_org2005gtsTM_PeriodDuration', False)

    
    TM_PeriodDuration = property(__TM_PeriodDuration.value, __TM_PeriodDuration.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gts_TM_PeriodDuration_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        __TM_PeriodDuration.name() : __TM_PeriodDuration
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason
    }
_Namespace_gts.addCategoryObject('typeBinding', u'TM_PeriodDuration_PropertyType', TM_PeriodDuration_PropertyType)


# Complex type AbstractGeneralOperationParameterType with content type ELEMENT_ONLY
class AbstractGeneralOperationParameterType (IdentifiedObjectType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractGeneralOperationParameterType')
    # Base type is IdentifiedObjectType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}minimumOccurs uses Python identifier minimumOccurs
    __minimumOccurs = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'minimumOccurs'), 'minimumOccurs', '__httpwww_opengis_netgml3_2_AbstractGeneralOperationParameterType_httpwww_opengis_netgml3_2minimumOccurs', False)

    
    minimumOccurs = property(__minimumOccurs.value, __minimumOccurs.set, None, u'gml:minimumOccurs is the minimum number of times that values for this parameter group or parameter are required. If this attribute is omitted, the minimum number shall be one.')

    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType

    _ElementMap = IdentifiedObjectType._ElementMap.copy()
    _ElementMap.update({
        __minimumOccurs.name() : __minimumOccurs
    })
    _AttributeMap = IdentifiedObjectType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractGeneralOperationParameterType', AbstractGeneralOperationParameterType)


# Complex type OperationParameterGroupType with content type ELEMENT_ONLY
class OperationParameterGroupType (AbstractGeneralOperationParameterType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'OperationParameterGroupType')
    # Base type is AbstractGeneralOperationParameterType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}maximumOccurs uses Python identifier maximumOccurs
    __maximumOccurs = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'maximumOccurs'), 'maximumOccurs', '__httpwww_opengis_netgml3_2_OperationParameterGroupType_httpwww_opengis_netgml3_2maximumOccurs', False)

    
    maximumOccurs = property(__maximumOccurs.value, __maximumOccurs.set, None, u'gml:maximumOccurs is the maximum number of times that values for this parameter group may be included. If this attribute is omitted, the maximum number shall be one.')

    
    # Element {http://www.opengis.net/gml/3.2}parameter uses Python identifier parameter
    __parameter = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'parameter'), 'parameter', '__httpwww_opengis_netgml3_2_OperationParameterGroupType_httpwww_opengis_netgml3_2parameter', True)

    
    parameter = property(__parameter.value, __parameter.set, None, u'gml:parameter is an association to an operation parameter or parameter group.')

    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element minimumOccurs ({http://www.opengis.net/gml/3.2}minimumOccurs) inherited from {http://www.opengis.net/gml/3.2}AbstractGeneralOperationParameterType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType

    _ElementMap = AbstractGeneralOperationParameterType._ElementMap.copy()
    _ElementMap.update({
        __maximumOccurs.name() : __maximumOccurs,
        __parameter.name() : __parameter
    })
    _AttributeMap = AbstractGeneralOperationParameterType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'OperationParameterGroupType', OperationParameterGroupType)


# Complex type MD_Georectified_Type with content type ELEMENT_ONLY
class MD_Georectified_Type (MD_GridSpatialRepresentation_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_Georectified_Type')
    # Base type is MD_GridSpatialRepresentation_Type
    
    # Element cellGeometry ({http://www.isotc211.org/2005/gmd}cellGeometry) inherited from {http://www.isotc211.org/2005/gmd}MD_GridSpatialRepresentation_Type
    
    # Element {http://www.isotc211.org/2005/gmd}pointInPixel uses Python identifier pointInPixel
    __pointInPixel = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'pointInPixel'), 'pointInPixel', '__httpwww_isotc211_org2005gmd_MD_Georectified_Type_httpwww_isotc211_org2005gmdpointInPixel', False)

    
    pointInPixel = property(__pointInPixel.value, __pointInPixel.set, None, None)

    
    # Element numberOfDimensions ({http://www.isotc211.org/2005/gmd}numberOfDimensions) inherited from {http://www.isotc211.org/2005/gmd}MD_GridSpatialRepresentation_Type
    
    # Element axisDimensionProperties ({http://www.isotc211.org/2005/gmd}axisDimensionProperties) inherited from {http://www.isotc211.org/2005/gmd}MD_GridSpatialRepresentation_Type
    
    # Element transformationParameterAvailability ({http://www.isotc211.org/2005/gmd}transformationParameterAvailability) inherited from {http://www.isotc211.org/2005/gmd}MD_GridSpatialRepresentation_Type
    
    # Element {http://www.isotc211.org/2005/gmd}transformationDimensionMapping uses Python identifier transformationDimensionMapping
    __transformationDimensionMapping = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'transformationDimensionMapping'), 'transformationDimensionMapping', '__httpwww_isotc211_org2005gmd_MD_Georectified_Type_httpwww_isotc211_org2005gmdtransformationDimensionMapping', True)

    
    transformationDimensionMapping = property(__transformationDimensionMapping.value, __transformationDimensionMapping.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}transformationDimensionDescription uses Python identifier transformationDimensionDescription
    __transformationDimensionDescription = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'transformationDimensionDescription'), 'transformationDimensionDescription', '__httpwww_isotc211_org2005gmd_MD_Georectified_Type_httpwww_isotc211_org2005gmdtransformationDimensionDescription', False)

    
    transformationDimensionDescription = property(__transformationDimensionDescription.value, __transformationDimensionDescription.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}checkPointAvailability uses Python identifier checkPointAvailability
    __checkPointAvailability = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'checkPointAvailability'), 'checkPointAvailability', '__httpwww_isotc211_org2005gmd_MD_Georectified_Type_httpwww_isotc211_org2005gmdcheckPointAvailability', False)

    
    checkPointAvailability = property(__checkPointAvailability.value, __checkPointAvailability.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}checkPointDescription uses Python identifier checkPointDescription
    __checkPointDescription = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'checkPointDescription'), 'checkPointDescription', '__httpwww_isotc211_org2005gmd_MD_Georectified_Type_httpwww_isotc211_org2005gmdcheckPointDescription', False)

    
    checkPointDescription = property(__checkPointDescription.value, __checkPointDescription.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}cornerPoints uses Python identifier cornerPoints
    __cornerPoints = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'cornerPoints'), 'cornerPoints', '__httpwww_isotc211_org2005gmd_MD_Georectified_Type_httpwww_isotc211_org2005gmdcornerPoints', True)

    
    cornerPoints = property(__cornerPoints.value, __cornerPoints.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}centerPoint uses Python identifier centerPoint
    __centerPoint = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'centerPoint'), 'centerPoint', '__httpwww_isotc211_org2005gmd_MD_Georectified_Type_httpwww_isotc211_org2005gmdcenterPoint', False)

    
    centerPoint = property(__centerPoint.value, __centerPoint.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = MD_GridSpatialRepresentation_Type._ElementMap.copy()
    _ElementMap.update({
        __pointInPixel.name() : __pointInPixel,
        __transformationDimensionMapping.name() : __transformationDimensionMapping,
        __transformationDimensionDescription.name() : __transformationDimensionDescription,
        __checkPointAvailability.name() : __checkPointAvailability,
        __checkPointDescription.name() : __checkPointDescription,
        __cornerPoints.name() : __cornerPoints,
        __centerPoint.name() : __centerPoint
    })
    _AttributeMap = MD_GridSpatialRepresentation_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_Georectified_Type', MD_Georectified_Type)


# Complex type DQ_DataQuality_Type with content type ELEMENT_ONLY
class DQ_DataQuality_Type (AbstractObject_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'DQ_DataQuality_Type')
    # Base type is AbstractObject_Type
    
    # Element {http://www.isotc211.org/2005/gmd}lineage uses Python identifier lineage
    __lineage = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'lineage'), 'lineage', '__httpwww_isotc211_org2005gmd_DQ_DataQuality_Type_httpwww_isotc211_org2005gmdlineage', False)

    
    lineage = property(__lineage.value, __lineage.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}scope uses Python identifier scope
    __scope = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'scope'), 'scope', '__httpwww_isotc211_org2005gmd_DQ_DataQuality_Type_httpwww_isotc211_org2005gmdscope', False)

    
    scope = property(__scope.value, __scope.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}report uses Python identifier report
    __report = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'report'), 'report', '__httpwww_isotc211_org2005gmd_DQ_DataQuality_Type_httpwww_isotc211_org2005gmdreport', True)

    
    report = property(__report.value, __report.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractObject_Type._ElementMap.copy()
    _ElementMap.update({
        __lineage.name() : __lineage,
        __scope.name() : __scope,
        __report.name() : __report
    })
    _AttributeMap = AbstractObject_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'DQ_DataQuality_Type', DQ_DataQuality_Type)


# Complex type SolidPropertyType with content type ELEMENT_ONLY
class SolidPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'SolidPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}AbstractSolid uses Python identifier AbstractSolid
    __AbstractSolid = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractSolid'), 'AbstractSolid', '__httpwww_opengis_netgml3_2_SolidPropertyType_httpwww_opengis_netgml3_2AbstractSolid', False)

    
    AbstractSolid = property(__AbstractSolid.value, __AbstractSolid.set, None, u'The AbstractSolid element is the abstract head of the substituition group for all (continuous) solid elements.')

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_SolidPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_SolidPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_SolidPropertyType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_SolidPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_SolidPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_SolidPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_SolidPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_SolidPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_SolidPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_SolidPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')


    _ElementMap = {
        __AbstractSolid.name() : __AbstractSolid
    }
    _AttributeMap = {
        __show.name() : __show,
        __role.name() : __role,
        __owns.name() : __owns,
        __actuate.name() : __actuate,
        __href.name() : __href,
        __nilReason.name() : __nilReason,
        __type.name() : __type,
        __arcrole.name() : __arcrole,
        __title.name() : __title,
        __remoteSchema.name() : __remoteSchema
    }
_Namespace_gml.addCategoryObject('typeBinding', u'SolidPropertyType', SolidPropertyType)


# Complex type MD_Format_Type with content type ELEMENT_ONLY
class MD_Format_Type (AbstractObject_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_Format_Type')
    # Base type is AbstractObject_Type
    
    # Element {http://www.isotc211.org/2005/gmd}version uses Python identifier version
    __version = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'version'), 'version', '__httpwww_isotc211_org2005gmd_MD_Format_Type_httpwww_isotc211_org2005gmdversion', False)

    
    version = property(__version.value, __version.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}formatDistributor uses Python identifier formatDistributor
    __formatDistributor = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'formatDistributor'), 'formatDistributor', '__httpwww_isotc211_org2005gmd_MD_Format_Type_httpwww_isotc211_org2005gmdformatDistributor', True)

    
    formatDistributor = property(__formatDistributor.value, __formatDistributor.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}amendmentNumber uses Python identifier amendmentNumber
    __amendmentNumber = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'amendmentNumber'), 'amendmentNumber', '__httpwww_isotc211_org2005gmd_MD_Format_Type_httpwww_isotc211_org2005gmdamendmentNumber', False)

    
    amendmentNumber = property(__amendmentNumber.value, __amendmentNumber.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}specification uses Python identifier specification
    __specification = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'specification'), 'specification', '__httpwww_isotc211_org2005gmd_MD_Format_Type_httpwww_isotc211_org2005gmdspecification', False)

    
    specification = property(__specification.value, __specification.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}fileDecompressionTechnique uses Python identifier fileDecompressionTechnique
    __fileDecompressionTechnique = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'fileDecompressionTechnique'), 'fileDecompressionTechnique', '__httpwww_isotc211_org2005gmd_MD_Format_Type_httpwww_isotc211_org2005gmdfileDecompressionTechnique', False)

    
    fileDecompressionTechnique = property(__fileDecompressionTechnique.value, __fileDecompressionTechnique.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}name uses Python identifier name
    __name = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'name'), 'name', '__httpwww_isotc211_org2005gmd_MD_Format_Type_httpwww_isotc211_org2005gmdname', False)

    
    name = property(__name.value, __name.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractObject_Type._ElementMap.copy()
    _ElementMap.update({
        __version.name() : __version,
        __formatDistributor.name() : __formatDistributor,
        __amendmentNumber.name() : __amendmentNumber,
        __specification.name() : __specification,
        __fileDecompressionTechnique.name() : __fileDecompressionTechnique,
        __name.name() : __name
    })
    _AttributeMap = AbstractObject_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_Format_Type', MD_Format_Type)


# Complex type TopoSolidPropertyType with content type ELEMENT_ONLY
class TopoSolidPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'TopoSolidPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}TopoSolid uses Python identifier TopoSolid
    __TopoSolid = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'TopoSolid'), 'TopoSolid', '__httpwww_opengis_netgml3_2_TopoSolidPropertyType_httpwww_opengis_netgml3_2TopoSolid', False)

    
    TopoSolid = property(__TopoSolid.value, __TopoSolid.set, None, u'gml:TopoSolid represents the 3-dimensional topology primitive. \nThe topological boundary of a solid (gml:directedFace) consists of a set of directed faces.\nA solid may optionally be realised by a 3-dimensional geometric primitive (gml:solidProperty).')

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_TopoSolidPropertyType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_TopoSolidPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_TopoSolidPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_TopoSolidPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_TopoSolidPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_TopoSolidPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_TopoSolidPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_TopoSolidPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_TopoSolidPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_TopoSolidPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")


    _ElementMap = {
        __TopoSolid.name() : __TopoSolid
    }
    _AttributeMap = {
        __owns.name() : __owns,
        __role.name() : __role,
        __actuate.name() : __actuate,
        __title.name() : __title,
        __href.name() : __href,
        __remoteSchema.name() : __remoteSchema,
        __type.name() : __type,
        __nilReason.name() : __nilReason,
        __arcrole.name() : __arcrole,
        __show.name() : __show
    }
_Namespace_gml.addCategoryObject('typeBinding', u'TopoSolidPropertyType', TopoSolidPropertyType)


# Complex type CodeListType with content type SIMPLE
class CodeListType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = NameList
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_SIMPLE
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'CodeListType')
    # Base type is NameList
    
    # Attribute codeSpace uses Python identifier codeSpace
    __codeSpace = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'codeSpace'), 'codeSpace', '__httpwww_opengis_netgml3_2_CodeListType_codeSpace', pyxb.binding.datatypes.anyURI)
    
    codeSpace = property(__codeSpace.value, __codeSpace.set, None, None)


    _ElementMap = {
        
    }
    _AttributeMap = {
        __codeSpace.name() : __codeSpace
    }
_Namespace_gml.addCategoryObject('typeBinding', u'CodeListType', CodeListType)


# Complex type TargetPropertyType with content type ELEMENT_ONLY
class TargetPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'TargetPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}AbstractFeature uses Python identifier AbstractFeature
    __AbstractFeature = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractFeature'), 'AbstractFeature', '__httpwww_opengis_netgml3_2_TargetPropertyType_httpwww_opengis_netgml3_2AbstractFeature', False)

    
    AbstractFeature = property(__AbstractFeature.value, __AbstractFeature.set, None, u'This abstract element serves as the head of a substitution group which may contain any elements whose content model is derived from gml:AbstractFeatureType.  This may be used as a variable in the construction of content models.  \ngml:AbstractFeature may be thought of as "anything that is a GML feature" and may be used to define variables or templates in which the value of a GML property is "any feature". This occurs in particular in a GML feature collection where the feature member properties contain one or multiple copies of gml:AbstractFeature respectively.')

    
    # Element {http://www.opengis.net/gml/3.2}AbstractGeometry uses Python identifier AbstractGeometry
    __AbstractGeometry = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractGeometry'), 'AbstractGeometry', '__httpwww_opengis_netgml3_2_TargetPropertyType_httpwww_opengis_netgml3_2AbstractGeometry', False)

    
    AbstractGeometry = property(__AbstractGeometry.value, __AbstractGeometry.set, None, u'The AbstractGeometry element is the abstract head of the substitution group for all geometry elements of GML. This includes pre-defined and user-defined geometry elements. Any geometry element shall be a direct or indirect extension/restriction of AbstractGeometryType and shall be directly or indirectly in the substitution group of AbstractGeometry.')

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_TargetPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_TargetPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_TargetPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_TargetPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_TargetPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_TargetPropertyType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_TargetPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_TargetPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_TargetPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_TargetPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)


    _ElementMap = {
        __AbstractFeature.name() : __AbstractFeature,
        __AbstractGeometry.name() : __AbstractGeometry
    }
    _AttributeMap = {
        __role.name() : __role,
        __arcrole.name() : __arcrole,
        __remoteSchema.name() : __remoteSchema,
        __actuate.name() : __actuate,
        __show.name() : __show,
        __owns.name() : __owns,
        __nilReason.name() : __nilReason,
        __href.name() : __href,
        __title.name() : __title,
        __type.name() : __type
    }
_Namespace_gml.addCategoryObject('typeBinding', u'TargetPropertyType', TargetPropertyType)


# Complex type MD_Georectified_PropertyType with content type ELEMENT_ONLY
class MD_Georectified_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_Georectified_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}MD_Georectified uses Python identifier MD_Georectified
    __MD_Georectified = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_Georectified'), 'MD_Georectified', '__httpwww_isotc211_org2005gmd_MD_Georectified_PropertyType_httpwww_isotc211_org2005gmdMD_Georectified', False)

    
    MD_Georectified = property(__MD_Georectified.value, __MD_Georectified.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_MD_Georectified_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_MD_Georectified_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_MD_Georectified_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_MD_Georectified_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_MD_Georectified_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_MD_Georectified_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_MD_Georectified_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_MD_Georectified_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_MD_Georectified_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)


    _ElementMap = {
        __MD_Georectified.name() : __MD_Georectified
    }
    _AttributeMap = {
        __type.name() : __type,
        __arcrole.name() : __arcrole,
        __role.name() : __role,
        __nilReason.name() : __nilReason,
        __uuidref.name() : __uuidref,
        __show.name() : __show,
        __href.name() : __href,
        __actuate.name() : __actuate,
        __title.name() : __title
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_Georectified_PropertyType', MD_Georectified_PropertyType)


# Complex type TimeTopologyComplexPropertyType with content type ELEMENT_ONLY
class TimeTopologyComplexPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'TimeTopologyComplexPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}TimeTopologyComplex uses Python identifier TimeTopologyComplex
    __TimeTopologyComplex = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'TimeTopologyComplex'), 'TimeTopologyComplex', '__httpwww_opengis_netgml3_2_TimeTopologyComplexPropertyType_httpwww_opengis_netgml3_2TimeTopologyComplex', False)

    
    TimeTopologyComplex = property(__TimeTopologyComplex.value, __TimeTopologyComplex.set, None, u'A temporal topology complex shall be the connected acyclic directed graph composed of temporal topological primitives, i.e. time nodes and time edges. Because a time edge may not exist without two time nodes on its boundaries, static features have time edges from a temporal topology complex as the values of their temporal properties, regardless of explicit declarations.\nA temporal topology complex expresses a linear or a non-linear graph. A temporal linear graph, composed of a sequence of time edges, provides a lineage described only by "substitution" of feature instances or feature element values. A time node as the start or the end of the graph connects with at least one time edge. A time node other than the start and the end shall connect to at least two time edges: one of starting from the node, and another ending at the node.\nA temporal topological complex is a set of connected temporal topological primitives. The member primtives are indicated, either by reference or by value, using the primitive property.')

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_TimeTopologyComplexPropertyType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_TimeTopologyComplexPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_TimeTopologyComplexPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_TimeTopologyComplexPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_TimeTopologyComplexPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_TimeTopologyComplexPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_TimeTopologyComplexPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_TimeTopologyComplexPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_TimeTopologyComplexPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_TimeTopologyComplexPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)


    _ElementMap = {
        __TimeTopologyComplex.name() : __TimeTopologyComplex
    }
    _AttributeMap = {
        __owns.name() : __owns,
        __show.name() : __show,
        __type.name() : __type,
        __role.name() : __role,
        __arcrole.name() : __arcrole,
        __remoteSchema.name() : __remoteSchema,
        __nilReason.name() : __nilReason,
        __title.name() : __title,
        __actuate.name() : __actuate,
        __href.name() : __href
    }
_Namespace_gml.addCategoryObject('typeBinding', u'TimeTopologyComplexPropertyType', TimeTopologyComplexPropertyType)


# Complex type AbstractMD_ContentInformation_Type with content type EMPTY
class AbstractMD_ContentInformation_Type (AbstractObject_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_EMPTY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'AbstractMD_ContentInformation_Type')
    # Base type is AbstractObject_Type
    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractObject_Type._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractObject_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'AbstractMD_ContentInformation_Type', AbstractMD_ContentInformation_Type)


# Complex type MD_CoverageDescription_Type with content type ELEMENT_ONLY
class MD_CoverageDescription_Type (AbstractMD_ContentInformation_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_CoverageDescription_Type')
    # Base type is AbstractMD_ContentInformation_Type
    
    # Element {http://www.isotc211.org/2005/gmd}dimension uses Python identifier dimension
    __dimension = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'dimension'), 'dimension', '__httpwww_isotc211_org2005gmd_MD_CoverageDescription_Type_httpwww_isotc211_org2005gmddimension', True)

    
    dimension = property(__dimension.value, __dimension.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}attributeDescription uses Python identifier attributeDescription
    __attributeDescription = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'attributeDescription'), 'attributeDescription', '__httpwww_isotc211_org2005gmd_MD_CoverageDescription_Type_httpwww_isotc211_org2005gmdattributeDescription', False)

    
    attributeDescription = property(__attributeDescription.value, __attributeDescription.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}contentType uses Python identifier contentType
    __contentType = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'contentType'), 'contentType', '__httpwww_isotc211_org2005gmd_MD_CoverageDescription_Type_httpwww_isotc211_org2005gmdcontentType', False)

    
    contentType = property(__contentType.value, __contentType.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractMD_ContentInformation_Type._ElementMap.copy()
    _ElementMap.update({
        __dimension.name() : __dimension,
        __attributeDescription.name() : __attributeDescription,
        __contentType.name() : __contentType
    })
    _AttributeMap = AbstractMD_ContentInformation_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_CoverageDescription_Type', MD_CoverageDescription_Type)


# Complex type GeodeticDatumType with content type ELEMENT_ONLY
class GeodeticDatumType (AbstractDatumType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'GeodeticDatumType')
    # Base type is AbstractDatumType
    
    # Element scope ({http://www.opengis.net/gml/3.2}scope) inherited from {http://www.opengis.net/gml/3.2}AbstractDatumType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element anchorDefinition ({http://www.opengis.net/gml/3.2}anchorDefinition) inherited from {http://www.opengis.net/gml/3.2}AbstractDatumType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element realizationEpoch ({http://www.opengis.net/gml/3.2}realizationEpoch) inherited from {http://www.opengis.net/gml/3.2}AbstractDatumType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}primeMeridian uses Python identifier primeMeridian
    __primeMeridian = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'primeMeridian'), 'primeMeridian', '__httpwww_opengis_netgml3_2_GeodeticDatumType_httpwww_opengis_netgml3_2primeMeridian', False)

    
    primeMeridian = property(__primeMeridian.value, __primeMeridian.set, None, u'gml:primeMeridian is an association role to the prime meridian used by this geodetic datum.')

    
    # Element {http://www.opengis.net/gml/3.2}ellipsoid uses Python identifier ellipsoid
    __ellipsoid = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'ellipsoid'), 'ellipsoid', '__httpwww_opengis_netgml3_2_GeodeticDatumType_httpwww_opengis_netgml3_2ellipsoid', False)

    
    ellipsoid = property(__ellipsoid.value, __ellipsoid.set, None, u'gml:ellipsoid is an association role to the ellipsoid used by this geodetic datum.')

    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element domainOfValidity ({http://www.opengis.net/gml/3.2}domainOfValidity) inherited from {http://www.opengis.net/gml/3.2}AbstractDatumType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType

    _ElementMap = AbstractDatumType._ElementMap.copy()
    _ElementMap.update({
        __primeMeridian.name() : __primeMeridian,
        __ellipsoid.name() : __ellipsoid
    })
    _AttributeMap = AbstractDatumType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'GeodeticDatumType', GeodeticDatumType)


# Complex type TopoVolumePropertyType with content type ELEMENT_ONLY
class TopoVolumePropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'TopoVolumePropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}TopoVolume uses Python identifier TopoVolume
    __TopoVolume = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'TopoVolume'), 'TopoVolume', '__httpwww_opengis_netgml3_2_TopoVolumePropertyType_httpwww_opengis_netgml3_2TopoVolume', False)

    
    TopoVolume = property(__TopoVolume.value, __TopoVolume.set, None, u'gml:TopoVolume represents a homogeneous topological expression, a set of directed topologic solids, which if realised are isomorphic to a geometric solid primitive. The intended use of gml:TopoVolume is to appear within a solid feature to express the structural and geometric relationships of this solid feature to other features via the shared solid definitions.')

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_TopoVolumePropertyType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)


    _ElementMap = {
        __TopoVolume.name() : __TopoVolume
    }
    _AttributeMap = {
        __owns.name() : __owns
    }
_Namespace_gml.addCategoryObject('typeBinding', u'TopoVolumePropertyType', TopoVolumePropertyType)


# Complex type CurvePropertyType with content type ELEMENT_ONLY
class CurvePropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'CurvePropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}AbstractCurve uses Python identifier AbstractCurve
    __AbstractCurve = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractCurve'), 'AbstractCurve', '__httpwww_opengis_netgml3_2_CurvePropertyType_httpwww_opengis_netgml3_2AbstractCurve', False)

    
    AbstractCurve = property(__AbstractCurve.value, __AbstractCurve.set, None, u'The AbstractCurve element is the abstract head of the substitution group for all (continuous) curve elements.')

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_CurvePropertyType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_CurvePropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_CurvePropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_CurvePropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_CurvePropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_CurvePropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_CurvePropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_CurvePropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_CurvePropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_CurvePropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)


    _ElementMap = {
        __AbstractCurve.name() : __AbstractCurve
    }
    _AttributeMap = {
        __owns.name() : __owns,
        __arcrole.name() : __arcrole,
        __remoteSchema.name() : __remoteSchema,
        __role.name() : __role,
        __show.name() : __show,
        __nilReason.name() : __nilReason,
        __type.name() : __type,
        __href.name() : __href,
        __actuate.name() : __actuate,
        __title.name() : __title
    }
_Namespace_gml.addCategoryObject('typeBinding', u'CurvePropertyType', CurvePropertyType)


# Complex type MD_ImageDescription_Type with content type ELEMENT_ONLY
class MD_ImageDescription_Type (MD_CoverageDescription_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_ImageDescription_Type')
    # Base type is MD_CoverageDescription_Type
    
    # Element {http://www.isotc211.org/2005/gmd}illuminationAzimuthAngle uses Python identifier illuminationAzimuthAngle
    __illuminationAzimuthAngle = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'illuminationAzimuthAngle'), 'illuminationAzimuthAngle', '__httpwww_isotc211_org2005gmd_MD_ImageDescription_Type_httpwww_isotc211_org2005gmdilluminationAzimuthAngle', False)

    
    illuminationAzimuthAngle = property(__illuminationAzimuthAngle.value, __illuminationAzimuthAngle.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}lensDistortionInformationAvailability uses Python identifier lensDistortionInformationAvailability
    __lensDistortionInformationAvailability = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'lensDistortionInformationAvailability'), 'lensDistortionInformationAvailability', '__httpwww_isotc211_org2005gmd_MD_ImageDescription_Type_httpwww_isotc211_org2005gmdlensDistortionInformationAvailability', False)

    
    lensDistortionInformationAvailability = property(__lensDistortionInformationAvailability.value, __lensDistortionInformationAvailability.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}imagingCondition uses Python identifier imagingCondition
    __imagingCondition = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'imagingCondition'), 'imagingCondition', '__httpwww_isotc211_org2005gmd_MD_ImageDescription_Type_httpwww_isotc211_org2005gmdimagingCondition', False)

    
    imagingCondition = property(__imagingCondition.value, __imagingCondition.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}cameraCalibrationInformationAvailability uses Python identifier cameraCalibrationInformationAvailability
    __cameraCalibrationInformationAvailability = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'cameraCalibrationInformationAvailability'), 'cameraCalibrationInformationAvailability', '__httpwww_isotc211_org2005gmd_MD_ImageDescription_Type_httpwww_isotc211_org2005gmdcameraCalibrationInformationAvailability', False)

    
    cameraCalibrationInformationAvailability = property(__cameraCalibrationInformationAvailability.value, __cameraCalibrationInformationAvailability.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}imageQualityCode uses Python identifier imageQualityCode
    __imageQualityCode = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'imageQualityCode'), 'imageQualityCode', '__httpwww_isotc211_org2005gmd_MD_ImageDescription_Type_httpwww_isotc211_org2005gmdimageQualityCode', False)

    
    imageQualityCode = property(__imageQualityCode.value, __imageQualityCode.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}cloudCoverPercentage uses Python identifier cloudCoverPercentage
    __cloudCoverPercentage = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'cloudCoverPercentage'), 'cloudCoverPercentage', '__httpwww_isotc211_org2005gmd_MD_ImageDescription_Type_httpwww_isotc211_org2005gmdcloudCoverPercentage', False)

    
    cloudCoverPercentage = property(__cloudCoverPercentage.value, __cloudCoverPercentage.set, None, None)

    
    # Element contentType ({http://www.isotc211.org/2005/gmd}contentType) inherited from {http://www.isotc211.org/2005/gmd}MD_CoverageDescription_Type
    
    # Element attributeDescription ({http://www.isotc211.org/2005/gmd}attributeDescription) inherited from {http://www.isotc211.org/2005/gmd}MD_CoverageDescription_Type
    
    # Element {http://www.isotc211.org/2005/gmd}radiometricCalibrationDataAvailability uses Python identifier radiometricCalibrationDataAvailability
    __radiometricCalibrationDataAvailability = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'radiometricCalibrationDataAvailability'), 'radiometricCalibrationDataAvailability', '__httpwww_isotc211_org2005gmd_MD_ImageDescription_Type_httpwww_isotc211_org2005gmdradiometricCalibrationDataAvailability', False)

    
    radiometricCalibrationDataAvailability = property(__radiometricCalibrationDataAvailability.value, __radiometricCalibrationDataAvailability.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}compressionGenerationQuantity uses Python identifier compressionGenerationQuantity
    __compressionGenerationQuantity = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'compressionGenerationQuantity'), 'compressionGenerationQuantity', '__httpwww_isotc211_org2005gmd_MD_ImageDescription_Type_httpwww_isotc211_org2005gmdcompressionGenerationQuantity', False)

    
    compressionGenerationQuantity = property(__compressionGenerationQuantity.value, __compressionGenerationQuantity.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}processingLevelCode uses Python identifier processingLevelCode
    __processingLevelCode = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'processingLevelCode'), 'processingLevelCode', '__httpwww_isotc211_org2005gmd_MD_ImageDescription_Type_httpwww_isotc211_org2005gmdprocessingLevelCode', False)

    
    processingLevelCode = property(__processingLevelCode.value, __processingLevelCode.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}triangulationIndicator uses Python identifier triangulationIndicator
    __triangulationIndicator = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'triangulationIndicator'), 'triangulationIndicator', '__httpwww_isotc211_org2005gmd_MD_ImageDescription_Type_httpwww_isotc211_org2005gmdtriangulationIndicator', False)

    
    triangulationIndicator = property(__triangulationIndicator.value, __triangulationIndicator.set, None, None)

    
    # Element dimension ({http://www.isotc211.org/2005/gmd}dimension) inherited from {http://www.isotc211.org/2005/gmd}MD_CoverageDescription_Type
    
    # Element {http://www.isotc211.org/2005/gmd}filmDistortionInformationAvailability uses Python identifier filmDistortionInformationAvailability
    __filmDistortionInformationAvailability = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'filmDistortionInformationAvailability'), 'filmDistortionInformationAvailability', '__httpwww_isotc211_org2005gmd_MD_ImageDescription_Type_httpwww_isotc211_org2005gmdfilmDistortionInformationAvailability', False)

    
    filmDistortionInformationAvailability = property(__filmDistortionInformationAvailability.value, __filmDistortionInformationAvailability.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}illuminationElevationAngle uses Python identifier illuminationElevationAngle
    __illuminationElevationAngle = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'illuminationElevationAngle'), 'illuminationElevationAngle', '__httpwww_isotc211_org2005gmd_MD_ImageDescription_Type_httpwww_isotc211_org2005gmdilluminationElevationAngle', False)

    
    illuminationElevationAngle = property(__illuminationElevationAngle.value, __illuminationElevationAngle.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = MD_CoverageDescription_Type._ElementMap.copy()
    _ElementMap.update({
        __illuminationAzimuthAngle.name() : __illuminationAzimuthAngle,
        __lensDistortionInformationAvailability.name() : __lensDistortionInformationAvailability,
        __imagingCondition.name() : __imagingCondition,
        __cameraCalibrationInformationAvailability.name() : __cameraCalibrationInformationAvailability,
        __imageQualityCode.name() : __imageQualityCode,
        __cloudCoverPercentage.name() : __cloudCoverPercentage,
        __radiometricCalibrationDataAvailability.name() : __radiometricCalibrationDataAvailability,
        __compressionGenerationQuantity.name() : __compressionGenerationQuantity,
        __processingLevelCode.name() : __processingLevelCode,
        __triangulationIndicator.name() : __triangulationIndicator,
        __filmDistortionInformationAvailability.name() : __filmDistortionInformationAvailability,
        __illuminationElevationAngle.name() : __illuminationElevationAngle
    })
    _AttributeMap = MD_CoverageDescription_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_ImageDescription_Type', MD_ImageDescription_Type)


# Complex type TimeInstantPropertyType with content type ELEMENT_ONLY
class TimeInstantPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'TimeInstantPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}TimeInstant uses Python identifier TimeInstant
    __TimeInstant = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'TimeInstant'), 'TimeInstant', '__httpwww_opengis_netgml3_2_TimeInstantPropertyType_httpwww_opengis_netgml3_2TimeInstant', False)

    
    TimeInstant = property(__TimeInstant.value, __TimeInstant.set, None, u'gml:TimeInstant acts as a zero-dimensional geometric primitive that represents an identifiable position in time.')

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_TimeInstantPropertyType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_TimeInstantPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_TimeInstantPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_TimeInstantPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_TimeInstantPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_TimeInstantPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_TimeInstantPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_TimeInstantPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_TimeInstantPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_TimeInstantPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')


    _ElementMap = {
        __TimeInstant.name() : __TimeInstant
    }
    _AttributeMap = {
        __owns.name() : __owns,
        __href.name() : __href,
        __type.name() : __type,
        __nilReason.name() : __nilReason,
        __role.name() : __role,
        __arcrole.name() : __arcrole,
        __show.name() : __show,
        __actuate.name() : __actuate,
        __title.name() : __title,
        __remoteSchema.name() : __remoteSchema
    }
_Namespace_gml.addCategoryObject('typeBinding', u'TimeInstantPropertyType', TimeInstantPropertyType)


# Complex type DQ_QuantitativeResult_Type with content type ELEMENT_ONLY
class DQ_QuantitativeResult_Type (AbstractDQ_Result_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'DQ_QuantitativeResult_Type')
    # Base type is AbstractDQ_Result_Type
    
    # Element {http://www.isotc211.org/2005/gmd}value uses Python identifier value_
    __value = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'value'), 'value_', '__httpwww_isotc211_org2005gmd_DQ_QuantitativeResult_Type_httpwww_isotc211_org2005gmdvalue', True)

    
    value_ = property(__value.value, __value.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}valueType uses Python identifier valueType
    __valueType = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'valueType'), 'valueType', '__httpwww_isotc211_org2005gmd_DQ_QuantitativeResult_Type_httpwww_isotc211_org2005gmdvalueType', False)

    
    valueType = property(__valueType.value, __valueType.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}errorStatistic uses Python identifier errorStatistic
    __errorStatistic = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'errorStatistic'), 'errorStatistic', '__httpwww_isotc211_org2005gmd_DQ_QuantitativeResult_Type_httpwww_isotc211_org2005gmderrorStatistic', False)

    
    errorStatistic = property(__errorStatistic.value, __errorStatistic.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}valueUnit uses Python identifier valueUnit
    __valueUnit = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'valueUnit'), 'valueUnit', '__httpwww_isotc211_org2005gmd_DQ_QuantitativeResult_Type_httpwww_isotc211_org2005gmdvalueUnit', False)

    
    valueUnit = property(__valueUnit.value, __valueUnit.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractDQ_Result_Type._ElementMap.copy()
    _ElementMap.update({
        __value.name() : __value,
        __valueType.name() : __valueType,
        __errorStatistic.name() : __errorStatistic,
        __valueUnit.name() : __valueUnit
    })
    _AttributeMap = AbstractDQ_Result_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'DQ_QuantitativeResult_Type', DQ_QuantitativeResult_Type)


# Complex type CartesianCSPropertyType with content type ELEMENT_ONLY
class CartesianCSPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'CartesianCSPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}CartesianCS uses Python identifier CartesianCS
    __CartesianCS = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'CartesianCS'), 'CartesianCS', '__httpwww_opengis_netgml3_2_CartesianCSPropertyType_httpwww_opengis_netgml3_2CartesianCS', False)

    
    CartesianCS = property(__CartesianCS.value, __CartesianCS.set, None, u'gml:CartesianCS is a 1-, 2-, or 3-dimensional coordinate system. In the 1-dimensional case, it contains a single straight coordinate axis. In the 2- and 3-dimensional cases gives the position of points relative to orthogonal straight axes. In the multi-dimensional case, all axes shall have the same length unit of measure. A CartesianCS shall have one, two, or three gml:axis property elements.')

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_CartesianCSPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_CartesianCSPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_CartesianCSPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_CartesianCSPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_CartesianCSPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_CartesianCSPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_CartesianCSPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_CartesianCSPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_CartesianCSPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)


    _ElementMap = {
        __CartesianCS.name() : __CartesianCS
    }
    _AttributeMap = {
        __title.name() : __title,
        __role.name() : __role,
        __arcrole.name() : __arcrole,
        __remoteSchema.name() : __remoteSchema,
        __show.name() : __show,
        __nilReason.name() : __nilReason,
        __actuate.name() : __actuate,
        __href.name() : __href,
        __type.name() : __type
    }
_Namespace_gml.addCategoryObject('typeBinding', u'CartesianCSPropertyType', CartesianCSPropertyType)


# Complex type AbstractMetaDataType with content type MIXED
class AbstractMetaDataType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_MIXED
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractMetaDataType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Attribute {http://www.opengis.net/gml/3.2}id uses Python identifier id
    __id = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'id'), 'id', '__httpwww_opengis_netgml3_2_AbstractMetaDataType_httpwww_opengis_netgml3_2id', pyxb.binding.datatypes.ID)
    
    id = property(__id.value, __id.set, None, u'The attribute gml:id supports provision of a handle for the XML element representing a GML Object. Its use is mandatory for all GML objects. It is of XML type ID, so is constrained to be unique in the XML document within which it occurs.')


    _ElementMap = {
        
    }
    _AttributeMap = {
        __id.name() : __id
    }
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractMetaDataType', AbstractMetaDataType)


# Complex type GenericMetaDataType with content type MIXED
class GenericMetaDataType (AbstractMetaDataType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_MIXED
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'GenericMetaDataType')
    # Base type is AbstractMetaDataType
    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractMetaDataType
    _HasWildcardElement = True

    _ElementMap = AbstractMetaDataType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractMetaDataType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'GenericMetaDataType', GenericMetaDataType)


# Complex type PT_Locale_Type with content type ELEMENT_ONLY
class PT_Locale_Type (AbstractObject_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'PT_Locale_Type')
    # Base type is AbstractObject_Type
    
    # Element {http://www.isotc211.org/2005/gmd}characterEncoding uses Python identifier characterEncoding
    __characterEncoding = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'characterEncoding'), 'characterEncoding', '__httpwww_isotc211_org2005gmd_PT_Locale_Type_httpwww_isotc211_org2005gmdcharacterEncoding', False)

    
    characterEncoding = property(__characterEncoding.value, __characterEncoding.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}languageCode uses Python identifier languageCode
    __languageCode = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'languageCode'), 'languageCode', '__httpwww_isotc211_org2005gmd_PT_Locale_Type_httpwww_isotc211_org2005gmdlanguageCode', False)

    
    languageCode = property(__languageCode.value, __languageCode.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}country uses Python identifier country
    __country = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'country'), 'country', '__httpwww_isotc211_org2005gmd_PT_Locale_Type_httpwww_isotc211_org2005gmdcountry', False)

    
    country = property(__country.value, __country.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractObject_Type._ElementMap.copy()
    _ElementMap.update({
        __characterEncoding.name() : __characterEncoding,
        __languageCode.name() : __languageCode,
        __country.name() : __country
    })
    _AttributeMap = AbstractObject_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'PT_Locale_Type', PT_Locale_Type)


# Complex type CylindricalCSType with content type ELEMENT_ONLY
class CylindricalCSType (AbstractCoordinateSystemType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'CylindricalCSType')
    # Base type is AbstractCoordinateSystemType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element axis ({http://www.opengis.net/gml/3.2}axis) inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateSystemType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Attribute aggregationType inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateSystemType
    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType

    _ElementMap = AbstractCoordinateSystemType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractCoordinateSystemType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'CylindricalCSType', CylindricalCSType)


# Complex type AbstractParametricCurveSurfaceType with content type EMPTY
class AbstractParametricCurveSurfaceType (AbstractSurfacePatchType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_EMPTY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractParametricCurveSurfaceType')
    # Base type is AbstractSurfacePatchType
    
    # Attribute aggregationType uses Python identifier aggregationType
    __aggregationType = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'aggregationType'), 'aggregationType', '__httpwww_opengis_netgml3_2_AbstractParametricCurveSurfaceType_aggregationType', AggregationType)
    
    aggregationType = property(__aggregationType.value, __aggregationType.set, None, None)


    _ElementMap = AbstractSurfacePatchType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractSurfacePatchType._AttributeMap.copy()
    _AttributeMap.update({
        __aggregationType.name() : __aggregationType
    })
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractParametricCurveSurfaceType', AbstractParametricCurveSurfaceType)


# Complex type AbstractGriddedSurfaceType with content type ELEMENT_ONLY
class AbstractGriddedSurfaceType (AbstractParametricCurveSurfaceType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractGriddedSurfaceType')
    # Base type is AbstractParametricCurveSurfaceType
    
    # Element {http://www.opengis.net/gml/3.2}rows uses Python identifier rows
    __rows = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'rows'), 'rows', '__httpwww_opengis_netgml3_2_AbstractGriddedSurfaceType_httpwww_opengis_netgml3_2rows', False)

    
    rows = property(__rows.value, __rows.set, None, None)

    
    # Attribute aggregationType inherited from {http://www.opengis.net/gml/3.2}AbstractParametricCurveSurfaceType
    
    # Attribute rows uses Python identifier rows_
    __rows_ = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'rows'), 'rows_', '__httpwww_opengis_netgml3_2_AbstractGriddedSurfaceType_rows', pyxb.binding.datatypes.integer)
    
    rows_ = property(__rows_.value, __rows_.set, None, None)

    
    # Attribute columns uses Python identifier columns
    __columns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'columns'), 'columns', '__httpwww_opengis_netgml3_2_AbstractGriddedSurfaceType_columns', pyxb.binding.datatypes.integer)
    
    columns = property(__columns.value, __columns.set, None, None)


    _ElementMap = AbstractParametricCurveSurfaceType._ElementMap.copy()
    _ElementMap.update({
        __rows.name() : __rows
    })
    _AttributeMap = AbstractParametricCurveSurfaceType._AttributeMap.copy()
    _AttributeMap.update({
        __rows_.name() : __rows_,
        __columns.name() : __columns
    })
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractGriddedSurfaceType', AbstractGriddedSurfaceType)


# Complex type SphereType with content type ELEMENT_ONLY
class SphereType (AbstractGriddedSurfaceType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'SphereType')
    # Base type is AbstractGriddedSurfaceType
    
    # Element rows ({http://www.opengis.net/gml/3.2}rows) inherited from {http://www.opengis.net/gml/3.2}AbstractGriddedSurfaceType
    
    # Attribute aggregationType inherited from {http://www.opengis.net/gml/3.2}AbstractParametricCurveSurfaceType
    
    # Attribute horizontalCurveType uses Python identifier horizontalCurveType
    __horizontalCurveType = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'horizontalCurveType'), 'horizontalCurveType', '__httpwww_opengis_netgml3_2_SphereType_horizontalCurveType', CurveInterpolationType, fixed=True, unicode_default=u'circularArc3Points')
    
    horizontalCurveType = property(__horizontalCurveType.value, __horizontalCurveType.set, None, None)

    
    # Attribute columns inherited from {http://www.opengis.net/gml/3.2}AbstractGriddedSurfaceType
    
    # Attribute verticalCurveType uses Python identifier verticalCurveType
    __verticalCurveType = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'verticalCurveType'), 'verticalCurveType', '__httpwww_opengis_netgml3_2_SphereType_verticalCurveType', CurveInterpolationType, fixed=True, unicode_default=u'circularArc3Points')
    
    verticalCurveType = property(__verticalCurveType.value, __verticalCurveType.set, None, None)

    
    # Attribute rows_ inherited from {http://www.opengis.net/gml/3.2}AbstractGriddedSurfaceType

    _ElementMap = AbstractGriddedSurfaceType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractGriddedSurfaceType._AttributeMap.copy()
    _AttributeMap.update({
        __horizontalCurveType.name() : __horizontalCurveType,
        __verticalCurveType.name() : __verticalCurveType
    })
_Namespace_gml.addCategoryObject('typeBinding', u'SphereType', SphereType)


# Complex type RS_Identifier_PropertyType with content type ELEMENT_ONLY
class RS_Identifier_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'RS_Identifier_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}RS_Identifier uses Python identifier RS_Identifier
    __RS_Identifier = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'RS_Identifier'), 'RS_Identifier', '__httpwww_isotc211_org2005gmd_RS_Identifier_PropertyType_httpwww_isotc211_org2005gmdRS_Identifier', False)

    
    RS_Identifier = property(__RS_Identifier.value, __RS_Identifier.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_RS_Identifier_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_RS_Identifier_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_RS_Identifier_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_RS_Identifier_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_RS_Identifier_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_RS_Identifier_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_RS_Identifier_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_RS_Identifier_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_RS_Identifier_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)


    _ElementMap = {
        __RS_Identifier.name() : __RS_Identifier
    }
    _AttributeMap = {
        __type.name() : __type,
        __href.name() : __href,
        __nilReason.name() : __nilReason,
        __title.name() : __title,
        __show.name() : __show,
        __uuidref.name() : __uuidref,
        __actuate.name() : __actuate,
        __role.name() : __role,
        __arcrole.name() : __arcrole
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'RS_Identifier_PropertyType', RS_Identifier_PropertyType)


# Complex type MD_ClassificationCode_PropertyType with content type ELEMENT_ONLY
class MD_ClassificationCode_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_ClassificationCode_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}MD_ClassificationCode uses Python identifier MD_ClassificationCode
    __MD_ClassificationCode = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_ClassificationCode'), 'MD_ClassificationCode', '__httpwww_isotc211_org2005gmd_MD_ClassificationCode_PropertyType_httpwww_isotc211_org2005gmdMD_ClassificationCode', False)

    
    MD_ClassificationCode = property(__MD_ClassificationCode.value, __MD_ClassificationCode.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_MD_ClassificationCode_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        __MD_ClassificationCode.name() : __MD_ClassificationCode
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_ClassificationCode_PropertyType', MD_ClassificationCode_PropertyType)


# Complex type MD_BrowseGraphic_Type with content type ELEMENT_ONLY
class MD_BrowseGraphic_Type (AbstractObject_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_BrowseGraphic_Type')
    # Base type is AbstractObject_Type
    
    # Element {http://www.isotc211.org/2005/gmd}fileType uses Python identifier fileType
    __fileType = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'fileType'), 'fileType', '__httpwww_isotc211_org2005gmd_MD_BrowseGraphic_Type_httpwww_isotc211_org2005gmdfileType', False)

    
    fileType = property(__fileType.value, __fileType.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}fileName uses Python identifier fileName
    __fileName = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'fileName'), 'fileName', '__httpwww_isotc211_org2005gmd_MD_BrowseGraphic_Type_httpwww_isotc211_org2005gmdfileName', False)

    
    fileName = property(__fileName.value, __fileName.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}fileDescription uses Python identifier fileDescription
    __fileDescription = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'fileDescription'), 'fileDescription', '__httpwww_isotc211_org2005gmd_MD_BrowseGraphic_Type_httpwww_isotc211_org2005gmdfileDescription', False)

    
    fileDescription = property(__fileDescription.value, __fileDescription.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractObject_Type._ElementMap.copy()
    _ElementMap.update({
        __fileType.name() : __fileType,
        __fileName.name() : __fileName,
        __fileDescription.name() : __fileDescription
    })
    _AttributeMap = AbstractObject_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_BrowseGraphic_Type', MD_BrowseGraphic_Type)


# Complex type MD_Identifier_Type with content type ELEMENT_ONLY
class MD_Identifier_Type (AbstractObject_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_Identifier_Type')
    # Base type is AbstractObject_Type
    
    # Element {http://www.isotc211.org/2005/gmd}code uses Python identifier code
    __code = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'code'), 'code', '__httpwww_isotc211_org2005gmd_MD_Identifier_Type_httpwww_isotc211_org2005gmdcode', False)

    
    code = property(__code.value, __code.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}authority uses Python identifier authority
    __authority = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'authority'), 'authority', '__httpwww_isotc211_org2005gmd_MD_Identifier_Type_httpwww_isotc211_org2005gmdauthority', False)

    
    authority = property(__authority.value, __authority.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractObject_Type._ElementMap.copy()
    _ElementMap.update({
        __code.name() : __code,
        __authority.name() : __authority
    })
    _AttributeMap = AbstractObject_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_Identifier_Type', MD_Identifier_Type)


# Complex type RS_Identifier_Type with content type ELEMENT_ONLY
class RS_Identifier_Type (MD_Identifier_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'RS_Identifier_Type')
    # Base type is MD_Identifier_Type
    
    # Element {http://www.isotc211.org/2005/gmd}version uses Python identifier version
    __version = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'version'), 'version', '__httpwww_isotc211_org2005gmd_RS_Identifier_Type_httpwww_isotc211_org2005gmdversion', False)

    
    version = property(__version.value, __version.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}codeSpace uses Python identifier codeSpace
    __codeSpace = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'codeSpace'), 'codeSpace', '__httpwww_isotc211_org2005gmd_RS_Identifier_Type_httpwww_isotc211_org2005gmdcodeSpace', False)

    
    codeSpace = property(__codeSpace.value, __codeSpace.set, None, None)

    
    # Element authority ({http://www.isotc211.org/2005/gmd}authority) inherited from {http://www.isotc211.org/2005/gmd}MD_Identifier_Type
    
    # Element code ({http://www.isotc211.org/2005/gmd}code) inherited from {http://www.isotc211.org/2005/gmd}MD_Identifier_Type
    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = MD_Identifier_Type._ElementMap.copy()
    _ElementMap.update({
        __version.name() : __version,
        __codeSpace.name() : __codeSpace
    })
    _AttributeMap = MD_Identifier_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'RS_Identifier_Type', RS_Identifier_Type)


# Complex type DQ_ConformanceResult_PropertyType with content type ELEMENT_ONLY
class DQ_ConformanceResult_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'DQ_ConformanceResult_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}DQ_ConformanceResult uses Python identifier DQ_ConformanceResult
    __DQ_ConformanceResult = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'DQ_ConformanceResult'), 'DQ_ConformanceResult', '__httpwww_isotc211_org2005gmd_DQ_ConformanceResult_PropertyType_httpwww_isotc211_org2005gmdDQ_ConformanceResult', False)

    
    DQ_ConformanceResult = property(__DQ_ConformanceResult.value, __DQ_ConformanceResult.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_DQ_ConformanceResult_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_DQ_ConformanceResult_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_DQ_ConformanceResult_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_DQ_ConformanceResult_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_DQ_ConformanceResult_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_DQ_ConformanceResult_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_DQ_ConformanceResult_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_DQ_ConformanceResult_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_DQ_ConformanceResult_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")


    _ElementMap = {
        __DQ_ConformanceResult.name() : __DQ_ConformanceResult
    }
    _AttributeMap = {
        __href.name() : __href,
        __role.name() : __role,
        __type.name() : __type,
        __arcrole.name() : __arcrole,
        __uuidref.name() : __uuidref,
        __nilReason.name() : __nilReason,
        __title.name() : __title,
        __actuate.name() : __actuate,
        __show.name() : __show
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'DQ_ConformanceResult_PropertyType', DQ_ConformanceResult_PropertyType)


# Complex type MultiSolidType with content type ELEMENT_ONLY
class MultiSolidType (AbstractGeometricAggregateType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'MultiSolidType')
    # Base type is AbstractGeometricAggregateType
    
    # Element {http://www.opengis.net/gml/3.2}solidMember uses Python identifier solidMember
    __solidMember = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'solidMember'), 'solidMember', '__httpwww_opengis_netgml3_2_MultiSolidType_httpwww_opengis_netgml3_2solidMember', True)

    
    solidMember = property(__solidMember.value, __solidMember.set, None, u'This property element either references a solid via the XLink-attributes or contains the solid element. A solid element is any element, which is substitutable for gml:AbstractSolid.')

    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}solidMembers uses Python identifier solidMembers
    __solidMembers = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'solidMembers'), 'solidMembers', '__httpwww_opengis_netgml3_2_MultiSolidType_httpwww_opengis_netgml3_2solidMembers', False)

    
    solidMembers = property(__solidMembers.value, __solidMembers.set, None, u'This property element contains a list of solids. The order of the elements is significant and shall be preserved when processing the array.')

    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute uomLabels inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute aggregationType inherited from {http://www.opengis.net/gml/3.2}AbstractGeometricAggregateType
    
    # Attribute srsName inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute srsDimension inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute axisLabels inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType

    _ElementMap = AbstractGeometricAggregateType._ElementMap.copy()
    _ElementMap.update({
        __solidMember.name() : __solidMember,
        __solidMembers.name() : __solidMembers
    })
    _AttributeMap = AbstractGeometricAggregateType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'MultiSolidType', MultiSolidType)


# Complex type ArcStringByBulgeType with content type ELEMENT_ONLY
class ArcStringByBulgeType (AbstractCurveSegmentType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'ArcStringByBulgeType')
    # Base type is AbstractCurveSegmentType
    
    # Element {http://www.opengis.net/gml/3.2}pointRep uses Python identifier pointRep
    __pointRep = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'pointRep'), 'pointRep', '__httpwww_opengis_netgml3_2_ArcStringByBulgeType_httpwww_opengis_netgml3_2pointRep', True)

    
    pointRep = property(__pointRep.value, __pointRep.set, None, u'')

    
    # Element {http://www.opengis.net/gml/3.2}posList uses Python identifier posList
    __posList = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'posList'), 'posList', '__httpwww_opengis_netgml3_2_ArcStringByBulgeType_httpwww_opengis_netgml3_2posList', False)

    
    posList = property(__posList.value, __posList.set, None, None)

    
    # Element {http://www.opengis.net/gml/3.2}coordinates uses Python identifier coordinates
    __coordinates = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'coordinates'), 'coordinates', '__httpwww_opengis_netgml3_2_ArcStringByBulgeType_httpwww_opengis_netgml3_2coordinates', False)

    
    coordinates = property(__coordinates.value, __coordinates.set, None, u'')

    
    # Element {http://www.opengis.net/gml/3.2}normal uses Python identifier normal
    __normal = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'normal'), 'normal', '__httpwww_opengis_netgml3_2_ArcStringByBulgeType_httpwww_opengis_netgml3_2normal', True)

    
    normal = property(__normal.value, __normal.set, None, None)

    
    # Element {http://www.opengis.net/gml/3.2}bulge uses Python identifier bulge
    __bulge = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'bulge'), 'bulge', '__httpwww_opengis_netgml3_2_ArcStringByBulgeType_httpwww_opengis_netgml3_2bulge', True)

    
    bulge = property(__bulge.value, __bulge.set, None, None)

    
    # Element {http://www.opengis.net/gml/3.2}pos uses Python identifier pos
    __pos = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'pos'), 'pos', '__httpwww_opengis_netgml3_2_ArcStringByBulgeType_httpwww_opengis_netgml3_2pos', True)

    
    pos = property(__pos.value, __pos.set, None, None)

    
    # Element {http://www.opengis.net/gml/3.2}pointProperty uses Python identifier pointProperty
    __pointProperty = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'pointProperty'), 'pointProperty', '__httpwww_opengis_netgml3_2_ArcStringByBulgeType_httpwww_opengis_netgml3_2pointProperty', True)

    
    pointProperty = property(__pointProperty.value, __pointProperty.set, None, u'This property element either references a point via the XLink-attributes or contains the point element. pointProperty is the predefined property which may be used by GML Application Schemas whenever a GML feature has a property with a value that is substitutable for Point.')

    
    # Attribute numDerivativesAtEnd inherited from {http://www.opengis.net/gml/3.2}AbstractCurveSegmentType
    
    # Attribute numDerivativesAtStart inherited from {http://www.opengis.net/gml/3.2}AbstractCurveSegmentType
    
    # Attribute numArc uses Python identifier numArc
    __numArc = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'numArc'), 'numArc', '__httpwww_opengis_netgml3_2_ArcStringByBulgeType_numArc', pyxb.binding.datatypes.integer)
    
    numArc = property(__numArc.value, __numArc.set, None, None)

    
    # Attribute numDerivativeInterior inherited from {http://www.opengis.net/gml/3.2}AbstractCurveSegmentType
    
    # Attribute interpolation uses Python identifier interpolation
    __interpolation = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'interpolation'), 'interpolation', '__httpwww_opengis_netgml3_2_ArcStringByBulgeType_interpolation', CurveInterpolationType, fixed=True, unicode_default=u'circularArc2PointWithBulge')
    
    interpolation = property(__interpolation.value, __interpolation.set, None, None)


    _ElementMap = AbstractCurveSegmentType._ElementMap.copy()
    _ElementMap.update({
        __pointRep.name() : __pointRep,
        __posList.name() : __posList,
        __coordinates.name() : __coordinates,
        __normal.name() : __normal,
        __bulge.name() : __bulge,
        __pos.name() : __pos,
        __pointProperty.name() : __pointProperty
    })
    _AttributeMap = AbstractCurveSegmentType._AttributeMap.copy()
    _AttributeMap.update({
        __numArc.name() : __numArc,
        __interpolation.name() : __interpolation
    })
_Namespace_gml.addCategoryObject('typeBinding', u'ArcStringByBulgeType', ArcStringByBulgeType)


# Complex type DictionaryType with content type ELEMENT_ONLY
class DictionaryType (DefinitionType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'DictionaryType')
    # Base type is DefinitionType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}indirectEntry uses Python identifier indirectEntry
    __indirectEntry = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'indirectEntry'), 'indirectEntry', '__httpwww_opengis_netgml3_2_DictionaryType_httpwww_opengis_netgml3_2indirectEntry', True)

    
    indirectEntry = property(__indirectEntry.value, __indirectEntry.set, None, u'')

    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}dictionaryEntry uses Python identifier dictionaryEntry
    __dictionaryEntry = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'dictionaryEntry'), 'dictionaryEntry', '__httpwww_opengis_netgml3_2_DictionaryType_httpwww_opengis_netgml3_2dictionaryEntry', True)

    
    dictionaryEntry = property(__dictionaryEntry.value, __dictionaryEntry.set, None, u'This property element contains or refers to the definitions which are members of a dictionary. \nThe content model follows the standard GML property pattern, so a gml:dictionaryEntry may either contain or refer to a single gml:Definition. Since gml:Dictionary is substitutable for gml:Definition, the content of an entry may itself be a lower level dictionary. \nNote that if the value is provided by reference, this definition does not carry a handle (gml:id) in this context, so does not allow external references to this specific definition in this context.  When used in this way the referenced definition will usually be in a dictionary in the same XML document.')

    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Attribute aggregationType uses Python identifier aggregationType
    __aggregationType = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'aggregationType'), 'aggregationType', '__httpwww_opengis_netgml3_2_DictionaryType_aggregationType', AggregationType)
    
    aggregationType = property(__aggregationType.value, __aggregationType.set, None, None)

    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType

    _ElementMap = DefinitionType._ElementMap.copy()
    _ElementMap.update({
        __indirectEntry.name() : __indirectEntry,
        __dictionaryEntry.name() : __dictionaryEntry
    })
    _AttributeMap = DefinitionType._AttributeMap.copy()
    _AttributeMap.update({
        __aggregationType.name() : __aggregationType
    })
_Namespace_gml.addCategoryObject('typeBinding', u'DictionaryType', DictionaryType)


# Complex type DirectedTopoSolidPropertyType with content type ELEMENT_ONLY
class DirectedTopoSolidPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'DirectedTopoSolidPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}TopoSolid uses Python identifier TopoSolid
    __TopoSolid = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'TopoSolid'), 'TopoSolid', '__httpwww_opengis_netgml3_2_DirectedTopoSolidPropertyType_httpwww_opengis_netgml3_2TopoSolid', False)

    
    TopoSolid = property(__TopoSolid.value, __TopoSolid.set, None, u'gml:TopoSolid represents the 3-dimensional topology primitive. \nThe topological boundary of a solid (gml:directedFace) consists of a set of directed faces.\nA solid may optionally be realised by a 3-dimensional geometric primitive (gml:solidProperty).')

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_DirectedTopoSolidPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute orientation uses Python identifier orientation
    __orientation = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'orientation'), 'orientation', '__httpwww_opengis_netgml3_2_DirectedTopoSolidPropertyType_orientation', SignType, unicode_default=u'+')
    
    orientation = property(__orientation.value, __orientation.set, None, None)

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_DirectedTopoSolidPropertyType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_DirectedTopoSolidPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_DirectedTopoSolidPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_DirectedTopoSolidPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_DirectedTopoSolidPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_DirectedTopoSolidPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_DirectedTopoSolidPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_DirectedTopoSolidPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_DirectedTopoSolidPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")


    _ElementMap = {
        __TopoSolid.name() : __TopoSolid
    }
    _AttributeMap = {
        __actuate.name() : __actuate,
        __orientation.name() : __orientation,
        __owns.name() : __owns,
        __role.name() : __role,
        __arcrole.name() : __arcrole,
        __href.name() : __href,
        __type.name() : __type,
        __nilReason.name() : __nilReason,
        __remoteSchema.name() : __remoteSchema,
        __title.name() : __title,
        __show.name() : __show
    }
_Namespace_gml.addCategoryObject('typeBinding', u'DirectedTopoSolidPropertyType', DirectedTopoSolidPropertyType)


# Complex type ObliqueCartesianCSType with content type ELEMENT_ONLY
class ObliqueCartesianCSType (AbstractCoordinateSystemType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'ObliqueCartesianCSType')
    # Base type is AbstractCoordinateSystemType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element axis ({http://www.opengis.net/gml/3.2}axis) inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateSystemType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Attribute aggregationType inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateSystemType
    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType

    _ElementMap = AbstractCoordinateSystemType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractCoordinateSystemType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'ObliqueCartesianCSType', ObliqueCartesianCSType)


# Complex type DateTime_PropertyType with content type ELEMENT_ONLY
class DateTime_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gco, u'DateTime_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gco}DateTime uses Python identifier DateTime
    __DateTime = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'DateTime'), 'DateTime', '__httpwww_isotc211_org2005gco_DateTime_PropertyType_httpwww_isotc211_org2005gcoDateTime', False)

    
    DateTime = property(__DateTime.value, __DateTime.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gco_DateTime_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        __DateTime.name() : __DateTime
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason
    }
_Namespace_gco.addCategoryObject('typeBinding', u'DateTime_PropertyType', DateTime_PropertyType)


# Complex type GeometricPrimitivePropertyType with content type ELEMENT_ONLY
class GeometricPrimitivePropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'GeometricPrimitivePropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}AbstractGeometricPrimitive uses Python identifier AbstractGeometricPrimitive
    __AbstractGeometricPrimitive = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractGeometricPrimitive'), 'AbstractGeometricPrimitive', '__httpwww_opengis_netgml3_2_GeometricPrimitivePropertyType_httpwww_opengis_netgml3_2AbstractGeometricPrimitive', False)

    
    AbstractGeometricPrimitive = property(__AbstractGeometricPrimitive.value, __AbstractGeometricPrimitive.set, None, u'The AbstractGeometricPrimitive element is the abstract head of the substitution group for all (pre- and user-defined) geometric primitives.')

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_GeometricPrimitivePropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_GeometricPrimitivePropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_GeometricPrimitivePropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_GeometricPrimitivePropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_GeometricPrimitivePropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_GeometricPrimitivePropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_GeometricPrimitivePropertyType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_GeometricPrimitivePropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_GeometricPrimitivePropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_GeometricPrimitivePropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")


    _ElementMap = {
        __AbstractGeometricPrimitive.name() : __AbstractGeometricPrimitive
    }
    _AttributeMap = {
        __remoteSchema.name() : __remoteSchema,
        __role.name() : __role,
        __type.name() : __type,
        __arcrole.name() : __arcrole,
        __title.name() : __title,
        __nilReason.name() : __nilReason,
        __owns.name() : __owns,
        __actuate.name() : __actuate,
        __href.name() : __href,
        __show.name() : __show
    }
_Namespace_gml.addCategoryObject('typeBinding', u'GeometricPrimitivePropertyType', GeometricPrimitivePropertyType)


# Complex type CoordinateOperationPropertyType with content type ELEMENT_ONLY
class CoordinateOperationPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'CoordinateOperationPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}AbstractCoordinateOperation uses Python identifier AbstractCoordinateOperation
    __AbstractCoordinateOperation = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractCoordinateOperation'), 'AbstractCoordinateOperation', '__httpwww_opengis_netgml3_2_CoordinateOperationPropertyType_httpwww_opengis_netgml3_2AbstractCoordinateOperation', False)

    
    AbstractCoordinateOperation = property(__AbstractCoordinateOperation.value, __AbstractCoordinateOperation.set, None, u'gml:AbstractCoordinateOperation is a mathematical operation on coordinates that transforms or converts coordinates to another coordinate reference system. Many but not all coordinate operations (from CRS A to CRS B) also uniquely define the inverse operation (from CRS B to CRS A). In some cases, the operation method algorithm for the inverse operation is the same as for the forward algorithm, but the signs of some operation parameter values shall be reversed. In other cases, different algorithms are required for the forward and inverse operations, but the same operation parameter values are used. If (some) entirely different parameter values are needed, a different coordinate operation shall be defined.\nThe optional coordinateOperationAccuracy property elements provide estimates of the impact of this coordinate operation on point position accuracy.')

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_CoordinateOperationPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_CoordinateOperationPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_CoordinateOperationPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_CoordinateOperationPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_CoordinateOperationPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_CoordinateOperationPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_CoordinateOperationPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_CoordinateOperationPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_CoordinateOperationPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")


    _ElementMap = {
        __AbstractCoordinateOperation.name() : __AbstractCoordinateOperation
    }
    _AttributeMap = {
        __remoteSchema.name() : __remoteSchema,
        __href.name() : __href,
        __title.name() : __title,
        __type.name() : __type,
        __nilReason.name() : __nilReason,
        __show.name() : __show,
        __role.name() : __role,
        __arcrole.name() : __arcrole,
        __actuate.name() : __actuate
    }
_Namespace_gml.addCategoryObject('typeBinding', u'CoordinateOperationPropertyType', CoordinateOperationPropertyType)


# Complex type DerivedCRSType with content type ELEMENT_ONLY
class DerivedCRSType (AbstractGeneralDerivedCRSType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'DerivedCRSType')
    # Base type is AbstractGeneralDerivedCRSType
    
    # Element {http://www.opengis.net/gml/3.2}baseCRS uses Python identifier baseCRS
    __baseCRS = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'baseCRS'), 'baseCRS', '__httpwww_opengis_netgml3_2_DerivedCRSType_httpwww_opengis_netgml3_2baseCRS', False)

    
    baseCRS = property(__baseCRS.value, __baseCRS.set, None, u'gml:baseCRS is an association role to the coordinate reference system used by this derived CRS.')

    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element conversion ({http://www.opengis.net/gml/3.2}conversion) inherited from {http://www.opengis.net/gml/3.2}AbstractGeneralDerivedCRSType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element domainOfValidity ({http://www.opengis.net/gml/3.2}domainOfValidity) inherited from {http://www.opengis.net/gml/3.2}AbstractCRSType
    
    # Element {http://www.opengis.net/gml/3.2}derivedCRSType uses Python identifier derivedCRSType
    __derivedCRSType = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'derivedCRSType'), 'derivedCRSType', '__httpwww_opengis_netgml3_2_DerivedCRSType_httpwww_opengis_netgml3_2derivedCRSType', False)

    
    derivedCRSType = property(__derivedCRSType.value, __derivedCRSType.set, None, u'The gml:derivedCRSType property describes the type of a derived coordinate reference system. The required codeSpace attribute shall reference a source of information specifying the values and meanings of all the allowed string values for this property.')

    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element scope ({http://www.opengis.net/gml/3.2}scope) inherited from {http://www.opengis.net/gml/3.2}AbstractCRSType
    
    # Element {http://www.opengis.net/gml/3.2}coordinateSystem uses Python identifier coordinateSystem
    __coordinateSystem = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'coordinateSystem'), 'coordinateSystem', '__httpwww_opengis_netgml3_2_DerivedCRSType_httpwww_opengis_netgml3_2coordinateSystem', False)

    
    coordinateSystem = property(__coordinateSystem.value, __coordinateSystem.set, None, u'An association role to the coordinate system used by this CRS.')

    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType

    _ElementMap = AbstractGeneralDerivedCRSType._ElementMap.copy()
    _ElementMap.update({
        __baseCRS.name() : __baseCRS,
        __derivedCRSType.name() : __derivedCRSType,
        __coordinateSystem.name() : __coordinateSystem
    })
    _AttributeMap = AbstractGeneralDerivedCRSType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'DerivedCRSType', DerivedCRSType)


# Complex type LI_ProcessStep_PropertyType with content type ELEMENT_ONLY
class LI_ProcessStep_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'LI_ProcessStep_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}LI_ProcessStep uses Python identifier LI_ProcessStep
    __LI_ProcessStep = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'LI_ProcessStep'), 'LI_ProcessStep', '__httpwww_isotc211_org2005gmd_LI_ProcessStep_PropertyType_httpwww_isotc211_org2005gmdLI_ProcessStep', False)

    
    LI_ProcessStep = property(__LI_ProcessStep.value, __LI_ProcessStep.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_LI_ProcessStep_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_LI_ProcessStep_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_LI_ProcessStep_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_LI_ProcessStep_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_LI_ProcessStep_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_LI_ProcessStep_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_LI_ProcessStep_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_LI_ProcessStep_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_LI_ProcessStep_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")


    _ElementMap = {
        __LI_ProcessStep.name() : __LI_ProcessStep
    }
    _AttributeMap = {
        __type.name() : __type,
        __arcrole.name() : __arcrole,
        __role.name() : __role,
        __uuidref.name() : __uuidref,
        __nilReason.name() : __nilReason,
        __show.name() : __show,
        __title.name() : __title,
        __href.name() : __href,
        __actuate.name() : __actuate
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'LI_ProcessStep_PropertyType', LI_ProcessStep_PropertyType)


# Complex type LI_Lineage_Type with content type ELEMENT_ONLY
class LI_Lineage_Type (AbstractObject_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'LI_Lineage_Type')
    # Base type is AbstractObject_Type
    
    # Element {http://www.isotc211.org/2005/gmd}source uses Python identifier source
    __source = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'source'), 'source', '__httpwww_isotc211_org2005gmd_LI_Lineage_Type_httpwww_isotc211_org2005gmdsource', True)

    
    source = property(__source.value, __source.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}statement uses Python identifier statement
    __statement = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'statement'), 'statement', '__httpwww_isotc211_org2005gmd_LI_Lineage_Type_httpwww_isotc211_org2005gmdstatement', False)

    
    statement = property(__statement.value, __statement.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}processStep uses Python identifier processStep
    __processStep = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'processStep'), 'processStep', '__httpwww_isotc211_org2005gmd_LI_Lineage_Type_httpwww_isotc211_org2005gmdprocessStep', True)

    
    processStep = property(__processStep.value, __processStep.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractObject_Type._ElementMap.copy()
    _ElementMap.update({
        __source.name() : __source,
        __statement.name() : __statement,
        __processStep.name() : __processStep
    })
    _AttributeMap = AbstractObject_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'LI_Lineage_Type', LI_Lineage_Type)


# Complex type PassThroughOperationType with content type ELEMENT_ONLY
class PassThroughOperationType (AbstractCoordinateOperationType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'PassThroughOperationType')
    # Base type is AbstractCoordinateOperationType
    
    # Element sourceCRS ({http://www.opengis.net/gml/3.2}sourceCRS) inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateOperationType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element targetCRS ({http://www.opengis.net/gml/3.2}targetCRS) inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateOperationType
    
    # Element domainOfValidity ({http://www.opengis.net/gml/3.2}domainOfValidity) inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateOperationType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}modifiedCoordinate uses Python identifier modifiedCoordinate
    __modifiedCoordinate = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'modifiedCoordinate'), 'modifiedCoordinate', '__httpwww_opengis_netgml3_2_PassThroughOperationType_httpwww_opengis_netgml3_2modifiedCoordinate', True)

    
    modifiedCoordinate = property(__modifiedCoordinate.value, __modifiedCoordinate.set, None, u'gml:modifiedCoordinate is a positive integer defining a position in a coordinate tuple.')

    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element operationVersion ({http://www.opengis.net/gml/3.2}operationVersion) inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateOperationType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element scope ({http://www.opengis.net/gml/3.2}scope) inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateOperationType
    
    # Element {http://www.opengis.net/gml/3.2}coordOperation uses Python identifier coordOperation
    __coordOperation = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'coordOperation'), 'coordOperation', '__httpwww_opengis_netgml3_2_PassThroughOperationType_httpwww_opengis_netgml3_2coordOperation', False)

    
    coordOperation = property(__coordOperation.value, __coordOperation.set, None, u'gml:coordOperation is an association role to a coordinate operation.')

    
    # Element coordinateOperationAccuracy ({http://www.opengis.net/gml/3.2}coordinateOperationAccuracy) inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateOperationType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Attribute aggregationType uses Python identifier aggregationType
    __aggregationType = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'aggregationType'), 'aggregationType', '__httpwww_opengis_netgml3_2_PassThroughOperationType_aggregationType', AggregationType)
    
    aggregationType = property(__aggregationType.value, __aggregationType.set, None, None)

    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType

    _ElementMap = AbstractCoordinateOperationType._ElementMap.copy()
    _ElementMap.update({
        __modifiedCoordinate.name() : __modifiedCoordinate,
        __coordOperation.name() : __coordOperation
    })
    _AttributeMap = AbstractCoordinateOperationType._AttributeMap.copy()
    _AttributeMap.update({
        __aggregationType.name() : __aggregationType
    })
_Namespace_gml.addCategoryObject('typeBinding', u'PassThroughOperationType', PassThroughOperationType)


# Complex type CurveSegmentArrayPropertyType with content type ELEMENT_ONLY
class CurveSegmentArrayPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'CurveSegmentArrayPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}AbstractCurveSegment uses Python identifier AbstractCurveSegment
    __AbstractCurveSegment = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractCurveSegment'), 'AbstractCurveSegment', '__httpwww_opengis_netgml3_2_CurveSegmentArrayPropertyType_httpwww_opengis_netgml3_2AbstractCurveSegment', True)

    
    AbstractCurveSegment = property(__AbstractCurveSegment.value, __AbstractCurveSegment.set, None, u'A curve segment defines a homogeneous segment of a curve.\nThe attributes numDerivativesAtStart, numDerivativesAtEnd and numDerivativesInterior specify the type of continuity as specified in ISO 19107:2003, 6.4.9.3.\nThe AbstractCurveSegment element is the abstract head of the substituition group for all curve segment elements, i.e. continuous segments of the same interpolation mechanism.\nAll curve segments shall have an attribute interpolation with type gml:CurveInterpolationType specifying the curve interpolation mechanism used for this segment. This mechanism uses the control points and control parameters to determine the position of this curve segment.')


    _ElementMap = {
        __AbstractCurveSegment.name() : __AbstractCurveSegment
    }
    _AttributeMap = {
        
    }
_Namespace_gml.addCategoryObject('typeBinding', u'CurveSegmentArrayPropertyType', CurveSegmentArrayPropertyType)


# Complex type PT_Locale_PropertyType with content type ELEMENT_ONLY
class PT_Locale_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'PT_Locale_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}PT_Locale uses Python identifier PT_Locale
    __PT_Locale = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'PT_Locale'), 'PT_Locale', '__httpwww_isotc211_org2005gmd_PT_Locale_PropertyType_httpwww_isotc211_org2005gmdPT_Locale', False)

    
    PT_Locale = property(__PT_Locale.value, __PT_Locale.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_PT_Locale_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_PT_Locale_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_PT_Locale_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_PT_Locale_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_PT_Locale_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_PT_Locale_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_PT_Locale_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_PT_Locale_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_PT_Locale_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")


    _ElementMap = {
        __PT_Locale.name() : __PT_Locale
    }
    _AttributeMap = {
        __type.name() : __type,
        __arcrole.name() : __arcrole,
        __role.name() : __role,
        __nilReason.name() : __nilReason,
        __title.name() : __title,
        __uuidref.name() : __uuidref,
        __href.name() : __href,
        __show.name() : __show,
        __actuate.name() : __actuate
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'PT_Locale_PropertyType', PT_Locale_PropertyType)


# Complex type LI_Source_PropertyType with content type ELEMENT_ONLY
class LI_Source_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'LI_Source_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}LI_Source uses Python identifier LI_Source
    __LI_Source = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'LI_Source'), 'LI_Source', '__httpwww_isotc211_org2005gmd_LI_Source_PropertyType_httpwww_isotc211_org2005gmdLI_Source', False)

    
    LI_Source = property(__LI_Source.value, __LI_Source.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_LI_Source_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_LI_Source_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_LI_Source_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_LI_Source_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_LI_Source_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_LI_Source_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_LI_Source_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_LI_Source_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_LI_Source_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)


    _ElementMap = {
        __LI_Source.name() : __LI_Source
    }
    _AttributeMap = {
        __type.name() : __type,
        __arcrole.name() : __arcrole,
        __role.name() : __role,
        __nilReason.name() : __nilReason,
        __uuidref.name() : __uuidref,
        __actuate.name() : __actuate,
        __show.name() : __show,
        __title.name() : __title,
        __href.name() : __href
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'LI_Source_PropertyType', LI_Source_PropertyType)


# Complex type Multiplicity_Type with content type ELEMENT_ONLY
class Multiplicity_Type (AbstractObject_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gco, u'Multiplicity_Type')
    # Base type is AbstractObject_Type
    
    # Element {http://www.isotc211.org/2005/gco}range uses Python identifier range
    __range = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'range'), 'range', '__httpwww_isotc211_org2005gco_Multiplicity_Type_httpwww_isotc211_org2005gcorange', True)

    
    range = property(__range.value, __range.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractObject_Type._ElementMap.copy()
    _ElementMap.update({
        __range.name() : __range
    })
    _AttributeMap = AbstractObject_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gco.addCategoryObject('typeBinding', u'Multiplicity_Type', Multiplicity_Type)


# Complex type VerticalCRSType with content type ELEMENT_ONLY
class VerticalCRSType (AbstractCRSType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'VerticalCRSType')
    # Base type is AbstractCRSType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}verticalDatum uses Python identifier verticalDatum
    __verticalDatum = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'verticalDatum'), 'verticalDatum', '__httpwww_opengis_netgml3_2_VerticalCRSType_httpwww_opengis_netgml3_2verticalDatum', False)

    
    verticalDatum = property(__verticalDatum.value, __verticalDatum.set, None, u'gml:verticalDatum is an association role to the vertical datum used by this CRS.')

    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element domainOfValidity ({http://www.opengis.net/gml/3.2}domainOfValidity) inherited from {http://www.opengis.net/gml/3.2}AbstractCRSType
    
    # Element {http://www.opengis.net/gml/3.2}verticalCS uses Python identifier verticalCS
    __verticalCS = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'verticalCS'), 'verticalCS', '__httpwww_opengis_netgml3_2_VerticalCRSType_httpwww_opengis_netgml3_2verticalCS', False)

    
    verticalCS = property(__verticalCS.value, __verticalCS.set, None, u'gml:verticalCS is an association role to the vertical coordinate system used by this CRS.')

    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element scope ({http://www.opengis.net/gml/3.2}scope) inherited from {http://www.opengis.net/gml/3.2}AbstractCRSType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType

    _ElementMap = AbstractCRSType._ElementMap.copy()
    _ElementMap.update({
        __verticalDatum.name() : __verticalDatum,
        __verticalCS.name() : __verticalCS
    })
    _AttributeMap = AbstractCRSType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'VerticalCRSType', VerticalCRSType)


# Complex type IndirectEntryType with content type ELEMENT_ONLY
class IndirectEntryType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'IndirectEntryType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}DefinitionProxy uses Python identifier DefinitionProxy
    __DefinitionProxy = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'DefinitionProxy'), 'DefinitionProxy', '__httpwww_opengis_netgml3_2_IndirectEntryType_httpwww_opengis_netgml3_2DefinitionProxy', False)

    
    DefinitionProxy = property(__DefinitionProxy.value, __DefinitionProxy.set, None, u'')


    _ElementMap = {
        __DefinitionProxy.name() : __DefinitionProxy
    }
    _AttributeMap = {
        
    }
_Namespace_gml.addCategoryObject('typeBinding', u'IndirectEntryType', IndirectEntryType)


# Complex type AbstractGeometricPrimitiveType with content type ELEMENT_ONLY
class AbstractGeometricPrimitiveType (AbstractGeometryType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractGeometricPrimitiveType')
    # Base type is AbstractGeometryType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute srsName inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute axisLabels inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute uomLabels inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute srsDimension inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType

    _ElementMap = AbstractGeometryType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractGeometryType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractGeometricPrimitiveType', AbstractGeometricPrimitiveType)


# Complex type AbstractSurfaceType with content type ELEMENT_ONLY
class AbstractSurfaceType (AbstractGeometricPrimitiveType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractSurfaceType')
    # Base type is AbstractGeometricPrimitiveType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute srsName inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute axisLabels inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute uomLabels inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute srsDimension inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType

    _ElementMap = AbstractGeometricPrimitiveType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractGeometricPrimitiveType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractSurfaceType', AbstractSurfaceType)


# Complex type OrientableSurfaceType with content type ELEMENT_ONLY
class OrientableSurfaceType (AbstractSurfaceType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'OrientableSurfaceType')
    # Base type is AbstractSurfaceType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}baseSurface uses Python identifier baseSurface
    __baseSurface = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'baseSurface'), 'baseSurface', '__httpwww_opengis_netgml3_2_OrientableSurfaceType_httpwww_opengis_netgml3_2baseSurface', False)

    
    baseSurface = property(__baseSurface.value, __baseSurface.set, None, u'The property baseSurface references or contains the base surface. The property baseSurface either references the base surface via the XLink-attributes or contains the surface element. A surface element is any element which is substitutable for gml:AbstractSurface. The base surface has positive orientation.')

    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute orientation uses Python identifier orientation
    __orientation = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'orientation'), 'orientation', '__httpwww_opengis_netgml3_2_OrientableSurfaceType_orientation', SignType, unicode_default=u'+')
    
    orientation = property(__orientation.value, __orientation.set, None, None)

    
    # Attribute uomLabels inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute srsName inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute srsDimension inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute axisLabels inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType

    _ElementMap = AbstractSurfaceType._ElementMap.copy()
    _ElementMap.update({
        __baseSurface.name() : __baseSurface
    })
    _AttributeMap = AbstractSurfaceType._AttributeMap.copy()
    _AttributeMap.update({
        __orientation.name() : __orientation
    })
_Namespace_gml.addCategoryObject('typeBinding', u'OrientableSurfaceType', OrientableSurfaceType)


# Complex type CTD_ANON_3 with content type SIMPLE
class CTD_ANON_3 (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = pyxb.binding.datatypes.boolean
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_SIMPLE
    _Abstract = False
    _ExpandedName = None
    # Base type is pyxb.binding.datatypes.boolean
    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_CTD_ANON_3_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason
    }



# Complex type AbstractDQ_ThematicAccuracy_Type with content type ELEMENT_ONLY
class AbstractDQ_ThematicAccuracy_Type (AbstractDQ_Element_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'AbstractDQ_ThematicAccuracy_Type')
    # Base type is AbstractDQ_Element_Type
    
    # Element evaluationMethodDescription ({http://www.isotc211.org/2005/gmd}evaluationMethodDescription) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element measureDescription ({http://www.isotc211.org/2005/gmd}measureDescription) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element evaluationProcedure ({http://www.isotc211.org/2005/gmd}evaluationProcedure) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element evaluationMethodType ({http://www.isotc211.org/2005/gmd}evaluationMethodType) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element dateTime ({http://www.isotc211.org/2005/gmd}dateTime) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element result ({http://www.isotc211.org/2005/gmd}result) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element nameOfMeasure ({http://www.isotc211.org/2005/gmd}nameOfMeasure) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element measureIdentification ({http://www.isotc211.org/2005/gmd}measureIdentification) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractDQ_Element_Type._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractDQ_Element_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'AbstractDQ_ThematicAccuracy_Type', AbstractDQ_ThematicAccuracy_Type)


# Complex type PT_LocaleContainer_Type with content type ELEMENT_ONLY
class PT_LocaleContainer_Type (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'PT_LocaleContainer_Type')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}localisedString uses Python identifier localisedString
    __localisedString = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'localisedString'), 'localisedString', '__httpwww_isotc211_org2005gmd_PT_LocaleContainer_Type_httpwww_isotc211_org2005gmdlocalisedString', True)

    
    localisedString = property(__localisedString.value, __localisedString.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}description uses Python identifier description
    __description = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'description'), 'description', '__httpwww_isotc211_org2005gmd_PT_LocaleContainer_Type_httpwww_isotc211_org2005gmddescription', False)

    
    description = property(__description.value, __description.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}locale uses Python identifier locale
    __locale = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'locale'), 'locale', '__httpwww_isotc211_org2005gmd_PT_LocaleContainer_Type_httpwww_isotc211_org2005gmdlocale', False)

    
    locale = property(__locale.value, __locale.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}responsibleParty uses Python identifier responsibleParty
    __responsibleParty = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'responsibleParty'), 'responsibleParty', '__httpwww_isotc211_org2005gmd_PT_LocaleContainer_Type_httpwww_isotc211_org2005gmdresponsibleParty', True)

    
    responsibleParty = property(__responsibleParty.value, __responsibleParty.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}date uses Python identifier date
    __date = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'date'), 'date', '__httpwww_isotc211_org2005gmd_PT_LocaleContainer_Type_httpwww_isotc211_org2005gmddate', True)

    
    date = property(__date.value, __date.set, None, None)


    _ElementMap = {
        __localisedString.name() : __localisedString,
        __description.name() : __description,
        __locale.name() : __locale,
        __responsibleParty.name() : __responsibleParty,
        __date.name() : __date
    }
    _AttributeMap = {
        
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'PT_LocaleContainer_Type', PT_LocaleContainer_Type)


# Complex type MD_MaintenanceFrequencyCode_PropertyType with content type ELEMENT_ONLY
class MD_MaintenanceFrequencyCode_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_MaintenanceFrequencyCode_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}MD_MaintenanceFrequencyCode uses Python identifier MD_MaintenanceFrequencyCode
    __MD_MaintenanceFrequencyCode = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_MaintenanceFrequencyCode'), 'MD_MaintenanceFrequencyCode', '__httpwww_isotc211_org2005gmd_MD_MaintenanceFrequencyCode_PropertyType_httpwww_isotc211_org2005gmdMD_MaintenanceFrequencyCode', False)

    
    MD_MaintenanceFrequencyCode = property(__MD_MaintenanceFrequencyCode.value, __MD_MaintenanceFrequencyCode.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_MD_MaintenanceFrequencyCode_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        __MD_MaintenanceFrequencyCode.name() : __MD_MaintenanceFrequencyCode
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_MaintenanceFrequencyCode_PropertyType', MD_MaintenanceFrequencyCode_PropertyType)


# Complex type ValuePropertyType with content type ELEMENT_ONLY
class ValuePropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'ValuePropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}AbstractValue uses Python identifier AbstractValue
    __AbstractValue = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractValue'), 'AbstractValue', '__httpwww_opengis_netgml3_2_ValuePropertyType_httpwww_opengis_netgml3_2AbstractValue', False)

    
    AbstractValue = property(__AbstractValue.value, __AbstractValue.set, None, u'gml:AbstractValue is an abstract element which acts as the head of a substitution group which contains gml:AbstractScalarValue, gml:AbstractScalarValueList, gml:CompositeValue and gml:ValueExtent, and (transitively) the elements in their substitution groups.\nThese elements may be used in an application schema as variables, so that in an XML instance document any member of its substitution group may occur.')

    
    # Element {http://www.opengis.net/gml/3.2}AbstractGeometry uses Python identifier AbstractGeometry
    __AbstractGeometry = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractGeometry'), 'AbstractGeometry', '__httpwww_opengis_netgml3_2_ValuePropertyType_httpwww_opengis_netgml3_2AbstractGeometry', False)

    
    AbstractGeometry = property(__AbstractGeometry.value, __AbstractGeometry.set, None, u'The AbstractGeometry element is the abstract head of the substitution group for all geometry elements of GML. This includes pre-defined and user-defined geometry elements. Any geometry element shall be a direct or indirect extension/restriction of AbstractGeometryType and shall be directly or indirectly in the substitution group of AbstractGeometry.')

    
    # Element {http://www.opengis.net/gml/3.2}AbstractTimeObject uses Python identifier AbstractTimeObject
    __AbstractTimeObject = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractTimeObject'), 'AbstractTimeObject', '__httpwww_opengis_netgml3_2_ValuePropertyType_httpwww_opengis_netgml3_2AbstractTimeObject', False)

    
    AbstractTimeObject = property(__AbstractTimeObject.value, __AbstractTimeObject.set, None, u'gml:AbstractTimeObject acts as the head of a substitution group for all temporal primitives and complexes.')

    
    # Element {http://www.opengis.net/gml/3.2}Null uses Python identifier Null
    __Null = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'Null'), 'Null', '__httpwww_opengis_netgml3_2_ValuePropertyType_httpwww_opengis_netgml3_2Null', False)

    
    Null = property(__Null.value, __Null.set, None, u'')

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_ValuePropertyType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_ValuePropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_ValuePropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_ValuePropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_ValuePropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_ValuePropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_ValuePropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_ValuePropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_ValuePropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_ValuePropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")


    _ElementMap = {
        __AbstractValue.name() : __AbstractValue,
        __AbstractGeometry.name() : __AbstractGeometry,
        __AbstractTimeObject.name() : __AbstractTimeObject,
        __Null.name() : __Null
    }
    _AttributeMap = {
        __owns.name() : __owns,
        __href.name() : __href,
        __role.name() : __role,
        __arcrole.name() : __arcrole,
        __type.name() : __type,
        __title.name() : __title,
        __nilReason.name() : __nilReason,
        __remoteSchema.name() : __remoteSchema,
        __show.name() : __show,
        __actuate.name() : __actuate
    }
_Namespace_gml.addCategoryObject('typeBinding', u'ValuePropertyType', ValuePropertyType)


# Complex type PointType with content type ELEMENT_ONLY
class PointType (AbstractGeometricPrimitiveType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'PointType')
    # Base type is AbstractGeometricPrimitiveType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}pos uses Python identifier pos
    __pos = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'pos'), 'pos', '__httpwww_opengis_netgml3_2_PointType_httpwww_opengis_netgml3_2pos', False)

    
    pos = property(__pos.value, __pos.set, None, None)

    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}coordinates uses Python identifier coordinates
    __coordinates = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'coordinates'), 'coordinates', '__httpwww_opengis_netgml3_2_PointType_httpwww_opengis_netgml3_2coordinates', False)

    
    coordinates = property(__coordinates.value, __coordinates.set, None, u'')

    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute srsName inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute axisLabels inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute uomLabels in