/*
 * PSVIUni.cpp
 *
 *  Created on: 2013/03/11
 *      Author: mugwort_rc
 */

#include "PSVIUni.h"

#include <boost/python.hpp>
#include <xercesc/util/PSVIUni.hpp>

#include "XMLString.h"

namespace pyxerces {

void PSVIUni_init(void) {
	//! xercesc::PSVIUni
	boost::python::class_<xercesc::PSVIUni, boost::noncopyable>("PSVIUni", boost::python::no_init)
			.setattr("fgPsvColon", XMLChPtr(xercesc::PSVIUni::fgPsvColon))

			//Infoset Element Names
			.setattr("fgAllDeclarationsProcessed", XMLChPtr(xercesc::PSVIUni::fgAllDeclarationsProcessed))
			.setattr("fgAttribute", XMLChPtr(xercesc::PSVIUni::fgAttribute))
			.setattr("fgAttributes", XMLChPtr(xercesc::PSVIUni::fgAttributes))
			.setattr("fgAttributeType", XMLChPtr(xercesc::PSVIUni::fgAttributeType))
			.setattr("fgBaseURI", XMLChPtr(xercesc::PSVIUni::fgBaseURI))
			.setattr("fgCharacter", XMLChPtr(xercesc::PSVIUni::fgCharacter))
			.setattr("fgCharacterEncodingScheme", XMLChPtr(xercesc::PSVIUni::fgCharacterEncodingScheme))
			.setattr("fgChildren", XMLChPtr(xercesc::PSVIUni::fgChildren))
			.setattr("fgComment", XMLChPtr(xercesc::PSVIUni::fgComment))
			.setattr("fgContent", XMLChPtr(xercesc::PSVIUni::fgContent))
			.setattr("fgDocument", XMLChPtr(xercesc::PSVIUni::fgDocument))
			.setattr("fgDocTypeDeclaration", XMLChPtr(xercesc::PSVIUni::fgDocTypeDeclaration))
			.setattr("fgDocumentElement", XMLChPtr(xercesc::PSVIUni::fgDocumentElement))
			.setattr("fgElement", XMLChPtr(xercesc::PSVIUni::fgElement))
			.setattr("fgInScopeNamespaces", XMLChPtr(xercesc::PSVIUni::fgInScopeNamespaces))
			.setattr("fgLocalName", XMLChPtr(xercesc::PSVIUni::fgLocalName))
			.setattr("fgNamespace", XMLChPtr(xercesc::PSVIUni::fgNamespace))
			.setattr("fgNamespaceAttributes", XMLChPtr(xercesc::PSVIUni::fgNamespaceAttributes))
			.setattr("fgNamespaceName", XMLChPtr(xercesc::PSVIUni::fgNamespaceName))
			.setattr("fgNormalizedValue", XMLChPtr(xercesc::PSVIUni::fgNormalizedValue))
			.setattr("fgNotations", XMLChPtr(xercesc::PSVIUni::fgNotations))
			.setattr("fgPrefix", XMLChPtr(xercesc::PSVIUni::fgPrefix))
			.setattr("fgProcessingInstruction", XMLChPtr(xercesc::PSVIUni::fgProcessingInstruction))
			.setattr("fgReferences", XMLChPtr(xercesc::PSVIUni::fgReferences))
			.setattr("fgSpecified", XMLChPtr(xercesc::PSVIUni::fgSpecified))
			.setattr("fgStandalone", XMLChPtr(xercesc::PSVIUni::fgStandalone))
			.setattr("fgTarget", XMLChPtr(xercesc::PSVIUni::fgTarget))
			.setattr("fgText", XMLChPtr(xercesc::PSVIUni::fgText))
			.setattr("fgTextContent", XMLChPtr(xercesc::PSVIUni::fgTextContent))
			.setattr("fgUnparsedEntities", XMLChPtr(xercesc::PSVIUni::fgUnparsedEntities))
			.setattr("fgVersion", XMLChPtr(xercesc::PSVIUni::fgVersion))

			//PSVI Element Names
			.setattr("fgAbstract", XMLChPtr(xercesc::PSVIUni::fgAbstract))
			.setattr("fgAnnotation", XMLChPtr(xercesc::PSVIUni::fgAnnotation))
			.setattr("fgAnnotations", XMLChPtr(xercesc::PSVIUni::fgAnnotations))
			.setattr("fgApplicationInformation", XMLChPtr(xercesc::PSVIUni::fgApplicationInformation))
			.setattr("fgAttributeDeclaration", XMLChPtr(xercesc::PSVIUni::fgAttributeDeclaration))
			.setattr("fgAttributeGroupDefinition", XMLChPtr(xercesc::PSVIUni::fgAttributeGroupDefinition))
			.setattr("fgAttributeUse", XMLChPtr(xercesc::PSVIUni::fgAttributeUse))
			.setattr("fgAttributeUses", XMLChPtr(xercesc::PSVIUni::fgAttributeUses))
			.setattr("fgAttributeWildcard", XMLChPtr(xercesc::PSVIUni::fgAttributeWildcard))
			.setattr("fgBaseTypeDefinition", XMLChPtr(xercesc::PSVIUni::fgBaseTypeDefinition))
			.setattr("fgCanonicalRepresentation", XMLChPtr(xercesc::PSVIUni::fgCanonicalRepresentation))
			.setattr("fgComplexTypeDefinition", XMLChPtr(xercesc::PSVIUni::fgComplexTypeDefinition))
			.setattr("fgCompositor", XMLChPtr(xercesc::PSVIUni::fgCompositor))
			.setattr("fgContentType", XMLChPtr(xercesc::PSVIUni::fgContentType))
			.setattr("fgDeclaration", XMLChPtr(xercesc::PSVIUni::fgDeclaration))
			.setattr("fgDerivationMethod", XMLChPtr(xercesc::PSVIUni::fgDerivationMethod))
			.setattr("fgDisallowedSubstitutions", XMLChPtr(xercesc::PSVIUni::fgDisallowedSubstitutions))
			.setattr("fgPsvDocument", XMLChPtr(xercesc::PSVIUni::fgPsvDocument))
			.setattr("fgDocumentLocation", XMLChPtr(xercesc::PSVIUni::fgDocumentLocation))
			.setattr("fgElementDeclaration", XMLChPtr(xercesc::PSVIUni::fgElementDeclaration))
			.setattr("fgFacets", XMLChPtr(xercesc::PSVIUni::fgFacets))
			.setattr("fgFacetFixed", XMLChPtr(xercesc::PSVIUni::fgFacetFixed))
			.setattr("fgFields", XMLChPtr(xercesc::PSVIUni::fgFields))
			.setattr("fgFinal", XMLChPtr(xercesc::PSVIUni::fgFinal))
			.setattr("fgFundamentalFacets", XMLChPtr(xercesc::PSVIUni::fgFundamentalFacets))
			.setattr("fgIdentityConstraintCategory", XMLChPtr(xercesc::PSVIUni::fgIdentityConstraintCategory))
			.setattr("fgIdentityConstraintDefinition", XMLChPtr(xercesc::PSVIUni::fgIdentityConstraintDefinition))
			.setattr("fgIdentityConstraintDefinitions", XMLChPtr(xercesc::PSVIUni::fgIdentityConstraintDefinitions))
			.setattr("fgIdentityConstraintTable", XMLChPtr(xercesc::PSVIUni::fgIdentityConstraintTable))
			.setattr("fgIdIdrefTable", XMLChPtr(xercesc::PSVIUni::fgIdIdrefTable))
			.setattr("fgItemTypeDefinition", XMLChPtr(xercesc::PSVIUni::fgItemTypeDefinition))
			.setattr("fgMaxOccurs", XMLChPtr(xercesc::PSVIUni::fgMaxOccurs))
			.setattr("fgMemberTypeDefinition", XMLChPtr(xercesc::PSVIUni::fgMemberTypeDefinition))
			.setattr("fgMemberTypeDefinitions", XMLChPtr(xercesc::PSVIUni::fgMemberTypeDefinitions))
			.setattr("fgMinOccurs", XMLChPtr(xercesc::PSVIUni::fgMinOccurs))
			.setattr("fgModelGroup", XMLChPtr(xercesc::PSVIUni::fgModelGroup))
			.setattr("fgModelGroupDefinition", XMLChPtr(xercesc::PSVIUni::fgModelGroupDefinition))
			.setattr("fgName", XMLChPtr(xercesc::PSVIUni::fgName))
			.setattr("fgNamespaceConstraint", XMLChPtr(xercesc::PSVIUni::fgNamespaceConstraint))
			.setattr("fgNamespaces", XMLChPtr(xercesc::PSVIUni::fgNamespaces))
			.setattr("fgNamespaceSchemaInformation", XMLChPtr(xercesc::PSVIUni::fgNamespaceSchemaInformation))
			.setattr("fgNil", XMLChPtr(xercesc::PSVIUni::fgNil))
			.setattr("fgNillable", XMLChPtr(xercesc::PSVIUni::fgNillable))
			.setattr("fgNotation", XMLChPtr(xercesc::PSVIUni::fgNotation))
			.setattr("fgNotationDeclaration", XMLChPtr(xercesc::PSVIUni::fgNotationDeclaration))
			.setattr("fgParticle", XMLChPtr(xercesc::PSVIUni::fgParticle))
			.setattr("fgParticles", XMLChPtr(xercesc::PSVIUni::fgParticles))
			.setattr("fgPrimitiveTypeDefinition", XMLChPtr(xercesc::PSVIUni::fgPrimitiveTypeDefinition))
			.setattr("fgProcessContents", XMLChPtr(xercesc::PSVIUni::fgProcessContents))
			.setattr("fgProhibitedSubstitutions", XMLChPtr(xercesc::PSVIUni::fgProhibitedSubstitutions))
			.setattr("fgPublicIdentifier", XMLChPtr(xercesc::PSVIUni::fgPublicIdentifier))
			.setattr("fgReferencedKey", XMLChPtr(xercesc::PSVIUni::fgReferencedKey))
			.setattr("fgRequired", XMLChPtr(xercesc::PSVIUni::fgRequired))
			.setattr("fgSchemaAnnotations", XMLChPtr(xercesc::PSVIUni::fgSchemaAnnotations))
			.setattr("fgSchemaComponents", XMLChPtr(xercesc::PSVIUni::fgSchemaComponents))
			.setattr("fgSchemaDefault", XMLChPtr(xercesc::PSVIUni::fgSchemaDefault))
			.setattr("fgSchemaDocument", XMLChPtr(xercesc::PSVIUni::fgSchemaDocument))
			.setattr("fgSchemaDocuments", XMLChPtr(xercesc::PSVIUni::fgSchemaDocuments))
			.setattr("fgSchemaErrorCode", XMLChPtr(xercesc::PSVIUni::fgSchemaErrorCode))
			.setattr("fgSchemaInformation", XMLChPtr(xercesc::PSVIUni::fgSchemaInformation))
			.setattr("fgSchemaNamespace", XMLChPtr(xercesc::PSVIUni::fgSchemaNamespace))
			.setattr("fgSchemaNormalizedValue", XMLChPtr(xercesc::PSVIUni::fgSchemaNormalizedValue))
			.setattr("fgSchemaSpecified", XMLChPtr(xercesc::PSVIUni::fgSchemaSpecified))
			.setattr("fgScope", XMLChPtr(xercesc::PSVIUni::fgScope))
			.setattr("fgSelector", XMLChPtr(xercesc::PSVIUni::fgSelector))
			.setattr("fgSimpleTypeDefinition", XMLChPtr(xercesc::PSVIUni::fgSimpleTypeDefinition))
			.setattr("fgSubstitutionGroupAffiliation", XMLChPtr(xercesc::PSVIUni::fgSubstitutionGroupAffiliation))
			.setattr("fgSubstitutionGroupExclusions", XMLChPtr(xercesc::PSVIUni::fgSubstitutionGroupExclusions))
			.setattr("fgSystemIdentifier", XMLChPtr(xercesc::PSVIUni::fgSystemIdentifier))
			.setattr("fgTargetNamespace", XMLChPtr(xercesc::PSVIUni::fgTargetNamespace))
			.setattr("fgTerm", XMLChPtr(xercesc::PSVIUni::fgTerm))
			.setattr("fgTypeDefinition", XMLChPtr(xercesc::PSVIUni::fgTypeDefinition))
			.setattr("fgUserInformation", XMLChPtr(xercesc::PSVIUni::fgUserInformation))
			.setattr("fgValidationAttempted", XMLChPtr(xercesc::PSVIUni::fgValidationAttempted))
			.setattr("fgValidationContext", XMLChPtr(xercesc::PSVIUni::fgValidationContext))
			.setattr("fgValidity", XMLChPtr(xercesc::PSVIUni::fgValidity))
			.setattr("fgValue", XMLChPtr(xercesc::PSVIUni::fgValue))
			.setattr("fgValueConstraint", XMLChPtr(xercesc::PSVIUni::fgValueConstraint))
			.setattr("fgVariety", XMLChPtr(xercesc::PSVIUni::fgVariety))
			.setattr("fgWildcard", XMLChPtr(xercesc::PSVIUni::fgWildcard))
			.setattr("fgXpath", XMLChPtr(xercesc::PSVIUni::fgXpath))

			//PSVI Element Values
			.setattr("fgAll", XMLChPtr(xercesc::PSVIUni::fgAll))
			.setattr("fgAny", XMLChPtr(xercesc::PSVIUni::fgAny))
			.setattr("fgAppinfo", XMLChPtr(xercesc::PSVIUni::fgAppinfo))
			.setattr("fgAtomic", XMLChPtr(xercesc::PSVIUni::fgAtomic))
			.setattr("fgChoice", XMLChPtr(xercesc::PSVIUni::fgChoice))
			.setattr("fgDefault", XMLChPtr(xercesc::PSVIUni::fgDefault))
			.setattr("fgDocumentation", XMLChPtr(xercesc::PSVIUni::fgDocumentation))
			.setattr("fgElementOnly", XMLChPtr(xercesc::PSVIUni::fgElementOnly))
			.setattr("fgEmpty", XMLChPtr(xercesc::PSVIUni::fgEmpty))
			.setattr("fgExtension", XMLChPtr(xercesc::PSVIUni::fgExtension))
			.setattr("fgFalse", XMLChPtr(xercesc::PSVIUni::fgFalse))
			.setattr("fgFull", XMLChPtr(xercesc::PSVIUni::fgFull))
			.setattr("fgGlobal", XMLChPtr(xercesc::PSVIUni::fgGlobal))
			.setattr("fgInfoset", XMLChPtr(xercesc::PSVIUni::fgInfoset))
			.setattr("fgInvalid", XMLChPtr(xercesc::PSVIUni::fgInvalid))
			.setattr("fgKey", XMLChPtr(xercesc::PSVIUni::fgKey))
			.setattr("fgKeyref", XMLChPtr(xercesc::PSVIUni::fgKeyref))
			.setattr("fgLax", XMLChPtr(xercesc::PSVIUni::fgLax))
			.setattr("fgList", XMLChPtr(xercesc::PSVIUni::fgList))
			.setattr("fgLocal", XMLChPtr(xercesc::PSVIUni::fgLocal))
			.setattr("fgMixed", XMLChPtr(xercesc::PSVIUni::fgMixed))
			.setattr("fgNone", XMLChPtr(xercesc::PSVIUni::fgNone))
			.setattr("fgNotKnown", XMLChPtr(xercesc::PSVIUni::fgNotKnown))
			.setattr("fgNsNamespace", XMLChPtr(xercesc::PSVIUni::fgNsNamespace))
			.setattr("fgOnePointZero", XMLChPtr(xercesc::PSVIUni::fgOnePointZero))
			.setattr("fgPartial", XMLChPtr(xercesc::PSVIUni::fgPartial))
			.setattr("fgRestrict", XMLChPtr(xercesc::PSVIUni::fgRestrict))
			.setattr("fgRestriction", XMLChPtr(xercesc::PSVIUni::fgRestriction))
			.setattr("fgSchema", XMLChPtr(xercesc::PSVIUni::fgSchema))
			.setattr("fgSequence", XMLChPtr(xercesc::PSVIUni::fgSequence))
			.setattr("fgSimple", XMLChPtr(xercesc::PSVIUni::fgSimple))
			.setattr("fgSkip", XMLChPtr(xercesc::PSVIUni::fgSkip))
			.setattr("fgStrict", XMLChPtr(xercesc::PSVIUni::fgStrict))
			.setattr("fgSubstitution", XMLChPtr(xercesc::PSVIUni::fgSubstitution))
			.setattr("fgTotal", XMLChPtr(xercesc::PSVIUni::fgTotal))
			.setattr("fgTrue", XMLChPtr(xercesc::PSVIUni::fgTrue))
			.setattr("fgUnbounded", XMLChPtr(xercesc::PSVIUni::fgUnbounded))
			.setattr("fgUnion", XMLChPtr(xercesc::PSVIUni::fgUnion))
			.setattr("fgUnique", XMLChPtr(xercesc::PSVIUni::fgUnique))
			.setattr("fgUnknown", XMLChPtr(xercesc::PSVIUni::fgUnknown))
			.setattr("fgValid", XMLChPtr(xercesc::PSVIUni::fgValid))
			.setattr("fgVCFixed", XMLChPtr(xercesc::PSVIUni::fgVCFixed))
			.setattr("fgXMLChNull", XMLChPtr(xercesc::PSVIUni::fgXMLChNull))

			//PSVI Element Types (Shortened)
			.setattr("fgAg", XMLChPtr(xercesc::PSVIUni::fgAg))
			.setattr("fgAnnot", XMLChPtr(xercesc::PSVIUni::fgAnnot))
			.setattr("fgAttr", XMLChPtr(xercesc::PSVIUni::fgAttr))
			.setattr("fgAu", XMLChPtr(xercesc::PSVIUni::fgAu))
			.setattr("fgElt", XMLChPtr(xercesc::PSVIUni::fgElt))
			.setattr("fgIdc", XMLChPtr(xercesc::PSVIUni::fgIdc))
			.setattr("fgMg", XMLChPtr(xercesc::PSVIUni::fgMg))
			.setattr("fgNot", XMLChPtr(xercesc::PSVIUni::fgNot))
			.setattr("fgType", XMLChPtr(xercesc::PSVIUni::fgType))

			//Facets
			.setattr("fgBounded", XMLChPtr(xercesc::PSVIUni::fgBounded))
			.setattr("fgCardinality", XMLChPtr(xercesc::PSVIUni::fgCardinality))
			.setattr("fgEnumeration", XMLChPtr(xercesc::PSVIUni::fgEnumeration))
			.setattr("fgFractionDigits", XMLChPtr(xercesc::PSVIUni::fgFractionDigits))
			.setattr("fgLength", XMLChPtr(xercesc::PSVIUni::fgLength))
			.setattr("fgMaxExclusive", XMLChPtr(xercesc::PSVIUni::fgMaxExclusive))
			.setattr("fgMaxInclusive", XMLChPtr(xercesc::PSVIUni::fgMaxInclusive))
			.setattr("fgMaxLength", XMLChPtr(xercesc::PSVIUni::fgMaxLength))
			.setattr("fgMinExclusive", XMLChPtr(xercesc::PSVIUni::fgMinExclusive))
			.setattr("fgMinInclusive", XMLChPtr(xercesc::PSVIUni::fgMinInclusive))
			.setattr("fgMinLength", XMLChPtr(xercesc::PSVIUni::fgMinLength))
			.setattr("fgNumeric", XMLChPtr(xercesc::PSVIUni::fgNumeric))
			.setattr("fgOrdered", XMLChPtr(xercesc::PSVIUni::fgOrdered))
			.setattr("fgPattern", XMLChPtr(xercesc::PSVIUni::fgPattern))
			.setattr("fgTotalDigits", XMLChPtr(xercesc::PSVIUni::fgTotalDigits))
			.setattr("fgWhiteSpace", XMLChPtr(xercesc::PSVIUni::fgWhiteSpace))

		   	//Namespaces and prefixes
			.setattr("fgNamespaceInfoset", XMLChPtr(xercesc::PSVIUni::fgNamespaceInfoset))
			.setattr("fgXsi", XMLChPtr(xercesc::PSVIUni::fgXsi))
			.setattr("fgNamespaceInstance", XMLChPtr(xercesc::PSVIUni::fgNamespaceInstance))
			.setattr("fgPsv", XMLChPtr(xercesc::PSVIUni::fgPsv))
			.setattr("fgNamespacePsvi", XMLChPtr(xercesc::PSVIUni::fgNamespacePsvi))
			.setattr("fgXml", XMLChPtr(xercesc::PSVIUni::fgXml))
			.setattr("fgNamespaceXmlSchema", XMLChPtr(xercesc::PSVIUni::fgNamespaceXmlSchema))
			;
}

} /* namespace pyxerces */
