/*
 * XMLExceptMsgs.cpp
 *
 *  Created on: 2013/02/20
 *      Author: mugwort_rc
 */

#include "XMLExceptMsgs.h"

#include <boost/python.hpp>
#include <xercesc/util/XMLExceptMsgs.hpp>

namespace pyxerces {

void XMLExceptMsgs_init(void) {
	//! xercesc::XMLExcepts
	boost::python::scope XMLExcepts = boost::python::class_<xercesc::XMLExcepts, boost::noncopyable>("XMLExcepts", boost::python::no_init);
	//! xercesc::XMLExcepts::Codes
	boost::python::enum_<xercesc::XMLExcepts::Codes>("Codes")
			.value("NoError", xercesc::XMLExcepts::NoError)
			.value("W_LowBounds", xercesc::XMLExcepts::W_LowBounds)
			.value("Scan_CouldNotOpenSource_Warning", xercesc::XMLExcepts::Scan_CouldNotOpenSource_Warning)
			.value("W_HighBounds", xercesc::XMLExcepts::W_HighBounds)
			.value("F_LowBounds", xercesc::XMLExcepts::F_LowBounds)
			.value("Array_BadIndex", xercesc::XMLExcepts::Array_BadIndex)
			.value("Array_BadNewSize", xercesc::XMLExcepts::Array_BadNewSize)
			.value("AttrList_BadIndex", xercesc::XMLExcepts::AttrList_BadIndex)
			.value("AttDef_BadAttType", xercesc::XMLExcepts::AttDef_BadAttType)
			.value("AttDef_BadDefAttType", xercesc::XMLExcepts::AttDef_BadDefAttType)
			.value("Bitset_BadIndex", xercesc::XMLExcepts::Bitset_BadIndex)
			.value("Bitset_NotEqualSize", xercesc::XMLExcepts::Bitset_NotEqualSize)
			.value("BufMgr_NoMoreBuffers", xercesc::XMLExcepts::BufMgr_NoMoreBuffers)
			.value("BufMgr_BufferNotInPool", xercesc::XMLExcepts::BufMgr_BufferNotInPool)
			.value("CPtr_PointerIsZero", xercesc::XMLExcepts::CPtr_PointerIsZero)
			.value("CM_BinOpHadUnaryType", xercesc::XMLExcepts::CM_BinOpHadUnaryType)
			.value("CM_MustBeMixedOrChildren", xercesc::XMLExcepts::CM_MustBeMixedOrChildren)
			.value("CM_NoPCDATAHere", xercesc::XMLExcepts::CM_NoPCDATAHere)
			.value("CM_UnaryOpHadBinType", xercesc::XMLExcepts::CM_UnaryOpHadBinType)
			.value("CM_UnknownCMType", xercesc::XMLExcepts::CM_UnknownCMType)
			.value("CM_UnknownCMSpecType", xercesc::XMLExcepts::CM_UnknownCMSpecType)
			.value("CM_NoParentCSN", xercesc::XMLExcepts::CM_NoParentCSN)
			.value("CM_NotValidSpecTypeForNode", xercesc::XMLExcepts::CM_NotValidSpecTypeForNode)
			.value("DTD_UnknownCreateReason", xercesc::XMLExcepts::DTD_UnknownCreateReason)
			.value("ElemStack_EmptyStack", xercesc::XMLExcepts::ElemStack_EmptyStack)
			.value("ElemStack_StackUnderflow", xercesc::XMLExcepts::ElemStack_StackUnderflow)
			.value("ElemStack_NoParentPushed", xercesc::XMLExcepts::ElemStack_NoParentPushed)
			.value("Enum_NoMoreElements", xercesc::XMLExcepts::Enum_NoMoreElements)
			.value("File_CouldNotOpenFile", xercesc::XMLExcepts::File_CouldNotOpenFile)
			.value("File_CouldNotGetCurPos", xercesc::XMLExcepts::File_CouldNotGetCurPos)
			.value("File_CouldNotCloseFile", xercesc::XMLExcepts::File_CouldNotCloseFile)
			.value("File_CouldNotSeekToEnd", xercesc::XMLExcepts::File_CouldNotSeekToEnd)
			.value("File_CouldNotSeekToPos", xercesc::XMLExcepts::File_CouldNotSeekToPos)
			.value("File_CouldNotDupHandle", xercesc::XMLExcepts::File_CouldNotDupHandle)
			.value("File_CouldNotReadFromFile", xercesc::XMLExcepts::File_CouldNotReadFromFile)
			.value("File_CouldNotWriteToFile", xercesc::XMLExcepts::File_CouldNotWriteToFile)
			.value("File_CouldNotResetFile", xercesc::XMLExcepts::File_CouldNotResetFile)
			.value("File_CouldNotGetSize", xercesc::XMLExcepts::File_CouldNotGetSize)
			.value("File_CouldNotGetBasePathName", xercesc::XMLExcepts::File_CouldNotGetBasePathName)
			.value("Gen_ParseInProgress", xercesc::XMLExcepts::Gen_ParseInProgress)
			.value("Gen_NoDTDValidator", xercesc::XMLExcepts::Gen_NoDTDValidator)
			.value("Gen_CouldNotOpenDTD", xercesc::XMLExcepts::Gen_CouldNotOpenDTD)
			.value("Gen_CouldNotOpenExtEntity", xercesc::XMLExcepts::Gen_CouldNotOpenExtEntity)
			.value("Gen_UnexpectedEOF", xercesc::XMLExcepts::Gen_UnexpectedEOF)
			.value("HshTbl_ZeroModulus", xercesc::XMLExcepts::HshTbl_ZeroModulus)
			.value("HshTbl_BadHashFromKey", xercesc::XMLExcepts::HshTbl_BadHashFromKey)
			.value("HshTbl_NoSuchKeyExists", xercesc::XMLExcepts::HshTbl_NoSuchKeyExists)
			.value("Mutex_CouldNotDestroy", xercesc::XMLExcepts::Mutex_CouldNotDestroy)
			.value("NetAcc_InternalError", xercesc::XMLExcepts::NetAcc_InternalError)
			.value("NetAcc_LengthError", xercesc::XMLExcepts::NetAcc_LengthError)
			.value("NetAcc_InitFailed", xercesc::XMLExcepts::NetAcc_InitFailed)
			.value("NetAcc_TargetResolution", xercesc::XMLExcepts::NetAcc_TargetResolution)
			.value("NetAcc_CreateSocket", xercesc::XMLExcepts::NetAcc_CreateSocket)
			.value("NetAcc_ConnSocket", xercesc::XMLExcepts::NetAcc_ConnSocket)
			.value("NetAcc_WriteSocket", xercesc::XMLExcepts::NetAcc_WriteSocket)
			.value("NetAcc_ReadSocket", xercesc::XMLExcepts::NetAcc_ReadSocket)
			.value("NetAcc_UnsupportedMethod", xercesc::XMLExcepts::NetAcc_UnsupportedMethod)
			.value("Pool_ElemAlreadyExists", xercesc::XMLExcepts::Pool_ElemAlreadyExists)
			.value("Pool_InvalidId", xercesc::XMLExcepts::Pool_InvalidId)
			.value("Pool_ZeroModulus", xercesc::XMLExcepts::Pool_ZeroModulus)
			.value("RdrMgr_ReaderIdNotFound", xercesc::XMLExcepts::RdrMgr_ReaderIdNotFound)
			.value("Reader_BadAutoEncoding", xercesc::XMLExcepts::Reader_BadAutoEncoding)
			.value("Reader_CouldNotDecodeFirstLine", xercesc::XMLExcepts::Reader_CouldNotDecodeFirstLine)
			.value("Reader_NelLsepinDecl", xercesc::XMLExcepts::Reader_NelLsepinDecl)
			.value("Reader_SrcOfsNotSupported", xercesc::XMLExcepts::Reader_SrcOfsNotSupported)
			.value("Reader_EncodingStrRequired", xercesc::XMLExcepts::Reader_EncodingStrRequired)
			.value("Scan_CouldNotOpenSource", xercesc::XMLExcepts::Scan_CouldNotOpenSource)
			.value("Scan_UnbalancedStartEnd", xercesc::XMLExcepts::Scan_UnbalancedStartEnd)
			.value("Scan_BadPScanToken", xercesc::XMLExcepts::Scan_BadPScanToken)
			.value("Stack_BadIndex", xercesc::XMLExcepts::Stack_BadIndex)
			.value("Stack_EmptyStack", xercesc::XMLExcepts::Stack_EmptyStack)
			.value("Str_ZeroSizedTargetBuf", xercesc::XMLExcepts::Str_ZeroSizedTargetBuf)
			.value("Str_UnknownRadix", xercesc::XMLExcepts::Str_UnknownRadix)
			.value("Str_TargetBufTooSmall", xercesc::XMLExcepts::Str_TargetBufTooSmall)
			.value("Str_StartIndexPastEnd", xercesc::XMLExcepts::Str_StartIndexPastEnd)
			.value("Str_ConvertOverflow", xercesc::XMLExcepts::Str_ConvertOverflow)
			.value("StrPool_IllegalId", xercesc::XMLExcepts::StrPool_IllegalId)
			.value("Trans_Unrepresentable", xercesc::XMLExcepts::Trans_Unrepresentable)
			.value("Trans_BadSrcSeq", xercesc::XMLExcepts::Trans_BadSrcSeq)
			.value("Trans_BadSrcCP", xercesc::XMLExcepts::Trans_BadSrcCP)
			.value("Trans_BadTrailingSurrogate", xercesc::XMLExcepts::Trans_BadTrailingSurrogate)
			.value("Trans_CantCreateCvtrFor", xercesc::XMLExcepts::Trans_CantCreateCvtrFor)
			.value("URL_MalformedURL", xercesc::XMLExcepts::URL_MalformedURL)
			.value("URL_UnsupportedProto", xercesc::XMLExcepts::URL_UnsupportedProto)
			.value("URL_UnsupportedProto1", xercesc::XMLExcepts::URL_UnsupportedProto1)
			.value("URL_NoProtocolPresent", xercesc::XMLExcepts::URL_NoProtocolPresent)
			.value("URL_ExpectingTwoSlashes", xercesc::XMLExcepts::URL_ExpectingTwoSlashes)
			.value("URL_RelativeBaseURL", xercesc::XMLExcepts::URL_RelativeBaseURL)
			.value("URL_BadPortField", xercesc::XMLExcepts::URL_BadPortField)
			.value("UTF8_FormatError", xercesc::XMLExcepts::UTF8_FormatError)
			.value("UTF8_Invalid_3BytesSeq", xercesc::XMLExcepts::UTF8_Invalid_3BytesSeq)
			.value("UTF8_Irregular_3BytesSeq", xercesc::XMLExcepts::UTF8_Irregular_3BytesSeq)
			.value("UTF8_Invalid_4BytesSeq", xercesc::XMLExcepts::UTF8_Invalid_4BytesSeq)
			.value("UTF8_Exceeds_BytesLimit", xercesc::XMLExcepts::UTF8_Exceeds_BytesLimit)
			.value("Vector_BadIndex", xercesc::XMLExcepts::Vector_BadIndex)
			.value("Val_InvalidElemId", xercesc::XMLExcepts::Val_InvalidElemId)
			.value("Val_CantHaveIntSS", xercesc::XMLExcepts::Val_CantHaveIntSS)
			.value("XMLRec_UnknownEncoding", xercesc::XMLExcepts::XMLRec_UnknownEncoding)
			.value("Parser_Parse1", xercesc::XMLExcepts::Parser_Parse1)
			.value("Parser_Parse2", xercesc::XMLExcepts::Parser_Parse2)
			.value("Parser_Next1", xercesc::XMLExcepts::Parser_Next1)
			.value("Parser_Next2", xercesc::XMLExcepts::Parser_Next2)
			.value("Parser_Next3", xercesc::XMLExcepts::Parser_Next3)
			.value("Parser_Next4", xercesc::XMLExcepts::Parser_Next4)
			.value("Parser_Factor1", xercesc::XMLExcepts::Parser_Factor1)
			.value("Parser_Factor2", xercesc::XMLExcepts::Parser_Factor2)
			.value("Parser_Factor3", xercesc::XMLExcepts::Parser_Factor3)
			.value("Parser_Factor4", xercesc::XMLExcepts::Parser_Factor4)
			.value("Parser_Factor5", xercesc::XMLExcepts::Parser_Factor5)
			.value("Parser_Factor6", xercesc::XMLExcepts::Parser_Factor6)
			.value("Parser_Atom1", xercesc::XMLExcepts::Parser_Atom1)
			.value("Parser_Atom2", xercesc::XMLExcepts::Parser_Atom2)
			.value("Parser_Atom3", xercesc::XMLExcepts::Parser_Atom3)
			.value("Parser_Atom4", xercesc::XMLExcepts::Parser_Atom4)
			.value("Parser_Atom5", xercesc::XMLExcepts::Parser_Atom5)
			.value("Parser_CC1", xercesc::XMLExcepts::Parser_CC1)
			.value("Parser_CC2", xercesc::XMLExcepts::Parser_CC2)
			.value("Parser_CC3", xercesc::XMLExcepts::Parser_CC3)
			.value("Parser_CC5", xercesc::XMLExcepts::Parser_CC5)
			.value("Parser_CC6", xercesc::XMLExcepts::Parser_CC6)
			.value("Parser_Ope1", xercesc::XMLExcepts::Parser_Ope1)
			.value("Parser_Ope2", xercesc::XMLExcepts::Parser_Ope2)
			.value("Parser_Ope3", xercesc::XMLExcepts::Parser_Ope3)
			.value("Parser_Descape1", xercesc::XMLExcepts::Parser_Descape1)
			.value("Parser_Descape3", xercesc::XMLExcepts::Parser_Descape3)
			.value("Parser_Descape4", xercesc::XMLExcepts::Parser_Descape4)
			.value("Parser_Descape5", xercesc::XMLExcepts::Parser_Descape5)
			.value("Parser_Process2", xercesc::XMLExcepts::Parser_Process2)
			.value("Parser_Quantifier1", xercesc::XMLExcepts::Parser_Quantifier1)
			.value("Parser_Quantifier2", xercesc::XMLExcepts::Parser_Quantifier2)
			.value("Parser_Quantifier3", xercesc::XMLExcepts::Parser_Quantifier3)
			.value("Parser_Quantifier4", xercesc::XMLExcepts::Parser_Quantifier4)
			.value("Parser_Quantifier5", xercesc::XMLExcepts::Parser_Quantifier5)
			.value("Gen_NoSchemaValidator", xercesc::XMLExcepts::Gen_NoSchemaValidator)
			.value("SubGrpComparator_NGR", xercesc::XMLExcepts::SubGrpComparator_NGR)
			.value("FACET_Invalid_Len", xercesc::XMLExcepts::FACET_Invalid_Len)
			.value("FACET_Invalid_maxLen", xercesc::XMLExcepts::FACET_Invalid_maxLen)
			.value("FACET_Invalid_minLen", xercesc::XMLExcepts::FACET_Invalid_minLen)
			.value("FACET_NonNeg_Len", xercesc::XMLExcepts::FACET_NonNeg_Len)
			.value("FACET_NonNeg_maxLen", xercesc::XMLExcepts::FACET_NonNeg_maxLen)
			.value("FACET_NonNeg_minLen", xercesc::XMLExcepts::FACET_NonNeg_minLen)
			.value("FACET_Len_maxLen", xercesc::XMLExcepts::FACET_Len_maxLen)
			.value("FACET_Len_minLen", xercesc::XMLExcepts::FACET_Len_maxLen)
			.value("FACET_maxLen_minLen", xercesc::XMLExcepts::FACET_maxLen_minLen)
			.value("FACET_Invalid_Tag", xercesc::XMLExcepts::FACET_Invalid_Tag)
			.value("FACET_Len_baseLen", xercesc::XMLExcepts::FACET_Len_baseLen)
			.value("FACET_minLen_baseminLen", xercesc::XMLExcepts::FACET_minLen_baseminLen)
			.value("FACET_minLen_basemaxLen", xercesc::XMLExcepts::FACET_minLen_basemaxLen)
			.value("FACET_maxLen_basemaxLen", xercesc::XMLExcepts::FACET_maxLen_basemaxLen)
			.value("FACET_maxLen_baseminLen", xercesc::XMLExcepts::FACET_maxLen_baseminLen)
			.value("FACET_Len_baseMinLen", xercesc::XMLExcepts::FACET_Len_baseMinLen)
			.value("FACET_Len_baseMaxLen", xercesc::XMLExcepts::FACET_Len_baseMaxLen)
			.value("FACET_minLen_baseLen", xercesc::XMLExcepts::FACET_minLen_baseLen)
			.value("FACET_maxLen_baseLen", xercesc::XMLExcepts::FACET_maxLen_baseLen)
			.value("FACET_enum_base", xercesc::XMLExcepts::FACET_enum_base)
			.value("FACET_Invalid_WS", xercesc::XMLExcepts::FACET_Invalid_WS)
			.value("FACET_WS_collapse", xercesc::XMLExcepts::FACET_WS_collapse)
			.value("FACET_WS_replace", xercesc::XMLExcepts::FACET_WS_replace)
			.value("FACET_Invalid_MaxIncl", xercesc::XMLExcepts::FACET_Invalid_MaxIncl)
			.value("FACET_Invalid_MaxExcl", xercesc::XMLExcepts::FACET_Invalid_MaxExcl)
			.value("FACET_Invalid_MinIncl", xercesc::XMLExcepts::FACET_Invalid_MinIncl)
			.value("FACET_Invalid_MinExcl", xercesc::XMLExcepts::FACET_Invalid_MinExcl)
			.value("FACET_Invalid_TotalDigit", xercesc::XMLExcepts::FACET_Invalid_TotalDigit)
			.value("FACET_Invalid_FractDigit", xercesc::XMLExcepts::FACET_Invalid_FractDigit)
			.value("FACET_PosInt_TotalDigit", xercesc::XMLExcepts::FACET_PosInt_TotalDigit)
			.value("FACET_NonNeg_FractDigit", xercesc::XMLExcepts::FACET_NonNeg_FractDigit)
			.value("FACET_max_Incl_Excl", xercesc::XMLExcepts::FACET_max_Incl_Excl)
			.value("FACET_min_Incl_Excl", xercesc::XMLExcepts::FACET_min_Incl_Excl)
			.value("FACET_maxExcl_minExcl", xercesc::XMLExcepts::FACET_maxExcl_minExcl)
			.value("FACET_maxExcl_minIncl", xercesc::XMLExcepts::FACET_maxExcl_minIncl)
			.value("FACET_maxIncl_minExcl", xercesc::XMLExcepts::FACET_maxIncl_minExcl)
			.value("FACET_maxIncl_minIncl", xercesc::XMLExcepts::FACET_maxIncl_minIncl)
			.value("FACET_TotDigit_FractDigit", xercesc::XMLExcepts::FACET_TotDigit_FractDigit)
			.value("FACET_maxIncl_base_maxExcl", xercesc::XMLExcepts::FACET_maxIncl_base_maxExcl)
			.value("FACET_maxIncl_base_maxIncl", xercesc::XMLExcepts::FACET_maxIncl_base_maxExcl)
			.value("FACET_maxIncl_base_minIncl", xercesc::XMLExcepts::FACET_maxIncl_base_minIncl)
			.value("FACET_maxIncl_base_minExcl", xercesc::XMLExcepts::FACET_maxIncl_base_minExcl)
			.value("FACET_maxExcl_base_maxExcl", xercesc::XMLExcepts::FACET_maxExcl_base_maxExcl)
			.value("FACET_maxExcl_base_maxIncl", xercesc::XMLExcepts::FACET_maxExcl_base_maxIncl)
			.value("FACET_maxExcl_base_minIncl", xercesc::XMLExcepts::FACET_maxExcl_base_minIncl)
			.value("FACET_maxExcl_base_minExcl", xercesc::XMLExcepts::FACET_maxExcl_base_minExcl)
			.value("FACET_minExcl_base_maxExcl", xercesc::XMLExcepts::FACET_minExcl_base_maxExcl)
			.value("FACET_minExcl_base_maxIncl", xercesc::XMLExcepts::FACET_minExcl_base_maxIncl)
			.value("FACET_minExcl_base_minIncl", xercesc::XMLExcepts::FACET_minExcl_base_minIncl)
			.value("FACET_minExcl_base_minExcl", xercesc::XMLExcepts::FACET_minExcl_base_minExcl)
			.value("FACET_minIncl_base_maxExcl", xercesc::XMLExcepts::FACET_minIncl_base_maxExcl)
			.value("FACET_minIncl_base_maxIncl", xercesc::XMLExcepts::FACET_minIncl_base_maxIncl)
			.value("FACET_minIncl_base_minIncl", xercesc::XMLExcepts::FACET_minIncl_base_minIncl)
			.value("FACET_minIncl_base_minExcl", xercesc::XMLExcepts::FACET_minIncl_base_minExcl)
			.value("FACET_maxIncl_notFromBase", xercesc::XMLExcepts::FACET_maxIncl_notFromBase)
			.value("FACET_maxExcl_notFromBase", xercesc::XMLExcepts::FACET_maxExcl_notFromBase)
			.value("FACET_minIncl_notFromBase", xercesc::XMLExcepts::FACET_minIncl_notFromBase)
			.value("FACET_minExcl_notFromBase", xercesc::XMLExcepts::FACET_minExcl_notFromBase)
			.value("FACET_totalDigit_base_totalDigit", xercesc::XMLExcepts::FACET_totalDigit_base_totalDigit)
			.value("FACET_fractDigit_base_totalDigit", xercesc::XMLExcepts::FACET_fractDigit_base_totalDigit)
			.value("FACET_fractDigit_base_fractDigit", xercesc::XMLExcepts::FACET_fractDigit_base_fractDigit)
			.value("FACET_maxIncl_base_fixed", xercesc::XMLExcepts::FACET_maxIncl_base_fixed)
			.value("FACET_maxExcl_base_fixed", xercesc::XMLExcepts::FACET_maxExcl_base_fixed)
			.value("FACET_minIncl_base_fixed", xercesc::XMLExcepts::FACET_minIncl_base_fixed)
			.value("FACET_minExcl_base_fixed", xercesc::XMLExcepts::FACET_minExcl_base_fixed)
			.value("FACET_totalDigit_base_fixed", xercesc::XMLExcepts::FACET_totalDigit_base_fixed)
			.value("FACET_fractDigit_base_fixed", xercesc::XMLExcepts::FACET_fractDigit_base_fixed)
			.value("FACET_maxLen_base_fixed", xercesc::XMLExcepts::FACET_maxLen_base_fixed)
			.value("FACET_minLen_base_fixed", xercesc::XMLExcepts::FACET_minLen_base_fixed)
			.value("FACET_whitespace_base_fixed", xercesc::XMLExcepts::FACET_whitespace_base_fixed)
			.value("FACET_internalError_fixed", xercesc::XMLExcepts::FACET_internalError_fixed)
			.value("FACET_List_Null_baseValidator", xercesc::XMLExcepts::FACET_List_Null_baseValidator)
			.value("FACET_Union_Null_memberTypeValidators", xercesc::XMLExcepts::FACET_Union_Null_memberTypeValidators)
			.value("FACET_Union_Null_baseValidator", xercesc::XMLExcepts::FACET_Union_Null_baseValidator)
			.value("FACET_Union_invalid_baseValidatorType", xercesc::XMLExcepts::FACET_Union_invalid_baseValidatorType)
			.value("VALUE_NotMatch_Pattern", xercesc::XMLExcepts::VALUE_NotMatch_Pattern)
			.value("VALUE_Not_Base64", xercesc::XMLExcepts::VALUE_Not_Base64)
			.value("VALUE_Not_HexBin", xercesc::XMLExcepts::VALUE_Not_HexBin)
			.value("VALUE_GT_maxLen", xercesc::XMLExcepts::VALUE_GT_maxLen)
			.value("VALUE_LT_minLen", xercesc::XMLExcepts::VALUE_LT_minLen)
			.value("VALUE_NE_Len", xercesc::XMLExcepts::VALUE_NE_Len)
			.value("VALUE_NotIn_Enumeration", xercesc::XMLExcepts::VALUE_NotIn_Enumeration)
			.value("VALUE_exceed_totalDigit", xercesc::XMLExcepts::VALUE_exceed_totalDigit)
			.value("VALUE_exceed_fractDigit", xercesc::XMLExcepts::VALUE_exceed_fractDigit)
			.value("VALUE_exceed_maxIncl", xercesc::XMLExcepts::VALUE_exceed_maxIncl)
			.value("VALUE_exceed_maxExcl", xercesc::XMLExcepts::VALUE_exceed_maxExcl)
			.value("VALUE_exceed_minIncl", xercesc::XMLExcepts::VALUE_exceed_minIncl)
			.value("VALUE_exceed_minExcl", xercesc::XMLExcepts::VALUE_exceed_minExcl)
			.value("VALUE_WS_replaced", xercesc::XMLExcepts::VALUE_WS_replaced)
			.value("VALUE_WS_collapsed", xercesc::XMLExcepts::VALUE_WS_collapsed)
			.value("VALUE_Invalid_NCName", xercesc::XMLExcepts::VALUE_Invalid_NCName)
			.value("VALUE_Invalid_Name", xercesc::XMLExcepts::VALUE_Invalid_Name)
			.value("VALUE_ID_Not_Unique", xercesc::XMLExcepts::VALUE_ID_Not_Unique)
			.value("VALUE_ENTITY_Invalid", xercesc::XMLExcepts::VALUE_ENTITY_Invalid)
			.value("VALUE_QName_Invalid", xercesc::XMLExcepts::VALUE_QName_Invalid)
			.value("VALUE_NOTATION_Invalid", xercesc::XMLExcepts::VALUE_NOTATION_Invalid)
			.value("VALUE_no_match_memberType", xercesc::XMLExcepts::VALUE_no_match_memberType)
			.value("VALUE_URI_Malformed", xercesc::XMLExcepts::VALUE_URI_Malformed)
			.value("XMLNUM_emptyString", xercesc::XMLExcepts::XMLNUM_emptyString)
			.value("XMLNUM_WSString", xercesc::XMLExcepts::XMLNUM_WSString)
			.value("XMLNUM_2ManyDecPoint", xercesc::XMLExcepts::XMLNUM_2ManyDecPoint)
			.value("XMLNUM_Inv_chars", xercesc::XMLExcepts::XMLNUM_Inv_chars)
			.value("XMLNUM_null_ptr", xercesc::XMLExcepts::XMLNUM_null_ptr)
			.value("XMLNUM_URI_Component_Empty", xercesc::XMLExcepts::XMLNUM_URI_Component_Empty)
			.value("XMLNUM_URI_Component_for_GenURI_Only", xercesc::XMLExcepts::XMLNUM_URI_Component_for_GenURI_Only)
			.value("XMLNUM_URI_Component_Invalid_EscapeSequence", xercesc::XMLExcepts::XMLNUM_URI_Component_Invalid_EscapeSequence)
			.value("XMLNUM_URI_Component_Invalid_Char", xercesc::XMLExcepts::XMLNUM_URI_Component_Invalid_Char)
			.value("XMLNUM_URI_Component_Set_Null", xercesc::XMLExcepts::XMLNUM_URI_Component_Set_Null)
			.value("XMLNUM_URI_Component_Not_Conformant", xercesc::XMLExcepts::XMLNUM_URI_Component_Not_Conformant)
			.value("XMLNUM_URI_No_Scheme", xercesc::XMLExcepts::XMLNUM_URI_No_Scheme)
			.value("XMLNUM_URI_NullHost", xercesc::XMLExcepts::XMLNUM_URI_NullHost)
			.value("XMLNUM_URI_NullPath", xercesc::XMLExcepts::XMLNUM_URI_NullPath)
			.value("XMLNUM_URI_PortNo_Invalid", xercesc::XMLExcepts::XMLNUM_URI_PortNo_Invalid)
			.value("XMLNUM_DBL_FLT_InvalidType", xercesc::XMLExcepts::XMLNUM_DBL_FLT_InvalidType)
			.value("Regex_Result_Not_Set", xercesc::XMLExcepts::Regex_Result_Not_Set)
			.value("Regex_CompactRangesError", xercesc::XMLExcepts::Regex_CompactRangesError)
			.value("Regex_MergeRangesTypeMismatch", xercesc::XMLExcepts::Regex_MergeRangesTypeMismatch)
			.value("Regex_SubtractRangesError", xercesc::XMLExcepts::Regex_SubtractRangesError)
			.value("Regex_IntersectRangesError", xercesc::XMLExcepts::Regex_IntersectRangesError)
			.value("Regex_ComplementRangesInvalidArg", xercesc::XMLExcepts::Regex_ComplementRangesInvalidArg)
			.value("Regex_InvalidCategoryName", xercesc::XMLExcepts::Regex_InvalidCategoryName)
			.value("Regex_KeywordNotFound", xercesc::XMLExcepts::Regex_KeywordNotFound)
			.value("Regex_BadRefNo", xercesc::XMLExcepts::Regex_BadRefNo)
			.value("Regex_UnknownOption", xercesc::XMLExcepts::Regex_UnknownOption)
			.value("Regex_UnknownTokenType", xercesc::XMLExcepts::Regex_UnknownTokenType)
			.value("Regex_RangeTokenGetError", xercesc::XMLExcepts::Regex_RangeTokenGetError)
			.value("Regex_NotSupported", xercesc::XMLExcepts::Regex_NotSupported)
			.value("Regex_InvalidChildIndex", xercesc::XMLExcepts::Regex_InvalidChildIndex)
			.value("Regex_RepPatMatchesZeroString", xercesc::XMLExcepts::Regex_RepPatMatchesZeroString)
			.value("Regex_InvalidRepPattern", xercesc::XMLExcepts::Regex_InvalidRepPattern)
			.value("NEL_RepeatedCalls", xercesc::XMLExcepts::NEL_RepeatedCalls)
			.value("Out_Of_Memory", xercesc::XMLExcepts::Out_Of_Memory)
			.value("DV_InvalidOperation", xercesc::XMLExcepts::DV_InvalidOperation)
			.value("XPath_NoAttrSelector", xercesc::XMLExcepts::XPath_NoAttrSelector)
			.value("XPath_NoUnionAtStart", xercesc::XMLExcepts::XPath_NoUnionAtStart)
			.value("XPath_NoMultipleUnion", xercesc::XMLExcepts::XPath_NoMultipleUnion)
			.value("XPath_MissingAttr", xercesc::XMLExcepts::XPath_MissingAttr)
			.value("XPath_ExpectedToken1", xercesc::XMLExcepts::XPath_ExpectedToken1)
			.value("XPath_PrefixNoURI", xercesc::XMLExcepts::XPath_PrefixNoURI)
			.value("XPath_NoDoubleColon", xercesc::XMLExcepts::XPath_NoDoubleColon)
			.value("XPath_ExpectedStep1", xercesc::XMLExcepts::XPath_ExpectedStep1)
			.value("XPath_ExpectedStep2", xercesc::XMLExcepts::XPath_ExpectedStep2)
			.value("XPath_ExpectedStep3", xercesc::XMLExcepts::XPath_ExpectedStep3)
			.value("XPath_NoForwardSlash", xercesc::XMLExcepts::XPath_NoForwardSlash)
			.value("XPath_NoDoubleForwardSlash", xercesc::XMLExcepts::XPath_NoDoubleForwardSlash)
			.value("XPath_NoForwardSlashAtStart", xercesc::XMLExcepts::XPath_NoForwardSlashAtStart)
			.value("XPath_NoSelectionOfRoot", xercesc::XMLExcepts::XPath_NoSelectionOfRoot)
			.value("XPath_EmptyExpr", xercesc::XMLExcepts::XPath_EmptyExpr)
			.value("XPath_NoUnionAtEnd", xercesc::XMLExcepts::XPath_NoUnionAtEnd)
			.value("XPath_InvalidChar", xercesc::XMLExcepts::XPath_InvalidChar)
			.value("XPath_TokenNotSupported", xercesc::XMLExcepts::XPath_TokenNotSupported)
			.value("XPath_FindSolution", xercesc::XMLExcepts::XPath_FindSolution)
			.value("DateTime_dt_invalid", xercesc::XMLExcepts::DateTime_dt_invalid)
			.value("DateTime_dt_missingT", xercesc::XMLExcepts::DateTime_dt_missingT)
			.value("DateTime_gDay_invalid", xercesc::XMLExcepts::DateTime_gDay_invalid)
			.value("DateTime_gMth_invalid", xercesc::XMLExcepts::DateTime_gMth_invalid)
			.value("DateTime_gMthDay_invalid", xercesc::XMLExcepts::DateTime_gMthDay_invalid)
			.value("DateTime_dur_invalid", xercesc::XMLExcepts::DateTime_dur_invalid)
			.value("DateTime_dur_Start_dashP", xercesc::XMLExcepts::DateTime_dur_Start_dashP)
			.value("DateTime_dur_noP", xercesc::XMLExcepts::DateTime_dur_noP)
			.value("DateTime_dur_DashNotFirst", xercesc::XMLExcepts::DateTime_dur_DashNotFirst)
			.value("DateTime_dur_inv_b4T", xercesc::XMLExcepts::DateTime_dur_inv_b4T)
			.value("DateTime_dur_NoTimeAfterT", xercesc::XMLExcepts::DateTime_dur_NoTimeAfterT)
			.value("DateTime_dur_NoElementAtAll", xercesc::XMLExcepts::DateTime_dur_NoElementAtAll)
			.value("DateTime_dur_inv_seconds", xercesc::XMLExcepts::DateTime_dur_inv_seconds)
			.value("DateTime_date_incomplete", xercesc::XMLExcepts::DateTime_date_incomplete)
			.value("DateTime_date_invalid", xercesc::XMLExcepts::DateTime_date_invalid)
			.value("DateTime_time_incomplete", xercesc::XMLExcepts::DateTime_time_incomplete)
			.value("DateTime_time_invalid", xercesc::XMLExcepts::DateTime_time_invalid)
			.value("DateTime_ms_noDigit", xercesc::XMLExcepts::DateTime_ms_noDigit)
			.value("DateTime_ym_incomplete", xercesc::XMLExcepts::DateTime_ym_incomplete)
			.value("DateTime_ym_invalid", xercesc::XMLExcepts::DateTime_ym_invalid)
			.value("DateTime_year_invalid", xercesc::XMLExcepts::DateTime_year_invalid)
			.value("DateTime_year_tooShort", xercesc::XMLExcepts::DateTime_year_tooShort)
			.value("DateTime_year_leadingZero", xercesc::XMLExcepts::DateTime_year_leadingZero)
			.value("DateTime_ym_noMonth", xercesc::XMLExcepts::DateTime_ym_noMonth)
			.value("DateTime_tz_noUTCsign", xercesc::XMLExcepts::DateTime_tz_noUTCsign)
			.value("DateTime_tz_stuffAfterZ", xercesc::XMLExcepts::DateTime_tz_stuffAfterZ)
			.value("DateTime_tz_invalid", xercesc::XMLExcepts::DateTime_tz_invalid)
			.value("DateTime_year_zero", xercesc::XMLExcepts::DateTime_year_zero)
			.value("DateTime_mth_invalid", xercesc::XMLExcepts::DateTime_mth_invalid)
			.value("DateTime_day_invalid", xercesc::XMLExcepts::DateTime_day_invalid)
			.value("DateTime_hour_invalid", xercesc::XMLExcepts::DateTime_hour_invalid)
			.value("DateTime_min_invalid", xercesc::XMLExcepts::DateTime_min_invalid)
			.value("DateTime_second_invalid", xercesc::XMLExcepts::DateTime_second_invalid)
			.value("DateTime_tz_hh_invalid", xercesc::XMLExcepts::DateTime_tz_hh_invalid)
			.value("PD_EmptyBase", xercesc::XMLExcepts::PD_EmptyBase)
			.value("PD_NSCompat1", xercesc::XMLExcepts::PD_NSCompat1)
			.value("PD_OccurRangeE", xercesc::XMLExcepts::PD_OccurRangeE)
			.value("PD_NameTypeOK1", xercesc::XMLExcepts::PD_NameTypeOK1)
			.value("PD_NameTypeOK2", xercesc::XMLExcepts::PD_NameTypeOK2)
			.value("PD_NameTypeOK3", xercesc::XMLExcepts::PD_NameTypeOK3)
			.value("PD_NameTypeOK4", xercesc::XMLExcepts::PD_NameTypeOK4)
			.value("PD_NameTypeOK5", xercesc::XMLExcepts::PD_NameTypeOK5)
			.value("PD_NameTypeOK6", xercesc::XMLExcepts::PD_NameTypeOK6)
			.value("PD_NameTypeOK7", xercesc::XMLExcepts::PD_NameTypeOK7)
			.value("PD_Recurse1", xercesc::XMLExcepts::PD_Recurse1)
			.value("PD_Recurse2", xercesc::XMLExcepts::PD_Recurse2)
			.value("PD_ForbiddenRes1", xercesc::XMLExcepts::PD_ForbiddenRes1)
			.value("PD_ForbiddenRes2", xercesc::XMLExcepts::PD_ForbiddenRes2)
			.value("PD_ForbiddenRes3", xercesc::XMLExcepts::PD_ForbiddenRes3)
			.value("PD_ForbiddenRes4", xercesc::XMLExcepts::PD_ForbiddenRes4)
			.value("PD_NSSubset1", xercesc::XMLExcepts::PD_NSSubset1)
			.value("PD_NSSubset2", xercesc::XMLExcepts::PD_NSSubset2)
			.value("PD_NSRecurseCheckCardinality1", xercesc::XMLExcepts::PD_NSRecurseCheckCardinality1)
			.value("PD_RecurseUnordered", xercesc::XMLExcepts::PD_RecurseUnordered)
			.value("PD_MapAndSum", xercesc::XMLExcepts::PD_MapAndSum)
			.value("PD_InvalidContentType", xercesc::XMLExcepts::PD_InvalidContentType)
			.value("NodeIDMap_GrowErr", xercesc::XMLExcepts::NodeIDMap_GrowErr)
			.value("XSer_ProtoType_Null_ClassName", xercesc::XMLExcepts::XSer_ProtoType_Null_ClassName)
			.value("XSer_ProtoType_NameLen_Dif", xercesc::XMLExcepts::XSer_ProtoType_NameLen_Dif)
			.value("XSer_ProtoType_Name_Dif", xercesc::XMLExcepts::XSer_ProtoType_Name_Dif)
			.value("XSer_InStream_Read_LT_Req", xercesc::XMLExcepts::XSer_InStream_Read_LT_Req)
			.value("XSer_InStream_Read_OverFlow", xercesc::XMLExcepts::XSer_InStream_Read_OverFlow)
			.value("XSer_Storing_Violation", xercesc::XMLExcepts::XSer_Storing_Violation)
			.value("XSer_StoreBuffer_Violation", xercesc::XMLExcepts::XSer_StoreBuffer_Violation)
			.value("XSer_LoadPool_UppBnd_Exceed", xercesc::XMLExcepts::XSer_LoadPool_UppBnd_Exceed)
			.value("XSer_LoadPool_NoTally_ObjCnt", xercesc::XMLExcepts::XSer_LoadPool_NoTally_ObjCnt)
			.value("XSer_Loading_Violation", xercesc::XMLExcepts::XSer_Loading_Violation)
			.value("XSer_LoadBuffer_Violation", xercesc::XMLExcepts::XSer_LoadBuffer_Violation)
			.value("XSer_Inv_ClassIndex", xercesc::XMLExcepts::XSer_Inv_ClassIndex)
			.value("XSer_Inv_checkFillBuffer_Size", xercesc::XMLExcepts::XSer_Inv_checkFillBuffer_Size)
			.value("XSer_Inv_checkFlushBuffer_Size", xercesc::XMLExcepts::XSer_Inv_checkFlushBuffer_Size)
			.value("XSer_Inv_Null_Pointer", xercesc::XMLExcepts::XSer_Inv_Null_Pointer)
			.value("XSer_CreateObject_Fail", xercesc::XMLExcepts::XSer_CreateObject_Fail)
			.value("XSer_ObjCount_UppBnd_Exceed", xercesc::XMLExcepts::XSer_ObjCount_UppBnd_Exceed)
			.value("XSer_GrammarPool_Empty", xercesc::XMLExcepts::XSer_GrammarPool_Empty)
			.value("XSer_GrammarPool_NotEmpty", xercesc::XMLExcepts::XSer_GrammarPool_NotEmpty)
			.value("XSer_StringPool_NotEmpty", xercesc::XMLExcepts::XSer_StringPool_NotEmpty)
			.value("XSer_Storer_Loader_Mismatch", xercesc::XMLExcepts::XSer_Storer_Loader_Mismatch)
			.value("VALUE_QName_Invalid2", xercesc::XMLExcepts::VALUE_QName_Invalid2)
			.value("F_HighBounds", xercesc::XMLExcepts::VALUE_QName_Invalid2)
			.value("E_LowBounds", xercesc::XMLExcepts::E_LowBounds)
			.value("E_HighBounds", xercesc::XMLExcepts::E_HighBounds)
			.export_values()
			;
}

} /* namespace pyxerces */
