# Copyright (c) 2010 Marco Giusti
# See LICENSE.txt for details.

from twisted.python import usage, log
from twisted.web import client, error
from twisted.internet import reactor, defer
from zope.interface import implements
from pycabulary import interfaces, utils


class Options(usage.Options):

    optFlags = [
            ['italian', 'i', 'Translate from english to italian'],
            ['english', 'e', 'Translate from italian to english']
            ]

    def parseArgs(self, *args):
        self['words'] = args

    def postOptions(self):
        if not self['words']:
            raise usage.UsageError, 'Specify at least one word to translate'
        if self['italian'] and self['english']:
            raise usage.UsageError, 'Cannot translate to english and to ' \
                    'italian at the same time.'
        if not self['italian'] and not self['english']:
            raise usage.UsageError, 'Specify a language to translate to.'


class CliApp:
    implements(interfaces.IApp)

    def __init__(self, config):
        self.config = config

    def stop(self, a=None):
        reactor.stop()

    def _eb(self, failure):
        failure.trap(defer.TimeoutError, error.Error)
        log.err(failure)
        return []

    def _print(self, (word, translation)):
        print '%s: %s' % (word, translation)

    def translate(self, word):
        url = utils.getUrl(self.config['english'], word)
        d = client.getPage(url, timeout=30)
        d.addCallbacks(utils.translate, self._eb)
        d.addCallback(lambda ws: map(self._print, ws))
        return d

    def run(self):

        dl = []
        for word in self.config['words']:
            dl.append(self.translate(word))

        defer.DeferredList(dl).addCallback(self.stop)
        reactor.run()


def makeApp(config):
    return CliApp(config)

