# Copyright (c) 2010 Marco Giusti
# See LICENSE.txt for details.

import sgmllib
from zope.interface import implements
from twisted.plugin import IPlugin
from twisted.python import reflect
from pycabulary import interfaces


class AppMaker:
    """
    Lazy build L{IApp} plugin.
    """
    implements(IPlugin, interfaces.IAppMaker)

    def __init__(self, module, description, name):
        self.module = module
        self.description = description
        self.name = name

    @property
    def options(self):
        return reflect.namedAny(self.module).Options

    @property
    def makeApp(self):
        return reflect.namedAny(self.module).makeApp


class Parser(sgmllib.SGMLParser):
    """Preleva la traduzione del vocabolo dato."""

    def reset(self):
        sgmllib.SGMLParser.reset(self)
        self.inTable = False
        self.grabLink = False
        self.getWord = False
        self.traslation = False
        self.word = None
        self.terms = []

    def start_table(self, attrs):
        for k, v in attrs:
            if k == 'id' and v == 'PGtbltrad':
                self.inTable = True
                break

    def end_table(self):
        if self.inTable:
            self.inTable = False

    def start_td(self, attrs):
        if self.inTable:
            for k, v in attrs:
                if k == 'colspan' and v == '2':
                    self.grabLink = True
                    break

    def end_td(self):
        if self.grabLink:
            self.grabLink = False

    def start_a(self, attrs):
        if self.grabLink:
            self.getWord = True

    def end_a(self):
        if self.getWord:
            self.getWord = False

    def handle_data(self, data):
        if self.getWord:
            if self.traslation:
                self.terms.append((self.word, data))
                self.traslation = False
            else:
                self.word = data
                self.traslation = True


parser = Parser()


def translate(page, parser=parser, li=None, encoding='iso-8859-1'):
    parser.reset()
    if li is None:
        li = []
    parser.feed(page)
    e = encoding
    map(li.append, ((t.decode(e), tr.decode(e)) for t, tr in parser.terms))
    return li


URL = 'http://it.dicios.com/%s/%s'

def getUrl(toEng, term):
    return URL % ('iten' if toEng else 'enit', term)

