# Copyright (c) 2010 Marco Giusti
# See LICENSE.txt for details.

from zope.interface import Interface, Attribute


class IApp(Interface):

    def __init__(config):
        """
        Initialize the application.

        @type config: C{dict}
        @param config: configure parameters
        """

    def run():
        """Start the application."""


class IAppMaker(Interface):

    name = Attribute("The name for this plugin. This name will be used as"
                     "subcommand")

    description = Attribute("A short description for this application")

    options = Attribute("A C{twisted.python.usage.Options} subclass defining "
                        "the configuration options for this application.")

    def makeApp():
        """Build an L{IApp} object."""

