#!/usr/bin/env python

# Copyright (C) 2009 Marco Giusti
# See LICENSE.txt for details

from setuptools import setup
from pycabulary import __version__


setup(name='Pycabulary',
      version=__version__,
      description='An english to italian, italian to english online '
                  'vocabulary',
      long_description=open('README.txt').read(),
      author='Marco Giusti',
      author_email='marco.giusti@gmail.com',
      url='http://bitbucket.org/gm/pycabulary/',
      license='MIT',
      platforms=['any'],
      packages=['pycabulary', 'pycabulary.plugins'],
      install_requires=['Twisted'],
      tests_require=['unittest2'],
      zip_safe=True,
      test_suite='pycabulary.tests',
      entry_points={
              'console_scripts': [
                  'pycabulary = pycabulary.main:main',
                  ],
              'gui_scripts': [
                  'pycabulary-tk = pycabulary.main:main_tk',
                  'pycabulary-gtk = pycabulary.main:main_gtk',
                  ],
              'setuptools.installation': [
                  'eggsecutable = pycabulary.main:main_tk',
                  ],
              },
      classifiers=[
          'Environment :: Console',
          'Environment :: X11 Applications :: GTK',
          'Environment :: X11 Applications',
          'Framework :: Twisted',
          'Intended Audience :: Education',
          'Natural Language :: Italian',
          'Natural Language :: English',
          'Topic :: Education',
          'License :: OSI Approved :: MIT License',
          'Operating System :: OS Independent',
          ],
      )

