# Copyright (c) 2010 Marco Giusti
# See LICENSE.txt for details.

from __future__ import absolute_import

from twisted.python import usage, log
from twisted.internet import reactor, defer
from zope.interface import implements

from . import interfaces, client, dicios


class Options(usage.Options):

    optFlags = [
            ['italian', 'i', 'Translate from english to italian'],
            ['english', 'e', 'Translate from italian to english']
            ]

    def parseArgs(self, *args):
        self['words'] = args

    def postOptions(self):
        if not self['words']:
            raise usage.UsageError, 'Specify at least one word to translate'
        if self['italian'] and self['english']:
            raise usage.UsageError, 'Cannot translate to english and to ' \
                    'italian at the same time.'
        if not self['italian'] and not self['english']:
            raise usage.UsageError, 'Specify a language to translate to.'


class CliApp:
    implements(interfaces.IApp)

    def __init__(self, config, translatorFactory=dicios.Dicios,
                 parserFactory=dicios.Parser, clientFactory=client.Client):
        self.translator = translatorFactory(clientFactory(), parserFactory)
        self.config = config

    def write(self, lst):
        for word, translation in lst:
            print '%s: %s' % (word, translation)

    def run(self):
        dl = []
        if self.config['italian']:
            frm, to = 'en', 'it'
        else:
            frm, to = 'it', 'en'
        for word in self.config['words']:
            d = self.translator.translate(word, frm, to)
            d.addCallbacks(self.write, log.err)
            dl.append(d)

        dl = defer.DeferredList(dl)
        dl.addErrback(log.err)
        dl.addCallback(lambda a: reactor.stop())
        reactor.run()


def makeApp(config):
    return CliApp(config)

