#!/usr/bin/env python
# Copyright (c) 2010 Marco Giusti
# See LICENSE.txt for details.

from __future__ import absolute_import

import sys
from twisted.python import usage
from twisted.plugin import getPlugins

from . import plugins, interfaces


class Options(usage.Options):

    @property
    def subCommands(self):
        self.plugins = {}
        for plug in getPlugins(interfaces.IAppMaker, plugins):
            self.plugins[plug.name] = plug
            yield (plug.name, None, lambda: plug.options(), plug.description)

    def opt_version(self):
        import pycabulary

        print 'Pycabulary ' + pycabulary.__version__
        print 'An english to italian, italian to english online vocabulary'
        print 'Copyright (C) 2010 Marco Giusti'
        print 'LICENSE MIT, see LICENSE.txt for details.'
        print 'The software is provided "as is", without warranty of any kind.'
        sys.exit(0)


def main_tk():
    return main(['tk'])


def main_gtk():
    return main(['gtk'])


def main(argv=None):
    if argv is None:
        argv = sys.argv[1:]

    config = Options()
    try:
        config.parseOptions(argv)
    except usage.UsageError, e:
        print '%s: %s' % (sys.argv[0], e)
        print 'Try --help for usage details.'
        return 2

    if config.subCommand:
        plugin = config.plugins[config.subCommand]
        app = plugin.makeApp(config.subOptions)
        app.run()
    else:
        print '%s: Specify a command' % sys.argv[0]
        print 'Try --help for usage details.'
        return 2


if __name__ == '__main__':
    sys.exit(main())
