# -*- test-case-name: pycabulary.tests.test_utils -*-
# Copyright (c) 2010 Marco Giusti
# See LICENSE.txt for details.

from __future__ import absolute_import

try:
    from itertools import permutations  # python 2.6
except ImportError:
    # from ufficial_python_documentation import copy&paste
    def permutations(iterable, r=None):
        # permutations('ABCD', 2) --> AB AC AD BA BC BD CA CB CD DA DB DC
        # permutations(range(3)) --> 012 021 102 120 201 210
        pool = tuple(iterable)
        n = len(pool)
        r = n if r is None else r
        if r > n:
            return
        indices = range(n)
        cycles = range(n, n-r, -1)
        yield tuple(pool[i] for i in indices[:r])
        while n:
            for i in reversed(range(r)):
                cycles[i] -= 1
                if cycles[i] == 0:
                    indices[i:] = indices[i+1:] + indices[i:i+1]
                    cycles[i] = n - i
                else:
                    j = cycles[i]
                    indices[i], indices[-j] = indices[-j], indices[i]
                    yield tuple(pool[i] for i in indices[:r])
                    break
            else:
                return

from zope.interface import implements
from twisted.plugin import IPlugin
from twisted.python import reflect

from . import interfaces


class AppMaker:
    """Lazy build L{IApp} plugin."""

    implements(IPlugin, interfaces.IAppMaker)

    def __init__(self, module, description, name):
        self.module = module
        self.description = description
        self.name = name

    @property
    def options(self):
        return reflect.namedAny(self.module).Options

    @property
    def makeApp(self):
        return reflect.namedAny(self.module).makeApp


class LanguageMap(object):

    def __init__(self, translator):
        self.translator = translator
        m = {}
        for i in permutations(translator.languages.items(), 2):
            (c1, l1), (c2, l2) = i
            m['%s - %s' % (l1, l2)] = (c1, c2)

        self._map = m

    def getLabels(self):
        return self._map.keys()

    def getCodes(self, label):
        return self._map[label]
