/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers;

import junit.framework.TestCase;
import org.openqa.selenium.server.browserlaunchers.BrowserStringParser;

public class BrowserStringParserUnitTest
extends TestCase {
    public void testBrowserStartCommandMatchWhenBrowserStringIsTheBrowserName() {
        BrowserStringParser.Result result = new BrowserStringParser().parseBrowserStartCommand("firefox", "firefox");
        BrowserStringParserUnitTest.assertTrue((boolean)result.match());
        BrowserStringParserUnitTest.assertNull((Object)result.customLauncher());
    }

    public void testBrowserStartCommandMatchWhenBrowserStringIsStarTheBrowserName() {
        BrowserStringParser.Result result = new BrowserStringParser().parseBrowserStartCommand("firefox", "*firefox");
        BrowserStringParserUnitTest.assertTrue((boolean)result.match());
    }

    public void testBrowserStartCommandDoNotMatchWhenBrowsersAreWayDifferent() {
        BrowserStringParser.Result result = new BrowserStringParser().parseBrowserStartCommand("firefox", "*safari");
        BrowserStringParserUnitTest.assertFalse((boolean)result.match());
        BrowserStringParserUnitTest.assertNull((Object)result.customLauncher());
    }

    public void testBrowserStartCommandMatchWhenCustomLauncherIsProvided() {
        BrowserStringParser.Result result = new BrowserStringParser().parseBrowserStartCommand("firefox", "*firefox /a/custom/launcher");
        BrowserStringParserUnitTest.assertTrue((boolean)result.match());
        BrowserStringParserUnitTest.assertEquals((String)"/a/custom/launcher", (String)result.customLauncher());
    }

    public void testBrowserStartCommandDoNotMatchWhenBrowsersisASubstring() {
        BrowserStringParser.Result result = new BrowserStringParser().parseBrowserStartCommand("firefox", "*firefoxproxy");
        BrowserStringParserUnitTest.assertFalse((boolean)result.match());
        BrowserStringParserUnitTest.assertNull((Object)result.customLauncher());
    }

    public void testBrowserStartCommandIsNullWhenThereIsNothingButSpaceAfterTheBrowserName() {
        BrowserStringParser.Result result = new BrowserStringParser().parseBrowserStartCommand("firefox", "firefox    ");
        BrowserStringParserUnitTest.assertTrue((boolean)result.match());
        BrowserStringParserUnitTest.assertNull((Object)result.customLauncher());
    }

    public void testBrowserStartCommandMatchIgnoredTrailingSpacesWhenCustomLauncherIsProvided() {
        BrowserStringParser.Result result = new BrowserStringParser().parseBrowserStartCommand("iexplore", "*iexplore /a/custom/launcher   ");
        BrowserStringParserUnitTest.assertTrue((boolean)result.match());
        BrowserStringParserUnitTest.assertEquals((String)"/a/custom/launcher", (String)result.customLauncher());
    }

    public void testBrowserStartCommandMatchPreservedSpacesWhithinCustomLauncher() {
        BrowserStringParser.Result result = new BrowserStringParser().parseBrowserStartCommand("hta", "*hta '/a/custom/launcher with space'   ");
        BrowserStringParserUnitTest.assertTrue((boolean)result.match());
        BrowserStringParserUnitTest.assertEquals((String)"'/a/custom/launcher with space'", (String)result.customLauncher());
    }
}

