/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers;

import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.mortbay.log.LogFactory;
import org.openqa.selenium.server.ApplicationRegistry;
import org.openqa.selenium.server.RemoteControlConfiguration;
import org.openqa.selenium.server.browserlaunchers.AbstractBrowserLauncher;
import org.openqa.selenium.server.browserlaunchers.AsyncExecute;
import org.openqa.selenium.server.browserlaunchers.BrowserInstallation;
import org.openqa.selenium.server.browserlaunchers.LauncherUtils;
import org.openqa.selenium.server.browserlaunchers.ResourceExtractor;
import org.openqa.selenium.server.browserlaunchers.WindowsProxyManager;
import org.openqa.selenium.server.browserlaunchers.WindowsUtils;
import org.openqa.selenium.server.browserlaunchers.locators.InternetExplorerLocator;

public class InternetExplorerCustomProxyLauncher
extends AbstractBrowserLauncher {
    private static final Log LOGGER = LogFactory.getLog(InternetExplorerCustomProxyLauncher.class);
    private File customProxyPACDir;
    private String[] cmdarray;
    private BrowserInstallation browserInstallation;
    private Process process;
    protected boolean customPACappropriate = true;
    protected WindowsProxyManager wpm;
    private static boolean alwaysChangeMaxConnections = false;
    protected boolean changeMaxConnections = alwaysChangeMaxConnections;

    public InternetExplorerCustomProxyLauncher(RemoteControlConfiguration configuration, String sessionId) {
        this(configuration, sessionId, (String)null);
    }

    public InternetExplorerCustomProxyLauncher(RemoteControlConfiguration configuration, String sessionId, String browserLaunchLocation) {
        this(configuration, sessionId, ApplicationRegistry.instance().browserInstallationCache().locateBrowserInstallation("iexplore", browserLaunchLocation, new InternetExplorerLocator()));
    }

    public InternetExplorerCustomProxyLauncher(RemoteControlConfiguration configuration, String sessionId, BrowserInstallation browserInstallation) {
        super(sessionId, configuration);
        this.browserInstallation = browserInstallation;
        this.wpm = new WindowsProxyManager(true, sessionId, this.getPort(), this.getPort());
    }

    protected void changeRegistrySettings() throws IOException {
        this.wpm.changeRegistrySettings();
    }

    public void launch(String url) {
        try {
            this.setupSystem(url);
            LOGGER.info((Object)"Launching Internet Explorer...");
            AsyncExecute exe = new AsyncExecute();
            exe.setCommandline(this.cmdarray);
            this.process = exe.asyncSpawn();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void setupSystem(String url) throws IOException {
        if (WindowsUtils.thisIsWindows()) {
            if (this.getConfiguration().shouldOverrideSystemProxy()) {
                this.setupSystemProxy();
            }
            this.customProxyPACDir = this.wpm.getCustomProxyPACDir();
            File killableProcessWrapper = new File(this.customProxyPACDir, "killableprocess.exe");
            ResourceExtractor.extractResourcePath(InternetExplorerCustomProxyLauncher.class, "/killableprocess/killableprocess.exe", killableProcessWrapper);
            this.cmdarray = new String[]{killableProcessWrapper.getAbsolutePath(), this.browserInstallation.launcherFilePath(), "-new", url};
        } else {
            this.cmdarray = new String[]{this.browserInstallation.launcherFilePath(), url};
        }
    }

    public void close() {
        Throwable taskKillException = null;
        if (WindowsUtils.thisIsWindows() && this.getConfiguration().shouldOverrideSystemProxy()) {
            this.restoreSystemProxy();
        }
        if (this.process == null) {
            return;
        }
        try {
            this.process.getOutputStream().write(10);
            this.process.getOutputStream().flush();
            Thread.sleep(200L);
        }
        catch (Exception ignored) {
            // empty catch block
        }
        AsyncExecute.killProcess(this.process);
        if (this.customPACappropriate) {
            try {
                LauncherUtils.recursivelyDeleteDir(this.customProxyPACDir);
            }
            catch (RuntimeException e) {
                if (taskKillException != null) {
                    LOGGER.error((Object)"Couldn't delete custom IE proxy directory", (Throwable)e);
                    LOGGER.error((Object)"Perhaps IE proxy delete error was caused by this exception", taskKillException);
                    throw new RuntimeException("Couldn't delete custom IE proxy directory, presumably because task kill failed; see error log!", e);
                }
                throw e;
            }
        }
    }

    private void restoreSystemProxy() {
        this.wpm.restoreRegistrySettings();
    }

    public Process getProcess() {
        return this.process;
    }

    public static void main(String[] args) {
        InternetExplorerCustomProxyLauncher l = new InternetExplorerCustomProxyLauncher(new RemoteControlConfiguration(), "CUSTIE");
        l.launch("http://www.google.com/");
        int seconds = 5;
        System.out.println("Killing browser in " + Integer.toString(seconds) + " seconds");
        AsyncExecute.sleepTight(seconds * 1000);
        l.close();
        System.out.println("He's dead now, right?");
    }

    public static void setChangeMaxConnections(boolean changeMaxConnections) {
        alwaysChangeMaxConnections = changeMaxConnections;
    }

    private void setupSystemProxy() throws IOException {
        this.wpm.backupRegistrySettings();
        this.changeRegistrySettings();
    }
}

