#!/bin/env python
"""
Unit tests for ``pyth_grib``.

Author: Daniel Lee, DWD, 2014
"""

# TODO: Implement these as real unit tests, this is just a list of things you
# can do to test stuff.

import os

from pyth_grib import GribFile, GribIndex


# GribFile tests
filename = "test.grib2"
with GribFile(filename) as grib:
    # Print number of messages in file
    len(grib)
    # Open all messages in file
    for msg in grib:
        print(msg["shortName"])
    len(grib.open_messages)
# When the file is closed, any open messages are closed
len(grib.open_messages)

# GribMessage tests
testfile = "test-output.grib"
with GribFile(filename) as grib:
    # Access shortNames of all messages
    for msg in grib:
        print(msg["shortName"])
    # Report number of keys in message
    len(msg)
    # Report message size in bytes
    msg.size
    # Report keys in message
    msg.keys()
    # Check if value is missing
    msg.missing("scaleFactorOfSecondFixedSurface")
    # Set scalar value
    msg["scaleFactorOfSecondFixedSurface"] = 5
    # Check key's value
    msg["scaleFactorOfSecondFixedSurface"]
    # Set value to missing
    msg.set_missing("scaleFactorOfSecondFixedSurface")
    # Missing values raise exception when read with dict notation
    msg["scaleFactorOfSecondFixedSurface"]
    # Array values are set transparently
    msg["values"] = [1, 2, 3]
    # Messages can be written to file
    with open(testfile, "w") as test:
        msg.write(test)
    # Messages can be cloned from other messages
    msg2 = msg.clone()
    # If desired, messages can be closed manually or used in with
    msg.close()
os.unlink(testfile)

# GribIndex tests
# Create index from file with keys
index_file = "test.index"
keys = "dataDate", "stepRange"
key = keys[1]
other_filename = filename
with GribIndex(filename, keys) as idx:
    # Write index to file
    idx.write(index_file)
# Read index from file
with GribIndex(file_index=index_file) as idx:
    # Add new file to index
    idx.add(other_filename)
    # Report number of unique values for given key
    idx.size(key)
    # Report unique values indexed by key
    idx.values(key)
os.unlink(index_file)
