/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.HashMap;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PGraphicsJava2D;
import processing.core.PMatrix2D;
import processing.core.PShape;
import processing.xml.XMLElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PShapeSVG
extends PShape {
    XMLElement element;
    float opacity;
    float strokeOpacity;
    float fillOpacity;
    Gradient strokeGradient;
    Paint strokeGradientPaint;
    String strokeName;
    Gradient fillGradient;
    Paint fillGradientPaint;
    String fillName;

    public PShapeSVG(PApplet pApplet, String string) {
        this(new XMLElement(pApplet, string));
    }

    public PShapeSVG(XMLElement xMLElement) {
        this(null, xMLElement);
        Object object;
        if (!xMLElement.getName().equals("svg")) {
            throw new RuntimeException("root is not <svg>, it's <" + xMLElement.getName() + ">");
        }
        String string = xMLElement.getString("viewBox");
        if (string != null) {
            object = PApplet.parseInt(PApplet.splitTokens(string));
            this.width = object[2];
            this.height = object[3];
        }
        object = xMLElement.getString("width");
        String string2 = xMLElement.getString("height");
        if (object != null) {
            this.width = PShapeSVG.parseUnitSize((String)object);
            this.height = PShapeSVG.parseUnitSize(string2);
        } else if (this.width == 0.0f || this.height == 0.0f) {
            PGraphics.showWarning("The width and/or height is not readable in the <svg> tag of this file.");
            this.width = 1.0f;
            this.height = 1.0f;
        }
        this.parseChildren(xMLElement);
    }

    public PShapeSVG(PShapeSVG pShapeSVG, XMLElement xMLElement) {
        Object object;
        this.parent = pShapeSVG;
        if (pShapeSVG == null) {
            this.stroke = false;
            this.strokeColor = -16777216;
            this.strokeWeight = 1.0f;
            this.strokeCap = 1;
            this.strokeJoin = 8;
            this.strokeGradient = null;
            this.strokeGradientPaint = null;
            this.strokeName = null;
            this.fill = true;
            this.fillColor = -16777216;
            this.fillGradient = null;
            this.fillGradientPaint = null;
            this.fillName = null;
            this.strokeOpacity = 1.0f;
            this.fillOpacity = 1.0f;
            this.opacity = 1.0f;
        } else {
            this.stroke = pShapeSVG.stroke;
            this.strokeColor = pShapeSVG.strokeColor;
            this.strokeWeight = pShapeSVG.strokeWeight;
            this.strokeCap = pShapeSVG.strokeCap;
            this.strokeJoin = pShapeSVG.strokeJoin;
            this.strokeGradient = pShapeSVG.strokeGradient;
            this.strokeGradientPaint = pShapeSVG.strokeGradientPaint;
            this.strokeName = pShapeSVG.strokeName;
            this.fill = pShapeSVG.fill;
            this.fillColor = pShapeSVG.fillColor;
            this.fillGradient = pShapeSVG.fillGradient;
            this.fillGradientPaint = pShapeSVG.fillGradientPaint;
            this.fillName = pShapeSVG.fillName;
            this.opacity = pShapeSVG.opacity;
        }
        this.element = xMLElement;
        this.name = xMLElement.getString("id");
        if (this.name != null) {
            while ((object = PApplet.match(this.name, "_x([A-Za-z0-9]{2})_")) != null) {
                char c = (char)PApplet.unhex((String)object[1]);
                this.name = this.name.replace((CharSequence)object[0], "" + c);
            }
        }
        this.visible = !((String)(object = xMLElement.getString("display", "inline"))).equals("none");
        String string = xMLElement.getString("transform");
        if (string != null) {
            this.matrix = PShapeSVG.parseMatrix(string);
        }
        this.parseColors(xMLElement);
        this.parseChildren(xMLElement);
    }

    protected void parseChildren(XMLElement xMLElement) {
        XMLElement[] xMLElementArray = xMLElement.getChildren();
        this.children = new PShape[xMLElementArray.length];
        this.childCount = 0;
        for (XMLElement xMLElement2 : xMLElementArray) {
            PShape pShape = this.parseChild(xMLElement2);
            if (pShape == null) continue;
            this.addChild(pShape);
        }
    }

    protected PShape parseChild(XMLElement xMLElement) {
        String string = xMLElement.getName();
        PShapeSVG pShapeSVG = null;
        if (string.equals("g")) {
            pShapeSVG = new PShapeSVG(this, xMLElement);
        } else if (string.equals("defs")) {
            pShapeSVG = new PShapeSVG(this, xMLElement);
        } else if (string.equals("line")) {
            pShapeSVG = new PShapeSVG(this, xMLElement);
            pShapeSVG.parseLine();
        } else if (string.equals("circle")) {
            pShapeSVG = new PShapeSVG(this, xMLElement);
            pShapeSVG.parseEllipse(true);
        } else if (string.equals("ellipse")) {
            pShapeSVG = new PShapeSVG(this, xMLElement);
            pShapeSVG.parseEllipse(false);
        } else if (string.equals("rect")) {
            pShapeSVG = new PShapeSVG(this, xMLElement);
            pShapeSVG.parseRect();
        } else if (string.equals("polygon")) {
            pShapeSVG = new PShapeSVG(this, xMLElement);
            pShapeSVG.parsePoly(true);
        } else if (string.equals("polyline")) {
            pShapeSVG = new PShapeSVG(this, xMLElement);
            pShapeSVG.parsePoly(false);
        } else if (string.equals("path")) {
            pShapeSVG = new PShapeSVG(this, xMLElement);
            pShapeSVG.parsePath();
        } else {
            if (string.equals("radialGradient")) {
                return new RadialGradient(this, xMLElement);
            }
            if (string.equals("linearGradient")) {
                return new LinearGradient(this, xMLElement);
            }
            if (string.equals("text") || string.equals("font")) {
                PGraphics.showWarning("Text and fonts in SVG files are not currently supported, convert text to outlines instead.");
            } else if (string.equals("filter")) {
                PGraphics.showWarning("Filters are not supported.");
            } else if (string.equals("mask")) {
                PGraphics.showWarning("Masks are not supported.");
            } else if (string.equals("pattern")) {
                PGraphics.showWarning("Patterns are not supported.");
            } else if (!string.equals("stop") && !string.equals("sodipodi:namedview")) {
                PGraphics.showWarning("Ignoring  <" + string + "> tag.");
            }
        }
        return pShapeSVG;
    }

    protected void parseLine() {
        this.primitive = 4;
        this.family = 1;
        this.params = new float[]{PShapeSVG.getFloatWithUnit(this.element, "x1"), PShapeSVG.getFloatWithUnit(this.element, "y1"), PShapeSVG.getFloatWithUnit(this.element, "x2"), PShapeSVG.getFloatWithUnit(this.element, "y2")};
    }

    protected void parseEllipse(boolean bl) {
        float f;
        float f2;
        this.primitive = 31;
        this.family = 1;
        this.params = new float[4];
        this.params[0] = PShapeSVG.getFloatWithUnit(this.element, "cx");
        this.params[1] = PShapeSVG.getFloatWithUnit(this.element, "cy");
        if (bl) {
            f = f2 = PShapeSVG.getFloatWithUnit(this.element, "r");
        } else {
            f = PShapeSVG.getFloatWithUnit(this.element, "rx");
            f2 = PShapeSVG.getFloatWithUnit(this.element, "ry");
        }
        this.params[0] = this.params[0] - f;
        this.params[1] = this.params[1] - f2;
        this.params[2] = f * 2.0f;
        this.params[3] = f2 * 2.0f;
    }

    protected void parseRect() {
        this.primitive = 30;
        this.family = 1;
        this.params = new float[]{PShapeSVG.getFloatWithUnit(this.element, "x"), PShapeSVG.getFloatWithUnit(this.element, "y"), PShapeSVG.getFloatWithUnit(this.element, "width"), PShapeSVG.getFloatWithUnit(this.element, "height")};
    }

    protected void parsePoly(boolean bl) {
        this.family = 2;
        this.close = bl;
        String string = this.element.getString("points");
        if (string != null) {
            String[] stringArray = PApplet.splitTokens(string);
            this.vertexCount = stringArray.length;
            this.vertices = new float[this.vertexCount][2];
            for (int i = 0; i < this.vertexCount; ++i) {
                String[] stringArray2 = PApplet.split(stringArray[i], ',');
                this.vertices[i][0] = Float.valueOf(stringArray2[0]).floatValue();
                this.vertices[i][1] = Float.valueOf(stringArray2[1]).floatValue();
            }
        }
    }

    protected void parsePath() {
        this.family = 2;
        this.primitive = 0;
        String string = this.element.getString("d");
        if (string == null) {
            return;
        }
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            boolean bl2 = false;
            if (c == 'M' || c == 'm' || c == 'L' || c == 'l' || c == 'H' || c == 'h' || c == 'V' || c == 'v' || c == 'C' || c == 'c' || c == 'S' || c == 's' || c == 'Q' || c == 'q' || c == 'T' || c == 't' || c == 'Z' || c == 'z' || c == ',') {
                bl2 = true;
                if (i != 0) {
                    stringBuffer.append("|");
                }
            }
            if (c == 'Z' || c == 'z') {
                bl2 = false;
            }
            if (!(c != '-' || bl || i != 0 && cArray[i - 1] == 'e')) {
                stringBuffer.append("|");
            }
            if (c != ',') {
                stringBuffer.append(c);
            }
            if (bl2 && c != ',' && c != '-') {
                stringBuffer.append("|");
            }
            bl = bl2;
        }
        String[] stringArray = PApplet.splitTokens(stringBuffer.toString(), "| \t\n\r\f\u00a0");
        this.vertices = new float[stringArray.length][2];
        this.vertexCodes = new int[stringArray.length];
        float f = 0.0f;
        float f2 = 0.0f;
        int n = 0;
        int n2 = 0;
        block20: while (n < stringArray.length) {
            int n3 = stringArray[n].charAt(0);
            if ((n3 >= 48 && n3 <= 57 || n3 == 45) && n2 != 0) {
                n3 = n2;
                --n;
            } else {
                n2 = n3;
            }
            switch (n3) {
                case 77: {
                    f = PApplet.parseFloat(stringArray[n + 1]);
                    f2 = PApplet.parseFloat(stringArray[n + 2]);
                    this.parsePathMoveto(f, f2);
                    n2 = 76;
                    n += 3;
                    continue block20;
                }
                case 109: {
                    this.parsePathMoveto(f += PApplet.parseFloat(stringArray[n + 1]), f2 += PApplet.parseFloat(stringArray[n + 2]));
                    n2 = 108;
                    n += 3;
                    continue block20;
                }
                case 76: {
                    f = PApplet.parseFloat(stringArray[n + 1]);
                    f2 = PApplet.parseFloat(stringArray[n + 2]);
                    this.parsePathLineto(f, f2);
                    n += 3;
                    continue block20;
                }
                case 108: {
                    this.parsePathLineto(f += PApplet.parseFloat(stringArray[n + 1]), f2 += PApplet.parseFloat(stringArray[n + 2]));
                    n += 3;
                    continue block20;
                }
                case 72: {
                    f = PApplet.parseFloat(stringArray[n + 1]);
                    this.parsePathLineto(f, f2);
                    n += 2;
                    continue block20;
                }
                case 104: {
                    this.parsePathLineto(f += PApplet.parseFloat(stringArray[n + 1]), f2);
                    n += 2;
                    continue block20;
                }
                case 86: {
                    f2 = PApplet.parseFloat(stringArray[n + 1]);
                    this.parsePathLineto(f, f2);
                    n += 2;
                    continue block20;
                }
                case 118: {
                    this.parsePathLineto(f, f2 += PApplet.parseFloat(stringArray[n + 1]));
                    n += 2;
                    continue block20;
                }
                case 67: {
                    float f3 = PApplet.parseFloat(stringArray[n + 1]);
                    float f4 = PApplet.parseFloat(stringArray[n + 2]);
                    float f5 = PApplet.parseFloat(stringArray[n + 3]);
                    float f6 = PApplet.parseFloat(stringArray[n + 4]);
                    float f7 = PApplet.parseFloat(stringArray[n + 5]);
                    float f8 = PApplet.parseFloat(stringArray[n + 6]);
                    this.parsePathCurveto(f3, f4, f5, f6, f7, f8);
                    f = f7;
                    f2 = f8;
                    n += 7;
                    continue block20;
                }
                case 99: {
                    float f3 = f + PApplet.parseFloat(stringArray[n + 1]);
                    float f4 = f2 + PApplet.parseFloat(stringArray[n + 2]);
                    float f5 = f + PApplet.parseFloat(stringArray[n + 3]);
                    float f6 = f2 + PApplet.parseFloat(stringArray[n + 4]);
                    float f7 = f + PApplet.parseFloat(stringArray[n + 5]);
                    float f8 = f2 + PApplet.parseFloat(stringArray[n + 6]);
                    this.parsePathCurveto(f3, f4, f5, f6, f7, f8);
                    f = f7;
                    f2 = f8;
                    n += 7;
                    continue block20;
                }
                case 83: {
                    float f3 = this.vertices[this.vertexCount - 2][0];
                    float f4 = this.vertices[this.vertexCount - 2][1];
                    float f5 = this.vertices[this.vertexCount - 1][0];
                    float f6 = this.vertices[this.vertexCount - 1][1];
                    float f7 = f5 + (f5 - f3);
                    float f8 = f6 + (f6 - f4);
                    float f9 = PApplet.parseFloat(stringArray[n + 1]);
                    float f10 = PApplet.parseFloat(stringArray[n + 2]);
                    float f11 = PApplet.parseFloat(stringArray[n + 3]);
                    float f12 = PApplet.parseFloat(stringArray[n + 4]);
                    this.parsePathCurveto(f7, f8, f9, f10, f11, f12);
                    f = f11;
                    f2 = f12;
                    n += 5;
                    continue block20;
                }
                case 115: {
                    float f3 = this.vertices[this.vertexCount - 2][0];
                    float f4 = this.vertices[this.vertexCount - 2][1];
                    float f5 = this.vertices[this.vertexCount - 1][0];
                    float f6 = this.vertices[this.vertexCount - 1][1];
                    float f7 = f5 + (f5 - f3);
                    float f8 = f6 + (f6 - f4);
                    float f9 = f + PApplet.parseFloat(stringArray[n + 1]);
                    float f10 = f2 + PApplet.parseFloat(stringArray[n + 2]);
                    float f11 = f + PApplet.parseFloat(stringArray[n + 3]);
                    float f12 = f2 + PApplet.parseFloat(stringArray[n + 4]);
                    this.parsePathCurveto(f7, f8, f9, f10, f11, f12);
                    f = f11;
                    f2 = f12;
                    n += 5;
                    continue block20;
                }
                case 81: {
                    float f3 = PApplet.parseFloat(stringArray[n + 1]);
                    float f4 = PApplet.parseFloat(stringArray[n + 2]);
                    float f5 = PApplet.parseFloat(stringArray[n + 3]);
                    float f6 = PApplet.parseFloat(stringArray[n + 4]);
                    this.parsePathQuadto(f, f2, f3, f4, f5, f6);
                    f = f5;
                    f2 = f6;
                    n += 5;
                    continue block20;
                }
                case 113: {
                    float f3 = f + PApplet.parseFloat(stringArray[n + 1]);
                    float f4 = f2 + PApplet.parseFloat(stringArray[n + 2]);
                    float f5 = f + PApplet.parseFloat(stringArray[n + 3]);
                    float f6 = f2 + PApplet.parseFloat(stringArray[n + 4]);
                    this.parsePathQuadto(f, f2, f3, f4, f5, f6);
                    f = f5;
                    f2 = f6;
                    n += 5;
                    continue block20;
                }
                case 84: {
                    float f3 = this.vertices[this.vertexCount - 2][0];
                    float f4 = this.vertices[this.vertexCount - 2][1];
                    float f5 = this.vertices[this.vertexCount - 1][0];
                    float f6 = this.vertices[this.vertexCount - 1][1];
                    float f7 = f5 + (f5 - f3);
                    float f8 = f6 + (f6 - f4);
                    float f9 = PApplet.parseFloat(stringArray[n + 1]);
                    float f10 = PApplet.parseFloat(stringArray[n + 2]);
                    this.parsePathQuadto(f, f2, f7, f8, f9, f10);
                    f = f9;
                    f2 = f10;
                    n += 3;
                    continue block20;
                }
                case 116: {
                    float f3 = this.vertices[this.vertexCount - 2][0];
                    float f4 = this.vertices[this.vertexCount - 2][1];
                    float f5 = this.vertices[this.vertexCount - 1][0];
                    float f6 = this.vertices[this.vertexCount - 1][1];
                    float f7 = f5 + (f5 - f3);
                    float f8 = f6 + (f6 - f4);
                    float f9 = f + PApplet.parseFloat(stringArray[n + 1]);
                    float f10 = f2 + PApplet.parseFloat(stringArray[n + 2]);
                    this.parsePathQuadto(f, f2, f7, f8, f9, f10);
                    f = f9;
                    f2 = f10;
                    n += 3;
                    continue block20;
                }
                case 90: 
                case 122: {
                    this.close = true;
                    ++n;
                    continue block20;
                }
            }
            String string2 = PApplet.join(PApplet.subset(stringArray, 0, n), ",");
            String string3 = PApplet.join(PApplet.subset(stringArray, n), ",");
            System.err.println("parsed: " + string2);
            System.err.println("unparsed: " + string3);
            if (stringArray[n].equals("a") || stringArray[n].equals("A")) {
                String string4 = "Sorry, elliptical arc support for SVG files is not yet implemented (See bug #996 for details)";
                throw new RuntimeException(string4);
            }
            throw new RuntimeException("shape command not handled: " + stringArray[n]);
        }
    }

    private void parsePathVertex(float f, float f2) {
        if (this.vertexCount == this.vertices.length) {
            float[][] fArray = new float[this.vertexCount << 1][2];
            System.arraycopy(this.vertices, 0, fArray, 0, this.vertexCount);
            this.vertices = fArray;
        }
        this.vertices[this.vertexCount][0] = f;
        this.vertices[this.vertexCount][1] = f2;
        ++this.vertexCount;
    }

    private void parsePathCode(int n) {
        if (this.vertexCodeCount == this.vertexCodes.length) {
            this.vertexCodes = PApplet.expand(this.vertexCodes);
        }
        this.vertexCodes[this.vertexCodeCount++] = n;
    }

    private void parsePathMoveto(float f, float f2) {
        if (this.vertexCount > 0) {
            this.parsePathCode(3);
        }
        this.parsePathCode(0);
        this.parsePathVertex(f, f2);
    }

    private void parsePathLineto(float f, float f2) {
        this.parsePathCode(0);
        this.parsePathVertex(f, f2);
    }

    private void parsePathCurveto(float f, float f2, float f3, float f4, float f5, float f6) {
        this.parsePathCode(1);
        this.parsePathVertex(f, f2);
        this.parsePathVertex(f3, f4);
        this.parsePathVertex(f5, f6);
    }

    private void parsePathQuadto(float f, float f2, float f3, float f4, float f5, float f6) {
        this.parsePathCode(1);
        this.parsePathVertex(f + (f3 - f) * 2.0f / 3.0f, f2 + (f4 - f2) * 2.0f / 3.0f);
        this.parsePathVertex(f5 + (f3 - f5) * 2.0f / 3.0f, f6 + (f4 - f6) * 2.0f / 3.0f);
        this.parsePathVertex(f5, f6);
    }

    protected static PMatrix2D parseMatrix(String string) {
        String[] stringArray = PApplet.match(string, "\\s*(\\w+)\\((.*)\\)");
        if (stringArray == null) {
            System.err.println("Could not parse transform " + string);
            return null;
        }
        float[] fArray = PApplet.parseFloat(PApplet.splitTokens(stringArray[2], ", "));
        if (stringArray[1].equals("matrix")) {
            return new PMatrix2D(fArray[0], fArray[2], fArray[4], fArray[1], fArray[3], fArray[5]);
        }
        if (stringArray[1].equals("translate")) {
            float f = fArray[0];
            float f2 = fArray.length == 2 ? fArray[1] : fArray[0];
            return new PMatrix2D(1.0f, 0.0f, f, 0.0f, 1.0f, f2);
        }
        if (stringArray[1].equals("scale")) {
            float f = fArray[0];
            float f3 = fArray.length == 2 ? fArray[1] : fArray[0];
            return new PMatrix2D(f, 0.0f, 0.0f, 0.0f, f3, 0.0f);
        }
        if (stringArray[1].equals("rotate")) {
            float f = fArray[0];
            if (fArray.length == 1) {
                float f4 = PApplet.cos(f);
                float f5 = PApplet.sin(f);
                return new PMatrix2D(f4, -f5, 0.0f, f5, f4, 0.0f);
            }
            if (fArray.length == 3) {
                PMatrix2D pMatrix2D = new PMatrix2D(0.0f, 1.0f, fArray[1], 1.0f, 0.0f, fArray[2]);
                pMatrix2D.rotate(fArray[0]);
                pMatrix2D.translate(-fArray[1], -fArray[2]);
                return pMatrix2D;
            }
        } else {
            if (stringArray[1].equals("skewX")) {
                return new PMatrix2D(1.0f, 0.0f, 1.0f, PApplet.tan(fArray[0]), 0.0f, 0.0f);
            }
            if (stringArray[1].equals("skewY")) {
                return new PMatrix2D(1.0f, 0.0f, 1.0f, 0.0f, PApplet.tan(fArray[0]), 0.0f);
            }
        }
        return null;
    }

    protected void parseColors(XMLElement xMLElement) {
        String string;
        if (xMLElement.hasAttribute("opacity")) {
            string = xMLElement.getString("opacity");
            this.setOpacity(string);
        }
        if (xMLElement.hasAttribute("stroke")) {
            string = xMLElement.getString("stroke");
            this.setColor(string, false);
        }
        if (xMLElement.hasAttribute("stroke-opacity")) {
            string = xMLElement.getString("stroke-opacity");
            this.setStrokeOpacity(string);
        }
        if (xMLElement.hasAttribute("stroke-width")) {
            string = xMLElement.getString("stroke-width");
            this.setStrokeWeight(string);
        }
        if (xMLElement.hasAttribute("stroke-linejoin")) {
            string = xMLElement.getString("stroke-linejoin");
            this.setStrokeJoin(string);
        }
        if (xMLElement.hasAttribute("stroke-linecap")) {
            string = xMLElement.getString("stroke-linecap");
            this.setStrokeCap(string);
        }
        if (xMLElement.hasAttribute("fill")) {
            string = xMLElement.getString("fill");
            this.setColor(string, true);
        }
        if (xMLElement.hasAttribute("fill-opacity")) {
            string = xMLElement.getString("fill-opacity");
            this.setFillOpacity(string);
        }
        if (xMLElement.hasAttribute("style")) {
            string = xMLElement.getString("style");
            String[] stringArray = PApplet.splitTokens(string, ";");
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2 = PApplet.splitTokens(stringArray[i], ":");
                stringArray2[0] = PApplet.trim(stringArray2[0]);
                if (stringArray2[0].equals("fill")) {
                    this.setColor(stringArray2[1], true);
                    continue;
                }
                if (stringArray2[0].equals("fill-opacity")) {
                    this.setFillOpacity(stringArray2[1]);
                    continue;
                }
                if (stringArray2[0].equals("stroke")) {
                    this.setColor(stringArray2[1], false);
                    continue;
                }
                if (stringArray2[0].equals("stroke-width")) {
                    this.setStrokeWeight(stringArray2[1]);
                    continue;
                }
                if (stringArray2[0].equals("stroke-linecap")) {
                    this.setStrokeCap(stringArray2[1]);
                    continue;
                }
                if (stringArray2[0].equals("stroke-linejoin")) {
                    this.setStrokeJoin(stringArray2[1]);
                    continue;
                }
                if (stringArray2[0].equals("stroke-opacity")) {
                    this.setStrokeOpacity(stringArray2[1]);
                    continue;
                }
                if (!stringArray2[0].equals("opacity")) continue;
                this.setOpacity(stringArray2[1]);
            }
        }
    }

    void setOpacity(String string) {
        this.opacity = PApplet.parseFloat(string);
        this.strokeColor = (int)(this.opacity * 255.0f) << 24 | this.strokeColor & 0xFFFFFF;
        this.fillColor = (int)(this.opacity * 255.0f) << 24 | this.fillColor & 0xFFFFFF;
    }

    void setStrokeWeight(String string) {
        this.strokeWeight = PShapeSVG.parseUnitSize(string);
    }

    void setStrokeOpacity(String string) {
        this.strokeOpacity = PApplet.parseFloat(string);
        this.strokeColor = (int)(this.strokeOpacity * 255.0f) << 24 | this.strokeColor & 0xFFFFFF;
    }

    void setStrokeJoin(String string) {
        if (!string.equals("inherit")) {
            if (string.equals("miter")) {
                this.strokeJoin = 8;
            } else if (string.equals("round")) {
                this.strokeJoin = 2;
            } else if (string.equals("bevel")) {
                this.strokeJoin = 32;
            }
        }
    }

    void setStrokeCap(String string) {
        if (!string.equals("inherit")) {
            if (string.equals("butt")) {
                this.strokeCap = 1;
            } else if (string.equals("round")) {
                this.strokeCap = 2;
            } else if (string.equals("square")) {
                this.strokeCap = 4;
            }
        }
    }

    void setFillOpacity(String string) {
        this.fillOpacity = PApplet.parseFloat(string);
        this.fillColor = (int)(this.fillOpacity * 255.0f) << 24 | this.fillColor & 0xFFFFFF;
    }

    void setColor(String string, boolean bl) {
        int n = this.fillColor & 0xFF000000;
        boolean bl2 = true;
        int n2 = 0;
        String string2 = "";
        Gradient gradient = null;
        Paint paint = null;
        if (string.equals("none")) {
            bl2 = false;
        } else if (string.equals("black")) {
            n2 = n;
        } else if (string.equals("white")) {
            n2 = n | 0xFFFFFF;
        } else if (string.startsWith("#")) {
            if (string.length() == 4) {
                string = string.replaceAll("^#(.)(.)(.)$", "#$1$1$2$2$3$3");
            }
            n2 = n | Integer.parseInt(string.substring(1), 16) & 0xFFFFFF;
        } else if (string.startsWith("rgb")) {
            n2 = n | PShapeSVG.parseRGB(string);
        } else if (string.startsWith("url(#")) {
            string2 = string.substring(5, string.length() - 1);
            PShape pShape = this.findChild(string2);
            if (pShape instanceof Gradient) {
                gradient = (Gradient)pShape;
                paint = this.calcGradientPaint(gradient);
            } else {
                System.err.println("url " + string2 + " refers to unexpected data: " + pShape);
            }
        }
        if (bl) {
            this.fill = bl2;
            this.fillColor = n2;
            this.fillName = string2;
            this.fillGradient = gradient;
            this.fillGradientPaint = paint;
        } else {
            this.stroke = bl2;
            this.strokeColor = n2;
            this.strokeName = string2;
            this.strokeGradient = gradient;
            this.strokeGradientPaint = paint;
        }
    }

    protected static int parseRGB(String string) {
        int n = string.indexOf(40) + 1;
        int n2 = string.indexOf(41);
        String string2 = string.substring(n, n2);
        int[] nArray = PApplet.parseInt(PApplet.splitTokens(string2, ", "));
        return nArray[0] << 16 | nArray[1] << 8 | nArray[2];
    }

    protected static HashMap<String, String> parseStyleAttributes(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String[] stringArray = string.split(";");
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split(":");
            hashMap.put(stringArray2[0], stringArray2[1]);
        }
        return hashMap;
    }

    protected static float getFloatWithUnit(XMLElement xMLElement, String string) {
        String string2 = xMLElement.getString(string);
        return string2 == null ? 0.0f : PShapeSVG.parseUnitSize(string2);
    }

    protected static float parseUnitSize(String string) {
        int n = string.length() - 2;
        if (string.endsWith("pt")) {
            return PApplet.parseFloat(string.substring(0, n)) * 1.25f;
        }
        if (string.endsWith("pc")) {
            return PApplet.parseFloat(string.substring(0, n)) * 15.0f;
        }
        if (string.endsWith("mm")) {
            return PApplet.parseFloat(string.substring(0, n)) * 3.543307f;
        }
        if (string.endsWith("cm")) {
            return PApplet.parseFloat(string.substring(0, n)) * 35.43307f;
        }
        if (string.endsWith("in")) {
            return PApplet.parseFloat(string.substring(0, n)) * 90.0f;
        }
        if (string.endsWith("px")) {
            return PApplet.parseFloat(string.substring(0, n));
        }
        return PApplet.parseFloat(string);
    }

    protected Paint calcGradientPaint(Gradient gradient) {
        if (gradient instanceof LinearGradient) {
            LinearGradient linearGradient = (LinearGradient)gradient;
            return new LinearGradientPaint(linearGradient.x1, linearGradient.y1, linearGradient.x2, linearGradient.y2, linearGradient.offset, linearGradient.color, linearGradient.count, this.opacity);
        }
        if (gradient instanceof RadialGradient) {
            RadialGradient radialGradient = (RadialGradient)gradient;
            return new RadialGradientPaint(radialGradient.cx, radialGradient.cy, radialGradient.r, radialGradient.offset, radialGradient.color, radialGradient.count, this.opacity);
        }
        return null;
    }

    @Override
    protected void styles(PGraphics pGraphics) {
        super.styles(pGraphics);
        if (pGraphics instanceof PGraphicsJava2D) {
            PGraphicsJava2D pGraphicsJava2D = (PGraphicsJava2D)pGraphics;
            if (this.strokeGradient != null) {
                pGraphicsJava2D.strokeGradient = true;
                pGraphicsJava2D.strokeGradientObject = this.strokeGradientPaint;
            }
            if (this.fillGradient != null) {
                pGraphicsJava2D.fillGradient = true;
                pGraphicsJava2D.fillGradientObject = this.fillGradientPaint;
            }
        }
    }

    @Override
    public PShape getChild(String string) {
        PShape pShape = super.getChild(string);
        if (pShape == null) {
            pShape = super.getChild(string.replace(' ', '_'));
        }
        if (pShape != null) {
            pShape.width = this.width;
            pShape.height = this.height;
        }
        return pShape;
    }

    public void print() {
        PApplet.println(this.element.toString());
    }

    class RadialGradientPaint
    implements Paint {
        float cx;
        float cy;
        float radius;
        float[] offset;
        int[] color;
        int count;
        float opacity;

        public RadialGradientPaint(float f, float f2, float f3, float[] fArray, int[] nArray, int n, float f4) {
            this.cx = f;
            this.cy = f2;
            this.radius = f3;
            this.offset = fArray;
            this.color = nArray;
            this.count = n;
            this.opacity = f4;
        }

        public PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
            return new RadialGradientContext();
        }

        public int getTransparency() {
            return 3;
        }

        public class RadialGradientContext
        implements PaintContext {
            int ACCURACY = 5;

            public void dispose() {
            }

            public ColorModel getColorModel() {
                return ColorModel.getRGBdefault();
            }

            public Raster getRaster(int n, int n2, int n3, int n4) {
                int n5;
                int n6;
                int n7;
                WritableRaster writableRaster = this.getColorModel().createCompatibleWritableRaster(n3, n4);
                int n8 = (int)RadialGradientPaint.this.radius * this.ACCURACY;
                int[][] nArray = new int[n8][4];
                int n9 = 0;
                for (int i = 1; i < RadialGradientPaint.this.count; ++i) {
                    n7 = RadialGradientPaint.this.color[i - 1];
                    n6 = RadialGradientPaint.this.color[i];
                    n5 = (int)(RadialGradientPaint.this.offset[i] * (float)(n8 - 1));
                    for (int j = n9; j <= n5; ++j) {
                        float f = PApplet.norm(j, n9, n5);
                        nArray[j][0] = (int)PApplet.lerp(n7 >> 16 & 0xFF, n6 >> 16 & 0xFF, f);
                        nArray[j][1] = (int)PApplet.lerp(n7 >> 8 & 0xFF, n6 >> 8 & 0xFF, f);
                        nArray[j][2] = (int)PApplet.lerp(n7 & 0xFF, n6 & 0xFF, f);
                        nArray[j][3] = (int)(PApplet.lerp(n7 >> 24 & 0xFF, n6 >> 24 & 0xFF, f) * RadialGradientPaint.this.opacity);
                    }
                    n9 = n5;
                }
                int[] nArray2 = new int[n3 * n4 * 4];
                n7 = 0;
                for (n6 = 0; n6 < n4; ++n6) {
                    for (n5 = 0; n5 < n3; ++n5) {
                        float f = PApplet.dist(RadialGradientPaint.this.cx, RadialGradientPaint.this.cy, n + n5, n2 + n6);
                        int n10 = PApplet.min((int)(f * (float)this.ACCURACY), nArray.length - 1);
                        nArray2[n7++] = nArray[n10][0];
                        nArray2[n7++] = nArray[n10][1];
                        nArray2[n7++] = nArray[n10][2];
                        nArray2[n7++] = nArray[n10][3];
                    }
                }
                writableRaster.setPixels(0, 0, n3, n4, nArray2);
                return writableRaster;
            }
        }
    }

    class LinearGradientPaint
    implements Paint {
        float x1;
        float y1;
        float x2;
        float y2;
        float[] offset;
        int[] color;
        int count;
        float opacity;

        public LinearGradientPaint(float f, float f2, float f3, float f4, float[] fArray, int[] nArray, int n, float f5) {
            this.x1 = f;
            this.y1 = f2;
            this.x2 = f3;
            this.y2 = f4;
            this.offset = fArray;
            this.color = nArray;
            this.count = n;
            this.opacity = f5;
        }

        public PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
            Point2D point2D = affineTransform.transform(new Point2D.Float(this.x1, this.y1), null);
            Point2D point2D2 = affineTransform.transform(new Point2D.Float(this.x2, this.y2), null);
            return new LinearGradientContext((float)point2D.getX(), (float)point2D.getY(), (float)point2D2.getX(), (float)point2D2.getY());
        }

        public int getTransparency() {
            return 3;
        }

        public class LinearGradientContext
        implements PaintContext {
            int ACCURACY = 2;
            float tx1;
            float ty1;
            float tx2;
            float ty2;

            public LinearGradientContext(float f, float f2, float f3, float f4) {
                this.tx1 = f;
                this.ty1 = f2;
                this.tx2 = f3;
                this.ty2 = f4;
            }

            public void dispose() {
            }

            public ColorModel getColorModel() {
                return ColorModel.getRGBdefault();
            }

            public Raster getRaster(int n, int n2, int n3, int n4) {
                int n5;
                WritableRaster writableRaster = this.getColorModel().createCompatibleWritableRaster(n3, n4);
                int[] nArray = new int[n3 * n4 * 4];
                float f = this.tx2 - this.tx1;
                float f2 = this.ty2 - this.ty1;
                float f3 = (float)Math.sqrt(f * f + f2 * f2);
                if (f3 != 0.0f) {
                    f /= f3;
                    f2 /= f3;
                }
                if ((n5 = (int)PApplet.dist(this.tx1, this.ty1, this.tx2, this.ty2) * this.ACCURACY) <= 0) {
                    int n6 = 0;
                    for (int i = 0; i < n4; ++i) {
                        for (int j = 0; j < n3; ++j) {
                            nArray[n6++] = 0;
                            nArray[n6++] = 0;
                            nArray[n6++] = 0;
                            nArray[n6++] = 255;
                        }
                    }
                } else {
                    int n7;
                    int n8;
                    int n9;
                    int[][] nArray2 = new int[n5][4];
                    int n10 = 0;
                    for (n9 = 1; n9 < LinearGradientPaint.this.count; ++n9) {
                        n8 = LinearGradientPaint.this.color[n9 - 1];
                        n7 = LinearGradientPaint.this.color[n9];
                        int n11 = (int)(LinearGradientPaint.this.offset[n9] * (float)(n5 - 1));
                        for (int i = n10; i <= n11; ++i) {
                            float f4 = PApplet.norm(i, n10, n11);
                            nArray2[i][0] = (int)PApplet.lerp(n8 >> 16 & 0xFF, n7 >> 16 & 0xFF, f4);
                            nArray2[i][1] = (int)PApplet.lerp(n8 >> 8 & 0xFF, n7 >> 8 & 0xFF, f4);
                            nArray2[i][2] = (int)PApplet.lerp(n8 & 0xFF, n7 & 0xFF, f4);
                            nArray2[i][3] = (int)(PApplet.lerp(n8 >> 24 & 0xFF, n7 >> 24 & 0xFF, f4) * LinearGradientPaint.this.opacity);
                        }
                        n10 = n11;
                    }
                    n9 = 0;
                    for (n8 = 0; n8 < n4; ++n8) {
                        for (n7 = 0; n7 < n3; ++n7) {
                            float f5 = (float)(n + n7) - this.tx1;
                            float f6 = (float)(n2 + n8) - this.ty1;
                            int n12 = (int)((f5 * f + f6 * f2) * (float)this.ACCURACY);
                            if (n12 < 0) {
                                n12 = 0;
                            }
                            if (n12 > nArray2.length - 1) {
                                n12 = nArray2.length - 1;
                            }
                            nArray[n9++] = nArray2[n12][0];
                            nArray[n9++] = nArray2[n12][1];
                            nArray[n9++] = nArray2[n12][2];
                            nArray[n9++] = nArray2[n12][3];
                        }
                    }
                }
                writableRaster.setPixels(0, 0, n3, n4, nArray);
                return writableRaster;
            }
        }
    }

    class RadialGradient
    extends Gradient {
        float cx;
        float cy;
        float r;

        public RadialGradient(PShapeSVG pShapeSVG2, XMLElement xMLElement) {
            super(pShapeSVG2, xMLElement);
            this.cx = RadialGradient.getFloatWithUnit(xMLElement, "cx");
            this.cy = RadialGradient.getFloatWithUnit(xMLElement, "cy");
            this.r = RadialGradient.getFloatWithUnit(xMLElement, "r");
            String string = xMLElement.getString("gradientTransform");
            if (string != null) {
                float[] fArray = RadialGradient.parseMatrix(string).get(null);
                this.transform = new AffineTransform(fArray[0], fArray[3], fArray[1], fArray[4], fArray[2], fArray[5]);
                Point2D point2D = this.transform.transform(new Point2D.Float(this.cx, this.cy), null);
                Point2D point2D2 = this.transform.transform(new Point2D.Float(this.cx + this.r, this.cy), null);
                this.cx = (float)point2D.getX();
                this.cy = (float)point2D.getY();
                this.r = (float)(point2D2.getX() - point2D.getX());
            }
        }
    }

    class LinearGradient
    extends Gradient {
        float x1;
        float y1;
        float x2;
        float y2;

        public LinearGradient(PShapeSVG pShapeSVG2, XMLElement xMLElement) {
            super(pShapeSVG2, xMLElement);
            this.x1 = LinearGradient.getFloatWithUnit(xMLElement, "x1");
            this.y1 = LinearGradient.getFloatWithUnit(xMLElement, "y1");
            this.x2 = LinearGradient.getFloatWithUnit(xMLElement, "x2");
            this.y2 = LinearGradient.getFloatWithUnit(xMLElement, "y2");
            String string = xMLElement.getString("gradientTransform");
            if (string != null) {
                float[] fArray = LinearGradient.parseMatrix(string).get(null);
                this.transform = new AffineTransform(fArray[0], fArray[3], fArray[1], fArray[4], fArray[2], fArray[5]);
                Point2D point2D = this.transform.transform(new Point2D.Float(this.x1, this.y1), null);
                Point2D point2D2 = this.transform.transform(new Point2D.Float(this.x2, this.y2), null);
                this.x1 = (float)point2D.getX();
                this.y1 = (float)point2D.getY();
                this.x2 = (float)point2D2.getX();
                this.y2 = (float)point2D2.getY();
            }
        }
    }

    static class Gradient
    extends PShapeSVG {
        AffineTransform transform;
        float[] offset;
        int[] color;
        int count;

        public Gradient(PShapeSVG pShapeSVG, XMLElement xMLElement) {
            super(pShapeSVG, xMLElement);
            XMLElement[] xMLElementArray = xMLElement.getChildren();
            this.offset = new float[xMLElementArray.length];
            this.color = new int[xMLElementArray.length];
            for (int i = 0; i < xMLElementArray.length; ++i) {
                String string;
                XMLElement xMLElement2 = xMLElementArray[i];
                String string2 = xMLElement2.getName();
                if (!string2.equals("stop")) continue;
                String string3 = xMLElement2.getString("offset");
                float f = 1.0f;
                if (string3.endsWith("%")) {
                    f = 100.0f;
                    string3 = string3.substring(0, string3.length() - 1);
                }
                this.offset[this.count] = PApplet.parseFloat(string3) / f;
                String string4 = xMLElement2.getString("style");
                HashMap<String, String> hashMap = Gradient.parseStyleAttributes(string4);
                String string5 = hashMap.get("stop-color");
                if (string5 == null) {
                    string5 = "#000000";
                }
                if ((string = hashMap.get("stop-opacity")) == null) {
                    string = "1";
                }
                int n = (int)(PApplet.parseFloat(string) * 255.0f);
                this.color[this.count] = n << 24 | Integer.parseInt(string5.substring(1), 16);
                ++this.count;
            }
            this.offset = PApplet.subset(this.offset, 0, this.count);
            this.color = PApplet.subset(this.color, 0, this.count);
        }
    }
}

