/*
 * Decompiled with CFR 0.152.
 */
package processing.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import processing.xml.XMLElement;

public class XMLWriter {
    static final int INDENT = 2;
    static final String HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private PrintWriter writer;

    public XMLWriter(Writer writer) {
        this.writer = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
    }

    public XMLWriter(OutputStream outputStream) {
        this.writer = new PrintWriter(outputStream);
    }

    protected void finalize() throws Throwable {
        this.writer = null;
        super.finalize();
    }

    public void write(XMLElement xMLElement) throws IOException {
        this.write(xMLElement, false, 0, 2, true);
    }

    public void write(XMLElement xMLElement, boolean bl) throws IOException {
        this.write(xMLElement, bl, 0, 2, true);
    }

    public void write(XMLElement xMLElement, boolean bl, int n) throws IOException {
        this.write(xMLElement, bl, n, 2, true);
    }

    public void write(XMLElement xMLElement, boolean bl, int n, int n2, boolean bl2) throws IOException {
        if (bl) {
            for (int i = 0; i < n; ++i) {
                this.writer.print(' ');
            }
        }
        if (xMLElement.getLocalName() == null) {
            if (xMLElement.getContent() != null) {
                if (bl) {
                    this.writeEncoded(xMLElement.getContent().trim());
                    this.writer.println();
                } else {
                    this.writeEncoded(xMLElement.getContent());
                }
            }
        } else {
            this.writer.print('<');
            this.writer.print(xMLElement.getName());
            String[] stringArray = xMLElement.listAttributes();
            int n3 = stringArray.length;
            for (int i = 0; i < n3; ++i) {
                String string = stringArray[i];
                String string2 = xMLElement.getAttribute(string, null);
                this.writer.print(" " + string + "=\"");
                this.writeEncoded(string2);
                this.writer.print('\"');
            }
            if (xMLElement.getContent() != null && xMLElement.getContent().length() > 0) {
                this.writer.print('>');
                this.writeEncoded(xMLElement.getContent());
                this.writer.print("</" + xMLElement.getName() + '>');
                if (bl) {
                    this.writer.println();
                }
            } else if (xMLElement.hasChildren() || !bl2) {
                this.writer.print('>');
                if (bl) {
                    this.writer.println();
                }
                int n4 = xMLElement.getChildCount();
                for (n3 = 0; n3 < n4; ++n3) {
                    XMLElement xMLElement2 = xMLElement.getChild(n3);
                    this.write(xMLElement2, bl, n + n2, n2, bl2);
                }
                if (bl) {
                    for (n3 = 0; n3 < n; ++n3) {
                        this.writer.print(' ');
                    }
                }
                this.writer.print("</" + xMLElement.getName() + ">");
                if (bl) {
                    this.writer.println();
                }
            } else {
                this.writer.print("/>");
                if (bl) {
                    this.writer.println();
                }
            }
        }
        this.writer.flush();
    }

    private void writeEncoded(String string) {
        block8: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\n': {
                    this.writer.print(c);
                    continue block8;
                }
                case '<': {
                    this.writer.print("&lt;");
                    continue block8;
                }
                case '>': {
                    this.writer.print("&gt;");
                    continue block8;
                }
                case '&': {
                    this.writer.print("&amp;");
                    continue block8;
                }
                case '\'': {
                    this.writer.print("&apos;");
                    continue block8;
                }
                case '\"': {
                    this.writer.print("&quot;");
                    continue block8;
                }
                default: {
                    if (c < ' ' || c > '~') {
                        this.writer.print("&#x");
                        this.writer.print(Integer.toString(c, 16));
                        this.writer.print(';');
                        continue block8;
                    }
                    this.writer.print(c);
                }
            }
        }
    }
}

