/*
 * Decompiled with CFR 0.152.
 */
package jycessing;

import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.concurrent.CountDownLatch;
import java.util.regex.Pattern;
import jycessing.Runner;
import org.python.core.CompileMode;
import org.python.core.CompilerFlags;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyInteger;
import org.python.core.PyJavaType;
import org.python.core.PyObject;
import org.python.core.PySet;
import org.python.core.PyStringMap;
import org.python.core.PyType;
import org.python.core.PyUnicode;
import org.python.util.InteractiveConsole;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PImage;

public abstract class PAppletJythonDriver
extends PApplet {
    protected final PyStringMap builtins;
    protected final InteractiveConsole interp;
    private final String pySketchPath;
    private final String programText;
    private final CountDownLatch finishedLatch = new CountDownLatch(1);
    private final boolean isStaticMode;
    private static final Pattern ACTIVE_METHOD_DEF = Pattern.compile("^def\\s+(setup|draw)\\s*\\(\\s*\\)\\s*:", 8);
    private final PyObject setupMeth;
    private final PyObject drawMeth;
    private final PyObject mousePressedMeth;
    private final PyObject mouseClickedMeth;
    private final PyObject mouseReleasedMeth;
    private final PyObject mouseDraggedMeth;
    private final PyObject keyPressedMeth;
    private final PyObject keyReleasedMeth;
    private final PyObject keyTypedMeth;
    private final PyObject initMeth;
    private final PyObject stopMeth;

    protected abstract void populateBuiltins();

    private void interpretSketch() {
        try {
            Py.setSystemState(this.interp.getSystemState());
            Py.exec(Py.compile_flags(this.programText, this.pySketchPath, CompileMode.exec, new CompilerFlags()), this.interp.getLocals(), null);
            Py.flushLine();
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            this.checkForRendererChangeException(throwable);
            while (throwable2.getCause() != null) {
                throwable2 = throwable2.getCause();
            }
            throwable2.printStackTrace(System.err);
            System.exit(-1);
        }
    }

    protected void setFields() {
        this.builtins.__setitem__("key", (PyObject)new PyUnicode(Character.toString(this.key)));
    }

    public PAppletJythonDriver(InteractiveConsole interactiveConsole, String string, String string2) {
        this.programText = string2;
        this.pySketchPath = string;
        this.sketchPath = new File(string).getParent();
        this.isStaticMode = !ACTIVE_METHOD_DEF.matcher(string2).find();
        Runner.log("Mode: ", this.isStaticMode ? "static" : "active");
        this.builtins = (PyStringMap)interactiveConsole.getSystemState().getBuiltins();
        this.interp = interactiveConsole;
        PAppletJythonDriver.initializeStatics(this.builtins);
        this.setSet();
        this.populateBuiltins();
        this.setFields();
        this.builtins.__setitem__("this", Py.java2py(this));
        this.builtins.__setitem__("g", Py.java2py(this.g));
        this.builtins.__setitem__("exit", new PyObject(){

            @Override
            public PyObject __call__(PyObject[] pyObjectArray, String[] stringArray) {
                PAppletJythonDriver.this.finishedLatch.countDown();
                return Py.None;
            }
        });
        if (!this.isStaticMode) {
            this.interpretSketch();
        }
        this.drawMeth = interactiveConsole.get("draw");
        this.setupMeth = interactiveConsole.get("setup");
        this.mousePressedMeth = interactiveConsole.get("mousePressed");
        this.mouseClickedMeth = interactiveConsole.get("mouseClicked");
        this.mouseReleasedMeth = interactiveConsole.get("mouseReleased");
        this.mouseDraggedMeth = interactiveConsole.get("mouseDragged");
        this.keyPressedMeth = interactiveConsole.get("keyPressed");
        this.keyReleasedMeth = interactiveConsole.get("keyReleased");
        this.keyTypedMeth = interactiveConsole.get("keyTyped");
        this.initMeth = interactiveConsole.get("init");
        this.stopMeth = interactiveConsole.get("stop");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
                PAppletJythonDriver.this.finishedLatch.countDown();
            }
        });
    }

    @Override
    public void start() {
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread2, Throwable throwable) {
                throwable.printStackTrace(System.err);
                System.exit(-1);
            }
        });
        super.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        try {
            if (this.initMeth != null) {
                this.builtins.__setitem__("frame", Py.java2py(this.frame));
                this.initMeth.__call__();
            }
        }
        finally {
            super.init();
        }
    }

    public void blockUntilFinished() throws InterruptedException {
        this.finishedLatch.await();
    }

    private void setSet() {
        this.builtins.__setitem__("set", (PyObject)new PyJavaType(){
            {
                this.builtin = true;
                this.init(PySet.class, new HashSet<PyJavaType>());
                this.invalidateMethodCache();
            }

            @Override
            public PyObject __call__(PyObject[] pyObjectArray, String[] stringArray) {
                switch (pyObjectArray.length) {
                    default: {
                        return super.__call__(pyObjectArray, stringArray);
                    }
                    case 3: 
                }
                PyObject pyObject = pyObjectArray[0];
                PyType pyType = pyObject.getType();
                PyObject pyObject2 = pyObjectArray[1];
                PyType pyType2 = pyObject2.getType();
                PyObject pyObject3 = pyObjectArray[2];
                PyType pyType3 = pyObject3.getType();
                if (pyType == PyInteger.TYPE && pyType2 == PyInteger.TYPE && pyType3 == PyInteger.TYPE) {
                    PAppletJythonDriver.this.set(pyObject.asInt(), pyObject2.asInt(), pyObject3.asInt());
                    return Py.None;
                }
                if (pyType == PyInteger.TYPE && pyType2 == PyInteger.TYPE && pyType3.getProxyType() != null && pyType3.getProxyType() == PImage.class) {
                    PAppletJythonDriver.this.set(pyObject.asInt(), pyObject2.asInt(), (PImage)pyObject3.__tojava__(PImage.class));
                    return Py.None;
                }
                return super.__call__(pyObjectArray, stringArray);
            }
        });
    }

    public static void initializeStatics(PyStringMap pyStringMap) {
        for (Field field : PConstants.class.getDeclaredFields()) {
            int n = field.getModifiers();
            if (!Modifier.isPublic(n) && !Modifier.isStatic(n)) continue;
            try {
                pyStringMap.__setitem__(field.getName(), Py.java2py(field.get(null)));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void checkForRendererChangeException(Throwable throwable) {
        if (throwable.getCause() instanceof PApplet.RendererChangeException) {
            throw (PApplet.RendererChangeException)throwable.getCause();
        }
    }

    @Override
    public void size(int n, int n2, String string, String string2) {
        super.size(n, n2, string, string2);
        this.setFields();
        this.builtins.__setitem__("g", Py.java2py(this.g));
        this.builtins.__setitem__("frame", Py.java2py(this.frame));
    }

    @Override
    public void setup() {
        this.setFields();
        this.builtins.__setitem__("frame", Py.java2py(this.frame));
        try {
            if (this.isStaticMode) {
                Runner.log("Interpreting static-mode sketch.");
                this.interpretSketch();
            } else if (this.setupMeth != null) {
                this.setupMeth.__call__();
            }
        }
        catch (PyException pyException) {
            this.checkForRendererChangeException(pyException);
            throw pyException;
        }
    }

    @Override
    public void draw() {
        if (this.drawMeth == null) {
            Runner.log("Calling super.draw() in what I assume is a static-mode sketch.");
            super.draw();
        } else {
            this.setFields();
            this.drawMeth.__call__();
        }
    }

    @Override
    public void loadPixels() {
        super.loadPixels();
        this.builtins.__setitem__("pixels", Py.java2py(this.pixels));
    }

    @Override
    public void mouseClicked() {
        if (this.mouseClickedMeth == null) {
            super.mouseClicked();
        } else {
            this.setFields();
            this.mouseClickedMeth.__call__();
        }
    }

    @Override
    public void mousePressed() {
        if (this.mousePressedMeth == null) {
            super.mousePressed();
        } else {
            this.setFields();
            this.mousePressedMeth.__call__();
        }
    }

    @Override
    public void mouseReleased() {
        if (this.mouseReleasedMeth == null) {
            super.mouseReleased();
        } else {
            this.setFields();
            this.mouseReleasedMeth.__call__();
        }
    }

    @Override
    public void mouseDragged() {
        if (this.mouseDraggedMeth == null) {
            super.mouseDragged();
        } else {
            this.setFields();
            this.mouseDraggedMeth.__call__();
        }
    }

    @Override
    public void keyPressed() {
        if (this.keyPressedMeth == null) {
            super.keyPressed();
        } else {
            this.setFields();
            this.keyPressedMeth.__call__();
        }
    }

    @Override
    public void keyReleased() {
        if (this.keyReleasedMeth == null) {
            super.keyReleased();
        } else {
            this.setFields();
            this.keyReleasedMeth.__call__();
        }
    }

    @Override
    public void keyTyped() {
        if (this.keyTypedMeth == null) {
            super.keyTyped();
        } else {
            this.setFields();
            this.keyTypedMeth.__call__();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        try {
            if (this.stopMeth != null) {
                this.stopMeth.__call__();
            }
        }
        finally {
            super.stop();
        }
    }
}

