/*
 * Decompiled with CFR 0.152.
 */
package jycessing;

import java.awt.Window;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import jycessing.DriverImpl;
import org.python.core.Py;
import org.python.core.PyString;
import org.python.util.InteractiveConsole;
import org.python.util.PythonInterpreter;
import processing.core.PApplet;

public class Runner {
    static boolean VERBOSE = false;
    private static final Pattern JAR_RESOURCE = Pattern.compile("jar:file:(.+?)/processing-py.jar!/jycessing/buildnumber.properties");
    private static final Pattern FILE_RESOURCE = Pattern.compile("file:(.+?)/bin/jycessing/buildnumber.properties");

    static void log(Object ... objectArray) {
        if (!VERBOSE) {
            return;
        }
        for (Object object : objectArray) {
            System.err.print(String.valueOf(object));
        }
        System.err.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String read(Reader reader) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        StringBuilder stringBuilder = new StringBuilder(1024);
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string).append("\n");
            }
            String string2 = stringBuilder.toString();
            return string2;
        }
        finally {
            bufferedReader.close();
        }
    }

    private static String read(InputStream inputStream) throws IOException {
        return Runner.read(new InputStreamReader(inputStream, "UTF-8"));
    }

    private static void addJar(URL uRL) throws Exception {
        URLClassLoader uRLClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        for (URL uRL2 : uRLClassLoader.getURLs()) {
            if (!uRL2.equals(uRL)) continue;
            return;
        }
        Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
        method.setAccessible(true);
        method.invoke((Object)uRLClassLoader, uRL);
        Runner.log("Added ", uRL, " to classpath.");
    }

    private static void addLibraryPath(String string) throws Exception {
        String[] stringArray;
        Field field = ClassLoader.class.getDeclaredField("usr_paths");
        field.setAccessible(true);
        for (String string2 : stringArray = (String[])field.get(null)) {
            if (!string.equals(string2)) continue;
            return;
        }
        String[] stringArray2 = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        stringArray2[stringArray.length] = string;
        field.set(null, stringArray2);
        Runner.log("Added ", string, " to java.library.path.");
    }

    private static void searchForExtraStuff(File file) throws Exception {
        if (file == null) {
            throw new IllegalArgumentException("null dir");
        }
        Runner.log("Searching: ", file);
        File[] fileArray = file.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.matches("^.+\\.(so|dll|jnilib)$");
            }
        });
        if (fileArray != null && fileArray.length > 0) {
            Runner.addLibraryPath(file.getAbsolutePath());
        } else {
            Runner.log("No DLLs in ", file);
        }
        File[] fileArray2 = file.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.matches("^.+\\.jar$");
            }
        });
        if (fileArray2 != null && fileArray2.length != 0) {
            for (File file2 : fileArray2) {
                Runner.addJar(file2.toURI().toURL());
            }
        } else {
            Runner.log("No JARs in ", file);
        }
        File[] fileArray3 = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                Runner.log("Looking at ", file);
                return file.isDirectory() && file.getName().charAt(0) != '.';
            }
        });
        if (fileArray3 != null && fileArray3.length != 0) {
            for (File file3 : fileArray3) {
                Runner.searchForExtraStuff(file3);
            }
        } else {
            Runner.log("No dirs in ", file);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        Runner.runFromCommandLineArguments(stringArray);
        System.exit(0);
    }

    public static void runFromCommandLineArguments(String[] stringArray) throws Exception {
        if (stringArray.length < 1) {
            throw new RuntimeException("I need the path of your Python script as an argument.");
        }
        VERBOSE = Boolean.getBoolean("verbose");
        Properties properties = new Properties();
        properties.load(Runner.class.getResourceAsStream("buildnumber.properties"));
        Runner.log("processing.py build ", properties.getProperty("buildnumber"));
        String string = stringArray[stringArray.length - 1];
        String string2 = Runner.read(new FileReader(string));
        Runner.runSketch(stringArray, string, string2);
    }

    private static File getLibrariesDir() {
        String string;
        try {
            string = URLDecoder.decode(Runner.class.getResource("buildnumber.properties").toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Impossible: " + unsupportedEncodingException);
        }
        Matcher matcher = JAR_RESOURCE.matcher(string);
        if (matcher.matches()) {
            Runner.log("We're running from a JAR file.");
            return new File(matcher.group(1), "libraries");
        }
        matcher = FILE_RESOURCE.matcher(string);
        if (matcher.matches()) {
            Runner.log("We're running from class files.");
            return new File(matcher.group(1), "libraries");
        }
        System.err.println("WARNING: I can't figure out where my libraries directory is.");
        return new File("libraries");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runSketch(String[] stringArray, String string, String string2) throws Exception {
        File file = Runner.getLibrariesDir();
        Runner.searchForExtraStuff(file);
        String string3 = new File(string).getCanonicalFile().getParent();
        Properties properties = new Properties();
        properties.setProperty("python.path", file.getAbsolutePath() + File.pathSeparator + string3);
        PythonInterpreter.initialize(null, properties, new String[]{""});
        Py.initPython();
        InteractiveConsole interactiveConsole = new InteractiveConsole();
        interactiveConsole.setOut(System.out);
        System.setProperty("user.dir", string3);
        Py.getSystemState().path.insert(0, new PyString(string3));
        interactiveConsole.set("__file__", string);
        interactiveConsole.exec(Runner.read(Runner.class.getResourceAsStream("core.py")));
        DriverImpl driverImpl = new DriverImpl(interactiveConsole, string, string2);
        try {
            PApplet.runSketch(stringArray, driverImpl);
            driverImpl.blockUntilFinished();
            Runner.log("Applet is finished. Disposing window.");
            ((Window)SwingUtilities.getRoot(driverImpl)).dispose();
        }
        catch (Throwable throwable) {
            try {
                Py.printException(throwable);
            }
            catch (Throwable throwable2) {
                Runner.log("Cleaning up interpreter.");
                interactiveConsole.cleanup();
                throw throwable2;
            }
            Runner.log("Cleaning up interpreter.");
            interactiveConsole.cleanup();
        }
        Runner.log("Cleaning up interpreter.");
        interactiveConsole.cleanup();
    }
}

