#!/usr/bin/env python
# -*- coding: utf-8 -*-
'''
Copyright 2012 Rodrigo Pinheiro Matias <rodrigopmatias@gmail.com>

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
'''
from PyQt4 import QtGui
from QSupervisorControl import SupervisorController
from QSupervisorControl.system import System

import signal
import sys
import traceback


def int_handler(signal, frame):
    QtGui.QApplication.exit(1)


def main():
    signal.signal(signal.SIGINT, int_handler)

    try:
        System.app = QtGui.QApplication(sys.argv)

        System.control = SupervisorController(System.app)
        System.control.show()

        System.wnd = QtGui.QMainWindow()
        System.wnd.setVisible(False)

        System.app.setQuitOnLastWindowClosed(False)
        System.app.exec_()
    except Exception:
        traceback.print_exc(file=sys.stdout)

__name__ == '__main__' and main()
