# -*- coding: utf-8 -*-
import unittest

from ..suite import QUnitSuite

from utils import path_to

class TestSuccess(unittest.TestCase):
    def test_various(self):
        result = unittest.TestResult()
        suite = QUnitSuite(path_to('success.html'))
        suite(result)

        self.assertEqual(result.skipped, [])
        self.assertEqual(result.errors, [])
        self.assertEqual(result.failures, [])
        self.assertEqual(result.testsRun, 6)

class TestFailure(unittest.TestCase):
    def test_various(self):
        result = unittest.TestResult()
        suite = QUnitSuite(path_to('failure.html'))
        suite(result)

        self.assertEqual(result.skipped, [])
        self.assertEqual(result.errors, [])
        self.assertEqual(len(result.failures), 10)
        # check messages
        self.assertEqual(result.failures[0][1],"")
        self.assertEqual(result.failures[1][1], '12 != "13"')
        self.assertEqual(result.failures[2][1], '"foo" != "bar"')
        self.assertEqual(result.failures[3][1], '')
        # too bothersome
        # self.assertEqual(result.failures[4][1], )
        self.assertEqual(result.failures[5][1], '')
        # make no sense
        # self.assertEqual(result.failures[6][1], )
        # self.assertEqual(result.failures[7][1], )
        # Need to rewrite that
        self.assertEqual(result.failures[8][1],
                         'Died on test #1 undefined: Blow up')
        self.assertTrue(result.failures[9][1].startswith(
            'Error: Out of test'))

        self.assertEqual(result.testsRun, 8)

