#!/usr/bin/env python
from __future__ import absolute_import, division, print_function
"""Event logger to allow testing events.

The events are all generated by the entry widget and its title widget.

Based on code in John Grayson's "Python and Tkinter Programming"
"""
import sys
import os
import Tkinter
RORoot = os.path.join(os.path.dirname(os.path.abspath(os.path.dirname(__file__))), "python")
sys.path.append(RORoot)
import RO.Wdg

class EventLogger(Tkinter.Frame):
    EventDict = {
         '2': 'KeyPress',
         '3': 'KeyRelease',
         '4': 'ButtonPress',
         '5': 'ButtonRelease',
         '6': 'Motion',
         '7': 'Enter',
         '8': 'Leave',
         '9': 'FocusIn',
        '10': 'FocusOut',
        '12': 'Expose',
        '15': 'Visibility',
        '17': 'Destroy',
        '18': 'Unmap',
        '19': 'Map',
        '21': 'Reparent',
        '22': 'Configure',
        '24': 'Gravity',
        '26': 'Circulate',
        '28': 'Property',
        '32': 'Colormap',
        '36': 'Activate',
        '37': 'Deactivate',
    }

    def __init__(self, master):
        Tkinter.Frame.__init__(self, master)
        # dict of event type: event name
        
        self.eventInd = 0
        
        self.userLabel = Tkinter.Label(self, text="Type here:")
        self.userEntry  = Tkinter.Entry(self, highlightthickness=2)
        self.logWdg = RO.Wdg.LogWdg(self)
        
        for eventName in self.EventDict.values():
            self.userLabel.bind('<%s>' % eventName, self.reportEvent)
            self.userEntry.bind('<%s>' % eventName, self.reportEvent)
        
        self.userLabel.grid(row=0, column=0)
        self.userEntry.grid(row=0, column=1, sticky="ew")
        self.logWdg.grid(row=1, column=0, columnspan=2, sticky="ewns")
        self.rowconfigure(1, weight=1)
        self.columnconfigure(1, weight=1)
        
        self.userEntry.focus_set()
        
    def reportEvent(self, evt):
        eventName = self.EventDict.get(evt.type, 'Unknown')
        rptList = [
            '\n\nEvent %d' % (self.eventInd,),
            'type=%r (%s)' % (evt.type, eventName,),
            'serial=%r' % (evt.serial,),
            'time=%r' % (evt.time,),
            'widget=%r' % (evt.widget,),
            '\nx=%r  y=%r' % (evt.x, evt.y),
            'x_root=%r' % (evt.x_root,),
            'y_root=%r' % (evt.y_root,),
            'num=%r' % (evt.num,),
            'char=%r' % (evt.char,),
            'keysym=%r' % (evt.keysym,),
            'keysym_num=%r' % (evt.keysym_num,),
            '\ndelta=%r' % (evt.delta,),
            'height=%r' % (evt.height,),
            'width=%r' % (evt.width,),
        ]
        self.eventInd += 1
    
        #### some event types don't have these attributes 
        try:
            rptList.append(
                'focus=%s' % (evt.focus)
            )
        except AttributeError:
            pass
        try:
            rptList.append(
                'send_event=%s' % (evt.send_event)
            )
        except AttributeError:
            pass
        
#        print '; '.join(rptList)
        self.logWdg.addOutput('; '.join(rptList))
            

if __name__ == "__main__":
    root = Tkinter.Tk()
    root.geometry("800x500")
    root.wm_title("Event Logger")
    evtLogger = EventLogger(root)
    evtLogger.pack(expand=True, fill="both")
    root.mainloop()
