# Copyright (c) 2009-2014 Stefan Marr <http://www.stefan-marr.de/>
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to
# deal in the Software without restriction, including without limitation the
# rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
# sell copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
# IN THE SOFTWARE.

"""
Glossary:


  data point:
      a set of measurements belonging together.
      generated by one specific run.
      In some cases, a single run can produce multiple data points.

  measurement:
      one value for one specific criterion
  
  virtual machine:
      A named set of settings for the executor of a benchmark suite.
      
      Typically, this is one specific virtual machine with a specific set of
      startup parameters. It refers to an executable that will execute
      benchmarks from suite. Thus, the virtual machine is the executor.

  benchmark suite:
      A set of benchmarks with a variety of parameters, i.e., dimension to be
      explored by a benchmark.
  
  benchmark:
      A set of experiments based on one program to be executed.
      The set is described by parameters, i.e., dimensions that are to be
      explored.

  run:
      A run is one specific experiments based on the selected
      parameters, benchmark, benchmark suite, and virtual machine.
      One run can generate multiple data points.
  
  experiment:
      Brings together benchmark suites, virtual machines, and their
      various parameters.
"""


def value_or_list_as_list(value):
    if type(value) is list:
        return value
    elif value is None:
        return []
    else:
        return [value]


def value_with_optional_details(value, default_details = None):
    if type(value) is dict:
        assert len(value) == 1
        (value, details) = value.items()[0]
    else:
        details = default_details
    
    return value, details
