from __future__ import with_statement, absolute_import
from mext.addons import AddOn
from weakref import ref
from mext.reaction.stm import *
from mext.reaction.celltypes.base import *
from mext.reaction.celltypes.maintain import *

__all__ = ['Connector']


class Connector(AddOn):
    __slots__ = 'cell',  'connect', 'watch_connect', 'is_connected'

    def __init__(self, cell, connect):
        self.cell = ref(cell)
        self.connect = connect
        self.is_connected = Value(False)
        with ctrl.need_txn() as txn:
            txn.effect(self._start_watching)
            #@@ on-fail
            txn.on_undo(self.delete_from, cell, connect)
        #self._start_watching()
        #self.watch_connect = MaintainRule(self.watch_connect_rule)

    #@effect_method
    def _start_watching(self):
        self.watch_connect = MaintainRule(self.watch_connect_rule)

    def watch_connect_rule(self):
        cell = self.cell()
        if cell is None:
            #@@ no disconnect message for dead cell
            # from other side there are no cell to pass into self.connect
            # maybe it can be solved with passing weakref to cell without dereferencing?
            # weakref can be key as well as cell itself
            # another solution is not pass cell at all
            # looking at existing codebase it's preferable
            # connect callback can be generated with storing cell inside
            return
        needs_conn = cell.has_listeners
        if needs_conn != self.connected:
            self._connect(needs_conn)

    @property
    def connected(self):
        return self.is_connected.read()

    @effect_method
    def _connect(self, conn):
        cell = self.cell()
        if cell is None:
            return
        self.connect(cell, conn)
        self.is_connected.write(conn)

    def __repr__(self):
        cell = self.cell()
        if cell is None:
            cell_repr = '<dead cell>'
        else:
            cell_repr = repr(cell)
        return "Connector(%s, %r)" % (cell_repr, self.connect)

