from __future__ import with_statement, absolute_import
from mext.reaction.stm import *
from mext.reaction.celltypes.base import *

class RuleBase(HasListenersBase, AbstractListener):
    __slots__ = 'key', 'rule', '__weakref__', 'layer', 'next_subject'

    def __init__(self, rule):
        self.key = CellKey(self)
        self.rule = rule
        self.layer = 0
        super(RuleBase, self).__init__()

    def run(self):
        txn = ctrl.txn
        curval = self.get_curval()
        value = self.rule()
        txn.change_key(txn.set_by, self, self)
        txn.change_key(txn.writes, self.key, value)
        # lets be careful not to reschedule our initializer
        if value != curval and self.next_listener:
            txn.changed(self)
        if not txn.rule_reads:
            txn.effect(self.become_constant)

    def get_curval(self):
        # this is required to support
        # 1. tracking resetting values (@@? really)
        txn = ctrl.txn
        key = self.key
        if key in txn.writes:
            return txn.writes[key]
        else:
            # 2. concurrent txns
            txn.note_read(key)
            return txn.snapshot[key]


    def _const_class(self):
        return ConstantRule

    def __repr__(self):
        if ctrl.txn and self in ctrl.txn.set_by:
            val = repr(ctrl.txn.writes[self.key])
        else:
            try:
                val = repr(ctrl.state[self.key])
            except KeyError:
                val = '<error: key not in state>'
        _extra = ''
        return "%s(%s, %s%s)" % (self.__class__.__name__, val, self.rule, _extra)






class ConstantRule(ConstantMixin, RuleBase):
    """
        A read-only cell that no longer depends on anything else
    """
    __slots__ = ()
    def read(self):
        return ctrl.state[self.key] #@@

    def dirty(self):
        # Constants don't need recalculation
        raise AssertionError("%s cannot be dirty. Scheduled by %s" % (self, ctrl.txn.crule))

    def run(self):
        # Constants don't run
        raise AssertionError




