from __future__ import with_statement, absolute_import

from mext.classhacks import classy

#from mext.reaction.stm import *
from mext.reaction.component.base import *
from mext.reaction.component.attrs import *
from mext.reaction.component.cellcache import *



__all__ = [
    'Component', 'Cells', 'CellAttribute',
    'get_cell', 'replace_cell',
    'attr', 'attrs', 'compute', 'maintain', 'track', #'perform',
    'make', 'todo', 'cellcache', 'active_cellcache', 'lazymap', 'writer',
    'effect_method',
    #'init_attrs',
    'has_listeners',
]


def has_listeners(ob, name):
    return get_cell(ob, name).has_listeners


def init_attrs(self, **kw):
    """Initialize attributes from keyword arguments"""
    if kw:
        cells = None
        cls = type(self)
        for k, v in kw.iteritems():
            try:
                attr = getattr(cls, k)
            except AttributeError:
                msg = "%s() has no keyword argument %r" % (cls.__name__, k)
                raise TypeError(msg)
            else:
                if isinstance(v, AbstractCell) and isinstance(attr, CellAttribute):
                    #@@ move this to attr.set_init(ob, value)
                    if cells is None:
                        cells = Cells(self)
                    assert k not in cells
                    replace_cell(cells, k, v)
                else:
                    setattr(self, k, v)



def make_cells(instance):
    cls = instance.__class__
    optional = IsOptional(cls)
    cells = Cells(instance)
    for name, opt in optional.iteritems():
        if not opt and name not in cells:
            get_cell(instance, name, cells=cells)

def init_cell_attrs(cls, name, bases, cdict):
    optional = IsOptional(cls)
    factories = CellFactories(cls)
    for k, descr in cdict.items():
        if isinstance(descr, CellAttribute):
            descr.set_name(k)
            assert descr.__name__ == k, descr
            optional[k] = descr.optional
            factories[k] = descr.make_cell
        elif k in optional:
            # Don't create a cell for overridden non-CellProperty attribute
            optional[k] = True




class Component(classy):
    """Base class for objects with Cell attributes"""
    __slots__ = ()

    @classmethod
    def __class_call__(cls, *args, **kw):
        with ctrl.need_txn() as txn:
            #root = RootRule()
            #with self._replace_crule(root):
            with txn.new_root():
                instance = super(Component, cls).__class_call__(*args, **kw)
                assert isinstance(instance, cls)
                if txn.rule_reads:
                    #@@ todo: check for resetting reads
                    raise RuntimeError(
                        "Components should not read transactional state during initialization"
                        " %s.__init__ has read %r" % (cls.__name__, list(txn.rule_reads))
                    )
                txn._process_writes()
                txn.rule_writes = set()
                make_cells(instance)
                #txn._process_writes()
                return instance

    __init__ = init_attrs

    def __class_init__(cls, name, bases, cdict, supr):
        supr()(cls, name, bases, cdict, supr)
        try:
            Component
        except NameError:
            return
        init_cell_attrs(cls, name, bases, cdict)



























