from __future__ import absolute_import
from mext.reaction.stm import *
from mext.reaction.celltypes import ConstantMixin

from mext.addons import AddOn, Registry



class CellFactories(Registry):
    """
        Registry for cell factories
        Required to allow inheritance from both Component and
        Service -- otherwise we wouldn't be able to get factories.
    """

class IsOptional(Registry):
    """Registry for flagging that an attribute need not be activated"""

class Cells(AddOn):
    __slots__ = ()
    addon_key = '__cells__'.__str__
    def __new__(cls, subject):
        return {}



def get_cell(ob, name, attr=None, cells=None):
    if cells is None:
        try:
            cells = ob.__cells__
        except AttributeError:
            cells = Cells(ob)
    try:
        return cells[name]
    except KeyError:
        if attr is None:
            factory = CellFactories(type(ob))[name]
        else:
            factory = attr.make_cell
        # this isn't good enough -- cell creation has to be synchronous
        cell = cells.setdefault(name, factory(ob))
        if ctrl.txn:
            ctrl.txn.on_undo(cells.pop, name)
        return cell

# this is not concurrency-friendly -- cells dict is global
def replace_cell(cells, name, new_cell):
    if type(cells) is not dict:
        cells = Cells(cells)
    with ctrl.need_txn() as txn:
        assert not txn.crule.readonly
        #assert not txn.crule.can_rerun
        if name in cells:
            old_cell = cells[name]
            if isinstance(old_cell, ConstantMixin):
                raise AttributeError("Can't change a constant")
            # If the old cell was already changed in this transaction
            # this will result in an error which is generally correct
            # behaviour -- previous setter might have wanted to
            # change the cell we are setting now.
            # However if previous change was done through a different attribute
            # (which means this replacement doesn't conflict with it) it's not so clear.
            # This is good enough until there's a real case to investigate.

            # If the update fails we want to restore old cell
            txn.change_key(cells, name, new_cell)
            # Anyway, schedule the listeners of the old cell to update dependencies
            txn.changed(old_cell)
        else:
            txn.set_key(cells, name, new_cell)

