from __future__ import absolute_import
import wx
from mext.reaction import *
from mext.reaction.eventloop import *
from mext.reaction.time import *

from mext.addons import AddOn

__all__ = ['wx', 'WxEventLoop']

def is_broken(name):
    def replacement(*args, **kw):
        raise DeprecationWarning("Don't use %s because it's broken")
    return replacement

wx.CallLater = is_broken('wx.CallLater')

## def call_later(secs, func):
##     if wx.Thread_IsMain():
##         timer = wx.PyTimer(func)
##         delay = max(1, secs*1000) # msecs
##         timer.Start(delay, wx.TIMER_ONE_SHOT)
##
##         from weakref import ref
##         def dead(ref):
##             print 'DEAD'
##         r = ref(timer, dead)
##         timer.timer = timer
##     else:
##         # wx does not like timer creation from other threads
##         wx.CallAfter(call_later, secs, func)
##

class WxEventLoop(EventLoop):
    __service__ = EventLoop
    @maintain
    def _ticker(self):
        if self.running:
            next_time = Time.next_event_time
            if next_time is not None:
                self.tick_when(next_time)
            if self.stop_requested:
                effect(self.app.ExitMainLoop)

    @effect_method
    def tick_when(self, when):
        if wx.Thread_IsMain():
            delay = max(1, (when - Time.time)*1000) # msecs
            self.timer.Start(delay, wx.TIMER_ONE_SHOT)
        else:
            wx.CallAfter(self.tick_when, when)

    #@atomic
    def tick(self):
        if ctrl.txn is not None:
            # timers cbs are called out of order, for ex. could be triggered
            # when applying wx effects.
            # we need a new txn for Time.tick, so we put it in msg queue
            wx.CallAfter(self.tick)
            return
        next_time = Time.next_event_time
        if next_time is not None:
            if Time.time < next_time:
                self.tick_when(next_time)
                return
        Time.tick()


    def _setup(self):
        self.app = wx.GetApp() or wx.PySimpleApp()
        self.timer = wx.PyTimer(self.tick)

    def _teardown(self):
        self.timer = None
        self.app = None

    def _loop(self):
        """
            Loop updating the time and invoking requested calls
        """
        while not self.stop_requested:
            # commented out because MainLoop seems to run fine in non-main thread
            # and CallAfter does get delivered to it
            #if not wx.Thread_IsMain():
            #    raise RuntimeError("WxEventLoop may only be run in main wx thread because it relies on wx.CallAfter for wakeup")
            self.app.MainLoop()
            if self.app.ExitOnFrameDelete:
                self.stop()
            else:
                self.app.ProcessPendingEvents()

    def _arrange_wakeup(self):
        wx.CallAfter(lambda: EventQueue._wakeup())








class WxEvents(AddOn, Component):
    def __init__(self, ob):
        # this is a circular reference, but it's OK
        # given what wx does when windows are destroyed (__dict__.clear())
        self.ob = ob

    @active_cellcache(reset=None)
    def _events(self, key, conn):
        # no undo, because of the new Connector implementation
        event, id = key
        if conn:
##             cell = self.get_cell(key)
##             def receive(evt):
##                 evt.Skip()
##                 if not ctrl.txn:
##                     cell.write(evt)
##                 else:
##                     print 'ignored', evt
##
##             self.ob.Bind(event, receive, None, id)
##
            self.ob.Bind(event, self.get_cell(key).write, None, id)
        else:
            # this will sometimes happen during garbage collection
            # so the error handling is necessary
            try:
                self.ob.Unbind(event, None, id)
            except (wx.PyDeadObjectError, TypeError):
                pass

    def get_cell(self, key):
        if not isinstance(key, tuple):
            key = key, wx.ID_ANY
        return self._events[key]

    def __getitem__(self, key):
        return self.get_cell(key).read()

    def __getattr__(self, name):
        assert name.islower()
        return self[getattr(wx, 'EVT_' + name.upper())]


wx.EvtHandler.evt = property(lambda win: WxEvents(win))
