#!/usr/bin/env python
import sys
from setuptools import setup, find_packages

assert sys.version >= '2.5'

setup(
    name = "Reaction",
    version = "0.2.2",
    url = "http://code.google.com/p/trellis-fork/",
    description = "Reaction is a fork of Trellis: \"A simple 'untwisted' approach to event-driven programming\"",
    long_description = """
    * Trellis_ (c) 2006-2008 Phillip J. Eby
    * Reaction_ (c) 2009-2010 Sergey Schetinin

    .. _Trellis: http://pypi.python.org/pypi/Trellis
    .. _Reaction: http://code.google.com/p/trellis-fork/
    """.strip(),
    license = "PSF or ZPL", # this is a Trellis legacy, I'd prefer MIT -Sergey
    maintainer = "Sergey Schetinin",
    maintainer_email = "sergey@maluke.com",
    packages = find_packages(),
    namespace_packages = ['mext'],
    install_requires = [
        'mext.hacks>=0.9', 'mext.context>=0.6', 'Extremes>=1.1',
    ],

    test_suite = 'test.suite',
    tests_require = ['mext.test>=0.3'],

    download_url='http://bitbucket.org/mlk/reaction/get/tip.bz2',
)
