from __future__ import with_statement, absolute_import
import os
from mext.reaction.celltypes.rulebase import *
#from mext.reaction.celltypes.track_old import Rule
#from mext.reaction.celltypes.maintain import *
from mext.reaction.celltypes.connector import *
from mext.const import const

__all__ = [
    'AutoDisconnectMixin', 'NEEDS_INIT',
    'ComputeRule', #'NewComputeRule',
    'ComputeConstant',
]

NEEDS_INIT = const()


def disconnector(cell, conn):
    if not conn:
        cell.disconnect()

class AutoDisconnectMixin(HasListenersBase):
    # Jython throws TypeError: ... multiple bases have instance lay-out conflict
    # for ComputeRule unless we skip __slots__ here
    if os.name != 'java':
        __slots__ = ()

    def __init__(self):
        super(AutoDisconnectMixin, self).__init__()
        Connector(self, disconnector)

    def disconnect(self):
        if self.next_subject is not None:
            #self.next_subject = None
            link = self.next_subject
            while link is not None:
                nxt = link.next_subject
                link.unlink()
                link = nxt




class ComputeRule(RuleBase, AutoDisconnectMixin):
    """
        @compute implementation.
        Only listens to its subjects if has listeners itself.
        Cannot access its old value.
    """
    __slots__ = ()

    def __init__(self, rule, value=None):
        assert value is None
        super(ComputeRule, self).__init__(rule)
        with ctrl.need_txn() as txn:
            txn.writes[self.key] = NEEDS_INIT

    def read(self):
        txn = ctrl.txn
        key = self.key
        if not txn:
            r = ctrl.state[key]
            if r is NEEDS_INIT:
                with ctrl.new_txn() as txn:
                    r = self.read()
            return r

        assert txn.crule is not self, "compute rules cannot use their own value"

        r = self.get_curval()
        txn.used(self)

        if r is NEEDS_INIT:
            # initialize would not register self in has_run,
            # which is wrong for @compute rules
            # @@ this will not work properly until we fix initialization
            # we are rolling back into the middle of parent rule -- nonsense
            #@@@@
            txn.has_run[self] = txn.savepoint()
            #txn.has_run[self] = txn.has_run[txn.crule]
            with txn._replace_crule(self):
                r = self.rule()
                txn.change_key(txn.writes, self.key, r)
                if txn.rule_reads:
                    txn._process_reads()
                else:
                    txn.effect(self.become_constant)
            if not txn.crule.is_listener:
                #@@ handle the case when a first read is non-listener
                # but a second one is
                txn.effect(self.disconnect)
        return r

    #@effect_method
    def disconnect(self):
        if self.next_subject: # not a constant
            ctrl.txn.change_key(ctrl.txn.writes, self.key, NEEDS_INIT)
            #txn.set_key(txn.writes, self.key, NEEDS_INIT)
        if self.next_listener is None:
            super(ComputeRule, self).disconnect()


    def run_reset(self):
        txn = ctrl.txn
        oldval = txn.writes[self.key]
        with txn._replace_crule(self):
            newval = self.rule()
            txn._process_reads()
        if newval != oldval:
            raise InputConflict("%r can't change during reset (%r != %r)"
                % (self, newval, oldval)
            )
        #@@?
        #if not txn.rule_reads:
        #   txn.effect(self.become_constant)



    def _const_class(self):
        return ComputeConstant

    def __repr__(self):
        if ctrl.txn and self.key in ctrl.txn.writes:
            val = ctrl.txn.writes[self.key]
        else:
            val = ctrl.state[self.key] #@@ in-txn value
        if val is NEEDS_INIT:
            return "%s(%r [inactive])" % (self.__class__.__name__, self.rule)
        else:
            return "%s(%r, %s)" % (self.__class__.__name__, val, self.rule)


class ComputeConstant(ConstantRule, ComputeRule):
    __slots__ = ()





## class NewComputeRule(AbstractCell): # __init__, get_curval
##     """
##         @compute implementation.
##         Only listens to its subjects if has listeners itself.
##     """
##     __slots__ = 'key', 'rule', '__weakref__', 'disconnect_cell'
##
##     def __init__(self, rule, value=None):
##         assert value is None
##         self.key = CellKey(self)
##         self.rule = rule
##         #super(NewComputeRule, self).__init__()
##         with ctrl.need_txn() as txn:
##             txn.writes[self.key] = None
##
##     get_curval = RuleBase.get_curval.im_func
##
##     def read(self):
##         txn = ctrl.txn
##         key = self.key
##         if not txn:
##             cell = ctrl.state[key]
##             if cell is None:
##                 with ctrl.new_txn() as txn:
##                     cell = Rule(self.rule)
##                     r = cell.read()
##                     if isinstance(cell, ConstantMixin):
##                         self.rule = None
##                         txn.writes[key] = cell
##                     return r
##                     #return self.read()
##             return cell.read()
##
##         assert txn.crule is not self, "rules cannot use their own value"
##
##         cell = self.get_curval()
##         if cell is None:
##             cell = Rule(self.rule)
##             @MaintainRule
##             def disconnect_cell():
##                 if not cell.has_listeners:
##                     self.disconnect_cell = None
##                     if cell.next_subject: # not a constant
##                     #if not isinstance(cell, ConstantMixin):
##                         ctrl.txn.change_key(ctrl.txn.writes, key, None) #@@ set_key
##                     #else:
##                     #    effect(setattr, self, 'rule', None) #@@
##             self.disconnect_cell = disconnect_cell
##             txn.change_key(txn.writes, self.key, cell)
##             #if not txn.crule.is_listener:
##             #    txn.effect(disconnect_cell.rule)
##         return cell.read()
##
##     def run(self):
##         raise AssertionError
##
##
##     def _const_class(self):
##         return ComputeConstant
##
##     def __repr__(self):
##         if ctrl.txn and self.key in ctrl.txn.writes:
##             cell = ctrl.txn.writes[self.key]
##         else:
##             cell = ctrl.state[self.key]
##         if cell is None:
##             return "%s(%r [inactive])" % (self.__class__.__name__, self.rule)
##         #elif self.rule is None:
##         elif isinstance(cell, ConstantMixin):
##             return repr(cell)
##         else:
##             return "%s(%r, %s)" % (self.__class__.__name__, cell, self.rule)
##
##
