from __future__ import with_statement, absolute_import
from mext.reaction.stm import *

__all__ = ['PureListener', 'MaintainRule']


class PureListener(AbstractListener):
    """
        Baseclass for pure listeners.
        Pure listeners don't have values or listeners, only subjects.
        Pure listener rules run when any of its subjects change and must not return anything.
    """
    __slots__ = '__weakref__', 'rule', 'next_subject',

    def __init__(self, rule):
        super(PureListener, self).__init__()
        self.rule = rule
        #atomically(schedule, self)

    def __repr__(self):
        return '%s(%r)' % (type(self).__name__, self.rule)

    def run(self):
        r = self.rule()
        assert r is None, ("%s rules must not return anything. rule=%r; r=%r"
            % (type(self).__name__, self.rule, r)
        )
        if not ctrl.txn.rule_reads:
            # become const: drop rule and its references
            # shouldn't roll back, because there can be no
            # invalidating reads -- there were no reads
            #self.rule = None
            ctrl.txn.effect(setattr, self, 'rule', None)


    def _no_val(self, *args):
        raise TypeError("%s have no values (%r)" % (type(self).__name__, self))
    write = read = _no_val
    value = property(_no_val, _no_val)


class MaintainRule(PureListener):
    __slots__ = 'layer',
    readonly = False
    def __init__(self, rule):
        self.layer = 0
        super(MaintainRule, self).__init__(rule)
        with ctrl.need_txn() as txn:
            with txn._replace_crule(self):
                self.run()
                txn._process_writes()
                txn._process_reads()

    def run_reset(self):
        txn = ctrl.txn
        with txn._replace_crule(self):
            self.run()
            assert not txn.rule_writes
            #txn._process_writes()
            txn._process_reads()


