from __future__ import with_statement, absolute_import
from mext.reaction import *
from mext.reaction.eventloop import EventQueue
from mext.reaction.stm.controllers import DisabledTransaction

import signal
from Queue import Queue
from threading import Thread, Lock

__all__ = ['Signal']


class Signal(object):
    _lock = Lock()
    _queue = None
    def _start_signal_thread(self):
        with self._lock:
            if self._queue is not None:
                return
            self._queue = Queue()
            th = Thread(target=self._signal_thread, name=__name__, args=(EventQueue.get(),))
            th.setDaemon(True)
            th.start()

    def _signal_thread(self, equeue):
        while True:
            sig = self._queue.get()
            equeue.call(self._signals[sig].write, True)

    @active_cellcache(reset=False)
    def _signals(self, sig, conn):
        if conn:
            if self._queue is None:
                self._start_signal_thread()
            signal.signal(sig, self._handler)
        else:
            try:
                signal.signal(sig, signal.SIG_DFL)
            except TypeError:
                # errors happen when this is called during interpreter shutdown:
                #   Exception TypeError: TypeError('signal handler must be signal.SIG_IGN, signal.SIG_DFL, or a callable object',)
                #       in <unbound method Link.unlink> ignored
                pass

    def _handler(self, sig, fr):
        self._queue.put(sig)

    def __getitem__(self, sig):
        assert isinstance(sig, int)
        assert 0 < sig < signal.NSIG
        return self._signals[sig].read()

    def __getattr__(self, name):
        if not name.isupper():
            raise AttributeError
        return self[getattr(signal, 'SIG%s' % name)]

Signal = Signal()
