"""\
A set of words which should not be used as record keys in case they conflict 
with keywords in SQL, Python or JavaScript.
"""

#
# Reserved Words (Generated in such a way that words should be easy to update)
#

# http://www.python.org/doc/2.5.2/ref/keywords.html
_python_reserved_words = [x.strip('\n ') for x in """
    and       del       from      not       while    
    as        elif      global    or        with     
    assert    else      if        pass      yield    
    break     except    import    print              
    class     exec      in        raise              
    continue  finally   is        return             
    def       for       lambda    try
""".replace('\n', ' ').split(' ')]

# http://dev.mysql.com/doc/mysqld-version-reference/en/mysqld-version-reference-reservedwords-5-0.html
_mysql_reserved_words = [x.strip('\n []abcdefghi') for x in """
ADD 	ALL 	ALTER
ANALYZE 	AND 	AS
ASC 	ASENSITIVE 	BEFORE
BETWEEN 	BIGINT 	BINARY
BLOB 	BOTH 	BY
CALL 	CASCADE 	CASE
CHANGE 	CHAR 	CHARACTER
CHECK 	COLLATE 	COLUMN
COLUMNS[a] 	CONDITION 	CONNECTION[b]
CONSTRAINT 	CONTINUE 	CONVERT
CREATE 	CROSS 	CURRENT_DATE
CURRENT_TIME 	CURRENT_TIMESTAMP 	CURRENT_USER
CURSOR 	DATABASE 	DATABASES
DAY_HOUR 	DAY_MICROSECOND 	DAY_MINUTE
DAY_SECOND 	DEC 	DECIMAL
DECLARE 	DEFAULT 	DELAYED
DELETE 	DESC 	DESCRIBE
DETERMINISTIC 	DISTINCT 	DISTINCTROW
DIV 	DOUBLE 	DROP
DUAL 	EACH 	ELSE
ELSEIF 	ENCLOSED 	ESCAPED
EXISTS 	EXIT 	EXPLAIN
FALSE 	FETCH 	FIELDS[c]
FLOAT 	FLOAT4 	FLOAT8
FOR 	FORCE 	FOREIGN
FROM 	FULLTEXT 	GOTO[d]
GRANT 	GROUP 	HAVING
HIGH_PRIORITY 	HOUR_MICROSECOND 	HOUR_MINUTE
HOUR_SECOND 	IF 	IGNORE
IN 	INDEX 	INFILE
INNER 	INOUT 	INSENSITIVE
INSERT 	INT 	INT1
INT2 	INT3 	INT4
INT8 	INTEGER 	INTERVAL
INTO 	IS 	ITERATE
JOIN 	KEY 	KEYS
KILL 	LABEL[e] 	LEADING
LEAVE 	LEFT 	LIKE
LIMIT 	LINES 	LOAD
LOCALTIME 	LOCALTIMESTAMP 	LOCK
LONG 	LONGBLOB 	LONGTEXT
LOOP 	LOW_PRIORITY 	MATCH
MEDIUMBLOB 	MEDIUMINT 	MEDIUMTEXT
MIDDLEINT 	MINUTE_MICROSECOND 	MINUTE_SECOND
MOD 	MODIFIES 	NATURAL
NOT 	NO_WRITE_TO_BINLOG 	NULL
NUMERIC 	ON 	OPTIMIZE
OPTION 	OPTIONALLY 	OR
ORDER 	OUT 	OUTER
OUTFILE 	PRECISION 	PRIMARY
PRIVILEGES[f] 	PROCEDURE 	PURGE
READ 	READS 	REAL
REFERENCES 	REGEXP 	RELEASE[g]
RENAME 	REPEAT 	REPLACE
REQUIRE 	RESTRICT 	RETURN
REVOKE 	RIGHT 	RLIKE
SCHEMA 	SCHEMAS 	SECOND_MICROSECOND
SELECT 	SENSITIVE 	SEPARATOR
SET 	SHOW 	SMALLINT
SONAME 	SPATIAL 	SPECIFIC
SQL 	SQLEXCEPTION 	SQLSTATE
SQLWARNING 	SQL_BIG_RESULT 	SQL_CALC_FOUND_ROWS
SQL_SMALL_RESULT 	SSL 	STARTING
STRAIGHT_JOIN 	TABLE 	TABLES[h]
TERMINATED 	THEN 	TINYBLOB
TINYINT 	TINYTEXT 	TO
TRAILING 	TRIGGER 	TRUE
UNDO 	UNION 	UNIQUE
UNLOCK 	UNSIGNED 	UPDATE
UPGRADE[i] 	USAGE 	USE
USING 	UTC_DATE 	UTC_TIME
UTC_TIMESTAMP 	VALUES 	VARBINARY
VARCHAR 	VARCHARACTER 	VARYING
WHEN 	WHERE 	WHILE
WITH 	WRITE 	XOR
YEAR_MONTH 	ZEROFILL 	 
""".replace('\n', ' ').split(' ')]

# All keywords, reserved or not from PostgreSQL 8.3, SQL92, SQL99 and SQL2003
# http://www.postgresql.org/docs/8.3/static/sql-keywords-appendix.html
_postgresql_keywords = [x.strip() for x in """
A
ABORT	
ABS	
ABSOLUTE	
ACCESS	
ACTION	
ADA	
ADD	
ADMIN	
AFTER	
AGGREGATE	
ALIAS	
ALL	
ALLOCATE	
ALSO	
ALTER	
ALWAYS	
ANALYSE	
ANALYZE	
AND	
ANY	
ARE	
ARRAY	
AS	
ASC	
ASENSITIVE	
ASSERTION	
ASSIGNMENT	
ASYMMETRIC	
AT	
ATOMIC	
ATTRIBUTE	
ATTRIBUTES	
AUTHORIZATION	
AVG	
BACKWARD	
BASE64	
BEFORE	
BEGIN	
BERNOULLI	
BETWEEN	
BIGINT	                                
BINARY	
BIT	
BITVAR	
BIT_LENGTH	
BLOB	
BOOLEAN	
BOTH	
BREADTH	
BY	
C	
CACHE	
CALL	
CALLED	
CARDINALITY	
CASCADE	
CASCADED	
CASE	
CAST	
CATALOG	
CATALOG_NAME	
CEIL	
CEILING	
CHAIN	
CHAR	
CHARACTER	
CHARACTERISTICS	
CHARACTERS	
CHARACTER_LENGTH	
CHARACTER_SET_CATALOG	
CHARACTER_SET_NAME	
CHARACTER_SET_SCHEMA	
CHAR_LENGTH	
CHECK	
CHECKED	
CHECKPOINT	
CLASS	
CLASS_ORIGIN	
CLOB	
CLOSE	
CLUSTER	
COALESCE	
COBOL	
COLLATE	
COLLATION	
COLLATION_CATALOG	
COLLATION_NAME	
COLLATION_SCHEMA	
COLLECT	
COLUMN	
COLUMN_NAME	
COMMAND_FUNCTION	
COMMAND_FUNCTION_CODE	
COMMENT	
COMMIT	
COMMITTED	
COMPLETION	
CONCURRENTLY	
CONDITION	
CONDITION_NUMBER	
CONFIGURATION	
CONNECT	
CONNECTION	
CONNECTION_NAME	
CONSTRAINT	
CONSTRAINTS	
CONSTRAINT_CATALOG	
CONSTRAINT_NAME	
CONSTRAINT_SCHEMA	
CONSTRUCTOR	
CONTAINS	
CONTENT	
CONTINUE	
CONVERSION	
CONVERT	
COPY	
CORR	
CORRESPONDING	
COST	
COUNT	
COVAR_POP	
COVAR_SAMP	
CREATE	
CREATEDB	
CREATEROLE	
CREATEUSER	
CROSS	
CSV	
CUBE	
CUME_DIST	
CURRENT	
CURRENT_DATE	
CURRENT_DEFAULT_TRANSFORM_GROUP	
CURRENT_PATH	
CURRENT_ROLE	
CURRENT_TIME	
CURRENT_TIMESTAMP	
CURRENT_TRANSFORM_GROUP_FOR_TYPE	
CURRENT_USER	
CURSOR	
CURSOR_NAME	
CYCLE	
DATA	
DATABASE	
DATE	
DATETIME_INTERVAL_CODE	
DATETIME_INTERVAL_PRECISION	
DAY	
DEALLOCATE	
DEC	
DECIMAL	
DECLARE	
DEFAULT	
DEFAULTS	
DEFERRABLE	
DEFERRED	
DEFINED	
DEFINER	
DEGREE	
DELETE	
DELIMITER	
DELIMITERS	
DENSE_RANK	
DEPTH	
DEREF	
DERIVED	
DESC	
DESCRIBE	
DESCRIPTOR	
DESTROY	
DESTRUCTOR	
DETERMINISTIC	
DIAGNOSTICS	
DICTIONARY	
DISABLE	
DISCARD	
DISCONNECT	
DISPATCH	
DISTINCT	
DO	
DOCUMENT	
DOMAIN	
DOUBLE	
DROP	
DYNAMIC	
DYNAMIC_FUNCTION	
DYNAMIC_FUNCTION_CODE	
EACH	
ELEMENT	
ELSE	
ENABLE	
ENCODING	
ENCRYPTED	
END	
END-EXEC	
ENUM	
EQUALS	
ESCAPE	
EVERY	
EXCEPT	
EXCEPTION	
EXCLUDE	
EXCLUDING	
EXCLUSIVE	
EXEC	
EXECUTE	
EXISTING	
EXISTS	
EXP	
EXPLAIN	
EXTERNAL	
EXTRACT	
FALSE	
FAMILY	
FETCH	
FILTER	
FINAL	
FIRST	
FLOAT	
FLOOR	
FOLLOWING	
FOR	
FORCE	
FOREIGN	
FORTRAN	
FORWARD	
FOUND	
FREE	
FREEZE	
FROM	
FULL	
FUNCTION	
FUSION	
G	
GENERAL	
GENERATED	
GET	
GLOBAL	
GO	
GOTO	
GRANT	
GRANTED	
GREATEST	
GROUP	
GROUPING	
HANDLER	
HAVING	
HEADER	
HEX	
HIERARCHY	
HOLD	
HOST	
HOUR	
IDENTITY	
IF	
IGNORE	
ILIKE	
IMMEDIATE	
IMMUTABLE	
IMPLEMENTATION	
IMPLICIT	
IN	
INCLUDING	
INCREMENT	
INDEX	
INDEXES	
INDICATOR	
INFIX	
INHERIT	
INHERITS	
INITIALIZE	
INITIALLY	
INNER	
INOUT	
INPUT	
INSENSITIVE	
INSERT	
INSTANCE	
INSTANTIABLE	
INSTEAD	
INT	
INTEGER	
INTERSECT	
INTERSECTION	
INTERVAL	
INTO	
INVOKER	
IS	
ISNULL	
ISOLATION	
ITERATE	
JOIN	
K	
KEY	
KEY_MEMBER	
KEY_TYPE	
LANCOMPILER	
LANGUAGE	
LARGE	
LAST	
LATERAL	
LEADING	
LEAST	
LEFT	
LENGTH	
LESS	
LEVEL	
LIKE	
LIMIT	
LISTEN	
LN	
LOAD	
LOCAL	
LOCALTIME	
LOCALTIMESTAMP	
LOCATION	
LOCATOR	
LOCK	
LOGIN	
LOWER	
M	
MAP	
MAPPING	
MATCH	
MATCHED	
MAX	
MAXVALUE	
MEMBER	
MERGE	
MESSAGE_LENGTH	
MESSAGE_OCTET_LENGTH	
MESSAGE_TEXT	
METHOD	
MIN	
MINUTE	
MINVALUE	
MOD	
MODE	
MODIFIES	
MODIFY	
MODULE	
MONTH	
MORE	
MOVE	
MULTISET	
MUMPS	
NAME	
NAMES	
NATIONAL	
NATURAL	
NCHAR	
NCLOB	
NESTING	
NEW	
NEXT	
NO	
NOCREATEDB	
NOCREATEROLE	
NOCREATEUSER	
NOINHERIT	
NOLOGIN	
NONE	
NORMALIZE	
NORMALIZED	
NOSUPERUSER	
NOT	
NOTHING	
NOTIFY	
NOTNULL	
NOWAIT	
NULL	
NULLABLE	
NULLIF	
NULLS	
NUMBER	
NUMERIC	
OBJECT	
OCTETS	
OCTET_LENGTH	
OF	
OFF	
OFFSET	
OIDS	
OLD	
ON	
ONLY	
OPEN	
OPERATION	
OPERATOR	
OPTION	
OPTIONS	
OR	
ORDER	
ORDERING	
ORDINALITY	
OTHERS	
OUT	
OUTER	
OUTPUT	
OVER	
OVERLAPS	
OVERLAY	 
OVERRIDING	
OWNED	
OWNER	
PAD	
PARAMETER	
PARAMETERS	
PARAMETER_MODE	
PARAMETER_NAME	
PARAMETER_ORDINAL_POSITION	
PARAMETER_SPECIFIC_CATALOG	
PARAMETER_SPECIFIC_NAME	
PARAMETER_SPECIFIC_SCHEMA	
PARSER	
PARTIAL	
PARTITION	
PASCAL	
PASSWORD	
PATH	
PERCENTILE_CONT	
PERCENTILE_DISC	
PERCENT_RANK	
PLACING	
PLANS	
PLI	
POSITION	
POSTFIX	
POWER	
PRECEDING	
PRECISION	
PREFIX	
PREORDER	
PREPARE	
PREPARED	
PRESERVE	
PRIMARY	
PRIOR	
PRIVILEGES	
PROCEDURAL	
PROCEDURE	
PUBLIC	
QUOTE	
RANGE	
RANK	
READ	
READS	
REAL	
REASSIGN	
RECHECK	
RECURSIVE	
REF	
REFERENCES	
REFERENCING	
REGR_AVGX	
REGR_AVGY	
REGR_COUNT	
REGR_INTERCEPT	
REGR_R2	
REGR_SLOPE	
REGR_SXX	
REGR_SXY	
REGR_SYY	
REINDEX	
RELATIVE	
RELEASE	
RENAME	
REPEATABLE	
REPLACE	
REPLICA	
RESET	
RESTART	
RESTRICT	
RESULT	
RETURN	
RETURNED_CARDINALITY	
RETURNED_LENGTH	
RETURNED_OCTET_LENGTH	
RETURNED_SQLSTATE	
RETURNING	
RETURNS	
REVOKE	
RIGHT	
ROLE	
ROLLBACK	
ROLLUP	
ROUTINE	
ROUTINE_CATALOG	
ROUTINE_NAME	
ROUTINE_SCHEMA	
ROW	
ROWS	
ROW_COUNT	
ROW_NUMBER	
RULE	
SAVEPOINT	
SCALE	
SCHEMA	
SCHEMA_NAME	
SCOPE	
SCOPE_CATALOG	
SCOPE_NAME	
SCOPE_SCHEMA	
SCROLL	
SEARCH	
SECOND	
SECTION	
SECURITY	
SELECT	
SELF	
SENSITIVE	
SEQUENCE	
SERIALIZABLE	
SERVER_NAME	
SESSION	
SESSION_USER	
SET	
SETOF	
SETS	
SHARE	
SHOW	
SIMILAR	
SIMPLE	
SIZE	
SMALLINT	
SOME	
SOURCE	
SPACE	
SPECIFIC	
SPECIFICTYPE	
SPECIFIC_NAME	
SQL	
SQLCODE	
SQLERROR	
SQLEXCEPTION	
SQLSTATE	
SQLWARNING	
SQRT	
STABLE	
STANDALONE	
START	
STATE	
STATEMENT	
STATIC	
STATISTICS	
STDDEV_POP	
STDDEV_SAMP	
STDIN	
STDOUT	
STORAGE	
STRICT	
STRIP	
STRUCTURE	
STYLE	
SUBCLASS_ORIGIN	
SUBLIST	
SUBMULTISET	
SUBSTRING
SUM	
SUPERUSER	
SYMMETRIC	
SYSID	
SYSTEM	
SYSTEM_USER	
TABLE	
TABLESAMPLE	
TABLESPACE	
TABLE_NAME	
TEMP	
TEMPLATE	
TEMPORARY	
TERMINATE	
TEXT	
THAN	
THEN	
TIES	
TIME	
TIMESTAMP	
TIMEZONE_HOUR	
TIMEZONE_MINUTE	
TO	
TOP_LEVEL_COUNT	
TRAILING	
TRANSACTION	
TRANSACTIONS_COMMITTED	
TRANSACTIONS_ROLLED_BACK	
TRANSACTION_ACTIVE	
TRANSFORM	
TRANSFORMS	
TRANSLATE	
TRANSLATION	
TREAT	
TRIGGER	
TRIGGER_CATALOG	
TRIGGER_NAME	
TRIGGER_SCHEMA	
TRIM
TRUE	
TRUNCATE	
TRUSTED	
TYPE	
UESCAPE	
UNBOUNDED	
UNCOMMITTED	
UNDER	
UNENCRYPTED	
UNION	
UNIQUE	
UNKNOWN	
UNLISTEN	
UNNAMED	
UNNEST	
UNTIL	
UPDATE	
UPPER	
USAGE	
USER	
USER_DEFINED_TYPE_CATALOG	
USER_DEFINED_TYPE_CODE	
USER_DEFINED_TYPE_NAME	
USER_DEFINED_TYPE_SCHEMA	
USING	
VACUUM	
VALID	
VALIDATOR	
VALUE	
VALUES	
VARCHAR	
VARIABLE	
VARYING	
VAR_POP	
VAR_SAMP	
VERBOSE	
VERSION	
VIEW	
VOLATILE	
WHEN	
WHENEVER	
WHERE	
WHITESPACE	
WIDTH_BUCKET	
WINDOW	
WITH	
WITHIN	
WITHOUT	
WORK	
WRITE	
XML	
XMLAGG	
XMLATTRIBUTES	                                
XMLBINARY	
XMLCOMMENT	
XMLCONCAT	                                
XMLELEMENT	                                
XMLFOREST	                                
XMLNAMESPACES	
XMLPARSE	                                
XMLPI	                                
XMLROOT	                                
XMLSERIALIZE	                                
YEAR	
YES	
ZONE	
""".split('\n')]

# https://developer.mozilla.org/en/Core_JavaScript_1.5_Reference/Reserved_Words
javascript_reserved_words = """
break
case
catch
continue
default
delete
do
else
finally
for
function
if
in
instanceof
new
return
switch
this
throw
try
typeof
var
void
while
with 
abstract
boolean
byte
char
class
const
debugger
double
enum
export
extends
final
float
goto
implements
import
int
interface
long
native
package
private
protected
public
short
static
super
synchronized
throws
transient
volatile 
const
export
import
null
true
false 
""".split('\n')

case_insensitive_reserved_words = _python_reserved_words + _javascript_reserved_words
case_sensitive_reserved_words = _mysql_reserved_words + _postgresql_keywords
