from AccessControl.SecurityManagement import newSecurityManager
from Acquisition import aq_inner
from Acquisition import aq_parent
from Products.CMFCore.utils import getToolByName
from Products.Five import BrowserView
from persistent.list import PersistentList

class CompleteMemberView(BrowserView):
    def fields(self):
        fieldnames = ['fullname', 'email', 'portrait', 'location',
                      'language', 'biography']
        mem = aq_inner(self.context)
        plonetool = getToolByName(mem, 'plone_utils')
        if plonetool.isIDAutoGenerated(mem.getId()):
            fieldnames = ['id'] + fieldnames
        for fname in fieldnames:
            field = mem.getField(fname)
            if field is not None:
                yield field

    def login(self, mem):
        """login programmatically, for this and future requests"""
        mem_id = mem.getId()
        uf = getToolByName(mem, 'acl_users')
        user = uf.getUserById(mem_id)
        if user is not None:
            # log in for this request
            newSecurityManager(self.request, user)
        # XXX: super kludgey hard-coding of cookie auth plugin but i
        # can't find a generalized way to ensure we're logged in on
        # the following request, and this will work for the
        # overwhelming majority of Plone sites
        if 'credentials_cookie_auth' in uf:
            self.request.set('__ac_name', mem_id)
            uf['credentials_cookie_auth'].login()

    def __call__(self):
        form = getattr(self.request, 'form', dict())
        if form.get('form.submitted'):
            mem = aq_inner(self.context)
            uf = getToolByName(mem, 'acl_users')
            plugin = uf['RemOpenId']
            request = self.request
            errors = mem.validate(REQUEST=request, data=request.form)
            if errors:
                self.request.errors = errors
                return super(CompleteMemberView, self).__call__()
            # retrieve the OpenId URL from the cache
            openid_url = plugin._temp_member_map.pop(mem.getId(), None)
            # move out of portal_factory
            pf = aq_parent(mem)
            mem_id = form.get('id')
            mem = pf.doCreate(mem, mem_id)
            # update user data
            if form.has_key('portrait_file'):
                form['portrait'] = form.pop('portrait_file')
            mem.update(**form)
            mem._openid_urls = PersistentList([openid_url])
            plugin._url_username_map[openid_url] = mem_id
            self.login(mem)
            self.request.RESPONSE.redirect(mem.absolute_url())
        else:
            return super(CompleteMemberView, self).__call__()
