"""
    requires
    ~~~~

    Easily construct BDD-style assertions on the
    go, and also chain and call multiple methods
    on a single function::

        >>> from requires import requires
        >>> requires('a b c d').chain.split().index('a').value()
        0
        >>> requires([]).expect.length.to.be.equal(0)

    You can use the expect tests within test suites
    that use ``assert`` as a method for running the
    tests, ``nose`` and ``py.test`` are two good
    examples.
"""

from collections import defaultdict
_NATURAL_KEYWORDS = ("to","be","been","Is","that","And","have","having","With","at","of","same")

from requires.expect import expect as _expect
from requires.chain  import chain  as _chain

class requires(object):
    """
    Initializes an requires object that caches
    the instances like ``expect`` and ``chain``
    so you don't use as much memory when
    using them repetitively. Usage::

        >>> from requires import requires
        >>> requires(object)

    :param obj: The object to provide a
        wrapper around.
    """
    def __init__(self, obj):
        self.obj = obj
        self._expect = _expect(self.obj)
        self._chain  = _chain(self.obj)

    @property
    def chain(self):
        """
        Returns the cached ``chain`` object
        but clears the internal method stack
        before returning it. Usage::

            >>> requires(object).chain
        """
        self._chain.stack = []
        return self._chain

    @property
    def expect(self):
        """
        Returns the cached ``expect`` object
        and clears the internal flags before
        returning it. Usage is similar to the
        ``chain`` property::

            >>> requires(object).expect
        """
        self._expect.flags = defaultdict(bool)
        return self._expect

