class Assertion(object):
    def __init__(self, obj):
        self.subject = obj
        self.Not = False
        self.length = False

    def ok(self):
        subject = self.obj
        if not self.toggle(subject):
            message = "Object {0} is not truthy"
            if self.Not:
                message = "Object {0} is truthy"
            raise AssertionError(
                    message.format(repr(subject))
                    )

    def keys(self, *args):
        subject = self.obj
        args = frozenset(args)
        keys = frozenset(subject.keys())
        if not self.toggle(keys >= args):
            message = "Object {0} doesn't contain keys {1}"
            if self.Not:
                message = "Object {0} contains keys {1}"
            raise AssertionError(
                    message.format(repr(subject), repr(args))
                    )

    def lengthIs(self, f):
        subject = self.obj
        if not self.toggle(subject == f):
            message = "len({0}) != {1}"
            if self.Not:
                message = "len({0}) == {1}"
            raise AssertionError(
                    message.format(repr(self.subject), repr(f))
                            )

    def satisfy(self, func):
        res = func(self.obj)
        if not self.toggle(res):
            message = "{0}({1}) is not truthy."
            if self.Not:
                message = "{0}({1}) is truthy."
            raise AssertionError(
                    message.format(func.__name__, repr(self.subject))
                    )

    def throw(self, exception, *args, **kwargs):
        subject = self.obj
        try:
            subject(*args, **kwargs)
            message = "Object [{0}] didn't raise exception [{1}]"
            raise AssertionError(
                    message.format(repr(subject), repr(exception))
                    )
        except Exception as err:
            if not self.toggle(isinstance(err, exception)):
                message = "Object [{0}] raised unexpected exception [{1}]"
                if self.Not:
                    message = "Object[{0}] shouldn't raise exception of type [{1}]."
                raise AssertionError(
                        message.format(repr(subject), repr(exception))
                        )

    def toggle(self, value):
        if not self.Not:
            return value
        return not value

    def include(self, item):
        subject = self.obj
        switch = self.Not
        for x in item:
            res = x in subject
            if switch:
                res = not res
            if not res:
                message = "{0} not in object: [{1}]"
                if self.Not:
                    message = "{0} in object: [{1}]"
                raise AssertionError(message.format(repr(subject), repr(x)))

    def istype(self, name):
        subject = self.obj
        if not self.toggle(isinstance(subject, name)):
            message = "{0} is not of type {1}"
            if self.Not:
                message = "{0} is of type {1}"
            raise AssertionError(
                    message.format(repr(subject), repr(name))
                    )

    def method(self, name):
        subject = self.obj
        self.have(name)
        if not self.toggle(callable(getattr(subject,name))):
            message = "Object [{0}] does not have method {1}."
            if self.Not:
                message = "Object [{0}] has method {1}."
            raise AssertionError(
                    message.format(repr(subject), repr(name))
                    )

    @property
    def obj(self):
        if self.length:
            #self.length = False
            return len(self.subject)
        return self.subject

    def lt(self, value):
        subject = self.obj
        if not self.toggle(subject < value):
            raise AssertionError(
                    "Object [{0}] not < {1}"\
                            .format(repr(subject), repr(value))
                            )

    def gt(self, value):
        subject = self.obj
        if not self.toggle(subject > value):
            raise AssertionError(
                    "Object [{0}] not > {1}"\
                            .format(repr(subject), repr(value))
                    )

    def le(self, value):
        subject = self.obj
        if not self.toggle(subject <= value):
            raise AssertionError(
                    "Object [{0}] not <= {1}"\
                            .format(repr(subject), repr(value))
                    )

    def ge(self, value):
        subject = self.obj
        if not self.toggle(subject >= value):
            raise AssertionError(
                    "Object [{0}] not >= {1}"\
                            .format(repr(subject), repr(value))
                    )

    def within(self, start, end):
        subject = self.obj
        if not self.toggle(start < subject < end):
            raise AssertionError(
                    "Object [{0}] not within bounds {1},{2}"\
                            .format(repr(subject), repr(subject), repr(end))
                    )

    def attribute(self, attribute, value):
        self.have(attribute)
        subject = self.obj
        if not self.toggle(getattr(subject, attribute) == value):
            message = "{0}.{1} doesn't equal to value [{2}]"
            if self.Not:
                message = "{0}.{1} equals value [{2}]"
            raise AssertionError(
                    message.format(repr(subject), attribute, repr(value))
                    )

    def have(self, attribute):
        subject = self.obj
        if not self.toggle(hasattr(subject, attribute)):
            raise AssertionError(
                    "Object [{0}] doesn't have attribute [{1}]"\
                            .format(repr(subject), attribute)
                    )

    def equals(self, value):
        subject = self.obj
        if not self.toggle(subject == value):
            raise AssertionError(
                    "Object [{0}] doesn't equal value [{1}]"\
                            .format(repr(subject), repr(value))
                    )

