# Copyright (C) 2012 Bob Bowles <bobjohnbowles@gmail.com>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

# Work around mbcs bug in distutils. (for wininst)
# http://bugs.python.org/issue10945
import codecs
try:
    codecs.lookup('mbcs')
except LookupError:
    ascii = codecs.lookup('ascii')
    func = lambda name, enc=ascii: {True: enc}.get(name=='mbcs')
    codecs.register(func)

from distutils.core import setup
import os

# automate the list of i18n files

# locale root
targetLocaleRoot = ''
if os.name == 'nt': targetLocaleRoot = os.path.join('C:', 'Python32')
elif os.name == 'posix': targetLocaleRoot = os.path.join('/', 'usr', 'share')

# auto-generate the list of .mo files
languages = os.listdir('locale')
languageFiles = []
for language in languages:
    languageFiles.append((os.path.join(targetLocaleRoot,
                                       'locale',
                                       language,
                                       'LC_MESSAGES'),
                          [os.path.join('locale',
                                        language,
                                        'LC_MESSAGES',
                                        'Reversi.mo'),]))
dataFiles = languageFiles

# detect Ubuntu/Unity to decide what to do with the launcher
from subprocess import Popen, PIPE
if os.name == 'posix':
    pipe = Popen('ps aux | grep unity', shell=True, stdout=PIPE).stdout

    # now scan the output for some unity tell-tale
    if  'unity-panel-service' in str(pipe.read()):
        print('Yay! Unity detected!')
        dataFiles.append((os.path.join(targetLocaleRoot, 'applications'),
                          ['Reversi.desktop']))
    else:
        print('No Unity detected')
else:
     print('Not posix')

setup(
    name='Reversi',
    version='1.0',
    description='A version of the Reversi board game intended for casual play.',
    long_description=open('README.txt').read(),
    author='Bob Bowles',
    author_email='bobjohnbowles@gmail.com',
    url='http://pypi.python.org/pypi/Reversi/1.0',
    license='GNU General Public License v3 (GPLv3)', # TODO belt-n-braces??
    keywords=["Reversi", "Othello",],
    classifiers=[
        "Programming Language :: Python",
        "Programming Language :: Python :: 3",
        "Development Status :: 5 - Production/Stable",
        "Environment :: Other Environment",
        "Intended Audience :: Developers",
        "Intended Audience :: End Users/Desktop",
        "License :: OSI Approved :: GNU General Public License v3 (GPLv3)",
        "Operating System :: POSIX :: Linux", # so far only tested on Linux
        "Topic :: Games/Entertainment :: Board Games",
        "Topic :: Games/Entertainment :: Turn Based Strategy",
        ],
    package_dir={'': 'src'},
    packages=['Reversi',],
    requires=['numpy (>=1.6.1)', 'tkinter (>=8.5)'], # TODO needs Python >3.3
    package_data={'Reversi': ['graphics/BWSmiley-75x75.gif',
                              'graphics/WBSmiley-75x75.gif',
                              'graphics/star-75x75.gif',
                              'graphics/unplayed-75x75.gif',
                              ]},
    data_files=dataFiles,
)



