#!/usr/bin/env python
# -*- coding: utf-8 -*- 

#
# Generated Mon Feb 27 11:50:28 2012 by generateDS.py version 2.7b.
#

# To update this file:
# 1- sudo easy_install generateDS
# 2- generateDS.py -o ScriptChainXML.py --use-old-getter-setter xsd/Launcher.xsd
# 3- ???
# 4- profit

import sys
import getopt
import re as re_

etree_ = None
Verbose_import_ = False
(   XMLParser_import_none, XMLParser_import_lxml,
    XMLParser_import_elementtree
    ) = range(3)
XMLParser_import_library = None
try:
    # lxml
    from lxml import etree as etree_
    XMLParser_import_library = XMLParser_import_lxml
    if Verbose_import_:
        print("running with lxml.etree")
except ImportError:
    try:
        # cElementTree from Python 2.5+
        import xml.etree.cElementTree as etree_
        XMLParser_import_library = XMLParser_import_elementtree
        if Verbose_import_:
            print("running with cElementTree on Python 2.5+")
    except ImportError:
        try:
            # ElementTree from Python 2.5+
            import xml.etree.ElementTree as etree_
            XMLParser_import_library = XMLParser_import_elementtree
            if Verbose_import_:
                print("running with ElementTree on Python 2.5+")
        except ImportError:
            try:
                # normal cElementTree install
                import cElementTree as etree_
                XMLParser_import_library = XMLParser_import_elementtree
                if Verbose_import_:
                    print("running with cElementTree")
            except ImportError:
                try:
                    # normal ElementTree install
                    import elementtree.ElementTree as etree_
                    XMLParser_import_library = XMLParser_import_elementtree
                    if Verbose_import_:
                        print("running with ElementTree")
                except ImportError:
                    raise ImportError("Failed to import ElementTree from any known place")

def parsexml_(*args, **kwargs):
    if (XMLParser_import_library == XMLParser_import_lxml and
        'parser' not in kwargs):
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        kwargs['parser'] = etree_.ETCompatXMLParser()
    doc = etree_.parse(*args, **kwargs)
    return doc

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError, exp:

    class GeneratedsSuper(object):
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_validate_integer(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_integer_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of integers')
            return input_data
        def gds_format_float(self, input_data, input_name=''):
            return '%f' % input_data
        def gds_validate_float(self, input_data, node, input_name=''):
            return input_data
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_float_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of floats')
            return input_data
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_validate_double(self, input_data, node, input_name=''):
            return input_data
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_double_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of doubles')
            return input_data
        def gds_format_boolean(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean(self, input_data, node, input_name=''):
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0', ):
                    raise_parse_error(node, 'Requires sequence of booleans ("true", "1", "false", "0")')
            return input_data
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            return None


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'ascii'
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')

#
# Support/utility functions.
#

def showIndent(outfile, level):
    for idx in range(level):
        outfile.write('    ')

def quote_xml(inStr):
    if not inStr:
        return ''
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1

def quote_attrib(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1

def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1

def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text

def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


class GDSParseError(Exception):
    pass

def raise_parse_error(node, msg):
    if XMLParser_import_library == XMLParser_import_lxml:
        msg = '%s (element %s/line %d)' % (msg, node.tag, node.sourceline, )
    else:
        msg = '%s (element %s)' % (msg, node.tag, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip(): 
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace,name)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (self.name, self.value, self.name))
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s",\n' % \
                (self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container

def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#

class scriptChain(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, program=None):
        if program is None:
            self.program = []
        else:
            self.program = program
    def factory(*args_, **kwargs_):
        if scriptChain.subclass:
            return scriptChain.subclass(*args_, **kwargs_)
        else:
            return scriptChain(*args_, **kwargs_)
    factory = staticmethod(factory)
    def getProgram(self): return self.program
    def setProgram(self, program): self.program = program
    def addProgram(self, value): self.program.append(value)
    def insertProgram(self, index, value): self.program[index] = value
    def export(self, outfile, level, namespace_='', name_='scriptChain', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='scriptChain')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='scriptChain'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='scriptChain', fromsubclass_=False):
        for program_ in self.program:
            program_.export(outfile, level, namespace_, name_='program')
    def hasContent_(self):
        if (
            self.program
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='scriptChain'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('program=[\n')
        level += 1
        for program_ in self.program:
            showIndent(outfile, level)
            outfile.write('model_.programType(\n')
            program_.exportLiteral(outfile, level, name_='programType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'program':
            obj_ = programType.factory()
            obj_.build(child_)
            self.program.append(obj_)
# end class scriptChain


class programType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, main=None, option=None, cpu=None):
        self.main = main
        if option is None:
            self.option = []
        else:
            self.option = option
        self.cpu = cpu
    def factory(*args_, **kwargs_):
        if programType.subclass:
            return programType.subclass(*args_, **kwargs_)
        else:
            return programType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def getMain(self): return self.main
    def setMain(self, main): self.main = main
    def getOption(self): return self.option
    def setOption(self, option): self.option = option
    def addOption(self, value): self.option.append(value)
    def insertOption(self, index, value): self.option[index] = value
    def getCpu(self): return self.cpu
    def setCpu(self, cpu): self.cpu = cpu
    def export(self, outfile, level, namespace_='', name_='programType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='programType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='programType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='programType', fromsubclass_=False):
        if self.main is not None:
            self.main.export(outfile, level, namespace_, name_='main', )
        for option_ in self.option:
            option_.export(outfile, level, namespace_, name_='option')
        if self.cpu is not None:
            self.cpu.export(outfile, level, namespace_, name_='cpu')
    def hasContent_(self):
        if (
            self.main is not None or
            self.option or
            self.cpu is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='programType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.main is not None:
            showIndent(outfile, level)
            outfile.write('main=model_.mainType(\n')
            self.main.exportLiteral(outfile, level, name_='main')
            showIndent(outfile, level)
            outfile.write('),\n')
        showIndent(outfile, level)
        outfile.write('option=[\n')
        level += 1
        for option_ in self.option:
            showIndent(outfile, level)
            outfile.write('model_.optionType(\n')
            option_.exportLiteral(outfile, level, name_='optionType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.cpu is not None:
            showIndent(outfile, level)
            outfile.write('cpu=model_.cpuType(\n')
            self.cpu.exportLiteral(outfile, level, name_='cpu')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'main':
            obj_ = mainType.factory()
            obj_.build(child_)
            self.setMain(obj_)
        elif nodeName_ == 'option':
            obj_ = optionType.factory()
            obj_.build(child_)
            self.option.append(obj_)
        elif nodeName_ == 'cpu':
            obj_ = cpuType.factory()
            obj_.build(child_)
            self.setCpu(obj_)
# end class programType


class mainType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, name=None, baseCommand=None, order=None, canFail=None):
        self.name = name
        self.baseCommand = baseCommand
        self.order = order
        self.canFail = canFail
    def factory(*args_, **kwargs_):
        if mainType.subclass:
            return mainType.subclass(*args_, **kwargs_)
        else:
            return mainType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def getName(self): return self.name
    def setName(self, name): self.name = name
    def getBasecommand(self): return self.baseCommand
    def setBasecommand(self, baseCommand): self.baseCommand = baseCommand
    def getOrder(self): return self.order
    def setOrder(self, order): self.order = order
    def getCanfail(self): return self.canFail
    def setCanfail(self, canFail): self.canFail = canFail
    def export(self, outfile, level, namespace_='', name_='mainType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='mainType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='mainType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='mainType', fromsubclass_=False):
        if self.name is not None:
            showIndent(outfile, level)
            outfile.write('<%sname>%s</%sname>\n' % (namespace_, self.gds_format_string(quote_xml(self.name).encode(ExternalEncoding), input_name='name'), namespace_))
        if self.baseCommand is not None:
            showIndent(outfile, level)
            outfile.write('<%sbaseCommand>%s</%sbaseCommand>\n' % (namespace_, self.gds_format_string(quote_xml(self.baseCommand).encode(ExternalEncoding), input_name='baseCommand'), namespace_))
        if self.order is not None:
            showIndent(outfile, level)
            outfile.write('<%sorder>%s</%sorder>\n' % (namespace_, self.gds_format_integer(self.order, input_name='order'), namespace_))
        if self.canFail is not None:
            showIndent(outfile, level)
            outfile.write('<%scanFail>%s</%scanFail>\n' % (namespace_, self.gds_format_boolean(self.gds_str_lower(str(self.canFail)), input_name='canFail'), namespace_))
    def hasContent_(self):
        if (
            self.name is not None or
            self.baseCommand is not None or
            self.order is not None or
            self.canFail is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='mainType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.name is not None:
            showIndent(outfile, level)
            outfile.write('name=%s,\n' % quote_python(self.name).encode(ExternalEncoding))
        if self.baseCommand is not None:
            showIndent(outfile, level)
            outfile.write('baseCommand=%s,\n' % quote_python(self.baseCommand).encode(ExternalEncoding))
        if self.order is not None:
            showIndent(outfile, level)
            outfile.write('order=%d,\n' % self.order)
        if self.canFail is not None:
            showIndent(outfile, level)
            outfile.write('canFail=%s,\n' % self.canFail)
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'name':
            name_ = child_.text
            name_ = self.gds_validate_string(name_, node, 'name')
            self.name = name_
        elif nodeName_ == 'baseCommand':
            baseCommand_ = child_.text
            baseCommand_ = self.gds_validate_string(baseCommand_, node, 'baseCommand')
            self.baseCommand = baseCommand_
        elif nodeName_ == 'order':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'order')
            self.order = ival_
        elif nodeName_ == 'canFail':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'canFail')
            self.canFail = ival_
# end class mainType


class name(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self):
        pass
    def factory(*args_, **kwargs_):
        if name.subclass:
            return name.subclass(*args_, **kwargs_)
        else:
            return name(*args_, **kwargs_)
    factory = staticmethod(factory)
    def export(self, outfile, level, namespace_='', name_='name', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='name')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='name'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='name', fromsubclass_=False):
        pass
    def hasContent_(self):
        if (

            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='name'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class name


class baseCommand(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self):
        pass
    def factory(*args_, **kwargs_):
        if baseCommand.subclass:
            return baseCommand.subclass(*args_, **kwargs_)
        else:
            return baseCommand(*args_, **kwargs_)
    factory = staticmethod(factory)
    def export(self, outfile, level, namespace_='', name_='baseCommand', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='baseCommand')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='baseCommand'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='baseCommand', fromsubclass_=False):
        pass
    def hasContent_(self):
        if (

            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='baseCommand'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class baseCommand


class optionType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, alias=None, value=None, separator=' ', delimiter=None):
        self.alias = alias
        self.value = value
        self.separator = separator
        self.delimiter = delimiter
    def factory(*args_, **kwargs_):
        if optionType.subclass:
            return optionType.subclass(*args_, **kwargs_)
        else:
            return optionType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def getAlias(self): return self.alias
    def setAlias(self, alias): self.alias = alias
    def getValue(self): return self.value
    def setValue(self, value): self.value = value
    def getSeparator(self): return self.separator
    def setSeparator(self, separator): self.separator = separator
    def getDelimiter(self): return self.delimiter
    def setDelimiter(self, delimiter): self.delimiter = delimiter
    def export(self, outfile, level, namespace_='', name_='optionType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='optionType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='optionType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='optionType', fromsubclass_=False):
        if self.alias is not None:
            showIndent(outfile, level)
            outfile.write('<%salias>%s</%salias>\n' % (namespace_, self.gds_format_string(quote_xml(self.alias).encode(ExternalEncoding), input_name='alias'), namespace_))
        if self.value is not None:
            showIndent(outfile, level)
            outfile.write('<%svalue>%s</%svalue>\n' % (namespace_, self.gds_format_string(quote_xml(self.value).encode(ExternalEncoding), input_name='value'), namespace_))
        if self.separator is not None:
            showIndent(outfile, level)
            outfile.write('<%sseparator>%s</%sseparator>\n' % (namespace_, self.gds_format_string(quote_xml(self.separator).encode(ExternalEncoding), input_name='separator'), namespace_))
        if self.delimiter is not None:
            showIndent(outfile, level)
            outfile.write('<%sdelimiter>%s</%sdelimiter>\n' % (namespace_, self.gds_format_string(quote_xml(self.delimiter).encode(ExternalEncoding), input_name='delimiter'), namespace_))
    def hasContent_(self):
        if (
            self.alias is not None or
            self.value is not None or
            self.separator is not None or
            self.delimiter is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='optionType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.alias is not None:
            showIndent(outfile, level)
            outfile.write('alias=%s,\n' % quote_python(self.alias).encode(ExternalEncoding))
        if self.value is not None:
            showIndent(outfile, level)
            outfile.write('value=%s,\n' % quote_python(self.value).encode(ExternalEncoding))
        if self.separator is not None:
            showIndent(outfile, level)
            outfile.write('separator=%s,\n' % quote_python(self.separator).encode(ExternalEncoding))
        if self.delimiter is not None:
            showIndent(outfile, level)
            outfile.write('delimiter=%s,\n' % quote_python(self.delimiter).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'alias':
            alias_ = child_.text
            alias_ = self.gds_validate_string(alias_, node, 'alias')
            self.alias = alias_
        elif nodeName_ == 'value':
            value_ = child_.text
            value_ = self.gds_validate_string(value_, node, 'value')
            self.value = value_
        elif nodeName_ == 'separator':
            separator_ = child_.text
            separator_ = self.gds_validate_string(separator_, node, 'separator')
            self.separator = separator_
        elif nodeName_ == 'delimiter':
            delimiter_ = child_.text
            delimiter_ = self.gds_validate_string(delimiter_, node, 'delimiter')
            self.delimiter = delimiter_
# end class optionType


class separator(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self):
        pass
    def factory(*args_, **kwargs_):
        if separator.subclass:
            return separator.subclass(*args_, **kwargs_)
        else:
            return separator(*args_, **kwargs_)
    factory = staticmethod(factory)
    def export(self, outfile, level, namespace_='', name_='separator', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='separator')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='separator'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='separator', fromsubclass_=False):
        pass
    def hasContent_(self):
        if (

            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='separator'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class separator


class cpuType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, numCPU=None, kind='inside', cmdCPU=None, separator=' ', delimiter=None):
        self.numCPU = numCPU
        self.kind = kind
        self.cmdCPU = cmdCPU
        self.separator = separator
        self.delimiter = delimiter
    def factory(*args_, **kwargs_):
        if cpuType.subclass:
            return cpuType.subclass(*args_, **kwargs_)
        else:
            return cpuType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def getNumcpu(self): return self.numCPU
    def setNumcpu(self, numCPU): self.numCPU = numCPU
    def getKind(self): return self.kind
    def setKind(self, kind): self.kind = kind
    def getCmdcpu(self): return self.cmdCPU
    def setCmdcpu(self, cmdCPU): self.cmdCPU = cmdCPU
    def getSeparator(self): return self.separator
    def setSeparator(self, separator): self.separator = separator
    def getDelimiter(self): return self.delimiter
    def setDelimiter(self, delimiter): self.delimiter = delimiter
    def export(self, outfile, level, namespace_='', name_='cpuType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='cpuType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='cpuType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='cpuType', fromsubclass_=False):
        if self.numCPU is not None:
            showIndent(outfile, level)
            outfile.write('<%snumCPU>%s</%snumCPU>\n' % (namespace_, self.gds_format_integer(self.numCPU, input_name='numCPU'), namespace_))
        if self.kind is not None:
            showIndent(outfile, level)
            outfile.write('<%skind>%s</%skind>\n' % (namespace_, self.gds_format_string(quote_xml(self.kind).encode(ExternalEncoding), input_name='kind'), namespace_))
        if self.cmdCPU is not None:
            showIndent(outfile, level)
            outfile.write('<%scmdCPU>%s</%scmdCPU>\n' % (namespace_, self.gds_format_string(quote_xml(self.cmdCPU).encode(ExternalEncoding), input_name='cmdCPU'), namespace_))
        if self.separator is not None:
            showIndent(outfile, level)
            outfile.write('<%sseparator>%s</%sseparator>\n' % (namespace_, self.gds_format_string(quote_xml(self.separator).encode(ExternalEncoding), input_name='separator'), namespace_))
        if self.delimiter is not None:
            showIndent(outfile, level)
            outfile.write('<%sdelimiter>%s</%sdelimiter>\n' % (namespace_, self.gds_format_string(quote_xml(self.delimiter).encode(ExternalEncoding), input_name='delimiter'), namespace_))
    def hasContent_(self):
        if (
            self.numCPU is not None or
            self.kind is not None or
            self.cmdCPU is not None or
            self.separator is not None or
            self.delimiter is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='cpuType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.numCPU is not None:
            showIndent(outfile, level)
            outfile.write('numCPU=%d,\n' % self.numCPU)
        if self.kind is not None:
            showIndent(outfile, level)
            outfile.write('kind=%s,\n' % quote_python(self.kind).encode(ExternalEncoding))
        if self.cmdCPU is not None:
            showIndent(outfile, level)
            outfile.write('cmdCPU=%s,\n' % quote_python(self.cmdCPU).encode(ExternalEncoding))
        if self.separator is not None:
            showIndent(outfile, level)
            outfile.write('separator=%s,\n' % quote_python(self.separator).encode(ExternalEncoding))
        if self.delimiter is not None:
            showIndent(outfile, level)
            outfile.write('delimiter=%s,\n' % quote_python(self.delimiter).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'numCPU':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'numCPU')
            self.numCPU = ival_
        elif nodeName_ == 'kind':
            kind_ = child_.text
            kind_ = self.gds_validate_string(kind_, node, 'kind')
            self.kind = kind_
        elif nodeName_ == 'cmdCPU':
            cmdCPU_ = child_.text
            cmdCPU_ = self.gds_validate_string(cmdCPU_, node, 'cmdCPU')
            self.cmdCPU = cmdCPU_
        elif nodeName_ == 'separator':
            separator_ = child_.text
            separator_ = self.gds_validate_string(separator_, node, 'separator')
            self.separator = separator_
        elif nodeName_ == 'delimiter':
            delimiter_ = child_.text
            delimiter_ = self.gds_validate_string(delimiter_, node, 'delimiter')
            self.delimiter = delimiter_
# end class cpuType


class numCPU(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self):
        pass
    def factory(*args_, **kwargs_):
        if numCPU.subclass:
            return numCPU.subclass(*args_, **kwargs_)
        else:
            return numCPU(*args_, **kwargs_)
    factory = staticmethod(factory)
    def export(self, outfile, level, namespace_='', name_='numCPU', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='numCPU')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='numCPU'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='numCPU', fromsubclass_=False):
        pass
    def hasContent_(self):
        if (

            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='numCPU'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class numCPU


class kind(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self):
        pass
    def factory(*args_, **kwargs_):
        if kind.subclass:
            return kind.subclass(*args_, **kwargs_)
        else:
            return kind(*args_, **kwargs_)
    factory = staticmethod(factory)
    def export(self, outfile, level, namespace_='', name_='kind', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='kind')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='kind'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='kind', fromsubclass_=False):
        pass
    def hasContent_(self):
        if (

            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='kind'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class kind


USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""

def usage():
    print USAGE_TEXT
    sys.exit(1)


def get_root_tag(node):
    tag = Tag_pattern_.match(node.tag).groups()[-1]
    rootClass = globals().get(tag)
    return tag, rootClass


def parse(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'scriptChain'
        rootClass = scriptChain
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_=rootTag, 
        namespacedef_='')
    return rootObj


def parseString(inString):
    from StringIO import StringIO
    doc = parsexml_(StringIO(inString))
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'scriptChain'
        rootClass = scriptChain
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_="scriptChain",
        namespacedef_='')
    return rootObj


def parseLiteral(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'scriptChain'
        rootClass = scriptChain
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('#from ScriptChainXML import *\n\n')
    sys.stdout.write('import ScriptChainXML as model_\n\n')
    sys.stdout.write('rootObj = model_.rootTag(\n')
    rootObj.exportLiteral(sys.stdout, 0, name_=rootTag)
    sys.stdout.write(')\n')
    return rootObj


def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()


if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()


__all__ = [
    "baseCommand",
    "cpuType",
    "kind",
    "mainType",
    "name",
    "numCPU",
    "optionType",
    "programType",
    "scriptChain",
    "separator"
    ]
