#!/usr/bin/env python
# -*- coding: utf-8 -*-

#
# Generated Mon Dec 29 12:39:26 2014 by generateDS.py version 2.14a.
#
# Command line options:
#   ('-o', 'sesarwslib/sample/Sample.py')
#
# Command line arguments:
#   sesarwslib/sample/sample.xsd
#
# Command line:
#   /usr/local/bin/generateDS.py -o "sesarwslib/sample/Sample.py" sesarwslib/sample/sample.xsd
#
# Current working directory (os.getcwd()):
#   SESAR-Web-Services-Lib
#

import sys
import re as re_
import base64
import datetime as datetime_
import warnings as warnings_


Validate_simpletypes_ = True


etree_ = None
Verbose_import_ = False
(
    XMLParser_import_none, XMLParser_import_lxml,
    XMLParser_import_elementtree
) = range(3)
XMLParser_import_library = None
try:
    # lxml
    from lxml import etree as etree_
    XMLParser_import_library = XMLParser_import_lxml
    if Verbose_import_:
        print("running with lxml.etree")
except ImportError:
    try:
        # cElementTree from Python 2.5+
        import xml.etree.cElementTree as etree_
        XMLParser_import_library = XMLParser_import_elementtree
        if Verbose_import_:
            print("running with cElementTree on Python 2.5+")
    except ImportError:
        try:
            # ElementTree from Python 2.5+
            import xml.etree.ElementTree as etree_
            XMLParser_import_library = XMLParser_import_elementtree
            if Verbose_import_:
                print("running with ElementTree on Python 2.5+")
        except ImportError:
            try:
                # normal cElementTree install
                import cElementTree as etree_
                XMLParser_import_library = XMLParser_import_elementtree
                if Verbose_import_:
                    print("running with cElementTree")
            except ImportError:
                try:
                    # normal ElementTree install
                    import elementtree.ElementTree as etree_
                    XMLParser_import_library = XMLParser_import_elementtree
                    if Verbose_import_:
                        print("running with ElementTree")
                except ImportError:
                    raise ImportError(
                        "Failed to import ElementTree from any known place")


def parsexml_(*args, **kwargs):
    if (XMLParser_import_library == XMLParser_import_lxml and
            'parser' not in kwargs):
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        kwargs['parser'] = etree_.ETCompatXMLParser()
    doc = etree_.parse(*args, **kwargs)
    return doc

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError, exp:

    class GeneratedsSuper(object):
        tzoff_pattern = re_.compile(r'(\+|-)((0\d|1[0-3]):[0-5]\d|14:00)$')
        class _FixedOffsetTZ(datetime_.tzinfo):
            def __init__(self, offset, name):
                self.__offset = datetime_.timedelta(minutes=offset)
                self.__name = name
            def utcoffset(self, dt):
                return self.__offset
            def tzname(self, dt):
                return self.__name
            def dst(self, dt):
                return None
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node=None, input_name=''):
            if not input_data:
                return ''
            else:
                return input_data
        def gds_format_base64(self, input_data, input_name=''):
            return base64.b64encode(input_data)
        def gds_validate_base64(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_validate_integer(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_integer_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    int(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of integers')
            return values
        def gds_format_float(self, input_data, input_name=''):
            return ('%.15f' % input_data).rstrip('0')
        def gds_validate_float(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_float_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of floats')
            return values
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_validate_double(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_double_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of doubles')
            return values
        def gds_format_boolean(self, input_data, input_name=''):
            return ('%s' % input_data).lower()
        def gds_validate_boolean(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_boolean_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0', ):
                    raise_parse_error(
                        node,
                        'Requires sequence of booleans '
                        '("true", "1", "false", "0")')
            return values
        def gds_validate_datetime(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_datetime(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d.%s' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        @classmethod
        def gds_parse_datetime(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            time_parts = input_data.split('.')
            if len(time_parts) > 1:
                micro_seconds = int(float('0.' + time_parts[1]) * 1000000)
                input_data = '%s.%s' % (time_parts[0], micro_seconds, )
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt
        def gds_validate_date(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_date(self, input_data, input_name=''):
            _svalue = '%04d-%02d-%02d' % (
                input_data.year,
                input_data.month,
                input_data.day,
            )
            try:
                if input_data.tzinfo is not None:
                    tzoff = input_data.tzinfo.utcoffset(input_data)
                    if tzoff is not None:
                        total_seconds = tzoff.seconds + (86400 * tzoff.days)
                        if total_seconds == 0:
                            _svalue += 'Z'
                        else:
                            if total_seconds < 0:
                                _svalue += '-'
                                total_seconds *= -1
                            else:
                                _svalue += '+'
                            hours = total_seconds // 3600
                            minutes = (total_seconds - (hours * 3600)) // 60
                            _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            except AttributeError:
                pass
            return _svalue
        @classmethod
        def gds_parse_date(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            dt = datetime_.datetime.strptime(input_data, '%Y-%m-%d')
            dt = dt.replace(tzinfo=tz)
            return dt.date()
        def gds_validate_time(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_time(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%02d:%02d:%02d' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%02d:%02d:%02d.%s' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        def gds_validate_simple_patterns(self, patterns, target):
            # pat is a list of lists of strings/patterns.  We should:
            # - AND the outer elements
            # - OR the inner elements
            found1 = True
            for patterns1 in patterns:
                found2 = False
                for patterns2 in patterns1:
                    if re_.search(patterns2, target) is not None:
                        found2 = True
                        break
                if not found2:
                    found1 = False
                    break
            return found1
        @classmethod
        def gds_parse_time(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt.time()
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            return None
        @classmethod
        def gds_reverse_node_mapping(cls, mapping):
            return dict(((v, k) for k, v in mapping.iteritems()))


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'ascii'
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')

#
# Support/utility functions.
#


def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')


def quote_xml(inStr):
    if not inStr:
        return ''
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1


def quote_attrib(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1


def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1


def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text


def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


class GDSParseError(Exception):
    pass


def raise_parse_error(node, msg):
    if XMLParser_import_library == XMLParser_import_lxml:
        msg = '%s (element %s/line %d)' % (
            msg, node.tag, node.sourceline, )
    else:
        msg = '%s (element %s)' % (msg, node.tag, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    TypeBase64 = 8
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace, pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace, name, pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeBase64:
            outfile.write('<%s>%s</%s>' % (
                self.name, base64.b64encode(self.value), self.name))
    def to_etree(self, element):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                if len(element) > 0:
                    if element[-1].tail is None:
                        element[-1].tail = self.value
                    else:
                        element[-1].tail += self.value
                else:
                    if element.text is None:
                        element.text = self.value
                    else:
                        element.text += self.value
        elif self.category == MixedContainer.CategorySimple:
            subelement = etree_.SubElement(element, '%s' % self.name)
            subelement.text = self.to_etree_simple()
        else:    # category == MixedContainer.CategoryComplex
            self.value.to_etree(element)
    def to_etree_simple(self):
        if self.content_type == MixedContainer.TypeString:
            text = self.value
        elif (self.content_type == MixedContainer.TypeInteger or
                self.content_type == MixedContainer.TypeBoolean):
            text = '%d' % self.value
        elif (self.content_type == MixedContainer.TypeFloat or
                self.content_type == MixedContainer.TypeDecimal):
            text = '%f' % self.value
        elif self.content_type == MixedContainer.TypeDouble:
            text = '%g' % self.value
        elif self.content_type == MixedContainer.TypeBase64:
            text = '%s' % base64.b64encode(self.value)
        return text
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s",\n' % (
                    self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container


def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#


class sample(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, sample_type=None, igsn=None, user_code=None, name=None, sample_other_name=None, parent_igsn=None, parent_sample_type=None, parent_name=None, is_private=None, publish_date=None, material=None, classification=None, field_name=None, description=None, age_min=None, age_max=None, age_unit=None, geological_age=None, geological_unit=None, collection_method=None, collection_method_descr=None, size=None, size_unit=None, sample_comment=None, latitude=None, longitude=None, latitude_end=None, longitude_end=None, elevation=None, elevation_end=None, primary_location_type=None, primary_location_name=None, location_description=None, locality=None, locality_description=None, country=None, province=None, county=None, city=None, cruise_field_prgrm=None, platform_type=None, platform_name=None, platform_descr=None, collector=None, collector_detail=None, collection_date_precision=None, current_archive=None, current_archive_contact=None, original_archive=None, original_archive_contact=None, depth_min=None, depth_max=None, depth_scale=None, other_names=None):
        self.original_tagname_ = None
        self.sample_type = sample_type
        self.validate_sample_type(self.sample_type)
        self.igsn = igsn
        self.validate_igsn(self.igsn)
        self.user_code = user_code
        self.validate_user_code(self.user_code)
        self.name = name
        self.sample_other_name = sample_other_name
        self.parent_igsn = parent_igsn
        self.validate_parent_igsn(self.parent_igsn)
        self.parent_sample_type = parent_sample_type
        self.validate_parent_sample_type(self.parent_sample_type)
        self.parent_name = parent_name
        self.is_private = is_private
        self.publish_date = publish_date
        self.validate_publish_date(self.publish_date)
        self.material = material
        self.validate_material(self.material)
        self.classification = classification
        self.field_name = field_name
        self.description = description
        self.age_min = age_min
        self.age_max = age_max
        self.age_unit = age_unit
        self.geological_age = geological_age
        self.geological_unit = geological_unit
        self.collection_method = collection_method
        self.collection_method_descr = collection_method_descr
        self.size = size
        self.size_unit = size_unit
        self.sample_comment = sample_comment
        self.latitude = latitude
        self.longitude = longitude
        self.latitude_end = latitude_end
        self.longitude_end = longitude_end
        self.elevation = elevation
        self.elevation_end = elevation_end
        self.primary_location_type = primary_location_type
        self.primary_location_name = primary_location_name
        self.location_description = location_description
        self.locality = locality
        self.locality_description = locality_description
        self.country = country
        self.province = province
        self.county = county
        self.city = city
        self.cruise_field_prgrm = cruise_field_prgrm
        self.platform_type = platform_type
        self.platform_name = platform_name
        self.platform_descr = platform_descr
        self.collector = collector
        self.collector_detail = collector_detail
        self.collection_date_precision = collection_date_precision
        self.current_archive = current_archive
        self.current_archive_contact = current_archive_contact
        self.original_archive = original_archive
        self.original_archive_contact = original_archive_contact
        self.depth_min = depth_min
        self.depth_max = depth_max
        self.depth_scale = depth_scale
        if other_names is None:
            self.other_names = []
        else:
            self.other_names = other_names
    def factory(*args_, **kwargs_):
        if sample.subclass:
            return sample.subclass(*args_, **kwargs_)
        else:
            return sample(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_sample_type(self): return self.sample_type
    def set_sample_type(self, sample_type): self.sample_type = sample_type
    def get_igsn(self): return self.igsn
    def set_igsn(self, igsn): self.igsn = igsn
    def get_user_code(self): return self.user_code
    def set_user_code(self, user_code): self.user_code = user_code
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_sample_other_name(self): return self.sample_other_name
    def set_sample_other_name(self, sample_other_name): self.sample_other_name = sample_other_name
    def get_parent_igsn(self): return self.parent_igsn
    def set_parent_igsn(self, parent_igsn): self.parent_igsn = parent_igsn
    def get_parent_sample_type(self): return self.parent_sample_type
    def set_parent_sample_type(self, parent_sample_type): self.parent_sample_type = parent_sample_type
    def get_parent_name(self): return self.parent_name
    def set_parent_name(self, parent_name): self.parent_name = parent_name
    def get_is_private(self): return self.is_private
    def set_is_private(self, is_private): self.is_private = is_private
    def get_publish_date(self): return self.publish_date
    def set_publish_date(self, publish_date): self.publish_date = publish_date
    def get_material(self): return self.material
    def set_material(self, material): self.material = material
    def get_classification(self): return self.classification
    def set_classification(self, classification): self.classification = classification
    def get_field_name(self): return self.field_name
    def set_field_name(self, field_name): self.field_name = field_name
    def get_description(self): return self.description
    def set_description(self, description): self.description = description
    def get_age_min(self): return self.age_min
    def set_age_min(self, age_min): self.age_min = age_min
    def get_age_max(self): return self.age_max
    def set_age_max(self, age_max): self.age_max = age_max
    def get_age_unit(self): return self.age_unit
    def set_age_unit(self, age_unit): self.age_unit = age_unit
    def get_geological_age(self): return self.geological_age
    def set_geological_age(self, geological_age): self.geological_age = geological_age
    def get_geological_unit(self): return self.geological_unit
    def set_geological_unit(self, geological_unit): self.geological_unit = geological_unit
    def get_collection_method(self): return self.collection_method
    def set_collection_method(self, collection_method): self.collection_method = collection_method
    def get_collection_method_descr(self): return self.collection_method_descr
    def set_collection_method_descr(self, collection_method_descr): self.collection_method_descr = collection_method_descr
    def get_size(self): return self.size
    def set_size(self, size): self.size = size
    def get_size_unit(self): return self.size_unit
    def set_size_unit(self, size_unit): self.size_unit = size_unit
    def get_sample_comment(self): return self.sample_comment
    def set_sample_comment(self, sample_comment): self.sample_comment = sample_comment
    def get_latitude(self): return self.latitude
    def set_latitude(self, latitude): self.latitude = latitude
    def get_longitude(self): return self.longitude
    def set_longitude(self, longitude): self.longitude = longitude
    def get_latitude_end(self): return self.latitude_end
    def set_latitude_end(self, latitude_end): self.latitude_end = latitude_end
    def get_longitude_end(self): return self.longitude_end
    def set_longitude_end(self, longitude_end): self.longitude_end = longitude_end
    def get_elevation(self): return self.elevation
    def set_elevation(self, elevation): self.elevation = elevation
    def get_elevation_end(self): return self.elevation_end
    def set_elevation_end(self, elevation_end): self.elevation_end = elevation_end
    def get_primary_location_type(self): return self.primary_location_type
    def set_primary_location_type(self, primary_location_type): self.primary_location_type = primary_location_type
    def get_primary_location_name(self): return self.primary_location_name
    def set_primary_location_name(self, primary_location_name): self.primary_location_name = primary_location_name
    def get_location_description(self): return self.location_description
    def set_location_description(self, location_description): self.location_description = location_description
    def get_locality(self): return self.locality
    def set_locality(self, locality): self.locality = locality
    def get_locality_description(self): return self.locality_description
    def set_locality_description(self, locality_description): self.locality_description = locality_description
    def get_country(self): return self.country
    def set_country(self, country): self.country = country
    def get_province(self): return self.province
    def set_province(self, province): self.province = province
    def get_county(self): return self.county
    def set_county(self, county): self.county = county
    def get_city(self): return self.city
    def set_city(self, city): self.city = city
    def get_cruise_field_prgrm(self): return self.cruise_field_prgrm
    def set_cruise_field_prgrm(self, cruise_field_prgrm): self.cruise_field_prgrm = cruise_field_prgrm
    def get_platform_type(self): return self.platform_type
    def set_platform_type(self, platform_type): self.platform_type = platform_type
    def get_platform_name(self): return self.platform_name
    def set_platform_name(self, platform_name): self.platform_name = platform_name
    def get_platform_descr(self): return self.platform_descr
    def set_platform_descr(self, platform_descr): self.platform_descr = platform_descr
    def get_collector(self): return self.collector
    def set_collector(self, collector): self.collector = collector
    def get_collector_detail(self): return self.collector_detail
    def set_collector_detail(self, collector_detail): self.collector_detail = collector_detail
    def get_collection_date_precision(self): return self.collection_date_precision
    def set_collection_date_precision(self, collection_date_precision): self.collection_date_precision = collection_date_precision
    def get_current_archive(self): return self.current_archive
    def set_current_archive(self, current_archive): self.current_archive = current_archive
    def get_current_archive_contact(self): return self.current_archive_contact
    def set_current_archive_contact(self, current_archive_contact): self.current_archive_contact = current_archive_contact
    def get_original_archive(self): return self.original_archive
    def set_original_archive(self, original_archive): self.original_archive = original_archive
    def get_original_archive_contact(self): return self.original_archive_contact
    def set_original_archive_contact(self, original_archive_contact): self.original_archive_contact = original_archive_contact
    def get_depth_min(self): return self.depth_min
    def set_depth_min(self, depth_min): self.depth_min = depth_min
    def get_depth_max(self): return self.depth_max
    def set_depth_max(self, depth_max): self.depth_max = depth_max
    def get_depth_scale(self): return self.depth_scale
    def set_depth_scale(self, depth_scale): self.depth_scale = depth_scale
    def get_other_names(self): return self.other_names
    def set_other_names(self, other_names): self.other_names = other_names
    def add_other_names(self, value): self.other_names.append(value)
    def insert_other_names_at(self, index, value): self.other_names.insert(index, value)
    def replace_other_names_at(self, index, value): self.other_names[index] = value
    def validate_sample_type(self, value):
        # Validate type sample_type, a restriction on xs:string.
        pass
    def validate_igsn(self, value):
        # Validate type igsn, a restriction on xs:string.
        pass
    def validate_user_code(self, value):
        # Validate type user_code, a restriction on xs:string.
        pass
    def validate_parent_igsn(self, value):
        # Validate type parent_igsn, a restriction on xs:string.
        pass
    def validate_parent_sample_type(self, value):
        # Validate type parent_sample_type, a restriction on xs:string.
        pass
    def validate_publish_date(self, value):
        # Validate type publish_date, a restriction on xs:string.
        pass
    def validate_material(self, value):
        # Validate type material, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            self.sample_type is not None or
            self.igsn is not None or
            self.user_code is not None or
            self.name is not None or
            self.sample_other_name is not None or
            self.parent_igsn is not None or
            self.parent_sample_type is not None or
            self.parent_name is not None or
            self.is_private is not None or
            self.publish_date is not None or
            self.material is not None or
            self.classification is not None or
            self.field_name is not None or
            self.description is not None or
            self.age_min is not None or
            self.age_max is not None or
            self.age_unit is not None or
            self.geological_age is not None or
            self.geological_unit is not None or
            self.collection_method is not None or
            self.collection_method_descr is not None or
            self.size is not None or
            self.size_unit is not None or
            self.sample_comment is not None or
            self.latitude is not None or
            self.longitude is not None or
            self.latitude_end is not None or
            self.longitude_end is not None or
            self.elevation is not None or
            self.elevation_end is not None or
            self.primary_location_type is not None or
            self.primary_location_name is not None or
            self.location_description is not None or
            self.locality is not None or
            self.locality_description is not None or
            self.country is not None or
            self.province is not None or
            self.county is not None or
            self.city is not None or
            self.cruise_field_prgrm is not None or
            self.platform_type is not None or
            self.platform_name is not None or
            self.platform_descr is not None or
            self.collector is not None or
            self.collector_detail is not None or
            self.collection_date_precision is not None or
            self.current_archive is not None or
            self.current_archive_contact is not None or
            self.original_archive is not None or
            self.original_archive_contact is not None or
            self.depth_min is not None or
            self.depth_max is not None or
            self.depth_scale is not None or
            self.other_names
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='sample', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='sample')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='sample', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='sample'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='sample', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.sample_type is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssample_type>%s</%ssample_type>%s' % (namespace_, self.gds_format_string(quote_xml(self.sample_type).encode(ExternalEncoding), input_name='sample_type'), namespace_, eol_))
        if self.igsn is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sigsn>%s</%sigsn>%s' % (namespace_, self.gds_format_string(quote_xml(self.igsn).encode(ExternalEncoding), input_name='igsn'), namespace_, eol_))
        if self.user_code is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suser_code>%s</%suser_code>%s' % (namespace_, self.gds_format_string(quote_xml(self.user_code).encode(ExternalEncoding), input_name='user_code'), namespace_, eol_))
        if self.name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespace_, self.gds_format_string(quote_xml(self.name).encode(ExternalEncoding), input_name='name'), namespace_, eol_))
        if self.sample_other_name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssample_other_name>%s</%ssample_other_name>%s' % (namespace_, self.gds_format_string(quote_xml(self.sample_other_name).encode(ExternalEncoding), input_name='sample_other_name'), namespace_, eol_))
        if self.parent_igsn is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sparent_igsn>%s</%sparent_igsn>%s' % (namespace_, self.gds_format_string(quote_xml(self.parent_igsn).encode(ExternalEncoding), input_name='parent_igsn'), namespace_, eol_))
        if self.parent_sample_type is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sparent_sample_type>%s</%sparent_sample_type>%s' % (namespace_, self.gds_format_string(quote_xml(self.parent_sample_type).encode(ExternalEncoding), input_name='parent_sample_type'), namespace_, eol_))
        if self.parent_name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sparent_name>%s</%sparent_name>%s' % (namespace_, self.gds_format_string(quote_xml(self.parent_name).encode(ExternalEncoding), input_name='parent_name'), namespace_, eol_))
        if self.is_private is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sis_private>%s</%sis_private>%s' % (namespace_, self.gds_format_integer(self.is_private, input_name='is_private'), namespace_, eol_))
        if self.publish_date is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spublish_date>%s</%spublish_date>%s' % (namespace_, self.gds_format_string(quote_xml(self.publish_date).encode(ExternalEncoding), input_name='publish_date'), namespace_, eol_))
        if self.material is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smaterial>%s</%smaterial>%s' % (namespace_, self.gds_format_string(quote_xml(self.material).encode(ExternalEncoding), input_name='material'), namespace_, eol_))
        if self.classification is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sclassification>%s</%sclassification>%s' % (namespace_, self.gds_format_string(quote_xml(self.classification).encode(ExternalEncoding), input_name='classification'), namespace_, eol_))
        if self.field_name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfield_name>%s</%sfield_name>%s' % (namespace_, self.gds_format_string(quote_xml(self.field_name).encode(ExternalEncoding), input_name='field_name'), namespace_, eol_))
        if self.description is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdescription>%s</%sdescription>%s' % (namespace_, self.gds_format_string(quote_xml(self.description).encode(ExternalEncoding), input_name='description'), namespace_, eol_))
        if self.age_min is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sage_min>%s</%sage_min>%s' % (namespace_, self.gds_format_float(self.age_min, input_name='age_min'), namespace_, eol_))
        if self.age_max is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sage_max>%s</%sage_max>%s' % (namespace_, self.gds_format_float(self.age_max, input_name='age_max'), namespace_, eol_))
        if self.age_unit is not None:
            self.age_unit.export(outfile, level, namespace_, name_='age_unit', pretty_print=pretty_print)
        if self.geological_age is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sgeological_age>%s</%sgeological_age>%s' % (namespace_, self.gds_format_float(self.geological_age, input_name='geological_age'), namespace_, eol_))
        if self.geological_unit is not None:
            self.geological_unit.export(outfile, level, namespace_, name_='geological_unit', pretty_print=pretty_print)
        if self.collection_method is not None:
            self.collection_method.export(outfile, level, namespace_, name_='collection_method', pretty_print=pretty_print)
        if self.collection_method_descr is not None:
            self.collection_method_descr.export(outfile, level, namespace_, name_='collection_method_descr', pretty_print=pretty_print)
        if self.size is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssize>%s</%ssize>%s' % (namespace_, self.gds_format_float(self.size, input_name='size'), namespace_, eol_))
        if self.size_unit is not None:
            self.size_unit.export(outfile, level, namespace_, name_='size_unit', pretty_print=pretty_print)
        if self.sample_comment is not None:
            self.sample_comment.export(outfile, level, namespace_, name_='sample_comment', pretty_print=pretty_print)
        if self.latitude is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slatitude>%s</%slatitude>%s' % (namespace_, self.gds_format_float(self.latitude, input_name='latitude'), namespace_, eol_))
        if self.longitude is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slongitude>%s</%slongitude>%s' % (namespace_, self.gds_format_float(self.longitude, input_name='longitude'), namespace_, eol_))
        if self.latitude_end is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slatitude_end>%s</%slatitude_end>%s' % (namespace_, self.gds_format_float(self.latitude_end, input_name='latitude_end'), namespace_, eol_))
        if self.longitude_end is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slongitude_end>%s</%slongitude_end>%s' % (namespace_, self.gds_format_float(self.longitude_end, input_name='longitude_end'), namespace_, eol_))
        if self.elevation is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%selevation>%s</%selevation>%s' % (namespace_, self.gds_format_float(self.elevation, input_name='elevation'), namespace_, eol_))
        if self.elevation_end is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%selevation_end>%s</%selevation_end>%s' % (namespace_, self.gds_format_float(self.elevation_end, input_name='elevation_end'), namespace_, eol_))
        if self.primary_location_type is not None:
            self.primary_location_type.export(outfile, level, namespace_, name_='primary_location_type', pretty_print=pretty_print)
        if self.primary_location_name is not None:
            self.primary_location_name.export(outfile, level, namespace_, name_='primary_location_name', pretty_print=pretty_print)
        if self.location_description is not None:
            self.location_description.export(outfile, level, namespace_, name_='location_description', pretty_print=pretty_print)
        if self.locality is not None:
            self.locality.export(outfile, level, namespace_, name_='locality', pretty_print=pretty_print)
        if self.locality_description is not None:
            self.locality_description.export(outfile, level, namespace_, name_='locality_description', pretty_print=pretty_print)
        if self.country is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scountry>%s</%scountry>%s' % (namespace_, self.gds_format_string(quote_xml(self.country).encode(ExternalEncoding), input_name='country'), namespace_, eol_))
        if self.province is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sprovince>%s</%sprovince>%s' % (namespace_, self.gds_format_string(quote_xml(self.province).encode(ExternalEncoding), input_name='province'), namespace_, eol_))
        if self.county is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scounty>%s</%scounty>%s' % (namespace_, self.gds_format_string(quote_xml(self.county).encode(ExternalEncoding), input_name='county'), namespace_, eol_))
        if self.city is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scity>%s</%scity>%s' % (namespace_, self.gds_format_string(quote_xml(self.city).encode(ExternalEncoding), input_name='city'), namespace_, eol_))
        if self.cruise_field_prgrm is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scruise_field_prgrm>%s</%scruise_field_prgrm>%s' % (namespace_, self.gds_format_string(quote_xml(self.cruise_field_prgrm).encode(ExternalEncoding), input_name='cruise_field_prgrm'), namespace_, eol_))
        if self.platform_type is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%splatform_type>%s</%splatform_type>%s' % (namespace_, self.gds_format_string(quote_xml(self.platform_type).encode(ExternalEncoding), input_name='platform_type'), namespace_, eol_))
        if self.platform_name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%splatform_name>%s</%splatform_name>%s' % (namespace_, self.gds_format_string(quote_xml(self.platform_name).encode(ExternalEncoding), input_name='platform_name'), namespace_, eol_))
        if self.platform_descr is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%splatform_descr>%s</%splatform_descr>%s' % (namespace_, self.gds_format_string(quote_xml(self.platform_descr).encode(ExternalEncoding), input_name='platform_descr'), namespace_, eol_))
        if self.collector is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scollector>%s</%scollector>%s' % (namespace_, self.gds_format_string(quote_xml(self.collector).encode(ExternalEncoding), input_name='collector'), namespace_, eol_))
        if self.collector_detail is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scollector_detail>%s</%scollector_detail>%s' % (namespace_, self.gds_format_string(quote_xml(self.collector_detail).encode(ExternalEncoding), input_name='collector_detail'), namespace_, eol_))
        if self.collection_date_precision is not None:
            self.collection_date_precision.export(outfile, level, namespace_, name_='collection_date_precision', pretty_print=pretty_print)
        if self.current_archive is not None:
            self.current_archive.export(outfile, level, namespace_, name_='current_archive', pretty_print=pretty_print)
        if self.current_archive_contact is not None:
            self.current_archive_contact.export(outfile, level, namespace_, name_='current_archive_contact', pretty_print=pretty_print)
        if self.original_archive is not None:
            self.original_archive.export(outfile, level, namespace_, name_='original_archive', pretty_print=pretty_print)
        if self.original_archive_contact is not None:
            self.original_archive_contact.export(outfile, level, namespace_, name_='original_archive_contact', pretty_print=pretty_print)
        if self.depth_min is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdepth_min>%s</%sdepth_min>%s' % (namespace_, self.gds_format_float(self.depth_min, input_name='depth_min'), namespace_, eol_))
        if self.depth_max is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdepth_max>%s</%sdepth_max>%s' % (namespace_, self.gds_format_float(self.depth_max, input_name='depth_max'), namespace_, eol_))
        if self.depth_scale is not None:
            self.depth_scale.export(outfile, level, namespace_, name_='depth_scale', pretty_print=pretty_print)
        for other_names_ in self.other_names:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sother_names>%s</%sother_names>%s' % (namespace_, self.gds_format_string(quote_xml(other_names_).encode(ExternalEncoding), input_name='other_names'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='sample'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.sample_type is not None:
            showIndent(outfile, level)
            outfile.write('sample_type=%s,\n' % quote_python(self.sample_type).encode(ExternalEncoding))
        if self.igsn is not None:
            showIndent(outfile, level)
            outfile.write('igsn=%s,\n' % quote_python(self.igsn).encode(ExternalEncoding))
        if self.user_code is not None:
            showIndent(outfile, level)
            outfile.write('user_code=%s,\n' % quote_python(self.user_code).encode(ExternalEncoding))
        if self.name is not None:
            showIndent(outfile, level)
            outfile.write('name=%s,\n' % quote_python(self.name).encode(ExternalEncoding))
        if self.sample_other_name is not None:
            showIndent(outfile, level)
            outfile.write('sample_other_name=%s,\n' % quote_python(self.sample_other_name).encode(ExternalEncoding))
        if self.parent_igsn is not None:
            showIndent(outfile, level)
            outfile.write('parent_igsn=%s,\n' % quote_python(self.parent_igsn).encode(ExternalEncoding))
        if self.parent_sample_type is not None:
            showIndent(outfile, level)
            outfile.write('parent_sample_type=%s,\n' % quote_python(self.parent_sample_type).encode(ExternalEncoding))
        if self.parent_name is not None:
            showIndent(outfile, level)
            outfile.write('parent_name=%s,\n' % quote_python(self.parent_name).encode(ExternalEncoding))
        if self.is_private is not None:
            showIndent(outfile, level)
            outfile.write('is_private=%d,\n' % self.is_private)
        if self.publish_date is not None:
            showIndent(outfile, level)
            outfile.write('publish_date=%s,\n' % quote_python(self.publish_date).encode(ExternalEncoding))
        if self.material is not None:
            showIndent(outfile, level)
            outfile.write('material=%s,\n' % quote_python(self.material).encode(ExternalEncoding))
        if self.classification is not None:
            showIndent(outfile, level)
            outfile.write('classification=%s,\n' % quote_python(self.classification).encode(ExternalEncoding))
        if self.field_name is not None:
            showIndent(outfile, level)
            outfile.write('field_name=%s,\n' % quote_python(self.field_name).encode(ExternalEncoding))
        if self.description is not None:
            showIndent(outfile, level)
            outfile.write('description=%s,\n' % quote_python(self.description).encode(ExternalEncoding))
        if self.age_min is not None:
            showIndent(outfile, level)
            outfile.write('age_min=%f,\n' % self.age_min)
        if self.age_max is not None:
            showIndent(outfile, level)
            outfile.write('age_max=%f,\n' % self.age_max)
        if self.age_unit is not None:
            showIndent(outfile, level)
            outfile.write('age_unit=model_.age_unit(\n')
            self.age_unit.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.geological_age is not None:
            showIndent(outfile, level)
            outfile.write('geological_age=%f,\n' % self.geological_age)
        if self.geological_unit is not None:
            showIndent(outfile, level)
            outfile.write('geological_unit=model_.geological_unit(\n')
            self.geological_unit.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.collection_method is not None:
            showIndent(outfile, level)
            outfile.write('collection_method=model_.collection_method(\n')
            self.collection_method.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.collection_method_descr is not None:
            showIndent(outfile, level)
            outfile.write('collection_method_descr=model_.collection_method_descr(\n')
            self.collection_method_descr.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.size is not None:
            showIndent(outfile, level)
            outfile.write('size=%f,\n' % self.size)
        if self.size_unit is not None:
            showIndent(outfile, level)
            outfile.write('size_unit=model_.size_unit(\n')
            self.size_unit.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.sample_comment is not None:
            showIndent(outfile, level)
            outfile.write('sample_comment=model_.sample_comment(\n')
            self.sample_comment.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.latitude is not None:
            showIndent(outfile, level)
            outfile.write('latitude=%f,\n' % self.latitude)
        if self.longitude is not None:
            showIndent(outfile, level)
            outfile.write('longitude=%f,\n' % self.longitude)
        if self.latitude_end is not None:
            showIndent(outfile, level)
            outfile.write('latitude_end=%f,\n' % self.latitude_end)
        if self.longitude_end is not None:
            showIndent(outfile, level)
            outfile.write('longitude_end=%f,\n' % self.longitude_end)
        if self.elevation is not None:
            showIndent(outfile, level)
            outfile.write('elevation=%f,\n' % self.elevation)
        if self.elevation_end is not None:
            showIndent(outfile, level)
            outfile.write('elevation_end=%f,\n' % self.elevation_end)
        if self.primary_location_type is not None:
            showIndent(outfile, level)
            outfile.write('primary_location_type=model_.primary_location_type(\n')
            self.primary_location_type.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.primary_location_name is not None:
            showIndent(outfile, level)
            outfile.write('primary_location_name=model_.primary_location_name(\n')
            self.primary_location_name.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.location_description is not None:
            showIndent(outfile, level)
            outfile.write('location_description=model_.location_description(\n')
            self.location_description.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.locality is not None:
            showIndent(outfile, level)
            outfile.write('locality=model_.locality(\n')
            self.locality.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.locality_description is not None:
            showIndent(outfile, level)
            outfile.write('locality_description=model_.locality_description(\n')
            self.locality_description.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.country is not None:
            showIndent(outfile, level)
            outfile.write('country=%s,\n' % quote_python(self.country).encode(ExternalEncoding))
        if self.province is not None:
            showIndent(outfile, level)
            outfile.write('province=%s,\n' % quote_python(self.province).encode(ExternalEncoding))
        if self.county is not None:
            showIndent(outfile, level)
            outfile.write('county=%s,\n' % quote_python(self.county).encode(ExternalEncoding))
        if self.city is not None:
            showIndent(outfile, level)
            outfile.write('city=%s,\n' % quote_python(self.city).encode(ExternalEncoding))
        if self.cruise_field_prgrm is not None:
            showIndent(outfile, level)
            outfile.write('cruise_field_prgrm=%s,\n' % quote_python(self.cruise_field_prgrm).encode(ExternalEncoding))
        if self.platform_type is not None:
            showIndent(outfile, level)
            outfile.write('platform_type=%s,\n' % quote_python(self.platform_type).encode(ExternalEncoding))
        if self.platform_name is not None:
            showIndent(outfile, level)
            outfile.write('platform_name=%s,\n' % quote_python(self.platform_name).encode(ExternalEncoding))
        if self.platform_descr is not None:
            showIndent(outfile, level)
            outfile.write('platform_descr=%s,\n' % quote_python(self.platform_descr).encode(ExternalEncoding))
        if self.collector is not None:
            showIndent(outfile, level)
            outfile.write('collector=%s,\n' % quote_python(self.collector).encode(ExternalEncoding))
        if self.collector_detail is not None:
            showIndent(outfile, level)
            outfile.write('collector_detail=%s,\n' % quote_python(self.collector_detail).encode(ExternalEncoding))
        if self.collection_date_precision is not None:
            showIndent(outfile, level)
            outfile.write('collection_date_precision=model_.collection_date_precision(\n')
            self.collection_date_precision.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.current_archive is not None:
            showIndent(outfile, level)
            outfile.write('current_archive=model_.current_archive(\n')
            self.current_archive.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.current_archive_contact is not None:
            showIndent(outfile, level)
            outfile.write('current_archive_contact=model_.current_archive_contact(\n')
            self.current_archive_contact.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.original_archive is not None:
            showIndent(outfile, level)
            outfile.write('original_archive=model_.original_archive(\n')
            self.original_archive.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.original_archive_contact is not None:
            showIndent(outfile, level)
            outfile.write('original_archive_contact=model_.original_archive_contact(\n')
            self.original_archive_contact.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.depth_min is not None:
            showIndent(outfile, level)
            outfile.write('depth_min=%f,\n' % self.depth_min)
        if self.depth_max is not None:
            showIndent(outfile, level)
            outfile.write('depth_max=%f,\n' % self.depth_max)
        if self.depth_scale is not None:
            showIndent(outfile, level)
            outfile.write('depth_scale=model_.depth_scale(\n')
            self.depth_scale.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        showIndent(outfile, level)
        outfile.write('other_names=[\n')
        level += 1
        for other_names_ in self.other_names:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(other_names_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'sample_type':
            sample_type_ = child_.text
            sample_type_ = self.gds_validate_string(sample_type_, node, 'sample_type')
            self.sample_type = sample_type_
            self.validate_sample_type(self.sample_type)    # validate type sample_type
        elif nodeName_ == 'igsn':
            igsn_ = child_.text
            igsn_ = self.gds_validate_string(igsn_, node, 'igsn')
            self.igsn = igsn_
            self.validate_igsn(self.igsn)    # validate type igsn
        elif nodeName_ == 'user_code':
            user_code_ = child_.text
            user_code_ = self.gds_validate_string(user_code_, node, 'user_code')
            self.user_code = user_code_
            self.validate_user_code(self.user_code)    # validate type user_code
        elif nodeName_ == 'name':
            name_ = child_.text
            name_ = self.gds_validate_string(name_, node, 'name')
            self.name = name_
        elif nodeName_ == 'sample_other_name':
            sample_other_name_ = child_.text
            sample_other_name_ = self.gds_validate_string(sample_other_name_, node, 'sample_other_name')
            self.sample_other_name = sample_other_name_
        elif nodeName_ == 'parent_igsn':
            parent_igsn_ = child_.text
            parent_igsn_ = self.gds_validate_string(parent_igsn_, node, 'parent_igsn')
            self.parent_igsn = parent_igsn_
            self.validate_parent_igsn(self.parent_igsn)    # validate type parent_igsn
        elif nodeName_ == 'parent_sample_type':
            parent_sample_type_ = child_.text
            parent_sample_type_ = self.gds_validate_string(parent_sample_type_, node, 'parent_sample_type')
            self.parent_sample_type = parent_sample_type_
            self.validate_parent_sample_type(self.parent_sample_type)    # validate type parent_sample_type
        elif nodeName_ == 'parent_name':
            parent_name_ = child_.text
            parent_name_ = self.gds_validate_string(parent_name_, node, 'parent_name')
            self.parent_name = parent_name_
        elif nodeName_ == 'is_private':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'is_private')
            self.is_private = ival_
        elif nodeName_ == 'publish_date':
            publish_date_ = child_.text
            publish_date_ = self.gds_validate_string(publish_date_, node, 'publish_date')
            self.publish_date = publish_date_
            self.validate_publish_date(self.publish_date)    # validate type publish_date
        elif nodeName_ == 'material':
            material_ = child_.text
            material_ = self.gds_validate_string(material_, node, 'material')
            self.material = material_
            self.validate_material(self.material)    # validate type material
        elif nodeName_ == 'classification':
            classification_ = child_.text
            classification_ = self.gds_validate_string(classification_, node, 'classification')
            self.classification = classification_
        elif nodeName_ == 'field_name':
            field_name_ = child_.text
            field_name_ = self.gds_validate_string(field_name_, node, 'field_name')
            self.field_name = field_name_
        elif nodeName_ == 'description':
            description_ = child_.text
            description_ = self.gds_validate_string(description_, node, 'description')
            self.description = description_
        elif nodeName_ == 'age_min':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'age_min')
            self.age_min = fval_
        elif nodeName_ == 'age_max':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'age_max')
            self.age_max = fval_
        elif nodeName_ == 'age_unit':
            obj_ = age_unit.factory()
            obj_.build(child_)
            self.age_unit = obj_
            obj_.original_tagname_ = 'age_unit'
        elif nodeName_ == 'geological_age':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'geological_age')
            self.geological_age = fval_
        elif nodeName_ == 'geological_unit':
            obj_ = geological_unit.factory()
            obj_.build(child_)
            self.geological_unit = obj_
            obj_.original_tagname_ = 'geological_unit'
        elif nodeName_ == 'collection_method':
            obj_ = collection_method.factory()
            obj_.build(child_)
            self.collection_method = obj_
            obj_.original_tagname_ = 'collection_method'
        elif nodeName_ == 'collection_method_descr':
            obj_ = collection_method_descr.factory()
            obj_.build(child_)
            self.collection_method_descr = obj_
            obj_.original_tagname_ = 'collection_method_descr'
        elif nodeName_ == 'size':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'size')
            self.size = fval_
        elif nodeName_ == 'size_unit':
            obj_ = size_unit.factory()
            obj_.build(child_)
            self.size_unit = obj_
            obj_.original_tagname_ = 'size_unit'
        elif nodeName_ == 'sample_comment':
            obj_ = sample_comment.factory()
            obj_.build(child_)
            self.sample_comment = obj_
            obj_.original_tagname_ = 'sample_comment'
        elif nodeName_ == 'latitude':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'latitude')
            self.latitude = fval_
        elif nodeName_ == 'longitude':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'longitude')
            self.longitude = fval_
        elif nodeName_ == 'latitude_end':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'latitude_end')
            self.latitude_end = fval_
        elif nodeName_ == 'longitude_end':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'longitude_end')
            self.longitude_end = fval_
        elif nodeName_ == 'elevation':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'elevation')
            self.elevation = fval_
        elif nodeName_ == 'elevation_end':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'elevation_end')
            self.elevation_end = fval_
        elif nodeName_ == 'primary_location_type':
            obj_ = primary_location_type.factory()
            obj_.build(child_)
            self.primary_location_type = obj_
            obj_.original_tagname_ = 'primary_location_type'
        elif nodeName_ == 'primary_location_name':
            obj_ = primary_location_name.factory()
            obj_.build(child_)
            self.primary_location_name = obj_
            obj_.original_tagname_ = 'primary_location_name'
        elif nodeName_ == 'location_description':
            obj_ = location_description.factory()
            obj_.build(child_)
            self.location_description = obj_
            obj_.original_tagname_ = 'location_description'
        elif nodeName_ == 'locality':
            obj_ = locality.factory()
            obj_.build(child_)
            self.locality = obj_
            obj_.original_tagname_ = 'locality'
        elif nodeName_ == 'locality_description':
            obj_ = locality_description.factory()
            obj_.build(child_)
            self.locality_description = obj_
            obj_.original_tagname_ = 'locality_description'
        elif nodeName_ == 'country':
            country_ = child_.text
            country_ = self.gds_validate_string(country_, node, 'country')
            self.country = country_
        elif nodeName_ == 'province':
            province_ = child_.text
            province_ = self.gds_validate_string(province_, node, 'province')
            self.province = province_
        elif nodeName_ == 'county':
            county_ = child_.text
            county_ = self.gds_validate_string(county_, node, 'county')
            self.county = county_
        elif nodeName_ == 'city':
            city_ = child_.text
            city_ = self.gds_validate_string(city_, node, 'city')
            self.city = city_
        elif nodeName_ == 'cruise_field_prgrm':
            cruise_field_prgrm_ = child_.text
            cruise_field_prgrm_ = self.gds_validate_string(cruise_field_prgrm_, node, 'cruise_field_prgrm')
            self.cruise_field_prgrm = cruise_field_prgrm_
        elif nodeName_ == 'platform_type':
            platform_type_ = child_.text
            platform_type_ = self.gds_validate_string(platform_type_, node, 'platform_type')
            self.platform_type = platform_type_
        elif nodeName_ == 'platform_name':
            platform_name_ = child_.text
            platform_name_ = self.gds_validate_string(platform_name_, node, 'platform_name')
            self.platform_name = platform_name_
        elif nodeName_ == 'platform_descr':
            platform_descr_ = child_.text
            platform_descr_ = self.gds_validate_string(platform_descr_, node, 'platform_descr')
            self.platform_descr = platform_descr_
        elif nodeName_ == 'collector':
            collector_ = child_.text
            collector_ = self.gds_validate_string(collector_, node, 'collector')
            self.collector = collector_
        elif nodeName_ == 'collector_detail':
            collector_detail_ = child_.text
            collector_detail_ = self.gds_validate_string(collector_detail_, node, 'collector_detail')
            self.collector_detail = collector_detail_
        elif nodeName_ == 'collection_date_precision':
            obj_ = collection_date_precision.factory()
            obj_.build(child_)
            self.collection_date_precision = obj_
            obj_.original_tagname_ = 'collection_date_precision'
        elif nodeName_ == 'current_archive':
            obj_ = current_archive.factory()
            obj_.build(child_)
            self.current_archive = obj_
            obj_.original_tagname_ = 'current_archive'
        elif nodeName_ == 'current_archive_contact':
            obj_ = current_archive_contact.factory()
            obj_.build(child_)
            self.current_archive_contact = obj_
            obj_.original_tagname_ = 'current_archive_contact'
        elif nodeName_ == 'original_archive':
            obj_ = original_archive.factory()
            obj_.build(child_)
            self.original_archive = obj_
            obj_.original_tagname_ = 'original_archive'
        elif nodeName_ == 'original_archive_contact':
            obj_ = original_archive_contact.factory()
            obj_.build(child_)
            self.original_archive_contact = obj_
            obj_.original_tagname_ = 'original_archive_contact'
        elif nodeName_ == 'depth_min':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'depth_min')
            self.depth_min = fval_
        elif nodeName_ == 'depth_max':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'depth_max')
            self.depth_max = fval_
        elif nodeName_ == 'depth_scale':
            obj_ = depth_scale.factory()
            obj_.build(child_)
            self.depth_scale = obj_
            obj_.original_tagname_ = 'depth_scale'
        elif nodeName_ == 'other_names':
            other_names_ = child_.text
            other_names_ = self.gds_validate_string(other_names_, node, 'other_names')
            self.other_names.append(other_names_)
# end class sample


class sample_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self):
        self.original_tagname_ = None
    def factory(*args_, **kwargs_):
        if sample_type.subclass:
            return sample_type.subclass(*args_, **kwargs_)
        else:
            return sample_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='sample_type', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='sample_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='sample_type', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='sample_type'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='sample_type', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='sample_type'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class sample_type


class igsn(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self):
        self.original_tagname_ = None
    def factory(*args_, **kwargs_):
        if igsn.subclass:
            return igsn.subclass(*args_, **kwargs_)
        else:
            return igsn(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='igsn', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='igsn')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='igsn', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='igsn'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='igsn', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='igsn'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class igsn


class user_code(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self):
        self.original_tagname_ = None
    def factory(*args_, **kwargs_):
        if user_code.subclass:
            return user_code.subclass(*args_, **kwargs_)
        else:
            return user_code(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='user_code', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='user_code')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='user_code', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='user_code'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='user_code', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='user_code'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class user_code


class parent_igsn(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self):
        self.original_tagname_ = None
    def factory(*args_, **kwargs_):
        if parent_igsn.subclass:
            return parent_igsn.subclass(*args_, **kwargs_)
        else:
            return parent_igsn(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='parent_igsn', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='parent_igsn')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='parent_igsn', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='parent_igsn'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='parent_igsn', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='parent_igsn'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class parent_igsn


class parent_sample_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self):
        self.original_tagname_ = None
    def factory(*args_, **kwargs_):
        if parent_sample_type.subclass:
            return parent_sample_type.subclass(*args_, **kwargs_)
        else:
            return parent_sample_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='parent_sample_type', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='parent_sample_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='parent_sample_type', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='parent_sample_type'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='parent_sample_type', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='parent_sample_type'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class parent_sample_type


class publish_date(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self):
        self.original_tagname_ = None
    def factory(*args_, **kwargs_):
        if publish_date.subclass:
            return publish_date.subclass(*args_, **kwargs_)
        else:
            return publish_date(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='publish_date', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='publish_date')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='publish_date', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='publish_date'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='publish_date', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='publish_date'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class publish_date


class material(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self):
        self.original_tagname_ = None
    def factory(*args_, **kwargs_):
        if material.subclass:
            return material.subclass(*args_, **kwargs_)
        else:
            return material(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='material', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='material')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='material', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='material'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='material', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='material'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class material


class age_unit(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self):
        self.original_tagname_ = None
    def factory(*args_, **kwargs_):
        if age_unit.subclass:
            return age_unit.subclass(*args_, **kwargs_)
        else:
            return age_unit(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='age_unit', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='age_unit')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='age_unit', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='age_unit'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='age_unit', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='age_unit'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class age_unit


class geological_unit(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self):
        self.original_tagname_ = None
    def factory(*args_, **kwargs_):
        if geological_unit.subclass:
            return geological_unit.subclass(*args_, **kwargs_)
        else:
            return geological_unit(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='geological_unit', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='geological_unit')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='geological_unit', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='geological_unit'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='geological_unit', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='geological_unit'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class geological_unit


class collection_method(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self):
        self.original_tagname_ = None
    def factory(*args_, **kwargs_):
        if collection_method.subclass:
            return collection_method.subclass(*args_, **kwargs_)
        else:
            return collection_method(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='collection_method', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='collection_method')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='collection_method', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='collection_method'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='collection_method', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='collection_method'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class collection_method


class collection_method_descr(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self):
        self.original_tagname_ = None
    def factory(*args_, **kwargs_):
        if collection_method_descr.subclass:
            return collection_method_descr.subclass(*args_, **kwargs_)
        else:
            return collection_method_descr(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='collection_method_descr', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='collection_method_descr')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='collection_method_descr', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='collection_method_descr'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='collection_method_descr', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='collection_method_descr'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class collection_method_descr


class size_unit(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self):
        self.original_tagname_ = None
    def factory(*args_, **kwargs_):
        if size_unit.subclass:
            return size_unit.subclass(*args_, **kwargs_)
        else:
            return size_unit(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='size_unit', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='size_unit')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='size_unit', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='size_unit'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='size_unit', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='size_unit'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class size_unit


class sample_comment(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self):
        self.original_tagname_ = None
    def factory(*args_, **kwargs_):
        if sample_comment.subclass:
            return sample_comment.subclass(*args_, **kwargs_)
        else:
            return sample_comment(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='sample_comment', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='sample_comment')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='sample_comment', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='sample_comment'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='sample_comment', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='sample_comment'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class sample_comment


class primary_location_type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self):
        self.original_tagname_ = None
    def factory(*args_, **kwargs_):
        if primary_location_type.subclass:
            return primary_location_type.subclass(*args_, **kwargs_)
        else:
            return primary_location_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='primary_location_type', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='primary_location_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='primary_location_type', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='primary_location_type'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='primary_location_type', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='primary_location_type'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class primary_location_type


class primary_location_name(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self):
        self.original_tagname_ = None
    def factory(*args_, **kwargs_):
        if primary_location_name.subclass:
            return primary_location_name.subclass(*args_, **kwargs_)
        else:
            return primary_location_name(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='primary_location_name', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='primary_location_name')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='primary_location_name', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='primary_location_name'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='primary_location_name', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='primary_location_name'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class primary_location_name


class location_description(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self):
        self.original_tagname_ = None
    def factory(*args_, **kwargs_):
        if location_description.subclass:
            return location_description.subclass(*args_, **kwargs_)
        else:
            return location_description(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='location_description', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='location_description')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='location_description', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='location_description'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='location_description', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='location_description'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class location_description


class locality(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self):
        self.original_tagname_ = None
    def factory(*args_, **kwargs_):
        if locality.subclass:
            return locality.subclass(*args_, **kwargs_)
        else:
            return locality(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='locality', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='locality')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='locality', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='locality'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='locality', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='locality'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class locality


class locality_description(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self):
        self.original_tagname_ = None
    def factory(*args_, **kwargs_):
        if locality_description.subclass:
            return locality_description.subclass(*args_, **kwargs_)
        else:
            return locality_description(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='locality_description', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='locality_description')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='locality_description', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='locality_description'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='locality_description', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='locality_description'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class locality_description


class collection_date_precision(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self):
        self.original_tagname_ = None
    def factory(*args_, **kwargs_):
        if collection_date_precision.subclass:
            return collection_date_precision.subclass(*args_, **kwargs_)
        else:
            return collection_date_precision(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='collection_date_precision', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='collection_date_precision')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='collection_date_precision', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='collection_date_precision'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='collection_date_precision', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='collection_date_precision'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class collection_date_precision


class current_archive(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self):
        self.original_tagname_ = None
    def factory(*args_, **kwargs_):
        if current_archive.subclass:
            return current_archive.subclass(*args_, **kwargs_)
        else:
            return current_archive(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='current_archive', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='current_archive')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='current_archive', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='current_archive'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='current_archive', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='current_archive'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class current_archive


class current_archive_contact(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self):
        self.original_tagname_ = None
    def factory(*args_, **kwargs_):
        if current_archive_contact.subclass:
            return current_archive_contact.subclass(*args_, **kwargs_)
        else:
            return current_archive_contact(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='current_archive_contact', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='current_archive_contact')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='current_archive_contact', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='current_archive_contact'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='current_archive_contact', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='current_archive_contact'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class current_archive_contact


class original_archive(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self):
        self.original_tagname_ = None
    def factory(*args_, **kwargs_):
        if original_archive.subclass:
            return original_archive.subclass(*args_, **kwargs_)
        else:
            return original_archive(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='original_archive', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='original_archive')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='original_archive', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='original_archive'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='original_archive', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='original_archive'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class original_archive


class original_archive_contact(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self):
        self.original_tagname_ = None
    def factory(*args_, **kwargs_):
        if original_archive_contact.subclass:
            return original_archive_contact.subclass(*args_, **kwargs_)
        else:
            return original_archive_contact(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='original_archive_contact', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='original_archive_contact')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='original_archive_contact', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='original_archive_contact'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='original_archive_contact', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='original_archive_contact'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class original_archive_contact


class depth_scale(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self):
        self.original_tagname_ = None
    def factory(*args_, **kwargs_):
        if depth_scale.subclass:
            return depth_scale.subclass(*args_, **kwargs_)
        else:
            return depth_scale(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='depth_scale', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='depth_scale')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='depth_scale', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='depth_scale'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='depth_scale', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='depth_scale'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class depth_scale


GDSClassesMapping = {
}


USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""


def usage():
    print USAGE_TEXT
    sys.exit(1)


def get_root_tag(node):
    tag = Tag_pattern_.match(node.tag).groups()[-1]
    rootClass = GDSClassesMapping.get(tag)
    if rootClass is None:
        rootClass = globals().get(tag)
    return tag, rootClass


def parse(inFileName, silence=False):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'sample'
        rootClass = sample
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    if not silence:
        sys.stdout.write('<?xml version="1.0" ?>\n')
        rootObj.export(
            sys.stdout, 0, name_=rootTag,
            namespacedef_='',
            pretty_print=True)
    return rootObj


def parseEtree(inFileName, silence=False):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'sample'
        rootClass = sample
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    mapping = {}
    rootElement = rootObj.to_etree(None, name_=rootTag, mapping_=mapping)
    reverse_mapping = rootObj.gds_reverse_node_mapping(mapping)
    if not silence:
        content = etree_.tostring(
            rootElement, pretty_print=True,
            xml_declaration=True, encoding="utf-8")
        sys.stdout.write(content)
        sys.stdout.write('\n')
    return rootObj, rootElement, mapping, reverse_mapping


def parseString(inString, silence=False):
    from StringIO import StringIO
    doc = parsexml_(StringIO(inString))
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'sample'
        rootClass = sample
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    if not silence:
        sys.stdout.write('<?xml version="1.0" ?>\n')
        rootObj.export(
            sys.stdout, 0, name_=rootTag,
            namespacedef_='')
    return rootObj


def parseLiteral(inFileName, silence=False):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'sample'
        rootClass = sample
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    if not silence:
        sys.stdout.write('#from Sample import *\n\n')
        sys.stdout.write('import Sample as model_\n\n')
        sys.stdout.write('rootObj = model_.rootClass(\n')
        rootObj.exportLiteral(sys.stdout, 0, name_=rootTag)
        sys.stdout.write(')\n')
    return rootObj


def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()


if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()


__all__ = [
    "age_unit",
    "collection_date_precision",
    "collection_method",
    "collection_method_descr",
    "current_archive",
    "current_archive_contact",
    "depth_scale",
    "geological_unit",
    "igsn",
    "locality",
    "locality_description",
    "location_description",
    "material",
    "original_archive",
    "original_archive_contact",
    "parent_igsn",
    "parent_sample_type",
    "primary_location_name",
    "primary_location_type",
    "publish_date",
    "sample",
    "sample_comment",
    "sample_type",
    "size_unit",
    "user_code"
]
