import sqlalchemy as sa
from sqlalchemy_utils.aggregates import aggregated
from tests import TestCase


class TestAggregatedWithColumnAlias(TestCase):
    def create_models(self):
        class Thread(self.Base):
            __tablename__ = 'thread'
            id = sa.Column(sa.Integer, primary_key=True)

            @aggregated(
                'comments',
                sa.Column('_comment_count', sa.Integer, default=0)
            )
            def comment_count(self):
                return sa.func.count('1')

            comments = sa.orm.relationship('Comment', backref='thread')

        class Comment(self.Base):
            __tablename__ = 'comment'
            id = sa.Column(sa.Integer, primary_key=True)
            thread_id = sa.Column(sa.Integer, sa.ForeignKey('thread.id'))

        self.Thread = Thread
        self.Comment = Comment

    def test_assigns_aggregates_on_insert(self):
        thread = self.Thread()
        self.session.add(thread)
        comment = self.Comment(thread=thread)
        self.session.add(comment)
        self.session.commit()
        self.session.refresh(thread)
        assert thread.comment_count == 1

    def test_assigns_aggregates_on_separate_insert(self):
        thread = self.Thread()
        self.session.add(thread)
        self.session.commit()
        comment = self.Comment(thread=thread)
        self.session.add(comment)
        self.session.commit()
        self.session.refresh(thread)
        assert thread.comment_count == 1

    def test_assigns_aggregates_on_delete(self):
        thread = self.Thread()
        self.session.add(thread)
        self.session.commit()
        comment = self.Comment(thread=thread)
        self.session.add(comment)
        self.session.commit()
        self.session.delete(comment)
        self.session.commit()
        self.session.refresh(thread)
        assert thread.comment_count == 0
