# -----------------------------------------
# Sextant
# Copyright 2014, Ensoft Ltd.
# Author: James Harkin, Patrick Stevens
# -----------------------------------------
#API for performing queries on the database

#!/usr/bin/python3
import argparse
import requests, urllib  # for different kinds of exception
import logging

from . import db_api
from .export import ProgramConverter

def query(remote_neo4j, input_query, program_name=None, argument_1=None, argument_2=None, suppress_common=False):

    try:
        db = db_api.SextantConnection(remote_neo4j)
    except requests.exceptions.ConnectionError as err:
        logging.exception("Could not connect to Neo4J server {}. Are you sure it is running?".format(remote_neo4j))
        logging.exception(str(err))
        return 2
    #Not supported in python 2
    #except (urllib.exceptions.MaxRetryError):
     #   logging.error("Connection was refused to {}. Are you sure the server is running?".format(remote_neo4j))
      #  return 2
    except Exception as err:
        logging.exception(str(err))
        return 2

    prog = None
    names_list = None

    if input_query == 'functions-calling':
        if argument_1 == None:
            print('Supply one function name to functions-calling.')
            return 1
        prog = db.get_all_functions_calling(program_name, argument_1)
    elif input_query == 'functions-called-by':
        if argument_1 == None:
            print('Supply one function name to functions-called-by.')
            return 1
        prog = db.get_all_functions_called(program_name, argument_1)
    elif input_query == 'calls-between':
        if (argument_1 == None and argument_2 == None):
            print('Supply two function names to calls-between.')
            return 1
        prog = db.get_call_paths(program_name, argument_1, argument_2)
    elif input_query == 'whole-graph':
        prog = db.get_whole_program(program_name)
    elif input_query == 'shortest-path':
        if argument_1 == None and argument_2 == None:
            print('Supply two function names to shortest-path.')
            return 1
        prog = db.get_shortest_path_between_functions(program_name, argument_1, argument_2)
    elif input_query == 'return-all-function-names':
        if program_name != None:
            func_names = db.get_function_names(program_name)
            if func_names:
                names_list = list(func_names)
            else:
                print('No functions were found in program %s on server %s.' % (program_name, remote_neo4j))
        else:
            list_of_programs = db.get_program_names()
            if not list_of_programs:
                print('Server %s database empty.' % (remote_neo4j))
                return 0
            func_list = []
            for prog_name in list_of_programs:
                func_list += db.get_function_names(prog_name)
            if not func_list:
                print('Server %s contains no functions.' % (remote_neo4j))
            else:
                names_list = func_list
    elif input_query == 'return-all-program-names':
        list_found = list(db.get_program_names())
        if not list_found:
            print('No programs were found on server {}.'.format(remote_neo4j))
        else:
            names_list = list_found
    else:
        print('Query unrecognised.')
        return 2

    if prog:
        print(ProgramConverter.to_yed_graphml(prog, suppress_common))
    elif names_list is not None:
        print(names_list)
    else:
        print('Nothing was returned from the query.')


def main():
    argumentparser = argparse.ArgumentParser(description="Return GraphML representation or list from graph queries.")
    argumentparser.add_argument('--remote-neo4j', required=True, metavar="URL", help="URL of neo4j server", type=str, nargs=1)
    argumentparser.add_argument('--program-name', metavar="PROG_NAME", help="name of program as stored in the database",
                                type=str, nargs=1)
    argumentparser.add_argument('--query', required=True, metavar="QUERY",
                                help="""functions-calling, functions-called-by, calls-between, whole-graph, shortest-path,
                                return-all-program-names or return-all-function-names; if return-all-function-names,
                                supply argument -program-name""", type=str, nargs=1)
    argumentparser.add_argument('--funcs', metavar='FUNCS', help='functions to pass to the query', type=str, nargs='+')

    parsed = argumentparser.parse_args()
    names_list = None

    query(remote_neo4j=parsed.remote_neo4j[0], input_query=parsed.query[0], arguments=parsed.funcs,
          program_name=parsed.program_name[0])


if __name__ == '__main__':
    main()
