// Sextant
// Copyright 2014, Ensoft Ltd.
// Author: James Harkin, Patrick Stevens
// 
//Runs query and "GET"s either program names uploaded on the 
//server or function names from a specific program.


function get_names_for_autocomplete(info_needed){
	//Function queries to database to create a list 
	//which is used to populate the auto-complete text boxes.
	var xmlhttp = new XMLHttpRequest();
	xmlhttp.onreadystatechange = function(){
		if (xmlhttp.status = 200){
			var values_list = xmlhttp.responseText;
			console.log(values_list)
			values_list = JSON.parse(values_list);
			if (info_needed =='programs'){
				//We need to populate the program names list
				add_options("program_names", values_list);
			}
			if (info_needed =='funcs'){
				//We need to populate the functions list for the arguments
				add_options("function_names", values_list);
			}	
		}
	}
	if (info_needed == 'programs'){
		var string = "/database_properties?query=" + info_needed + "&program_name=";
	}
	else{
		var string = "/database_properties?query=" + "functions" + 
		"&program_name=" + document.getElementById("program_name").value;
	if (info_needed == 'programs'){
		var string = "/database_properties?query=" + 
		info_needed + "&program_name=" + prog_name;
	}
	//"GET" information from the specified url (string)
	xmlhttp.open("GET", string, true);
	xmlhttp.send();
	}
	xmlhttp.open("GET", string, true);
	xmlhttp.send();
}


function add_options(selectedlist, values_list){
	//Adds all the options obtained from the list of program 
	//names or function names to an auto complete drop-down box
	var options = ''
	if (values_list.length == 1 || values_list.length ==0){
		options += '<option value="'+values_list+'"/>';
	}
	else{
		for (var i=0; i < values_list.length;++i){
			options += '<option value="'+values_list[i]+'"/>';
		}
	}
	document.getElementById(selectedlist).innerHTML = options;
}

	
function display_when(){
	//For each query specifies when auto-complete text boxes should be made 
	//visible or invisible and makes them read only
	var query_list = document.getElementById("query_list");
	document.getElementById("query").value = 
		query_list.options[query_list.selectedIndex].text;
	var no_functions = new Array();
	var prog_name = document.getElementById("program_name").value;
	if (query_list.options[query_list.selectedIndex].value == "functions_calling"){
		document.getElementById("argument_1").innerHTML = "Function being called";
		document.getElementById("argument_2").innerHTML = "";
		document.getElementById("function_1").readOnly = false;
		document.getElementById("function_2").readOnly = true;
		document.getElementById("function_1").style.visibility = "visible";
		document.getElementById("function_2").style.visibility = "hidden";
		document.getElementById("function_2").value = null;
	}
	if (query_list.options[query_list.selectedIndex].value == "functions_called_by"){
		document.getElementById("argument_1").innerHTML = "Function calling";
		document.getElementById("argument_2").innerHTML = "";
		document.getElementById("function_1").readOnly = false;
		document.getElementById("function_2").readOnly = true;
		document.getElementById("function_1").style.visibility = "visible";
		document.getElementById("function_2").style.visibility = "hidden";
		document.getElementById("function_2").value = null;
	}
	if (query_list.options[query_list.selectedIndex].value == "call_paths"){
		document.getElementById("argument_1").innerHTML = "Function calling";
		document.getElementById("argument_2").innerHTML = "Function being called";
		document.getElementById("function_1").readOnly = false;
		document.getElementById("function_2").readOnly = false;
		document.getElementById("function_1").style.visibility = "visible";
		document.getElementById("function_2").style.visibility = "visible";
	}
	if (query_list.options[query_list.selectedIndex].value == "shortest_path"){
		document.getElementById("argument_1").innerHTML = "Function calling";
		document.getElementById("argument_2").innerHTML = "Function being called";
		document.getElementById("function_1").readOnly = false;
		document.getElementById("function_2").readOnly = false;
		document.getElementById("function_1").style.visibility = "visible";
		document.getElementById("function_2").style.visibility = "visible";
	}
	if (query_list.options[query_list.selectedIndex].value == "whole_program") {
		document.getElementById("argument_1").innerHTML	= "No arguments required.";
		document.getElementById("argument_2").innerHTML = "";
		document.getElementById("function_1").readOnly = true;
		document.getElementById("function_2").readOnly = true;
		document.getElementById("function_1").style.visibility = "hidden";
		document.getElementById("function_2").style.visibility = "hidden";
		document.getElementById("function_1").value = null;
		document.getElementById("function_2").value = null;
	}
	if (query_list.options[query_list.selectedIndex].value == "function_names"){
		document.getElementById("argument_1").innerHTML = "No arguments required.";
		document.getElementById("argument_2").innerHTML = "";
		document.getElementById("function_1").readOnly = true;
		document.getElementById("function_2").readOnly = true;
		document.getElementById("function_1").style.visibility = "hidden";
		document.getElementById("function_2").style.visibility = "hidden";
		document.getElementById("function_1").value = null;
		document.getElementById("function_2").value = null;
	}
}



function execute_query(){
	//Returns error in alert window if query not executed properly, 
	//otherwise performs the query and outputs it
	document.getElementById("output_image").src = "";
	document.getElementById("output_image").alt = "Please wait loading...";
	var query_id = document.getElementById("query_list").value;
	if (query_id == "function_names"){
		//url for page containing all function names
		var string = "/database_properties?program_name=" + 
		document.getElementById("program_name").value + "&query=functions";
	}
	else{
		//If not function names we will want a graph as an output; 
		//url returns svg file of graph.
		var string = "/output_graph.svg?program_name=" + 
			document.getElementById("program_name").value + 
			"&query=" + query_id + "&func1=";
        string = string + document.getElementById("function_1").value + 
			"&func2=" + document.getElementById("function_2").value;
        string = string + "&suppress_common=" + 
			document.getElementById('suppress_common').checked.toString();

	}
	var xmlhttp = new XMLHttpRequest();
		xmlhttp.open("GET", string, true);
		xmlhttp.send();
	xmlhttp.onreadystatechange = function(){
		if (xmlhttp.readyState == 4 && xmlhttp.status == 200){
			//readyState == 4 means query has finished executing.
			//status == 200 means "GET"ing has been successful.
			if (query_id == "function_names"){
				//Text output displayed in paragraph.
				document.getElementById("function_names_output").innerHTML = 
						xmlhttp.responseText;
				document.getElementById("function_names_output").style.visibility = 
						"visible"
				//Clear current image if one exists.
				document.getElementById("output_image").alt = "";
				document.getElementById("output_image").src = "";
			}
			else{
				document.getElementById("function_names_output").style.visibility = 
						"hidden"
				document.getElementById("output_image").src = string;
			}
		}
		else if (xmlhttp.readyState == 4 && xmlhttp.status == 400){
			//Error occurred during query; display response.
			document.getElementById("output_image").alt = "";
			window.alert(xmlhttp.responseText);
		}
		else if(xmlhttp.readyState == 4 && xmlhttp.status == 404){
			//Error occurred during query; display response.
			document.getElementById("output_image").alt = "";
			window.alert(xmlhttp.responseText);
		}
		else if(xmlhttp.readyState ==4 && xmlhttp.status == 204){
			//Query executed correctly but graph returned is empty
			document.getElementById("output_image").alt = "";
			window.alert("Graph returned was empty");
		}
		else if (xmlhttp.readyState == 4 && xmlhttp.status == 502) {
		    //Error occurs if Neo4j isn't running
			document.getElementById("output_image").alt = "";
			window.alert("Bad Gateway received - are you sure the database server is running?");
		}
		else if(xmlhttp.readyState ==4){
			//query executed correctly
			document.getElementById("output_image").alt = "";
			window.alert("Error not recognised");
		}
	}
}
