// Sextant
// Copyright 2014, Ensoft Ltd.
// Author: James Harkin, Patrick Stevens
// 
//Runs query and "GET"s either program names uploaded on the 
//server or function names from a specific program.


function get_names_for_autocomplete(info_needed){
    //Function queries to database to create a list 
    //which is used to populate the auto-complete text boxes.
    var xmlhttp = new XMLHttpRequest();
    xmlhttp.onreadystatechange = function(){
        if (xmlhttp.status = 200){
            var values_list = xmlhttp.responseText;
            if (values_list != "") {
                values_list = JSON.parse(values_list);
                if (info_needed =='programs'){
                    //We need to populate the program names list
                    add_options("program_names", values_list);
                }
                if (info_needed =='funcs'){
                    //We need to populate the functions list for the arguments
                    add_options("function_names", values_list);
                }    
            }
        }
    }
    if (info_needed == 'programs'){
        var string = "/database_properties?query=" + info_needed + "&program_name=";
    }
    else{
        var string = "/database_properties?query=" + "functions" + 
        "&program_name=" + document.getElementById("program_name").value;
    if (info_needed == 'programs'){
        var string = "/database_properties?query=" + 
        info_needed + "&program_name=" + prog_name;
    }
    //"GET" information from the specified url (string)
    xmlhttp.open("GET", string, true);
    xmlhttp.send();
    }
    xmlhttp.open("GET", string, true);
    xmlhttp.send();
}


function add_options(selectedlist, values_list){
    //Adds all the options obtained from the list of program 
    //names or function names to an auto complete drop-down box
    var options = ''
    if (values_list.length == 1 || values_list.length ==0){
        options += '<option value="'+values_list+'"/>';
    }
    else{
        for (var i=0; i < values_list.length;++i){
            options += '<option value="'+values_list[i]+'"/>';
        }
    }
    document.getElementById(selectedlist).innerHTML = options;
}


function set_argument(number, label) {
    var argEl = document.getElementById("argument_" + number);
    var funcEl = document.getElementById("function_" + number);
    if (label == "") {
        argEl.style.visibility = "hidden";
        funcEl.style.visibility = "hidden";
        funcEl.value = null;
    } else {
        argEl.innerHTML = label;
        argEl.style.visibility = "visible";
        funcEl.style.visibility = "visible";
    }
}


function set_arguments(label1, label2) {
    set_argument(1, label1);
    set_argument(2, label2);
    document.getElementById("toolbar-row2").style.display
                    = (label1 == "" && label2 == "") ? "none" : "block";
}

    
function display_when(){
    //For each query specifies when auto-complete text boxes should be made 
    //visible or invisible and makes them read only
    var query_list = document.getElementById("query_list");

    var no_functions = new Array();
    var prog_name = document.getElementById("program_name").value;
    if (query_list.options[query_list.selectedIndex].value == "functions_calling"){
        set_arguments("Function being called", "");
    }
    if (query_list.options[query_list.selectedIndex].value == "functions_called_by"){
        set_arguments("Function calling", "");
    }
    if (query_list.options[query_list.selectedIndex].value == "all_call_paths"){
        set_arguments("Function calling", "Function being called");
    }
    if (query_list.options[query_list.selectedIndex].value == "shortest_call_path"){
        set_arguments("Function calling", "Function being called");
    }
    if (query_list.options[query_list.selectedIndex].value == "whole_program") {
        set_arguments("", "");
    }
    if (query_list.options[query_list.selectedIndex].value == "function_names"){
        set_arguments("", "");
    }
}



function execute_query(){
    document.getElementById("output_image").src = "";

    //Returns error in alert window if query not executed properly, 
    //otherwise performs the query and outputs it
    show_item("please-wait");
    var query_id = document.getElementById("query_list").value;
    if (query_id == "function_names"){
        //url for page containing all function names
        var string = "/database_properties?program_name=" + 
        document.getElementById("program_name").value + "&query=functions";
    }
    else{
        //If not function names we will want a graph as an output; 
        //url returns svg file of graph.
                // We use a random number argument to prevent caching.
        var string = "/output_graph.svg?stop_cache=" + String(Math.random()) + "&program_name=" + 
            document.getElementById("program_name").value + 
            "&query=" + query_id + "&func1=";
        string = string + document.getElementById("function_1").value + 
            "&func2=" + document.getElementById("function_2").value;
        string = string + "&suppress_common=" + 
            document.getElementById('suppress_common').checked.toString();

    }
    var xmlhttp = new XMLHttpRequest();
        xmlhttp.open("GET", string, true);
        xmlhttp.send();
    xmlhttp.onreadystatechange = function(){
        if (xmlhttp.readyState == 4 && xmlhttp.status == 200){
            //readyState == 4 means query has finished executing.
            //status == 200 means "GET"ing has been successful.
            if (query_id == "function_names"){
                //Text output displayed in paragraph.
                document.getElementById("function_names_output").innerHTML = 
                        xmlhttp.responseText;
                show_item("function_names_output");
            }
            else{
                show_item("output_image");
                document.getElementById("output_image").src = string;
            }
        }
        else if (xmlhttp.readyState == 4 && xmlhttp.status == 400){
            //Error occurred during query; display response.
            show_error(xmlhttp.responseText);
        }
        else if(xmlhttp.readyState == 4 && xmlhttp.status == 404){
            //Error occurred during query; display response.
            show_error(xmlhttp.responseText);
        }
        else if(xmlhttp.readyState ==4 && xmlhttp.status == 204){
            //Query executed correctly but graph returned is empty
            show_error("Graph returned was empty");
        }
        else if (xmlhttp.readyState == 4 && xmlhttp.status == 502) {
            //Error occurs if Neo4j isn't running
            show_error("Bad Gateway received - are you sure the database server is running?");
        }
        else if(xmlhttp.readyState ==4){
            //query executed correctly
            show_error("An unknown error occurred");
        }
    }
}

function show_item(id) {
    var els = ["output_image", "function_names_output", "welcome", "please-wait", "error"];

    for (var i = 0; i < els.length; i++) {
        document.getElementById(els[i]).style.display = "none";
    }

    document.getElementById(id).style.display = "block";
}


function show_error(msg) {
    show_item("error");
    document.getElementById("error-msg").innerHTML = msg;
}
