# Copyright 2014, Ensoft Ltd.
# Author: Patrick Stevens, James Harkin
# -----------------------------------------
# Note: this must be run in Python 2.

from twisted.web.server import Site, NOT_DONE_YET
from twisted.web.resource import Resource
from twisted.web.static import File
from twisted.internet import reactor
from twisted.internet.threads import deferToThread
from twisted.internet import defer

import logging
import os
import json
import requests

import sextant.db_api as db_api
import sextant.export as export
import sextant.environment as environment
import tempfile
import subprocess

from cgi import escape  # deprecated in Python 3 in favour of html.escape, but we're stuck on Python 2

database_url = None  # the URL to access the database instance

class Echoer(Resource):
    # designed to take one name argument

    def render_GET(self, request):
        if "name" not in request.args:
            return '<html><body>Greetings, unnamed stranger.</body></html>'

        arg = escape(request.args["name"][0])
        return '<html><body>Hello %s!</body></html>' % arg


class SVGRenderer(Resource):

    def error_creating_neo4j_connection(self, failure):
        self.write("Error creating Neo4J connection: %s\n") % failure.getErrorMessage()

    @staticmethod
    def create_neo4j_connection():
        return db_api.SextantConnection(database_url)

    @staticmethod
    def check_program_exists(connection, name):
        return connection.check_program_exists(name)

    @staticmethod
    def get_whole_program(connection, name):
        return connection.get_whole_program(name)

    @staticmethod
    def get_functions_calling(connection, progname, funcname):
        return connection.get_all_functions_calling(progname, funcname)

    @staticmethod
    def get_plot(program, suppress_common_functions=False, remove_self_calls=False):
        graph_dot = export.ProgramConverter.to_dot(program, suppress_common_functions,

