<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
	"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" 
      xmlns:svg="http://www.w3.org/2000/svg"
       xmlns:dc="http://purl.org/dc/elements/1.1/"
       xmlns:cc="http://creativecommons.org/ns#"
       xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
       xmlns:sodipodi="http://sodipodi.sourceforge.net/DTD/sodipodi-0.dtd"
       xmlns:inkscape="http://www.inkscape.org/namespaces/inkscape"
      xml:lang="en" lang="en">
<head>
    <script>
        Timeline_ajax_url="/javascripts/simile/ajax/api/simile-ajax-api.js";
        Timeline_urlPrefix='/javascripts/simile/timeline/api/';       
        Timeline_parameters='defaultLocale=en';
    </script>

    <script src="/javascripts/simile/timeline/api/timeline-api.js?bundle=false" type="text/javascript"></script> 
	<meta http-equiv="Content-Type" content="application/xhtml+xml; charset=utf-8"/>
	<title>${c.ctitle|n}</title>
	<script type="text/javascript" src="/javascripts/simile/ajax/api/scripts/jquery-1.2.6.js"/>
	<script type="text/javascript" src="/javascripts/jquery.tooltip.js"/>
    <link rel="stylesheet'" href="/css/styles.css" type='text/css' />

    <style type="text/css">
    #rhs {padding: 0 0.5em; float:right; width:320px; height:490px; border:1px solid #aaa}
    #rhs h2 {padding: 0 0.25em; font-style:italic; font-weight:normal;}
    #rhs p {padding: 0 0.25em;}
    #rubric {font-family:Helvetica; font-style:italic; padding:0 2em;}
    h1.mainh1 {font-size:120%; font-weight:bold; padding: 0.25em; margin:0.25em;}
    #svgbox {
        margin:0.33 0; padding:5px; width:640px; height:480px; border:1px solid #aaa; max-width:640px;
    }
    #tl {height: 250px; width:1000px;}
    #flashTransport {clear:all; float:none; visibility:hidden; }
    .rhsp {visibility:hidden; position: absolute; font-size: 90%}
    .rhsp a {text-decoration: none;}
    #layer0 {visibility:visible;}
    </style>
    <script type="text/javascript"> 
        $('g > path').tooltip({
    	track: true,
    	delay: 0,
    	bodyHandler: function() {
    		return $($(this).attr("id"));
    	},
    	showURL: false,
    	fade: 250 });
        % if c.constituency is DEFINED:
        var next = ${c.constituency};
        % else:
        var next = 9;
        % endif 
        var tl;
        function onTimeLine() {
            var eventSource = new Timeline.DefaultEventSource(0);
            
            var theme = Timeline.ClassicTheme.create();
            theme.event.bubble.width = 300;
            theme.event.bubble.height = 200;
            var d = Timeline.DateTime.setIso8601Date(new Date(), "2008-09-26");
            var bandInfos = [
                Timeline.createBandInfo({
                    width:          "80%", 
                    intervalUnit:   Timeline.DateTime.DAY, 
                    intervalPixels: 100,
                    eventSource:    eventSource,
                    date:           d,
                    theme:          theme
                }),
                Timeline.createBandInfo({
                    width:          "10%", 
                    intervalUnit:   Timeline.DateTime.MONTH, 
                    intervalPixels: 150
                }),
                Timeline.createBandInfo({
                    width:          "10%", 
                    intervalUnit:   Timeline.DateTime.YEAR, 
                    intervalPixels: 200
                })
            ];
            bandInfos[1].syncWith = 0;
            bandInfos[1].highlight = true;            
            bandInfos[2].syncWith = 1;
            bandInfos[2].highlight = true;            
 
            tl = Timeline.create(document.getElementById("tl"), bandInfos, Timeline.HORIZONTAL);
            Timeline.loadXML("/rdflab/constituency_detail/"+next, function(xml, url) {
                eventSource.loadSPARQL(xml, url);
            });
        }
        var resizeTimerID = null;
        function onResize() {
            if (resizeTimerID == null) {
                resizeTimerID = window.setTimeout(function() {
                    resizeTimerID = null;
                    tl.layout();
                }, 500);
            }
        }
    </script> 
	<script type="text/javascript" src="/javascripts/lib.js"/>
</head>

<body>
    <h1 class="mainh1">
    % if c.clink is not UNDEFINED:
        <a href="/rdflab/constituency">South West UK</a> :: <a href="${c.clink}">${c.ctitle|n}</a>
    % else:
        <a href="/rdflab/constituency">South West UK</a> ${':: ' + c.ctitle if c.title else ''|n}
    % endif
    </h1>
    <div style="width:1000px">
        <div id="rhs">
            <div id="layer0" class="rhsp"><span id="rubric"> ... South West UK constituency regions ... </span></div>
            <div id="_Bath" class="rhsp"><table class="infobox geography vcard" style="width:300px;"> <tr> <th colspan="2" style="background-color:#efefef; text-align:center;"><big class="fn org"><b>Bath</b></big><br /> <a href="http://en.wikipedia.org/wiki/County_constituency" title="County constituency" class="mw-redirect">County constituency</a></th> </tr> <tr> <td colspan="2" style="text-align:center;"><a href="http://en.wikipedia.org/wiki/Image:BathConstituency.svg" class="image" title="BathConstituency.svg"><img alt="" src="http://upload.wikimedia.org/wikipedia/commons/thumb/d/da/BathConstituency.svg/120px-BathConstituency.svg.png" width="120" height="104" border="0" /></a><br /> <a href="http://en.wikipedia.org/wiki/Image:EnglandAvon.svg" class="image" title="EnglandAvon.svg"><img alt="" src="http://upload.wikimedia.org/wikipedia/commons/thumb/b/b7/EnglandAvon.svg/120px-EnglandAvon.svg.png" width="120" height="148" border="0" /></a></td> </tr> <tr> <td colspan="2" style="background-color:#efefef; text-align:center; font-weight:bold;">Bath shown within <a href="http://en.wikipedia.org/wiki/Avon_(county)" title="Avon (county)">Avon (county)</a>, and Avon (county) shown within <a href="http://en.wikipedia.org/wiki/England" title="England">England</a></td> </tr> <tr class="note"> <th>Created:</th> <td>1295</td> </tr> <tr class="note"> <th><a href="http://en.wikipedia.org/wiki/Member_of_Parliament" title="Member of Parliament">MP</a>:</th> <td><a href="http://en.wikipedia.org/wiki/Donald_Foster_(politician)" title="Donald Foster (politician)" class="mw-redirect">Don Foster</a></td> </tr> <tr class="note"> <th><a href="http://en.wikipedia.org/wiki/List_of_political_parties_in_the_United_Kingdom" title="List of political parties in the United Kingdom">Party</a>:</th> <td><a href="http://en.wikipedia.org/wiki/Liberal_Democrats_(UK)" title="Liberal Democrats (UK)" class="mw-redirect">Liberal Democrat</a></td> </tr> <tr class="note"> <th><a href="http://en.wikipedia.org/wiki/United_Kingdom_constituencies" title="United Kingdom constituencies">Type</a>:</th> <td><a href="http://en.wikipedia.org/wiki/House_of_Commons_of_the_United_Kingdom" title="House of Commons of the United Kingdom">House of Commons</a></td> </tr> <tr class="note"> <th><a href="http://en.wikipedia.org/wiki/Ceremonial_counties_of_England" title="Ceremonial counties of England">County</a>:</th> <td><a href="http://en.wikipedia.org/wiki/Somerset" title="Somerset">Somerset</a></td> </tr> <tr class="note"> <th><a href="http://en.wikipedia.org/wiki/European_Parliament" title="European Parliament">EP constituency</a>:</th> <td><a href="http://en.wikipedia.org/wiki/South_West_England_(European_Parliament_constituency)" title="South West England (European Parliament constituency)">South West England</a></td> </tr> </table></div>
            <div id="_Northavon" class="rhsp"><table class="infobox geography vcard" style="width:300px;"> <tr> <th colspan="2" style="background-color:#efefef; text-align:center;"><big class="fn org"><b>Northavon</b></big><br /> <a href="http://en.wikipedia.org/wiki/County_constituency" title="County constituency" class="mw-redirect">County constituency</a></th> </tr> <tr> <td colspan="2" style="text-align:center;"><a href="http://en.wikipedia.org/wiki/Image:NorthavonConstituency.svg" class="image" title="NorthavonConstituency.svg"><img alt="" src="http://upload.wikimedia.org/wikipedia/commons/thumb/c/cc/NorthavonConstituency.svg/120px-NorthavonConstituency.svg.png" width="120" height="104" border="0" /></a><br /> <a href="http://en.wikipedia.org/wiki/Image:EnglandAvon.svg" class="image" title="EnglandAvon.svg"><img alt="" src="http://upload.wikimedia.org/wikipedia/commons/thumb/b/b7/EnglandAvon.svg/120px-EnglandAvon.svg.png" width="120" height="148" border="0" /></a></td> </tr> <tr> <td colspan="2" style="background-color:#efefef; text-align:center; font-weight:bold;">Northavon shown within <a href="http://en.wikipedia.org/wiki/Avon_(county)" title="Avon (county)">Avon (county)</a>, and Avon (county) shown within <a href="http://en.wikipedia.org/wiki/England" title="England">England</a></td> </tr> <tr class="note"> <th>Created:</th> <td><a href="http://en.wikipedia.org/wiki/1983" title="1983">1983</a></td> </tr> <tr class="note"> <th><a href="http://en.wikipedia.org/wiki/Member_of_Parliament" title="Member of Parliament">MP</a>:</th> <td><a href="http://en.wikipedia.org/wiki/Steve_Webb" title="Steve Webb">Steve Webb</a></td> </tr> <tr class="note"> <th><a href="http://en.wikipedia.org/wiki/List_of_political_parties_in_the_United_Kingdom" title="List of political parties in the United Kingdom">Party</a>:</th> <td><a href="http://en.wikipedia.org/wiki/Liberal_Democrats_(UK)" title="Liberal Democrats (UK)" class="mw-redirect">Liberal Democrat</a></td> </tr> <tr class="note"> <th><a href="http://en.wikipedia.org/wiki/United_Kingdom_constituencies" title="United Kingdom constituencies">Type</a>:</th> <td><a href="http://en.wikipedia.org/wiki/House_of_Commons_of_the_United_Kingdom" title="House of Commons of the United Kingdom">House of Commons</a></td> </tr> <tr class="note"> <th><a href="http://en.wikipedia.org/wiki/Ceremonial_counties_of_England" title="Ceremonial counties of England">County</a>:</th> <td><a href="http://en.wikipedia.org/wiki/Gloucestershire" title="Gloucestershire">Gloucestershire</a></td> </tr> <tr class="note"> <th><a href="http://en.wikipedia.org/wiki/European_Parliament" title="European Parliament">EP constituency</a>:</th> <td><a href="http://en.wikipedia.org/wiki/South_West_England_(European_Parliament_constituency)" title="South West England (European Parliament constituency)">South West England</a></td> </tr> </table></div>
            <div id="_Bristol West" class="rhsp"><table class="infobox geography vcard" style="width:300px;"> <tr> <th colspan="2" style="background-color:#efefef; text-align:center;"><big class="fn org"><b>Bristol West</b></big><br /> <a href="http://en.wikipedia.org/wiki/Borough_constituency" title="Borough constituency" class="mw-redirect">Borough constituency</a></th> </tr> <tr> <td colspan="2" style="text-align:center;"><a href="http://en.wikipedia.org/wiki/Image:BristolWestConstituency.svg" class="image" title="BristolWestConstituency.svg"><img alt="" src="http://upload.wikimedia.org/wikipedia/commons/thumb/6/6e/BristolWestConstituency.svg/120px-BristolWestConstituency.svg.png" width="120" height="104" border="0" /></a><br /> <a href="http://en.wikipedia.org/wiki/Image:EnglandAvon.svg" class="image" title="EnglandAvon.svg"><img alt="" src="http://upload.wikimedia.org/wikipedia/commons/thumb/b/b7/EnglandAvon.svg/120px-EnglandAvon.svg.png" width="120" height="148" border="0" /></a></td> </tr> <tr> <td colspan="2" style="background-color:#efefef; text-align:center; font-weight:bold;">Bristol West shown within <a href="http://en.wikipedia.org/wiki/Greater_Bristol" title="Greater Bristol">Greater Bristol</a>, and Greater Bristol shown within <a href="http://en.wikipedia.org/wiki/England" title="England">England</a></td> </tr> <tr class="note"> <th>Created:</th> <td>1885</td> </tr> <tr class="note"> <th><a href="http://en.wikipedia.org/wiki/Member_of_Parliament" title="Member of Parliament">MP</a>:</th> <td><a href="http://en.wikipedia.org/wiki/Stephen_Williams_(politician)" title="Stephen Williams (politician)">Stephen Williams</a></td> </tr> <tr class="note"> <th><a href="http://en.wikipedia.org/wiki/List_of_political_parties_in_the_United_Kingdom" title="List of political parties in the United Kingdom">Party</a>:</th> <td><a href="http://en.wikipedia.org/wiki/Liberal_Democrats_(UK)" title="Liberal Democrats (UK)" class="mw-redirect">Liberal Democrat</a></td> </tr> <tr class="note"> <th><a href="http://en.wikipedia.org/wiki/United_Kingdom_constituencies" title="United Kingdom constituencies">Type</a>:</th> <td><a href="http://en.wikipedia.org/wiki/House_of_Commons_of_the_United_Kingdom" title="House of Commons of the United Kingdom">House of Commons</a></td> </tr> <tr class="note"> <th><a href="http://en.wikipedia.org/wiki/Ceremonial_counties_of_England" title="Ceremonial counties of England">County</a>:</th> <td><a href="http://en.wikipedia.org/wiki/City_of_Bristol" title="City of Bristol" class="mw-redirect">City of Bristol</a></td> </tr> <tr class="note"> <th><a href="http://en.wikipedia.org/wiki/European_Parliament" title="European Parliament">EP constituency</a>:</th> <td><a href="http://en.wikipedia.org/wiki/South_West_England_(European_Parliament_constituency)" title="South West England (European Parliament constituency)">South West England</a></td> </tr> </table></div>
            <div id="_Bristol East" class="rhsp"><table class="infobox geography vcard" style="width:300px;"> <tr> <th colspan="2" style="background-color:#efefef; text-align:center;"><big class="fn org"><b>Bristol East</b></big><br /> <a href="http://en.wikipedia.org/wiki/Borough_constituency" title="Borough constituency" class="mw-redirect">Borough constituency</a></th> </tr> <tr> <td colspan="2" style="text-align:center;"><a href="http://en.wikipedia.org/wiki/Image:BristolEastConstituency.svg" class="image" title="BristolEastConstituency.svg"><img alt="" src="http://upload.wikimedia.org/wikipedia/commons/thumb/b/bf/BristolEastConstituency.svg/120px-BristolEastConstituency.svg.png" width="120" height="104" border="0" /></a><br /> <a href="http://en.wikipedia.org/wiki/Image:EnglandAvon.svg" class="image" title="EnglandAvon.svg"><img alt="" src="http://upload.wikimedia.org/wikipedia/commons/thumb/b/b7/EnglandAvon.svg/120px-EnglandAvon.svg.png" width="120" height="148" border="0" /></a></td> </tr> <tr> <td colspan="2" style="background-color:#efefef; text-align:center; font-weight:bold;">Bristol East shown within <a href="http://en.wikipedia.org/wiki/Avon_(county)" title="Avon (county)">Avon (county)</a>, and Avon (county) shown within <a href="http://en.wikipedia.org/wiki/England" title="England">England</a></td> </tr> <tr class="note"> <th>Created:</th> <td>1885, 1983</td> </tr> <tr class="note"> <th><a href="http://en.wikipedia.org/wiki/Member_of_Parliament" title="Member of Parliament">MP</a>:</th> <td><a href="http://en.wikipedia.org/wiki/Kerry_McCarthy" title="Kerry McCarthy">Kerry McCarthy</a></td> </tr> <tr class="note"> <th><a href="http://en.wikipedia.org/wiki/List_of_political_parties_in_the_United_Kingdom" title="List of political parties in the United Kingdom">Party</a>:</th> <td><a href="http://en.wikipedia.org/wiki/Labour_Party_(UK)" title="Labour Party (UK)">Labour</a></td> </tr> <tr class="note"> <th><a href="http://en.wikipedia.org/wiki/United_Kingdom_constituencies" title="United Kingdom constituencies">Type</a>:</th> <td><a href="http://en.wikipedia.org/wiki/House_of_Commons_of_the_United_Kingdom" title="House of Commons of the United Kingdom">House of Commons</a></td> </tr> <tr class="note"> <th><a href="http://en.wikipedia.org/wiki/Ceremonial_counties_of_England" title="Ceremonial counties of England">County</a>:</th> <td><a href="http://en.wikipedia.org/wiki/Bristol" title="Bristol">Bristol</a></td> </tr> <tr class="note"> <th><a href="http://en.wikipedia.org/wiki/European_Parliament" title="European Parliament">EP constituency</a>:</th> <td><a href="http://en.wikipedia.org/wiki/South_West_England_(European_Parliament_constituency)" title="South West England (European Parliament constituency)">South West England</a></td> </tr> </table></div>
            <div id="_Bristol North West" class="rhsp"><table class="infobox geography vcard" style="width:300px;"> <tr> <th colspan="2" style="background-color:#efefef; text-align:center;"><big class="fn org"><b>Bristol North West</b></big><br /> <a href="http://en.wikipedia.org/wiki/Borough_constituency" title="Borough constituency" class="mw-redirect">Borough constituency</a></th> </tr> <tr> <td colspan="2" style="text-align:center;"><a href="http://en.wikipedia.org/wiki/Image:BristolNorthWestConstituency.svg" class="image" title="BristolNorthWestConstituency.svg"><img alt="" src="http://upload.wikimedia.org/wikipedia/commons/thumb/8/8a/BristolNorthWestConstituency.svg/120px-BristolNorthWestConstituency.svg.png" width="120" height="104" border="0" /></a><br /> <a href="http://en.wikipedia.org/wiki/Image:EnglandAvon.svg" class="image" title="EnglandAvon.svg"><img alt="" src="http://upload.wikimedia.org/wikipedia/commons/thumb/b/b7/EnglandAvon.svg/120px-EnglandAvon.svg.png" width="120" height="148" border="0" /></a></td> </tr> <tr> <td colspan="2" style="background-color:#efefef; text-align:center; font-weight:bold;">Bristol North West shown within <a href="http://en.wikipedia.org/wiki/Greater_Bristol" title="Greater Bristol">Greater Bristol</a>, and Greater Bristol shown within <a href="http://en.wikipedia.org/wiki/England" title="England">England</a></td> </tr> <tr class="note"> <th>Created:</th> <td>1950</td> </tr> <tr class="note"> <th><a href="http://en.wikipedia.org/wiki/Member_of_Parliament" title="Member of Parliament">MP</a>:</th> <td><a href="http://en.wikipedia.org/wiki/Doug_Naysmith" title="Doug Naysmith">Doug Naysmith</a></td> </tr> <tr class="note"> <th><a href="http://en.wikipedia.org/wiki/List_of_political_parties_in_the_United_Kingdom" title="List of political parties in the United Kingdom">Party</a>:</th> <td><a href="http://en.wikipedia.org/wiki/Labour_Co-operative" title="Labour Co-operative">Labour Co-operative</a></td> </tr> <tr class="note"> <th><a href="http://en.wikipedia.org/wiki/United_Kingdom_constituencies" title="United Kingdom constituencies">Type</a>:</th> <td><a href="http://en.wikipedia.org/wiki/House_of_Commons_of_the_United_Kingdom" title="House of Commons of the United Kingdom">House of Commons</a></td> </tr> <tr class="note"> <th><a href="http://en.wikipedia.org/wiki/Ceremonial_counties_of_England" title="Ceremonial counties of England">County</a>:</th> <td><a href="http://en.wikipedia.org/wiki/Bristol" title="Bristol">Bristol</a></td> </tr> <tr class="note"> <th><a href="http://en.wikipedia.org/wiki/European_Parliament" title="European Parliament">EP constituency</a>:</th> <td><a href="http://en.wikipedia.org/wiki/South_West_England_(European_Parliament_constituency)" title="South West England (European Parliament constituency)">South West England</a></td> </tr> </table></div>
            <div id="_Bristol South" class="rhsp"><table class="infobox geography vcard" style="width:300px;"> <tr> <th colspan="2" style="background-color:#efefef; text-align:center;"><big class="fn org"><b>Bristol South</b></big><br /> <a href="http://en.wikipedia.org/wiki/Borough_constituency" title="Borough constituency" class="mw-redirect">Borough constituency</a></th> </tr> <tr> <td colspan="2" style="text-align:center;"><a href="http://en.wikipedia.org/wiki/Image:BristolSouthConstituency.svg" class="image" title="BristolSouthConstituency.svg"><img alt="" src="http://upload.wikimedia.org/wikipedia/commons/thumb/c/ce/BristolSouthConstituency.svg/120px-BristolSouthConstituency.svg.png" width="120" height="104" border="0" /></a><br /> <a href="http://en.wikipedia.org/wiki/Image:EnglandAvon.svg" class="image" title="EnglandAvon.svg"><img alt="" src="http://upload.wikimedia.org/wikipedia/commons/thumb/b/b7/EnglandAvon.svg/120px-EnglandAvon.svg.png" width="120" height="148" border="0" /></a></td> </tr> <tr> <td colspan="2" style="background-color:#efefef; text-align:center; font-weight:bold;">Bristol South shown within <a href="http://en.wikipedia.org/wiki/Avon_(county)" title="Avon (county)">Avon (county)</a>, and Avon (county) shown within <a href="http://en.wikipedia.org/wiki/England" title="England">England</a></td> </tr> <tr class="note"> <th>Created:</th> <td>1885</td> </tr> <tr class="note"> <th><a href="http://en.wikipedia.org/wiki/Member_of_Parliament" title="Member of Parliament">MP</a>:</th> <td><a href="http://en.wikipedia.org/wiki/Dawn_Primarolo" title="Dawn Primarolo">Dawn Primarolo</a></td> </tr> <tr class="note"> <th><a href="http://en.wikipedia.org/wiki/List_of_political_parties_in_the_United_Kingdom" title="List of political parties in the United Kingdom">Party</a>:</th> <td><a href="http://en.wikipedia.org/wiki/Labour_Party_(UK)" title="Labour Party (UK)">Labour</a></td> </tr> <tr class="note"> <th><a href="http://en.wikipedia.org/wiki/United_Kingdom_constituencies" title="United Kingdom constituencies">Type</a>:</th> <td><a href="http://en.wikipedia.org/wiki/House_of_Commons_of_the_United_Kingdom" title="House of Commons of the United Kingdom">House of Commons</a></td> </tr> <tr class="note"> <th><a href="http://en.wikipedia.org/wiki/Ceremonial_counties_of_England" title="Ceremonial counties of England">County</a>:</th> <td><a href="http://en.wikipedia.org/wiki/Bristol" title="Bristol">Bristol</a></td> </tr> <tr class="note"> <th><a href="http://en.wikipedia.org/wiki/European_Parliament" title="European Parliament">EP constituency</a>:</th> <td><a href="http://en.wikipedia.org/wiki/South_West_England_(European_Parliament_constituency)" title="South West England (European Parliament constituency)">South West England</a></td> </tr> </table></div>
            <div id="_Kingswood" class="rhsp"><table class="infobox geography vcard" style="width:300px;"> <tr> <th colspan="2" style="background-color:#efefef; text-align:center;"><big class="fn org"><b>Kingswood</b></big><br /> <a href="http://en.wikipedia.org/wiki/Borough_constituency" title="Borough constituency" class="mw-redirect">Borough constituency</a></th> </tr> <tr> <td colspan="2" style="text-align:center;"><a href="http://en.wikipedia.org/wiki/Image:KingswoodConstituency.svg" class="image" title="KingswoodConstituency.svg"><img alt="" src="http://upload.wikimedia.org/wikipedia/commons/thumb/d/d1/KingswoodConstituency.svg/120px-KingswoodConstituency.svg.png" width="120" height="104" border="0" /></a><br /> <a href="http://en.wikipedia.org/wiki/Image:EnglandAvon.svg" class="image" title="EnglandAvon.svg"><img alt="" src="http://upload.wikimedia.org/wikipedia/commons/thumb/b/b7/EnglandAvon.svg/120px-EnglandAvon.svg.png" width="120" height="148" border="0" /></a></td> </tr> <tr> <td colspan="2" style="background-color:#efefef; text-align:center; font-weight:bold;">Kingswood shown within <a href="http://en.wikipedia.org/wiki/Avon_(county)" title="Avon (county)">Avon (county)</a>, and Avon (county) shown within <a href="http://en.wikipedia.org/wiki/England" title="England">England</a></td> </tr> <tr class="note"> <th>Created:</th> <td><a href="http://en.wikipedia.org/wiki/1974" title="1974">1974</a></td> </tr> <tr class="note"> <th><a href="http://en.wikipedia.org/wiki/Member_of_Parliament" title="Member of Parliament">MP</a>:</th> <td><a href="http://en.wikipedia.org/wiki/Roger_Berry" title="Roger Berry">Roger Berry</a></td> </tr> <tr class="note"> <th><a href="http://en.wikipedia.org/wiki/List_of_political_parties_in_the_United_Kingdom" title="List of political parties in the United Kingdom">Party</a>:</th> <td><a href="http://en.wikipedia.org/wiki/Labour_Party_(UK)" title="Labour Party (UK)">Labour</a></td> </tr> <tr class="note"> <th><a href="http://en.wikipedia.org/wiki/United_Kingdom_constituencies" title="United Kingdom constituencies">Type</a>:</th> <td><a href="http://en.wikipedia.org/wiki/House_of_Commons_of_the_United_Kingdom" title="House of Commons of the United Kingdom">House of Commons</a></td> </tr> <tr class="note"> <th><a href="http://en.wikipedia.org/wiki/Ceremonial_counties_of_England" title="Ceremonial counties of England">County</a>:</th> <td><a href="http://en.wikipedia.org/wiki/Gloucestershire" title="Gloucestershire">Gloucestershire</a></td> </tr> <tr class="note"> <th><a href="http://en.wikipedia.org/wiki/European_Parliament" title="European Parliament">EP constituency</a>:</th> <td><a href="http://en.wikipedia.org/wiki/South_West_England_(European_Parliament_constituency)" title="South West England (European Parliament constituency)">South West England</a></td> </tr> </table></div>
            <div id="_Wansdyke" class="rhsp"><table class="infobox geography vcard" style="width:300px;"> <tr> <th colspan="2" style="background-color:#efefef; text-align:center;"><big class="fn org"><b>Wansdyke</b></big><br /> <a href="http://en.wikipedia.org/wiki/County_constituency" title="County constituency" class="mw-redirect">County constituency</a></th> </tr> <tr> <td colspan="2" style="text-align:center;"><a href="http://en.wikipedia.org/wiki/Image:WansdykeConstituency.svg" class="image" title="WansdykeConstituency.svg"><img alt="" src="http://upload.wikimedia.org/wikipedia/commons/thumb/e/e5/WansdykeConstituency.svg/120px-WansdykeConstituency.svg.png" width="120" height="104" border="0" /></a><br /> <a href="http://en.wikipedia.org/wiki/Image:EnglandAvon.svg" class="image" title="EnglandAvon.svg"><img alt="" src="http://upload.wikimedia.org/wikipedia/commons/thumb/b/b7/EnglandAvon.svg/120px-EnglandAvon.svg.png" width="120" height="148" border="0" /></a></td> </tr> <tr> <td colspan="2" style="background-color:#efefef; text-align:center; font-weight:bold;">Wansdyke shown within <a href="http://en.wikipedia.org/wiki/Avon_(county)" title="Avon (county)">Avon (county)</a>, and Avon (county) shown within <a href="http://en.wikipedia.org/wiki/England" title="England">England</a></td> </tr> <tr class="note"> <th>Created:</th> <td><a href="http://en.wikipedia.org/wiki/1983" title="1983">1983</a></td> </tr> <tr class="note"> <th><a href="http://en.wikipedia.org/wiki/Member_of_Parliament" title="Member of Parliament">MP</a>:</th> <td><a href="http://en.wikipedia.org/wiki/Dan_Norris" title="Dan Norris">Dan Norris</a></td> </tr> <tr class="note"> <th><a href="http://en.wikipedia.org/wiki/List_of_political_parties_in_the_United_Kingdom" title="List of political parties in the United Kingdom">Party</a>:</th> <td><a href="http://en.wikipedia.org/wiki/Labour_Party_(UK)" title="Labour Party (UK)">Labour</a></td> </tr> <tr class="note"> <th><a href="http://en.wikipedia.org/wiki/United_Kingdom_constituencies" title="United Kingdom constituencies">Type</a>:</th> <td><a href="http://en.wikipedia.org/wiki/House_of_Commons_of_the_United_Kingdom" title="House of Commons of the United Kingdom">House of Commons</a></td> </tr> <tr class="note"> <th><a href="http://en.wikipedia.org/wiki/Ceremonial_counties_of_England" title="Ceremonial counties of England">County</a>:</th> <td><a href="http://en.wikipedia.org/wiki/Somerset" title="Somerset">Somerset</a></td> </tr> <tr class="note"> <th><a href="http://en.wikipedia.org/wiki/European_Parliament" title="European Parliament">EP constituency</a>:</th> <td><a href="http://en.wikipedia.org/wiki/South_West_England_(European_Parliament_constituency)" title="South West England (European Parliament constituency)">South West England</a></td> </tr> </table></div>
            <div id="_Weston-Super-Mare" class="rhsp"><table class="infobox geography vcard" style="width:300px;"> <tr> <th colspan="2" style="background-color:#efefef; text-align:center;"><big class="fn org"><b>Weston-super-Mare</b></big><br /> <a href="http://en.wikipedia.org/wiki/County_constituency" title="County constituency" class="mw-redirect">County constituency</a></th> </tr> <tr> <td colspan="2" style="text-align:center;"><a href="http://en.wikipedia.org/wiki/Image:WestonSuperMareConstituency.svg" class="image" title="WestonSuperMareConstituency.svg"><img alt="" src="http://upload.wikimedia.org/wikipedia/commons/thumb/4/46/WestonSuperMareConstituency.svg/120px-WestonSuperMareConstituency.svg.png" width="120" height="104" border="0" /></a><br /> <a href="http://en.wikipedia.org/wiki/Image:EnglandAvon.svg" class="image" title="EnglandAvon.svg"><img alt="" src="http://upload.wikimedia.org/wikipedia/commons/thumb/b/b7/EnglandAvon.svg/120px-EnglandAvon.svg.png" width="120" height="148" border="0" /></a></td> </tr> <tr> <td colspan="2" style="background-color:#efefef; text-align:center; font-weight:bold;">Weston-super-Mare shown within <a href="http://en.wikipedia.org/wiki/Avon_(county)" title="Avon (county)">Avon (county)</a>, and Avon (county) shown within <a href="http://en.wikipedia.org/wiki/England" title="England">England</a></td> </tr> <tr class="note"> <th>Created:</th> <td>1918</td> </tr> <tr class="note"> <th><a href="http://en.wikipedia.org/wiki/Member_of_Parliament" title="Member of Parliament">MP</a>:</th> <td><a href="http://en.wikipedia.org/wiki/John_Penrose" title="John Penrose">John Penrose</a></td> </tr> <tr class="note"> <th><a href="http://en.wikipedia.org/wiki/List_of_political_parties_in_the_United_Kingdom" title="List of political parties in the United Kingdom">Party</a>:</th> <td><a href="http://en.wikipedia.org/wiki/Conservative_Party_(UK)" title="Conservative Party (UK)">Conservative</a></td> </tr> <tr class="note"> <th><a href="http://en.wikipedia.org/wiki/United_Kingdom_constituencies" title="United Kingdom constituencies">Type</a>:</th> <td><a href="http://en.wikipedia.org/wiki/House_of_Commons_of_the_United_Kingdom" title="House of Commons of the United Kingdom">House of Commons</a></td> </tr> <tr class="note"> <th><a href="http://en.wikipedia.org/wiki/Ceremonial_counties_of_England" title="Ceremonial counties of England">County</a>:</th> <td><a href="http://en.wikipedia.org/wiki/Somerset" title="Somerset">Somerset</a></td> </tr> <tr class="note"> <th><a href="http://en.wikipedia.org/wiki/European_Parliament" title="European Parliament">EP constituency</a>:</th> <td><a href="http://en.wikipedia.org/wiki/South_West_England_(European_Parliament_constituency)" title="South West England (European Parliament constituency)">South West England</a></td> </tr> </table></div>
            <div id="_Woodspring" class="rhsp"><table class="infobox geography vcard" style="width:300px;"> <tr> <th colspan="2" style="background-color:#efefef; text-align:center;"><big class="fn org"><b>Woodspring</b></big><br /> <a href="http://en.wikipedia.org/wiki/County_constituency" title="County constituency" class="mw-redirect">County constituency</a></th> </tr> <tr> <td colspan="2" style="text-align:center;"><a href="http://en.wikipedia.org/wiki/Image:WoodspringConstituency.svg" class="image" title="WoodspringConstituency.svg"><img alt="" src="http://upload.wikimedia.org/wikipedia/commons/thumb/a/a4/WoodspringConstituency.svg/120px-WoodspringConstituency.svg.png" width="120" height="104" border="0" /></a><br /> <a href="http://en.wikipedia.org/wiki/Image:EnglandAvon.svg" class="image" title="EnglandAvon.svg"><img alt="" src="http://upload.wikimedia.org/wikipedia/commons/thumb/b/b7/EnglandAvon.svg/120px-EnglandAvon.svg.png" width="120" height="148" border="0" /></a></td> </tr> <tr> <td colspan="2" style="background-color:#efefef; text-align:center; font-weight:bold;">Woodspring shown within <a href="http://en.wikipedia.org/wiki/Avon" title="Avon">Avon</a>, and Avon shown within <a href="http://en.wikipedia.org/wiki/England" title="England">England</a></td> </tr> <tr class="note"> <th>Created:</th> <td>1983</td> </tr> <tr class="note"> <th><a href="http://en.wikipedia.org/wiki/Member_of_Parliament" title="Member of Parliament">MP</a>:</th> <td><a href="http://en.wikipedia.org/wiki/Liam_Fox" title="Liam Fox">Liam Fox</a></td> </tr> <tr class="note"> <th><a href="http://en.wikipedia.org/wiki/List_of_political_parties_in_the_United_Kingdom" title="List of political parties in the United Kingdom">Party</a>:</th> <td><a href="http://en.wikipedia.org/wiki/Conservative_Party_(UK)" title="Conservative Party (UK)">Conservative</a></td> </tr> <tr class="note"> <th><a href="http://en.wikipedia.org/wiki/United_Kingdom_constituencies" title="United Kingdom constituencies">Type</a>:</th> <td><a href="http://en.wikipedia.org/wiki/House_of_Commons_of_the_United_Kingdom" title="House of Commons of the United Kingdom">House of Commons</a></td> </tr> <tr class="note"> <th><a href="http://en.wikipedia.org/wiki/Ceremonial_counties_of_England" title="Ceremonial counties of England">County</a>:</th> <td><a href="http://en.wikipedia.org/wiki/Somerset" title="Somerset">Somerset</a></td> </tr> <tr class="note"> <th><a href="http://en.wikipedia.org/wiki/European_Parliament" title="European Parliament">EP constituency</a>:</th> <td><a href="http://en.wikipedia.org/wiki/South_West_England_(European_Parliament_constituency)" title="South West England (European Parliament constituency)">South West England</a></td> </tr> </table></div>
        </div>
        <div id="svgbox">
${c.svg|n}
        </div>
    </div>
    <div id="tl" class="timeline-default timeline-container"></div>
    <div id="flashTransport">foobar</div>
    
</body>
</html>
