#!/usr/bin/env python
# coding=utf-8
"""
The raw SimpleDB interface
"""


class SimpleDB(object):
    def __init__(self, **kwargs):
        """
        Create a new SimpleDB object and setup the permissions as needed
        """
        self.authorization = {}

    def __del__(self):
        """
        Manage any specific requirements to disconnect from the database here
        """
        raise NotImplementedError

    def auth(self, **kwargs):
        """
        Handle any specific authorizations here
        """
        raise NotImplementedError

###############################################################################

    def query_dict(self, *args, **kwargs):
        """
        Query and return a dict generator
        """
        raise NotImplementedError
    
    def query_dicts(self, *args, **kwargs):
        return self.query_dict(*args, **kwargs)

    def query_dict_row(self, *args, **kwargs):
        """
        Query and return a single row as a dict
        """
        raise NotImplementedError

###############################################################################

    def query_tuple(self, *args, **kwargs):
        """
        Query and return a tuples generator
        """
        raise NotImplementedError
    
    def query_tuples(self, *args, **kwargs):
        return self.query_tuple(*args, **kwargs)

    def query_tuple_row(self, *args, **kwargs):
        """
        Query and return a single tuple row
        """
        raise NotImplementedError

###############################################################################

    def query_list(self, *args, **kwargs):
        """
        Query and return a list generator
        """
        raise NotImplementedError
    
    def query_lists(self, *args, **kwargs):
        return self.query_list(*args, **kwargs)

    def query_list_row(self, *args, **kwargs):
        """
        Query and return a single list row
        """
        raise NotImplementedError

###############################################################################

    def query_fields(self, *args, **kwargs):
        """
        Query and return a field generator
        """
        raise NotImplementedError

    def query_field(self, *args, **kwargs):
        """
        Query and return a single field
        """
        raise NotImplementedError
