# -*- coding: utf-8 -*-
from ._compat import to_unicode, iteritems
try:
    from markupsafe import Markup
except ImportError:
    try:
        from jinja2 import Markup
    except ImportError:
        Markup = to_unicode
import re
from xml.sax.saxutils import quoteattr


class FakeMultiDict(dict):
    """Adds a fake `getlist` method to a regular dict; or acts as a proxy to
    Webob's MultiDict `getall` method.
    """
    def __getattr__(self, attr):
        try:
            return self[attr]
        except KeyError as error:
            raise AttributeError(error)

    def getlist(self, name):
        if hasattr(self, 'getall'):
            return self.getall(name)
        value = self.get(name)
        if value is None:
            return []
        return [value]


def get_html_attrs(kwargs=None):
    """Generate HTML attributes from the provided keyword arguments.

    The output value is sorted by the passed keys, to provide consistent
    output.  Because of the frequent use of the normally reserved keyword
    `class`, `classes` is used instead. Also, all underscores are translated
    to regular dashes.

    Set any property with a `True` value.

    >>> _get_html_attrs({'id': 'text1', 'classes': 'myclass',
        'data_id': 1, 'checked': True})
    u'class="myclass" data-id="1" id="text1" checked'

    """
    kwargs = kwargs or {}
    attrs = []
    props = []

    classes = kwargs.get('classes', '').strip()
    if classes:
        classes = ' '.join(re.split(r'\s+', classes))
        classes = to_unicode(quoteattr(classes))
        attrs.append('class=%s' % classes)
    try:
        del kwargs['classes']
    except KeyError:
        pass

    for key, value in iteritems(kwargs):
        key = key.replace('_', '-')
        key = to_unicode(key)
        if isinstance(value, bool):
            if value is True:
                props.append(key)
        else:
            value = quoteattr(to_unicode(value))
            attrs.append(u'%s=%s' % (key, value))

    attrs.sort()
    props.sort()
    attrs.extend(props)
    return u' '.join(attrs)

